/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.SerializationUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;

public class EvaluateCrossSubmitDynamicPlugin
extends AbstractFormPlugin {
    public static final String NOT_REFRESH_FROM_SUBMIT = "NOT_REFRESH_FROM_SUBMIT";
    private static final Log LOG = LogFactory.getLog(EvaluateCrossSubmitDynamicPlugin.class);
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    public static final String BTNOK = "btnok";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnok": {
                this.submitTask();
                break;
            }
        }
    }

    public void submitTask() {
        boolean indicatorChangeOfCross;
        List mergeTaskIds;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskId = (String)formShowParameter.getCustomParam("taskId");
        String taskIndCountMapStr = (String)formShowParameter.getCustomParam("taskIndCountMapStr");
        String mergeTaskIdsStr = (String)formShowParameter.getCustomParam("mergeTaskIdsStr");
        ArrayList<Long> crossTaskIdList = new ArrayList<Long>(10);
        crossTaskIdList.add(Long.parseLong(taskId));
        if (!HRStringUtils.isBlank((CharSequence)mergeTaskIdsStr) && (mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class)) != null) {
            crossTaskIdList.addAll(mergeTaskIds);
        }
        if (indicatorChangeOfCross = ObjEvaluationUtils.isIndicatorChangeOfCross(taskIndCountMapStr, crossTaskIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6307\u6807\u6570\u636e\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"EvaluateCrossSubmitDynamicPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean submitSuccess = true;
        List<Long> mergeSubmitSuccessIds = new ArrayList<Long>(10);
        try {
            long c1 = System.currentTimeMillis();
            String mergeTaskId = (String)formShowParameter.getCustomParam("mergeTaskIdsStr");
            if (HRStringUtils.isNotEmpty((String)mergeTaskId)) {
                List mergeTaskIds2 = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
                Map submitedMap = APP_SERVICE.submitEvalTask(taskId, mergeTaskIds2);
                if (submitedMap != null) {
                    Boolean submitRes = submitedMap.get("submitSuccess") == null ? Boolean.FALSE : (Boolean)submitedMap.get("submitSuccess");
                    submitSuccess = submitRes;
                    mergeSubmitSuccessIds = (List)submitedMap.get("successTaskIds");
                }
            } else {
                submitSuccess = APP_SERVICE.submitEvalTask(taskId);
            }
            if (submitSuccess) {
                this.syncIndicatorDataInfo(formShowParameter);
            } else {
                String tips = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"EvaluateCrossSubmitDynamicPlugin_1", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
            }
            long c2 = System.currentTimeMillis();
            long cc = c2 - c1;
            StringBuilder s1 = new StringBuilder();
            s1.append("EvaluateSubmitTipsDynamicPlugin submitEvalTask use time:").append(cc).append("ms");
            LOG.error(s1.toString());
        }
        catch (KDBizException bizException) {
            String message = bizException.getMessage();
            this.getView().showTipNotification(message);
            submitSuccess = false;
        }
        catch (Exception e) {
            submitSuccess = false;
            LOG.error("evasubmit task error\uff1a", (Throwable)e);
            String tips = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"EvaluateCrossSubmitDynamicPlugin_1", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
        }
        if (submitSuccess) {
            String parentViewEntityId;
            this.updateCanEditWhenSuccess(taskId, mergeSubmitSuccessIds);
            long ss1 = System.currentTimeMillis();
            boolean release = MutexHelper.release((String)"epa_actevalobj_eval", (String)"nodeview", (String)taskId);
            LOG.info("acteval mutex release taskid:{},release:{}", (Object)taskId, (Object)release);
            if (crossTaskIdList != null) {
                for (Long mergerTaskId : crossTaskIdList) {
                    if (mergerTaskId == null) continue;
                    boolean release1 = MutexHelper.release((String)"epa_actevalobj_eval", (String)"nodeview", (String)mergerTaskId.toString());
                    LOG.info("acteval mutex release taskid:{},release:{}", (Object)mergerTaskId.toString(), (Object)release1);
                }
            }
            this.getView().getParentView().setStatus(OperationStatus.VIEW);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            this.getView().getParentView().invokeOperation("refresh", option);
            this.getView().sendFormAction(this.getView().getParentView());
            long ss2 = System.currentTimeMillis();
            long sss = ss2 - ss1;
            StringBuilder sssx = new StringBuilder();
            sssx.append("EvaluateSubmitTipsDynamicPlugin REFRESH use time:").append(sss).append("ms");
            LOG.error(sssx.toString());
            long xx1 = System.currentTimeMillis();
            if (this.getView().getParentView().getParentView() != null && "epa_actevalobj_eval_multi".equals(parentViewEntityId = this.getView().getParentView().getParentView().getEntityId())) {
                this.getView().getParentView().getParentView().getPageCache().put("isEmptyPage", "true");
                OperateOption option1 = OperateOption.create();
                option1.setVariableValue("ishasright", "true");
                this.getView().getParentView().getParentView().invokeOperation("refresh", option1);
                this.getView().getParentView().getParentView().getPageCache().put("isEmptyPage", "false");
                this.getView().sendFormAction(this.getView().getParentView().getParentView());
                long xx2 = System.currentTimeMillis();
                StringBuilder sssxx = new StringBuilder();
                sssxx.append("EvaluateSubmitTipsDynamicPlugin REFRESH2 use time:").append(xx2 - xx1).append("ms");
                LOG.error(sssxx.toString());
            }
            this.getView().close();
        }
    }

    private void updateCanEditWhenSuccess(String taskId, List<Long> mergeSubmitSuccessIds) {
        ArrayList<Long> taskIds = new ArrayList<Long>(10);
        if (!HRStringUtils.isBlank((CharSequence)taskId)) {
            taskIds.add(Long.parseLong(taskId));
        }
        if (mergeSubmitSuccessIds != null) {
            taskIds.addAll(mergeSubmitSuccessIds);
        }
        this.updateIsCanEdit(taskIds);
    }

    private List<Long> getMergeTaskIdList(String mergeTaskId) {
        ArrayList<Long> mergeTaskIds = new ArrayList<Long>(10);
        for (String taskIdStr : mergeTaskId.split(",")) {
            mergeTaskIds.add(Long.valueOf(taskIdStr));
        }
        return mergeTaskIds;
    }

    private void updateIsCanEdit(List<Long> taskIds) {
        if (taskIds != null && !taskIds.isEmpty()) {
            APP_SERVICE.updateGenIndRecordCanEditByTask(taskIds, false);
            APP_SERVICE.updateAddSubIndRecordCanEditByTask(taskIds, false);
        }
    }

    private void syncIndicatorDataInfo(FormShowParameter formShowParameter) {
        List subEvalRecordPageList;
        String subEvalRecordPageListStr = (String)formShowParameter.getCustomParam("subEvalRecordPageList");
        if (!HRStringUtils.isBlank((CharSequence)subEvalRecordPageListStr) && (subEvalRecordPageList = (List)SerializationUtils.fromJsonString((String)subEvalRecordPageListStr, List.class)) != null) {
            for (String subEvalRecordPage : subEvalRecordPageList) {
                IFormView subAreaPage = this.getView().getView(subEvalRecordPage);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                subAreaPage.invokeOperation("syncindicator", option);
            }
        }
    }
}

