/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.process.ProcessExecuteApplicationService;
import kd.opmc.epa.business.application.service.evaladjustment.ActEvalObjAdjApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.evaluat.ResSyncStatusEnum;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.utils.ActManageUtils;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.common.utils.OpmcDateUtils;

public class EvaluateEvaluatedList
extends EvalObjBaseList {
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final ProcessExecuteApplicationService PROCESS_EXECUTE_APPLICATION_SERVICE = ProcessExecuteApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY = ExecuteSchemeEntityService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final ObjsetScoreRecordDomainService OBJSET_SCORERECORD_ENTITY_SERVICE = ObjsetScoreRecordDomainService.getInstance();
    private static final ActEvalObjAdjApplicationService ACT_EVAL_OBJ_ADJ_APPLICATION_SERVICE = ActEvalObjAdjApplicationService.getInstance();
    private Map<Long, String> OBJ_FLOWINFO_MAP = new HashMap<Long, String>(16);
    private Map<Long, List<DynamicObject>> ACT_RECORD_MAP = new HashMap<Long, List<DynamicObject>>(16);
    private static final String EPA_NOTPARTICIPATEEVAL = "epa_notparticipateeval";
    private static final String UPT_EVAL_RESULT_CLOSE_BACK_BYMODEL = "uptEvalResultCloseBackByModel";
    private static final String INPUT_EVAL_RESULT_CLOSE_BACK_BYMODEL = "inputEvalResultCloseBackByModel";

    public void setFilter(SetFilterEvent filterEvent) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Tuple booleanBooleanTuple = PROCESS_EXECUTE_APPLICATION_SERVICE.queryIsLastNodeNActEnd(activityId, AssessNodeStatusEnum.EVALUATED);
        if (((Boolean)booleanBooleanTuple.item1).booleanValue()) {
            this.getView().getPageCache().put("lastNodeFlag", "1");
        }
        List objIds = ACT_EVAL_OBJ_ADJ_APPLICATION_SERVICE.queryEvaluatedObjIdByActivityId(activityId);
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        filterEvent.getQFilters().add(filter);
        filterEvent.setOrderBy("modifytime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("donothing_inputevalresult".equals(operateKey)) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            String activityStatus = activityDynObj.getString("activitystatus");
            if (!ActivityStatusEnum.EXECUTING.getValue().equals(activityStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u72b6\u6001\u4e0d\u4e3a\u201c\u6267\u884c\u4e2d\u201d\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528\u3002", (String)"EvaluateEvaluatedList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("resetevaled".equals(operateKey)) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
            op.getOption().setVariableValue("activity", activityId.toString());
            op.getOption().setVariableValue("nodeindex", String.valueOf(nodeIndex));
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "refresh": {
                ActManageUtils.refreshEvaluateCount(this.getView());
                break;
            }
            case "donothing_updateevalresult": {
                this.showUptEvalResultPage();
                break;
            }
            case "donothing_inputevalresult": {
                this.showInputEvalResultPage();
                break;
            }
            case "donothing_modifyevalresult": {
                this.showModifyEvalResultPage();
                break;
            }
            case "resetevaled": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void showModifyEvalResultPage() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        FormShowParameter showParameter = new FormShowParameter();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List evalObjectIdList = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList());
        showParameter.setFormId("epa_modifyeval");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("activity", (Object)activityId);
        showParameter.setCustomParam("evalObjectIds", evalObjectIdList);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifyEvalResultCloseBackByModel"));
        this.getView().showForm(showParameter);
    }

    private void showInputEvalResultPage() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_enterevalresult");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("activity", (Object)activityId);
        showParameter.setCustomParam("nodeindex", (Object)nodeIndex);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, INPUT_EVAL_RESULT_CLOSE_BACK_BYMODEL));
        this.getView().showForm(showParameter);
    }

    private void showUptEvalResultPage() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        FormShowParameter showParameter = new FormShowParameter();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List evalObjectIdList = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList());
        showParameter.setFormId("epa_modifyeval");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("activity", (Object)activityId);
        showParameter.setCustomParam("evalObjectIds", evalObjectIdList);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifyEvalResultCloseBackByModel"));
        this.getView().showForm(showParameter);
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        super.beforePackageData(dataEvent);
        DynamicObjectCollection pageData = dataEvent.getPageData();
        boolean selectedAllRows = ((ListModel)dataEvent.getSource()).isSelectedAllRows();
        if (!pageData.isEmpty() && !selectedAllRows) {
            List actObjIds = pageData.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList());
            this.ACT_RECORD_MAP = EVALUATION_OBJECT_APPLICATION_SERVICE.queryActRecordByActObjIds(actObjIds);
            this.OBJ_FLOWINFO_MAP = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getObjFlowInfo(actObjIds);
        }
    }

    public void packageData(PackageDataEvent evt) {
        Object source = evt.getSource();
        if (source instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc columnDesc = (DynamicTextColumnDesc)source;
            switch (columnDesc.getKey()) {
                case "assessendtime": {
                    this.setActRecordFormatValue("endtime", evt);
                    break;
                }
                case "assessstarttime": {
                    this.setActRecordFormatValue("createtime", evt);
                    break;
                }
                case "ruflowinfo": {
                    this.setRuFlowInfoValue(evt);
                    break;
                }
            }
        }
    }

    private void setActRecordFormatValue(String key, PackageDataEvent dataEvent) {
        DynamicObject actEvalObj = dataEvent.getRowData();
        List<DynamicObject> actRecords = this.ACT_RECORD_MAP.get(actEvalObj.getLong("id"));
        if (CollectionUtils.isEmpty(actRecords)) {
            return;
        }
        actRecords.stream().filter(actRecord -> actRecord.getLong("assessnode") == AssessNodeStatusEnum.EVALUATING.getNodeId().longValue()).filter(actRecord -> HRStringUtils.equals((String)actRecord.getString("nodestatus"), (String)AssessNodeStatusEnum.EVALUATED.getStatus())).findFirst().ifPresent(record -> dataEvent.setFormatValue((Object)OpmcDateUtils.formatTimeUser((Date)record.getDate(key))));
    }

    private void setRuFlowInfoValue(PackageDataEvent dataEvent) {
        String ruFlowInfo;
        Long objId;
        DynamicObject actEvalObj = dataEvent.getRowData();
        if (actEvalObj != null && (objId = Long.valueOf(actEvalObj.getLong("id"))) != null && objId != 0L && !HRStringUtils.isEmpty((String)(ruFlowInfo = this.OBJ_FLOWINFO_MAP.get(objId)))) {
            dataEvent.setFormatValue((Object)ruFlowInfo);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject atcivityDy = ACTIVITY_ENTITY_SERVICE.queryAssessFormByActivity(activityId);
        Long assessFormId = atcivityDy.getLong("assessform_id");
        DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(assessFormId);
        DynamicObject sumperflevel = assessForm.getDynamicObject("sumperflevel");
        final String numAccuracy = assessForm.getString("numaccuracy");
        final String scaleType = assessForm.getString("scaletype");
        if (sumperflevel != null) {
            Long sumPerfLevelId = (Long)sumperflevel.getPkValue();
            DynamicObject sumPerfLevel = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryPerfLevelById(sumPerfLevelId);
            DynamicObjectCollection levelEntry = sumPerfLevel.getDynamicObjectCollection("entryentity");
            final HashMap<String, String> levelMap = new HashMap<String, String>(16);
            for (DynamicObject dy : levelEntry) {
                int seq = dy.getInt("seq");
                levelMap.put(String.valueOf(seq), dy.getString("levelname"));
            }
            args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                public DynamicObjectCollection getData(int start, int limit) {
                    DynamicObjectCollection rows = super.getData(start, limit);
                    if (rows.isEmpty()) {
                        return rows;
                    }
                    for (DynamicObject row : rows) {
                        String lop = row.getString("lop");
                        row.set("lop", levelMap.get(lop));
                        BigDecimal sop = row.getBigDecimal("sop");
                        sop = sop.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get((String)scaleType).getType());
                        row.set("sop", (Object)sop);
                    }
                    return rows;
                }
            });
        } else {
            args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                public DynamicObjectCollection getData(int start, int limit) {
                    DynamicObjectCollection rows = super.getData(start, limit);
                    if (rows.isEmpty()) {
                        return rows;
                    }
                    for (DynamicObject row : rows) {
                        BigDecimal sop = row.getBigDecimal("sop");
                        sop = sop.setScale(Integer.parseInt(numAccuracy), ScalaTypeEnum.get((String)scaleType).getType());
                        row.set("sop", (Object)sop);
                    }
                    return rows;
                }
            });
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"modifyEvalResultCloseBackByModel")) {
            this.getView().invokeOperation("refresh");
            ActManageUtils.refreshEvaluateCount(this.getView());
            return;
        }
        Object returnData = closedCallBackEvent.getReturnData();
        Map<String, Object> returnMap = this.getReturnMap(returnData);
        if (returnMap == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)UPT_EVAL_RESULT_CLOSE_BACK_BYMODEL)) {
            this.uptEvalResultBack(returnMap);
            return;
        }
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)INPUT_EVAL_RESULT_CLOSE_BACK_BYMODEL)) {
            return;
        }
    }

    private void uptEvalResultBack(Map<String, Object> returnMap) {
        Object[] evaluationObjects = this.getEvalObjsWithScore();
        if (ObjectUtils.isEmpty((Object[])evaluationObjects)) {
            return;
        }
        ArrayList<String> failMessage = new ArrayList<String>(16);
        int notSuitCount = this.dealPartEvalBackResultData((DynamicObject[])evaluationObjects, returnMap, failMessage);
        if (notSuitCount == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"EvaluateEvaluatedList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"EvaluateEvaluatedList_2", (String)"opmc-epa-business", (Object[])new Object[0]), evaluationObjects.length, evaluationObjects.length - notSuitCount, notSuitCount);
            Tuple message = Tuple.create((Object)title, (Object)String.join((CharSequence)"\n", failMessage));
            this.getView().showMessage(String.valueOf(message.item1), String.valueOf(message.item2), MessageTypes.Default);
        }
        this.getView().invokeOperation("refresh");
        ActManageUtils.refreshEvaluateCount(this.getView());
    }

    private int dealPartEvalBackResultData(DynamicObject[] evaluationObjects, Map<String, Object> returnMap, List<String> failMessage) {
        int allSize;
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        Map scoreAndLevelMap = EvalObjUtils.reqFormScoreAndLevel((DynamicObject)activityDy);
        int successSize = allSize = evaluationObjects.length;
        BigDecimal score = (BigDecimal)returnMap.get("score");
        String level = (String)returnMap.get("level");
        OrmLocaleValue reason = (OrmLocaleValue)returnMap.get("reason");
        Date date = new Date();
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        String lastNodeFlag = this.getView().getPageCache().get("lastNodeFlag");
        for (int index = 0; index < evaluationObjects.length; ++index) {
            boolean evalCompletedLastNode;
            DynamicObject evalObj = evaluationObjects[index];
            boolean bl = evalCompletedLastNode = HRStringUtils.isNotEmpty((String)lastNodeFlag) && HRStringUtils.equals((String)lastNodeFlag, (String)"1") && HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessNodeStatusEnum.EVALUATED.getStatus());
            if (evalCompletedLastNode && HRStringUtils.equals((String)evalObj.getString("ressyncstatus"), (String)ResSyncStatusEnum.ARCHIVED.getCode())) {
                failMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0} ({1}) : \u7ed3\u679c\u5df2\u5f52\u6863\uff0c\u4e0d\u53ef\u4fee\u6539", (String)"EvaluateEvaluatedList_3", (String)"opmc-epa-business", (Object[])new Object[0]), evalObj.getString("person.name"), evalObj.getString("person.number")));
                --successSize;
                continue;
            }
            if (!(evalCompletedLastNode || evalObj.getLong("assessnode.id") == NodeTabMapEnum.EVAL_PROCESS.getNodeId().longValue() && HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.EVALUATED.getStatus()) && HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.HAVE_IN_HAND.getStatus()))) {
                failMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0} ({1}) : \u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u8bc4\u4f30\u5b8c\u6210", (String)"EvaluateEvaluatedList_4", (String)"opmc-epa-business", (Object[])new Object[0]), evalObj.getString("person.name"), evalObj.getString("person.number")));
                --successSize;
                continue;
            }
            evalObj.set(AssessScoreAbbrEnum.MSOAC.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.MLOAC.getCode(), (Object)level);
            evalObj.set(AssessScoreAbbrEnum.SOP.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.LOP.getCode(), (Object)level);
            evalObj.set("sopsource", (Object)AssessScoreAbbrEnum.MSOAC.getCode());
            evalObj.set(AssessScoreAbbrEnum.FSOP.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.FLOP.getCode(), (Object)level);
            evalObj.set("fsopsource", (Object)AssessScoreAbbrEnum.SOP.getCode());
            evalObj.set("fsopscoresystem", scoreAndLevelMap.get("scoreSystem"));
            evalObj.set("floplevel", scoreAndLevelMap.get("sumPerfLevel"));
            evalObj.set("perffilev", evalObj.get("perffile.sourcevid"));
            long userId = UserServiceHelper.getCurrentUserId();
            evalObj.set("modifier", (Object)userId);
            evalObj.set("modifytime", (Object)date);
            dyColl.add((Object)evalObj);
        }
        OBJSET_SCORERECORD_ENTITY_SERVICE.saveEntityByEval(dyColl, score, level, (Object)reason, AssessNodeStatusEnum.EVALUATED.getNodeId());
        ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evaluationObjects);
        return allSize - successSize;
    }

    private DynamicObject[] getEvalObjsWithScore() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Long[] evalObjectIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithScoreById(Arrays.asList(evalObjectIdList));
    }

    private Map<String, Object> getReturnMap(Object returnData) {
        if (returnData == null) {
            return null;
        }
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            return result;
        }
        return null;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        switch (fieldName = event.getFieldName()) {
            case "person_name": 
            case "person.name": 
            case "perffile_name": {
                args.setCancel(true);
                this.showEvalDetailForm();
                break;
            }
        }
    }

    private void showEvalDetailForm() {
        Object pkId = this.getFocusRowPkId();
        boolean isShow = PROCESS_EXECUTE_APPLICATION_SERVICE.checkEvalFinishType(pkId, true);
        if (!isShow) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u672a\u53c2\u4e0e\u8bc4\u4f30\u6d41\u7a0b\uff0c\u65e0\u8bc4\u4f30\u8be6\u60c5\u8bb0\u5f55", (String)"EvaluateEvaluatedList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_actevalobj_evalres");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId(pkId);
        baseShowParameter.setPageId(this.getView().getPageId() + this.getFocusRowPkId().toString());
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    @Override
    public void setEnableCustomSum(EnableCustomSumEvent args) {
        args.setEnableCustomSum(false);
        super.setEnableCustomSum(args);
    }
}

