/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entity.PushResultBo;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.ActRecordStartTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.enums.EvalfinishtypeEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.utils.ActManageUtils;
import kd.opmc.epa.formplugin.web.utils.ShowConfigTipsUtils;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuProcEntityService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuProcDomainService;
import kd.opmc.pbs.common.utils.OpmcDateUtils;

public class EvaluateEvaluatingList
extends EvalObjBaseList {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final FlowRuProcEntityService FLOW_RU_PROC_ENTITY_SERVICE = FlowRuProcEntityService.getInstance();
    private static final FlowRuProcDomainService FLOW_RU_PROC_DOMAIN_SERVICE = FlowRuProcDomainService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final ObjsetScoreRecordDomainService OBJSET_SCORERECORD_ENTITY_SERVICE = ObjsetScoreRecordDomainService.getInstance();
    private static final AssessActivityApplicationService ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();
    private Map<Long, List<DynamicObject>> ACT_RECORD_MAP = new HashMap<Long, List<DynamicObject>>(16);
    private Map<Long, Map<String, String>> CUR_NODE_MAP = new HashMap<Long, Map<String, String>>(16);
    private Map<Long, String> RUFLOW_FLOWINFO_MAP = new HashMap<Long, String>(16);
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final String EVAL_SCH_MONITOR_OP = "evalschmonitor";
    private static final String EVAL_MONITOR_AP = "evalmonitorap";
    private static final String EVAL_MONITOR_LAB = "evalmonitorlab";
    private static final String SEND_EVAL_TASK_AP = "sendevaltaskap";
    private static final String SEND_EVAL_TASK_LAB = "sendevaltasklab";
    private static final String EPA_NOTPARTICIPATEEVAL = "epa_notparticipateeval";
    private static final String END_EVAL_CLOSE_BACK_BYMODEL = "endEvalCloseBackByModel";
    private static final String PERASON_NAME = "person_name";
    private static final String EVALFLOW_NAME = "evalflow_name";
    private static final String PERFILE_NAME = "perffile_name";
    private static final String WAITTING_SEND = "waittingsend";
    private static final String WAITTING_IDS = "waittingIds";
    private List<Long> ACTOBJ_IDS = new ArrayList<Long>(10);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{EVAL_MONITOR_AP, EVAL_MONITOR_LAB, SEND_EVAL_TASK_AP, SEND_EVAL_TASK_LAB});
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("evalflow.name".equals(fieldName)) {
            List ids;
            List qFilters = args.getQfilters();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long activityId = (Long)customParams.get("activity");
            DynamicObject activityDy = ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            long perfWorkFlowId = activityDy.getLong("perfworkflow.id");
            if (perfWorkFlowId == 0L) {
                perfWorkFlowId = activityDy.getLong("executescheme.perfworkflow.id");
            }
            if (CollectionUtils.isEmpty((Collection)(ids = PERF_WORK_FLOW_DOMAIN_SERVICE.queryFlowById(perfWorkFlowId, "2")))) {
                return;
            }
            qFilters.add(new QFilter("id", "in", (Object)ids));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "evalmonitorap": 
            case "evalmonitorlab": {
                this.getView().invokeOperation(EVAL_SCH_MONITOR_OP);
                break;
            }
            case "sendevaltaskap": 
            case "sendevaltasklab": {
                this.showSendEvalTaskView();
                break;
            }
        }
    }

    private void showSendEvalTaskView() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Map flowMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvaluatingFlowsMap(activityId);
        DynamicObject[] flows = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowByPkValue(flowMap.keySet());
        if (Objects.isNull(flows) || flows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"EvaluateEvaluatingList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("epa_evaltaskmanage");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setPageId("epa_evaltaskmanage" + (Objects.isNull(activityId) ? "" : activityId.toString()) + nodeIndex);
        baseShowParameter.setCustomParam("activity", (Object)activityId);
        baseShowParameter.setCustomParam("nodeindex", (Object)nodeIndex);
        this.getView().showForm(baseShowParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        switch (fieldName = event.getFieldName()) {
            case "perffile_name": {
                this.showEvalDetailForm();
                break;
            }
            case "evalflow_name": {
                this.ShowWorkflowForm();
                break;
            }
        }
        args.setCancel(true);
    }

    public void setFilter(SetFilterEvent filterEvent) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        QFilter qFilter = new QFilter("activity", "=", (Object)activityId).and("nodestatus", "=", (Object)AssessNodeStatusEnum.EVALUATING.getStatus()).and("assessstaus", "=", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus()).and("nodeindex", "=", (Object)nodeIndex);
        List filterList = filterEvent.getQFilters();
        filterList.add(qFilter);
        QFilter actIdFilter = null;
        for (QFilter filter2 : filterList) {
            Object value;
            if (!WAITTING_SEND.equals(filter2.getProperty()) || !((value = filter2.getValue()) instanceof String)) continue;
            String qcp = "1".equals(value) ? "in" : "not in";
            String ids = this.getView().getPageCache().get(WAITTING_IDS);
            List idList = JSONObject.parseArray((String)ids, Long.class);
            actIdFilter = new QFilter("id", qcp, (Object)idList);
        }
        filterList.removeIf(filter -> WAITTING_SEND.equals(filter.getProperty()));
        if (actIdFilter != null) {
            filterList.add(actIdFilter);
        }
    }

    private void showEvalDetailForm() {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_actevalobj_evalres");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId(this.getFocusRowPkId());
        baseShowParameter.setPageId(this.getView().getPageId() + this.getFocusRowPkId().toString());
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void ShowWorkflowForm() {
        Object focusRowPkId = this.getFocusRowPkId();
        DynamicObject[] objects = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryByPkValues(new Object[]{focusRowPkId});
        Object flowId = objects[0].getDynamicObject("evalflow").getPkValue();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_assessworkflow");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setCustomParam("assessruleid", (Object)0L);
        baseShowParameter.setPkId(flowId);
        baseShowParameter.setPageId("epa_assessworkflowEvaluateEvaluatingList" + flowId);
        baseShowParameter.setCustomParam("flowType", (Object)"2");
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        for (IListColumn listColumn : columns) {
            DynamicObject dy = this.getModel().getDataEntity();
            if (StringUtils.equals((CharSequence)"evalflowins.procstatus", (CharSequence)listColumn.getListFieldKey()) && listColumn instanceof ListColumn) {
                ShowConfigTipsUtils.showListColumnTips((ListColumn)listColumn, "procstatus", "pbs_flowruproc", dy);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"assessprocess", (CharSequence)listColumn.getListFieldKey()) || !(listColumn instanceof ListColumn)) continue;
            ShowConfigTipsUtils.showListColumnTips((ListColumn)listColumn, "assessprocess", "epa_actevalobj", dy);
        }
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        super.beforePackageData(dataEvent);
        DynamicObjectCollection pageData = dataEvent.getPageData();
        boolean selectedAllRows = ((ListModel)dataEvent.getSource()).isSelectedAllRows();
        if (!pageData.isEmpty() && !selectedAllRows) {
            List actObjIds = pageData.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList());
            this.ACT_RECORD_MAP = EVALUATION_OBJECT_APPLICATION_SERVICE.queryActRecordByActObjIds(actObjIds);
            this.CUR_NODE_MAP = EVALUATION_OBJECT_APPLICATION_SERVICE.queryEvaluatingCurNodeByObjIds(actObjIds, AssessNodeStatusEnum.EVALUATING.getNodeId().longValue());
            List flowInsIds = pageData.stream().map(actObj -> actObj.getLong("evalflowins.id")).collect(Collectors.toList());
            this.RUFLOW_FLOWINFO_MAP = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getFlowInfo(flowInsIds);
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            this.ACTOBJ_IDS = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getWaittingSendByActivityId(activityId);
            this.getView().getPageCache().put(WAITTING_IDS, this.ACTOBJ_IDS.toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long activityId;
        Map flowMap;
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)EVAL_SCH_MONITOR_OP) && ObjectUtils.isEmpty((Object)(flowMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvaluatingFlowsMap(activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity"))))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"EvaluateEvaluatingList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        switch (operateKey = evt.getOperateKey()) {
            case "refresh": {
                ActManageUtils.refreshEvaluateCount(this.getView());
                break;
            }
            case "evalschmonitor": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("epa_evalflowmonitor");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                parameter.setCustomParam("activity", (Object)activityId);
                parameter.setCustomParam("objectscope", this.getView().getFormShowParameter().getCustomParam("objectscope"));
                parameter.setPageId("epa_evalflowmonitor" + this.getView().getPageId());
                parameter.setHasRight(true);
                this.getView().showForm(parameter);
                break;
            }
            case "donothing_endeval": {
                this.showEndEvalPage();
                break;
            }
            case "reseteval": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "donothing_evalprocessview": {
                this.transferFlowMonitor();
                break;
            }
            case "push": {
                this.evalObjPush();
                break;
            }
        }
    }

    private void evalObjPush() {
        Long activityId;
        List<Long> objIds = this.getEvaluationObjectIds();
        PushResultBo pushResultBo = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.pushByObjIds(objIds, activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity"));
        if (pushResultBo.getFailCount() > 0 && pushResultBo.getSuccessCount() > 0) {
            String title = ResManager.loadKDString((String)"\u5171\u52fe\u9009{0}\u4e2a\u8bc4\u4f30\u5bf9\u8c61\uff0c\u53ef\u50ac\u529e\u8bc4\u4f30\u4efb\u52a1\u5171{1}\u6761\uff0c\u50ac\u529e\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"EvaluateEvaluatingList_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{pushResultBo.getObjCount(), pushResultBo.getTaskCount(), pushResultBo.getSuccessCount(), pushResultBo.getFailCount()});
            this.getView().showMessage(title, pushResultBo.getFailMessage(), MessageTypes.Default);
        } else if ((long)pushResultBo.getSuccessCount() == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5171\u52fe\u9009{0}\u4e2a\u8bc4\u4f30\u5bf9\u8c61\uff0c\u53ef\u50ac\u529e\u8bc4\u4f30\u4efb\u52a1\u51710\u6761\uff0c\u50ac\u529e\u5931\u8d25", (String)"EvaluateEvaluatingList_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{pushResultBo.getObjCount()}));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5171\u52fe\u9009{0}\u4e2a\u8bc4\u4f30\u5bf9\u8c61\uff0c\u53ef\u50ac\u529e\u8bc4\u4f30\u4efb\u52a1\u5171{1}\u6761\uff0c\u5168\u90e8\u50ac\u529e\u6210\u529f", (String)"EvaluateEvaluatingList_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{pushResultBo.getObjCount(), pushResultBo.getTaskCount()}));
        }
    }

    private List<Long> getEvaluationObjectIds() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        return Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList());
    }

    private void transferFlowMonitor() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("pbs_flowrumonitor");
        ListFilterParameter list = new ListFilterParameter();
        list.getQFilters().add(new QFilter("activity", "=", (Object)activityId));
        list.getQFilters().add(new QFilter("workflowtype", "=", (Object)"2"));
        parameter.setListFilterParameter(list);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPageId("pbs_flowrumonitor" + this.getView().getPageId());
        parameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showEndEvalPage() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(EPA_NOTPARTICIPATEEVAL);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("activity", (Object)activityId);
        showParameter.setCustomParam("operationType", (Object)"1");
        showParameter.setCustomParam("evalCount", (Object)Integer.toString(this.getSelectedRows().size()));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, END_EVAL_CLOSE_BACK_BYMODEL));
        this.getView().showForm(showParameter);
    }

    public void packageData(PackageDataEvent evt) {
        Object source = evt.getSource();
        if (source instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc columnDesc = (DynamicTextColumnDesc)source;
            Map<String, String> map = this.CUR_NODE_MAP.get(evt.getRowData().getLong("id"));
            switch (columnDesc.getKey()) {
                case "currentnode": {
                    this.setNodeFormatValue(evt, map, "currentnode");
                    break;
                }
                case "duration": {
                    this.setNodeFormatValue(evt, map, "duration");
                    break;
                }
                case "currenthandler": {
                    this.setNodeFormatValue(evt, map, "currenthandler");
                    break;
                }
                case "starttype": {
                    this.setActRecordFormatValue("starttype", evt);
                    break;
                }
                case "assessstarttime": {
                    this.setActRecordFormatValue("createtime", evt);
                    break;
                }
                case "ruflowinfo": {
                    this.setRuFlowInfoValue(evt);
                    break;
                }
            }
        } else {
            String key = ((AbstractColumnDesc)evt.getSource()).getKey();
            if ("assessprocess".equals(key)) {
                Map<String, String> map = this.CUR_NODE_MAP.get(evt.getRowData().getLong("id"));
                this.setNodeFormatValue(evt, map, "assessprocess");
            } else if (WAITTING_SEND.equals(key)) {
                Long id = evt.getRowData().getLong("id");
                Integer value = this.ACTOBJ_IDS.contains(id) ? 1 : 0;
                evt.setFormatValue((Object)value);
            }
        }
    }

    private void setNodeFormatValue(PackageDataEvent evt, Map<String, String> map, String fieldKey) {
        if (map == null || ObjectUtils.isEmpty((Object)map.get(fieldKey))) {
            return;
        }
        evt.setFormatValue((Object)map.get(fieldKey));
    }

    private void setActRecordFormatValue(String key, PackageDataEvent dataEvent) {
        DynamicObject actEvalObj = dataEvent.getRowData();
        List<DynamicObject> actRecords = this.ACT_RECORD_MAP.get(actEvalObj.getLong("id"));
        if (CollectionUtils.isEmpty(actRecords)) {
            return;
        }
        DynamicObject record = actRecords.stream().filter(actRecord -> actRecord.getLong("assessnode") == AssessNodeStatusEnum.EVALUATING.getNodeId().longValue()).filter(actRecord -> HRStringUtils.equals((String)actRecord.getString("nodeindex"), (String)"2")).filter(actRecord -> HRStringUtils.equals((String)actRecord.getString("nodestatus"), (String)AssessNodeStatusEnum.EVALUATING.getStatus())).findFirst().orElse(null);
        if (record != null) {
            String curValue = record.getString(key);
            if ("starttype".equals(key)) {
                ActRecordStartTypeEnum startType = ActRecordStartTypeEnum.getEnum((String)curValue);
                curValue = startType.getText();
            } else if (HRStringUtils.equals((String)"createtime", (String)key)) {
                curValue = OpmcDateUtils.formatTimeUser((Date)record.getDate(key));
            }
            dataEvent.setFormatValue((Object)curValue);
        }
    }

    private void setRuFlowInfoValue(PackageDataEvent dataEvent) {
        String ruFlowInfo;
        Long ruFlowId;
        DynamicObject actEvalObj = dataEvent.getRowData();
        if (actEvalObj != null && (ruFlowId = Long.valueOf(actEvalObj.getLong("evalflowins.id"))) != null && ruFlowId != 0L && !HRStringUtils.isEmpty((String)(ruFlowInfo = this.RUFLOW_FLOWINFO_MAP.get(ruFlowId)))) {
            dataEvent.setFormatValue((Object)ruFlowInfo);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        Map<String, Object> returnMap = this.getReturnMap(returnData);
        if (returnMap == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)END_EVAL_CLOSE_BACK_BYMODEL)) {
            this.endEvalBack(returnMap);
            return;
        }
    }

    private void endEvalBack(Map<String, Object> returnMap) {
        Object[] evaluationObjects = this.getEvalObjsWithScore();
        if (ObjectUtils.isEmpty((Object[])evaluationObjects)) {
            return;
        }
        ArrayList<String> failMessage = new ArrayList<String>(16);
        int notSuitCount = this.dealPartEvalBackResultData((DynamicObject[])evaluationObjects, returnMap, failMessage);
        if (notSuitCount == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u8bc4\u4f30\u6210\u529f", (String)"EvaluateEvaluatingList_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"EvaluateEvaluatingList_5", (String)"opmc-epa-business", (Object[])new Object[0]), evaluationObjects.length, evaluationObjects.length - notSuitCount, notSuitCount);
            Tuple message = Tuple.create((Object)title, (Object)String.join((CharSequence)"\n", failMessage));
            this.getView().showMessage(String.valueOf(message.item1), String.valueOf(message.item2), MessageTypes.Default);
        }
        this.getView().invokeOperation("refresh");
        ActManageUtils.refreshEvaluateCount(this.getView());
    }

    private Map<String, Object> getReturnMap(Object returnData) {
        if (returnData == null) {
            return null;
        }
        if (returnData instanceof Map) {
            Map result = (Map)returnData;
            return result;
        }
        return null;
    }

    private DynamicObject[] getEvalObjsWithScore() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Long[] evalObjectIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithScoreById(Arrays.asList(evalObjectIdList));
    }

    private int dealPartEvalBackResultData(DynamicObject[] evaluationObjects, Map<String, Object> returnMap, List<String> failMessage) {
        int allSize;
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        Map scoreAndLevelMap = EvalObjUtils.reqFormScoreAndLevel((DynamicObject)activityDy);
        int successSize = allSize = evaluationObjects.length;
        BigDecimal score = (BigDecimal)returnMap.get("score");
        String level = (String)returnMap.get("level");
        OrmLocaleValue reason = (OrmLocaleValue)returnMap.get("reason");
        Date date = new Date();
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> ruProcIdList = new ArrayList<Long>(10);
        for (int index = 0; index < evaluationObjects.length; ++index) {
            DynamicObject evalObj = evaluationObjects[index];
            if (evalObj.getLong("assessnode.id") != NodeTabMapEnum.EVAL_PROCESS.getNodeId().longValue() || !HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.EVALUATING.getStatus()) || !HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.HAVE_IN_HAND.getStatus())) continue;
            ruProcIdList.add(evalObj.getLong("evalflowins.id"));
        }
        List<Object> resultList = new ArrayList(10);
        if (!ruProcIdList.isEmpty()) {
            resultList = this.stopProcess(ruProcIdList, null == reason ? "" : reason.getLocaleValue());
        }
        HashMap<Long, Boolean> ruProcResultMap = new HashMap<Long, Boolean>(16);
        for (FlowCommonResultBo commonResultBo : resultList) {
            ruProcResultMap.put(commonResultBo.getDataId(), commonResultBo.getCode().equals("1"));
        }
        int evaObjSize = evaluationObjects.length;
        for (int index = 0; index < evaObjSize; ++index) {
            DynamicObject evalObj = evaluationObjects[index];
            if (evalObj.getLong("assessnode.id") != NodeTabMapEnum.EVAL_PROCESS.getNodeId().longValue() || !HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.EVALUATING.getStatus()) || !HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.HAVE_IN_HAND.getStatus())) {
                failMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0} ({1}) : \u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u8bc4\u4f30\u4e2d", (String)"EvaluateEvaluatingList_6", (String)"opmc-epa-business", (Object[])new Object[0]), evalObj.getString("person.name"), evalObj.getString("person.number")));
                --successSize;
                continue;
            }
            if (!((Boolean)ruProcResultMap.get(evalObj.getLong("evalflowins.id"))).booleanValue()) {
                failMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0} ({1}) : \u6d41\u7a0b\u5904\u7406\u5931\u8d25", (String)"EvaluateEvaluatingList_7", (String)"opmc-epa-business", (Object[])new Object[0]), evalObj.getString("person.name"), evalObj.getString("person.number")));
                --successSize;
                continue;
            }
            evalObj.set(AssessScoreAbbrEnum.SATCS.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.SATCL.getCode(), (Object)level);
            evalObj.set(AssessScoreAbbrEnum.SOAT.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.LEVELOAT.getCode(), (Object)level);
            evalObj.set("soatsource", (Object)AssessScoreAbbrEnum.SATCS.getCode());
            evalObj.set(AssessScoreAbbrEnum.SOAC.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.LOAC.getCode(), (Object)level);
            evalObj.set(AssessScoreAbbrEnum.SOP.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.LOP.getCode(), (Object)level);
            evalObj.set("sopsource", (Object)AssessScoreAbbrEnum.SOAC.getCode());
            evalObj.set(AssessScoreAbbrEnum.FSOP.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.FLOP.getCode(), (Object)level);
            evalObj.set("fsopsource", (Object)AssessScoreAbbrEnum.SOP.getCode());
            evalObj.set("fsopscoresystem", scoreAndLevelMap.get("scoreSystem"));
            evalObj.set("floplevel", scoreAndLevelMap.get("sumPerfLevel"));
            DynamicObjectCollection timeplanEntry = activityDy.getDynamicObjectCollection("timeplanentry");
            boolean isLastNode = timeplanEntry.size() == evalObj.getInt("nodeindex");
            evalObj.set("modifier", (Object)userId);
            evalObj.set("modifytime", (Object)date);
            evalObj.set("perffilev", evalObj.get("perffile.sourcevid"));
            evalObj.set("evalfinishtype", (Object)EvalfinishtypeEnum.FINISH_EVAL.getType());
            evalObj.set("nodestatus", (Object)(isLastNode ? null : AssessNodeStatusEnum.EVALUATED.getStatus()));
            if (isLastNode) {
                evalObj.set("assessstaus", (Object)AssessStausEnum.COMPLETED.getStatus());
                evalObj.set("assessnode", null);
                evalObj.set("nodeindex", null);
                evalObj.set("completetime", (Object)date);
            }
            dyColl.add((Object)evalObj);
        }
        OBJSET_SCORERECORD_ENTITY_SERVICE.saveEntityByEval(dyColl, score, level, (Object)reason, AssessNodeStatusEnum.EVALUATED.getNodeId());
        ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evaluationObjects);
        EvalObjUtils.saveRecord((DynamicObjectCollection)dyColl, (Long)activityId, (Date)date, (long)userId);
        return allSize - successSize;
    }

    public List<FlowCommonResultBo> stopProcess(List<Long> ruProcIdList, String reason) {
        return FLOW_RU_PROC_DOMAIN_SERVICE.stopProcess(ruProcIdList, reason);
    }
}

