/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.evaluating.entity.EvalSubmitShowInfoDto;

public class EvaluateSubmitTipsDynamicPlugin
extends AbstractFormPlugin {
    public static final String NOT_REFRESH_FROM_SUBMIT = "NOT_REFRESH_FROM_SUBMIT";
    private static final Log LOG = LogFactory.getLog(EvaluateSubmitTipsDynamicPlugin.class);
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    public static final String BTNOK = "btnok";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setEntryAndTextData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnok": {
                this.submitTask();
                break;
            }
        }
    }

    public void submitTask() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskId = (String)formShowParameter.getCustomParam("taskId");
        boolean submitSuccess = true;
        try {
            long c1 = System.currentTimeMillis();
            submitSuccess = APP_SERVICE.submitEvalTask(taskId);
            if (submitSuccess) {
                this.syncIndicatorDataInfo(formShowParameter);
            } else {
                String tips = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"EvaluateSubmitTipsDynamicPlugin_0", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
            }
            long c2 = System.currentTimeMillis();
            long cc = c2 - c1;
            StringBuilder s1 = new StringBuilder();
            s1.append("EvaluateSubmitTipsDynamicPlugin submitEvalTask use time:").append(cc).append("ms");
            LOG.error(s1.toString());
        }
        catch (KDBizException bizException) {
            String message = bizException.getMessage();
            this.getView().showTipNotification(message);
            submitSuccess = false;
        }
        catch (Exception e) {
            submitSuccess = false;
            LOG.error("evasubmit task error\uff1a", (Throwable)e);
            String tips = ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"EvaluateSubmitTipsDynamicPlugin_0", (String)"opmc-epa-opplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
        }
        if (submitSuccess) {
            String parentViewEntityId;
            this.updateIsCanEdit(taskId);
            long ss1 = System.currentTimeMillis();
            boolean release = MutexHelper.release((String)"epa_actevalobj_eval", (String)"nodeview", (String)taskId);
            LOG.info("acteval mutex release taskid:{},release:{}", (Object)taskId, (Object)release);
            this.getView().getParentView().setStatus(OperationStatus.VIEW);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            this.getView().getParentView().invokeOperation("refresh", option);
            this.getView().sendFormAction(this.getView().getParentView());
            long ss2 = System.currentTimeMillis();
            long sss = ss2 - ss1;
            StringBuilder sssx = new StringBuilder();
            sssx.append("EvaluateSubmitTipsDynamicPlugin REFRESH use time:").append(sss).append("ms");
            LOG.error(sssx.toString());
            long xx1 = System.currentTimeMillis();
            if (this.getView().getParentView().getParentView() != null && "epa_actevalobj_eval_multi".equals(parentViewEntityId = this.getView().getParentView().getParentView().getEntityId())) {
                this.getView().getParentView().getParentView().getPageCache().put("isEmptyPage", "true");
                OperateOption option1 = OperateOption.create();
                option1.setVariableValue("ishasright", "true");
                this.getView().getParentView().getParentView().invokeOperation("refresh", option1);
                this.getView().getParentView().getParentView().getPageCache().put("isEmptyPage", "false");
                this.getView().sendFormAction(this.getView().getParentView().getParentView());
                long xx2 = System.currentTimeMillis();
                StringBuilder sssxx = new StringBuilder();
                sssxx.append("EvaluateSubmitTipsDynamicPlugin REFRESH2 use time:").append(xx2 - xx1).append("ms");
                LOG.error(sssxx.toString());
            }
            this.getView().close();
        }
    }

    private void updateIsCanEdit(String taskId) {
        if (taskId != null && !"".equals(taskId.trim())) {
            ArrayList<Long> taskIds = new ArrayList<Long>(10);
            taskIds.add(Long.parseLong(taskId));
            APP_SERVICE.updateGenIndRecordCanEditByTask(taskIds, false);
            APP_SERVICE.updateAddSubIndRecordCanEditByTask(taskIds, false);
            APP_SERVICE.updateAttachIndRecordCanEditByTask(taskIds, false);
            APP_SERVICE.updateCustomRecordCanEditByTask(taskIds, false);
        }
    }

    private void syncIndicatorDataInfo(FormShowParameter formShowParameter) {
        List subEvalRecordPageList;
        String subEvalRecordPageListStr = (String)formShowParameter.getCustomParam("subEvalRecordPageList");
        if (!HRStringUtils.isBlank((CharSequence)subEvalRecordPageListStr) && (subEvalRecordPageList = (List)kd.bos.portal.util.SerializationUtils.fromJsonString((String)subEvalRecordPageListStr, List.class)) != null) {
            for (String subEvalRecordPage : subEvalRecordPageList) {
                IFormView subAreaPage = this.getView().getView(subEvalRecordPage);
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                subAreaPage.invokeOperation("syncindicator", option);
            }
        }
    }

    protected void invokeSaveOp() {
        this.getView().getParentView().getPageCache().put("isInvokeOperation", "true");
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        this.getView().getParentView().invokeOperation("save", option);
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void setEntryAndTextData() {
        Boolean isCrossEvaluate;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String jsonStr = (String)formShowParameter.getCustomParam("areaSubTotalList");
        List list = new ArrayList(10);
        if (!HRStringUtils.isBlank((CharSequence)jsonStr)) {
            list = SerializationUtils.fromJsonStringToList((String)jsonStr, EvalSubmitShowInfoDto.class);
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"tipsflex"});
        if (list == null || list.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tipsflex"});
        }
        FlexPanelAp listApFlex = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("arealistap").setDirection("column").setAlignItems("flex-start").setJustifyContent("stretch").setWrap(false).setPaddingTop("6px")).setPaddingBottom("6px")).setGrow(1).setShrink(1).build();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String areaItem = "arealistitemap" + i;
                String paddingRight = "40px";
                if (list.size() >= 4) {
                    paddingRight = "32px";
                }
                FlexPanelAp tableItemAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(areaItem).setDirection("row").setJustifyContent("space-between").setAlignItems("center").setWrap(false).setWidth("100%").setHeight("auto").setMarginTop("6px")).setMarginBottom("6px")).setPaddingLeft("4px")).setPaddingRight(paddingRight)).setGrow(0).setShrink(0).setBackColor("#ffffff").build();
                EvalSubmitShowInfoDto infoDto = (EvalSubmitShowInfoDto)list.get(i);
                String name = infoDto.getName();
                LabelAp nameAp = new LabelAp();
                String nameId = areaItem + "_name";
                nameAp.setId(nameId);
                nameAp.setKey(nameId);
                nameAp.setName(new LocaleString(name));
                nameAp.setFontSize(12);
                nameAp.setWidth(new LocaleString("260px"));
                nameAp.setForeColor("#212121");
                nameAp.setFontWeight("400");
                nameAp.setAutoTextWrap(false);
                nameAp.setParentId(areaItem);
                tableItemAp.getItems().add(nameAp);
                String score = String.valueOf(infoDto.getScore());
                LabelAp valueAp = new LabelAp();
                String valueId = areaItem + "_val";
                valueAp.setId(valueId);
                valueAp.setKey(valueId);
                valueAp.setFontSize(14);
                valueAp.setFontWeight("600");
                valueAp.setWidth(new LocaleString("60px"));
                valueAp.setTextAlign("right");
                valueAp.setForeColor("#ff991c");
                valueAp.setName(new LocaleString(score));
                valueAp.setAutoTextWrap(false);
                valueAp.setParentId(areaItem);
                tableItemAp.getItems().add(valueAp);
                listApFlex.getItems().add(tableItemAp);
            }
        }
        this.getView().updateControlMetadata(listApFlex.getKey(), listApFlex.createControl());
        Integer numAccuracy = formShowParameter.getCustomParam("numAccuracy") == null ? Integer.valueOf(2) : (Integer)formShowParameter.getCustomParam("numAccuracy");
        Integer scaleType = formShowParameter.getCustomParam("scaleType") == null ? Integer.valueOf(4) : (Integer)formShowParameter.getCustomParam("scaleType");
        BigDecimal totalScore = EvaluateSubmitTipsDynamicPlugin.getTotalScore(formShowParameter);
        totalScore = totalScore.setScale((int)numAccuracy, scaleType);
        String totalLevel = (String)formShowParameter.getCustomParam("totalLevel");
        StringBuilder builder = new StringBuilder();
        if (totalScore != null) {
            builder.append(totalScore.stripTrailingZeros().toPlainString());
        }
        if (!HRStringUtils.isBlank((CharSequence)totalLevel) && this.isDisplayOle().booleanValue()) {
            if (!HRStringUtils.isBlank((CharSequence)builder.toString())) {
                builder.append("/");
            }
            builder.append(totalLevel);
        }
        Boolean isShowInFlow = formShowParameter.getCustomParam("isShowInFlow") == null ? Boolean.FALSE : (Boolean)formShowParameter.getCustomParam("isShowInFlow");
        Boolean bl = isCrossEvaluate = formShowParameter.getCustomParam("isCrossEvaluate") == null ? Boolean.FALSE : (Boolean)formShowParameter.getCustomParam("isCrossEvaluate");
        if (HRStringUtils.isBlank((CharSequence)builder.toString()) || !isShowInFlow.booleanValue() || isCrossEvaluate.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap", "totalscore"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"labelap", "totalscore"});
            Label control = (Label)this.getControl("totalscore");
            control.setText(builder.toString());
        }
    }

    private Boolean isDisplayOle() {
        HashMap sumPermSetting;
        boolean flag = false;
        String sumPermSettingStr = this.getView().getParentView().getPageCache().get("sumPermSetting");
        if (sumPermSettingStr != null && (sumPermSetting = (HashMap)kd.bos.portal.util.SerializationUtils.fromJsonString((String)sumPermSettingStr, HashMap.class)).get("ole") != null) {
            HashMap oleMap = (HashMap)sumPermSetting.get("ole");
            flag = (Boolean)oleMap.get("displayItem");
        }
        return flag;
    }

    private static BigDecimal getTotalScore(FormShowParameter formShowParameter) {
        Object totalScoreObj = formShowParameter.getCustomParam("totalScore");
        BigDecimal totalScore = totalScoreObj instanceof Integer || totalScoreObj instanceof Long ? new BigDecimal(totalScoreObj.toString()) : (totalScoreObj instanceof String ? new BigDecimal((String)totalScoreObj) : (BigDecimal)totalScoreObj);
        if (totalScore == null) {
            totalScore = BigDecimal.ZERO;
        }
        return totalScore;
    }
}

