/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.TipsSupport;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;

public class EvaluatingProcessEdit
extends HRDataBaseEdit {
    private static final String[] TAB_CONTAIN = new String[]{"flow_1", "flow_2", "flow_3", "flow_4", "flow_5", "flow_6", "flow_7", "flow_8", "flow_9", "flow_10"};
    private static final String[] FLOW_CONTAIN_SUB = new String[]{"flowname_1", "flowstatus_1", "flowname_2", "flowstatus_2"};

    public void initialize() {
        super.initialize();
        this.addClickListeners(TAB_CONTAIN);
        this.addClickListeners(FLOW_CONTAIN_SUB);
    }

    public void click(EventObject evt) {
        boolean success;
        super.click(evt);
        Object source = evt.getSource();
        String key = ((TipsSupport)source).getKey();
        String[] split = key.split("_");
        if ("flowstatus".equals(split[0]) || "flowname".equals(split[0])) {
            split[0] = "flow";
        }
        if (success = this.switchWizard(split)) {
            this.showTabPageByEvalFlow(Integer.parseInt(split[1]));
        }
    }

    private void showTabPageByEvalFlow(int clickIdx) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("evalflowentry");
        if (clickIdx > entryEntity.size()) {
            return;
        }
        DynamicObject flowEntry = (DynamicObject)entryEntity.get(clickIdx - 1);
        this.showTabPage(flowEntry.getDynamicObject("evalflowru").getLong("id"), clickIdx);
    }

    private void showTabPage(Long flowRu, int idx) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_evaluatingprocessnode");
        showParameter.setCustomParam("FLOW_RU_ID", (Object)flowRu);
        showParameter.setCustomParam("SHOW_TAB_IDX", (Object)idx);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("flowpage" + idx);
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
    }

    private boolean switchWizard(String[] split) {
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        for (String tab : TAB_CONTAIN) {
            boolean isSelected = HRStringUtils.equals((String)tab, (String)(split[0] + "_" + split[1]));
            HashMap stepLabMap = new HashMap(16);
            HashMap style = new HashMap(16);
            HashMap<String, String> rBorder = new HashMap<String, String>(16);
            rBorder.put("b", isSelected ? "2px_solid_themeColor" : "");
            style.put("b", rBorder);
            stepLabMap.put("s", style);
            this.getView().updateControlMetadata(tab, stepLabMap);
        }
        tabAp.activeTab(split[0] + "tab" + "_" + split[1]);
        return true;
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.showHeadInfo();
        this.showFlowEntryInfo();
        this.showTabPageByEvalFlow(1);
    }

    private void showFlowEntryInfo() {
        int i;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("evalflowentry");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        for (i = 0; i < entryEntity.size(); ++i) {
            DynamicObject flowEntry = (DynamicObject)entryEntity.get(i);
            DynamicObject flowRu = flowEntry.getDynamicObject("evalflowru");
            this.setLabelText(FLOW_CONTAIN_SUB[i * 2], flowEntry.getDynamicObject("evalflowdef").getString("name"), new String[0]);
            String procStatus = flowRu.getString("procstatus");
            this.setLabelText(FLOW_CONTAIN_SUB[i * 2 + 1], "\uff08" + FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)procStatus).getText() + "\uff09", new String[0]);
            FlowRuProcStatusEnum flowRuProcStatusByCode = FlowRuProcStatusEnum.getFlowRuProcStatusByCode((String)procStatus);
            if (HRObjectUtils.isEmpty((Object)flowRuProcStatusByCode)) continue;
            this.setProcStatusColour(flowRuProcStatusByCode.getColour(), FLOW_CONTAIN_SUB[i * 2 + 1]);
        }
        for (i = entryEntity.size(); i < 10; ++i) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TAB_CONTAIN[i]});
        }
        model.endInit();
        this.getView().updateView("assflowap");
    }

    private void setProcStatusColour(String colour, String updateControl) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
        HashMap style = new HashMap(16);
        fieldMap.put("fc", colour);
        fieldMap.put("s", style);
        this.getView().updateControlMetadata(updateControl, fieldMap);
    }

    private void showHeadInfo() {
        IFormView view = this.getView();
        DynamicObject dynamicObject = this.getView().getModel().getDataEntity();
        Image image = (Image)view.getControl("headsculpture");
        String headSculpture = dynamicObject.getString("person.headsculpture");
        if (!HRStringUtils.isEmpty((String)headSculpture)) {
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)headSculpture));
        }
        this.setLabelText("objname", dynamicObject.getString("person.name"), "objname");
        this.setLabelText("objnumber", dynamicObject.getString("person.number"), "objnumber");
        this.setLabelText("headassgroup", dynamicObject.getString("assgroup.name"), "headassgroup");
        this.setLabelText("headlaborrelstatus", dynamicObject.getString("employee.laborrelstatus.name"), "headlaborrelstatus");
        this.setLabelText("headpostype", dynamicObject.getString("empposrel.postype.name"), "headpostype");
        this.setLabelText("companylabel", dynamicObject.getString("affiliateadminorg.name"), "companyicon", "companylabel");
        this.setLabelText("adminorglabel", dynamicObject.getString("perforg.name"), "adminorgicon", "adminorglabel");
        this.setLabelText("perforglabel", dynamicObject.getString("perffile.pmdperson.name"), "perforgicon", "perforglabel");
        this.setLabelText("positionlabel", dynamicObject.getString("empposrel.position.name"), "positionicon", "positionlabel");
        this.setLabelText("joblabel", dynamicObject.getString("empposrel.job.name"), "jobicon", "joblabel");
    }

    private void setLabelText(String key, String text, String ... icon) {
        IFormView view = this.getView();
        Label label = (Label)view.getControl(key);
        if (ObjectUtils.isEmpty((Object)label)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)text)) {
            label.setText("");
            if (icon != null && icon.length > 0 && icon[0] != null) {
                this.getView().setVisible(Boolean.FALSE, icon);
            }
        } else {
            label.setText(text);
        }
    }
}

