/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.common.enums.activitymanage.EvaluatingProcessStatusEnum;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuProcStatusEnum;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class EvaluatingProcessFlowPlugin
extends HRDynamicFormBasePlugin {
    private static final String NODE_TYPE_ID = "flownodedef.nodetype.id";
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        this.initFlowRuProcess();
    }

    private void initFlowRuProcess() {
        int i;
        Long flowRuId = (Long)this.getView().getFormShowParameter().getCustomParam("FLOW_RU_ID");
        DynamicObject[] allNode = FLOW_RU_PROC_APPLICATION_SERVICE.queryAllNodeByProcId(flowRuId);
        DynamicObject[] allRole = FLOW_RU_PROC_APPLICATION_SERVICE.queryAllRoleByProcId(flowRuId);
        Map<Long, List<DynamicObject>> roleMap = Arrays.stream(allRole).collect(Collectors.groupingBy(dy -> dy.getLong("flowrunode.id")));
        for (i = 0; i < allNode.length; ++i) {
            boolean isNoShowWeight;
            FlexPanelAp ruRolePage = this.getShowAp(i == 0 ? "rurolepage" : "rurolepage" + i);
            String nodeName = i == 0 ? "nodename" : "nodename" + i;
            String nodeWeight = i == 0 ? "nodeweight" : "nodeweight" + i;
            Label nodeNameLabel = (Label)this.getControl(nodeName);
            nodeNameLabel.setText(allNode[i].getString("name"));
            Label nodeWeightLabel = (Label)this.getControl(nodeWeight);
            Long nodeTypeId = allNode[i].getLong(NODE_TYPE_ID);
            boolean bl = isNoShowWeight = null != nodeTypeId && nodeTypeId.equals(NodeTypeConstants.BATCH_ADJUSTSUMSCORE);
            if (isNoShowWeight) {
                nodeWeightLabel.setText("");
            } else {
                nodeWeightLabel.setText("(" + allNode[i].getInt("nodeweight") + "%)");
            }
            this.setNodeStatusVector(i, allNode);
            boolean isCrossNode = allNode[i].getBoolean("iscrossnode");
            this.getView().setVisible(Boolean.valueOf(isCrossNode), new String[]{i == 0 ? "iscross" : "iscross" + i});
            if (isCrossNode) continue;
            List<DynamicObject> roles = roleMap.get(allNode[i].getLong("id"));
            for (DynamicObject role : roles) {
                this.showRuRoleArea(ruRolePage, role.getLong("id"), isNoShowWeight);
            }
            this.getView().updateControlMetadata(ruRolePage.getKey(), ruRolePage.createControl());
        }
        for (i = allNode.length; i < 10; ++i) {
            String apKey = i == 0 ? "nodeap_1" : "nodeap_1" + i;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{apKey});
        }
        String procStatus = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcStatus(flowRuId);
        boolean isProcFinished = HRStringUtils.equals((String)FlowRuProcStatusEnum.FINISHED.getCode(), (String)procStatus);
        this.getView().setVisible(Boolean.valueOf(isProcFinished), new String[]{"lastfinishedvector"});
        this.getView().setVisible(Boolean.valueOf(!isProcFinished), new String[]{"lastnotactivevector"});
    }

    private void setNodeStatusVector(int idx, DynamicObject[] node) {
        String idxStr = idx == 0 ? "" : String.valueOf(idx);
        EvaluatingProcessStatusEnum[] processStatusEnums = EvaluatingProcessStatusEnum.values();
        EvaluatingProcessStatusEnum evaluatingProcessStatus = EvaluatingProcessStatusEnum.getEvaluatingProcessStatusEnum((String)node[idx].getString("nodestatus"));
        ArrayList<String> apStr = new ArrayList<String>();
        for (EvaluatingProcessStatusEnum processStatusEnum : processStatusEnums) {
            if (evaluatingProcessStatus == processStatusEnum) continue;
            apStr.add(processStatusEnum.getKey() + idxStr);
        }
        this.getView().setVisible(Boolean.valueOf(false), apStr.toArray(new String[0]));
    }

    private void showRuRoleArea(FlexPanelAp areaShowAp, Long roleRuId, boolean isNoShowWeight) {
        String targetKey = areaShowAp.getKey() + System.currentTimeMillis();
        FlexPanelAp cardAp = new HRFlexPanelAp.Builder(targetKey).build();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_evaluatingprocess_car");
        showParameter.setCustomParam("RU_ROLE_ID", (Object)roleRuId);
        showParameter.setCustomParam("isNoShowWeight", (Object)isNoShowWeight);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
        areaShowAp.getItems().add(cardAp);
    }

    private FlexPanelAp getShowAp(String key) {
        return new HRFlexPanelAp.Builder(key).setDirection("column").setAlignItems("stretch").setJustifyContent("flex-start").setWrap(false).setGrow(1).setShrink(0).build();
    }
}

