/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.area;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.evaluating.entity.ActEvalIndFieldItemTipsDto;
import kd.opmc.epa.business.domain.evaluating.entity.ActEvalIndFieldTipsDto;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.business.domain.evaluating.entity.EvalFieldEnterBo;
import kd.opmc.epa.business.domain.evaluating.entity.IndicatorEvalRecordBo;
import kd.opmc.epa.business.utils.NumberValidateUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.IisAllImportIndicatorsService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.impl.IisAllImportIndicatorsServiceImpl;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.utils.EvaluteDrawEntryEntityUtils;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.epa.formplugin.web.utils.EvaluationShowCartEntryTipsUtils;
import kd.opmc.epa.formplugin.web.utils.IndicatorDetailUtils;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;

public class AddSubAreaEvaluationEdit
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    public static final String NUM_STR_2 = "2";
    private final AssessActivityApplicationService ACTIVITY_SERVICE = AssessActivityApplicationService.getInstance();
    private static final Log LOGGER = LogFactory.getLog(AddSubAreaEvaluationEdit.class);
    private static final String[] AREA_INIT_FIELDS = new String[]{"actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc", "area"};
    private static final String[] INDICATOR_INIT_FIELDS = new String[]{"actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc", "area"};
    private static final String[] MERGE_IND_FIELDS = new String[]{"flowrunode", "flowrurole", "flowrutask", "flowruproc"};
    private static String[] SET_STRING_FIELDS = new String[]{"qualityres", "finishdesc"};
    private static final List<String> ADDSUB_AREA_IGNORE_FILED_LIST = new ArrayList<String>(16);
    public static final String TASK_WEIGHT_PREFIX = "TASK_WEIGHT_";

    public void initialize() {
        super.initialize();
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryPlusMinusConfigByPk(confId);
        if (conf != null) {
            boolean isPartIn = conf.getBoolean("ispartin");
            this.getView().getPageCache().put("isPartInStr", String.valueOf(isPartIn));
            boolean isAllowEval = true;
            this.getView().getPageCache().put("IS_ALLOW_EVAL_AREA", String.valueOf(isAllowEval));
            String areaName = conf.getString("areacustname");
            this.getView().getPageCache().put("areaCustomerName", areaName);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryPlusMinusConfigByPk(confId);
        String[] ignoreFields = ADDSUB_AREA_IGNORE_FILED_LIST.toArray(new String[ADDSUB_AREA_IGNORE_FILED_LIST.size()]);
        List<ContentFieldEntryEvaDto> fieldEntryEvaDtos = ObjEvaluationUtils.getPermFieldSetting(formShowParameter);
        EvaluteDrawEntryEntityUtils.customDrawArea(args, conf, ignoreFields, AssessRuleConstants.PLUS_MINUS_AREA_PK, fieldEntryEvaDtos);
    }

    public void afterCreateNewData(EventObject e) {
        ObjEvaluationUtils.cacheBindingData(this.getView(), true);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        for (String initField : AREA_INIT_FIELDS) {
            Object fieldValue = parameter.getCustomParam(initField);
            if (fieldValue == null) continue;
            this.getModel().setValue(initField, fieldValue);
        }
        this.initIndicatorEntry(parameter);
        ObjEvaluationUtils.calculateSSR(this.getView(), ObjEvaluationUtils.queryTaskWeight(this.getPageCache(), (Long)parameter.getCustomParam("flowrutask")), false);
        this.getView().getPageCache().put("isFirstLoad", "true");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
        ObjEvaluationUtils.cacheBindingData(this.getView(), true);
        this.freezeEntryCol();
    }

    private void freezeEntryCol() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.setColumnProperty("indctrname", "isFixed", (Object)true);
        }
    }

    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
            DynamicObject conf = this.ACTIVITY_SERVICE.queryPlusMinusConfigByPk(confId);
            DynamicObject areaDy = this.getModel().getDataEntity().getDynamicObject("area");
            this.getView().updateControlMetadata("ssr", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
            this.getView().updateControlMetadata("ssrec", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
            this.getModel().setValue("minareascore", areaDy.get("minareascore"));
            this.getModel().setValue("maxareascore", areaDy.get("maxareascore"));
            this.getModel().setValue("nodeweight", this.getModel().getDataEntity().get("flowrunode.nodeweight"));
            this.getModel().setValue("roleweight", this.getModel().getDataEntity().get("flowrurole.roleweight"));
            this.setAreaTips(areaDy, conf);
            this.setInitEntryFields();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            ArrayList<Long> indicatorIds = new ArrayList<Long>(16);
            ActEvalIndFieldTipsDto actEvalIndFieldTipsDto = new ActEvalIndFieldTipsDto();
            actEvalIndFieldTipsDto.setTitle(ResManager.loadKDString((String)"\u5206\u6570\u9650\u5236", (String)"AddSubAreaEvaluationEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            ArrayList<ActEvalIndFieldItemTipsDto> actEvalIndFieldItemTipsDtos = new ArrayList<ActEvalIndFieldItemTipsDto>(10);
            for (DynamicObject dynamicObject : entryEntity) {
                indicatorIds.add(dynamicObject.getLong("indicator.id"));
                String indctrname = dynamicObject.getString("indicator.indctrname");
                BigDecimal minDecimal = dynamicObject.getBigDecimal("indicator.subscoremin") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("indicator.subscoremin");
                BigDecimal maxDecimal = dynamicObject.getBigDecimal("indicator.addscoremax") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("indicator.addscoremax");
                minDecimal = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), minDecimal) == null ? BigDecimal.ZERO : ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), minDecimal);
                String subscoremin = minDecimal.toPlainString();
                maxDecimal = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), maxDecimal) == null ? BigDecimal.ZERO : ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), maxDecimal);
                String addscoremax = maxDecimal.toPlainString();
                ActEvalIndFieldItemTipsDto actEvalIndFieldItemTipsDto = new ActEvalIndFieldItemTipsDto(indctrname, String.format("[%s ~ %s]", subscoremin, addscoremax));
                actEvalIndFieldItemTipsDtos.add(actEvalIndFieldItemTipsDto);
            }
            actEvalIndFieldTipsDto.setActEvalIndFieldItemTipsList(actEvalIndFieldItemTipsDtos);
            this.getView().getPageCache().put("actEvalIndFieldTips", JSON.toJSONString((Object)actEvalIndFieldTipsDto));
            Map recordHisMap = APP_SERVICE.queryIndicatorEvalRecordHis(indicatorIds, AreaRegEnum.PLUS_MINUS_AREA);
            EvaluationShowCartEntryTipsUtils.showGridEntryDetail(this.getView(), recordHisMap, AreaRegEnum.PLUS_MINUS_AREA);
            ObjEvaluationUtils.cacheMustInputFieldInfo(this.getView(), conf, conf.getString("areacustname"), AreaRegEnum.PLUS_MINUS_AREA, false);
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            this.getView().setEnable(status == OperationStatus.VIEW ? Boolean.FALSE : Boolean.TRUE, new String[]{"entryentity"});
            Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
            DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
            this.addMergeIndicators();
            this.doInitForMerge(conf);
            ObjEvaluationUtils.dealPreNodeCarryInfo(this.getView(), status, taskId, AreaRegEnum.PLUS_MINUS_AREA, null);
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("columnResizeMode", "preset");
            this.getView().updateControlMetadata("entryentity", map);
            ObjEvaluationUtils.calculateSSR(this.getView(), APP_SERVICE.queryTaskWeight(taskId), false);
            this.cacheSsrData();
            this.getView().getPageCache().put("page_load_finished_key", "true");
            boolean isrollbacked = taskObj.getBoolean("isrollbacked");
            if (status == OperationStatus.ADDNEW || isrollbacked) {
                ObjEvaluationUtils.calculateScoreFirst(this.getView());
            }
            this.setSoeFieldTips(actEvalIndFieldTipsDto);
            this.setNotEditRowOfCross();
            this.cacheIsAllImportIndicators();
            this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector"});
        }
        catch (Exception excep) {
            LOGGER.error(excep.getMessage(), (Throwable)excep);
            throw excep;
        }
        finally {
            ObjEvaluationUtils.cacheBindingData(this.getView(), false);
        }
    }

    private void cacheIsAllImportIndicators() {
        IFormView parentViews = this.getView().getParentView().getParentView();
        if (this.isAddSubAllImportIndicators(this.getView())) {
            parentViews.getPageCache().put("isAllImportIndicators_PLUS_MINUS", "true");
        } else {
            parentViews.getPageCache().put("isAllImportIndicators_PLUS_MINUS", "false");
        }
    }

    public boolean isAddSubAllImportIndicators(IFormView view) {
        IisAllImportIndicatorsServiceImpl isAllImportIndicatorsService = new IisAllImportIndicatorsServiceImpl();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)isAllImportIndicatorsService, IisAllImportIndicatorsService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.IisAllImportIndicatorsService#isAllImportIndicators", (PluginFilter)null);
        List booleans = proxy.callReplaceIfPresent(validate -> validate.isAllImportIndicators(view));
        if (booleans != null && booleans.size() > 0) {
            return (Boolean)booleans.get(0);
        }
        return false;
    }

    private void addMergeIndicators() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long areaId = (Long)formShowParameter.getCustomParam("area");
        String mergeTaskIdsStr = (String)formShowParameter.getCustomParam("mergeTaskIds");
        String mergeTaskIndsStr = (String)formShowParameter.getCustomParam("mergeTaskInds");
        Long taskId = (Long)formShowParameter.getCustomParam("flowrutask");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
            List mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
            Map mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
            Map taskInfoMap = APP_SERVICE.queryTaskMap(mergeTaskIds);
            ArrayList mergeIndIdList = new ArrayList(10);
            ArrayList<Long> mergeTaskIdList = new ArrayList<Long>(10);
            HashMap indTaskMap = new HashMap(16);
            if (mergeTaskInds.size() > 1) {
                for (int j = 0; j < mergeTaskIds.size(); ++j) {
                    List areaIndItemList;
                    Long taskItemId = (Long)mergeTaskIds.get(j);
                    mergeTaskIdList.add(taskItemId);
                    Map areaRegIndicaItemMap = (Map)mergeTaskInds.get(taskItemId);
                    if (!areaRegIndicaItemMap.containsKey(areaId) || (areaIndItemList = (List)areaRegIndicaItemMap.get(areaId)) == null) continue;
                    mergeIndIdList.addAll(areaIndItemList);
                    for (int i = 0; i < areaIndItemList.size(); ++i) {
                        indTaskMap.put(areaIndItemList.get(i), taskItemId);
                    }
                }
                Collections.sort(mergeIndIdList);
                DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
                if (!mergeIndIdList.isEmpty()) {
                    int row = mergeIndIdList.size();
                    model.deleteEntryData("entryentity");
                    model.beginInit();
                    model.batchCreateNewEntryRow("entryentity", row);
                    Map addSubEvalRecordMap = APP_SERVICE.queryEvalRecordByTaskIdsAndIndIds(AreaRegEnum.PLUS_MINUS_AREA, mergeTaskIdList, mergeIndIdList);
                    Long userId = RequestContext.get().getCurrUserId();
                    Date now = new Date();
                    for (int i = 0; i < row; ++i) {
                        Long indId = (Long)mergeIndIdList.get(i);
                        DynamicObject evalObj = (DynamicObject)addSubEvalRecordMap.get(indId);
                        Long taskItemId = (Long)indTaskMap.get(indId);
                        Map taskMap = (Map)taskInfoMap.get(taskItemId);
                        Long actEvalObjId = (Long)formShowParameter.getCustomParam("actevalobj");
                        int assessYear = (Integer)formShowParameter.getCustomParam("assessyear");
                        String assessPeriod = (String)formShowParameter.getCustomParam("assessperiod");
                        Long activityId = (Long)formShowParameter.getCustomParam("activity");
                        Object perforgId = formShowParameter.getCustomParam("perforg");
                        Long flowrutaskId = (Long)taskMap.get("flowrutask");
                        Long flowrunodeId = (Long)taskMap.get("flowrunode");
                        Long flowruroleId = (Long)taskMap.get("flowrurole");
                        Long flowruprocId = (Long)taskMap.get("flowruproc");
                        Long areaInsId = (Long)formShowParameter.getCustomParam("area");
                        BigDecimal soe = BigDecimal.ZERO;
                        Date realFinishDate = new Date();
                        String qualityRes = "";
                        LocaleString finishDes = new LocaleString("");
                        LocaleString evalDesc = new LocaleString("");
                        Boolean iscanedit = Boolean.TRUE;
                        if (evalObj != null) {
                            actEvalObjId = evalObj.getLong("actevalobj");
                            assessYear = evalObj.getInt("assessyear");
                            assessPeriod = evalObj.getString("assessperiod");
                            activityId = evalObj.getLong("activity");
                            perforgId = evalObj.getLong("perforg");
                            flowrutaskId = evalObj.getLong("flowrutask.id");
                            flowrunodeId = evalObj.getLong("flowrunode.id");
                            flowruroleId = evalObj.getLong("flowrurole.id");
                            flowruprocId = evalObj.getLong("flowruproc");
                            areaInsId = evalObj.getLong("area");
                            soe = evalObj.getBigDecimal("soe");
                            realFinishDate = evalObj.getDate("realfinishdate");
                            qualityRes = evalObj.getString("qualityres");
                            finishDes = evalObj.getLocaleString("finishdesc");
                            evalDesc = evalObj.getLocaleString("evaldesc");
                            iscanedit = evalObj.getBoolean("iscanedit");
                        }
                        this.getModel().setValue("indicator", (Object)indId, i);
                        this.getModel().setValue("indactevalobj", (Object)actEvalObjId, i);
                        this.getModel().setValue("indassessyear", (Object)assessYear, i);
                        this.getModel().setValue("indassessperiod", (Object)assessPeriod, i);
                        this.getModel().setValue("indactivity", (Object)activityId, i);
                        this.getModel().setValue("indperforg", perforgId, i);
                        this.getModel().setValue("indflowrutask", (Object)flowrutaskId, i);
                        this.getModel().setValue("indflowruproc", (Object)flowruprocId, i);
                        this.getModel().setValue("indflowrunode", (Object)flowrunodeId, i);
                        this.getModel().setValue("indflowrurole", (Object)flowruroleId, i);
                        this.getModel().setValue("indarea", (Object)areaInsId, i);
                        this.getModel().setValue("soe", (Object)soe, i);
                        this.getModel().setValue("evaldesc", (Object)evalDesc, i);
                        this.getModel().setValue("realfinishdate", (Object)realFinishDate, i);
                        this.getModel().setValue("qualityres", (Object)qualityRes, i);
                        this.getModel().setValue("finishdesc", (Object)finishDes, i);
                        this.getModel().setValue("iscanedit", (Object)iscanedit, i);
                        this.getModel().setValue("indcreator", (Object)userId, i);
                        this.getModel().setValue("indcreatetime", (Object)now, i);
                        this.getModel().setValue("indmodifier", (Object)userId, i);
                        this.getModel().setValue("indmodifytime", (Object)now, i);
                    }
                    model.endInit();
                    this.getView().updateView("entryentity");
                    DynamicObjectCollection entryColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
                    if (entryColl != null) {
                        entryColl.sort((o1, o2) -> {
                            if (o1 != null && o2 != null) {
                                int seq2;
                                int seq1 = o1.getInt("indicator.entryseq");
                                if (seq1 >= (seq2 = o2.getInt("indicator.entryseq"))) {
                                    return 1;
                                }
                                return -1;
                            }
                            return 0;
                        });
                    }
                }
            }
        }
    }

    private void doInitForMerge(DynamicObject conf) {
        if (this.isCrossMerge()) {
            Map mergeTaskInds;
            String mergeTaskIndsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskInds");
            HashMap taskIndMap = new HashMap(16);
            if (HRStringUtils.isNotEmpty((String)mergeTaskIndsStr) && (mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class)) != null) {
                Long areaId = (Long)this.getView().getFormShowParameter().getCustomParam("area");
                for (Map.Entry entry : mergeTaskInds.entrySet()) {
                    List indicatorList;
                    if (entry == null) continue;
                    Long taskId = (Long)entry.getKey();
                    Map areaIndMap = (Map)entry.getValue();
                    if (taskId == null || areaIndMap == null || areaIndMap.isEmpty() || (indicatorList = (List)areaIndMap.get(areaId)) == null || indicatorList.isEmpty()) continue;
                    List inds = taskIndMap.get(taskId) == null ? new ArrayList(10) : (List)taskIndMap.get(taskId);
                    inds.addAll(indicatorList);
                    taskIndMap.put(taskId, inds);
                }
            }
            Long areaId = (Long)this.getView().getFormShowParameter().getCustomParam("area");
            Map hasTaskRecordMap = APP_SERVICE.queryEvalRecord(AreaRegEnum.PLUS_MINUS_AREA, areaId, taskIndMap);
            for (Map.Entry entry : taskIndMap.entrySet()) {
                List hasRecordIndList;
                if (entry == null) continue;
                Long taskIdKey = (Long)entry.getKey();
                List indList = (List)entry.getValue();
                if (taskIdKey == null || indList == null || indList.isEmpty()) continue;
                if (hasTaskRecordMap != null && (hasRecordIndList = (List)hasTaskRecordMap.get(taskIdKey)) != null) {
                    indList.removeAll(hasRecordIndList);
                }
                if (indList.isEmpty()) continue;
                this.initIndicatorEntryForMerge(conf, areaId, taskIdKey, indList);
            }
        }
    }

    private boolean isCrossMerge() {
        List mergeTaskIds;
        String mergeTaskIdsStr;
        return this.isCrossEval() && HRStringUtils.isNotEmpty((String)(mergeTaskIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskIds"))) && (mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class)) != null && mergeTaskIds.size() > 1;
    }

    public void initIndicatorEntryForMerge(DynamicObject conf, Long areaId, Long taskId, List<Long> crossIndicatorIds) {
        boolean firstNodeAndRole = APP_SERVICE.isFirstNodeAndRole(taskId);
        DynamicObject[] indicatorDys = APP_SERVICE.queryIndicator(areaId, AreaRegEnum.PLUS_MINUS_AREA, Boolean.valueOf(this.isCrossEval()), crossIndicatorIds);
        if (firstNodeAndRole) {
            this.setEntryRowDataFromInd(indicatorDys, conf);
        } else {
            Map indEvalRecordMap = new HashMap(16);
            Map indEvalScoreRecordMap = new HashMap(16);
            if (!this.isCrossEval() && !ObjEvaluationUtils.isPreRoleNodeIsCross(this.getView(), taskId)) {
                indEvalRecordMap = APP_SERVICE.queryIndicatorEvalRecordOfPreRoleLastTask(taskId, AreaRegEnum.PLUS_MINUS_AREA);
                indEvalScoreRecordMap = APP_SERVICE.queryIndicatorEvalScoreRecordOfPreRoleLastTask(taskId, AreaRegEnum.PLUS_MINUS_AREA);
            } else {
                HashMap<Long, List<Long>> taskMap = new HashMap<Long, List<Long>>(16);
                if (this.isCrossEval()) {
                    taskMap.put(taskId, crossIndicatorIds);
                } else {
                    ArrayList<Long> indicatorIdList = new ArrayList<Long>(10);
                    if (indicatorDys != null) {
                        for (DynamicObject indicatorDy : indicatorDys) {
                            if (indicatorDy == null || indicatorDy.getPkValue() == null || indicatorDy.getLong("id") == 0L) continue;
                            long indicatorDyPkValue = indicatorDy.getLong("id");
                            indicatorIdList.add(indicatorDyPkValue);
                        }
                    }
                    taskMap.put(taskId, indicatorIdList);
                }
                IndicatorEvalRecordBo evalRecordBo = APP_SERVICE.queryPreTaskCrossEvalRecord(taskMap, AreaRegEnum.PLUS_MINUS_AREA);
                if (evalRecordBo != null) {
                    indEvalRecordMap = evalRecordBo.getFinishEvalRecordMap();
                    indEvalScoreRecordMap = evalRecordBo.getScoreEvalRecordMap();
                }
            }
            this.setEntryRowInitData(indicatorDys, indEvalRecordMap, indEvalScoreRecordMap, conf);
        }
    }

    public void setEntryRowInitData(DynamicObject[] indicatorDys, Map<Long, DynamicObject> indEvalRecordMap, Map<Long, DynamicObject> indEvalScoreRecordMap, DynamicObject conf) {
        DynamicObjectCollection entryColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (entryColl == null || entryColl.isEmpty()) {
            return;
        }
        for (DynamicObject indicator : indicatorDys) {
            DynamicObject finishRecord;
            long indicatorId = indicator.getLong("id");
            if (indicator == null || indicator.getPkValue() == null || indicatorId == 0L) continue;
            if (indEvalRecordMap != null && (finishRecord = indEvalRecordMap.get(indicator.getPkValue())) != null) {
                for (DynamicObject entry : entryColl) {
                    long entryIndicatorId;
                    if (entry == null || indicatorId != (entryIndicatorId = entry.getLong("indicator.id"))) continue;
                    for (String setStringField : SET_STRING_FIELDS) {
                        String fieldValObj = finishRecord.get(setStringField) == null ? "" : finishRecord.get(setStringField);
                        entry.set(setStringField, (Object)fieldValObj);
                    }
                    entry.set("realfinishdate", indicator.get("realfinishdate"));
                }
            }
            Object soe = null;
            if (indEvalScoreRecordMap == null) continue;
            DynamicObject soeRecord = indEvalScoreRecordMap.get(indicator.getPkValue());
            if (soeRecord != null) {
                soe = soeRecord.get("soe") == null ? null : soeRecord.get("soe");
            }
            for (DynamicObject entry : entryColl) {
                long entryIndicatorId;
                if (entry == null || indicatorId != (entryIndicatorId = entry.getLong("indicator.id"))) continue;
                entry.set("soe", soe);
            }
        }
    }

    public void setEntryRowDataFromInd(DynamicObject[] indicatorDys, DynamicObject conf) {
        DynamicObjectCollection entryColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (entryColl == null || entryColl.isEmpty()) {
            return;
        }
        for (DynamicObject indicator : indicatorDys) {
            if (indicator == null || indicator.getPkValue() == null || indicator.getLong("id") == 0L) continue;
            long indicatorId = indicator.getLong("id");
            for (DynamicObject entry : entryColl) {
                long entryIndicatorId;
                if (entry == null || indicatorId != (entryIndicatorId = entry.getLong("indicator.id"))) continue;
                for (String setStringField : SET_STRING_FIELDS) {
                    String fieldValObj = indicator.get(setStringField) == null ? "" : indicator.get(setStringField);
                    entry.set(setStringField, (Object)fieldValObj);
                }
                entry.set("soe", null);
                entry.set("realfinishdate", indicator.get("realfinishdate"));
            }
        }
        this.getView().updateView("entryentity");
    }

    private void setInitEntryFields() {
        IFormView view = this.getView();
        IPageCache pageCache = this.getView().getPageCache();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String mergeTaskIdsStr = (String)formShowParameter.getCustomParam("mergeTaskIds");
        String mergeTaskIndsStr = (String)formShowParameter.getCustomParam("mergeTaskInds");
        Long areaInsId = (Long)formShowParameter.getCustomParam("area");
        if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
            List mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
            Map taskMap = APP_SERVICE.queryTaskMap(mergeTaskIds);
            Map mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
            HashMap<Long, Long> indTaskMap = new HashMap<Long, Long>(10);
            if (mergeTaskIds.size() > 1) {
                pageCache.put("mergeTaskCache", "true");
            }
            for (int j = 0; j < mergeTaskIds.size(); ++j) {
                Long taskItemId = (Long)mergeTaskIds.get(j);
                Map areaRegIndicaItemMap = (Map)mergeTaskInds.get(taskItemId);
                if (!areaRegIndicaItemMap.containsKey(areaInsId)) continue;
                List areaIndItemList = (List)areaRegIndicaItemMap.get(areaInsId);
                for (Long indId : areaIndItemList) {
                    indTaskMap.put(indId, taskItemId);
                }
            }
            if (formShowParameter.getStatus() == OperationStatus.ADDNEW) {
                DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    Long indId = ((DynamicObject)entryEntity.get(i)).getLong("indicator.id");
                    Long indTaskId = mergeTaskIds.size() > 1 ? (Long)indTaskMap.get(indId) : (Long)mergeTaskIds.get(0);
                    Map taskInfoMap = (Map)taskMap.get(indTaskId);
                    for (String initField : INDICATOR_INIT_FIELDS) {
                        Object fieldValue;
                        if (Arrays.asList(MERGE_IND_FIELDS).contains(initField)) {
                            fieldValue = taskInfoMap.get(initField);
                            if (fieldValue == null) continue;
                            view.getModel().setValue("ind" + initField, fieldValue, i);
                            continue;
                        }
                        fieldValue = formShowParameter.getCustomParam(initField);
                        if (fieldValue == null) continue;
                        view.getModel().setValue("ind" + initField, fieldValue, i);
                    }
                    ObjEvaluationUtils.setCreateInfo(view, i);
                }
            }
        }
    }

    private void setNotEditRowOfCross() {
        ArrayList<Integer> canNotEditIndexList = new ArrayList<Integer>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity != null) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                boolean crossCanEdit;
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                if (entry == null || (crossCanEdit = entry.getBoolean("iscanedit"))) continue;
                canNotEditIndexList.add(i);
            }
            if (!canNotEditIndexList.isEmpty()) {
                int[] notEditIndexArr = new int[canNotEditIndexList.size()];
                for (int i = 0; i < canNotEditIndexList.size(); ++i) {
                    notEditIndexArr[i] = (Integer)canNotEditIndexList.get(i);
                }
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                grid.setRowLock(true, notEditIndexArr);
            }
        }
    }

    private void setSoeFieldTips(ActEvalIndFieldTipsDto actEvalIndFieldTipsDto) {
        if (actEvalIndFieldTipsDto == null) {
            return;
        }
        StringBuilder content = new StringBuilder();
        List actEvalIndFieldItemTipsDtos = actEvalIndFieldTipsDto.getActEvalIndFieldItemTipsList();
        if (actEvalIndFieldItemTipsDtos != null) {
            for (ActEvalIndFieldItemTipsDto actEvalIndFieldItemTipsDto : actEvalIndFieldItemTipsDtos) {
                String name = actEvalIndFieldItemTipsDto.getName();
                String value = actEvalIndFieldItemTipsDto.getValue();
                content.append(name).append(" : ").append(value).append("\n");
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            Tips tips = new Tips();
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u5206\u6570\u9650\u5236", (String)"AddSubAreaEvaluationEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
            tips.setTriggerType("hover");
            tips.setType("text");
            tips.setContent(new LocaleString(content.toString()));
            tips.setIconClassName("kdfont kdfont-guanlianxinxi");
            tips.setPlace("right");
            entryGrid.setColumnProperty("soe", "tips", (Object)tips);
        }
    }

    private void setAreaTips(DynamicObject areaDy, DynamicObject conf) {
        EvalFieldEnterBo evalFieldEnterBo = new EvalFieldEnterBo();
        String areaName = conf.getString("areacustname");
        String description = conf.getString("description");
        String cacheDes = "";
        StringBuilder tipsBuilder = new StringBuilder();
        if (!HRStringUtils.isEmpty((String)description)) {
            cacheDes = ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a{0}", (String)"AddSubAreaEvaluationEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{description});
            tipsBuilder.append(cacheDes);
        }
        BigDecimal minareascore = areaDy.getBigDecimal("minareascore");
        BigDecimal maxareascore = areaDy.getBigDecimal("maxareascore");
        this.getView().getPageCache().put("addSubAreaTitleCacheKey", areaName);
        Tips tips = new Tips();
        tips.setTriggerType("hover");
        tips.setType("text");
        tips.setIconClassName("kdfont kdfont-guanlianxinxi");
        String msg = ResManager.loadKDString((String)"\u8bc4\u5206\u4e0a\u4e0b\u9650\uff1a{0}~{1}", (String)"AddSubAreaEvaluationEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{minareascore.stripTrailingZeros().toPlainString(), maxareascore.stripTrailingZeros().toPlainString()});
        if (tipsBuilder != null && !HRStringUtils.isBlank((CharSequence)tipsBuilder.toString())) {
            tipsBuilder.append("\n");
        }
        tipsBuilder.append(msg);
        tips.setContent(new LocaleString(tipsBuilder.toString()));
        tips.setPlace("right");
        Label titleLable = (Label)this.getView().getControl("areatitle");
        titleLable.addTips(tips);
    }

    public boolean isCrossEval() {
        Boolean isCrossEvaluate = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCrossEvaluate");
        return isCrossEvaluate != null && isCrossEvaluate != false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (HRStringUtils.equals((String)name, (String)"soe")) {
            try {
                String parentPageId = this.getView().getParentView().getPageId();
                IHRAppCache epaCache = HRAppCache.get((String)"epa");
                epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"true");
                int rowIndex = changeData.getRowIndex();
                DynamicObject indicator = (DynamicObject)this.getModel().getValue("indicator", rowIndex);
                BigDecimal scoreMax = indicator.getBigDecimal("addscoremax");
                BigDecimal scoreMin = indicator.getBigDecimal("subscoremin");
                BigDecimal newValue = (BigDecimal)changeData.getNewValue();
                String showTipsTag = this.getTipsTag(rowIndex, newValue);
                this.getView().getPageCache().put(showTipsTag, "true");
                if (ObjEvaluationUtils.validateSoe(this.getView(), changeData, scoreMax, scoreMin)) {
                    epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"false");
                    return;
                }
                Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
                DynamicObjectCollection indEvalRecordEntry = this.getModel().getEntryEntity("entryentity");
                BigDecimal ssr = indEvalRecordEntry.stream().map(indEvalRecord -> indEvalRecord.getBigDecimal("soe") == null ? BigDecimal.ZERO : indEvalRecord.getBigDecimal("soe")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (ssr == null) {
                    ssr = BigDecimal.ZERO;
                }
                DynamicObject areaDy = this.getModel().getDataEntity().getDynamicObject("area");
                BigDecimal minAreaScore = areaDy.getBigDecimal("minareascore");
                BigDecimal maxAreaScore = areaDy.getBigDecimal("maxareascore");
                if (ssr.compareTo(minAreaScore) < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u533a\u57df\u8bc4\u5206\u8303\u56f4\u4e3a\uff1a{0}~{1}\u3002", (String)"AddSubAreaEvaluationEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{minAreaScore, maxAreaScore}));
                    this.getModel().setValue("soe", null, rowIndex);
                    return;
                }
                if (ssr.compareTo(maxAreaScore) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u533a\u57df\u8bc4\u5206\u8303\u56f4\u4e3a\uff1a{0}~{1}\u3002", (String)"AddSubAreaEvaluationEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{minAreaScore, maxAreaScore}));
                    this.getModel().setValue("soe", null, rowIndex);
                    return;
                }
                if (this.isCrossEval()) {
                    ObjEvaluationUtils.calculateSSR(this.getView(), ObjEvaluationUtils.queryTaskWeight(this.getPageCache(), taskId), false);
                    epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"false");
                }
                ObjEvaluationUtils.calculateSSR(this.getView(), ObjEvaluationUtils.queryTaskWeight(this.getPageCache(), taskId), true);
            }
            catch (Exception exce) {
                LOGGER.error(exce.getMessage(), (Throwable)exce);
                String parentPageId = this.getView().getParentView().getPageId();
                IHRAppCache epaCache = HRAppCache.get((String)"epa");
                epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"false");
                throw exce;
            }
        } else if (HRStringUtils.equals((String)name, (String)"qualityres")) {
            NumberValidateUtils.opValidateEntryQualityRes((IFormView)this.getView(), (ChangeData)changeData);
        } else if (HRStringUtils.equals((String)name, (String)"ssr")) {
            this.cacheSsrData();
        }
    }

    private String getTipsTag(int rowIndex, BigDecimal newValue) {
        String showTipsTag = "";
        showTipsTag = newValue == null ? "soe" + rowIndex : "soe" + rowIndex + newValue.toString();
        return showTipsTag;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "syncindicator": {
                DynamicObjectCollection recordEntry = this.getModel().getEntryEntity("entryentity");
                APP_SERVICE.syncIndicatorInfo(recordEntry, AreaRegEnum.PLUS_MINUS_AREA, null);
                break;
            }
            case "submitvalid": {
                ObjEvaluationUtils.validateAreaMustEnterField(this.getView(), args);
                break;
            }
            case "save": {
                OperationResult operationResult = args.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess()) break;
                operationResult.setShowMessage(false);
                break;
            }
        }
    }

    private void initIndicatorEntry(FormShowParameter parameter) {
        IPageCache pageCache = this.getPageCache();
        Long areaId = (Long)parameter.getCustomParam("area");
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        ArrayList crossIndicatorIds = new ArrayList(10);
        String mergeTaskIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskIds");
        String mergeTaskIndsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskInds");
        HashMap taskMap = new HashMap(16);
        if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
            List mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
            Map mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
            if (mergeTaskInds.size() > 1) {
                pageCache.put("mergeTaskCache", "true");
                for (int j = 0; j < mergeTaskIds.size(); ++j) {
                    List areaIndItemList;
                    Long taskItemId = (Long)mergeTaskIds.get(j);
                    Map areaRegIndicaItemMap = (Map)mergeTaskInds.get(taskItemId);
                    if (!areaRegIndicaItemMap.containsKey(areaId) || (areaIndItemList = (List)areaRegIndicaItemMap.get(areaId)) == null) continue;
                    if (taskItemId.equals(taskId)) {
                        crossIndicatorIds.addAll(areaIndItemList);
                    }
                    List indicatorIds = taskMap.get(taskItemId) == null ? new ArrayList(10) : (List)taskMap.get(taskItemId);
                    indicatorIds.addAll(areaIndItemList);
                    taskMap.put(taskItemId, indicatorIds);
                }
            } else {
                Map areaIndicaMap = (Map)mergeTaskInds.get(taskId);
                List areaIndItemList = (List)areaIndicaMap.get(areaId);
                if (areaIndItemList != null) {
                    crossIndicatorIds.addAll(areaIndItemList);
                }
                taskMap.put(taskId, crossIndicatorIds);
            }
        }
        DynamicObject[] indicatorDys = APP_SERVICE.queryIndicator(areaId, AreaRegEnum.PLUS_MINUS_AREA, Boolean.valueOf(this.isCrossEval()), crossIndicatorIds);
        boolean firstNodeAndRole = APP_SERVICE.isFirstNodeAndRole(taskId);
        if (firstNodeAndRole) {
            this.addEntryRowAndSetInitData(indicatorDys);
        } else {
            HashMap<Long, DynamicObject> indEvalRecordMap = new HashMap(16);
            Map<Long, Object> indEvalScoreRecordMap = new HashMap<Long, DynamicObject>(16);
            if (!this.isCrossEval() && !ObjEvaluationUtils.isPreRoleNodeIsCross(this.getView(), taskId)) {
                indEvalRecordMap = APP_SERVICE.queryIndicatorEvalRecordOfPreRoleLastTask(taskId, AreaRegEnum.PLUS_MINUS_AREA);
                indEvalScoreRecordMap = APP_SERVICE.queryIndicatorEvalScoreRecordOfPreRoleLastTask(taskId, AreaRegEnum.PLUS_MINUS_AREA);
            } else {
                IndicatorEvalRecordBo evalRecordBo;
                if (!this.isCrossEval()) {
                    taskMap = new HashMap(16);
                    ArrayList<Long> indicatorIdList = new ArrayList<Long>(10);
                    if (indicatorDys != null) {
                        for (DynamicObject indicatorDy : indicatorDys) {
                            if (indicatorDy == null || indicatorDy.getPkValue() == null || indicatorDy.getLong("id") == 0L) continue;
                            long indicatorDyPkValue = indicatorDy.getLong("id");
                            indicatorIdList.add(indicatorDyPkValue);
                        }
                    }
                    taskMap.put(taskId, indicatorIdList);
                }
                if ((evalRecordBo = APP_SERVICE.queryPreTaskCrossEvalRecord(taskMap, AreaRegEnum.PLUS_MINUS_AREA)) != null) {
                    indEvalRecordMap = evalRecordBo.getFinishEvalRecordMap();
                    indEvalScoreRecordMap = evalRecordBo.getScoreEvalRecordMap();
                }
            }
            this.addEntryRowAndSetInitData(indicatorDys, indEvalRecordMap, indEvalScoreRecordMap);
        }
    }

    public void addEntryRowAndSetInitData(DynamicObject[] indicatorDys) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("indicator", new Object[0]);
        vs.addField("soe", new Object[0]);
        vs.addField("realfinishdate", new Object[0]);
        vs.addField("qualityres", new Object[0]);
        vs.addField("finishdesc", new Object[0]);
        for (DynamicObject indicator : indicatorDys) {
            if (indicator == null || indicator.getPkValue() == null || indicator.getLong("id") == 0L) continue;
            Object realfinishdate = indicator.get("realfinishdate");
            String qualityres = indicator.get("qualityres") == null ? "" : indicator.get("qualityres");
            String finishdesc = indicator.get("finishdesc") == null ? "" : indicator.get("finishdesc");
            vs.addRow(new Object[]{indicator.getPkValue(), null, realfinishdate, qualityres, finishdesc});
        }
        int count = vs.getCount();
        if (count > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void addEntryRowAndSetInitData(DynamicObject[] indicatorDys, Map<Long, DynamicObject> indEvalRecordMap, Map<Long, DynamicObject> indEvalScoreRecordMap) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("indicator", new Object[0]);
        vs.addField("soe", new Object[0]);
        vs.addField("realfinishdate", new Object[0]);
        vs.addField("qualityres", new Object[0]);
        vs.addField("finishdesc", new Object[0]);
        for (DynamicObject indicator : indicatorDys) {
            DynamicObject soeRecord;
            DynamicObject finishRecord;
            if (indicator == null || indicator.getPkValue() == null || indicator.getLong("id") == 0L) continue;
            Object soe = null;
            Object realfinishdate = null;
            Object qualityres = "";
            Object finishdesc = "";
            if (indEvalRecordMap != null && (finishRecord = indEvalRecordMap.get(indicator.getPkValue())) != null) {
                realfinishdate = finishRecord.get("realfinishdate");
                qualityres = finishRecord.get("qualityres");
                finishdesc = finishRecord.get("finishdesc");
            }
            if (indEvalScoreRecordMap != null && (soeRecord = indEvalScoreRecordMap.get(indicator.getPkValue())) != null) {
                soe = soeRecord.get("soe");
            }
            vs.addRow(new Object[]{indicator.getPkValue(), soe, realfinishdate, qualityres, finishdesc});
        }
        int count = vs.getCount();
        if (count > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"collapsevector", "expandvector"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "collapsevector": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity", "collapsevector"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"expandvector"});
                break;
            }
            case "expandvector": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity", "collapsevector"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector"});
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        String areaMarker = (String)this.getView().getFormShowParameter().getCustomParam("areaMarker");
        this.getView().getParentView().getPageCache().put("confId", confId.toString());
        if (HRStringUtils.equals((String)"entryentity", (String)entryGrid.getKey())) {
            IFormView view = this.getView();
            AreaRegEnum indctrArea = AreaRegEnum.PLUS_MINUS_AREA;
            IndicatorDetailUtils.showIndicatorDetail(entryGrid, view, indctrArea, areaMarker);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": {
                Long pkValue;
                OperationStatus status;
                String mergeTaskCache;
                String backenSave = source.getOption().getVariableValue("BACKEN_SAVE", "false");
                if ("true".equals(backenSave)) {
                    Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
                    BigDecimal taskWeight = ObjEvaluationUtils.queryTaskWeight(this.getPageCache(), taskId);
                    ObjEvaluationUtils.repeatCaluateSsr(this.getView(), taskWeight);
                }
                if (!HRStringUtils.isEmpty((String)(mergeTaskCache = this.getView().getPageCache().get("mergeTaskCache")))) {
                    FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                    DynamicObject addSubAreaRecordObj = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
                    String mergeTaskIdsStr = (String)formShowParameter.getCustomParam("mergeTaskIds");
                    String mergeTaskIndsStr = (String)formShowParameter.getCustomParam("mergeTaskInds");
                    if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
                        List mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
                        Map mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
                        APP_SERVICE.saveMergeAddSubAreaRecord(addSubAreaRecordObj);
                        this.getView().updateView("entryentity");
                        this.setNotEditRowOfCross();
                        IFormView parentView = this.getView().getParentView();
                        parentView.sendFormAction(this.getView());
                    }
                    args.setCancel(true);
                    return;
                }
                long max = Integer.MAX_VALUE;
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                dataEntity.getDataEntityState().setDirtyFlags(new long[]{max});
                dataEntity.getDataEntityState().setBizChangeFlags(new long[]{max});
                DynamicObjectCollection recordEntry = dataEntity.getDynamicObjectCollection("entryentity");
                if (recordEntry != null) {
                    Date currDate = new Date();
                    for (int i = 0; i < recordEntry.size(); ++i) {
                        DynamicObject dynamicObject = (DynamicObject)recordEntry.get(i);
                        dynamicObject.set("indmodifytime", (Object)currDate);
                        dynamicObject.getDataEntityState().setDirtyFlags(new long[]{max});
                        dynamicObject.getDataEntityState().setBizChangeFlags(new long[]{max});
                    }
                }
                if (OperationStatus.EDIT != (status = this.getView().getFormShowParameter().getStatus()) || (pkValue = (Long)this.getView().getModel().getDataEntity().getPkValue()) != null && 0L != pkValue) break;
                Long areaId = (Long)this.getView().getFormShowParameter().getCustomParam("area");
                Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
                if (!APP_SERVICE.isExistsAreaRecordByTaskAndAreaId(taskId, areaId, AssessRuleConstants.PLUS_MINUS_AREA_PK)) break;
                APP_SERVICE.deleteAreaRecordByTaskAndAreaId(taskId, areaId, AssessRuleConstants.PLUS_MINUS_AREA_PK);
                APP_SERVICE.saveAreaRecord(dataEntity, AssessRuleConstants.PLUS_MINUS_AREA_PK);
                args.setCancel(true);
                break;
            }
        }
    }

    private void soeNull2Zero() {
        DynamicObjectCollection recordEntry = this.getModel().getEntryEntity("entryentity");
        if (recordEntry != null) {
            for (DynamicObject dynamicObject : recordEntry) {
                BigDecimal soe;
                if (dynamicObject == null || (soe = dynamicObject.getBigDecimal("soe")) != null) continue;
                dynamicObject.set("soe", (Object)BigDecimal.ZERO);
            }
        }
    }

    private void cacheSsrData() {
        BigDecimal ssr = this.getModel().getDataEntity().getBigDecimal("ssr");
        if (ssr == null) {
            ssr = BigDecimal.ZERO;
        }
        this.getView().getPageCache().put("SSR_SCORE_AFTERBING", ssr.toPlainString());
        this.getView().getPageCache().put("ssrCacheValue", ssr.toPlainString());
    }

    static {
        ADDSUB_AREA_IGNORE_FILED_LIST.add("indctrdesc");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("evalcriteria");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("evaltype");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("qualitytarget");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("unit");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("indctrsource");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("remarks");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("isveto");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("indctrnumber");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("qualitydare");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("qualitybase");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("planfinishdate");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("subscoremin");
        ADDSUB_AREA_IGNORE_FILED_LIST.add("addscoremax");
    }
}

