/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.area;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.userconfig.GridConfigDAO;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.utils.EvaluteDrawEntryEntityUtils;
import kd.opmc.epa.formplugin.web.utils.IndicatorDetailUtils;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;

public class AttachAreaEvaluationEdit
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private final AssessActivityApplicationService ACTIVITY_SERVICE = AssessActivityApplicationService.getInstance();
    private static final Log LOGGER = LogFactory.getLog(AttachAreaEvaluationEdit.class);
    private static final String[] AREA_INIT_FIELDS = new String[]{"actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc", "area"};
    private static final String[] INDICATOR_INIT_FIELDS = new String[]{"actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc", "area"};
    private static final Map<String, String> RULE_FILED_MAP = new HashMap<String, String>(16);
    public static final String RAREAFIELDREG_CATEGORY_INDICATORDES = "10";
    public static final String RAREAFIELDREG_CATEGORY_FINISHDES = "20";
    public static final String RAREAFIELDREG_CATEGORY_SCOREDES = "30";
    private static final List<String> TIPS_FILED_LIST;

    public void initialize() {
        super.initialize();
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryAttachConfigByPk(confId);
        if (conf != null) {
            String areaName = conf.getString("areacustname");
            this.getView().getPageCache().put("areaCustomerName", areaName);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryAttachConfigByPk(confId);
        ArrayList indicatorDesList = new ArrayList(10);
        String[] ignoreFields = indicatorDesList.toArray(new String[indicatorDesList.size()]);
        List<ContentFieldEntryEvaDto> fieldEntryEvaDtos = ObjEvaluationUtils.getPermFieldSetting(formShowParameter);
        EvaluteDrawEntryEntityUtils.customDrawArea(args, conf, ignoreFields, AssessRuleConstants.ATTACH_AREA_PK, fieldEntryEvaDtos);
    }

    public void afterCreateNewData(EventObject e) {
        ObjEvaluationUtils.cacheBindingData(this.getView(), true);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        for (String initField : AREA_INIT_FIELDS) {
            Object fieldValue = parameter.getCustomParam(initField);
            if (fieldValue == null) continue;
            this.getModel().setValue(initField, fieldValue);
        }
        this.initIndicatorEntry(parameter);
    }

    public void setTitleAndTips(DynamicObject conf) {
        Label titleLable = (Label)this.getView().getControl("areatitle");
        String areCustName = conf.getString("areacustname");
        titleLable.setText(areCustName);
        boolean isShowTips = false;
        String description = conf.getString("description");
        StringBuilder tipsBuilder = new StringBuilder();
        if (!HRStringUtils.isBlank((CharSequence)description)) {
            isShowTips = true;
            String descTit = ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a", (String)"AttachAreaEvaluationEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            tipsBuilder.append(descTit).append(description);
        }
        this.getView().getPageCache().put("attachAreaTitleCacheKey", areCustName);
        if (isShowTips) {
            Tips tips = new Tips();
            tips.setTitle(null);
            tips.setTriggerType("hover");
            tips.setType("text");
            tips.setContent(new LocaleString(tipsBuilder.toString()));
            tips.setIconClassName("kdfont kdfont-guanlianxinxi");
            tips.setPlace("right");
            titleLable.addTips(tips);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
        ObjEvaluationUtils.cacheBindingData(this.getView(), true);
        this.freezeEntryCol();
    }

    private void freezeEntryCol() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.setColumnProperty("keyactname", "isFixed", (Object)true);
        }
    }

    public boolean isCrossEval() {
        Boolean isCrossEvaluate = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCrossEvaluate");
        return isCrossEvaluate != null && isCrossEvaluate != false;
    }

    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
            DynamicObject conf = this.ACTIVITY_SERVICE.queryAttachConfigByPk(confId);
            this.setTitleAndTips(conf);
            String areCustName = conf.getString("areacustname");
            ObjEvaluationUtils.cacheMustInputFieldInfo(this.getView(), conf, areCustName, AreaRegEnum.ATTACH_AREA, false);
            ObjEvaluationUtils.setInitFields(this.getView(), INDICATOR_INIT_FIELDS);
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            this.getView().setEnable(status == OperationStatus.VIEW ? Boolean.FALSE : Boolean.TRUE, new String[]{"entryentity"});
            Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
            ObjEvaluationUtils.dealPreNodeCarryInfo(this.getView(), status, taskId, AreaRegEnum.ATTACH_AREA, null);
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("columnResizeMode", "preset");
            this.getView().updateControlMetadata("entryentity", map);
            this.getView().getPageCache().put("page_load_finished_key", "true");
            this.setNotEditRowOfCross();
            this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector"});
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        finally {
            ObjEvaluationUtils.cacheBindingData(this.getView(), false);
        }
    }

    private void setNotEditRowOfCross() {
        ArrayList<Integer> canNotEditIndexList = new ArrayList<Integer>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity != null) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                boolean crossCanEdit;
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                if (entry == null || (crossCanEdit = entry.getBoolean("iscanedit"))) continue;
                canNotEditIndexList.add(i);
            }
            if (!canNotEditIndexList.isEmpty()) {
                int[] notEditIndexArr = new int[canNotEditIndexList.size()];
                for (int i = 0; i < canNotEditIndexList.size(); ++i) {
                    notEditIndexArr[i] = (Integer)canNotEditIndexList.get(i);
                }
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                grid.setRowLock(true, notEditIndexArr);
            }
        }
    }

    public void adjustTabelColOrder(DynamicObject conf) {
        Map<String, List<Map<String, Object>>> areaCateMap = this.getConfigColMapByCategory(conf);
        List<Map<String, Object>> allFieldList = this.getOrderedAllField(areaCateMap);
        List<GridConfigurationRow> beans = this.constructGridConfigBeans(allFieldList);
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        gridConfigDAO.saveGridConfig(this.getView().getFormShowParameter().getFormId(), "entryentity", beans);
        this.getView().updateView("entryentity");
    }

    public List<GridConfigurationRow> constructGridConfigBeans(List<Map<String, Object>> allFieldList) {
        ArrayList<GridConfigurationRow> beans = new ArrayList<GridConfigurationRow>();
        HashSet<String> visiableColSet = new HashSet<String>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        List fields = entryGrid.getFieldEdits();
        for (Map<String, Object> fieldMap : allFieldList) {
            String number;
            if (fieldMap == null || HRStringUtils.isBlank((CharSequence)(number = (String)fieldMap.get("number"))) || fields == null) continue;
            for (FieldEdit field : fields) {
                String key = field.getKey();
                if (!number.equals(key)) continue;
                String customerName = (String)fieldMap.get("customerName");
                LocaleString displayName = field.getProperty().getDisplayName();
                if (HRStringUtils.isBlank((CharSequence)customerName)) {
                    displayName = new LocaleString(customerName);
                }
                GridConfigurationRow bean = new GridConfigurationRow();
                bean.setColWidth(0);
                bean.setFreeze(false);
                bean.setHide(false);
                bean.setTextAlign("default");
                bean.setFieldKey(key);
                bean.setFieldName(displayName);
                beans.add(bean);
                visiableColSet.add(number);
            }
        }
        if (fields != null) {
            for (FieldEdit field : fields) {
                String key = field.getKey();
                if (visiableColSet.contains(key)) continue;
                GridConfigurationRow bean = new GridConfigurationRow();
                bean.setColWidth(0);
                bean.setFreeze(false);
                bean.setHide(true);
                bean.setTextAlign("default");
                bean.setFieldKey(key);
                bean.setFieldName(field.getProperty().getDisplayName());
                beans.add(bean);
            }
        }
        return beans;
    }

    public Map<String, List<Map<String, Object>>> getConfigColMapByCategory(DynamicObject conf) {
        HashMap<String, List<Map<String, Object>>> areaCateMap = new HashMap<String, List<Map<String, Object>>>(16);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        if (entryEntity != null) {
            for (DynamicObject configCol : entryEntity) {
                String fieldNumber = configCol.getString("areafield.number");
                String fieldCategory = configCol.getString("areafield.category");
                String fieldCustomerName = configCol.getString("fieldcustname");
                ArrayList fieldList = (ArrayList)areaCateMap.get(fieldCategory);
                if (fieldList == null) {
                    fieldList = new ArrayList(10);
                }
                HashMap<String, String> fieldMap = new HashMap<String, String>(16);
                if ("perfindctr".equals(fieldNumber)) {
                    fieldNumber = "indicator";
                }
                fieldMap.put("number", fieldNumber);
                fieldMap.put("customerName", fieldCustomerName);
                fieldList.add(fieldMap);
                areaCateMap.put(fieldCategory, fieldList);
            }
        }
        return areaCateMap;
    }

    public List<Map<String, Object>> getOrderedAllField(Map<String, List<Map<String, Object>>> areaCateMap) {
        List<Map<String, Object>> indicatorDesList = areaCateMap.get(RAREAFIELDREG_CATEGORY_INDICATORDES);
        List<Map<String, Object>> finishDesList = areaCateMap.get(RAREAFIELDREG_CATEGORY_FINISHDES);
        List<Map<String, Object>> scoreDesList = areaCateMap.get(RAREAFIELDREG_CATEGORY_SCOREDES);
        ArrayList<Map<String, Object>> otherList = new ArrayList<Map<String, Object>>(10);
        for (Map.Entry<String, List<Map<String, Object>>> next : areaCateMap.entrySet()) {
            List<Map<String, Object>> value;
            String key;
            if (next == null || RAREAFIELDREG_CATEGORY_INDICATORDES.equals(key = next.getKey()) || RAREAFIELDREG_CATEGORY_FINISHDES.equals(key) || RAREAFIELDREG_CATEGORY_SCOREDES.equals(key) || (value = next.getValue()) == null) continue;
            otherList.addAll(value);
        }
        ArrayList<Map<String, Object>> allFieldList = new ArrayList<Map<String, Object>>(10);
        this.addALLData(indicatorDesList, allFieldList);
        this.addALLData(finishDesList, allFieldList);
        this.addALLData(scoreDesList, allFieldList);
        this.addALLData(otherList, allFieldList);
        return allFieldList;
    }

    public void addALLData(List<Map<String, Object>> indicatorDesList, List<Map<String, Object>> allFieldList) {
        if (indicatorDesList != null) {
            allFieldList.addAll(indicatorDesList);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "syncindicator": {
                DynamicObjectCollection recordEntry = this.getModel().getEntryEntity("entryentity");
                APP_SERVICE.syncIndicatorInfo(recordEntry, AreaRegEnum.ATTACH_AREA, null);
                break;
            }
            case "submitvalid": {
                ObjEvaluationUtils.validateAreaMustEnterField(this.getView(), args);
                break;
            }
            case "save": {
                OperationResult operationResult = args.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess()) break;
                operationResult.setShowMessage(false);
                break;
            }
        }
    }

    private void initIndicatorEntry(FormShowParameter parameter) {
        Long areaId = (Long)parameter.getCustomParam("area");
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        DynamicObject[] indicatorDys = APP_SERVICE.queryIndicator(areaId, AreaRegEnum.ATTACH_AREA);
        boolean firstNodeAndRole = APP_SERVICE.isFirstNodeAndRole(taskId);
        if (firstNodeAndRole) {
            this.addEntryRowAndSetInitData(indicatorDys);
        } else {
            Map indEvalRecordMap = APP_SERVICE.queryIndEvalRecordOfPreRoleLastTaskNotCross(taskId, AreaRegEnum.ATTACH_AREA);
            this.addEntryRowAndSetInitData(indicatorDys, indEvalRecordMap);
        }
    }

    public void addEntryRowAndSetInitData(DynamicObject[] indicatorDys) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("indicator", new Object[0]);
        vs.addField("realfinishdate", new Object[0]);
        vs.addField("customfield", new Object[0]);
        for (DynamicObject indicator : indicatorDys) {
            if (indicator == null || indicator.getPkValue() == null || indicator.getLong("id") == 0L) continue;
            Object realfinishdate = indicator.get("realfinishdate");
            String customField = indicator.get("customfield") == null ? "" : indicator.get("customfield");
            vs.addRow(new Object[]{indicator.getPkValue(), realfinishdate, customField});
        }
        int count = vs.getCount();
        if (count > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void addEntryRowAndSetInitData(DynamicObject[] indicatorDys, Map<Long, DynamicObject> indEvalRecordMap) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("indicator", new Object[0]);
        vs.addField("realfinishdate", new Object[0]);
        vs.addField("customfield", new Object[0]);
        for (DynamicObject indicator : indicatorDys) {
            DynamicObject finishRecord;
            if (indicator == null || indicator.getPkValue() == null || indicator.getLong("id") == 0L) continue;
            Object realfinishdate = null;
            String customfield = "";
            if (indEvalRecordMap != null && (finishRecord = indEvalRecordMap.get(indicator.getPkValue())) != null) {
                realfinishdate = finishRecord.get("realfinishdate");
                customfield = finishRecord.get("customfield") == null ? "" : finishRecord.get("customfield");
            }
            vs.addRow(new Object[]{indicator.getPkValue(), realfinishdate, customfield});
        }
        int count = vs.getCount();
        if (count > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"collapsevector", "expandvector"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "collapsevector": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity", "collapsevector"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"expandvector"});
                break;
            }
            case "expandvector": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity", "collapsevector"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector"});
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (HRStringUtils.equals((String)"entryentity", (String)entryGrid.getKey())) {
            IFormView view = this.getView();
            IndicatorDetailUtils.showEmptyap(view, "attachAreaTitleCacheKey");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": {
                Long pkValue;
                OperationStatus status;
                long max = Integer.MAX_VALUE;
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                dataEntity.getDataEntityState().setDirtyFlags(new long[]{max});
                dataEntity.getDataEntityState().setBizChangeFlags(new long[]{max});
                DynamicObjectCollection recordEntry = dataEntity.getDynamicObjectCollection("entryentity");
                if (recordEntry != null) {
                    Date currDate = new Date();
                    for (int i = 0; i < recordEntry.size(); ++i) {
                        DynamicObject dynamicObject = (DynamicObject)recordEntry.get(i);
                        dynamicObject.set("indmodifytime", (Object)currDate);
                        dynamicObject.getDataEntityState().setDirtyFlags(new long[]{max});
                        dynamicObject.getDataEntityState().setBizChangeFlags(new long[]{max});
                    }
                }
                if (OperationStatus.EDIT != (status = this.getView().getFormShowParameter().getStatus()) || (pkValue = (Long)this.getView().getModel().getDataEntity().getPkValue()) != null && 0L != pkValue) break;
                Long areaId = (Long)this.getView().getFormShowParameter().getCustomParam("area");
                Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
                if (!APP_SERVICE.isExistsAreaRecordByTaskAndAreaId(taskId, areaId, AssessRuleConstants.ATTACH_AREA_PK)) break;
                APP_SERVICE.deleteAreaRecordByTaskAndAreaId(taskId, areaId, AssessRuleConstants.ATTACH_AREA_PK);
                APP_SERVICE.saveAreaRecord(dataEntity, AssessRuleConstants.ATTACH_AREA_PK);
                args.setCancel(true);
                break;
            }
        }
    }

    static {
        RULE_FILED_MAP.put("realfinishdate", "realfinishdateap");
        TIPS_FILED_LIST = new ArrayList<String>(16);
        TIPS_FILED_LIST.add("perfindctr");
        TIPS_FILED_LIST.add("keyactname");
        TIPS_FILED_LIST.add("keyacttype");
        TIPS_FILED_LIST.add("keyactnumber");
        TIPS_FILED_LIST.add("milestone");
        TIPS_FILED_LIST.add("yardstick");
        TIPS_FILED_LIST.add("planfinishdate");
        TIPS_FILED_LIST.add("remarks");
        TIPS_FILED_LIST.add("realfinishdate");
    }
}

