/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.area;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.utils.EvaluteDrawEntryEntityUtils;
import kd.opmc.epa.formplugin.web.utils.IndicatorDetailUtils;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.pbs.common.enums.FLowOpEnum;

public class CustomAreaEvalutionEdit
extends HRDataBaseEdit {
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private final AssessActivityApplicationService ACTIVITY_SERVICE = AssessActivityApplicationService.getInstance();
    private static final Log LOGGER = LogFactory.getLog(CustomAreaEvalutionEdit.class);
    private static final String[] AREA_INIT_FIELDS = new String[]{"areaconf", "actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc"};
    private static final String[] CUSTOM_AREA_ALL_FIELDS = new String[]{"customfield1", "customfield2", "customfield3", "customfield5", "customfield6", "customfield7", "customfield8", "customfield4", "customfield9", "customfield10"};
    private static final String[] CUSTOM_AREA_FIELDS = new String[]{"customfield1", "customfield2", "customfield3", "customfield5", "customfield6", "customfield7", "customfield8"};
    private static final String[] CUSTOM_AREA_ATTACHMENT_FIELDS = new String[]{"customfield4", "customfield9", "customfield10"};
    private static final int CUSTOM_FIELD_MAX_LENGTH = 1000;

    public void initialize() {
        super.initialize();
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryCustomConfigByPk(confId);
        if (conf != null) {
            String areaName = conf.getString("areacustname");
            this.getView().getPageCache().put("areaCustomerName", areaName);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryCustomConfigByPk(confId);
        EvaluteDrawEntryEntityUtils.drawCustomField(args, conf);
    }

    public void afterCreateNewData(EventObject e) {
        ObjEvaluationUtils.cacheBindingData(this.getView(), true);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        for (String initField : AREA_INIT_FIELDS) {
            Object fieldValue = parameter.getCustomParam(initField);
            if (fieldValue == null) continue;
            this.getModel().setValue(initField, fieldValue);
        }
        this.initIndicatorFormData();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ObjEvaluationUtils.cacheBindingData(this.getView(), true);
    }

    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
            DynamicObject conf = this.ACTIVITY_SERVICE.queryCustomConfigByPk(confId);
            if (conf != null) {
                String areaName = conf.getString("areacustname");
                this.getView().getPageCache().put("areaCustomerName", areaName);
            }
            this.setTitleAndTips(conf);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            this.initIndicatorForm(parameter);
            this.showIndicatorExistData();
            this.getView().getPageCache().put("page_load_finished_key", "true");
            this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector"});
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        finally {
            ObjEvaluationUtils.cacheBindingData(this.getView(), false);
        }
    }

    public void setTitleAndTips(DynamicObject conf) {
        Label titleLable = (Label)this.getView().getControl("areatitle");
        String areCustName = conf.getString("areacustname");
        titleLable.setText(areCustName);
        boolean isShowTips = false;
        String description = conf.getString("description");
        StringBuilder tipsBuilder = new StringBuilder();
        if (!HRStringUtils.isBlank((CharSequence)description)) {
            isShowTips = true;
            String descTit = ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a", (String)"CustomAreaEvalutionEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            tipsBuilder.append(descTit).append(description);
        }
        this.getView().getPageCache().put("customAreaTitleCacheKey", areCustName);
        if (isShowTips) {
            Tips tips = new Tips();
            tips.setTitle(null);
            tips.setTriggerType("hover");
            tips.setType("text");
            tips.setContent(new LocaleString(tipsBuilder.toString()));
            tips.setIconClassName("kdfont kdfont-guanlianxinxi");
            tips.setPlace("right");
            titleLable.addTips(tips);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        List<String> validateFieldsList = Arrays.asList(CUSTOM_AREA_FIELDS);
        if (validateFieldsList.contains(name) && e.getProperty() instanceof MuliLangTextProp) {
            LocaleDynamicObjectCollection newcols = (LocaleDynamicObjectCollection)changeData.getNewValue();
            LocaleDynamicObjectCollection oldcols = (LocaleDynamicObjectCollection)changeData.getOldValue();
            DynamicObjectType newDt = newcols.getDynamicObjectType();
            DynamicObjectType oldDt = oldcols.getDynamicObjectType();
            for (int i = 0; i < newcols.size(); ++i) {
                DynamicObject newObj = (DynamicObject)newcols.get(i);
                String newVal = (String)newDt.getProperty(e.getProperty().getName()).getValue((Object)newObj);
                if (newVal.length() <= 1000) continue;
                DynamicObject oldObj = (DynamicObject)oldcols.get(i);
                String oldVal = (String)oldDt.getProperty(e.getProperty().getName()).getValue((Object)oldObj);
                this.getView().getModel().setValue(name, (Object)new LocaleString(oldVal));
                this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u957f\u5ea6\u9700\u5c0f\u4e8e\u7b49\u4e8e1000\u3002", (String)"CustomAreaEvalutionEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{name}));
            }
        } else if (Arrays.asList(CUSTOM_AREA_ATTACHMENT_FIELDS).contains(name)) {
            MulBasedataDynamicObjectCollection newValue = (MulBasedataDynamicObjectCollection)changeData.getNewValue();
            MulBasedataDynamicObjectCollection oldValue = (MulBasedataDynamicObjectCollection)changeData.getOldValue();
            if (newValue.size() < oldValue.size()) {
                this.delPostNodeAttachments(name, newValue, oldValue);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "save": {
                this.saveUpdateCustomArea();
                OperationResult operationResult = args.getOperationResult();
                if (operationResult != null && operationResult.isSuccess()) {
                    operationResult.setShowMessage(false);
                }
                this.getView().getParentView().getModel().setValue("issaving", (Object)"false");
                this.getView().getParentView().updateView("issaving");
                break;
            }
            case "submitvalid": {
                this.validCustomAreaMustInputField(args);
                break;
            }
        }
    }

    private void saveUpdateCustomArea() {
        DynamicObject custObj = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        APP_SERVICE.saveUpdateCustomArea(custObj);
    }

    private void initIndicatorForm(FormShowParameter parameter) {
        Long confId = (Long)parameter.getCustomParam("confid");
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryCustomConfigByPk(confId);
        Map custAreaPermMap = APP_SERVICE.queryCustomAreaPerm(taskId, confId);
        ArrayList<String> confFiledsList = new ArrayList<String>(10);
        ArrayList<String> mustInputFieldList = new ArrayList<String>(10);
        if (conf != null) {
            String areaName = conf.getString("areacustname");
            this.getView().getPageCache().put("areaCustomerName", areaName);
            DynamicObjectCollection confFieldCols = conf.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < confFieldCols.size(); ++i) {
                DynamicObject fieldObj = (DynamicObject)confFieldCols.get(i);
                OrmLocaleValue fieldCustomLocaleName = (OrmLocaleValue)fieldObj.get("fieldcustname");
                String fieldtype = fieldObj.getString("fieldtype");
                String fieldNum = fieldObj.getString("areafield.number");
                String fieldName = fieldObj.getString("areafield.name");
                FieldEdit fieldAp = (FieldEdit)this.getView().getControl(fieldNum);
                if (fieldCustomLocaleName != null) {
                    fieldAp.setCaption(new LocaleString(fieldCustomLocaleName.getLocaleValue()));
                } else {
                    fieldAp.setCaption(new LocaleString(fieldName));
                }
                Map fieldMap = (Map)custAreaPermMap.get(fieldNum);
                if (fieldMap != null) {
                    Boolean fielddisplayitem = (Boolean)fieldMap.get("fielddisplayitem");
                    Boolean fieldmustinputitem = (Boolean)fieldMap.get("fieldmustinputitem");
                    Boolean fieldmodifyitem = (Boolean)fieldMap.get("fieldmodifyitem");
                    if (parameter.getStatus() != OperationStatus.VIEW) {
                        this.getView().setEnable(fieldmodifyitem, new String[]{fieldNum});
                    }
                    this.getView().setVisible(fielddisplayitem, new String[]{fieldNum});
                    FieldEdit fieldEdit = (FieldEdit)this.getControl(fieldNum);
                    fieldEdit.setMustInput(fieldmustinputitem.booleanValue());
                    if (fieldmustinputitem.booleanValue()) {
                        mustInputFieldList.add(fieldNum);
                    }
                }
                confFiledsList.add(fieldNum);
            }
            List<String> notConfFiledsList = Arrays.asList(CUSTOM_AREA_ALL_FIELDS).stream().filter(element -> !confFiledsList.contains(element)).collect(Collectors.toList());
            if (!notConfFiledsList.isEmpty()) {
                String[] hideFields = notConfFiledsList.toArray(new String[notConfFiledsList.size()]);
                this.getView().setVisible(Boolean.FALSE, hideFields);
            }
            if (mustInputFieldList.size() > 0) {
                this.cacheMustInputFields(mustInputFieldList, conf);
            }
        }
    }

    private void cacheMustInputFields(List<String> mustInputFieldList, DynamicObject conf) {
        String entityId;
        IFormView parentsView = this.getView().getParentView().getParentView();
        if (parentsView != null && HRStringUtils.equals((String)(entityId = parentsView.getEntityId()), (String)"epa_actevalobj_eval_multi")) {
            String confId = String.valueOf(conf.getPkValue());
            parentsView.getPageCache().put("CUSTAREAMUST_" + confId, JSON.toJSONString(mustInputFieldList));
        }
    }

    private void showIndicatorExistData() {
        DynamicObject indicatorDy;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)parameter.getCustomParam("flowrutask");
        DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
        boolean isrollbacked = taskObj.getBoolean("isrollbacked");
        Long confId = (Long)parameter.getCustomParam("confid");
        if (taskId != null && !ObjectUtils.isEmpty((Object)(indicatorDy = APP_SERVICE.queryCustomAreaEvalRecordByConfId(taskId, confId)))) {
            HashMap preAttachmentMap = new HashMap(16);
            HashMap<String, ILocaleString> preCustomInfoMap = new HashMap<String, ILocaleString>(16);
            Long preRoleTaskId = APP_SERVICE.queryPreRoleOfNoCrossLastTask(taskId);
            if (preRoleTaskId != null) {
                String fieldKey;
                int i;
                DynamicObject preIndicatorDy = APP_SERVICE.queryCustomAreaEvalRecordByConfId(preRoleTaskId, confId);
                if (preIndicatorDy != null) {
                    Date curModifyTime = indicatorDy.getDate("modifytime");
                    Date preModifyTime = preIndicatorDy.getDate("modifytime");
                    if (!isrollbacked && curModifyTime != null && preModifyTime != null && curModifyTime.before(preModifyTime)) {
                        String fieldKey2;
                        int i2;
                        for (i2 = 0; i2 < CUSTOM_AREA_FIELDS.length; ++i2) {
                            fieldKey2 = CUSTOM_AREA_FIELDS[i2];
                            preCustomInfoMap.put(fieldKey2, preIndicatorDy.getLocaleString(fieldKey2));
                        }
                        for (i2 = 0; i2 < CUSTOM_AREA_ATTACHMENT_FIELDS.length; ++i2) {
                            fieldKey2 = CUSTOM_AREA_ATTACHMENT_FIELDS[i2];
                            QFilter qFilter = new QFilter("id", "=", (Object)preIndicatorDy.getLong("id"));
                            DynamicObject attachments = BusinessDataServiceHelper.loadSingle((String)"epa_objcustomareains", (String)("id," + fieldKey2), (QFilter[])new QFilter[]{qFilter});
                            DynamicObjectCollection sourceAttachcol = (DynamicObjectCollection)attachments.get(fieldKey2);
                            ArrayList attchIdList = new ArrayList(10);
                            sourceAttachcol.forEach(attach -> {
                                DynamicObject attachObj = attach.getDynamicObject("fbasedataId");
                                if (attachObj != null) {
                                    attchIdList.add(attachObj.getLong("id"));
                                }
                            });
                            preAttachmentMap.put(fieldKey2, attchIdList);
                        }
                    }
                }
                for (i = 0; i < CUSTOM_AREA_FIELDS.length; ++i) {
                    fieldKey = CUSTOM_AREA_FIELDS[i];
                    ILocaleString customAreaInfo = indicatorDy.getLocaleString(fieldKey);
                    if (preCustomInfoMap.get(fieldKey) != null) {
                        customAreaInfo = (ILocaleString)preCustomInfoMap.get(fieldKey);
                    }
                    this.getView().getModel().setValue(fieldKey, (Object)customAreaInfo);
                }
                for (i = 0; i < CUSTOM_AREA_ATTACHMENT_FIELDS.length; ++i) {
                    List preAttachmentList;
                    fieldKey = CUSTOM_AREA_ATTACHMENT_FIELDS[i];
                    ArrayList attchIdSet = new ArrayList();
                    QFilter qFilter = new QFilter("id", "=", (Object)indicatorDy.getLong("id"));
                    DynamicObject attachments = BusinessDataServiceHelper.loadSingle((String)"epa_objcustomareains", (String)("id," + fieldKey), (QFilter[])new QFilter[]{qFilter});
                    DynamicObjectCollection sourceAttachcol = (DynamicObjectCollection)attachments.get(fieldKey);
                    sourceAttachcol.forEach(attach -> {
                        DynamicObject attachObj = attach.getDynamicObject("fbasedataId");
                        if (attachObj != null) {
                            attchIdSet.add(attachObj.getLong("id"));
                        }
                    });
                    if (!isrollbacked && !CollectionUtils.isEmpty((Collection)(preAttachmentList = (List)preAttachmentMap.get(fieldKey)))) {
                        attchIdSet.clear();
                        attchIdSet.addAll(preAttachmentList);
                    }
                    this.getView().getModel().setValue(fieldKey, (Object)attchIdSet.toArray());
                    this.getView().updateView(fieldKey);
                }
            }
        }
    }

    private void initIndicatorFormData() {
        DynamicObject indicatorDy;
        Long preRoleTaskId;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        Long confId = (Long)parameter.getCustomParam("confid");
        OperationStatus status = parameter.getStatus();
        if (status == OperationStatus.VIEW) {
            this.getView().setEnable(Boolean.FALSE, CUSTOM_AREA_ALL_FIELDS);
        }
        if ((preRoleTaskId = APP_SERVICE.queryPreRoleOfNoCrossLastTask(taskId)) != null && !ObjectUtils.isEmpty((Object)(indicatorDy = APP_SERVICE.queryCustomAreaEvalRecordByConfId(preRoleTaskId, confId)))) {
            String fieldKey;
            int i;
            for (i = 0; i < CUSTOM_AREA_FIELDS.length; ++i) {
                fieldKey = CUSTOM_AREA_FIELDS[i];
                this.getView().getModel().setValue(fieldKey, (Object)indicatorDy.getLocaleString(fieldKey));
            }
            for (i = 0; i < CUSTOM_AREA_ATTACHMENT_FIELDS.length; ++i) {
                fieldKey = CUSTOM_AREA_ATTACHMENT_FIELDS[i];
                QFilter qFilter = new QFilter("id", "=", (Object)indicatorDy.getLong("id"));
                DynamicObject attachments = BusinessDataServiceHelper.loadSingle((String)"epa_objcustomareains", (String)("id," + fieldKey), (QFilter[])new QFilter[]{qFilter});
                DynamicObjectCollection sourceAttachcol = (DynamicObjectCollection)attachments.get(fieldKey);
                ArrayList attchIdSet = new ArrayList();
                sourceAttachcol.forEach(attach -> {
                    DynamicObject attachObj = attach.getDynamicObject("fbasedataId");
                    if (attachObj != null) {
                        attchIdSet.add(attachObj.getLong("id"));
                    }
                });
                this.getView().getModel().setValue(fieldKey, (Object)attchIdSet.toArray());
                this.getView().updateView(fieldKey);
            }
        }
    }

    private void validCustomAreaMustInputField(AfterDoOperationEventArgs args) {
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryCustomConfigByPk(confId);
        String areaName = conf.getString("areacustname");
        DynamicObjectCollection confFieldCols = conf.getDynamicObjectCollection("entryentity");
        Map<String, String> fieldNameMap = confFieldCols.stream().collect(Collectors.toMap(x -> x.getString("areafield.number"), y -> y.getString("fieldcustname")));
        OperationResult operationResult = args.getOperationResult();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        Map custAreaPermMap = APP_SERVICE.queryCustomAreaPerm(taskId, confId);
        ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();
        int errIndex = 1;
        for (int i = 0; i < confFieldCols.size(); ++i) {
            OperateErrorInfo operateErrorInfo;
            Boolean fieldmustinputitem;
            DynamicObject fieldObj = (DynamicObject)confFieldCols.get(i);
            String fieldNum = fieldObj.getString("areafield.number");
            Object value = this.getModel().getValue(fieldNum);
            Map fieldMap = (Map)custAreaPermMap.get(fieldNum);
            if (fieldMap == null || !(fieldmustinputitem = (Boolean)fieldMap.get("fieldmustinputitem")).booleanValue()) continue;
            if (HRObjectUtils.isEmpty((Object)value)) {
                operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Warning);
                operateErrorInfo.setMessage(ResManager.loadKDString((String)"{0}. {1}\u5b58\u5728\u8bc4\u4ef7\u9879\u672a\u586b\u5199\u3002", (String)"CustomAreaEvalutionEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{errIndex++, fieldNameMap.get(fieldNum)}));
                errorInfoList.add(operateErrorInfo);
                continue;
            }
            if (!(value instanceof MulBasedataDynamicObjectCollection) || !((MulBasedataDynamicObjectCollection)value).isEmpty()) continue;
            operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Warning);
            operateErrorInfo.setMessage(ResManager.loadKDString((String)"{0}. {1}\u5b58\u5728\u9644\u4ef6\u9879\u672a\u4e0a\u4f20\u3002", (String)"CustomAreaEvalutionEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{errIndex++, fieldNameMap.get(fieldNum)}));
            errorInfoList.add(operateErrorInfo);
        }
        operationResult.setMessage(areaName);
        operationResult.setSuccess(ObjectUtils.isEmpty(errorInfoList));
        operationResult.setAllErrorInfo(errorInfoList);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"conentpanel"});
        this.addClickListeners(new String[]{"collapsevector", "expandvector"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "conentpanel": {
                IFormView view = this.getView();
                IndicatorDetailUtils.showEmptyap(view, "customAreaTitleCacheKey");
                break;
            }
            case "collapsevector": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"custompanelap", "collapsevector"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"expandvector"});
                break;
            }
            case "expandvector": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"custompanelap", "collapsevector"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector"});
            }
        }
    }

    private void delPostNodeAttachments(String name, MulBasedataDynamicObjectCollection newValue, MulBasedataDynamicObjectCollection oldValue) {
        DynamicObject[] customAreaColl;
        DynamicObject[] flowRuNodeColl;
        DynamicObject basedataInfo;
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        boolean isRollBack = APP_SERVICE.judgeTaskIsExitTargetFlowOp(taskId, FLowOpEnum.ROLLBACK);
        if (!isRollBack) {
            return;
        }
        ArrayList<String> delUidList = new ArrayList<String>(10);
        for (DynamicObject dynamicObject : oldValue) {
            basedataInfo = dynamicObject.getDynamicObject("fbasedataId");
            delUidList.add(basedataInfo.getString("uid"));
        }
        for (DynamicObject dynamicObject : newValue) {
            basedataInfo = dynamicObject.getDynamicObject("fbasedataId");
            String uid = basedataInfo.getString("uid");
            delUidList.remove(uid);
        }
        AttachmentEdit control = (AttachmentEdit)this.getControl(name);
        String tableName = control.getTableName();
        ArrayList<Long> areaIdList = new ArrayList<Long>(10);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long flowruproc = (Long)customParams.get("flowruproc");
        Long flowrunode = (Long)customParams.get("flowrunode");
        DynamicObject curNodeInfo = BusinessDataServiceHelper.loadSingle((Object)flowrunode, (String)"pbs_flowrunode", (String)"id,index");
        int curIndex = curNodeInfo.getInt("index");
        ArrayList<Long> flowRuNodeIdList = new ArrayList<Long>(4);
        for (DynamicObject dynamicObject : flowRuNodeColl = BusinessDataServiceHelper.load((String)"pbs_flowrunode", (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"flowruproc = ? and index > ?", (Object[])new Object[]{flowruproc, curIndex})})) {
            flowRuNodeIdList.add(dynamicObject.getLong("id"));
        }
        for (DynamicObject dynamicObject : customAreaColl = BusinessDataServiceHelper.load((String)"epa_objcustomareains", (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"flowruproc = ?", (Object[])new Object[]{flowruproc}), new QFilter("flowrunode", "in", flowRuNodeIdList)})) {
            long areaId = dynamicObject.getLong("id");
            areaIdList.add(areaId);
        }
        String uid = (String)delUidList.get(0);
        for (Long billPkId : areaIdList) {
            HashMap<String, Object> attachments = new HashMap<String, Object>(2);
            attachments.put("uid", uid);
            attachments.put("billPkId", billPkId);
            AttachmentFieldServiceHelper.removeAttachments((String)"epa_objcustomareains", (String)tableName, attachments);
        }
    }
}

