/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.area;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.common.enums.activitymanage.EvaluatingProcessTaskEnum;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.model.RollbackParamBo;

public class EvalBackConfirmDynamicPlugin
extends AbstractFormPlugin {
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    public static final String BTNOK = "btnok";
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final Log LOG = LogFactory.getLog(EvalBackConfirmDynamicPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnok": {
                this.rollbackEvaTask();
                break;
            }
        }
    }

    public boolean checkMustInput() {
        boolean hasError = false;
        String reason = this.getView().getModel().getDataEntity().getString("reason");
        if (HRStringUtils.isBlank((CharSequence)reason)) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9000\u56de\u539f\u56e0\u3002", (String)"EvalBackConfirmDynamicPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            hasError = true;
        } else if (reason.length() > 255) {
            String tips = ResManager.loadKDString((String)"\u201c\u9000\u56de\u539f\u56e0\u201d\u5b57\u6bb5\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\uff0c\u6700\u5927\u957f\u5ea6[0,255]\u3002", (String)"EvalBackConfirmDynamicPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            hasError = true;
        }
        return hasError;
    }

    public EvaluatingProcessTaskEnum checkTaskStatus(List<Long> taskIdList) {
        DynamicObject[] ruTasks = FLOW_RU_PROC_APPLICATION_SERVICE.queryNoOperateTasksById(taskIdList);
        if (ruTasks != null) {
            for (DynamicObject task : ruTasks) {
                if (task == null) continue;
                String taskStatus = task.getString("taskstatus");
                EvaluatingProcessTaskEnum evalTaskEnum = EvaluatingProcessTaskEnum.getEvaluatingProcessTaskEnum((String)taskStatus);
                return evalTaskEnum;
            }
        }
        return null;
    }

    public void rollbackEvaTask() {
        boolean indicatorChangeOfCross;
        List batchTaskList;
        List mergeTaskIds;
        if (this.checkMustInput()) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskId = (String)formShowParameter.getCustomParam("taskId");
        if (HRStringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        Long taskIdLong = Long.parseLong(taskId);
        String taskIndCountMapStr = (String)formShowParameter.getCustomParam("taskIndCountMapStr");
        String mergeTaskIdsStr = (String)formShowParameter.getCustomParam("mergeTaskIdsStr");
        ArrayList<Long> crossTaskIdList = new ArrayList<Long>(10);
        crossTaskIdList.add(taskIdLong);
        if (!HRStringUtils.isBlank((CharSequence)mergeTaskIdsStr) && (mergeTaskIds = (batchTaskList = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class)).stream().flatMap(Collection::stream).collect(Collectors.toList())) != null) {
            crossTaskIdList.addAll(mergeTaskIds);
        }
        if (indicatorChangeOfCross = ObjEvaluationUtils.isIndicatorChangeOfCross(taskIndCountMapStr, crossTaskIdList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6307\u6807\u6570\u636e\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"EvalBackConfirmDynamicPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        List batchTaskList2 = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
        List<Long> taskList = batchTaskList2.stream().flatMap(Collection::stream).collect(Collectors.toList());
        String reason = this.getView().getModel().getDataEntity().getString("reason");
        EvaluatingProcessTaskEnum taskStatusEnum = this.checkTaskStatus(taskList);
        if (taskStatusEnum != null) {
            String tips = "";
            tips = EvaluatingProcessTaskEnum.RETURNED == taskStatusEnum ? ResManager.loadKDString((String)"\u9000\u56de\u5931\u8d25,\u4efb\u52a1\u5df2\u88ab\u4ed6\u4eba\u64cd\u4f5c\u9000\u56de", (String)"EvalBackConfirmDynamicPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9000\u56de\u5931\u8d25\uff0c\u4efb\u52a1{0}\u3002", (String)"EvalBackConfirmDynamicPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{taskStatusEnum.getText()});
            if (this.getView().getParentView().getParentView() != null) {
                String parentViewEntityId = this.getView().getParentView().getParentView().getEntityId();
                if ("epa_actevalobj_eval_multi".equals(parentViewEntityId)) {
                    IFormView gradParentView = this.getView().getParentView().getParentView();
                    gradParentView.showErrorNotification(tips);
                    gradParentView.getPageCache().put("isEmptyPage", "true");
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    gradParentView.invokeOperation("refresh", option);
                    gradParentView.getPageCache().put("isEmptyPage", "false");
                    this.getView().sendFormAction(gradParentView);
                } else {
                    this.getView().getParentView().showErrorNotification(tips);
                }
            } else {
                this.getView().getParentView().showErrorNotification(tips);
            }
            boolean release = MutexHelper.release((String)"epa_actevalobj_eval", (String)"nodeview", (String)taskId);
            LOG.info("acteval mutex release taskid:{},release:{}", (Object)taskId, (Object)release);
            if (crossTaskIdList != null) {
                for (Long taskIDTmp : crossTaskIdList) {
                    if (taskIDTmp == null) continue;
                    boolean release1 = MutexHelper.release((String)"epa_actevalobj_eval", (String)"nodeview", (String)taskIDTmp.toString());
                    LOG.info("acteval mutex release taskid:{},release:{}", (Object)taskIDTmp.toString(), (Object)release1);
                }
            }
            this.getView().getParentView().setStatus(OperationStatus.VIEW);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            this.getView().getParentView().invokeOperation("refresh", option);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        } else {
            List<RollbackParamBo> rollbackParamBo = this.assembleRollbackParam(batchTaskList2);
            FlowValidateResultBo resultBo = APP_SERVICE.rollbackToLastNodeOrRole(rollbackParamBo);
            if (resultBo != null) {
                String resultBoCode = resultBo.getCode();
                if ("-1".equals(resultBoCode)) {
                    Map validateMap = resultBo.getValidateMap();
                    if (validateMap != null && !validateMap.isEmpty() && !HRStringUtils.isBlank((CharSequence)((CharSequence)validateMap.get(taskIdLong)))) {
                        String msg = (String)validateMap.get(taskIdLong);
                        this.getView().getParentView().showErrorNotification(msg);
                    } else {
                        String message = resultBo.getMessage();
                        this.getView().getParentView().showErrorNotification(message);
                    }
                } else if ("1".equals(resultBoCode)) {
                    String tips = ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f", (String)"EvalBackConfirmDynamicPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    if (this.getView().getParentView().getParentView() != null) {
                        String parentViewEntityId = this.getView().getParentView().getParentView().getEntityId();
                        if ("epa_actevalobj_eval_multi".equals(parentViewEntityId)) {
                            IFormView gradParentView = this.getView().getParentView().getParentView();
                            gradParentView.showSuccessNotification(tips);
                            gradParentView.getPageCache().put("isEmptyPage", "true");
                            OperateOption option = OperateOption.create();
                            option.setVariableValue("ishasright", "true");
                            gradParentView.invokeOperation("refresh", option);
                            gradParentView.getPageCache().put("isEmptyPage", "false");
                            this.getView().sendFormAction(gradParentView);
                        } else {
                            this.getView().getParentView().showSuccessNotification(tips);
                        }
                    } else {
                        this.getView().getParentView().showSuccessNotification(tips);
                    }
                    boolean release = MutexHelper.release((String)"epa_actevalobj_eval", (String)"nodeview", (String)taskId);
                    LOG.info("acteval mutex release taskid:{},release:{}", (Object)taskId, (Object)release);
                    if (crossTaskIdList != null) {
                        for (Long taskIDTmp : crossTaskIdList) {
                            if (taskIDTmp == null) continue;
                            boolean release1 = MutexHelper.release((String)"epa_actevalobj_eval", (String)"nodeview", (String)taskIDTmp.toString());
                            LOG.info("acteval mutex release taskid:{},release:{}", (Object)taskIDTmp.toString(), (Object)release1);
                        }
                    }
                    this.getView().getParentView().setStatus(OperationStatus.VIEW);
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    this.getView().getParentView().invokeOperation("refresh", option);
                    this.getView().sendFormAction(this.getView().getParentView());
                    this.getView().close();
                }
            }
        }
    }

    private List<RollbackParamBo> assembleRollbackParam(List<List<Long>> taskIdList) {
        String reason = this.getView().getModel().getDataEntity().getString("reason");
        ArrayList<RollbackParamBo> rollbackParamBoList = new ArrayList<RollbackParamBo>(10);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long ruProcId = (Long)formShowParameter.getCustomParam("ruProcId");
        Long ruNodeId = (Long)formShowParameter.getCustomParam("ruNodeId");
        List<Long> firstTaskList = taskIdList.get(0);
        for (int i = 0; i < taskIdList.size(); ++i) {
            List<Long> mergeTaskIds = taskIdList.get(0);
            RollbackParamBo rollbackParamBo = new RollbackParamBo();
            rollbackParamBo.setRuProcId(ruProcId);
            rollbackParamBo.setRuNodeId(ruNodeId);
            rollbackParamBo.setRollbackType("2");
            if (firstTaskList.size() > 1) {
                rollbackParamBo.setMergeTask(Boolean.valueOf(true));
                rollbackParamBo.setMergeTaskIds(mergeTaskIds);
            } else {
                rollbackParamBo.setMergeTask(Boolean.valueOf(false));
                rollbackParamBo.setRuTaskId(mergeTaskIds.get(0));
            }
            rollbackParamBo.setReason(reason);
            rollbackParamBoList.add(rollbackParamBo);
        }
        return rollbackParamBoList;
    }
}

