/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.area;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.evaluating.entity.ActEvalIndFieldItemTipsDto;
import kd.opmc.epa.business.domain.evaluating.entity.ActEvalIndFieldTipsDto;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.business.domain.evaluating.entity.IndicatorEvalRecordBo;
import kd.opmc.epa.business.utils.NumberValidateUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.assessrule.AdjustTypeEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.IsValidateScoreService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.impl.IsValidateScoreServiceImpl;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.utils.EvaluteDrawEntryEntityUtils;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.epa.formplugin.web.utils.IndicatorDetailUtils;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.pbs.business.model.NodeRoleConfigBo;

public class GenAreaEvaluationEdit
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final Log LOGGER = LogFactory.getLog(GenAreaEvaluationEdit.class);
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    public static final String RAREAFIELDREG_CATEGORY_INDICATORDES = "10";
    public static final String AREATITLE = "areatitle";
    public static final char RANGE_GUID = '~';
    public static final char LEFT_MID = '[';
    public static final char RIGHT_MID = ']';
    public static final String NUM_STR_2 = "2";
    private final AssessActivityApplicationService ACTIVITY_SERVICE = AssessActivityApplicationService.getInstance();
    private static final String[] AREA_INIT_FIELDS = new String[]{"actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc", "area"};
    private static final String[] INDICATOR_INIT_FIELDS = new String[]{"actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc", "area"};
    private static final String[] MERGE_IND_FIELDS = new String[]{"flowrunode", "flowrurole", "flowrutask", "flowruproc"};
    private static String[] SET_STRING_FIELDS = new String[]{"customfiled1", "customfiled2", "customfiled3", "customfiled4", "customfiled5", "qualityres", "finishdesc"};
    private static String[] SETSTRINGFIELDS_CUS = new String[]{"customfiled1", "customfiled2", "customfiled3", "customfiled4", "customfiled5", "qualityres", "finishdesc"};

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryNormalConfigByPk(confId);
        Map<String, List<String>> areaCateMap = this.getConfigColKeyMapByCategory(conf);
        List<String> indicatorDesList = areaCateMap.get(RAREAFIELDREG_CATEGORY_INDICATORDES);
        if (indicatorDesList == null) {
            indicatorDesList = new ArrayList<String>(10);
        }
        indicatorDesList.remove("indctrname");
        indicatorDesList.remove("weight");
        indicatorDesList.remove("indctrscore");
        boolean openReverse = ObjEvaluationUtils.isOpenAdjustScore(conf);
        if (openReverse) {
            String scoreCalcWay = (String)formShowParameter.getCustomParam("scorecalcway");
            if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
                indicatorDesList.add("indctrscore");
            }
        }
        String[] ignoreFields = indicatorDesList.toArray(new String[indicatorDesList.size()]);
        List<ContentFieldEntryEvaDto> fieldEntryEvaDtos = ObjEvaluationUtils.getPermFieldSetting(formShowParameter);
        EvaluteDrawEntryEntityUtils.customDrawArea(args, conf, ignoreFields, AssessRuleConstants.NORM_INDCTR_AREA_PK, fieldEntryEvaDtos);
    }

    public void updateNotAllowEvalSoeNull2Zero() {
        DynamicObjectCollection entryEntity;
        String isAllowEvalStr = this.getView().getPageCache().get("IS_ALLOW_EVAL_AREA");
        boolean isAllowSoe = true;
        if (!HRStringUtils.isBlank((CharSequence)isAllowEvalStr)) {
            isAllowSoe = Boolean.parseBoolean(isAllowEvalStr);
        } else {
            Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
            DynamicObject conf = this.ACTIVITY_SERVICE.queryNormalConfigByPk(confId);
            if (conf != null) {
                isAllowSoe = conf.getBoolean("isalloweval");
                this.getView().getPageCache().put("IS_ALLOW_EVAL_AREA", String.valueOf(isAllowSoe));
            }
        }
        if (!isAllowSoe && (entryEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity")) != null) {
            for (DynamicObject entry : entryEntity) {
                Object o;
                if (entry == null || (o = entry.get("soe")) != null) continue;
                entry.set("soe", (Object)BigDecimal.ZERO);
            }
        }
    }

    public void initialize() {
        super.initialize();
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryNormalConfigByPk(confId);
        if (conf != null) {
            BigDecimal areaScore;
            BigDecimal areaWeight;
            boolean isPartIn = conf.getBoolean("ispartin");
            boolean isAllowEval = conf.getBoolean("isalloweval");
            if (!isAllowEval) {
                this.getView().getPageCache().put("isPartInStr", "false");
            } else {
                this.getView().getPageCache().put("isPartInStr", String.valueOf(isPartIn));
            }
            String areaName = conf.getString("areacustname");
            this.getView().getPageCache().put("IS_ALLOW_EVAL_AREA", String.valueOf(isAllowEval));
            this.getView().getPageCache().put("areaCustomerName", areaName);
            String weightStr = "";
            DynamicObject genAreaIns = ObjEvaluationUtils.getObjGenAreaIns(this.getView());
            if (genAreaIns != null && (areaWeight = genAreaIns.getBigDecimal("areaweight")) != null) {
                weightStr = areaWeight.stripTrailingZeros().toPlainString();
            }
            this.getView().getPageCache().put("areaWeightCache", weightStr);
            String areaScoreStr = "";
            if (genAreaIns != null && (areaScore = genAreaIns.getBigDecimal("areascore")) != null) {
                areaScoreStr = areaScore.stripTrailingZeros().toPlainString();
            }
            this.getView().getPageCache().put("areaScoreCache", areaScoreStr);
        }
    }

    public void afterCreateNewData(EventObject e) {
        ObjEvaluationUtils.cacheBindingData(this.getView(), true);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        for (String initField : AREA_INIT_FIELDS) {
            Object fieldValue = parameter.getCustomParam(initField);
            if (fieldValue == null) continue;
            this.getModel().setValue(initField, fieldValue);
        }
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryNormalConfigByPk(confId);
        this.initIndicatorEntry(parameter, conf);
        this.initBeforeAdjustVal(conf);
        this.addImportIndicators();
        this.notEditImpIndicators();
        this.calculateAfterJustVal(conf);
        this.updateNotAllowEvalSoeNull2Zero();
        ObjEvaluationUtils.calculateSSR(this.getView(), APP_SERVICE.queryTaskWeight((Long)parameter.getCustomParam("flowrutask")), false);
        this.getView().getPageCache().put("isFirstLoad", "true");
    }

    public void putTipsForSoe(DynamicObject conf) {
        boolean isAllowEval = conf.getBoolean("isalloweval");
        if (isAllowEval) {
            ActEvalIndFieldTipsDto actEvalIndFieldTipsDto = new ActEvalIndFieldTipsDto();
            actEvalIndFieldTipsDto.setTitle(ResManager.loadKDString((String)"\u5206\u6570\u9650\u5236", (String)"GenAreaEvaluationEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            String scoreCalcWay = (String)this.getView().getFormShowParameter().getCustomParam("scorecalcway");
            List<Object> tipsList = new ArrayList(10);
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                boolean consistentWithArea = ObjEvaluationUtils.isConsistentWithArea(this.getView(), ObjEvaluationUtils.getAreaScoreSystemId(conf));
                if (consistentWithArea) {
                    DynamicObject scoreSystem = this.getScoreSystem();
                    tipsList = this.getScoreTipsContent(scoreSystem);
                } else {
                    DynamicObject areaScoreSystem = this.ACTIVITY_SERVICE.queryScoreSystemById(Long.valueOf(ObjEvaluationUtils.getAreaScoreSystemId(conf)));
                    tipsList = this.getScoreTipsContent(areaScoreSystem);
                }
            } else if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                ArrayList<ActEvalIndFieldItemTipsDto> actEvalIndFieldItemTipsDtos = new ArrayList<ActEvalIndFieldItemTipsDto>(10);
                for (DynamicObject dynamicObject : entryEntity) {
                    BigDecimal indicatorScore = dynamicObject.getBigDecimal("indicator.indctrscore") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("indicator.indctrscore");
                    String name = dynamicObject.getString("indicator.indctrname");
                    indicatorScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), indicatorScore);
                    String maxStr = indicatorScore.toPlainString();
                    BigDecimal zero = BigDecimal.ZERO;
                    zero = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), zero);
                    ActEvalIndFieldItemTipsDto actEvalIndFieldItemTipsDto = new ActEvalIndFieldItemTipsDto(name, String.format("[%s ~ %s]", zero.toPlainString(), maxStr));
                    actEvalIndFieldItemTipsDtos.add(actEvalIndFieldItemTipsDto);
                }
                tipsList = actEvalIndFieldItemTipsDtos;
            }
            actEvalIndFieldTipsDto.setActEvalIndFieldItemTipsList(tipsList);
            this.getView().getPageCache().put("actEvalIndFieldTips", JSON.toJSONString((Object)actEvalIndFieldTipsDto));
            boolean openReverse = ObjEvaluationUtils.isOpenAdjustScore(conf);
            if (!openReverse) {
                this.setFieldTips(actEvalIndFieldTipsDto, "soe");
            }
        }
    }

    private void setFieldTips(ActEvalIndFieldTipsDto actEvalIndFieldTipsDto, String fieldKey) {
        if (actEvalIndFieldTipsDto == null) {
            return;
        }
        StringBuilder content = new StringBuilder();
        List actEvalIndFieldItemTipsDtos = actEvalIndFieldTipsDto.getActEvalIndFieldItemTipsList();
        if (actEvalIndFieldItemTipsDtos != null) {
            for (ActEvalIndFieldItemTipsDto actEvalIndFieldItemTipsDto : actEvalIndFieldItemTipsDtos) {
                String name = actEvalIndFieldItemTipsDto.getName();
                String value = actEvalIndFieldItemTipsDto.getValue();
                content.append(name).append(" : ").append(value).append("\n");
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            Tips tips = new Tips();
            if (HRStringUtils.equals((String)fieldKey, (String)"soe")) {
                tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u5206\u6570\u9650\u5236", (String)"GenAreaEvaluationEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
            } else if (HRStringUtils.equals((String)fieldKey, (String)"adjustval")) {
                tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8bc4\u5206\u8303\u56f4", (String)"GenAreaEvaluationEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
            }
            tips.setTriggerType("hover");
            tips.setType("text");
            tips.setContent(new LocaleString(content.toString()));
            tips.setIconClassName("kdfont kdfont-guanlianxinxi");
            tips.setPlace("right");
            entryGrid.setColumnProperty(fieldKey, "tips", (Object)tips);
        }
    }

    private List<ActEvalIndFieldItemTipsDto> getScoreTipsContent(DynamicObject scoreSystem) {
        ArrayList<ActEvalIndFieldItemTipsDto> actEvalIndFieldItemTipsDtos = new ArrayList<ActEvalIndFieldItemTipsDto>(10);
        BigDecimal minScore = scoreSystem.getBigDecimal("minscore") == null ? BigDecimal.ZERO : scoreSystem.getBigDecimal("minscore");
        BigDecimal maxScore = scoreSystem.getBigDecimal("maxscore") == null ? BigDecimal.ZERO : scoreSystem.getBigDecimal("maxscore");
        minScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), minScore);
        String minStr = minScore.toPlainString();
        maxScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), maxScore);
        String maxStr = maxScore.toPlainString();
        String msgTips = ResManager.loadKDString((String)"\u6240\u6709\u6307\u6807\u8bc4\u5206\u8303\u56f4", (String)"GenAreaEvaluationEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        ActEvalIndFieldItemTipsDto actEvalIndFieldItemTipsDto = new ActEvalIndFieldItemTipsDto(msgTips, String.format("[%s ~ %s]", minStr, maxStr));
        actEvalIndFieldItemTipsDtos.add(actEvalIndFieldItemTipsDto);
        return actEvalIndFieldItemTipsDtos;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ObjEvaluationUtils.cacheBindingData(this.getView(), true);
        this.freezeEntryCol();
    }

    private void freezeEntryCol() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.setColumnProperty("indctrname", "isFixed", (Object)true);
            entryGrid.setColumnProperty("weight", "isFixed", (Object)true);
            entryGrid.setColumnProperty("indctrscore", "isFixed", (Object)true);
            entryGrid.setColumnProperty("beforeadjust", "isFixed", (Object)true);
        }
    }

    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Long confId = (Long)parameter.getCustomParam("confid");
            DynamicObject conf = this.ACTIVITY_SERVICE.queryNormalConfigByPk(confId);
            this.setConfigFieldInfo(conf);
            IFormView view = this.getView();
            String areaName = this.updateAndGetAreaName(conf);
            boolean openReverse = ObjEvaluationUtils.isOpenAdjustScore(conf);
            this.getView().getPageCache().put("openReverseCache", String.valueOf(openReverse));
            ObjEvaluationUtils.cacheMustInputFieldInfo(view, conf, areaName, AreaRegEnum.NORM_INDCTR_AREA, openReverse);
            this.getModel().setValue("minareascore", (Object)this.getScoreSystem().getBigDecimal("minscore"));
            DynamicObject areaDy = this.getModel().getDataEntity().getDynamicObject("area");
            if (areaDy != null) {
                this.getModel().setValue("maxareascore", areaDy.get("areascore"));
            }
            this.getModel().setValue("nodeweight", this.getModel().getDataEntity().get("flowrunode.nodeweight"));
            this.getModel().setValue("roleweight", this.getModel().getDataEntity().get("flowrurole.roleweight"));
            this.setInitEntryFields();
            OperationStatus status = parameter.getStatus();
            this.getView().setEnable(status == OperationStatus.VIEW ? Boolean.FALSE : Boolean.TRUE, new String[]{"entryentity"});
            this.addMergeIndicators();
            this.doInitForMerge(conf);
            Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
            DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
            ObjEvaluationUtils.dealPreNodeCarryInfo(this.getView(), status, taskId, AreaRegEnum.NORM_INDCTR_AREA, conf);
            this.addImportIndicators();
            this.notEditImpIndicators();
            this.changeWeightAndScore();
            this.initBeforeAdjustVal(conf);
            this.calculateAfterJustVal(conf);
            this.initAdjustCellColor(conf);
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("columnResizeMode", "preset");
            this.getView().updateControlMetadata("entryentity", map);
            ObjEvaluationUtils.calculateSSR(this.getView(), APP_SERVICE.queryTaskWeight(taskId), false);
            this.cacheSsrData();
            this.putTipsForSoe(conf);
            this.putTipsForAdjustVal(conf);
            this.showSsrTips(conf);
            this.setNotEditRowOfCross();
            this.getView().getPageCache().put("page_load_finished_key", "true");
            boolean isrollbacked = taskObj.getBoolean("isrollbacked");
            if (status == OperationStatus.ADDNEW || !isrollbacked) {
                ObjEvaluationUtils.calculateScoreFirst(this.getView());
            }
            this.cacheIsAllImportIndicators(conf);
            this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity", "collapsevector"});
        }
        catch (Exception execp) {
            LOGGER.error(execp.getMessage(), (Throwable)execp);
            throw execp;
        }
        finally {
            ObjEvaluationUtils.cacheBindingData(this.getView(), false);
        }
    }

    private void doInitForMerge(DynamicObject conf) {
        if (this.isCrossMerge()) {
            Map mergeTaskInds;
            String mergeTaskIndsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskInds");
            HashMap taskIndMap = new HashMap(16);
            if (HRStringUtils.isNotEmpty((String)mergeTaskIndsStr) && (mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class)) != null) {
                Long areaId = (Long)this.getView().getFormShowParameter().getCustomParam("area");
                for (Map.Entry entry : mergeTaskInds.entrySet()) {
                    List indicatorList;
                    if (entry == null) continue;
                    Long taskId = (Long)entry.getKey();
                    Map areaIndMap = (Map)entry.getValue();
                    if (taskId == null || areaIndMap == null || areaIndMap.isEmpty() || (indicatorList = (List)areaIndMap.get(areaId)) == null || indicatorList.isEmpty()) continue;
                    List inds = taskIndMap.get(taskId) == null ? new ArrayList(10) : (List)taskIndMap.get(taskId);
                    inds.addAll(indicatorList);
                    taskIndMap.put(taskId, inds);
                }
            }
            Long areaId = (Long)this.getView().getFormShowParameter().getCustomParam("area");
            Map hasTaskRecordMap = APP_SERVICE.queryEvalRecord(AreaRegEnum.NORM_INDCTR_AREA, areaId, taskIndMap);
            for (Map.Entry entry : taskIndMap.entrySet()) {
                List hasRecordIndList;
                if (entry == null) continue;
                Long taskIdKey = (Long)entry.getKey();
                List indList = (List)entry.getValue();
                if (taskIdKey == null || indList == null || indList.isEmpty()) continue;
                if (hasTaskRecordMap != null && (hasRecordIndList = (List)hasTaskRecordMap.get(taskIdKey)) != null) {
                    indList.removeAll(hasRecordIndList);
                }
                if (indList.isEmpty()) continue;
                this.initIndicatorEntryForMerge(conf, areaId, taskIdKey, indList);
            }
        }
    }

    private void setInitEntryFields() {
        IFormView view = this.getView();
        IPageCache pageCache = this.getView().getPageCache();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String mergeTaskIdsStr = (String)formShowParameter.getCustomParam("mergeTaskIds");
        String mergeTaskIndsStr = (String)formShowParameter.getCustomParam("mergeTaskInds");
        Long areaInsId = (Long)formShowParameter.getCustomParam("area");
        if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
            List mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
            Map taskMap = APP_SERVICE.queryTaskMap(mergeTaskIds);
            Map mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
            HashMap<Long, Long> indTaskMap = new HashMap<Long, Long>(10);
            if (mergeTaskIds.size() > 1) {
                pageCache.put("mergeTaskCache", "true");
            }
            for (int j = 0; j < mergeTaskIds.size(); ++j) {
                Long taskItemId = (Long)mergeTaskIds.get(j);
                Map areaRegIndicaItemMap = (Map)mergeTaskInds.get(taskItemId);
                if (!areaRegIndicaItemMap.containsKey(areaInsId)) continue;
                List areaIndItemList = (List)areaRegIndicaItemMap.get(areaInsId);
                for (Long indId : areaIndItemList) {
                    indTaskMap.put(indId, taskItemId);
                }
            }
            if (formShowParameter.getStatus() == OperationStatus.ADDNEW) {
                DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    Long indId = ((DynamicObject)entryEntity.get(i)).getLong("indicator.id");
                    Long indTaskId = mergeTaskIds.size() > 1 ? (Long)indTaskMap.get(indId) : (Long)mergeTaskIds.get(0);
                    Map taskInfoMap = (Map)taskMap.get(indTaskId);
                    for (String initField : INDICATOR_INIT_FIELDS) {
                        Object fieldValue;
                        if (Arrays.asList(MERGE_IND_FIELDS).contains(initField)) {
                            fieldValue = taskInfoMap.get(initField);
                            if (fieldValue == null) continue;
                            view.getModel().setValue("ind" + initField, fieldValue, i);
                            continue;
                        }
                        fieldValue = formShowParameter.getCustomParam(initField);
                        if (fieldValue == null) continue;
                        view.getModel().setValue("ind" + initField, fieldValue, i);
                    }
                    ObjEvaluationUtils.setCreateInfo(view, i);
                }
            }
        }
    }

    private void setNotEditRowOfCross() {
        ArrayList<Integer> canNotEditIndexList = new ArrayList<Integer>(10);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity != null) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                boolean crossCanEdit;
                DynamicObject entry = (DynamicObject)entryEntity.get(i);
                if (entry == null || (crossCanEdit = entry.getBoolean("iscanedit"))) continue;
                canNotEditIndexList.add(i);
            }
            if (!canNotEditIndexList.isEmpty()) {
                LOGGER.info("setNotEditRowOfCross canNotEditIndexList\uff1a{}", (Object)((Object)canNotEditIndexList).toString());
                int[] notEditIndexArr = new int[canNotEditIndexList.size()];
                for (int i = 0; i < canNotEditIndexList.size(); ++i) {
                    notEditIndexArr[i] = (Integer)canNotEditIndexList.get(i);
                }
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                grid.setRowLock(true, notEditIndexArr);
            }
        }
    }

    private void cacheIsAllImportIndicators(DynamicObject conf) {
        IFormView parentViews;
        String entityId;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List<Long> importIndicators = this.getImportIndicators();
        if (entryEntity != null && importIndicators != null && HRStringUtils.equals((String)(entityId = (parentViews = this.getView().getParentView().getParentView()).getEntityId()), (String)"epa_actevalobj_eval_multi")) {
            String confId = conf.getString("id");
            if (entryEntity.size() == importIndicators.size()) {
                parentViews.getPageCache().put("isAllImportIndicators_" + confId, "true");
            } else {
                parentViews.getPageCache().put("isAllImportIndicators_" + confId, "false");
            }
        }
    }

    private void notEditImpIndicators() {
        int i;
        DynamicObjectCollection entryEntity;
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        List<Long> importIndicators = this.getImportIndicators();
        ArrayList<Integer> impRowIndexList = new ArrayList<Integer>(10);
        if (importIndicators != null && (entryEntity = this.getModel().getEntryEntity("entryentity")) != null) {
            for (i = 0; i < entryEntity.size(); ++i) {
                long indicatorId;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                if (dynamicObject == null || (indicatorId = dynamicObject.getLong("indicator.id")) == 0L || !importIndicators.contains(indicatorId)) continue;
                impRowIndexList.add(i);
            }
        }
        if (!impRowIndexList.isEmpty()) {
            LOGGER.info("notEditImpIndicators {}", (Object)((Object)impRowIndexList).toString());
            int[] rowsArr = new int[impRowIndexList.size()];
            for (i = 0; i < impRowIndexList.size(); ++i) {
                rowsArr[i] = (Integer)impRowIndexList.get(i);
            }
            grid.setRowLock(true, rowsArr);
            grid.setRowBackcolor("#F5F5F5", rowsArr);
        }
        this.initAdjustCellColor(null);
    }

    private void calculateAfterJustVal(DynamicObject conf) {
        DynamicObjectCollection entryEntity;
        boolean openReverse = ObjEvaluationUtils.isOpenAdjustScore(conf);
        if (openReverse && (entryEntity = this.getModel().getEntryEntity("entryentity")) != null) {
            List<Long> importIndicators = this.getImportIndicators();
            for (DynamicObject entry : entryEntity) {
                BigDecimal beforeAdjust;
                long indicatorId = entry.getLong("indicator.id");
                if (indicatorId != 0L && importIndicators.contains(indicatorId)) {
                    beforeAdjust = entry.getBigDecimal("beforeadjust") == null ? BigDecimal.ZERO : entry.getBigDecimal("beforeadjust");
                    BigDecimal soe = entry.getBigDecimal("soe") == null ? BigDecimal.ZERO : entry.getBigDecimal("soe");
                    entry.set("adjustval", (Object)soe.subtract(beforeAdjust));
                    continue;
                }
                beforeAdjust = entry.getBigDecimal("beforeadjust") == null ? BigDecimal.ZERO : entry.getBigDecimal("beforeadjust");
                BigDecimal adjustVal = entry.getBigDecimal("adjustval") == null ? BigDecimal.ZERO : entry.getBigDecimal("adjustval");
                entry.set("soe", (Object)beforeAdjust.add(adjustVal));
            }
            FormShowParameter parameter = this.getView().getFormShowParameter();
            ObjEvaluationUtils.calculateSSR(this.getView(), APP_SERVICE.queryTaskWeight((Long)parameter.getCustomParam("flowrutask")), false);
            this.getView().updateView("entryentity");
        }
    }

    private void putTipsForAdjustVal(DynamicObject conf) {
        boolean openReverse = ObjEvaluationUtils.isOpenAdjustScore(conf);
        if (openReverse) {
            String adjustType;
            ActEvalIndFieldTipsDto actEvalIndFieldTipsDto = new ActEvalIndFieldTipsDto();
            String titleTips = ResManager.loadKDString((String)"\u8bc4\u5206\u8303\u56f4", (String)"GenAreaEvaluationEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            actEvalIndFieldTipsDto.setTitle(titleTips);
            String string = adjustType = conf.getString("adjusttype") == null ? "" : conf.getString("adjusttype");
            if (AdjustTypeEnum.NORMAL.getValue().equals(adjustType)) {
                BigDecimal upperScore = conf.getBigDecimal("upperscore") == null ? BigDecimal.ZERO : conf.getBigDecimal("upperscore");
                BigDecimal lowerScore = conf.getBigDecimal("lowerscore") == null ? BigDecimal.ZERO : conf.getBigDecimal("lowerscore");
                upperScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), upperScore);
                lowerScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), lowerScore);
                ArrayList<ActEvalIndFieldItemTipsDto> fieldItemTipsDtos = new ArrayList<ActEvalIndFieldItemTipsDto>(10);
                String msgTips = ResManager.loadKDString((String)"\u6240\u6709\u6307\u6807\u8bc4\u5206\u8303\u56f4", (String)"GenAreaEvaluationEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                ActEvalIndFieldItemTipsDto itemTipsDto = new ActEvalIndFieldItemTipsDto(msgTips, String.format("[%s ~ %s]", lowerScore.toPlainString(), upperScore.toPlainString()));
                fieldItemTipsDtos.add(itemTipsDto);
                actEvalIndFieldTipsDto.setActEvalIndFieldItemTipsList(fieldItemTipsDtos);
            } else if (AdjustTypeEnum.CUSTOM.getValue().equals(adjustType)) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                ArrayList<ActEvalIndFieldItemTipsDto> actEvalIndFieldItemTipsDtos = new ArrayList<ActEvalIndFieldItemTipsDto>(10);
                for (DynamicObject dynamicObject : entryEntity) {
                    BigDecimal maxEvalScore = dynamicObject.getBigDecimal("indicator.maxevalscore") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("indicator.maxevalscore");
                    BigDecimal minEvalScore = dynamicObject.getBigDecimal("indicator.minevalscore") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("indicator.minevalscore");
                    String name = dynamicObject.getString("indicator.indctrname");
                    maxEvalScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), maxEvalScore);
                    minEvalScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), minEvalScore);
                    ActEvalIndFieldItemTipsDto actEvalIndFieldItemTipsDto = new ActEvalIndFieldItemTipsDto(name, String.format("[%s ~ %s]", minEvalScore.toPlainString(), maxEvalScore.toPlainString()));
                    actEvalIndFieldItemTipsDtos.add(actEvalIndFieldItemTipsDto);
                }
                actEvalIndFieldTipsDto.setActEvalIndFieldItemTipsList(actEvalIndFieldItemTipsDtos);
            }
            this.getView().getPageCache().put("adjustScoreTips", JSON.toJSONString((Object)actEvalIndFieldTipsDto));
            this.setFieldTips(actEvalIndFieldTipsDto, "adjustval");
        }
    }

    public void initBeforeAdjustVal(DynamicObject conf) {
        boolean openReverse = ObjEvaluationUtils.isOpenAdjustScore(conf);
        if (openReverse) {
            String scoreCalcWay = (String)this.getView().getFormShowParameter().getCustomParam("scorecalcway");
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                long scoreSystemId = ObjEvaluationUtils.getAreaScoreSystemId(conf);
                if (!ObjEvaluationUtils.isConsistentWithArea(this.getView(), scoreSystemId)) {
                    DynamicObject areaScoreSystem = conf.getDynamicObject("scoresystem");
                    if (areaScoreSystem != null) {
                        BigDecimal areaMaxScore = areaScoreSystem.getBigDecimal("maxscore");
                        this.setBeforeAdjustVal(areaMaxScore);
                    }
                } else {
                    DynamicObject scoreSystem = this.getScoreSystem();
                    BigDecimal formMaxScore = scoreSystem.getBigDecimal("maxscore");
                    this.setBeforeAdjustVal(formMaxScore);
                }
            } else {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                if (entryEntity != null) {
                    for (DynamicObject entry : entryEntity) {
                        DynamicObject indicator;
                        if (entry == null || (indicator = entry.getDynamicObject("indicator")) == null) continue;
                        BigDecimal indctrScore = indicator.getBigDecimal("indctrscore") == null ? BigDecimal.ZERO : indicator.getBigDecimal("indctrscore");
                        entry.set("beforeadjust", (Object)indctrScore);
                    }
                    this.getView().updateView("entryentity");
                }
            }
        }
    }

    public void setBeforeAdjustVal(BigDecimal val) {
        DynamicObjectCollection entryEntity;
        if (val == null) {
            val = BigDecimal.ZERO;
        }
        if ((entryEntity = this.getModel().getEntryEntity("entryentity")) != null) {
            for (DynamicObject dynamicObject : entryEntity) {
                if (dynamicObject == null) continue;
                dynamicObject.set("beforeadjust", (Object)val);
            }
            this.getView().updateView("entryentity");
        }
    }

    private void changeWeightAndScore() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObject indicator;
            if (dynamicObject == null || (indicator = dynamicObject.getDynamicObject("indicator")) == null) continue;
            BigDecimal weight = indicator.getBigDecimal("weight") == null ? BigDecimal.ZERO : indicator.getBigDecimal("weight");
            BigDecimal indctrScore = indicator.getBigDecimal("indctrscore") == null ? BigDecimal.ZERO : indicator.getBigDecimal("indctrscore");
            dynamicObject.set("weight", (Object)weight.stripTrailingZeros().toPlainString());
            dynamicObject.set("indctrscore", (Object)indctrScore.stripTrailingZeros().toPlainString());
        }
        this.getView().updateView("entryentity");
    }

    private void setConfigFieldInfo(DynamicObject conf) {
        String areaName = this.updateAndGetAreaName(conf);
        this.setTisForAreaTitle(conf, areaName);
        this.getView().updateControlMetadata("ssr", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
        this.getView().updateControlMetadata("ssrec", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
        boolean isAllowEval = conf.getBoolean("isalloweval");
        this.getView().setVisible(Boolean.valueOf(isAllowEval), new String[]{"ssrap", "areascoreap", "noderoleap", "ssrecap"});
    }

    public void showSsrTips(DynamicObject conf) {
        String scoreCalcWay = (String)this.getView().getFormShowParameter().getCustomParam("scorecalcway");
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            long scoreSystemId = ObjEvaluationUtils.getAreaScoreSystemId(conf);
            if (!ObjEvaluationUtils.isConsistentWithArea(this.getView(), scoreSystemId)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"ssrtipslabellap"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"ssrtipslabellap"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ssrtipslabellap"});
        }
    }

    public void setTisForAreaTitle(DynamicObject conf, String areaName) {
        boolean isShowTips = false;
        StringBuilder tipsBuilder = new StringBuilder();
        String description = conf.getString("description");
        if (!HRStringUtils.isBlank((CharSequence)description)) {
            isShowTips = true;
            String descTit = ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a", (String)"GenAreaEvaluationEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            tipsBuilder.append(descTit).append(description);
        }
        this.getView().getPageCache().put("genAreaTitleCacheKey", areaName);
        String scoreCalcWay = (String)this.getView().getFormShowParameter().getCustomParam("scorecalcway");
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            String scoreSystemName;
            long scoreSystemId = ObjEvaluationUtils.getAreaScoreSystemId(conf);
            if (!ObjEvaluationUtils.isConsistentWithArea(this.getView(), scoreSystemId) && !HRStringUtils.isBlank((CharSequence)(scoreSystemName = conf.getString("scoresystem.name")))) {
                isShowTips = true;
                String descTit = ResManager.loadKDString((String)"\u533a\u57df\u5206\u5236\uff1a", (String)"GenAreaEvaluationEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                if (tipsBuilder != null && !HRStringUtils.isBlank((CharSequence)tipsBuilder.toString())) {
                    tipsBuilder.append("\n");
                }
                tipsBuilder.append(descTit).append(scoreSystemName);
            }
        }
        if (isShowTips) {
            Tips tips = new Tips();
            tips.setTriggerType("hover");
            tips.setType("text");
            tips.setIconClassName("kdfont kdfont-guanlianxinxi");
            tips.setContent(new LocaleString(tipsBuilder.toString()));
            tips.setPlace("right");
            Label titleLable = (Label)this.getView().getControl(AREATITLE);
            titleLable.addTips(tips);
        }
    }

    public String updateAndGetAreaName(DynamicObject conf) {
        Label titleLable = (Label)this.getView().getControl(AREATITLE);
        String areaCustName = conf.getString("areacustname");
        StringBuilder areaNameBuilder = new StringBuilder();
        areaNameBuilder.append(areaCustName);
        if (!this.isCrossEval()) {
            BigDecimal areascore;
            DynamicObject genAreaIns;
            String scoreCalcWay = (String)this.getView().getFormShowParameter().getCustomParam("scorecalcway");
            String weightDisplay = (String)this.getView().getFormShowParameter().getCustomParam("weightDisplay");
            if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay) && "display".equals(weightDisplay)) {
                BigDecimal areaWeight;
                DynamicObject genAreaIns2 = ObjEvaluationUtils.getObjGenAreaIns(this.getView());
                if (genAreaIns2 != null && (areaWeight = genAreaIns2.getBigDecimal("areaweight")) != null) {
                    String plainString = areaWeight.stripTrailingZeros().toPlainString();
                    areaNameBuilder.append('(').append(plainString).append('%').append(')');
                }
            } else if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay) && (genAreaIns = ObjEvaluationUtils.getObjGenAreaIns(this.getView())) != null && (areascore = genAreaIns.getBigDecimal("areascore")) != null) {
                String plainString = areascore.stripTrailingZeros().toPlainString();
                areaNameBuilder.append('(').append(plainString).append(')');
            }
        }
        String areaName = areaNameBuilder.toString();
        titleLable.setText(areaName);
        return areaName;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (name) {
            case "soe": {
                this.doSoeChangeEvent(changeData);
                this.notEditImpIndicators();
                break;
            }
            case "qualityres": {
                NumberValidateUtils.opValidateEntryQualityRes((IFormView)this.getView(), (ChangeData)changeData);
                break;
            }
            case "ssr": {
                this.cacheSsrData();
                break;
            }
            case "adjustval": {
                this.doAdjustValChangeEvent(changeData);
                this.notEditImpIndicators();
                this.setNotEditRowOfCross();
                break;
            }
        }
    }

    private void initAdjustCellColor(DynamicObject conf) {
        String openReverseStr;
        boolean openReverse = ObjEvaluationUtils.isOpenAdjustScore(conf);
        if (conf == null && "true".equals(openReverseStr = this.getView().getPageCache().get("openReverseCache"))) {
            openReverse = true;
        }
        if (openReverse) {
            this.getView().getPageCache().put("openReverseCache", String.valueOf(openReverse));
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            if (entity != null) {
                for (int i = 0; i < entity.size(); ++i) {
                    DynamicObject rowObj = (DynamicObject)entity.get(i);
                    if (rowObj == null) continue;
                    BigDecimal beforeAdjust = rowObj.getBigDecimal("beforeadjust") == null ? BigDecimal.ZERO : rowObj.getBigDecimal("beforeadjust");
                    BigDecimal soe = rowObj.getBigDecimal("soe") == null ? BigDecimal.ZERO : rowObj.getBigDecimal("soe");
                    cellStyles.add(this.adjustCellStyle(i, beforeAdjust, soe));
                }
                if (!cellStyles.isEmpty()) {
                    grid.setCellStyle(cellStyles);
                }
            }
        }
    }

    private CellStyle adjustCellStyle(int rowIndex, BigDecimal beforeAdjust, BigDecimal soe) {
        beforeAdjust = beforeAdjust == null ? BigDecimal.ZERO : beforeAdjust;
        soe = soe == null ? BigDecimal.ZERO : soe;
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey("soe");
        cellStyle.setRow(rowIndex);
        if (beforeAdjust.compareTo(soe) > 0) {
            cellStyle.setForeColor("#D80C1E");
        } else if (beforeAdjust.compareTo(soe) < 0) {
            cellStyle.setForeColor("#19994D");
        }
        return cellStyle;
    }

    private void doAdjustValChangeEvent(ChangeData changeData) {
        boolean pass = this.validDateAdjustVal(changeData);
        if (pass) {
            BigDecimal adjustVal = (BigDecimal)changeData.getNewValue();
            BigDecimal beforeAdjustVal = (BigDecimal)this.getView().getModel().getValue("beforeadjust", changeData.getRowIndex());
            this.setAfterAdjustValAndSetCellStyle(beforeAdjustVal, adjustVal, changeData.getRowIndex());
        }
    }

    public void setAfterAdjustValAndSetCellStyle(BigDecimal beforeAdjustVal, BigDecimal adjustVal, int rowIndex) {
        if (adjustVal == null) {
            adjustVal = BigDecimal.ZERO;
        }
        if (beforeAdjustVal == null) {
            beforeAdjustVal = BigDecimal.ZERO;
        }
        BigDecimal newSoe = beforeAdjustVal.add(adjustVal);
        this.getModel().beginInit();
        this.getView().getModel().setValue("soe", (Object)newSoe, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("entryentity", rowIndex);
        try {
            String parentPageId = this.getView().getParentView().getPageId();
            IHRAppCache epaCache = HRAppCache.get((String)"epa");
            epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"true");
            Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
            if (this.isCrossEval()) {
                ObjEvaluationUtils.calculateSSR(this.getView(), APP_SERVICE.queryTaskWeight(taskId), false);
                epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"false");
            } else {
                ObjEvaluationUtils.calculateSSR(this.getView(), APP_SERVICE.queryTaskWeight(taskId), true);
            }
        }
        catch (Exception ee) {
            LOGGER.error(ee.getMessage(), (Throwable)ee);
            String parentPageId = this.getView().getParentView().getPageId();
            IHRAppCache epaCache = HRAppCache.get((String)"epa");
            epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"false");
        }
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(10);
        CellStyle cellStyle = this.adjustCellStyle(rowIndex, beforeAdjustVal, newSoe);
        cellStyles.add(cellStyle);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.setCellStyle(cellStyles);
    }

    private void doSoeChangeEvent(ChangeData changeData) {
        try {
            String parentPageId = this.getView().getParentView().getPageId();
            IHRAppCache epaCache = HRAppCache.get((String)"epa");
            epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"true");
            if (!this.validDateSoeRange(changeData)) {
                epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"false");
            } else {
                Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
                LOGGER.info("caluate ssr taskid:{}", (Object)taskId);
                IPageCache pageCache = this.getPageCache();
                IPageCache pageCache1 = this.getView().getPageCache();
                LOGGER.info("caluate ssr pageCache:{}", (Object)pageCache);
                LOGGER.info("caluate ssr pageCache1:{}", (Object)pageCache1);
                if (this.isCrossEval()) {
                    ObjEvaluationUtils.calculateSSR(this.getView(), ObjEvaluationUtils.queryTaskWeight(this.getPageCache(), taskId), false);
                    epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"false");
                } else {
                    ObjEvaluationUtils.calculateSSR(this.getView(), ObjEvaluationUtils.queryTaskWeight(this.getPageCache(), taskId), true);
                }
            }
        }
        catch (Exception exce) {
            LOGGER.error(exce.getMessage(), (Throwable)exce);
            String parentPageId = this.getView().getParentView().getPageId();
            IHRAppCache epaCache = HRAppCache.get((String)"epa");
            epaCache.put(ObjEvaluationUtils.getCalculateKey(parentPageId), (Object)"false");
        }
    }

    private void cacheSsrData() {
        BigDecimal ssr = this.getModel().getDataEntity().getBigDecimal("ssr");
        if (ssr == null) {
            ssr = BigDecimal.ZERO;
        }
        this.getView().getPageCache().put("SSR_SCORE_AFTERBING", ssr.toPlainString());
        this.getView().getPageCache().put("ssrCacheValue", ssr.toPlainString());
    }

    public boolean isValidateScore(IFormView view) {
        IsValidateScoreServiceImpl isValidateScoreService = new IsValidateScoreServiceImpl();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)isValidateScoreService, IsValidateScoreService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.IsValidateScoreService#isValidateScore", (PluginFilter)null);
        List booleans = proxy.callReplaceIfPresent(validate -> validate.isValidateScore(view));
        if (booleans != null && booleans.size() > 0) {
            return (Boolean)booleans.get(0);
        }
        return true;
    }

    public boolean validDateAdjustVal(ChangeData changeData) {
        if (!this.isValidateScore(this.getView())) {
            return true;
        }
        BigDecimal newScore = (BigDecimal)changeData.getNewValue();
        Long confId = this.getView().getFormShowParameter().getCustomParam("confid") == null ? Long.valueOf(0L) : (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryNormalConfigByPk(confId);
        if (conf != null) {
            String adjustType;
            String string = adjustType = conf.getString("adjusttype") == null ? "" : conf.getString("adjusttype");
            if (AdjustTypeEnum.NORMAL.getValue().equals(adjustType)) {
                BigDecimal upperScore;
                BigDecimal lowerScore = conf.getBigDecimal("lowerscore") == null ? BigDecimal.ZERO : conf.getBigDecimal("lowerscore");
                BigDecimal bigDecimal = upperScore = conf.getBigDecimal("upperscore") == null ? BigDecimal.ZERO : conf.getBigDecimal("upperscore");
                if (newScore == null || newScore.compareTo(lowerScore) < 0 || newScore.compareTo(upperScore) > 0) {
                    lowerScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), lowerScore);
                    upperScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), upperScore);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728{0}~{1}\u8303\u56f4\u5185\u8bc4\u5206\u3002", (String)"GenAreaEvaluationEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{lowerScore.toPlainString(), upperScore.toPlainString()}));
                    DynamicObject entryRowEntity = this.getView().getModel().getEntryRowEntity("entryentity", changeData.getRowIndex());
                    DynamicObject indicator = entryRowEntity.getDynamicObject("indicator");
                    BigDecimal initAdjustVal = this.getInitAdjustVal(conf, indicator);
                    this.getModel().beginInit();
                    this.getView().getModel().setValue("adjustval", (Object)initAdjustVal, changeData.getRowIndex());
                    this.getModel().endInit();
                    BigDecimal beforeAdjustVal = (BigDecimal)this.getView().getModel().getValue("beforeadjust", changeData.getRowIndex());
                    this.setAfterAdjustValAndSetCellStyle(beforeAdjustVal, initAdjustVal, changeData.getRowIndex());
                    return false;
                }
            } else if (AdjustTypeEnum.CUSTOM.getValue().equals(adjustType)) {
                BigDecimal minevalScore;
                DynamicObject entryRowEntity = this.getView().getModel().getEntryRowEntity("entryentity", changeData.getRowIndex());
                BigDecimal maxevalScore = entryRowEntity.getBigDecimal("indicator.maxevalscore") == null ? BigDecimal.ZERO : entryRowEntity.getBigDecimal("indicator.maxevalscore");
                BigDecimal bigDecimal = minevalScore = entryRowEntity.getBigDecimal("indicator.minevalscore") == null ? BigDecimal.ZERO : entryRowEntity.getBigDecimal("indicator.minevalscore");
                if (newScore == null || newScore.compareTo(minevalScore) < 0 || newScore.compareTo(maxevalScore) > 0) {
                    minevalScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), minevalScore);
                    maxevalScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), maxevalScore);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728{0}~{1}\u8303\u56f4\u5185\u8bc4\u5206\u3002", (String)"GenAreaEvaluationEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{minevalScore.toPlainString(), maxevalScore.toPlainString()}));
                    DynamicObject indicator = entryRowEntity.getDynamicObject("indicator");
                    BigDecimal initAdjustVal = this.getInitAdjustVal(conf, indicator);
                    this.getModel().beginInit();
                    this.getView().getModel().setValue("adjustval", (Object)initAdjustVal, changeData.getRowIndex());
                    this.getModel().endInit();
                    BigDecimal beforeAdjustVal = (BigDecimal)this.getView().getModel().getValue("beforeadjust", changeData.getRowIndex());
                    this.setAfterAdjustValAndSetCellStyle(beforeAdjustVal, initAdjustVal, changeData.getRowIndex());
                    return false;
                }
            }
        }
        return true;
    }

    private BigDecimal getOldAdjustVal(ChangeData changeData, BigDecimal lowerScore, BigDecimal upperScore) {
        BigDecimal oldValue;
        BigDecimal bigDecimal = oldValue = changeData.getOldValue() == null ? BigDecimal.ZERO : (BigDecimal)changeData.getOldValue();
        if (oldValue.compareTo(lowerScore) < 0 || oldValue.compareTo(upperScore) > 0) {
            oldValue = this.getInitAdjustVal(lowerScore, upperScore);
        }
        return oldValue;
    }

    public BigDecimal getInitAdjustVal(BigDecimal lowerScore, BigDecimal upperScore) {
        if (lowerScore == null) {
            lowerScore = BigDecimal.ZERO;
        }
        if (upperScore == null) {
            upperScore = BigDecimal.ZERO;
        }
        if (BigDecimal.ZERO.compareTo(lowerScore) >= 0 && upperScore.compareTo(BigDecimal.ZERO) >= 0) {
            return BigDecimal.ZERO;
        }
        return upperScore;
    }

    private boolean isTurnOnOverLimit() {
        String evasumlimit = (String)this.getView().getFormShowParameter().getCustomParam("evasumlimit");
        return EvaSumLimit.APPOINT_SUM_LIMIT.getValue().equals(evasumlimit);
    }

    public boolean validDateSoeRange(ChangeData changeData) {
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryNormalConfigByPk(confId);
        BigDecimal newScore = (BigDecimal)changeData.getNewValue();
        if (ObjEvaluationUtils.isOpenAdjustScore(conf)) {
            return true;
        }
        boolean isValid = false;
        String scoreCalcWay = (String)this.getView().getFormShowParameter().getCustomParam("scorecalcway");
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            boolean consistentWithArea = ObjEvaluationUtils.isConsistentWithArea(this.getView(), ObjEvaluationUtils.getAreaScoreSystemId(conf));
            if (consistentWithArea) {
                isValid = this.checkScoreIsInScoreSystem(newScore, this.getScoreSystem());
                this.resetSoeData(conf, changeData, isValid);
            } else {
                DynamicObject areaScoreSystem = this.ACTIVITY_SERVICE.queryScoreSystemById(Long.valueOf(ObjEvaluationUtils.getAreaScoreSystemId(conf)));
                isValid = this.checkScoreIsInScoreSystem(newScore, areaScoreSystem);
                this.resetSoeData(conf, changeData, isValid);
            }
        } else if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
            DynamicObject entryRowEntity = this.getView().getModel().getEntryRowEntity("entryentity", changeData.getRowIndex());
            BigDecimal indicatorScore = entryRowEntity.getBigDecimal("indicator.indctrscore") == null ? BigDecimal.ZERO : entryRowEntity.getBigDecimal("indicator.indctrscore");
            isValid = this.isScoreValid(newScore, BigDecimal.ZERO, indicatorScore);
            this.resetSoeData(conf, changeData, isValid);
        }
        return isValid;
    }

    public void resetSoeData(DynamicObject conf, ChangeData changeData, boolean isValid) {
        if (!isValid) {
            BigDecimal defaultSoe = this.getDefaultSoe(conf);
            this.getView().getModel().setValue("soe", (Object)defaultSoe, changeData.getRowIndex());
        }
    }

    public boolean isScoreValid(BigDecimal newValue, BigDecimal minScore, BigDecimal maxScore) {
        if (!this.isValidateScore(this.getView())) {
            return true;
        }
        if (newValue == null) {
            return true;
        }
        boolean isValid = true;
        if (newValue.compareTo(maxScore) > 0 || newValue.compareTo(minScore) < 0) {
            isValid = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728{0}~{1}\u8303\u56f4\u5185\u8bc4\u5206\u3002", (String)"GenAreaEvaluationEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore}));
        }
        return isValid;
    }

    public boolean checkScoreIsInScoreSystem(BigDecimal newValue, DynamicObject formScoreSystem) {
        if (formScoreSystem != null) {
            BigDecimal minScore = formScoreSystem.getBigDecimal("minscore") == null ? BigDecimal.ZERO : formScoreSystem.getBigDecimal("minscore");
            BigDecimal maxScore = formScoreSystem.getBigDecimal("maxscore") == null ? BigDecimal.ZERO : formScoreSystem.getBigDecimal("maxscore");
            return this.isScoreValid(newValue, minScore, maxScore);
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": {
                String backenSave = source.getOption().getVariableValue("BACKEN_SAVE", "false");
                if ("true".equals(backenSave)) {
                    Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
                    BigDecimal taskWeight = ObjEvaluationUtils.queryTaskWeight(this.getPageCache(), taskId);
                    ObjEvaluationUtils.repeatCaluateSsr(this.getView(), taskWeight);
                }
                List<Long> genImportIndicators = this.getGenImportIndicators();
                this.updateEntrySoeScoreForImp(genImportIndicators);
                DynamicObjectCollection recordEntry = this.getModel().getEntryEntity("entryentity");
                ArrayList<Integer> notSaveEntryRowList = new ArrayList<Integer>(10);
                Date curDate = new Date();
                if (recordEntry != null) {
                    for (int i = 0; i < recordEntry.size(); ++i) {
                        DynamicObject dynamicObject = (DynamicObject)recordEntry.get(i);
                        if (dynamicObject == null || dynamicObject.getLong("indicator.id") == 0L) continue;
                        dynamicObject.set("indmodifytime", (Object)curDate);
                        long indCatorId = dynamicObject.getLong("indicator.id");
                        if (!genImportIndicators.contains(indCatorId) || indCatorId == 0L) continue;
                        notSaveEntryRowList.add(i);
                    }
                    if (!notSaveEntryRowList.isEmpty()) {
                        int[] notDelArr = new int[notSaveEntryRowList.size()];
                        for (int i = 0; i < notSaveEntryRowList.size(); ++i) {
                            notDelArr[i] = (Integer)notSaveEntryRowList.get(i);
                        }
                        this.getModel().deleteEntryRows("entryentity", notDelArr);
                    }
                }
                this.soeOrAdjustValNull2Zero();
                this.updateNotAllowEvalSoeNull2Zero();
                String mergeTaskCache = this.getView().getPageCache().get("mergeTaskCache");
                if (!HRStringUtils.isEmpty((String)mergeTaskCache)) {
                    FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                    DynamicObject genAreaRecordObj = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
                    String mergeTaskIdsStr = (String)formShowParameter.getCustomParam("mergeTaskIds");
                    String mergeTaskIndsStr = (String)formShowParameter.getCustomParam("mergeTaskInds");
                    if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
                        List mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
                        Map mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
                        String scoreCalcWay = (String)this.getView().getFormShowParameter().getCustomParam("scorecalcway");
                        APP_SERVICE.saveMergeGenAreaRecord(genAreaRecordObj, scoreCalcWay);
                        this.getView().updateView("entryentity");
                        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
                        DynamicObject conf = this.ACTIVITY_SERVICE.queryNormalConfigByPk(confId);
                        this.initAdjustCellColor(conf);
                        this.setNotEditRowOfCross();
                        IFormView parentView = this.getView().getParentView();
                        parentView.sendFormAction(this.getView());
                    }
                    args.setCancel(true);
                    return;
                }
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                if (OperationStatus.EDIT != status) break;
                long max = Integer.MAX_VALUE;
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                dataEntity.getDataEntityState().setDirtyFlags(new long[]{max});
                dataEntity.getDataEntityState().setBizChangeFlags(new long[]{max});
                DynamicObjectCollection dataColls = dataEntity.getDynamicObjectCollection("entryentity");
                Date currDate = new Date();
                for (int i = 0; i < dataColls.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)dataColls.get(i);
                    dynamicObject.set("indmodifytime", (Object)currDate);
                    dynamicObject.getDataEntityState().setDirtyFlags(new long[]{max});
                    dynamicObject.getDataEntityState().setBizChangeFlags(new long[]{max});
                }
                break;
            }
        }
    }

    private void updateEntrySoeScoreForImp(List<Long> genImportIndicators) {
        if (genImportIndicators != null && !genImportIndicators.isEmpty()) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long areaId = (Long)formShowParameter.getCustomParam("area");
            DynamicObject[] genIndicators = APP_SERVICE.queryIndicatorForGen(areaId);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            String openReverse = this.getView().getPageCache().get("openReverseCache");
            boolean isUpdateAreaScore = false;
            for (DynamicObject genIndicatorOfImp : genIndicators) {
                BigDecimal iecs;
                if (genIndicatorOfImp == null || genIndicatorOfImp.getPkValue() == null || genIndicatorOfImp.getLong("id") == 0L) continue;
                Long pkValue = (Long)genIndicatorOfImp.getPkValue();
                BigDecimal bigDecimal = iecs = genIndicatorOfImp.getBigDecimal("iecs") == null ? BigDecimal.ZERO : genIndicatorOfImp.getBigDecimal("iecs");
                if (entryEntity == null) continue;
                for (DynamicObject entry : entryEntity) {
                    BigDecimal curSoe;
                    long indId;
                    if (entry == null || (indId = entry.getLong("indicator.id")) == 0L || pkValue == null || indId != pkValue) continue;
                    BigDecimal bigDecimal2 = curSoe = entry.getBigDecimal("soe") == null ? BigDecimal.ZERO : entry.getBigDecimal("soe");
                    if (!isUpdateAreaScore && iecs.compareTo(curSoe) != 0) {
                        isUpdateAreaScore = true;
                    }
                    entry.set("soe", (Object)iecs);
                    if (!"true".equals(openReverse)) continue;
                    BigDecimal beforeAdjust = entry.getBigDecimal("beforeadjust") == null ? BigDecimal.ZERO : entry.getBigDecimal("beforeadjust");
                    BigDecimal soe = iecs;
                    entry.set("adjustval", (Object)soe.subtract(beforeAdjust));
                }
            }
            if (isUpdateAreaScore) {
                Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
                if (this.isCrossEval()) {
                    ObjEvaluationUtils.calculateSSR(this.getView(), ObjEvaluationUtils.queryTaskWeight(this.getPageCache(), taskId), false);
                } else {
                    ObjEvaluationUtils.calculateSSR(this.getView(), ObjEvaluationUtils.queryTaskWeight(this.getPageCache(), taskId), true);
                }
                this.getView().updateView("entryentity");
                IFormView parentView = this.getView().getParentView();
                parentView.sendFormAction(this.getView());
            }
        }
    }

    public List<Long> getGenImportIndicators() {
        String indicatorIds = this.getView().getPageCache().get("IMPORT_GEN_INDICATOR_ID_LIST");
        if (HRStringUtils.isBlank((CharSequence)indicatorIds)) {
            List<Long> importIndicators = this.getImportIndicators();
            return importIndicators;
        }
        List<Long> list = JSON.parseArray((String)indicatorIds, Long.class);
        if (list == null || list.isEmpty()) {
            list = this.getImportIndicators();
        }
        return list;
    }

    private List<Long> getImportIndicators() {
        boolean crossEval = this.isCrossEval();
        ArrayList<Long> importIndicators = new ArrayList<Long>(10);
        if (!crossEval) {
            String indicatorIds = this.getView().getPageCache().get("IMPORT_GEN_INDICATOR_ID_LIST");
            List list = JSON.parseArray((String)indicatorIds, Long.class);
            if (list != null && !list.isEmpty()) {
                return list;
            }
            Long areaId = (Long)this.getView().getFormShowParameter().getCustomParam("area");
            DynamicObject[] genIndicators = APP_SERVICE.queryIndicatorForGen(areaId);
            if (genIndicators != null) {
                for (DynamicObject genIndicator : genIndicators) {
                    if (genIndicator == null || genIndicator.getPkValue() == null || genIndicator.getLong("id") == 0L) continue;
                    importIndicators.add((Long)genIndicator.getPkValue());
                }
            }
            this.getView().getPageCache().put("IMPORT_GEN_INDICATOR_ID_LIST", JSON.toJSONString(importIndicators));
        }
        return importIndicators;
    }

    private void soeOrAdjustValNull2Zero() {
        LOGGER.info("**soeOrAdjustValNull2Zero dataloaded:{}", (Object)this.getView().getModel().isDataLoaded());
        DynamicObjectCollection recordEntry = this.getView().getModel().getEntryEntity("entryentity");
        if (recordEntry != null) {
            List<Long> genImportIndicators = this.getGenImportIndicators();
            for (DynamicObject dynamicObject : recordEntry) {
                BigDecimal adjustval;
                long indCatorId;
                if (dynamicObject == null || (indCatorId = dynamicObject.getLong("indicator.id")) != 0L && genImportIndicators.contains(indCatorId) || (adjustval = dynamicObject.getBigDecimal("adjustval")) != null) continue;
                dynamicObject.set("adjustval", (Object)BigDecimal.ZERO);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "syncindicator": {
                DynamicObjectCollection recordEntry = this.getModel().getEntryEntity("entryentity");
                APP_SERVICE.syncIndicatorInfo(recordEntry, AreaRegEnum.NORM_INDCTR_AREA, this.getGenImportIndicators());
                break;
            }
            case "submitvalid": {
                List<Long> genImportIndicators = this.getGenImportIndicators();
                ObjEvaluationUtils.validateAreaMustEnterFieldOfGen(this.getView(), args, genImportIndicators);
                break;
            }
            case "save": {
                this.getView().updateView();
                this.getView().updateView("entryentity");
                IFormView parentView = this.getView().getParentView();
                parentView.sendFormAction(this.getView());
                OperationResult operationResult = args.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess()) break;
                operationResult.setShowMessage(false);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"collapsevector", "expandvector"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "collapsevector": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity", "collapsevector"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"expandvector"});
                break;
            }
            case "expandvector": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity", "collapsevector"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"expandvector"});
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        String areaMarker = (String)this.getView().getFormShowParameter().getCustomParam("areaMarker");
        this.getView().getParentView().getPageCache().put("confId", confId.toString());
        if (HRStringUtils.equals((String)"entryentity", (String)entryGrid.getKey())) {
            IFormView view = this.getView();
            AreaRegEnum indctrArea = AreaRegEnum.NORM_INDCTR_AREA;
            IndicatorDetailUtils.showIndicatorDetail(entryGrid, view, indctrArea, areaMarker);
        }
    }

    public void initIndicatorEntryForMerge(DynamicObject conf, Long areaId, Long taskId, List<Long> crossIndicatorIds) {
        boolean firstNodeAndRole = APP_SERVICE.isFirstNodeAndRole(taskId);
        DynamicObject[] indicatorDys = APP_SERVICE.queryIndicator(areaId, AreaRegEnum.NORM_INDCTR_AREA, Boolean.valueOf(this.isCrossEval()), crossIndicatorIds);
        if (firstNodeAndRole) {
            this.setEntryRowDataFromInd(indicatorDys, conf);
        } else {
            Map indEvalRecordMap = new HashMap(16);
            Map indEvalScoreRecordMap = new HashMap(16);
            if (!this.isCrossEval() && !ObjEvaluationUtils.isPreRoleNodeIsCross(this.getView(), taskId)) {
                indEvalRecordMap = APP_SERVICE.queryIndicatorEvalRecordOfPreRoleLastTask(taskId, AreaRegEnum.NORM_INDCTR_AREA);
                indEvalScoreRecordMap = APP_SERVICE.queryIndicatorEvalScoreRecordOfPreRoleLastTask(taskId, AreaRegEnum.NORM_INDCTR_AREA);
            } else {
                HashMap<Long, List<Long>> taskMap = new HashMap<Long, List<Long>>(16);
                if (this.isCrossEval()) {
                    taskMap.put(taskId, crossIndicatorIds);
                } else {
                    ArrayList<Long> indicatorIdList = new ArrayList<Long>(10);
                    if (indicatorDys != null) {
                        for (DynamicObject indicatorDy : indicatorDys) {
                            if (indicatorDy == null || indicatorDy.getPkValue() == null || indicatorDy.getLong("id") == 0L) continue;
                            long indicatorDyPkValue = indicatorDy.getLong("id");
                            indicatorIdList.add(indicatorDyPkValue);
                        }
                    }
                    taskMap.put(taskId, indicatorIdList);
                }
                IndicatorEvalRecordBo evalRecordBo = APP_SERVICE.queryPreTaskCrossEvalRecord(taskMap, AreaRegEnum.NORM_INDCTR_AREA);
                if (evalRecordBo != null) {
                    indEvalRecordMap = evalRecordBo.getFinishEvalRecordMap();
                    indEvalScoreRecordMap = evalRecordBo.getScoreEvalRecordMap();
                }
            }
            this.setEntryRowInitData(indicatorDys, indEvalRecordMap, indEvalScoreRecordMap, conf);
        }
    }

    public boolean isCrossEval() {
        Boolean isCrossEvaluate = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCrossEvaluate");
        return isCrossEvaluate != null && isCrossEvaluate != false;
    }

    private boolean isCrossMerge() {
        List mergeTaskIds;
        String mergeTaskIdsStr;
        return this.isCrossEval() && HRStringUtils.isNotEmpty((String)(mergeTaskIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskIds"))) && (mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class)) != null && mergeTaskIds.size() > 1;
    }

    private void initIndicatorEntry(FormShowParameter parameter, DynamicObject conf) {
        IPageCache pageCache = this.getPageCache();
        Long areaId = (Long)parameter.getCustomParam("area");
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        ArrayList crossIndicatorIds = new ArrayList(10);
        String mergeTaskIdsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskIds");
        String mergeTaskIndsStr = (String)this.getView().getFormShowParameter().getCustomParam("mergeTaskInds");
        HashMap taskMap = new HashMap(16);
        if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
            List mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
            Map mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
            if (mergeTaskInds.size() > 1) {
                pageCache.put("mergeTaskCache", "true");
                for (int j = 0; j < mergeTaskIds.size(); ++j) {
                    List areaIndItemList;
                    Long taskItemId = (Long)mergeTaskIds.get(j);
                    Map areaRegIndicaItemMap = (Map)mergeTaskInds.get(taskItemId);
                    if (!areaRegIndicaItemMap.containsKey(areaId) || (areaIndItemList = (List)areaRegIndicaItemMap.get(areaId)) == null) continue;
                    if (taskItemId.equals(taskId)) {
                        crossIndicatorIds.addAll(areaIndItemList);
                    }
                    List indicatorIds = taskMap.get(taskItemId) == null ? new ArrayList(10) : (List)taskMap.get(taskItemId);
                    indicatorIds.addAll(areaIndItemList);
                    taskMap.put(taskItemId, indicatorIds);
                }
            } else {
                Map areaIndicaMap = (Map)mergeTaskInds.get(taskId);
                List areaIndItemList = (List)areaIndicaMap.get(areaId);
                if (areaIndItemList != null) {
                    crossIndicatorIds.addAll(areaIndItemList);
                }
                taskMap.put(taskId, crossIndicatorIds);
            }
        }
        DynamicObject[] indicatorDys = APP_SERVICE.queryIndicator(areaId, AreaRegEnum.NORM_INDCTR_AREA, Boolean.valueOf(this.isCrossEval()), crossIndicatorIds);
        boolean firstNodeAndRole = APP_SERVICE.isFirstNodeAndRole(taskId);
        if (firstNodeAndRole) {
            this.addEntryRowAndSetInitData(indicatorDys, conf);
        } else {
            HashMap<Long, DynamicObject> indEvalRecordMap = new HashMap(16);
            Map<Long, Object> indEvalScoreRecordMap = new HashMap<Long, DynamicObject>(16);
            if (!this.isCrossEval() && !ObjEvaluationUtils.isPreRoleNodeIsCross(this.getView(), taskId)) {
                indEvalRecordMap = APP_SERVICE.queryIndicatorEvalRecordOfPreRoleLastTask(taskId, AreaRegEnum.NORM_INDCTR_AREA);
                indEvalScoreRecordMap = APP_SERVICE.queryIndicatorEvalScoreRecordOfPreRoleLastTask(taskId, AreaRegEnum.NORM_INDCTR_AREA);
            } else {
                IndicatorEvalRecordBo evalRecordBo;
                if (!this.isCrossEval()) {
                    taskMap = new HashMap(16);
                    ArrayList<Long> indicatorIdList = new ArrayList<Long>(10);
                    if (indicatorDys != null) {
                        for (DynamicObject indicatorDy : indicatorDys) {
                            if (indicatorDy == null || indicatorDy.getPkValue() == null || indicatorDy.getLong("id") == 0L) continue;
                            long indicatorDyPkValue = indicatorDy.getLong("id");
                            indicatorIdList.add(indicatorDyPkValue);
                        }
                    }
                    taskMap.put(taskId, indicatorIdList);
                }
                if ((evalRecordBo = APP_SERVICE.queryPreTaskCrossEvalRecord(taskMap, AreaRegEnum.NORM_INDCTR_AREA)) != null) {
                    indEvalRecordMap = evalRecordBo.getFinishEvalRecordMap();
                    indEvalScoreRecordMap = evalRecordBo.getScoreEvalRecordMap();
                }
            }
            this.addEntryRowAndSetInitData(indicatorDys, indEvalRecordMap, indEvalScoreRecordMap, conf, false);
        }
    }

    public void setEntryRowDataFromInd(DynamicObject[] indicatorDys, DynamicObject conf) {
        DynamicObjectCollection entryColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (entryColl == null || entryColl.isEmpty()) {
            return;
        }
        BigDecimal soeVal = this.getDefaultSoe(conf);
        if (soeVal != null && soeVal.compareTo(BigDecimal.ZERO) == 0) {
            soeVal = null;
        }
        for (DynamicObject indicator : indicatorDys) {
            if (indicator == null || indicator.getPkValue() == null || indicator.getLong("id") == 0L) continue;
            long indicatorId = indicator.getLong("id");
            for (DynamicObject entry : entryColl) {
                long entryIndicatorId;
                if (entry == null || indicatorId != (entryIndicatorId = entry.getLong("indicator.id"))) continue;
                for (String setStringField : SET_STRING_FIELDS) {
                    String fieldValObj = indicator.get(setStringField) == null ? "" : indicator.get(setStringField);
                    entry.set(setStringField, (Object)fieldValObj);
                }
                BigDecimal initAdjustVal = this.getInitAdjustVal(conf, indicator);
                entry.set("soe", (Object)soeVal);
                entry.set("adjustval", (Object)initAdjustVal);
                entry.set("realfinishdate", indicator.get("realfinishdate"));
            }
        }
    }

    public void setEntryRowInitData(DynamicObject[] indicatorDys, Map<Long, DynamicObject> indEvalRecordMap, Map<Long, DynamicObject> indEvalScoreRecordMap, DynamicObject conf) {
        boolean isNeedUpdateEntryView = false;
        boolean openAdjustScore = ObjEvaluationUtils.isOpenAdjustScore(conf);
        DynamicObjectCollection entryColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (entryColl == null || entryColl.isEmpty()) {
            return;
        }
        String adjustType = conf.getString("adjusttype") == null ? "" : conf.getString("adjusttype");
        for (DynamicObject indicator : indicatorDys) {
            DynamicObject finishRecord;
            long indicatorId = indicator.getLong("id");
            if (indicator == null || indicator.getPkValue() == null || indicatorId == 0L) continue;
            if (indEvalRecordMap != null && (finishRecord = indEvalRecordMap.get(indicator.getPkValue())) != null) {
                for (DynamicObject entry : entryColl) {
                    long entryIndicatorId;
                    if (entry == null || indicatorId != (entryIndicatorId = entry.getLong("indicator.id"))) continue;
                    for (String setStringField : SETSTRINGFIELDS_CUS) {
                        String fieldValObj = finishRecord.get(setStringField) == null ? "" : finishRecord.get(setStringField);
                        entry.set(setStringField, (Object)fieldValObj);
                    }
                    entry.set("realfinishdate", indicator.get("realfinishdate"));
                    isNeedUpdateEntryView = true;
                }
            }
            BigDecimal soe = null;
            BigDecimal adjustVal = BigDecimal.ZERO;
            if (indEvalScoreRecordMap == null) continue;
            DynamicObject soeRecord = indEvalScoreRecordMap.get(indicator.getPkValue());
            if (openAdjustScore) {
                BigDecimal initAdjustVal = BigDecimal.ZERO;
                if (AdjustTypeEnum.NORMAL.getValue().equals(adjustType)) {
                    BigDecimal lowerScore = conf.getBigDecimal("lowerscore") == null ? BigDecimal.ZERO : conf.getBigDecimal("lowerscore");
                    BigDecimal upperScore = conf.getBigDecimal("upperscore") == null ? BigDecimal.ZERO : conf.getBigDecimal("upperscore");
                    initAdjustVal = this.getInitAdjustVal(lowerScore, upperScore);
                } else if (AdjustTypeEnum.CUSTOM.getValue().equals(adjustType)) {
                    BigDecimal maxEvalScore = indicator.getBigDecimal("maxevalscore") == null ? BigDecimal.ZERO : indicator.getBigDecimal("maxevalscore");
                    BigDecimal minEvalscore = indicator.getBigDecimal("minevalscore") == null ? BigDecimal.ZERO : indicator.getBigDecimal("minevalscore");
                    initAdjustVal = this.getInitAdjustVal(minEvalscore, maxEvalScore);
                }
                adjustVal = initAdjustVal;
                if (soeRecord != null) {
                    adjustVal = soeRecord.get("adjustval") == null ? BigDecimal.ZERO : soeRecord.get("adjustval");
                }
            } else if (soeRecord != null) {
                soe = soeRecord.get("soe") == null ? BigDecimal.ZERO : soeRecord.get("soe");
            }
            for (DynamicObject entry : entryColl) {
                long entryIndicatorId;
                if (entry == null || indicatorId != (entryIndicatorId = entry.getLong("indicator.id"))) continue;
                entry.set("adjustval", (Object)adjustVal);
                entry.set("soe", (Object)soe);
                isNeedUpdateEntryView = true;
            }
        }
    }

    public void addEntryRowAndSetInitData(DynamicObject[] indicatorDys, DynamicObject conf) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("indicator", new Object[0]);
        vs.addField("soe", new Object[0]);
        vs.addField("adjustval", new Object[0]);
        vs.addField("realfinishdate", new Object[0]);
        vs.addField("qualityres", new Object[0]);
        vs.addField("finishdesc", new Object[0]);
        vs.addField("customfiled1", new Object[0]);
        vs.addField("customfiled2", new Object[0]);
        vs.addField("customfiled3", new Object[0]);
        vs.addField("customfiled4", new Object[0]);
        vs.addField("customfiled5", new Object[0]);
        BigDecimal soeVal = this.getDefaultSoe(conf);
        if (soeVal != null && soeVal.compareTo(BigDecimal.ZERO) == 0) {
            soeVal = null;
        }
        for (DynamicObject indicator : indicatorDys) {
            if (indicator == null || indicator.getPkValue() == null || indicator.getLong("id") == 0L) continue;
            String customfiled1 = indicator.get("customfiled1") == null ? "" : indicator.get("customfiled1");
            String customfiled2 = indicator.get("customfiled2") == null ? "" : indicator.get("customfiled2");
            String customfiled3 = indicator.get("customfiled3") == null ? "" : indicator.get("customfiled3");
            String customfiled4 = indicator.get("customfiled4") == null ? "" : indicator.get("customfiled4");
            String customfiled5 = indicator.get("customfiled5") == null ? "" : indicator.get("customfiled5");
            Object realfinishdate = indicator.get("realfinishdate");
            String qualityres = indicator.get("qualityres") == null ? "" : indicator.get("qualityres");
            String finishdesc = indicator.get("finishdesc") == null ? "" : indicator.get("finishdesc");
            BigDecimal initAdjustVal = this.getInitAdjustVal(conf, indicator);
            vs.addRow(new Object[]{indicator.getPkValue(), soeVal, initAdjustVal, realfinishdate, qualityres, finishdesc, customfiled1, customfiled2, customfiled3, customfiled4, customfiled5});
        }
        this.updateEntryData(vs);
    }

    private void addMergeIndicators() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long areaId = (Long)formShowParameter.getCustomParam("area");
        String mergeTaskIdsStr = (String)formShowParameter.getCustomParam("mergeTaskIds");
        String mergeTaskIndsStr = (String)formShowParameter.getCustomParam("mergeTaskInds");
        Long taskId = (Long)formShowParameter.getCustomParam("flowrutask");
        if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
            List mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
            Map mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
            Map taskInfoMap = APP_SERVICE.queryTaskMap(mergeTaskIds);
            List<Object> mergeIndIdList = new ArrayList(10);
            ArrayList<Long> mergeTaskIdList = new ArrayList<Long>(10);
            HashMap indTaskMap = new HashMap(16);
            if (mergeTaskInds.size() > 1) {
                for (int j = 0; j < mergeTaskIds.size(); ++j) {
                    List areaIndItemList;
                    Long taskItemId = (Long)mergeTaskIds.get(j);
                    mergeTaskIdList.add(taskItemId);
                    Map areaRegIndicaItemMap = (Map)mergeTaskInds.get(taskItemId);
                    if (!areaRegIndicaItemMap.containsKey(areaId) || (areaIndItemList = (List)areaRegIndicaItemMap.get(areaId)) == null) continue;
                    mergeIndIdList.addAll(areaIndItemList);
                    for (int i = 0; i < areaIndItemList.size(); ++i) {
                        indTaskMap.put(areaIndItemList.get(i), taskItemId);
                    }
                }
                DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
                List entryIndIdList = entry.stream().map(obj -> obj.getLong("indicator.id")).collect(Collectors.toList());
                mergeIndIdList = mergeIndIdList.stream().filter(obj -> !entryIndIdList.contains(obj)).collect(Collectors.toList());
                Collections.sort(mergeIndIdList);
                if (!mergeIndIdList.isEmpty()) {
                    DynamicObjectCollection entryColl;
                    TableValueSetter vs = new TableValueSetter(new String[0]);
                    vs.addField("indactevalobj", new Object[0]);
                    vs.addField("indassessyear", new Object[0]);
                    vs.addField("indassessperiod", new Object[0]);
                    vs.addField("indactivity", new Object[0]);
                    vs.addField("indperforg", new Object[0]);
                    vs.addField("indflowrutask", new Object[0]);
                    vs.addField("indflowrunode", new Object[0]);
                    vs.addField("indflowrurole", new Object[0]);
                    vs.addField("indflowruproc", new Object[0]);
                    vs.addField("indarea", new Object[0]);
                    vs.addField("indicator", new Object[0]);
                    vs.addField("adjustval", new Object[0]);
                    vs.addField("soe", new Object[0]);
                    vs.addField("realfinishdate", new Object[0]);
                    vs.addField("qualityres", new Object[0]);
                    vs.addField("finishdesc", new Object[0]);
                    vs.addField("evaldesc", new Object[0]);
                    vs.addField("customfiled1", new Object[0]);
                    vs.addField("customfiled2", new Object[0]);
                    vs.addField("customfiled3", new Object[0]);
                    vs.addField("customfiled4", new Object[0]);
                    vs.addField("customfiled5", new Object[0]);
                    vs.addField("iscanedit", new Object[0]);
                    vs.addField("indcreator", new Object[0]);
                    vs.addField("indcreatetime", new Object[0]);
                    vs.addField("indmodifier", new Object[0]);
                    vs.addField("indmodifytime", new Object[0]);
                    Map genEvalRecordMap = APP_SERVICE.queryEvalRecordByTaskIdsAndIndIds(AreaRegEnum.NORM_INDCTR_AREA, mergeTaskIdList, mergeIndIdList);
                    Long userId = RequestContext.get().getCurrUserId();
                    for (int i = 0; i < mergeIndIdList.size(); ++i) {
                        Long indId = (Long)mergeIndIdList.get(i);
                        DynamicObject evalObj = (DynamicObject)genEvalRecordMap.get(indId);
                        if (evalObj != null) {
                            Long actEvalObjId = evalObj.getLong("actevalobj");
                            int assessYear = evalObj.getInt("assessyear");
                            String assessPeriod = evalObj.getString("assessperiod");
                            Long activityId = evalObj.getLong("activity");
                            Long perforgId = evalObj.getLong("perforg");
                            Long flowrutaskId = evalObj.getLong("flowrutask.id");
                            Long flowrunodeId = evalObj.getLong("flowrunode.id");
                            Long flowruroleId = evalObj.getLong("flowrurole.id");
                            Long flowruprocId = evalObj.getLong("flowruproc");
                            Long areaInsId = evalObj.getLong("area");
                            BigDecimal adjustval = evalObj.getBigDecimal("adjustval");
                            BigDecimal soe = evalObj.getBigDecimal("soe");
                            Date realFinishDate = evalObj.getDate("realfinishdate");
                            String qualityRes = evalObj.getString("qualityres");
                            ILocaleString finishDes = evalObj.getLocaleString("finishdesc");
                            ILocaleString evalDesc = evalObj.getLocaleString("evaldesc");
                            ILocaleString customfiled1 = evalObj.getLocaleString("customfiled1");
                            ILocaleString customfiled2 = evalObj.getLocaleString("customfiled2");
                            ILocaleString customfiled3 = evalObj.getLocaleString("customfiled3");
                            ILocaleString customfiled4 = evalObj.getLocaleString("customfiled4");
                            ILocaleString customfiled5 = evalObj.getLocaleString("customfiled5");
                            Boolean iscanedit = evalObj.getBoolean("iscanedit");
                            Long creator = evalObj.getLong("creator.id");
                            Date createTime = evalObj.getDate("createtime");
                            Long modifier = evalObj.getLong("modifier.id");
                            Date modifyTime = evalObj.getDate("modifytime");
                            vs.addRow(new Object[]{actEvalObjId, assessYear, assessPeriod, activityId, perforgId, flowrutaskId, flowrunodeId, flowruroleId, flowruprocId, areaInsId, indId, adjustval, soe, realFinishDate, qualityRes, finishDes, evalDesc, customfiled1, customfiled2, customfiled3, customfiled4, customfiled5, iscanedit, creator, createTime, modifier, modifyTime});
                            continue;
                        }
                        Long taskItemId = (Long)indTaskMap.get(indId);
                        Map taskMap = (Map)taskInfoMap.get(taskItemId);
                        Long actEvalObjId = (Long)formShowParameter.getCustomParam("actevalobj");
                        int assessYear = (Integer)formShowParameter.getCustomParam("assessyear");
                        String assessPeriod = (String)formShowParameter.getCustomParam("assessperiod");
                        Long activityId = (Long)formShowParameter.getCustomParam("activity");
                        Object perforgId = formShowParameter.getCustomParam("perforg");
                        Long flowrutaskId = (Long)taskMap.get("flowrutask");
                        Long flowrunodeId = (Long)taskMap.get("flowrunode");
                        Long flowruroleId = (Long)taskMap.get("flowrurole");
                        Long flowruprocId = (Long)taskMap.get("flowruproc");
                        Long areaInsId = (Long)formShowParameter.getCustomParam("area");
                        BigDecimal adjustval = BigDecimal.ZERO;
                        BigDecimal soe = BigDecimal.ZERO;
                        Date realFinishDate = new Date();
                        String qualityRes = "";
                        LocaleString finishDes = new LocaleString("");
                        LocaleString evalDesc = new LocaleString("");
                        LocaleString customfiled1 = new LocaleString("");
                        LocaleString customfiled2 = new LocaleString("");
                        LocaleString customfiled3 = new LocaleString("");
                        LocaleString customfiled4 = new LocaleString("");
                        LocaleString customfiled5 = new LocaleString("");
                        Boolean iscanedit = Boolean.TRUE;
                        Long creator = userId;
                        Date createTime = new Date();
                        Long modifier = userId;
                        Date modifyTime = new Date();
                        vs.addRow(new Object[]{actEvalObjId, assessYear, assessPeriod, activityId, perforgId, flowrutaskId, flowrunodeId, flowruroleId, flowruprocId, areaInsId, indId, adjustval, soe, realFinishDate, qualityRes, finishDes, evalDesc, customfiled1, customfiled2, customfiled3, customfiled4, customfiled5, iscanedit, creator, createTime, modifier, modifyTime});
                    }
                    int count = vs.getCount();
                    if (count > 0) {
                        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                        OperationStatus status = this.getView().getFormShowParameter().getStatus();
                        if (OperationStatus.VIEW == status) {
                            model.beginInit();
                            model.batchCreateNewEntryRow("entryentity", vs);
                            model.endInit();
                        } else {
                            model.batchCreateNewEntryRow("entryentity", vs);
                        }
                        this.getView().updateView("entryentity");
                    }
                    if ((entryColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity")) != null) {
                        entryColl.sort((o1, o2) -> {
                            if (o1 != null && o2 != null) {
                                int seq2;
                                int seq1 = o1.getInt("indicator.entryseq");
                                if (seq1 >= (seq2 = o2.getInt("indicator.entryseq"))) {
                                    return 1;
                                }
                                return -1;
                            }
                            return 0;
                        });
                    }
                }
            }
        }
    }

    public void addImportIndicators() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long areaId = (Long)formShowParameter.getCustomParam("area");
        boolean crossEval = this.isCrossEval();
        if (!crossEval) {
            DynamicObjectCollection entryColl;
            ArrayList<Long> importIndicators = new ArrayList<Long>(10);
            DynamicObject[] genIndicators = APP_SERVICE.queryIndicatorForGen(areaId);
            if (genIndicators != null && genIndicators.length > 0) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                HashSet<Long> existsIndicatorIdSet = new HashSet<Long>(16);
                for (DynamicObject[] object : entryEntity) {
                    if (object == null) continue;
                    long indId = object.getLong("indicator.id");
                    existsIndicatorIdSet.add(indId);
                }
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("indicator", new Object[0]);
                vs.addField("soe", new Object[0]);
                vs.addField("realfinishdate", new Object[0]);
                vs.addField("qualityres", new Object[0]);
                vs.addField("finishdesc", new Object[0]);
                vs.addField("customfiled1", new Object[0]);
                vs.addField("customfiled2", new Object[0]);
                vs.addField("customfiled3", new Object[0]);
                vs.addField("customfiled4", new Object[0]);
                vs.addField("customfiled5", new Object[0]);
                for (DynamicObject genIndicatorOfImp : genIndicators) {
                    BigDecimal iecs;
                    if (genIndicatorOfImp == null || genIndicatorOfImp.getPkValue() == null || genIndicatorOfImp.getLong("id") == 0L) continue;
                    Long pkValue = (Long)genIndicatorOfImp.getPkValue();
                    importIndicators.add(pkValue);
                    BigDecimal bigDecimal = iecs = genIndicatorOfImp.getBigDecimal("iecs") == null ? BigDecimal.ZERO : genIndicatorOfImp.getBigDecimal("iecs");
                    if (existsIndicatorIdSet.contains(pkValue)) continue;
                    String customfiled1 = genIndicatorOfImp.get("customfiled1") == null ? "" : genIndicatorOfImp.get("customfiled1");
                    String customfiled2 = genIndicatorOfImp.get("customfiled2") == null ? "" : genIndicatorOfImp.get("customfiled2");
                    String customfiled3 = genIndicatorOfImp.get("customfiled3") == null ? "" : genIndicatorOfImp.get("customfiled3");
                    String customfiled4 = genIndicatorOfImp.get("customfiled4") == null ? "" : genIndicatorOfImp.get("customfiled4");
                    String customfiled5 = genIndicatorOfImp.get("customfiled5") == null ? "" : genIndicatorOfImp.get("customfiled5");
                    Object realfinishdate = genIndicatorOfImp.get("realfinishdate");
                    String qualityres = genIndicatorOfImp.get("qualityres") == null ? "" : genIndicatorOfImp.get("qualityres");
                    String finishdesc = genIndicatorOfImp.get("finishdesc") == null ? "" : genIndicatorOfImp.get("finishdesc");
                    vs.addRow(new Object[]{pkValue, iecs, realfinishdate, qualityres, finishdesc, customfiled1, customfiled2, customfiled3, customfiled4, customfiled5});
                }
                int count = vs.getCount();
                if (count > 0) {
                    this.getView().getPageCache().put("IMPORT_GEN_INDICATOR_ID_LIST", JSON.toJSONString(importIndicators));
                    AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                    OperationStatus status = this.getView().getFormShowParameter().getStatus();
                    if (OperationStatus.VIEW == status) {
                        model.beginInit();
                        model.batchCreateNewEntryRow("entryentity", vs);
                        model.endInit();
                    } else {
                        model.batchCreateNewEntryRow("entryentity", vs);
                    }
                    this.getView().updateView("entryentity");
                }
            }
            if ((entryColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity")) != null) {
                entryColl.sort((o1, o2) -> {
                    if (o1 != null && o2 != null) {
                        int seq2;
                        int seq1 = o1.getInt("indicator.entryseq");
                        if (seq1 >= (seq2 = o2.getInt("indicator.entryseq"))) {
                            return 1;
                        }
                        return -1;
                    }
                    return 0;
                });
            }
        }
    }

    private BigDecimal getInitAdjustVal(DynamicObject conf, DynamicObject indicator) {
        BigDecimal initAdjustVal = BigDecimal.ZERO;
        boolean openAdjustScore = ObjEvaluationUtils.isOpenAdjustScore(conf);
        if (openAdjustScore) {
            String adjustType;
            String string = adjustType = conf.getString("adjusttype") == null ? "" : conf.getString("adjusttype");
            if (AdjustTypeEnum.NORMAL.getValue().equals(adjustType)) {
                BigDecimal lowerScore = conf.getBigDecimal("lowerscore") == null ? BigDecimal.ZERO : conf.getBigDecimal("lowerscore");
                BigDecimal upperScore = conf.getBigDecimal("upperscore") == null ? BigDecimal.ZERO : conf.getBigDecimal("upperscore");
                initAdjustVal = this.getInitAdjustVal(lowerScore, upperScore);
            } else if (AdjustTypeEnum.CUSTOM.getValue().equals(adjustType)) {
                BigDecimal maxEvalScore = indicator.getBigDecimal("maxevalscore") == null ? BigDecimal.ZERO : indicator.getBigDecimal("maxevalscore");
                BigDecimal minEvalscore = indicator.getBigDecimal("minevalscore") == null ? BigDecimal.ZERO : indicator.getBigDecimal("minevalscore");
                initAdjustVal = this.getInitAdjustVal(minEvalscore, maxEvalScore);
            }
        }
        return initAdjustVal;
    }

    private BigDecimal getLowLimitSoe(DynamicObject conf, boolean consistentWithArea) {
        BigDecimal lowLimitSoe = BigDecimal.ZERO;
        String LowLimitSoeValueCache = this.getView().getPageCache().get("LowLimitSoeValueCache");
        if (!HRStringUtils.isBlank((CharSequence)LowLimitSoeValueCache)) {
            lowLimitSoe = new BigDecimal(LowLimitSoeValueCache);
            return lowLimitSoe;
        }
        if (consistentWithArea) {
            DynamicObject scoreSystem = this.getScoreSystem();
            if (scoreSystem != null) {
                lowLimitSoe = this.getSoeFromScoreSys(scoreSystem);
            }
        } else {
            DynamicObject areaScoreSystem = this.ACTIVITY_SERVICE.queryScoreSystemById(Long.valueOf(ObjEvaluationUtils.getAreaScoreSystemId(conf)));
            if (areaScoreSystem != null) {
                lowLimitSoe = this.getSoeFromScoreSys(areaScoreSystem);
            }
        }
        this.getView().getPageCache().put("LowLimitSoeValueCache", lowLimitSoe.toPlainString());
        return lowLimitSoe;
    }

    private BigDecimal getSoeFromScoreSys(DynamicObject scoreSystem) {
        BigDecimal lowLimitSoe = BigDecimal.ZERO;
        if (scoreSystem != null) {
            BigDecimal minScore = scoreSystem.getBigDecimal("minscore") == null ? BigDecimal.ZERO : scoreSystem.getBigDecimal("minscore");
            BigDecimal maxScore = scoreSystem.getBigDecimal("maxscore") == null ? BigDecimal.ZERO : scoreSystem.getBigDecimal("maxscore");
            lowLimitSoe = BigDecimal.ZERO.compareTo(minScore) >= 0 && maxScore.compareTo(BigDecimal.ZERO) >= 0 ? BigDecimal.ZERO : minScore;
        }
        return lowLimitSoe;
    }

    public BigDecimal getDefaultSoe(DynamicObject conf) {
        boolean turnOnOverLimit;
        boolean isWeightCal = false;
        String scoreCalcWay = (String)this.getView().getFormShowParameter().getCustomParam("scorecalcway");
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            isWeightCal = true;
        }
        if ((turnOnOverLimit = this.isTurnOnOverLimit()) || !isWeightCal) {
            return null;
        }
        boolean consistentWithArea = this.getConsistentWithArea(conf);
        return this.getLowLimitSoe(conf, consistentWithArea);
    }

    private boolean getConsistentWithArea(DynamicObject conf) {
        String consistentWithAreaCache = this.getView().getPageCache().get("consistentWithAreaCache");
        boolean consistentWithArea = false;
        if (!HRStringUtils.isBlank((CharSequence)consistentWithAreaCache)) {
            if ("true".equals(consistentWithAreaCache)) {
                consistentWithArea = true;
            } else if ("false".equals(consistentWithAreaCache)) {
                consistentWithArea = false;
            } else {
                consistentWithArea = ObjEvaluationUtils.isConsistentWithArea(this.getView(), ObjEvaluationUtils.getAreaScoreSystemId(conf));
                this.getView().getPageCache().put("consistentWithAreaCache", String.valueOf(consistentWithArea));
            }
        } else {
            consistentWithArea = ObjEvaluationUtils.isConsistentWithArea(this.getView(), ObjEvaluationUtils.getAreaScoreSystemId(conf));
            this.getView().getPageCache().put("consistentWithAreaCache", String.valueOf(consistentWithArea));
        }
        return consistentWithArea;
    }

    public void addEntryRowAndSetInitData(DynamicObject[] indicatorDys, Map<Long, DynamicObject> indEvalRecordMap, Map<Long, DynamicObject> indEvalScoreRecordMap, DynamicObject conf, Boolean isCarryEvalDesc) {
        if (isCarryEvalDesc == null) {
            isCarryEvalDesc = false;
        }
        boolean openAdjustScore = ObjEvaluationUtils.isOpenAdjustScore(conf);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("indicator", new Object[0]);
        vs.addField("adjustval", new Object[0]);
        vs.addField("soe", new Object[0]);
        vs.addField("realfinishdate", new Object[0]);
        vs.addField("qualityres", new Object[0]);
        vs.addField("finishdesc", new Object[0]);
        vs.addField("customfiled1", new Object[0]);
        vs.addField("customfiled2", new Object[0]);
        vs.addField("customfiled3", new Object[0]);
        vs.addField("customfiled4", new Object[0]);
        vs.addField("customfiled5", new Object[0]);
        vs.addField("evaldesc", new Object[0]);
        String adjustType = conf.getString("adjusttype") == null ? "" : conf.getString("adjusttype");
        ArrayList<Long> addedIndicatorIdList = new ArrayList<Long>(10);
        for (DynamicObject indicator : indicatorDys) {
            DynamicObject finishRecord;
            long indicatorId = indicator.getLong("id");
            if (indicator == null || indicator.getPkValue() == null || indicatorId == 0L || addedIndicatorIdList.contains(indicatorId)) continue;
            addedIndicatorIdList.add(indicatorId);
            BigDecimal soe = null;
            BigDecimal adjustVal = BigDecimal.ZERO;
            Object realfinishdate = null;
            String qualityres = "";
            String finishdesc = "";
            String customfiled1 = "";
            String customfiled2 = "";
            String customfiled3 = "";
            String customfiled4 = "";
            String customfiled5 = "";
            String evaldesc = "";
            if (indEvalRecordMap != null && (finishRecord = indEvalRecordMap.get(indicator.getPkValue())) != null) {
                realfinishdate = finishRecord.get("realfinishdate");
                qualityres = finishRecord.get("qualityres") == null ? "" : finishRecord.get("qualityres");
                finishdesc = finishRecord.get("finishdesc") == null ? "" : finishRecord.get("finishdesc");
                customfiled1 = finishRecord.get("customfiled1") == null ? "" : finishRecord.get("customfiled1");
                customfiled2 = finishRecord.get("customfiled2") == null ? "" : finishRecord.get("customfiled2");
                customfiled3 = finishRecord.get("customfiled3") == null ? "" : finishRecord.get("customfiled3");
                customfiled4 = finishRecord.get("customfiled4") == null ? "" : finishRecord.get("customfiled4");
                customfiled5 = finishRecord.get("customfiled5") == null ? "" : finishRecord.get("customfiled5");
                String string = evaldesc = finishRecord.get("evaldesc") == null ? "" : finishRecord.get("evaldesc");
            }
            if (indEvalScoreRecordMap != null) {
                DynamicObject soeRecord = indEvalScoreRecordMap.get(indicator.getPkValue());
                if (openAdjustScore) {
                    BigDecimal initAdjustVal = BigDecimal.ZERO;
                    if (AdjustTypeEnum.NORMAL.getValue().equals(adjustType)) {
                        BigDecimal lowerScore = conf.getBigDecimal("lowerscore") == null ? BigDecimal.ZERO : conf.getBigDecimal("lowerscore");
                        BigDecimal upperScore = conf.getBigDecimal("upperscore") == null ? BigDecimal.ZERO : conf.getBigDecimal("upperscore");
                        initAdjustVal = this.getInitAdjustVal(lowerScore, upperScore);
                    } else if (AdjustTypeEnum.CUSTOM.getValue().equals(adjustType)) {
                        BigDecimal maxEvalScore = indicator.getBigDecimal("maxevalscore") == null ? BigDecimal.ZERO : indicator.getBigDecimal("maxevalscore");
                        BigDecimal minEvalscore = indicator.getBigDecimal("minevalscore") == null ? BigDecimal.ZERO : indicator.getBigDecimal("minevalscore");
                        initAdjustVal = this.getInitAdjustVal(minEvalscore, maxEvalScore);
                    }
                    adjustVal = initAdjustVal;
                    if (soeRecord != null) {
                        adjustVal = soeRecord.get("adjustval") == null ? BigDecimal.ZERO : soeRecord.get("adjustval");
                    }
                } else if (soeRecord != null) {
                    BigDecimal bigDecimal = soe = soeRecord.get("soe") == null ? BigDecimal.ZERO : soeRecord.get("soe");
                }
            }
            if (!isCarryEvalDesc.booleanValue()) {
                evaldesc = "";
            }
            vs.addRow(new Object[]{indicator.getPkValue(), adjustVal, soe, realfinishdate, qualityres, finishdesc, customfiled1, customfiled2, customfiled3, customfiled4, customfiled5, evaldesc});
        }
        this.updateEntryData(vs);
    }

    private void updateEntryData(TableValueSetter vs) {
        int count = vs.getCount();
        if (count > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", vs);
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void addEntryRowAndSetInitData(NodeRoleConfigBo lastRoleConfig, DynamicObject[] indicatorDys, Map<Long, DynamicObject> IndEvalRecordMap) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("indicator", new Object[0]);
        vs.addField("soe", new Object[0]);
        vs.addField("realfinishdate", new Object[0]);
        vs.addField("qualityres", new Object[0]);
        vs.addField("finishdesc", new Object[0]);
        for (DynamicObject indicator : indicatorDys) {
            DynamicObject IndEvalRecord = IndEvalRecordMap.get(indicator.getPkValue());
            BigDecimal soe = null;
            Object realfinishdate = null;
            Object qualityres = "";
            Object finishdesc = "";
            if (IndEvalRecord != null) {
                soe = lastRoleConfig != null && lastRoleConfig.getIsscorenext() != false ? IndEvalRecord.get("soe") : BigDecimal.ZERO;
                realfinishdate = IndEvalRecord.get("realfinishdate");
                qualityres = IndEvalRecord.get("qualityres");
                finishdesc = IndEvalRecord.get("finishdesc");
            }
            vs.addRow(new Object[]{indicator.getPkValue(), soe, realfinishdate, qualityres, finishdesc});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public Map<String, List<String>> getConfigColKeyMapByCategory(DynamicObject conf) {
        HashMap<String, List<String>> areaCateMap = new HashMap<String, List<String>>(16);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        if (entryEntity != null) {
            for (DynamicObject configCol : entryEntity) {
                String fieldNumber = configCol.getString("areafield.number");
                String fieldCategory = configCol.getString("areafield.category");
                ArrayList<String> fieldList = (ArrayList<String>)areaCateMap.get(fieldCategory);
                if (fieldList == null) {
                    fieldList = new ArrayList<String>(10);
                }
                fieldList.add(fieldNumber);
                areaCateMap.put(fieldCategory, fieldList);
            }
        }
        return areaCateMap;
    }

    private DynamicObject getScoreSystem() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long scoreSystemId = formShowParameter.getCustomParam("scoresystem") == null ? Long.valueOf(0L) : (Long)formShowParameter.getCustomParam("scoresystem");
        return this.ACTIVITY_SERVICE.queryScoreSystemById(scoreSystemId);
    }
}

