/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.area;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.common.enums.assessrule.EvalWayEnum;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationIsNeedCheckOseService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationUpdateOseService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.impl.SumAreaEvaluationIsNeedCheckServiceImpl;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.impl.SumAreaEvaluationUpdateOseServiceImpl;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.model.NodeRoleConfigBo;

public class SumAreaEvaluationEdit
extends HRDataBaseEdit {
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final Log LOGGER = LogFactory.getLog(SumAreaEvaluationEdit.class);
    private static final String[] INIT_FIELDS = new String[]{"actevalobj", "assessyear", "assessperiod", "activity", "perforg", "flowrunode", "flowrurole", "flowrutask", "flowruproc"};
    public static final String TIPS = "tips";

    public void afterCreateNewData(EventObject e) {
        ObjEvaluationUtils.cacheBindingData(this.getView().getParentView(), true);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        for (String initField : INIT_FIELDS) {
            Object fieldValue = parameter.getCustomParam(initField);
            if (fieldValue == null) continue;
            this.getModel().setValue(initField, fieldValue);
        }
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        Long actEvalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        Long lastTaskIdOfNextGrade = APP_SERVICE.queryPreRoleLastTaskOfNextGrade(taskId);
        if (lastTaskIdOfNextGrade == null || lastTaskIdOfNextGrade == 0L) {
            Object oseVal = this.getModel().getValue("ose");
            if (oseVal == null) {
                this.getModel().setValue("ole", (Object)"");
                this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"oselabel"});
            }
        } else {
            DynamicObject sumAreaEvalRecord = APP_SERVICE.querySumAreaEvalRecord(actEvalObjId, lastTaskIdOfNextGrade);
            if (sumAreaEvalRecord != null) {
                this.getModel().setValue("ole", sumAreaEvalRecord.get("ole"));
                this.getModel().setValue("ose", sumAreaEvalRecord.get("ose"));
            }
        }
        Long lastTaskOfNextEval = APP_SERVICE.queryPreRoleLastTaskOfNextEval(taskId);
        if (lastTaskOfNextEval != null && lastTaskOfNextEval != 0L) {
            this.setSumAreaRecordValue(actEvalObjId, lastTaskOfNextEval, "eval");
        }
    }

    public boolean isGradeCompute(Long taskId) {
        if (taskId == null || taskId == 0L) {
            return false;
        }
        NodeRoleConfigBo roleConfig = APP_SERVICE.queryNodeRoleConfigByTask(taskId);
        if (roleConfig != null) {
            Boolean isGradeCompute = roleConfig.getIsgradecompute();
            return isGradeCompute != null && isGradeCompute != false;
        }
        return false;
    }

    private void setSumAreaRecordValue(Long actEvalObjId, Long lastTaskIdOfIsGradeNext, String field) {
        DynamicObject sumAreaEvalRecord = APP_SERVICE.querySumAreaEvalRecord(actEvalObjId, lastTaskIdOfIsGradeNext);
        if (sumAreaEvalRecord != null) {
            this.getModel().setValue(field, sumAreaEvalRecord.get(field));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ObjEvaluationUtils.cacheBindingData(this.getView().getParentView(), true);
    }

    public BigDecimal getTotalScore(BigDecimal totalScore) {
        Long actEvalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        Map scoreRangeMap = APP_SERVICE.getScoreRangeMap(actEvalObjId);
        BigDecimal maxScore = (BigDecimal)scoreRangeMap.get("maxscore");
        BigDecimal minScore = (BigDecimal)scoreRangeMap.get("minscore");
        totalScore = totalScore.compareTo(minScore) > 0 ? totalScore : minScore;
        totalScore = totalScore.compareTo(maxScore) < 0 ? totalScore : maxScore;
        totalScore = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), totalScore);
        return totalScore;
    }

    public void afterBindData(EventObject e) {
        try {
            BigDecimal oldOse;
            super.afterBindData(e);
            ObjEvaluationUtils.dealSumAreaPreCarry(this.getView());
            this.getView().setVisible(Boolean.FALSE, new String[]{TIPS});
            String sumperflevel = this.getView().getParentView().getPageCache().get("sumperflevel");
            if (StringUtils.equals((CharSequence)sumperflevel, (CharSequence)"false")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"oleap"});
            }
            Long configId = (Long)this.getView().getFormShowParameter().getCustomParam("param_config_id");
            this.showFieldByConfig(configId);
            String customParam = (String)this.getView().getFormShowParameter().getCustomParam("evalValue");
            if (customParam != null) {
                this.getView().getModel().setValue("eval", (Object)new LocaleString(customParam));
            }
            this.getView().updateControlMetadata("ose", DrawAreaUtils.getPcScItemMap(this.getView().getFormShowParameter()));
            this.setEvalFiledProp();
            Long actEvalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
            Map scoreRangeMap = APP_SERVICE.getScoreRangeMap(actEvalObjId);
            BigDecimal maxScore = (BigDecimal)scoreRangeMap.get("maxscore");
            BigDecimal minScore = (BigDecimal)scoreRangeMap.get("minscore");
            String oseStr = this.getView().getParentView().getPageCache().get("param_ose");
            BigDecimal bigDecimal = oldOse = this.getModel().getValue("ose") == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("ose");
            if (!HRStringUtils.isEmpty((String)oseStr)) {
                BigDecimal ose = new BigDecimal(oseStr);
                ose = ose.compareTo(minScore) > 0 ? ose : minScore;
                ose = ose.compareTo(maxScore) < 0 ? ose : maxScore;
                ose = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), ose);
                if (BigDecimal.ZERO.compareTo(ose) == 0) {
                    this.getModel().setValue("ose", (Object)ose);
                    this.calOle(ose, oldOse);
                } else {
                    this.getModel().setValue("ose", (Object)ose);
                }
                this.getView().getParentView().setVisible(Boolean.TRUE, new String[]{"oselabel"});
                this.setLabelText("oselabel", ose.toPlainString());
            }
            if (!this.isCrossEval()) {
                this.setPermsumField(configId);
            }
            this.setTopScoreAndLevel();
            this.getView().getPageCache().put("page_load_finished_key", "true");
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (status == OperationStatus.ADDNEW) {
                ObjEvaluationUtils.calculateScoreFirst(this.getView());
            }
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        finally {
            ObjEvaluationUtils.cacheBindingData(this.getView().getParentView(), false);
        }
    }

    private void setPermsumField(Long configId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List<ContentFieldEntryEvaDto> fieldEntryEvaDtos = this.getPermsumFieldSetting(formShowParameter);
        Map<Long, ContentFieldEntryEvaDto> filePermMap = SumAreaEvaluationEdit.change2PermMap(fieldEntryEvaDtos);
        DynamicObject sumConf = APP_SERVICE.querySumConfInfoById(configId.longValue());
        DynamicObjectCollection entryEntity = sumConf.getDynamicObjectCollection("entryentity");
        HashMap<String, Object> sumPermSetting = new HashMap<String, Object>(16);
        ArrayList<String> mustInputFieldList = new ArrayList<String>(10);
        Boolean isDisplayOse = Boolean.FALSE;
        Boolean isDisplayOle = Boolean.FALSE;
        for (DynamicObject fieldInfo : entryEntity) {
            String fieldKey;
            if (fieldInfo == null || (fieldKey = fieldInfo.getString("areafield.number")) == null) continue;
            long areaFieldId = fieldInfo.getLong("areafield.id");
            ContentFieldEntryEvaDto permFileDto = filePermMap.get(areaFieldId);
            if (permFileDto != null) {
                Boolean displayItem = permFileDto.getFieldDisplayItem() == null ? Boolean.FALSE : permFileDto.getFieldDisplayItem();
                Boolean modifyItem = permFileDto.getFieldModifyItem() == null ? Boolean.FALSE : permFileDto.getFieldModifyItem();
                Boolean mustInputItem = permFileDto.getFieldMustInputItem() == null ? Boolean.FALSE : permFileDto.getFieldMustInputItem();
                switch (fieldKey) {
                    case "ose": {
                        EvalWayEnum evalWay;
                        boolean oseMustEnter;
                        DecimalEdit oseField = (DecimalEdit)this.getControl("ose");
                        oseField.setMustInput(mustInputItem.booleanValue());
                        this.getView().setEnable(modifyItem, new String[]{"ose"});
                        this.getView().setVisible(displayItem, new String[]{"ose"});
                        this.getView().getParentView().setVisible(displayItem, new String[]{"oselabel"});
                        if (!displayItem.booleanValue()) {
                            this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"oseline"});
                            this.getView().sendFormAction(this.getView().getParentView());
                        }
                        boolean bl = oseMustEnter = (evalWay = EvalWayEnum.getEvalWay((String)((String)this.getView().getFormShowParameter().getCustomParam("evalway")))) == EvalWayEnum.SCORE;
                        if (oseMustEnter) {
                            mustInputFieldList.add("ose");
                        }
                        this.setPermsumFieldMap(sumPermSetting, "ose", displayItem, modifyItem, mustInputItem);
                        isDisplayOse = displayItem;
                        break;
                    }
                    case "ole": {
                        ComboEdit comboEdit = (ComboEdit)this.getControl("ole");
                        comboEdit.setMustInput(mustInputItem.booleanValue());
                        this.getView().setEnable(modifyItem, new String[]{"ole"});
                        OperationStatus status = this.getView().getFormShowParameter().getStatus();
                        if (status == OperationStatus.VIEW) {
                            this.getView().setEnable(Boolean.FALSE, new String[]{"ole"});
                        }
                        this.getView().setVisible(displayItem, new String[]{"ole"});
                        this.getView().getParentView().setVisible(displayItem, new String[]{"olelabel"});
                        if (!displayItem.booleanValue()) {
                            this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"oseline"});
                            this.getView().sendFormAction(this.getView().getParentView());
                        }
                        if (mustInputItem.booleanValue()) {
                            mustInputFieldList.add("ole");
                        }
                        this.setPermsumFieldMap(sumPermSetting, "ole", displayItem, modifyItem, mustInputItem);
                        isDisplayOle = displayItem;
                        break;
                    }
                    case "eval": {
                        FieldEdit evalField = (FieldEdit)this.getControl("eval");
                        evalField.setMustInput(mustInputItem.booleanValue());
                        this.getView().setEnable(modifyItem, new String[]{"eval"});
                        this.getView().setVisible(displayItem, new String[]{"eval"});
                        if (mustInputItem.booleanValue()) {
                            mustInputFieldList.add("eval");
                        }
                        this.setPermsumFieldMap(sumPermSetting, "eval", displayItem, modifyItem, mustInputItem);
                        break;
                    }
                }
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{fieldKey});
            this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{fieldKey + "label"});
            if (HRStringUtils.equals((String)fieldKey, (String)"ole")) {
                this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"oseline"});
            }
            this.getView().sendFormAction(this.getView().getParentView());
        }
        if (this.isDisable()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"ose", "ole", "eval"});
        }
        this.getView().getPageCache().put("sumPermSetting", SerializationUtils.toJsonString(sumPermSetting));
        this.getView().getParentView().getPageCache().put("sumPermSetting", SerializationUtils.toJsonString(sumPermSetting));
        if (mustInputFieldList.size() > 0) {
            this.cacheMustInputFields(mustInputFieldList, "SUM_AREA");
        }
        this.addOrderComboItems(isDisplayOse, isDisplayOle);
    }

    private void addOrderComboItems(Boolean isDisplayOse, Boolean isDisplayOle) {
        if (isDisplayOse.equals(Boolean.FALSE) && isDisplayOle.equals(Boolean.FALSE)) {
            return;
        }
        IFormView parentsView = this.getView().getParentView().getParentView();
        if (HRStringUtils.equals((String)parentsView.getEntityId(), (String)"epa_actevalobj_eval_multi")) {
            List<ValueMapItem> metadataComboItems = this.getMetadataComboItems();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            if (metadataComboItems != null) {
                String orderPage;
                for (ValueMapItem metadataComboItem : metadataComboItems) {
                    this.addCombo(comboItems, metadataComboItem.getName(), metadataComboItem.getValue());
                }
                if (isDisplayOse.equals(Boolean.TRUE)) {
                    this.addCombo(comboItems, new LocaleString(ResManager.loadKDString((String)"\u6309\u8bc4\u5206", (String)"SumAreaEvaluationEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0])), "50");
                }
                if (isDisplayOle.equals(Boolean.TRUE)) {
                    this.addCombo(comboItems, new LocaleString(ResManager.loadKDString((String)"\u6309\u7b49\u7ea7", (String)"SumAreaEvaluationEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0])), "60");
                }
                if ((orderPage = parentsView.getPageCache().get("order_page")) != null) {
                    IFormView orderView = this.getView().getView(orderPage);
                    ComboEdit orderway = (ComboEdit)orderView.getControl("orderway");
                    orderway.setComboItems(comboItems);
                    this.getView().sendFormAction(orderView);
                }
            }
        }
    }

    private List<ValueMapItem> getMetadataComboItems() {
        ComboProp ComboProp2 = (ComboProp)MetadataServiceHelper.getDataEntityType((String)"epa_evalobj_order").findProperty("orderway");
        List comboPropItems = ComboProp2.getComboItems();
        return comboPropItems;
    }

    private void addCombo(List<ComboItem> comboItems, LocaleString name, String value) {
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(name);
        comboItem.setValue(value);
        comboItems.add(comboItem);
    }

    private boolean isDisable() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        OperationStatus parentViewStatus = this.getView().getParentView().getFormShowParameter().getStatus();
        return status == OperationStatus.VIEW || parentViewStatus == OperationStatus.VIEW;
    }

    private void cacheMustInputFields(List<String> mustInputFieldList, String areaKey) {
        String entityId;
        IFormView parentsView = this.getView().getParentView().getParentView();
        if (parentsView != null && HRStringUtils.equals((String)(entityId = parentsView.getEntityId()), (String)"epa_actevalobj_eval_multi")) {
            parentsView.getPageCache().put(areaKey + "_mustInputFields", JSON.toJSONString(mustInputFieldList));
        }
    }

    private void setPermsumFieldMap(HashMap<String, Object> sumPermSetting, String field, Boolean displayItem, Boolean modifyItem, Boolean mustInputItem) {
        HashMap<String, Boolean> permsumFieldMap = new HashMap<String, Boolean>(16);
        permsumFieldMap.put("displayItem", displayItem);
        permsumFieldMap.put("modifyItem", modifyItem);
        permsumFieldMap.put("mustInputItem", mustInputItem);
        sumPermSetting.put(field, permsumFieldMap);
    }

    private List<ContentFieldEntryEvaDto> getPermsumFieldSetting(FormShowParameter formShowParameter) {
        List<Object> fieldEntryEvaDtos = new ArrayList<ContentFieldEntryEvaDto>(10);
        String fieldPermSettingJsonStr = (String)formShowParameter.getCustomParam("sumPermSettingJsonStr");
        if (!HRStringUtils.isBlank((CharSequence)fieldPermSettingJsonStr)) {
            fieldEntryEvaDtos = JSON.parseArray((String)fieldPermSettingJsonStr, ContentFieldEntryEvaDto.class);
        }
        return fieldEntryEvaDtos;
    }

    private static Map<Long, ContentFieldEntryEvaDto> change2PermMap(List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        HashMap<Long, ContentFieldEntryEvaDto> filePermMap = new HashMap<Long, ContentFieldEntryEvaDto>(16);
        if (fieldEntryEvaDtos != null) {
            for (ContentFieldEntryEvaDto fieldEntryEvaDto : fieldEntryEvaDtos) {
                if (fieldEntryEvaDto == null) continue;
                filePermMap.put(fieldEntryEvaDto.getAreaFieldId(), fieldEntryEvaDto);
            }
        }
        return filePermMap;
    }

    private void setTopScoreAndLevel() {
        if (this.getView().getParentView() != null) {
            Object oleObj = this.getModel().getDataEntity().get("ole");
            String ole = "";
            if (oleObj != null) {
                ole = oleObj.toString();
            }
            BigDecimal oseBigDecimal = this.getModel().getDataEntity().getBigDecimal("ose");
            Long ruleId = (Long)this.getView().getFormShowParameter().getCustomParam("param_assess_form_id");
            String oleShowText = this.getOleShowText(ruleId, ole);
            if (HRStringUtils.isBlank((CharSequence)oleShowText) || !this.isDisplayOle().booleanValue()) {
                this.getView().getParentView().setVisible(Boolean.valueOf(false), new String[]{"olelabel", "oseline"});
            } else {
                Label la = (Label)this.getView().getParentView().getControl("olelabel");
                la.setText(oleShowText);
                this.getView().getParentView().setVisible(Boolean.valueOf(true), new String[]{"olelabel", "oseline"});
            }
            this.getView().getParentView().setVisible(Boolean.valueOf(true), new String[]{"oselabel"});
            Label oseLabel = (Label)this.getView().getParentView().getControl("oselabel");
            if (oseBigDecimal != null) {
                oseBigDecimal = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), oseBigDecimal);
                oseLabel.setText(oseBigDecimal.toPlainString());
                this.getView().getParentView().updateView("olelabel");
                this.getView().getParentView().updateView("oselabel");
                Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
                DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
                String taskStatus = taskObj.getString("taskstatus");
                if (FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatus) || FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatus)) {
                    if (this.getModel().getValue("ose") != null) {
                        this.updateMultiView("ose", oseBigDecimal.toPlainString());
                    }
                    if (!HRStringUtils.isEmpty((String)oleShowText)) {
                        this.updateMultiView("ole", "/ " + oleShowText);
                    }
                }
            } else {
                oseLabel.setText(null);
            }
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object eval;
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"ose")) {
            BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            this.calOle(newValue, oldValue);
            String oseStr = this.getView().getPageCache().get("oseCacheValue");
            if (HRStringUtils.isNotEmpty((String)oseStr)) {
                if (newValue == null) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{TIPS});
                } else {
                    BigDecimal oldOse = new BigDecimal(oseStr);
                    if (oldOse.compareTo(newValue) == 0) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{TIPS});
                    } else {
                        Label difftips = (Label)this.getControl("difftips");
                        difftips.setText(ResManager.loadKDString((String)"\u539f\u59cb\u8ba1\u7b97\u603b\u5206\u4e3a{0}\u3002", (String)"SumAreaEvaluationEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{oseStr}));
                        this.getView().setVisible(Boolean.FALSE, new String[]{TIPS});
                    }
                }
            }
        } else if (HRStringUtils.equals((String)name, (String)"ole")) {
            Object oleObj = this.getModel().getDataEntity().get("ole");
            String ole = "";
            if (oleObj != null) {
                ole = oleObj.toString();
            }
            Long ruleId = (Long)this.getView().getFormShowParameter().getCustomParam("param_assess_form_id");
            this.setOle(ruleId, "ole", ole);
        } else if ("eval".equals(name) && (eval = this.getView().getModel().getValue("eval")) instanceof OrmLocaleValue) {
            OrmLocaleValue localeValue = (OrmLocaleValue)eval;
            String localeValueStr = localeValue.getLocaleValue();
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.getPageCache().put("evalValue", localeValueStr);
            }
        }
    }

    private void calOle(BigDecimal newValue, Object oldValue) {
        Long ruleId;
        String ole;
        Long actEvalObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actevalobj");
        Map scoreRangeMap = APP_SERVICE.getScoreRangeMap(actEvalObjId);
        BigDecimal maxScore = (BigDecimal)scoreRangeMap.get("maxscore");
        BigDecimal minScore = (BigDecimal)scoreRangeMap.get("minscore");
        String roleConfigStr = this.getPageCache().get("roleConfig");
        Boolean isgradecompute = Boolean.TRUE;
        if (roleConfigStr != null) {
            NodeRoleConfigBo roleConfig = (NodeRoleConfigBo)SerializationUtils.fromJsonString((String)roleConfigStr, NodeRoleConfigBo.class);
            isgradecompute = roleConfig.getIsgradecompute();
        }
        if (HRObjectUtils.isEmpty((Object)newValue)) {
            this.hideOse(isgradecompute);
            return;
        }
        Boolean isNeedCheckOse = true;
        SumAreaEvaluationIsNeedCheckServiceImpl iCheckService = new SumAreaEvaluationIsNeedCheckServiceImpl();
        HRPluginProxy hrCheckPluginProxy = HRPlugInProxyFactory.create((Object)iCheckService, ISumAreaEvaluationIsNeedCheckOseService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationIsNeedCheckOseService#isNeedCheckOse", null);
        List result = hrCheckPluginProxy.callReplaceIfPresent(p -> p.isNeedCheckOse(this.getView()));
        if (result != null && result.size() > 0) {
            isNeedCheckOse = (Boolean)result.get(0);
        }
        if (isNeedCheckOse.booleanValue() && (newValue.compareTo(minScore) < 0 || newValue.compareTo(maxScore) > 0)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\u3002", (String)"SumAreaEvaluationEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore, maxScore}));
            this.getModel().setValue("ose", null);
            return;
        }
        this.getView().getParentView().setVisible(Boolean.TRUE, new String[]{"oselabel"});
        BigDecimal ose = this.getModel().getDataEntity().getBigDecimal("ose");
        ose = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), ose);
        this.setLabelText("oselabel", ose.toPlainString());
        this.updateMultiView("ose", ose.toPlainString());
        if (isgradecompute.equals(Boolean.TRUE) && (ole = APP_SERVICE.calculateLevel(ruleId = (Long)this.getView().getFormShowParameter().getCustomParam("param_assess_form_id"), this.getModel().getDataEntity().getBigDecimal("ose"))) != null) {
            this.getModel().setValue("ole", (Object)ole);
            this.getView().updateView("ole");
            this.setOle(ruleId, "ole", ole);
        }
    }

    private void hideOse(Boolean isgradecompute) {
        this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"oselabel", "oseline"});
        this.getView().sendFormAction(this.getView().getParentView());
        if (isgradecompute.equals(Boolean.TRUE)) {
            this.getModel().setValue("ole", null);
        }
        if (HRStringUtils.equals((String)this.getView().getParentView().getParentView().getEntityId(), (String)"epa_actevalobj_eval_multi")) {
            IFormView multiView = this.getView().getParentView().getParentView();
            IDataModel multiModel = multiView.getModel();
            String selectedRowNumStr = multiView.getPageCache().get("selectedRowNum");
            if (!HRStringUtils.isEmpty((String)selectedRowNumStr)) {
                int selectedRowNum = Integer.parseInt(selectedRowNumStr);
                multiModel.setValue("isshowose", (Object)"0", selectedRowNum);
                if (isgradecompute.equals(Boolean.TRUE)) {
                    multiModel.setValue("isshowole", (Object)"0", selectedRowNum);
                    multiModel.setValue("isshowassessstatus", (Object)"1", selectedRowNum);
                } else {
                    String oleStr;
                    String[] oleSplit;
                    Object ole = multiModel.getValue("ole", selectedRowNum);
                    if (ole != null && (oleSplit = (oleStr = ole.toString()).split("/")) != null && oleSplit.length > 1) {
                        multiModel.setValue("ole", (Object)oleSplit[1], selectedRowNum);
                    }
                }
                Object isshowole = multiModel.getValue("isshowole", selectedRowNum);
                if (isshowole != null && HRStringUtils.equals((String)"0", (String)isshowole.toString())) {
                    multiModel.setValue("isshowassessstatus", (Object)"1", selectedRowNum);
                }
                this.getView().sendFormAction(multiView);
            }
        }
    }

    private void updateMultiView(String filed, String filedValue) {
        if (HRStringUtils.equals((String)this.getView().getParentView().getParentView().getEntityId(), (String)"epa_actevalobj_eval_multi")) {
            IFormView multiView = this.getView().getParentView().getParentView();
            IDataModel multiModel = multiView.getModel();
            String selectedRowNumStr = multiView.getPageCache().get("selectedRowNum");
            if (!HRStringUtils.isEmpty((String)selectedRowNumStr) && !this.isCrossEval()) {
                int selectedRowNum = Integer.parseInt(selectedRowNumStr);
                multiModel.setValue(filed, (Object)filedValue, selectedRowNum);
                if (HRStringUtils.equals((String)filed, (String)"ose")) {
                    multiModel.setValue("isshowose", (Object)"1", selectedRowNum);
                } else if (HRStringUtils.equals((String)filed, (String)"ole")) {
                    multiModel.setValue("isshowole", (Object)"1", selectedRowNum);
                }
                multiModel.setValue("isshowassessstatus", (Object)"0", selectedRowNum);
                multiModel.setValue("status", (Object)FlowRuTaskStatusEnum.PROCESSING.getCode(), selectedRowNum);
                this.getView().sendFormAction(multiView);
            }
        }
    }

    public String getOleShowText(Long ruleId, String ole) {
        if (ruleId == null) {
            return null;
        }
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(ruleId);
        if (perfLevelItems != null) {
            for (ComboItem perfLevelItem : perfLevelItems) {
                LocaleString caption;
                if (perfLevelItem == null) continue;
                String perfLevelItemValue = perfLevelItem.getValue();
                if (ole == null || !ole.equals(perfLevelItemValue) || (caption = perfLevelItem.getCaption()) == null) continue;
                return caption.getLocaleValue();
            }
        }
        return null;
    }

    private void setOle(Long ruleId, String label, String ole) {
        if (HRStringUtils.isBlank((CharSequence)ole) || !this.isDisplayOle().booleanValue()) {
            this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"olelabel", "oseline"});
            this.getView().sendFormAction(this.getView().getParentView());
            this.hideOle();
            return;
        }
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(ruleId);
        if (perfLevelItems != null) {
            for (ComboItem perfLevelItem : perfLevelItems) {
                String perfLevelItemValue = perfLevelItem.getValue();
                String oleValue = perfLevelItem.getCaption().getLocaleValue();
                if (ole == null || !ole.equals(perfLevelItemValue)) continue;
                if (oleValue == null) {
                    this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"olelabel", "oseline"});
                    continue;
                }
                this.getView().getParentView().setVisible(Boolean.TRUE, new String[]{"olelabel", "oseline"});
                this.setLabelText("olelabel", oleValue);
                this.updateMultiView("ole", "/ " + oleValue);
            }
        }
    }

    private void hideOle() {
        if (HRStringUtils.equals((String)this.getView().getParentView().getParentView().getEntityId(), (String)"epa_actevalobj_eval_multi")) {
            IFormView multiView = this.getView().getParentView().getParentView();
            IDataModel multiModel = multiView.getModel();
            String selectedRowNumStr = multiView.getPageCache().get("selectedRowNum");
            if (!HRStringUtils.isEmpty((String)selectedRowNumStr)) {
                int selectedRowNum = Integer.parseInt(selectedRowNumStr);
                multiModel.setValue("isshowole", (Object)"0", selectedRowNum);
                Object isshowose = multiModel.getValue("isshowose", selectedRowNum);
                if (isshowose != null && HRStringUtils.equals((String)"0", (String)isshowose.toString())) {
                    multiModel.setValue("isshowassessstatus", (Object)"1", selectedRowNum);
                }
                this.getView().sendFormAction(multiView);
            }
        }
    }

    private Boolean isDisplayOle() {
        HashMap sumPermSetting;
        boolean flag = false;
        String sumPermSettingStr = this.getView().getPageCache().get("sumPermSetting");
        if (HRStringUtils.isEmpty((String)sumPermSettingStr) && !this.isCrossEval()) {
            Long configId = (Long)this.getView().getFormShowParameter().getCustomParam("param_config_id");
            this.setPermsumField(configId);
            sumPermSettingStr = this.getView().getPageCache().get("sumPermSetting");
        }
        if (sumPermSettingStr != null && (sumPermSetting = (HashMap)SerializationUtils.fromJsonString((String)sumPermSettingStr, HashMap.class)).get("ole") != null) {
            HashMap oleMap = (HashMap)sumPermSetting.get("ole");
            flag = (Boolean)oleMap.get("displayItem");
        }
        return flag;
    }

    private void setLabelText(String label, String text) {
        IFormView parentView = this.getView().getParentView();
        Label activityNameLab = (Label)parentView.getControl(label);
        activityNameLab.setText(text);
        this.getView().sendFormAction(parentView);
    }

    protected void invokeSaveOp() {
        this.getView().getPageCache().put("isInvokeOperation", "true");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        String isInvokeOperation = this.getView().getPageCache().get("isInvokeOperation");
        if (HRStringUtils.equals((String)"save", (String)operateKey) && operationResult.isSuccess()) {
            operationResult.setShowMessage(false);
        }
        if (HRStringUtils.equals((String)"true", (String)isInvokeOperation)) {
            operationResult.setShowMessage(false);
            this.getView().getPageCache().remove("isInvokeOperation");
        }
        if (HRStringUtils.equals((String)"submitvalid", (String)operateKey)) {
            this.validateEnterField(args);
        }
    }

    private void validateEnterField(AfterDoOperationEventArgs args) {
        EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)((String)this.getView().getFormShowParameter().getCustomParam("evalway")));
        boolean oseMustEnter = evalWay == EvalWayEnum.SCORE;
        Long configId = (Long)this.getView().getFormShowParameter().getCustomParam("param_config_id");
        DynamicObject sumConf = APP_SERVICE.querySumConfInfoById(configId.longValue());
        boolean oleMustEnter = false;
        boolean evalMustEnter = false;
        String sumPermSettingStr = this.getView().getPageCache().get("sumPermSetting");
        if (sumPermSettingStr != null) {
            HashMap sumPermSetting = (HashMap)SerializationUtils.fromJsonString((String)sumPermSettingStr, HashMap.class);
            if (sumPermSetting.get("ole") != null) {
                HashMap oleMap = (HashMap)sumPermSetting.get("ole");
                oleMustEnter = (Boolean)oleMap.get("mustInputItem");
            }
            if (sumPermSetting.get("eval") != null) {
                HashMap evalMap = (HashMap)sumPermSetting.get("eval");
                evalMustEnter = (Boolean)evalMap.get("mustInputItem");
            }
        }
        boolean validateOse = oseMustEnter && ObjEvaluationUtils.isEmpty(this.getModel().getValue("ose"));
        boolean validateOle = oleMustEnter && ObjEvaluationUtils.isEmpty(this.getModel().getValue("ole"));
        boolean validateEval = evalMustEnter && ObjEvaluationUtils.isEmpty(this.getModel().getValue("eval"));
        ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();
        if (!this.isCrossEval()) {
            this.validateSumField(validateOse, "ose", errorInfoList);
            this.validateSumField(validateOle, "ole", errorInfoList);
            this.validateSumField(validateEval, "eval", errorInfoList);
        }
        OperationResult operationResult = args.getOperationResult();
        operationResult.setSuccess(ObjectUtils.isEmpty(errorInfoList));
        operationResult.setAllErrorInfo(errorInfoList);
        operationResult.setMessage(sumConf.getString("areacustname"));
    }

    private void validateSumField(boolean validateField, String fieldKey, List<OperateErrorInfo> errorInfoList) {
        if (validateField) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Warning);
            FieldEdit sumField = (FieldEdit)this.getView().getControl(fieldKey);
            if (sumField != null) {
                operateErrorInfo.setMessage(ResManager.loadKDString((String)"{0}\u672a\u586b\u5199", (String)"SumAreaEvaluationEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{sumField.getDisplayName()}));
                errorInfoList.add(operateErrorInfo);
            }
        }
    }

    private boolean isCrossEval() {
        Boolean isCrossEvaluate = (Boolean)this.getView().getParentView().getFormShowParameter().getCustomParam("isCrossEvaluate");
        return isCrossEvaluate != null && isCrossEvaluate != false;
    }

    private void setEvalFiledProp() {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask");
        NodeRoleConfigBo roleConfig = APP_SERVICE.queryNodeRoleConfigByTask(taskId);
        this.getPageCache().put("roleConfig", SerializationUtils.toJsonString((Object)roleConfig));
        EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)((String)this.getView().getFormShowParameter().getCustomParam("evalway")));
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.getView().setEnable(Boolean.valueOf(status != OperationStatus.VIEW), new String[]{"ose"});
        DecimalEdit oseField = (DecimalEdit)this.getControl("ose");
        oseField.setMustInput(evalWay == EvalWayEnum.SCORE);
        FieldEdit evalField = (FieldEdit)this.getControl("eval");
        evalField.setMustInput(roleConfig.getIsevaluate().booleanValue());
    }

    private void showFieldByConfig(Long configId) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"oseap", "oleap", "evalap"});
        DynamicObject sumConf = APP_SERVICE.querySumConfInfoById(configId.longValue());
        DynamicObjectCollection filedEntry = sumConf.getDynamicObjectCollection("entryentity");
        for (DynamicObject filedInfo : filedEntry) {
            DynamicObject filed = filedInfo.getDynamicObject("areafield");
            String filedKey = filed.getString("number");
            boolean isShow = true;
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{filedKey + "ap"});
            FieldEdit evalFiled = (FieldEdit)this.getControl(filedKey);
            if (evalFiled == null) continue;
            String fieldCustName = filedInfo.getString("fieldcustname");
            evalFiled.setCaption(new LocaleString(StringUtils.isEmpty((CharSequence)fieldCustName) ? filed.getString("name") : fieldCustName));
            if (!HRStringUtils.equals((String)filedKey, (String)"ole") || !isShow) continue;
            Long ruleId = (Long)this.getView().getFormShowParameter().getCustomParam("param_assess_form_id");
            List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(ruleId);
            ComboEdit comboEdit = (ComboEdit)this.getControl("ole");
            comboEdit.setComboItems(perfLevelItems);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": {
                Long taskId;
                Long pkValue;
                Object value;
                if (this.isCrossEval()) {
                    args.setCancel(true);
                    break;
                }
                if (this.isCrossEval() && (value = this.getView().getModel().getValue("ose")) == null) {
                    this.getView().getModel().beginInit();
                    this.getView().getModel().setValue("ose", (Object)BigDecimal.ZERO);
                    DynamicObject dataEntity = this.getModel().getDataEntity(true);
                    if (dataEntity != null) {
                        dataEntity.set("ose", (Object)BigDecimal.ZERO);
                    }
                    this.getView().updateView("ose");
                    this.getView().getModel().endInit();
                }
                long max = Integer.MAX_VALUE;
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                dataEntity.set("modifytime", (Object)new Date());
                dataEntity.getDataEntityState().setDirtyFlags(new long[]{max});
                dataEntity.getDataEntityState().setBizChangeFlags(new long[]{max});
                OperationStatus status = this.getView().getFormShowParameter().getStatus();
                if (OperationStatus.EDIT != status || (pkValue = (Long)this.getView().getModel().getDataEntity().getPkValue()) != null && 0L != pkValue || !APP_SERVICE.isExistsSumAreaRecordByTaskId(taskId = (Long)this.getView().getFormShowParameter().getCustomParam("flowrutask"))) break;
                APP_SERVICE.deleteSumAreaRecordByTaskId(taskId);
                APP_SERVICE.saveSumAreaRecord(dataEntity);
                args.setCancel(true);
                break;
            }
            case "submitvalid": {
                break;
            }
            case "updatetotalscore": {
                this.updateTotalScore(source);
                break;
            }
        }
    }

    private void updateTotalScore(AbstractOperate source) {
        BigDecimal finalTotalScoreVal;
        SumAreaEvaluationUpdateOseServiceImpl iService;
        HRPluginProxy hrPluginProxy;
        List ret;
        String totalScoreStr = source.getOption().getVariableValue("totalScore");
        String firstInit = source.getOption().getVariableValue("firstInit");
        LOGGER.info("***firstInit\uff1a{},totalScoreStr:{}", (Object)firstInit, (Object)totalScoreStr);
        BigDecimal totalScoreVal = BigDecimal.ZERO;
        if (!HRStringUtils.isBlank((CharSequence)totalScoreStr)) {
            totalScoreVal = new BigDecimal(totalScoreStr);
        }
        totalScoreVal = ObjEvaluationUtils.setScaleTypeOfFormSetting(this.getView(), totalScoreVal);
        Boolean isNeedCheckOse = true;
        SumAreaEvaluationIsNeedCheckServiceImpl iCheckService = new SumAreaEvaluationIsNeedCheckServiceImpl();
        HRPluginProxy hrCheckPluginProxy = HRPlugInProxyFactory.create((Object)iCheckService, ISumAreaEvaluationIsNeedCheckOseService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationIsNeedCheckOseService#isNeedCheckOse", null);
        List result = hrCheckPluginProxy.callReplaceIfPresent(p -> p.isNeedCheckOse(this.getView()));
        if (result != null && result.size() > 0) {
            isNeedCheckOse = (Boolean)result.get(0);
        }
        if (isNeedCheckOse.booleanValue()) {
            totalScoreVal = this.getTotalScore(totalScoreVal);
        }
        if ((ret = (hrPluginProxy = HRPlugInProxyFactory.create((Object)(iService = new SumAreaEvaluationUpdateOseServiceImpl()), ISumAreaEvaluationUpdateOseService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.evaluate.area.extpoint.ISumAreaEvaluationUpdateOseService#updateOse", null)).callReplaceIfPresent(arg_0 -> this.lambda$updateTotalScore$2(finalTotalScoreVal = totalScoreVal, arg_0))) != null && ret.size() > 0) {
            totalScoreVal = (BigDecimal)ret.get(0);
        }
        this.getView().getPageCache().put("oseCacheValue", totalScoreVal.toString());
        LOGGER.info("***getTotalScore:{}", (Object)firstInit, (Object)totalScoreVal.toString());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long taskId = (Long)formShowParameter.getCustomParam("flowrutask");
        if ("true".equals(firstInit)) {
            if (BigDecimal.ZERO.compareTo(totalScoreVal) == 0) {
                this.getModel().beginInit();
                QFilter qFilter = new QFilter("flowrutask", "=", (Object)taskId);
                qFilter.and(new QFilter("soe", "is not null", null));
                boolean isNotAllNull = QueryServiceHelper.exists((String)"epa_genevalrecord", (QFilter[])new QFilter[]{qFilter});
                if (!isNotAllNull) {
                    isNotAllNull = QueryServiceHelper.exists((String)"epa_addsubevalrecord", (QFilter[])new QFilter[]{qFilter});
                }
                if (!isNotAllNull) {
                    this.getView().getModel().setValue("ose", null);
                } else {
                    this.getView().getModel().setValue("ose", (Object)"");
                }
                this.getView().getModel().setValue("ole", (Object)"");
                this.getView().updateView("ose");
                this.getView().updateView("ole");
                this.setTopScoreAndLevel();
                this.getModel().endInit();
            } else if (!this.isGradeCompute(taskId)) {
                this.getModel().beginInit();
                this.getView().getModel().setValue("ose", (Object)totalScoreVal);
                this.getView().updateView("ose");
                this.setTopScoreAndLevel();
                this.getModel().endInit();
            } else {
                DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
                boolean isrollbacked = taskObj.getBoolean("isrollbacked");
                if (!isrollbacked) {
                    this.getModel().beginInit();
                    this.getView().getModel().setValue("ose", (Object)totalScoreVal);
                    this.getView().updateView("ose");
                    this.setTopScoreAndLevel();
                    this.getModel().endInit();
                } else {
                    this.getView().getModel().setValue("ose", (Object)totalScoreVal);
                    this.getView().updateView("ose");
                    this.setTopScoreAndLevel();
                }
            }
        } else {
            this.getView().getModel().setValue("ose", (Object)totalScoreVal);
            this.getView().updateView("ose");
        }
    }

    private void soeNull2Zero() {
    }

    private /* synthetic */ BigDecimal lambda$updateTotalScore$2(BigDecimal finalTotalScoreVal, ISumAreaEvaluationUpdateOseService p) {
        return p.updateOse(this.getView(), finalTotalScoreVal);
    }
}

