/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evalrecord.area;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.utils.EvaluteDrawEntryEntityUtils;
import kd.opmc.epa.formplugin.web.utils.EvalResultViewUtils;
import kd.opmc.epa.formplugin.web.utils.IndicatorDetailUtils;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;

public class EvalCustomAreaEdit
extends HRDataBaseEdit {
    private final AssessActivityApplicationService ACTIVITY_SERVICE = AssessActivityApplicationService.getInstance();
    private static final Log LOGGER = LogFactory.getLog(EvalCustomAreaEdit.class);
    private static final String[] CUSTOM_AREA_ALL_FIELDS = new String[]{"customfield1", "customfield2", "customfield3", "customfield5", "customfield6", "customfield7", "customfield8", "customfield4", "customfield9", "customfield10"};

    public void initialize() {
        super.initialize();
        Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryCustomConfigByPk(confId);
        if (conf != null) {
            String areaName = conf.getString("areacustname");
            this.getView().getPageCache().put("areaCustomerName", areaName);
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryCustomConfigByPk(confId);
        EvaluteDrawEntryEntityUtils.drawCustomField(args, conf);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ObjEvaluationUtils.cacheBindingData(this.getView(), true);
    }

    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            Long confId = (Long)this.getView().getFormShowParameter().getCustomParam("confid");
            DynamicObject conf = this.ACTIVITY_SERVICE.queryCustomConfigByPk(confId);
            if (conf != null) {
                String areaName = conf.getString("areacustname");
                this.getView().getPageCache().put("areaCustomerName", areaName);
            }
            this.setTitleAndTips(conf);
            FormShowParameter parameter = this.getView().getFormShowParameter();
            this.initIndicatorForm(parameter);
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        finally {
            ObjEvaluationUtils.cacheBindingData(this.getView(), false);
        }
    }

    public void setTitleAndTips(DynamicObject conf) {
        Label titleLable = (Label)this.getView().getControl("areatitle");
        String areCustName = conf.getString("areacustname");
        titleLable.setText(areCustName);
        String description = conf.getString("description");
        if (!HRStringUtils.isEmpty((String)description)) {
            description = ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a{0}", (String)"EvalCustomAreaEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{description});
        }
        EvalResultViewUtils.showAreaInfoTips(this.getView(), areCustName, description);
    }

    private void initIndicatorForm(FormShowParameter parameter) {
        Long confId = (Long)parameter.getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryCustomConfigByPk(confId);
        ArrayList<String> confFiledsList = new ArrayList<String>(10);
        if (conf != null) {
            String areaName = conf.getString("areacustname");
            this.getView().getPageCache().put("areaCustomerName", areaName);
            DynamicObjectCollection confFieldCols = conf.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < confFieldCols.size(); ++i) {
                DynamicObject fieldObj = (DynamicObject)confFieldCols.get(i);
                OrmLocaleValue fieldCustomLocaleName = (OrmLocaleValue)fieldObj.get("fieldcustname");
                String fieldtype = fieldObj.getString("fieldtype");
                String fieldNum = fieldObj.getString("areafield.number");
                String fieldName = fieldObj.getString("areafield.name");
                FieldEdit fieldAp = (FieldEdit)this.getView().getControl(fieldNum);
                if (fieldCustomLocaleName != null) {
                    fieldAp.setCaption(new LocaleString(fieldCustomLocaleName.getLocaleValue()));
                } else {
                    fieldAp.setCaption(new LocaleString(fieldName));
                }
                confFiledsList.add(fieldNum);
            }
            List<String> notConfFiledsList = Arrays.asList(CUSTOM_AREA_ALL_FIELDS).stream().filter(element -> !confFiledsList.contains(element)).collect(Collectors.toList());
            if (!notConfFiledsList.isEmpty()) {
                String[] hideFields = notConfFiledsList.toArray(new String[notConfFiledsList.size()]);
                this.getView().setVisible(Boolean.FALSE, hideFields);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"conentpanel"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "conentpanel": {
                IFormView view = this.getView();
                IndicatorDetailUtils.showEmptyap(view, "customAreaTitleCacheKey");
                break;
            }
        }
    }
}

