/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evalrecord.area;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.mvc.form.ClientViewProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.evalrecord.area.EvalResultAreaBaseEdit;
import kd.opmc.epa.formplugin.web.assessrule.areaedit.DrawAreaUtils;
import kd.opmc.epa.formplugin.web.utils.EvalResultViewUtils;

public class EvalResultAddSubAreaEdit
extends EvalResultAreaBaseEdit {
    private static final String[] NUMBER_FIELDS = new String[]{AssessScoreAbbrEnum.SOI.getCode(), "subscoremin", "addscoremax"};
    private static final Set<String> CONFIG_FIELDS = Arrays.stream(new String[]{"indctrname"}).collect(Collectors.toSet());

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryPlusMinusConfigByPk(confId);
        Label areaNameLab = (Label)this.getControl("lblareaname");
        areaNameLab.setText(conf.getString("areacustname"));
        this.getView().updateControlMetadata(AssessScoreAbbrEnum.SOZ.getCode(), DrawAreaUtils.getPcScItemMap(formShowParameter));
        Integer numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        String scaleType = (String)formShowParameter.getCustomParam("scaletype");
        this.setAreaTips(conf);
        Label sozLab = (Label)this.getControl("sozlab");
        sozLab.setText(this.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.SOZ.getCode()).setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString());
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        for (String numberField : NUMBER_FIELDS) {
            clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{numberField, "sc", numAccuracy});
        }
        this.getView().setVisible(Boolean.FALSE, CONFIG_FIELDS.toArray(new String[0]));
        DynamicObjectCollection fieldEntity = conf.getDynamicObjectCollection("entryentity");
        for (DynamicObject fieldInfo : fieldEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            if (!CONFIG_FIELDS.contains(fieldKey)) continue;
            this.getView().setVisible(Boolean.TRUE, new String[]{fieldKey});
            clientViewProxy.invokeControlMethod("entryentity", "setColProp", new Object[]{fieldKey, "header", fieldInfo.get("fieldcustname")});
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.getModel().setValue("iestext", (Object)((DynamicObject)entryEntity.get(i)).getBigDecimal("ies").setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString(), i);
        }
    }

    @Override
    protected String getEvalDialogViewNumber() {
        Object isFromConfirm = this.getView().getFormShowParameter().getCustomParam("isFromConfirm");
        if (Boolean.TRUE.equals(isFromConfirm)) {
            return "epa_confirm_addsubareatpl";
        }
        return "epa_addsubarearecord_dv";
    }

    private void setAreaTips(DynamicObject conf) {
        String areaName = conf.getString("areacustname");
        String description = conf.getString("description");
        BigDecimal plusLimit = conf.getBigDecimal("pluslimit");
        BigDecimal minusLimit = conf.getBigDecimal("minuslimit");
        String content = "";
        content = !HRStringUtils.isEmpty((String)description) ? ResManager.loadKDString((String)"\u533a\u57df\u8bc4\u5206\u4e0a\u4e0b\u9650\uff1a\u3010{0}-{1}\u3011{2}\u63cf\u8ff0\uff1a{3}", (String)"EvalResultAddSubAreaEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{minusLimit, plusLimit, "\r\n", description}) : ResManager.loadKDString((String)"\u533a\u57df\u8bc4\u5206\u4e0a\u4e0b\u9650\uff1a\u3010{0}-{1}\u3011", (String)"EvalResultAddSubAreaEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{minusLimit, plusLimit});
        EvalResultViewUtils.showAreaInfoTips(this.getView(), areaName, content);
    }

    private void setSoiFieldTips() {
        DynamicObjectCollection indEntity = this.getModel().getEntryEntity("entryentity");
        StringBuilder content = new StringBuilder();
        for (DynamicObject indicatorDy : indEntity) {
            content.append(indicatorDy.getString("indctrname")).append("\uff1a[").append(indicatorDy.getBigDecimal("subscoremin").stripTrailingZeros().toPlainString()).append('-').append(indicatorDy.getBigDecimal("addscoremax").stripTrailingZeros().toPlainString()).append(']').append("\r\n");
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        Tips tips = new Tips();
        tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u5206\u6570\u9650\u5236", (String)"EvalResultAddSubAreaEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        tips.setTriggerType("hover");
        tips.setType("text");
        tips.setContent(new LocaleString(content.toString()));
        tips.setIconClassName("kdfont kdfont-gengduo2");
        tips.setPlace("right");
        entryGrid.setColumnProperty("soi", "tips", (Object)tips);
    }
}

