/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evalrecord.area;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.mvc.form.ClientViewProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.evalrecord.area.EvalResultAreaBaseEdit;
import kd.opmc.epa.formplugin.web.utils.EvalResultViewUtils;

public class EvalResultGenAreaEdit
extends EvalResultAreaBaseEdit {
    private static final String[] NUMBER_FIELDS = new String[]{AssessScoreAbbrEnum.SOI.getCode(), "weight", "indctrscore"};
    private static final Set<String> CONFIG_FIELDS = Arrays.stream(new String[]{"indctrname", "weight", "indctrscore", "qualityres"}).collect(Collectors.toSet());

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long confId = (Long)formShowParameter.getCustomParam("confid");
        DynamicObject conf = this.ACTIVITY_SERVICE.queryNormalConfigByPk(confId);
        Label areaNameLab = (Label)this.getControl("lblareaname");
        String areaName = conf.getString("areacustname");
        String scoreCalcWay = (String)formShowParameter.getCustomParam("scorecalcway");
        Integer numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        String scaleType = (String)formShowParameter.getCustomParam("scaletype");
        String scoreOrWeight = "";
        if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
            scoreOrWeight = this.getModel().getDataEntity().getBigDecimal("areascore").setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString();
            this.getView().setVisible(Boolean.FALSE, new String[]{"weight"});
        } else if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            scoreOrWeight = this.getModel().getDataEntity().getBigDecimal("areaweight").setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString() + "%";
            this.getView().setVisible(Boolean.FALSE, new String[]{"indctrscore"});
        }
        areaNameLab.setText(areaName + "\uff08" + scoreOrWeight + "\uff09");
        Label sozLab = (Label)this.getControl("sozlab");
        sozLab.setText(this.getModel().getDataEntity().getBigDecimal(AssessScoreAbbrEnum.SOZ.getCode()).setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString());
        this.setAreaTips(conf);
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        for (String numberField : NUMBER_FIELDS) {
            clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{numberField, "sc", numAccuracy});
        }
        this.getView().setVisible(Boolean.FALSE, CONFIG_FIELDS.toArray(new String[0]));
        DynamicObjectCollection fieldEntity = conf.getDynamicObjectCollection("entryentity");
        for (DynamicObject fieldInfo : fieldEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            if (!CONFIG_FIELDS.contains(fieldKey)) continue;
            this.getView().setVisible(Boolean.TRUE, new String[]{fieldKey});
            clientViewProxy.invokeControlMethod("entryentity", "setColProp", new Object[]{fieldKey, "header", fieldInfo.get("fieldcustname")});
        }
        if (conf.getBoolean("isalloweval")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getModel().setValue("iestext", (Object)((DynamicObject)entryEntity.get(i)).getBigDecimal("ies").setScale((int)numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString(), i);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"iestext"});
        }
    }

    private void setSoiFieldTips() {
        DynamicObjectCollection indEntity = this.getModel().getEntryEntity("entryentity");
        StringBuilder content = new StringBuilder();
        for (DynamicObject indicatorDy : indEntity) {
            content.append(indicatorDy.getString("indctrname")).append("\uff1a[0-").append(indicatorDy.getBigDecimal("indctrscore").stripTrailingZeros().toPlainString()).append(']').append("\r\n");
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        Tips tips = new Tips();
        tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u5206\u6570\u9650\u5236", (String)"EvalResultGenAreaEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        tips.setTriggerType("hover");
        tips.setType("text");
        tips.setContent(new LocaleString(content.toString()));
        tips.setIconClassName("kdfont kdfont-gengduo2");
        tips.setPlace("right");
        entryGrid.setColumnProperty("soi", "tips", (Object)tips);
    }

    @Override
    protected String getEvalDialogViewNumber() {
        Object isFromConfirm = this.getView().getFormShowParameter().getCustomParam("isFromConfirm");
        if (Boolean.TRUE.equals(isFromConfirm)) {
            return "epa_confirm_genareatpl";
        }
        return "epa_genarearecord_dv";
    }

    @Override
    protected String formatEvalDialogCaption(DynamicObject indicatorDy) {
        String scoreCalcWay = (String)this.getView().getFormShowParameter().getCustomParam("scorecalcway");
        int numAccuracy = Integer.parseInt((String)this.getView().getFormShowParameter().getCustomParam("numaccuracy"));
        String scaleType = (String)this.getView().getFormShowParameter().getCustomParam("scaletype");
        String scoreOrWeight = "";
        if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
            scoreOrWeight = indicatorDy.getBigDecimal("indctrscore").setScale(numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString();
        } else if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            scoreOrWeight = indicatorDy.getBigDecimal("weight").setScale(numAccuracy, ScalaTypeEnum.get((String)scaleType).getType()).toPlainString() + "%";
        }
        return ResManager.loadKDString((String)"\u8bc4\u4f30\u8be6\u60c5-{0}\uff08{1}\uff09", (String)"EvalResultGenAreaEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{indicatorDy.getString("indctrname"), scoreOrWeight});
    }

    private void setAreaTips(DynamicObject conf) {
        boolean isShowAreaScoreSystem;
        String areaName = conf.getString("areacustname");
        String description = conf.getString("description");
        if (!HRStringUtils.isEmpty((String)description)) {
            description = ResManager.loadKDString((String)"\u63cf\u8ff0\uff1a{0}{1}", (String)"EvalResultGenAreaEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{description, "\r\n"});
        }
        String scoreCalcWayOfTable = (String)this.getView().getFormShowParameter().getCustomParam("scorecalcway");
        Boolean consistentWithArea = (Boolean)this.getView().getFormShowParameter().getCustomParam("consistentwitharea");
        boolean bl = isShowAreaScoreSystem = ScoreCalcWayEnum.getScoreCalcWay((String)scoreCalcWayOfTable) == ScoreCalcWayEnum.WEIGHT && consistentWithArea == false;
        if (isShowAreaScoreSystem) {
            description = ResManager.loadKDString((String)"\u533a\u57df\u5206\u5236\uff1a{0}{1}{2}", (String)"EvalResultGenAreaEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{conf.getString("scoresystem.name"), "\r\n", description});
        }
        StringBuilder content = new StringBuilder(description);
        String allowText = conf.getBoolean("isalloweval") ? ResManager.loadKDString((String)"\u662f", (String)"EvalResultGenAreaEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"EvalResultGenAreaEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        String partInText = conf.getBoolean("ispartin") ? ResManager.loadKDString((String)"\u662f", (String)"EvalResultGenAreaEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"EvalResultGenAreaEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        String partInTextBuilder = ResManager.loadKDString((String)"\u53c2\u4e0e\u603b\u5206\u8ba1\u7b97\uff1a{0}{1}", (String)"EvalResultGenAreaEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{partInText, "\r\n"});
        String allowTextBuilder = ResManager.loadKDString((String)"\u652f\u6301\u8bc4\u5206/\u8bc4\u7ea7\uff1a{0}{1}", (String)"EvalResultGenAreaEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{allowText, "\r\n"});
        EvalResultViewUtils.showAreaInfoTips(this.getView(), areaName, content.append(allowTextBuilder).append(partInTextBuilder).toString());
    }
}

