/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evaluatinglist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entity.AddEvalCrossVo;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.workflow.dto.AssignHandlerParamDTO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.vo.AssignHandlerVO;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public class AddEvalCrossDialogPlugin
extends HRDataBaseEdit
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void registerListener(EventObject e) {
        BasedataEdit evalF7 = (BasedataEdit)this.getView().getControl("evaluaties");
        BasedataEdit depempF7 = (BasedataEdit)this.getView().getControl("depempf7");
        depempF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        depempF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        evalF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.addEntryList();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("columnResizeMode", "preset");
        this.getView().updateControlMetadata("entryentity", map);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean actPerm;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("confirm".equals(operateKey) && !(actPerm = EvalObjUtils.checkActivityPermission((IFormView)this.getView()))) {
            args.setCancel(true);
            return;
        }
        if ("addbatch".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = entryGrid.getSelectRows();
            if (ObjectUtils.isEmpty((Object)rows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AddEvalCrossDialogPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                this.getModel().setValue("depempf7", null);
                BasedataEdit control = (BasedataEdit)this.getView().getControl("depempf7");
                control.click();
            }
        }
        if ("confirm".equals(operateKey) && !(actPerm = EvalObjUtils.checkActivityPermission((IFormView)this.getView()))) {
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("confirm".equals(operateKey) && args.getOperationResult().isSuccess()) {
            String returnData = this.checkAndAddHanders();
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    private String checkAndAddHanders() {
        DynamicObjectCollection cols = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        ArrayList<AssignHandlerParamDTO> addList = new ArrayList<AssignHandlerParamDTO>(10);
        StringBuilder message = new StringBuilder();
        int fail = 0;
        for (Object dy : cols) {
            boolean checkStatus;
            DynamicObject objDy = dy.getDynamicObject("actobj");
            DynamicObject ruRole = dy.getDynamicObject("flowrurole");
            DynamicObject indicatorDy = dy.getDynamicObject("indicator");
            String roleStatus = ruRole.getString("rolestatus");
            boolean bl = checkStatus = FlowRuRoleStatusEnum.PENDING.getCode().equals(roleStatus) || FlowRuRoleStatusEnum.RUNNING.getCode().equals(roleStatus) || FlowRuRoleStatusEnum.NOT_ACTIVE.getCode().equals(roleStatus);
            if (!NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(objDy.getLong("assessnode.id")) || !AssessNodeStatusEnum.EVALUATING.getStatus().equals(objDy.getString("nodestatus"))) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message.append("\n");
                }
                message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u5df2\u4e0d\u5728\u8bc4\u4f30\u4e2d\uff0c\u4e0d\u53ef\u6dfb\u52a0\u8bc4\u4f30\u4eba", (String)"AddEvalCrossDialogPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                continue;
            }
            if (!checkStatus) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message.append("\n");
                }
                String roleStatusStr = EntityMetaDataUtils.getEntityComboFieldItemName((String)"pbs_flowrurole", (String)"rolestatus", (String)roleStatus);
                message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u6307\u6807-\u201c{2}\u201d\u6240\u5728\u5f53\u524d\u8282\u70b9\u4e0b\u7684\u89d2\u8272-{3}\u5904\u4e8e{4}\uff0c\u4e0d\u53ef\u6dfb\u52a0\u8bc4\u4f30\u4eba", (String)"AddEvalCrossDialogPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), indicatorDy.getString("indctrname"), ruRole.getString("flowdefrole.name"), roleStatusStr}));
                continue;
            }
            AssignHandlerParamDTO dto = new AssignHandlerParamDTO();
            List handerIds = dy.getDynamicObjectCollection("evaluaties").stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            dto.setActevaObj(Long.valueOf(objDy.getLong("id")));
            dto.setRoleId(Long.valueOf(ruRole.getLong("id")));
            dto.setHandlerIds(handerIds);
            dto.setHandType((short)0);
            dto.setIndicatorId(Long.valueOf(indicatorDy.getLong("indicator")));
            dto.setWorkFlowType("2");
            addList.add(dto);
        }
        fail = cols.size() - addList.size();
        List resultList = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.addEvalPersonCross(addList);
        for (AssignHandlerVO vo : resultList) {
            if (vo.isSucess()) continue;
            String str = StringUtils.isNotBlank((CharSequence)message) ? "\n" + vo.getErrorMessage() : vo.getErrorMessage();
            message.append(str);
            ++fail;
        }
        if (fail > 0) {
            String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff1a\u6dfb\u52a0\u8bc4\u4f30\u4eba\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"AddEvalCrossDialogPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{cols.size(), cols.size() - fail, fail});
            this.getView().showMessage(title, message.toString(), MessageTypes.Default);
        }
        return cols.size() - fail > 0 ? "true" : null;
    }

    private void addEntryList() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.dealWithSetter(setter);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void dealWithSetter(TableValueSetter setter) {
        setter.addField("flowrurole", new Object[0]);
        setter.addField("actobj", new Object[0]);
        setter.addField("indicator", new Object[0]);
        IListView parentView = (IListView)this.getView().getParentView();
        Object[] primaryIds = parentView.getSelectedRows().getPrimaryKeyValues();
        Collection indicatorTaskDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getIndicatorTask(primaryIds);
        Set indicatorId = indicatorTaskDys.stream().map(indicatorTask -> indicatorTask.getLong("indicator")).collect(Collectors.toSet());
        Map indicatorInfoMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryActObjByIndicatorId(indicatorId);
        ArrayList<AddEvalCrossVo> addEvalCrossVos = new ArrayList<AddEvalCrossVo>(indicatorTaskDys.size());
        for (DynamicObject indicatorTaskDy : indicatorTaskDys) {
            DynamicObject indicatorInfo = (DynamicObject)indicatorInfoMap.get(indicatorTaskDy.getLong("indicator"));
            AddEvalCrossVo addEvalCrossVo = new AddEvalCrossVo(Long.valueOf(indicatorTaskDy.getLong("rutask.flowrurole.id")), Long.valueOf(indicatorInfo.getLong("actevalobj.id")), Long.valueOf(indicatorInfo.getLong("id")));
            addEvalCrossVos.add(addEvalCrossVo);
        }
        addEvalCrossVos.sort(Comparator.comparing(AddEvalCrossVo::getActEvalObj));
        for (AddEvalCrossVo vo : addEvalCrossVos) {
            setter.addRow(new Object[]{vo.getFlowRuRole(), vo.getActEvalObj(), vo.getCrossIndicator()});
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((Control)evt.getSource()).getKey();
        if ("depempf7".equals(fieldKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = entryGrid.getSelectRows();
            DynamicObjectCollection depemps = (DynamicObjectCollection)this.getModel().getValue("depempf7");
            if (depemps.size() > 100) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u4eba\u6700\u591a\u53ea\u80fd\u8bbe\u7f6e100\u4e2a\uff08\u542b\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AddEvalCrossDialogPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("evaluaties", null, rows[0]);
            } else {
                List depempIds = depemps.stream().map(dy -> dy.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                List userIds = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getUserIdsByDepempIds(depempIds);
                List flowCommonResultBos = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.verifyUserIsValid(userIds);
                for (FlowCommonResultBo flowCommonResultBo : flowCommonResultBos) {
                    if (!"-1".equals(flowCommonResultBo.getCode())) continue;
                    this.getView().showErrorNotification(flowCommonResultBo.getMessage());
                    this.getModel().setValue("evaluaties", null);
                    return;
                }
                if (CollectionUtils.isNotEmpty((Collection)userIds) && userIds.size() == flowCommonResultBos.size()) {
                    DynamicObjectCollection cols = (DynamicObjectCollection)this.getModel().getValue("evaluaties", rows[0]);
                    DynamicObjectCollection handerCols = new DynamicObjectCollection();
                    userIds.forEach(eval -> {
                        DynamicObject hander = new DynamicObject(cols.getDynamicObjectType());
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)eval, (String)"bos_user");
                        hander.set("fbasedataid", (Object)dynamicObject);
                        hander.set("fbasedataid_id", eval);
                        handerCols.add((Object)hander);
                    });
                    for (int index : rows) {
                        this.getModel().setValue("evaluaties", (Object)handerCols, index);
                    }
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5904\u7406\u4eba\u5728\u5e73\u53f0\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AddEvalCrossDialogPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if ("evaluaties".equals(fieldKey)) {
            evt.setCancel(true);
            this.getModel().setValue("depempf7", null);
            BasedataEdit control = (BasedataEdit)this.getView().getControl("depempf7");
            control.click();
        } else if ("depempf7".equals(fieldKey)) {
            FormShowParameter formShowParameter = evt.getFormShowParameter();
            formShowParameter.setCustomParam("showeffect", (Object)"0");
        }
    }
}

