/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evaluatinglist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;

public class EvalFlowMonitorPlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessActivityApplicationService ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final String FLOW_NODE_MAP = "flowNodeMap";
    private static final String EVAL_PERSON_LAB = "evalpersonlab";
    private static final String EVAL_OBJ_LAB = "evalobjlab";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry nodeEntry = (CardEntry)this.getView().getControl("entryentity");
        nodeEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{EVAL_PERSON_LAB, EVAL_OBJ_LAB});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Map flowMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvaluatingFlowsMap(activityId);
        DynamicObject[] flows = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowByPkValue(flowMap.keySet());
        DynamicObject perfWorkFlow = ACTIVITY_APPLICATION_SERVICE.queryPerfWorkFlow(activityId);
        DynamicObjectCollection flowEntry = perfWorkFlow.getDynamicObjectCollection("flowentry");
        Map<Long, Boolean> temMap = flowEntry.stream().collect(Collectors.toMap(itemL -> itemL.getLong("flowvid"), itemB -> itemB.getBoolean("isdefaultflow")));
        Arrays.stream(flows).forEach(item -> {
            if (temMap.containsKey(item.getLong("id"))) {
                item.set("isdefault", temMap.get(item.getLong("id")));
            }
        });
        this.initFlowNodeMap(flows);
        this.buildComboItem(flowMap, flows);
        this.addNodeCard();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.selectLastNode();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)key, (String)EVAL_PERSON_LAB)) {
            this.getView().updateControlMetadata(EVAL_PERSON_LAB, this.getStyleMap(EVAL_PERSON_LAB, true));
            this.getView().updateControlMetadata(EVAL_OBJ_LAB, this.getStyleMap(EVAL_OBJ_LAB, false));
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("evalpersontab");
        } else if (HRStringUtils.equals((String)key, (String)EVAL_OBJ_LAB)) {
            this.getView().updateControlMetadata(EVAL_OBJ_LAB, this.getStyleMap(EVAL_OBJ_LAB, true));
            this.getView().updateControlMetadata(EVAL_PERSON_LAB, this.getStyleMap(EVAL_PERSON_LAB, false));
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("evalobjtab");
        }
    }

    private Map<String, Object> getStyleMap(String lab, boolean isSelect) {
        HashMap<String, Object> personStyleMap = new HashMap<String, Object>();
        personStyleMap.put("fc", isSelect ? "themeColor" : "");
        HashMap personStyle = new HashMap();
        HashMap<String, String> personBorder = new HashMap<String, String>();
        personBorder.put("r", isSelect ? "1px_solid_themeColor" : (lab.equals(EVAL_PERSON_LAB) ? "" : "1px_solid_#D9D9D9"));
        personBorder.put("l", isSelect ? "1px_solid_themeColor" : (lab.equals(EVAL_PERSON_LAB) ? "1px_solid_#D9D9D9" : ""));
        personBorder.put("t", isSelect ? "1px_solid_themeColor" : "1px_solid_#D9D9D9");
        personBorder.put("b", isSelect ? "1px_solid_themeColor" : "1px_solid_#D9D9D9");
        personStyle.put("b", personBorder);
        personStyleMap.put("s", personStyle);
        return personStyleMap;
    }

    private void selectLastNode() {
        DynamicObjectCollection nodeEntry = this.getModel().getEntryEntity("entryentity");
        if (nodeEntry.size() > 0) {
            int lastNodeRow = 0;
            for (int i = 0; i < nodeEntry.size(); ++i) {
                int objNum = ((DynamicObject)nodeEntry.get(i)).getInt("objnum");
                lastNodeRow = objNum > 0 ? i : lastNodeRow;
            }
            CardEntry card = (CardEntry)this.getControl("entryentity");
            card.selectCard(Integer.valueOf(lastNodeRow));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"flowcombo")) {
            String flowId = (String)this.getModel().getValue("flowcombo");
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (null == parentViewPageCache) {
                return;
            }
            parentViewPageCache.put("currentSelectFlow", flowId);
            parentViewPageCache.remove("lastSelectRow");
            this.addNodeCard();
            this.selectLastNode();
        }
    }

    private void initFlowNodeMap(DynamicObject[] flows) {
        Map<Long, List> flowNodeMap = Arrays.stream(flows).collect(Collectors.toMap(flow -> flow.getLong("id"), flow -> {
            Long flowProcId = ((DynamicObject)flow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            DynamicObject flowProc = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowProcPkValue(flowProcId);
            return flowProc.getDynamicObjectCollection("nodeentry").stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }));
        this.getView().getPageCache().put(FLOW_NODE_MAP, SerializationUtils.toJsonString(flowNodeMap));
    }

    private void buildComboItem(Map<Object, Long> flowMap, DynamicObject[] flows) {
        DynamicObject defaultFlow = Arrays.stream(flows).filter(dy -> dy.getBoolean("isdefault")).findFirst().orElse(null);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        if (defaultFlow != null) {
            String name = defaultFlow.getString("name");
            Long count = flowMap.get(defaultFlow.getPkValue());
            String value = name + "\uff08" + count + "\uff09";
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(defaultFlow.getPkValue()));
            item.setCaption(new LocaleString(value));
            item.setValue(String.valueOf(defaultFlow.getPkValue()));
            combos.add(item);
        }
        Arrays.stream(flows).filter(dy -> !dy.getBoolean("isdefault")).forEach(dy -> {
            String name = dy.getString("name");
            Long count = (Long)flowMap.get(dy.getPkValue());
            String value = name + "\uff08" + count + "\uff09";
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(dy.getPkValue()));
            item.setCaption(new LocaleString(value));
            item.setValue(String.valueOf(dy.getPkValue()));
            combos.add(item);
        });
        ComboEdit comboEdit = (ComboEdit)this.getControl("flowcombo");
        comboEdit.setComboItems(combos);
        if (!ObjectUtils.isEmpty(combos)) {
            this.getModel().setValue("flowcombo", (Object)((ComboItem)combos.get(0)).getId());
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"EvalFlowMonitorPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"refresh")) {
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (parentViewPageCache == null) {
                return;
            }
            String selectFlow = parentViewPageCache.get("currentSelectFlow");
            String selectRow = parentViewPageCache.get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)selectFlow)) {
                this.getModel().setValue("flowcombo", (Object)selectFlow);
            }
            if (ObjectUtils.isEmpty((Object)selectRow)) {
                return;
            }
            CardEntry card = (CardEntry)this.getControl("entryentity");
            card.selectCard(Integer.valueOf(Integer.parseInt(selectRow)));
            parentViewPageCache.remove("lastSelectRow");
        }
    }

    private IPageCache getParentViewPageCache() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"EvalFlowMonitorPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return null;
        }
        return parentView.getPageCache();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof CardEntry && HRStringUtils.equals((String)"entryentity", (String)((CardEntry)source).getKey())) {
            int lastSelectRow;
            int row = evt.getRow();
            DynamicObjectCollection nodeEntry = this.getModel().getEntryEntity("entryentity");
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (parentViewPageCache == null || ObjectUtils.isEmpty((Object)nodeEntry)) {
                return;
            }
            String lastSelectRowStr = parentViewPageCache.get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)lastSelectRowStr) && (lastSelectRow = Integer.parseInt(lastSelectRowStr)) == row) {
                return;
            }
            for (int i = 0; i < nodeEntry.size(); ++i) {
                this.getView().getModel().setValue("isselected", (Object)(row == i ? 1 : 0), i);
            }
            this.getView().getModel().setValue("isselected", (Object)Boolean.TRUE, row);
            parentViewPageCache.put("lastSelectRow", String.valueOf(row));
            this.showRightList(((DynamicObject)nodeEntry.get(row)).getDynamicObject("flownode"));
        }
    }

    private void showRightList(DynamicObject nodeDy) {
        boolean isCrossScore = nodeDy.getBoolean("crossscore");
        this.showPersonList(nodeDy, isCrossScore ? "epa_rutaskindlist" : "epa_evalpersonlist", "evalpersonap");
        this.showPersonList(nodeDy, isCrossScore ? "epa_crossevalobjlist" : "epa_evaluatingobjlist", "evalobjap");
    }

    private void showPersonList(DynamicObject nodeDy, String formId, String container) {
        Long evalFlowId = Long.parseLong((String)this.getModel().getValue("flowcombo"));
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId(formId);
        parameter.setCaption(nodeDy.getString("nodename"));
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(container);
        parameter.setCustomParam("nodeId", nodeDy.getPkValue());
        parameter.setCustomParam("nodeseq", (Object)nodeDy.getInt("entryseq"));
        parameter.setCustomParam("activity", (Object)activityId);
        parameter.setCustomParam("objectscope", this.getView().getFormShowParameter().getCustomParam("objectscope"));
        parameter.setCustomParam("evalflow", (Object)evalFlowId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void pageRelease(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            parentView.getPageCache().remove("lastSelectRow");
            parentView.getPageCache().remove("currentSelectFlow");
        }
    }

    private void addNodeCard() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.dealWithSetter(setter);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void dealWithSetter(TableValueSetter setter) {
        int seq = 1;
        setter.addField("nodeseq", new Object[0]);
        setter.addField("flownode", new Object[0]);
        setter.addField("isselected", new Object[0]);
        setter.addField("nodeposition", new Object[0]);
        setter.addField("objnum", new Object[0]);
        String flowId = (String)this.getModel().getValue("flowcombo");
        String flowNodeMapStr = this.getView().getPageCache().get(FLOW_NODE_MAP);
        Map flowNodeMap = (Map)SerializationUtils.fromJsonString((String)flowNodeMapStr, Map.class);
        List nodeIds = (List)flowNodeMap.get(flowId);
        if (nodeIds == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"EvalFlowMonitorPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return;
        }
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Map ObjGroupByNodeMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvaObjByFlow(Long.valueOf(Long.parseLong(flowId)), activityId);
        for (Long nodeId : nodeIds) {
            String position = null;
            if (seq == 1) {
                position = "top";
            } else if (nodeIds.indexOf(nodeId) == nodeIds.size() - 1) {
                position = "bottom";
            }
            int objNum = ObjGroupByNodeMap.get(nodeId) == null ? 0 : ((List)ObjGroupByNodeMap.get(nodeId)).size();
            setter.addRow(new Object[]{seq, nodeId, seq == 1, position, objNum});
            ++seq;
        }
    }
}

