/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evaluatinglist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;

public abstract class EvalObjBaseList
extends HRDataBaseList {
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();

    public void setFilter(SetFilterEvent event) {
        Long nodeId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeId");
        QFilter nodeFilter = new QFilter("evalflowins.currentnode.flownodedef", "=", (Object)nodeId);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        QFilter activityFilter = new QFilter("activity", "=", (Object)activityId);
        Long evalFlowId = (Long)this.getView().getFormShowParameter().getCustomParam("evalflow");
        QFilter evalFlowFilter = new QFilter("evalflow", "=", (Object)evalFlowId);
        QFilter evalNodeFilter = new QFilter("assessnode", "=", (Object)AssessNodeStatusEnum.EVALUATING.getNodeId());
        QFilter evalStatusFilter = new QFilter("nodestatus", "=", (Object)AssessNodeStatusEnum.EVALUATING.getStatus());
        event.getQFilters().add(nodeFilter);
        event.getQFilters().add(activityFilter);
        event.getQFilters().add(evalFlowFilter);
        event.getQFilters().add(evalNodeFilter);
        event.getQFilters().add(evalStatusFilter);
        super.setFilter(event);
        event.setOrderBy("modifytime desc,affiliateadminorg desc,assgroup asc");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BosListUtil.setGripMargin(this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("refresh".equals(args.getOperateKey())) {
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (HRStringUtils.equals((String)"assgroup.name", (String)fieldName) || "assgroup.id".equals(fieldName)) {
            List qFilters = args.getQfilters();
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
            List ids = assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup").getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", ids));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List<ComboItem> groupCombos = this.buildAssGroupComboItems();
        List schemeFilterCols = args.getSchemeFilterColumns().stream().map(filterFilterCol -> (SchemeFilterColumn)filterFilterCol).collect(Collectors.toList());
        for (SchemeFilterColumn schemeFilterColumn : schemeFilterCols) {
            String fieldName = schemeFilterColumn.getFieldName();
            if (!HRStringUtils.equals((String)fieldName, (String)"assgroup.name")) continue;
            schemeFilterColumn.setComboItems(groupCombos);
        }
        List commonFilterCols = args.getCommonFilterColumns().stream().map(commonFilterCol -> (CommonFilterColumn)commonFilterCol).collect(Collectors.toList());
        for (CommonFilterColumn commonFilterColumn : commonFilterCols) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!HRStringUtils.equals((String)fieldName, (String)"assgroup.name")) continue;
            commonFilterColumn.setComboItems(groupCombos);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (this.getView().getParentView().getParentView() == null) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"EvalObjBaseList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private List<ComboItem> buildAssGroupComboItems() {
        DynamicObject[] groups;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
        for (DynamicObject group : groups = (DynamicObject[])assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup")).toArray(DynamicObject[]::new)) {
            if (group == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(group.getPkValue()));
            item.setCaption(new LocaleString(group.getString("name")));
            item.setValue(String.valueOf(group.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "person.headsculpture", "perffile.name", "perffile.number", "person.name", "person.number", "perffile.billno");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }
}

