/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evaluatinglist;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuTaskIndEntryService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowCooperatorEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.common.utils.CommonResultBo;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class EvalPersonCrossList
extends QueryListPlugin {
    private static final Log LOG = LogFactory.getLog(EvalPersonCrossList.class);
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final FlowRuTaskIndEntryService FLOW_RU_TASK_IND_ENTRY_SERVICE = FlowRuTaskIndEntryService.getInstance();
    private static final String ADD_EVAL_CROSS = "addevalcross";
    private static final String MODIFY_EVAL_CROSS = "modifyevalcross";
    private static final String DELETE_EVAL_CROSS = "delevalcross";
    private static final String CROSS_EVAL_PUSH = "crossevalpush";
    private static final String RETURN_EVAL = "returneval";
    private Map<Long, String> COOPERATOR_MAP = new HashMap<Long, String>(16);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeseq");
        QFilter nodeIndexFilter = new QFilter("epa_evalflowrutask.flowrunode.index", "=", (Object)nodeIndex);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        QFilter activityFilter = new QFilter("epa_actevalobjind.actevalobj.activity", "=", (Object)activityId);
        DynamicObject[] objects = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvaluatedObj(activityId);
        Long evalFlowId = (Long)this.getView().getFormShowParameter().getCustomParam("evalflow");
        QFilter evalFlowFilter = new QFilter("epa_actevalobjind.actevalobj.evalflow", "=", (Object)evalFlowId);
        Map<Object, Long> objMap = Arrays.stream(objects).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy.getLong("evalflowins.id"), (k1, k2) -> k1));
        QFilter objFilter = new QFilter("epa_actevalobjind.actevalobj", "in", objMap.keySet());
        QFilter evalFlowInsFilter = new QFilter("epa_evalflowrutask.flowruproc", "in", objMap.values());
        event.getQFilters().add(nodeIndexFilter);
        event.getQFilters().add(activityFilter);
        event.getQFilters().add(evalFlowFilter);
        event.getQFilters().add(evalFlowInsFilter);
        event.getQFilters().add(objFilter);
        event.setOrderBy("epa_actevalobjind.actevalobj.modifytime desc,epa_evalflowrutask.taskstatus desc,epa_actevalobjind.actevalobj asc,epa_actevalobjind.indicator asc,epa_evalflowrutask.flowrurole.turnoversort asc");
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        super.beforePackageData(dataEvent);
        DynamicObjectCollection pageData = dataEvent.getPageData();
        if (pageData != null && !pageData.isEmpty()) {
            Object[] taskEntryIds = pageData.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList()).toArray(new Long[0]);
            DynamicObject[] taskEntryDys = FLOW_RU_TASK_IND_ENTRY_SERVICE.loadDynamicObjectArray(taskEntryIds);
            Map<Long, Long> entryIdTaskIdMap = Arrays.stream(taskEntryDys).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getLong("rutask.id")));
            List taskIds = Arrays.stream(taskEntryDys).map(entryDy -> entryDy.getLong("rutask.id")).collect(Collectors.toList());
            Map idCoopMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getTasksCooperator(taskIds);
            HashMap<Long, String> entryIdCoopMap = new HashMap<Long, String>(16);
            entryIdTaskIdMap.forEach((entryId, taskId) -> entryIdCoopMap.put((Long)entryId, (String)idCoopMap.get(taskId)));
            this.COOPERATOR_MAP = entryIdCoopMap;
        }
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        DynamicObject rowData = evt.getRowData();
        AbstractColumnDesc source = (AbstractColumnDesc)evt.getSource();
        String fieldKey = source.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"evalwaittime")) {
            Date date = rowData.getDate("epa_evalflowrutask.updatestatustime");
            int intervalDays = DateUtils.getIntervalDays((Date)date, (Date)new Date());
            evt.setFormatValue((Object)(intervalDays + "d"));
        }
        if (HRStringUtils.equals((String)fieldKey, (String)"cohandler")) {
            evt.setFormatValue((Object)"");
            if (this.COOPERATOR_MAP != null && !this.COOPERATOR_MAP.isEmpty()) {
                Long taskId = rowData.getLong("id");
                evt.setFormatValue((Object)(this.COOPERATOR_MAP.get(taskId) == null ? "" : this.COOPERATOR_MAP.get(taskId)));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BosListUtil.setGripMargin(this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (this.getView().getParentView().getParentView() == null) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"EvalPersonCrossList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return;
        }
        switch (operateKey) {
            case "addevalcross": {
                this.addEvalCross(args);
                break;
            }
            case "modifyevalcross": {
                this.beforeModifyEvaluator(args);
                break;
            }
            case "returneval": {
                this.beforeReturnEval(args);
                break;
            }
            case "delcooperator": {
                this.delCooperatorBeforeOp(args);
                break;
            }
            case "setcooperator": {
                this.cooperatorSetEval(args, "setcooperator");
                break;
            }
        }
    }

    private void delCooperatorBeforeOp(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            int count = primaryKeyValues == null ? 0 : primaryKeyValues.length;
            String msgTxt = ResManager.loadKDString((String)"\u5df2\u9009\u62e9{0}\u6761\u6570\u636e\uff0c\u5220\u9664\u540e\u5176\u534f\u529e\u4eba\u8bc4\u4f30\u4efb\u52a1\u5c06\u5168\u90e8\u5931\u6548\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"EvalPersonCrossList_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{count});
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(msgTxt);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delcooperator", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private void cooperatorSetEval(BeforeDoOperationEventArgs args, String operateKey) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            FormShowParameter baseShowParameter = new FormShowParameter();
            baseShowParameter.setFormId("epa_evalsetcooperator");
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setStatus(OperationStatus.EDIT);
            String addCaptionTxt = ResManager.getLocaleString((String)"\u65b0\u589e\u534f\u529e\u4eba", (String)"EvalPersonCrossList_7", (String)"opmc-epa-formplugin").getLocaleValue();
            String addCaption = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(addCaptionTxt);
            String adjustCaptionTxt = ResManager.getLocaleString((String)"\u8c03\u6574\u534f\u529e\u4eba", (String)"EvalPersonCrossList_8", (String)"opmc-epa-formplugin").getLocaleValue();
            String adjustCaption = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(adjustCaptionTxt);
            baseShowParameter.setCaption(HRStringUtils.equals((String)operateKey, (String)"setcooperator") ? addCaption : adjustCaption);
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            Long[] entryIdLongs = Arrays.stream(primaryKeyValues).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList()).toArray(new Long[0]);
            DynamicObject[] taskDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.loadTaskByEntryId(entryIdLongs);
            String[] noPassStatus = new String[]{FlowRuTaskStatusEnum.NOT_ACTIVE.getCode(), FlowRuTaskStatusEnum.BE_WAITTING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.EXPIRED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()};
            List noPassStatusList = Arrays.stream(noPassStatus).collect(Collectors.toList());
            ArrayList<String> selectedNoPassStatusList = new ArrayList<String>(5);
            for (DynamicObject taskDy : taskDys) {
                String taskStatus = taskDy.getString("taskstatus");
                if (!noPassStatusList.contains(taskStatus) || selectedNoPassStatusList.contains(taskStatus)) continue;
                selectedNoPassStatusList.add(taskStatus);
            }
            if (selectedNoPassStatusList.size() > 0) {
                StringBuilder statusStb = new StringBuilder();
                for (String statusCode : selectedNoPassStatusList) {
                    String statusText = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)statusCode).getText();
                    statusStb.append(statusText).append("\u3001");
                }
                String statusStr = "";
                if (statusStb.length() > 0) {
                    statusStr = statusStb.substring(0, statusStb.length() - 1);
                }
                String errMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5b58\u5728\u5904\u4e8e\u201c{0}\u201d\u72b6\u6001\u7684\u8bc4\u4f30\u4efb\u52a1\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EvalPersonCrossList_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{statusStr});
                this.getView().showErrorNotification(errMsg);
                args.setCancel(true);
                return;
            }
            DynamicObject[] taskEntryDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.loadTaskEntryDy(entryIdLongs);
            List<Long> taskIds = Arrays.stream(taskEntryDys).map(dataEntity -> dataEntity.getLong("rutask.id")).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            Long[] idLongs = taskIds.toArray(new Long[0]);
            baseShowParameter.setCustomParam("SELECTED_ROW", (Object)idLongs.length);
            baseShowParameter.setCustomParam("ROW_DATA", (Object)idLongs);
            baseShowParameter.setCustomParam("operateKey", (Object)operateKey);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            this.getView().showForm(baseShowParameter);
            args.setCancel(true);
        }
    }

    private void addEvalCross(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("epa_addevalcross_dv");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADD_EVAL_CROSS));
        parameter.setHasRight(true);
        this.getView().showForm(parameter);
        args.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
        switch (callBackId) {
            case "delcooperator": {
                if (!this.checkActivityPermission()) break;
                OperateOption delCoOp = OperateOption.create();
                delCoOp.setVariableValue("systeminvoke", "true");
                delCoOp.setVariableValue("OP_SOURCE", "formulate");
                this.getView().invokeOperation("delcooperator", delCoOp);
            }
        }
    }

    private boolean checkActivityPermission() {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650", (String)"EvalPersonCrossList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "addevalcross": 
            case "modifyevalcross": 
            case "delevalcross": 
            case "returneval": 
            case "delcooperator": {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                this.getView().invokeOperation("refresh", operateOption);
                break;
            }
            case "refresh": {
                FormOperate source = (FormOperate)args.getSource();
                String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
                if (HRStringUtils.equals((String)systemInvoke, (String)"true")) {
                    return;
                }
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
        }
    }

    private void setCooperator(String returnStr, Long[] entryIds) {
        DynamicObject[] taskEntryDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.loadTaskEntryDy(entryIds);
        List taskIds = Arrays.stream(taskEntryDys).map(dataEntity -> dataEntity.getLong("rutask.id")).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        Map<Long, Long> entryIdIdMap = Arrays.stream(taskEntryDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("rutask.id")));
        DynamicObject[] ruTaskDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryTaskByIds(taskIds);
        Map idTaskDyMap = Arrays.stream(ruTaskDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        Map<Long, Long> taskIdObjIdMap = Arrays.stream(ruTaskDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("flowruproc.actevalobj")));
        HashMap entryIdObjIdMap = new HashMap(16);
        HashMap entryIdTaskDyMap = new HashMap(16);
        entryIdIdMap.forEach((entryId, id) -> {
            entryIdObjIdMap.put(entryId, taskIdObjIdMap.get(id));
            entryIdTaskDyMap.put(entryId, idTaskDyMap.get(id));
        });
        List objIds = Arrays.stream(ruTaskDys).map(dy -> dy.getLong("flowruproc.actevalobj")).collect(Collectors.toList());
        Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(objIds);
        Map handlerInfo = (Map)SerializationUtils.deSerializeFromBase64((String)returnStr);
        if (handlerInfo == null) {
            return;
        }
        List handlers = (List)handlerInfo.get("handlers");
        HashSet<Long> passIds = new HashSet<Long>();
        HashMap<Long, String> taskIdDescMap = new HashMap<Long, String>(16);
        HashMap<Long, String> taskIdFailMsgMap = new HashMap<Long, String>(16);
        int coFailCount = 0;
        for (DynamicObject task : ruTaskDys) {
            String failMsg;
            String failMsgTxt;
            long objId = task.getLong("flowruproc.actevalobj");
            DynamicObject objDy = (DynamicObject)objMap.get(objId);
            String roleStatus = task.getString("flowrurole.rolestatus");
            String handlerNameStr = task.getString("handler.name");
            Long handlerId = task.getLong("handler.id");
            String handlerName = HRStringUtils.isEmpty((String)handlerNameStr) ? "" : handlerNameStr;
            String desc = objDy.getString("person.name") + " " + objDy.getString("person.number");
            taskIdDescMap.put(task.getLong("id"), desc);
            if (!HRStringUtils.equals((String)objDy.getString("nodestatus"), (String)AssessNodeStatusEnum.EVALUATING.getStatus()) || !HRStringUtils.equals((String)objDy.getString("assessnode.id"), (String)ProcessManageApEnum.EVALUATING.getLabId())) {
                failMsgTxt = ResManager.loadKDString((String)"{0} {1}\uff1a\u8bc4\u4f30\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u8bc4\u4f30\u4e2d\u201d\uff0c\u4e0d\u80fd\u65b0\u589e\u534f\u529e\u4eba\u3002", (String)"EvalPersonCrossList_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")});
                failMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(failMsgTxt);
                taskIdFailMsgMap.put(task.getLong("id"), failMsg);
                coFailCount += handlers.size();
                continue;
            }
            if (FlowRuRoleStatusEnum.FINISHED.getCode().equals(roleStatus)) {
                failMsgTxt = ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u5bf9\u5e94\u89d2\u8272\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5b8c\u6210\u201d\u4e0d\u80fd\u65b0\u589e\u534f\u529e\u4eba\u3002", (String)"EvalPersonCrossList_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName});
                failMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(failMsgTxt);
                taskIdFailMsgMap.put(task.getLong("id"), failMsg);
                coFailCount += handlers.size();
                continue;
            }
            if (FlowRuRoleStatusEnum.EXPIRED.getCode().equals(roleStatus)) {
                failMsgTxt = ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u5bf9\u5e94\u89d2\u8272\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5931\u6548\u201d\u4e0d\u80fd\u65b0\u589e\u534f\u529e\u4eba\u3002", (String)"EvalPersonCrossList_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName});
                failMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(failMsgTxt);
                taskIdFailMsgMap.put(task.getLong("id"), failMsg);
                coFailCount += handlers.size();
                continue;
            }
            if (FlowRuRoleStatusEnum.RETURNED.getCode().equals(roleStatus)) {
                failMsgTxt = ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u5bf9\u5e94\u89d2\u8272\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u9000\u56de\u201d\u4e0d\u80fd\u65b0\u589e\u534f\u529e\u4eba\u3002", (String)"EvalPersonCrossList_9", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName});
                failMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(failMsgTxt);
                taskIdFailMsgMap.put(task.getLong("id"), failMsg);
                coFailCount += handlers.size();
                continue;
            }
            passIds.add(task.getLong("id"));
        }
        HashMap<Long, List> cooperatorMap = new HashMap<Long, List>(16);
        for (Long mainTaskId : passIds) {
            cooperatorMap.put(mainTaskId, handlers);
        }
        CommonResultBo commonResultBo = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.setCooperator(cooperatorMap, FlowCooperatorEnum.ADD_COOPERATOR);
        LOG.info("commonResultBo: {}", (Object)commonResultBo);
        if (commonResultBo != null) {
            if (commonResultBo.getCode() == 1) {
                Object idUserMap = new HashMap(16);
                if (handlers != null) {
                    idUserMap = BusinessDataServiceHelper.loadFromCache((Object[])handlers.toArray(), (String)"bos_user");
                }
                Map errorMsgMap = commonResultBo.getErroMsgMap();
                for (Long taskId : passIds) {
                    if (errorMsgMap == null || cooperatorMap.get(taskId) == null || errorMsgMap.get(taskId) == null) continue;
                    Map cooperatorMsg = (Map)errorMsgMap.get(taskId);
                    List cooperator = (List)cooperatorMap.get(taskId);
                    String msgDesc = "";
                    String errMsg = "";
                    StringBuilder errMsgStrB = new StringBuilder();
                    for (Long cooperatorId : cooperator) {
                        if (idUserMap != null && !HRObjectUtils.isEmpty(idUserMap.get(cooperatorId))) {
                            DynamicObject dynamicObject = (DynamicObject)idUserMap.get(cooperatorId);
                            msgDesc = MessageFormat.format("{0} {1}:", dynamicObject.getString("name"), dynamicObject.getString("number"));
                        }
                        if (cooperatorMsg.get(cooperatorId) == null) continue;
                        errMsgStrB.append(msgDesc).append((String)cooperatorMsg.get(cooperatorId));
                        errMsgStrB.append("\u3001");
                    }
                    if (errMsgStrB.length() > 0) {
                        errMsg = errMsgStrB.substring(0, errMsgStrB.length() - 1);
                    }
                    coFailCount += cooperator.size();
                    taskIdFailMsgMap.put(taskId, errMsg);
                }
            } else {
                for (Long taskId : passIds) {
                    taskIdFailMsgMap.put(taskId, commonResultBo.getSumResult());
                }
                coFailCount += passIds.size() * handlers.size();
            }
            StringBuilder failMessageStb = new StringBuilder();
            String failReasonMessage = "";
            for (Long taskId : taskIds) {
                if (taskIdFailMsgMap.get(taskId) == null) continue;
                failMessageStb.append((String)taskIdDescMap.get(taskId)).append(" : ");
                failMessageStb.append((String)taskIdFailMsgMap.get(taskId));
                failMessageStb.append("\r\n");
            }
            if (failMessageStb.length() > 0) {
                failReasonMessage = failMessageStb.substring(0, failMessageStb.length() - 1);
            }
            if (coFailCount == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f", (String)"EvalPersonCrossList_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else if (coFailCount == taskIds.size() * handlers.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5931\u8d25", (String)"EvalPersonCrossList_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6d89\u53ca\u9700\u65b0\u589e{1}\u6761\u534f\u529e\u4eba\u6570\u636e\uff0c\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"EvalPersonCrossList_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{taskIds.size(), taskIds.size() * handlers.size(), taskIds.size() * handlers.size() - coFailCount, coFailCount});
                this.getView().showMessage(title, failReasonMessage, MessageTypes.Default);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object childMap = event.getReturnData();
        if (HRObjectUtils.isEmpty((Object)childMap)) {
            return;
        }
        switch (actionId) {
            case "epa_modifyevaldialog": {
                Object returnData = event.getReturnData();
                if (ObjectUtils.isEmpty((Object)returnData)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("evaluaties", returnData.toString());
                this.getView().invokeOperation(MODIFY_EVAL_CROSS, operateOption);
                break;
            }
            case "addevalcross": {
                String opResult = (String)event.getReturnData();
                if (ObjectUtils.isEmpty((Object)opResult) || !HRStringUtils.equals((String)"true", (String)opResult)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                this.getView().invokeOperation(ADD_EVAL_CROSS, operateOption);
                break;
            }
            case "epa_returntaskdialog": {
                String reason = (String)event.getReturnData();
                if (HRStringUtils.isEmpty((String)reason)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("reason", reason);
                this.getView().invokeOperation(RETURN_EVAL, operateOption);
                break;
            }
            case "setcooperator": {
                String returnStr = SerializationUtils.serializeToBase64((Object)childMap);
                Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                Long[] entryIdLongs = Arrays.stream(primaryKeyValues).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList()).toArray(new Long[0]);
                this.setCooperator(returnStr, entryIdLongs);
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                this.getView().invokeOperation("refresh", operateOption);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (HRStringUtils.equals((String)"epa_actevalobjind.actevalobj.assgroup.name", (String)fieldName) || "epa_actevalobjind.actevalobj.assgroup.id".equals(fieldName)) {
            List qFilters = args.getQfilters();
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
            List ids = assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup").getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", ids));
        } else if (HRStringUtils.equals((String)"epa_evalflowrutask.flowrurole.flowdefrole.rolename", (String)fieldName) || HRStringUtils.equals((String)"epa_evalflowrutask.flowrurole.flowdefrole.id", (String)fieldName)) {
            List qFilters = args.getQfilters();
            Long nodeDefId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeId");
            DynamicObject[] roles = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryRoleByNodeDefId(nodeDefId);
            List ids = Arrays.stream(roles).map(obj -> obj.getLong("flowdefrole.id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", ids));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List<ComboItem> groupCombos = this.buildAssGroupComboItems();
        List<ComboItem> roleCombos = this.buildRoleComboItems();
        List schemeFilterCols = args.getSchemeFilterColumns().stream().map(filterFilterCol -> (SchemeFilterColumn)filterFilterCol).collect(Collectors.toList());
        for (SchemeFilterColumn schemeFilterColumn : schemeFilterCols) {
            String fieldName = schemeFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"epa_actevalobjind.actevalobj.assgroup.name")) {
                schemeFilterColumn.setComboItems(groupCombos);
                continue;
            }
            if (!HRStringUtils.equals((String)fieldName, (String)"epa_evalflowrutask.flowrurole.flowdefrole.rolename")) continue;
            schemeFilterColumn.setComboItems(roleCombos);
        }
        List commonFilterCols = args.getCommonFilterColumns().stream().map(commonFilterCol -> (CommonFilterColumn)commonFilterCol).collect(Collectors.toList());
        for (CommonFilterColumn commonFilterColumn : commonFilterCols) {
            String fieldName = commonFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"epa_actevalobjind.actevalobj.assgroup.name")) {
                commonFilterColumn.setComboItems(groupCombos);
                continue;
            }
            if (!HRStringUtils.equals((String)fieldName, (String)"epa_evalflowrutask.flowrurole.flowdefrole.rolename")) continue;
            commonFilterColumn.setComboItems(roleCombos);
        }
    }

    private List<ComboItem> buildRoleComboItems() {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Long nodeDefId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeId");
        DynamicObject[] roles = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryRoleByNodeDefId(nodeDefId);
        Set defRoles = Arrays.stream(roles).map(role -> role.getDynamicObject("flowdefrole")).collect(Collectors.toSet());
        for (DynamicObject role2 : defRoles) {
            if (role2 == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(role2.getPkValue()));
            item.setCaption(new LocaleString(role2.getString("rolename")));
            item.setValue(String.valueOf(role2.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private List<ComboItem> buildAssGroupComboItems() {
        DynamicObject[] groups;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
        for (DynamicObject group : groups = (DynamicObject[])assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup")).toArray(DynamicObject[]::new)) {
            if (group == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(group.getPkValue()));
            item.setCaption(new LocaleString(group.getString("name")));
            item.setValue(String.valueOf(group.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private void beforeModifyEvaluator(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String evaluator = source.getOption().getVariableValue("evaluaties", "");
        if (HRStringUtils.isEmpty((String)evaluator)) {
            args.setCancel(true);
            List<Object> relationIdList = this.getSelectIdList();
            DynamicObject[] relations = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryRelationById(relationIdList);
            boolean isCheck = this.checkSelectRows(relations);
            if (!isCheck) {
                return;
            }
            boolean failStatus = Arrays.stream(relations).anyMatch(dy -> {
                String taskStatus = dy.getDynamicObject("rutask").getString("taskstatus");
                return !HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode()) && !HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.BE_WAITTING.getCode()) && !HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.WAITING.getCode()) && !HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.PROCESSING.getCode()) && !HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.PENDING.getCode());
            });
            if (failStatus) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u72b6\u6001\u4e3a\u201c\u672a\u6fc0\u6d3b/\u7b49\u5f85\u4e2d/\u5f85\u8bc4\u4f30/\u8bc4\u4f30\u4e2d/\u5df2\u6302\u8d77\u201d\u7684\u6570\u636e\u624d\u53ef\u8c03\u6574\u8bc4\u4f30\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EvalPersonCrossList_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("epa_modifyevaldialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("count", (Object)this.getSelectedRows().size());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_modifyevaldialog"));
            this.getView().showForm(parameter);
        }
    }

    private boolean checkSelectRows(DynamicObject[] relations) {
        List ruRoleIds = Arrays.stream(relations).map(dy -> dy.getLong("rutask.flowrurole.id")).collect(Collectors.toList());
        List indicatorIds = Arrays.stream(relations).map(dy -> dy.getLong("indicator")).collect(Collectors.toList());
        Map roleMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getRoleMap(ruRoleIds);
        Map roleToObjMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvalObjMap(ruRoleIds);
        Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(new ArrayList(roleToObjMap.values()));
        Map indicatorIdNameMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getIndicatorIdNameMap(indicatorIds);
        StringBuilder message = new StringBuilder();
        for (DynamicObject dy2 : relations) {
            boolean inStatus;
            boolean inEval;
            long roleId = dy2.getLong("rutask.flowrurole.id");
            Long objId = (Long)roleToObjMap.get(roleId);
            DynamicObject objDy = (DynamicObject)objMap.get(objId);
            boolean bl = inEval = NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(objDy.getLong("assessnode.id")) && AssessNodeStatusEnum.EVALUATING.getStatus().equals(objDy.getString("nodestatus"));
            if (!inEval) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message.append("\n");
                }
                message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u5df2\u4e0d\u5728\u8bc4\u4f30\u4e2d\uff0c\u4e0d\u53ef\u8c03\u6574\u8bc4\u4f30\u4eba", (String)"EvalPersonCrossList_14", (String)"opmc-epa-formplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
            }
            String roleStatus = ((DynamicObject)roleMap.get(roleId)).getString("rolestatus");
            boolean bl2 = inStatus = FlowRuRoleStatusEnum.PENDING.getCode().equals(roleStatus) || FlowRuRoleStatusEnum.RUNNING.getCode().equals(roleStatus) || FlowRuRoleStatusEnum.NOT_ACTIVE.getCode().equals(roleStatus);
            if (inStatus) continue;
            if (StringUtils.isNotBlank((CharSequence)message)) {
                message.append("\n");
            }
            String taskStatusStr = EntityMetaDataUtils.getEntityComboFieldItemName((String)"pbs_flowrurole", (String)"rolestatus", (String)roleStatus);
            String indicatorName = (String)indicatorIdNameMap.get(dy2.getLong("indicator"));
            String roleName = ((DynamicObject)roleMap.get(roleId)).getString("flowdefrole.rolename");
            message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u6307\u6807-\u201c{2}\u201d\u6240\u5728\u5f53\u524d\u8282\u70b9\u4e0b\u7684\u89d2\u8272-\u201c{3}\u201d\u5904\u4e8e\u201c{4}\u201d\uff0c\u4e0d\u53ef\u8c03\u6574\u8bc4\u4f30\u4eba", (String)"EvalPersonCrossList_15", (String)"opmc-epa-formplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), indicatorName, roleName, taskStatusStr}));
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            String title = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u53ef\u8c03\u6574\u8bc4\u4f30\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"EvalPersonCrossList_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title, message.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private List<Object> getSelectIdList() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        return selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "epa_actevalobjind.person.headsculpture", "epa_actevalobjind.person.name", "epa_actevalobjind.person.number");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        QFilter activityFilter = new QFilter("activity", "=", (Object)activityId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(Collections.singletonList(activityFilter));
        List fastQFilters = args.getFastQFilters();
        for (QFilter qFilter : fastQFilters) {
            Object value = qFilter.getValue();
            if (!(value instanceof String) || !((String)value).contains("epa_actevalobjind")) continue;
            qFilter.__setValue((Object)((String)value).replace("epa_actevalobjind.", ""));
        }
        filters.addAll(fastQFilters);
        List indicatorIds = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryIndicatorByObject(filters);
        fastQFilters.clear();
        fastQFilters.add(new QFilter("indicator", "in", (Object)indicatorIds));
    }

    private void beforeReturnEval(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String reason = source.getOption().getVariableValue("reason", "");
        if (HRStringUtils.isEmpty((String)reason)) {
            args.setCancel(true);
            List<Object> relationIdList = this.getSelectIdList();
            DynamicObject[] relations = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryRelationById(relationIdList);
            Set roleIdSet = Arrays.stream(relations).map(dy -> dy.getLong("rutask.flowrurole.id")).collect(Collectors.toSet());
            boolean isCommonSort = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.checkCommonSort(roleIdSet);
            if (!isCommonSort) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u89d2\u8272\u6d41\u8f6c\u987a\u5e8f\u76f8\u540c\u7684\u8bc4\u4f30\u4efb\u52a1\u3002", (String)"EvalPersonCrossList_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean failStatus = Arrays.stream(relations).anyMatch(dy -> {
                String taskStatus = dy.getDynamicObject("rutask").getString("taskstatus");
                return !HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.PROCESSED.getCode());
            });
            if (failStatus) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5df2\u8bc4\u4f30\u201d\u7684\u4efb\u52a1\u624d\u53ef\u9000\u56de\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EvalPersonCrossList_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("epa_returntaskdialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("dataCount", (Object)this.getSelectedRows().size());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_returntaskdialog"));
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
        }
    }
}

