/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evaluatinglist;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowCooperatorEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.common.utils.CommonResultBo;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class EvalPersonList
extends QueryListPlugin {
    private static final Log LOG = LogFactory.getLog(EvalPersonList.class);
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final String RETURN_EVAL = "returneval";
    private static final String ADD_EVAL_PERSON = "addevalperson";
    private static final String MODIFY_EVAL_PERSON = "modifyevalperson";
    private static final String DELETE_EVAL_TASK = "deleteevaltask";
    private static final String SEND_EVAL_TASK = "sendevaltask";
    private Map<Long, String> COOPERATOR_MAP = new HashMap<Long, String>(16);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeseq");
        QFilter nodeIndexFilter = new QFilter("pbs_flowrunode.index", "=", (Object)nodeIndex);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        QFilter activityFilter = new QFilter("activity", "=", (Object)activityId);
        Long evalFlowId = (Long)this.getView().getFormShowParameter().getCustomParam("evalflow");
        QFilter evalFlowFilter = new QFilter("epa_actevalobj.evalflow", "=", (Object)evalFlowId);
        DynamicObject[] objects = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvaluatedObj(activityId);
        List objIds = Arrays.stream(objects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter objFilter = new QFilter("epa_actevalobj.id", "in", objIds);
        QFilter isCooperatorTask = new QFilter("iscotask", "=", (Object)"0");
        event.getQFilters().add(nodeIndexFilter);
        event.getQFilters().add(activityFilter);
        event.getQFilters().add(evalFlowFilter);
        event.getQFilters().add(objFilter);
        event.getQFilters().add(isCooperatorTask);
        event.setOrderBy("epa_actevalobj.modifytime desc,taskstatus desc,evalflowins asc");
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        super.beforePackageData(dataEvent);
        DynamicObjectCollection pageData = dataEvent.getPageData();
        if (!pageData.isEmpty()) {
            List taskIds = pageData.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList());
            this.COOPERATOR_MAP = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getTasksCooperator(taskIds);
        }
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        DynamicObject rowData = evt.getRowData();
        AbstractColumnDesc source = (AbstractColumnDesc)evt.getSource();
        String fieldKey = source.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"evalwaittime")) {
            Date date = rowData.getDate("updatestatustime");
            int intervalDays = DateUtils.getIntervalDays((Date)date, (Date)new Date());
            evt.setFormatValue((Object)(intervalDays + "d"));
        }
        if (HRStringUtils.equals((String)fieldKey, (String)"cohandler")) {
            evt.setFormatValue((Object)"");
            if (this.COOPERATOR_MAP != null && !this.COOPERATOR_MAP.isEmpty()) {
                Long taskId = rowData.getLong("id");
                evt.setFormatValue((Object)(this.COOPERATOR_MAP.get(taskId) == null ? "" : this.COOPERATOR_MAP.get(taskId)));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BosListUtil.setGripMargin(this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (this.getView().getParentView().getParentView() == null) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"EvalPersonList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return;
        }
        switch (operateKey) {
            case "returneval": {
                this.returnEvalOpBeforeProcess(args);
                break;
            }
            case "modifyevalperson": {
                this.beforeModifyEvaluator(args);
                break;
            }
            case "addevalperson": {
                this.beforeAddEvaluator(args);
                break;
            }
            case "refresh": {
                FormOperate source = (FormOperate)args.getSource();
                String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
                if (HRStringUtils.equals((String)systemInvoke, (String)"true")) {
                    return;
                }
                args.setCancel(true);
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
                break;
            }
            case "adjcooperator": {
                this.cooperatorSetEval(args, "adjcooperator");
                break;
            }
            case "delcooperator": {
                this.delCooperatorBeforeOp(args);
                break;
            }
            case "setcooperator": {
                this.cooperatorSetEval(args, "setcooperator");
                break;
            }
        }
    }

    private void delCooperatorBeforeOp(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            int count = primaryKeyValues == null ? 0 : primaryKeyValues.length;
            String msgTxt = ResManager.loadKDString((String)"\u5df2\u9009\u62e9{0}\u6761\u6570\u636e\uff0c\u5220\u9664\u540e\u5176\u534f\u529e\u4eba\u8bc4\u4f30\u4efb\u52a1\u5c06\u5168\u90e8\u5931\u6548\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"EvalPersonList_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{count});
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(msgTxt);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delcooperator", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private void cooperatorSetEval(BeforeDoOperationEventArgs args, String operateKey) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            List idLongs = Arrays.stream(primaryKeyValues).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList());
            DynamicObject[] taskDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryTaskByIds(idLongs);
            String[] noPassStatus = new String[]{FlowRuTaskStatusEnum.NOT_ACTIVE.getCode(), FlowRuTaskStatusEnum.BE_WAITTING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.EXPIRED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()};
            List noPassStatusList = Arrays.stream(noPassStatus).collect(Collectors.toList());
            ArrayList<String> selectedNoPassStatusList = new ArrayList<String>(5);
            for (DynamicObject taskDy : taskDys) {
                String taskStatus = taskDy.getString("taskstatus");
                if (!noPassStatusList.contains(taskStatus) || selectedNoPassStatusList.contains(taskStatus)) continue;
                selectedNoPassStatusList.add(taskStatus);
            }
            if (selectedNoPassStatusList.size() > 0) {
                StringBuilder statusStb = new StringBuilder();
                for (String statusCode : selectedNoPassStatusList) {
                    String statusText = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)statusCode).getText();
                    statusStb.append(statusText).append("\u3001");
                }
                String statusStr = "";
                if (statusStb.length() > 0) {
                    statusStr = statusStb.substring(0, statusStb.length() - 1);
                }
                String errMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5b58\u5728\u5904\u4e8e\u201c{0}\u201d\u72b6\u6001\u7684\u8bc4\u4f30\u4efb\u52a1\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EvalPersonList_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{statusStr});
                this.getView().showErrorNotification(errMsg);
                args.setCancel(true);
                return;
            }
            FormShowParameter baseShowParameter = new FormShowParameter();
            baseShowParameter.setFormId("epa_evalsetcooperator");
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setStatus(OperationStatus.EDIT);
            String addCaptionTxt = ResManager.loadKDString((String)"\u65b0\u589e\u534f\u529e\u4eba", (String)"EvalPersonList_19", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            String addCaption = ResManager.getLocaleString((String)CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(addCaptionTxt), (String)"IndicatorSetterPlugin_6", (String)"opmc-epa-formplugin").getLocaleValue();
            String adjustCaptionTxt = ResManager.loadKDString((String)"\u8c03\u6574\u534f\u529e\u4eba", (String)"EvalPersonList_20", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            String adjustCaption = ResManager.getLocaleString((String)CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(adjustCaptionTxt), (String)"IndicatorSetterPlugin_7", (String)"opmc-epa-formplugin").getLocaleValue();
            baseShowParameter.setCaption(HRStringUtils.equals((String)operateKey, (String)"setcooperator") ? addCaption : adjustCaption);
            baseShowParameter.setCustomParam("SELECTED_ROW", (Object)primaryKeyValues.length);
            baseShowParameter.setCustomParam("ROW_DATA", (Object)primaryKeyValues);
            baseShowParameter.setCustomParam("operateKey", (Object)operateKey);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            this.getView().showForm(baseShowParameter);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
        switch (callBackId) {
            case "delcooperator": {
                if (!this.checkActivityPermission()) break;
                OperateOption delCoOp = OperateOption.create();
                delCoOp.setVariableValue("systeminvoke", "true");
                delCoOp.setVariableValue("OP_SOURCE", "formulate");
                this.getView().invokeOperation("delcooperator", delCoOp);
            }
        }
    }

    private boolean checkActivityPermission() {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650", (String)"EvalPersonList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }

    private List<Object> getSelectIdList() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        return selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "returneval": 
            case "addevalperson": 
            case "deleteevaltask": 
            case "modifyevalperson": 
            case "sendevaltask": 
            case "delcooperator": {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                this.getView().invokeOperation("refresh", operateOption);
                break;
            }
        }
    }

    private void returnEvalOpBeforeProcess(BeforeDoOperationEventArgs args) {
        List<Object> taskIdList = this.getSelectIdList();
        List validateList = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.validateTaskOfReturnEval(taskIdList);
        if (!ObjectUtils.isEmpty((Object)validateList)) {
            args.setCancel(true);
            for (String validate : validateList) {
                this.getView().showTipNotification(validate);
            }
            return;
        }
        AbstractOperate source = (AbstractOperate)args.getSource();
        String reason = source.getOption().getVariableValue("reason", "");
        if (HRStringUtils.isEmpty((String)reason)) {
            args.setCancel(true);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("epa_returntaskdialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("dataCount", (Object)this.getSelectedRows().size());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_returntaskdialog"));
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object childMap = event.getReturnData();
        if (HRObjectUtils.isEmpty((Object)childMap)) {
            return;
        }
        switch (actionId) {
            case "epa_returntaskdialog": {
                String reason = (String)event.getReturnData();
                if (HRStringUtils.isEmpty((String)reason)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("reason", reason);
                this.getView().invokeOperation(RETURN_EVAL, operateOption);
                break;
            }
            case "epa_modifyevaldialog": {
                Object returnData = event.getReturnData();
                if (ObjectUtils.isEmpty((Object)returnData)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("evaluaties", returnData.toString());
                this.getView().invokeOperation(MODIFY_EVAL_PERSON, operateOption);
                break;
            }
            case "epa_addevaldialog": {
                Object data = event.getReturnData();
                if (ObjectUtils.isEmpty((Object)data)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("evalPersonList", data.toString());
                this.getView().invokeOperation(ADD_EVAL_PERSON, operateOption);
                break;
            }
            case "setcooperator": 
            case "adjcooperator": {
                String returnStr = SerializationUtils.serializeToBase64((Object)childMap);
                Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                Long[] taskIdArr = Arrays.stream(primaryKeyValues).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList()).toArray(new Long[0]);
                this.setCooperator(returnStr, taskIdArr);
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                this.getView().invokeOperation("refresh", operateOption);
                break;
            }
        }
    }

    private void setCooperator(String returnStr, Long[] taskIdArr) {
        List taskIds = Arrays.stream(taskIdArr).collect(Collectors.toList());
        DynamicObject[] ruTaskDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryTaskByIds(taskIds);
        List objIds = Arrays.stream(ruTaskDys).map(dy -> dy.getLong("flowruproc.actevalobj")).collect(Collectors.toList());
        Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(objIds);
        Map handlerInfo = (Map)SerializationUtils.deSerializeFromBase64((String)returnStr);
        if (handlerInfo == null) {
            return;
        }
        List handlers = (List)handlerInfo.get("handlers");
        HashSet<Long> passIds = new HashSet<Long>();
        HashMap<Long, String> taskIdDescMap = new HashMap<Long, String>(16);
        HashMap<Long, String> taskIdFailMsgMap = new HashMap<Long, String>(16);
        int coFailCount = 0;
        for (DynamicObject task : ruTaskDys) {
            String failMsg;
            String failMsgTxt;
            long objId = task.getLong("flowruproc.actevalobj");
            DynamicObject objDy = (DynamicObject)objMap.get(objId);
            String roleStatus = task.getString("flowrurole.rolestatus");
            String handlerNameStr = task.getString("handler.name");
            Long handlerId = task.getLong("handler.id");
            String handlerName = HRStringUtils.isEmpty((String)handlerNameStr) ? "" : handlerNameStr;
            String desc = objDy.getString("person.name") + " " + objDy.getString("person.number");
            taskIdDescMap.put(task.getLong("id"), desc);
            if (!HRStringUtils.equals((String)objDy.getString("nodestatus"), (String)AssessNodeStatusEnum.EVALUATING.getStatus()) || !HRStringUtils.equals((String)objDy.getString("assessnode.id"), (String)ProcessManageApEnum.EVALUATING.getLabId())) {
                failMsgTxt = ResManager.loadKDString((String)"{0} {1}\uff1a\u8bc4\u4f30\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u8bc4\u4f30\u4e2d\u201d\uff0c\u4e0d\u80fd\u65b0\u589e\u534f\u529e\u4eba\u3002", (String)"EvalPersonList_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")});
                failMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(failMsgTxt);
                taskIdFailMsgMap.put(task.getLong("id"), failMsg);
                coFailCount += handlers.size();
                continue;
            }
            if (FlowRuRoleStatusEnum.FINISHED.getCode().equals(roleStatus)) {
                failMsgTxt = ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u5bf9\u5e94\u89d2\u8272\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5b8c\u6210\u201d\u4e0d\u80fd\u65b0\u589e\u534f\u529e\u4eba\u3002", (String)"EvalPersonList_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName});
                failMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(failMsgTxt);
                taskIdFailMsgMap.put(task.getLong("id"), failMsg);
                coFailCount += handlers.size();
                continue;
            }
            if (FlowRuRoleStatusEnum.EXPIRED.getCode().equals(roleStatus)) {
                failMsgTxt = ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u5bf9\u5e94\u89d2\u8272\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5931\u6548\u201d\u4e0d\u80fd\u65b0\u589e\u534f\u529e\u4eba\u3002", (String)"EvalPersonList_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName});
                failMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(failMsgTxt);
                taskIdFailMsgMap.put(task.getLong("id"), failMsg);
                coFailCount += handlers.size();
                continue;
            }
            if (FlowRuRoleStatusEnum.RETURNED.getCode().equals(roleStatus)) {
                failMsgTxt = ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u5bf9\u5e94\u89d2\u8272\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u9000\u56de\u201d\u4e0d\u80fd\u65b0\u589e\u534f\u529e\u4eba\u3002", (String)"EvalPersonList_9", (String)"opmc-epa-formplugin", (Object[])new Object[]{desc, handlerName});
                failMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(failMsgTxt);
                taskIdFailMsgMap.put(task.getLong("id"), failMsg);
                coFailCount += handlers.size();
                continue;
            }
            passIds.add(task.getLong("id"));
        }
        HashMap<Long, List> cooperatorMap = new HashMap<Long, List>(16);
        for (Long mainTaskId : passIds) {
            cooperatorMap.put(mainTaskId, handlers);
        }
        CommonResultBo commonResultBo = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.setCooperator(cooperatorMap, FlowCooperatorEnum.ADD_COOPERATOR);
        LOG.info("commonResultBo: {}", (Object)commonResultBo);
        if (commonResultBo != null) {
            if (commonResultBo.getCode() == 1) {
                Object idUserMap = new HashMap(16);
                if (handlers != null) {
                    idUserMap = BusinessDataServiceHelper.loadFromCache((Object[])handlers.toArray(), (String)"bos_user");
                }
                Map errorMsgMap = commonResultBo.getErroMsgMap();
                for (Long taskId : passIds) {
                    if (errorMsgMap == null || cooperatorMap.get(taskId) == null || errorMsgMap.get(taskId) == null) continue;
                    Map cooperatorMsg = (Map)errorMsgMap.get(taskId);
                    List cooperator = (List)cooperatorMap.get(taskId);
                    String msgDesc = "";
                    String errMsg = "";
                    StringBuilder errMsgStrB = new StringBuilder();
                    for (Long cooperatorId : cooperator) {
                        if (idUserMap != null && !HRObjectUtils.isEmpty(idUserMap.get(cooperatorId))) {
                            DynamicObject dynamicObject = (DynamicObject)idUserMap.get(cooperatorId);
                            msgDesc = MessageFormat.format("{0} {1}:", dynamicObject.getString("name"), dynamicObject.getString("number"));
                        }
                        if (cooperatorMsg.get(cooperatorId) == null) continue;
                        errMsgStrB.append(msgDesc).append((String)cooperatorMsg.get(cooperatorId));
                        errMsgStrB.append("\u3001");
                    }
                    if (errMsgStrB.length() > 0) {
                        errMsg = errMsgStrB.substring(0, errMsgStrB.length() - 1);
                    }
                    coFailCount += cooperator.size();
                    taskIdFailMsgMap.put(taskId, errMsg);
                }
            } else {
                for (Long taskId : passIds) {
                    taskIdFailMsgMap.put(taskId, commonResultBo.getSumResult());
                }
                coFailCount += passIds.size() * handlers.size();
            }
            StringBuilder failMessageStb = new StringBuilder();
            String failReasonMessage = "";
            for (Long taskId : taskIds) {
                if (taskIdFailMsgMap.get(taskId) == null) continue;
                failMessageStb.append((String)taskIdDescMap.get(taskId)).append(" : ");
                failMessageStb.append((String)taskIdFailMsgMap.get(taskId));
                failMessageStb.append("\r\n");
            }
            if (failMessageStb.length() > 0) {
                failReasonMessage = failMessageStb.substring(0, failMessageStb.length() - 1);
            }
            if (coFailCount == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f", (String)"EvalPersonList_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else if (coFailCount == taskIds.size() * handlers.size()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5931\u8d25", (String)"EvalPersonList_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            } else {
                String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6d89\u53ca\u9700\u65b0\u589e{1}\u6761\u534f\u529e\u4eba\u6570\u636e\uff0c\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761", (String)"EvalPersonList_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{taskIds.size(), taskIds.size() * handlers.size(), taskIds.size() * handlers.size() - coFailCount, coFailCount});
                this.getView().showMessage(title, failReasonMessage, MessageTypes.Default);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (HRStringUtils.equals((String)"epa_actevalobj.assgroup.name", (String)fieldName) || "epa_actevalobj.assgroup.id".equals(fieldName)) {
            List qFilters = args.getQfilters();
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
            List ids = assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup").getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", ids));
        } else if (HRStringUtils.equals((String)"flowrurole.flowdefrole.rolename", (String)fieldName) || HRStringUtils.equals((String)"flowrurole.flowdefrole.id", (String)fieldName)) {
            List qFilters = args.getQfilters();
            Long nodeDefId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeId");
            DynamicObject[] roles = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryRoleByNodeDefId(nodeDefId);
            List ids = Arrays.stream(roles).map(obj -> obj.getLong("flowdefrole.id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", ids));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List<ComboItem> groupCombos = this.buildAssGroupComboItems();
        List<ComboItem> roleCombos = this.buildRoleComboItems();
        List schemeFilterCols = args.getSchemeFilterColumns().stream().map(filterFilterCol -> (SchemeFilterColumn)filterFilterCol).collect(Collectors.toList());
        for (SchemeFilterColumn schemeFilterColumn : schemeFilterCols) {
            String fieldName = schemeFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"epa_actevalobj.assgroup.name")) {
                schemeFilterColumn.setComboItems(groupCombos);
                continue;
            }
            if (!HRStringUtils.equals((String)fieldName, (String)"flowrurole.flowdefrole.rolename")) continue;
            schemeFilterColumn.setComboItems(roleCombos);
        }
        List commonFilterCols = args.getCommonFilterColumns().stream().map(commonFilterCol -> (CommonFilterColumn)commonFilterCol).collect(Collectors.toList());
        for (CommonFilterColumn commonFilterColumn : commonFilterCols) {
            String fieldName = commonFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)"epa_actevalobj.assgroup.name")) {
                commonFilterColumn.setComboItems(groupCombos);
                continue;
            }
            if (!HRStringUtils.equals((String)fieldName, (String)"flowrurole.flowdefrole.rolename")) continue;
            commonFilterColumn.setComboItems(roleCombos);
        }
    }

    private List<ComboItem> buildRoleComboItems() {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Long nodeDefId = (Long)this.getView().getFormShowParameter().getCustomParam("nodeId");
        DynamicObject[] roles = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryRoleByNodeDefId(nodeDefId);
        Set defRoles = Arrays.stream(roles).map(role -> role.getDynamicObject("flowdefrole")).collect(Collectors.toSet());
        for (DynamicObject role2 : defRoles) {
            if (role2 == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(role2.getPkValue()));
            item.setCaption(new LocaleString(role2.getString("rolename")));
            item.setValue(String.valueOf(role2.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private List<ComboItem> buildAssGroupComboItems() {
        DynamicObject[] groups;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
        for (DynamicObject group : groups = (DynamicObject[])assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup")).toArray(DynamicObject[]::new)) {
            if (group == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(group.getPkValue()));
            item.setCaption(new LocaleString(group.getString("name")));
            item.setValue(String.valueOf(group.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private void beforeAddEvaluator(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String addPersonListStr = op.getOption().getVariableValue("evalPersonList", "");
        if (StringUtils.isBlank((CharSequence)addPersonListStr)) {
            List<Object> taskIdList = this.getSelectIdList();
            DynamicObject[] taskDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryTaskById(taskIdList);
            if (this.checkActObj(taskDys)) {
                args.setCancel(true);
                return;
            }
            List roleIds = Arrays.stream(taskDys).filter(task -> {
                String roleStatus = task.getDynamicObject("flowrurole").getString("rolestatus");
                return FlowRuRoleStatusEnum.PENDING.getCode().equals(roleStatus) || FlowRuRoleStatusEnum.RUNNING.getCode().equals(roleStatus) || FlowRuRoleStatusEnum.NOT_ACTIVE.getCode().equals(roleStatus);
            }).map(task -> task.getLong("flowrurole.id")).collect(Collectors.toList());
            args.setCancel(true);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("epa_addevaldialog");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("roleIds", roleIds);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_addevaldialog"));
            this.getView().showForm(showParameter);
        }
    }

    private boolean checkActObj(DynamicObject[] taskDys) {
        Object[] pKvalues = Arrays.stream(taskDys).map(dy -> dy.getLong("flowruproc.actevalobj")).toArray();
        DynamicObject[] actObjs = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryByPkValues(pKvalues);
        StringBuilder message = new StringBuilder();
        for (DynamicObject objDy : actObjs) {
            boolean inEval;
            boolean bl = inEval = NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(objDy.getLong("assessnode.id")) && AssessNodeStatusEnum.EVALUATING.getStatus().equals(objDy.getString("nodestatus"));
            if (inEval) continue;
            if (StringUtils.isNotBlank((CharSequence)message)) {
                message.append("\n");
            }
            message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-%1$s\uff08%2$s\uff09\uff1a\u5df2\u4e0d\u5728\u8bc4\u4f30\u4e2d\uff0c\u4e0d\u53ef\u6dfb\u52a0\u8bc4\u4f30\u4eba\u3002", (String)"EvalPersonList_13", (String)"opmc-epa-formplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            String title = ResManager.loadKDString((String)"\u5b58\u5728\u6570\u636e\u4e0d\u7b26\u5408\u672c\u64cd\u4f5c\u7684\u6761\u4ef6", (String)"EvalPersonList_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title, message.toString(), MessageTypes.Default);
            return true;
        }
        return false;
    }

    private void beforeModifyEvaluator(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String evaluator = source.getOption().getVariableValue("evaluaties", "");
        if (HRStringUtils.isEmpty((String)evaluator)) {
            List<Object> taskIdList = this.getSelectIdList();
            DynamicObject[] taskDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryTaskById(taskIdList);
            boolean failStatus = Arrays.stream(taskDys).anyMatch(task -> !HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode()) && !HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.BE_WAITTING.getCode()) && !HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.WAITING.getCode()) && !HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PROCESSING.getCode()) && !HRStringUtils.equals((String)task.getString("taskstatus"), (String)FlowRuTaskStatusEnum.PENDING.getCode()));
            args.setCancel(true);
            if (failStatus) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u72b6\u6001\u4e3a\u201c\u672a\u6fc0\u6d3b/\u7b49\u5f85\u4e2d/\u5f85\u8bc4\u4f30/\u8bc4\u4f30\u4e2d/\u5df2\u6302\u8d77\u201d\u7684\u6570\u636e\u624d\u53ef\u8c03\u6574\u8bc4\u4f30\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EvalPersonList_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isCheck = this.checkSelectRows(taskDys);
            if (!isCheck) {
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("epa_modifyevaldialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("count", (Object)this.getSelectedRows().size());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_modifyevaldialog"));
            this.getView().showForm(parameter);
        }
    }

    private boolean checkSelectRows(DynamicObject[] taskDys) {
        Map<Long, List<DynamicObject>> taskByObjMap = Arrays.stream(taskDys).collect(Collectors.groupingBy(task -> task.getLong("flowruproc.actevalobj")));
        Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(new ArrayList<Long>(taskByObjMap.keySet()));
        StringBuilder message = new StringBuilder();
        for (Map.Entry<Long, List<DynamicObject>> set : taskByObjMap.entrySet()) {
            boolean inEval;
            DynamicObject objDy = (DynamicObject)objMap.get(set.getKey());
            boolean bl = inEval = NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(objDy.getLong("assessnode.id")) && AssessNodeStatusEnum.EVALUATING.getStatus().equals(objDy.getString("nodestatus"));
            if (!inEval) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message.append("\n");
                }
                message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-%1$s\uff08%2$s\uff09\uff1a\u5df2\u4e0d\u5728\u8bc4\u4f30\u4e2d\uff0c\u4e0d\u53ef\u8c03\u6574\u8bc4\u4f30\u4eba\u3002", (String)"EvalPersonList_16", (String)"opmc-epa-formplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
            }
            Map<Long, List<DynamicObject>> roleMap = set.getValue().stream().collect(Collectors.groupingBy(dy -> dy.getLong("flowrurole.id")));
            for (Map.Entry<Long, List<DynamicObject>> roleSet : roleMap.entrySet()) {
                List<DynamicObject> value = roleSet.getValue();
                if (value.size() <= 1) continue;
                DynamicObject roleDy = value.get(0);
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message.append("\n");
                }
                message.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-%1$s\uff08%2$s\uff09\uff1a\u5728\u89d2\u8272-\u201c%3$s\u201d\u4e0b\u52fe\u9009\u4e86\u591a\u6761\u6570\u636e\uff0c\u4e0d\u53ef\u5c06\u540c\u4e00\u8bc4\u4f30\u5bf9\u8c61\u540c\u4e00\u89d2\u8272\u7684\u591a\u4e2a\u8bc4\u4f30\u4eba\u8c03\u6574\u4e3a\u540c\u4e00\u8bc4\u4f30\u4eba\u3002", (String)"EvalPersonList_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), roleDy.getString("flowrurole.flowdefrole.rolename")}));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            String title = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u53ef\u8c03\u6574\u8bc4\u4f30\u4eba\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"EvalPersonList_18", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title, message.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "epa_actevalobj.person.headsculpture", "epa_actevalobj.perffile.name", "epa_actevalobj.perffile.billno");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }
}

