/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evaluatinglist;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.service.FlowHandlerDomainService;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SendEvalTaskListPlugin
extends QueryListPlugin {
    private static final String DEFPROC = "epa_actevalobj.evalflow";
    private static final String NODESTATUS = "epa_actevalobj.nodestatus";
    private static final String ASSESSNODE = "epa_actevalobj.assessnode";
    private static final String QUERY_NODEINDEX = "epa_actevalobj.nodeindex";
    private static final String QUERY_ASSGROUP_NAME = "epa_actevalobj.assgroup.name";
    private static final String TASKSTATUS = "taskstatus";
    private static final String SEND_TASK_CONFIRM_BACK = "sendTaskConfirmBack";
    private static final String NOTHING_SENDTASK = "donothing_sendtask";
    private static final String NOTHING_CLOSE = "donothing_close";
    private static final String WAIT_TIME = "waittime";
    private static final String UPDATE_STATUS_TIME = "updatestatustime";
    private static final long dayLong = 86400000L;
    private static final FlowHandlerDomainService FLOW_HANDLER_DOMAIN_SERVICE = FlowHandlerDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUSUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();

    public void setFilter(SetFilterEvent e) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object flowId = this.getView().getFormShowParameter().getCustomParam("flowDefId");
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        QFilter filter = new QFilter("activity", "=", (Object)activityId).and(DEFPROC, "=", (Object)Long.parseLong(flowId.toString())).and(NODESTATUS, "=", (Object)AssessNodeStatusEnum.EVALUATING.getStatus()).and(ASSESSNODE, "=", (Object)Long.valueOf(ProcessManageApEnum.EVALUATING.getLabId())).and(QUERY_NODEINDEX, "=", (Object)nodeIndex).and(TASKSTATUS, "=", (Object)FlowRuTaskStatusEnum.BE_WAITTING.getCode());
        e.getQFilters().add(filter);
        e.setOrderBy("epa_actevalobj.modifytime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)NOTHING_SENDTASK)) {
            boolean actPerm = EvalObjUtils.checkActivityPermission((IFormView)this.getView());
            if (!actPerm) {
                args.setCancel(true);
                return;
            }
            ConfirmCallBackListener confirmListener = new ConfirmCallBackListener(SEND_TASK_CONFIRM_BACK, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u53d1\u9001\u8bc4\u4f30\u4efb\u52a1\u53ca\u6d88\u606f\u7ed9\u8bc4\u4f30\u4eba\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"SendEvalTaskListPlugin_0", (String)"opmc-epa-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)NOTHING_CLOSE)) {
            this.getView().close();
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
            return;
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"refresh")) {
            String flowId = this.getView().getParentView().getPageCache().get("flowDefId");
            this.getView().getFormShowParameter().setCustomParam("flowDefId", (Object)flowId);
            return;
        }
    }

    public void packageData(PackageDataEvent evt) {
        Object source = evt.getSource();
        if (source instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc columnDesc = (DynamicTextColumnDesc)source;
            switch (columnDesc.getKey()) {
                case "waittime": {
                    this.setWaitTimeFormatValue(evt);
                }
            }
        }
    }

    private void setWaitTimeFormatValue(PackageDataEvent dataEvent) {
        DynamicObject taskDy = dataEvent.getRowData();
        Date updateStatusTime = taskDy.getDate(UPDATE_STATUS_TIME);
        Date today = new Date();
        long diffTime = today.getTime() - updateStatusTime.getTime();
        long days = diffTime / 86400000L;
        dataEvent.setFormatValue((Object)MessageFormat.format("{0}{1}", String.valueOf(days), "d"));
    }

    private void sendTaskToFlow() {
        String number;
        String name;
        DynamicObject actevalobj;
        DynamicObject handler;
        int totalSize;
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List taskIdList = selectedRows.stream().map(ListSelectedRow2 -> (Long)ListSelectedRow2.getPrimaryKeyValue()).collect(Collectors.toList());
        ArrayList taskIds = Lists.newArrayListWithCapacity((int)10);
        Map<Long, DynamicObject> taskMap = this.queryTaskMapByTaskIds();
        Map<Long, DynamicObject> evalMap = this.queryEvalByTaskIds(taskMap);
        if (MapUtils.isEmpty(taskMap) || MapUtils.isEmpty(evalMap)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25", (String)"SendEvalTaskListPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> failMessage = new ArrayList<String>(16);
        int success = totalSize = taskIdList.size();
        for (Object id : taskIdList) {
            DynamicObject dynamicObject = taskMap.get(id);
            String taskstatus = dynamicObject.getString(TASKSTATUS);
            if (!StringUtils.equals((CharSequence)taskstatus, (CharSequence)FlowRuTaskStatusEnum.BE_WAITTING.getCode())) {
                if (!Objects.isNull(dynamicObject)) {
                    handler = dynamicObject.getDynamicObject("handler");
                    actevalobj = evalMap.get(dynamicObject.get("flowruproc.actevalobj"));
                    if (!HRObjectUtils.isEmpty((Object)actevalobj)) {
                        name = Objects.isNull(handler) || HRStringUtils.isEmpty((String)handler.getString("name")) ? "" : handler.getString("name");
                        number = Objects.isNull(handler) || HRStringUtils.isEmpty((String)handler.getString("number")) ? "" : handler.getString("number");
                        failMessage.add(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61 - %1$s ( %2$s ) :\u8bc4\u4f30\u4eba - %3$s ( %4$s ) \u7684\u8bc4\u4f30\u4efb\u52a1\u5df2\u4e0d\u5728\u201c\u7b49\u5f85\u4e2d\u201d\u3002", (String)"SendEvalTaskListPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{actevalobj.get("person.name"), actevalobj.get("person.number"), name, number}));
                    }
                }
                --success;
                continue;
            }
            taskIds.add(id);
        }
        Map resultMap = FLOW_HANDLER_DOMAIN_SERVICE.startProcessAfterWaiting((List)taskIds);
        if (!MapUtils.isEmpty((Map)resultMap)) {
            for (Map.Entry entry : resultMap.entrySet()) {
                if (Objects.isNull(entry.getValue()) || ((Boolean)entry.getValue()).booleanValue()) continue;
                DynamicObject taskInfo = taskMap.get(entry.getKey());
                if (!Objects.isNull(taskInfo)) {
                    handler = taskInfo.getDynamicObject("handler");
                    actevalobj = evalMap.get(taskInfo.get("flowruproc.actevalobj"));
                    if (!HRObjectUtils.isEmpty((Object)actevalobj)) {
                        name = Objects.isNull(handler) || HRStringUtils.isEmpty((String)handler.getString("name")) ? "" : handler.getString("name");
                        number = Objects.isNull(handler) || HRStringUtils.isEmpty((String)handler.getString("number")) ? "" : handler.getString("number");
                        failMessage.add(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61 - %1$s ( %2$s ) :\u8bc4\u4f30\u4eba - %3$s ( %4$s ) \u7684\u8bc4\u4f30\u4efb\u52a1\u53d1\u9001\u5931\u8d25\u3002", (String)"SendEvalTaskListPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{actevalobj.get("person.name"), actevalobj.get("person.number"), name, number}));
                    }
                }
                --success;
            }
        }
        if (totalSize == success) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u9001\u6210\u529f", (String)"SendEvalTaskListPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"SendEvalTaskListPlugin_5", (String)"opmc-epa-business", (Object[])new Object[0]), totalSize, success, totalSize - success);
            Tuple tuple = Tuple.create((Object)title, (Object)String.join((CharSequence)"\n", failMessage));
            this.getView().showMessage(String.valueOf(tuple.item1), String.valueOf(tuple.item2), MessageTypes.Default);
        }
        this.getView().invokeOperation("refresh");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("fseq", "handler.name", "handler.number");
        fixedColumnList.forEach(column -> args.getListColumn(column).setFixed(true));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)SEND_TASK_CONFIRM_BACK, (CharSequence)callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            boolean actPerm = EvalObjUtils.checkActivityPermission((IFormView)this.getView());
            if (!actPerm) {
                return;
            }
            this.sendTaskToFlow();
        }
    }

    private Map<Long, DynamicObject> queryEvalByTaskIds() {
        List taskIdMap = Arrays.stream(this.getSelectedRows().getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList());
        Map taskMap = FLOW_HANDLER_DOMAIN_SERVICE.queryEvalIdsByTaskIds(taskIdMap);
        if (MapUtils.isEmpty((Map)taskMap)) {
            return null;
        }
        List evalIds = taskMap.values().stream().map(DynamicObject2 -> DynamicObject2.getLong("flowruproc.actevalobj")).collect(Collectors.toList());
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjectsByIds(evalIds);
    }

    private Map<Long, DynamicObject> queryEvalByTaskIds(Map<Long, DynamicObject> taskMap) {
        if (MapUtils.isEmpty(taskMap)) {
            return null;
        }
        List evalIds = taskMap.values().stream().map(DynamicObject2 -> DynamicObject2.getLong("flowruproc.actevalobj")).collect(Collectors.toList());
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjectsByIds(evalIds);
    }

    private Map<Long, DynamicObject> queryTaskMapByTaskIds() {
        List taskIdMap = Arrays.stream(this.getSelectedRows().getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList());
        return FLOW_HANDLER_DOMAIN_SERVICE.queryEvalIdsByTaskIds(taskIdMap);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List<ComboItem> groupCombos = this.buildGroupComboItems();
        DynamicObject flowProc = this.getFlowProcDy();
        List<ComboItem> nodeCombos = this.buildNodeComboItems(flowProc);
        List<ComboItem> roleCombos = this.buildRoleComboItems(flowProc);
        List commonFilterCols = args.getCommonFilterColumns().stream().map(commonFilterCol -> (CommonFilterColumn)commonFilterCol).collect(Collectors.toList());
        for (CommonFilterColumn commonFilterColumn : commonFilterCols) {
            String fieldName = commonFilterColumn.getFieldName();
            if (HRStringUtils.equals((String)fieldName, (String)QUERY_ASSGROUP_NAME)) {
                commonFilterColumn.setComboItems(groupCombos);
            }
            if (HRStringUtils.equals((String)fieldName, (String)"flowrurole.flowdefrole.rolename")) {
                commonFilterColumn.setComboItems(roleCombos);
            }
            if (!HRStringUtils.equals((String)fieldName, (String)"flowrunode.flownodedef.nodename")) continue;
            commonFilterColumn.setComboItems(nodeCombos);
        }
    }

    private List<ComboItem> buildGroupComboItems() {
        DynamicObject[] assessGroup;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
        for (DynamicObject group : assessGroup = (DynamicObject[])assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup")).toArray(DynamicObject[]::new)) {
            if (group == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(group.getPkValue()));
            item.setCaption(new LocaleString(group.getString("name")));
            item.setValue(String.valueOf(group.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private List<ComboItem> buildNodeComboItems(DynamicObject flowProc) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        if (Objects.isNull(flowProc)) {
            return combos;
        }
        DynamicObjectCollection nodeDy = flowProc.getDynamicObjectCollection("nodeentry");
        for (DynamicObject node : nodeDy) {
            if (node == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(node.getPkValue()));
            item.setCaption(new LocaleString(node.getString("nodename")));
            item.setValue(String.valueOf(node.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private List<ComboItem> buildRoleComboItems(DynamicObject flowProc) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        if (Objects.isNull(flowProc)) {
            return combos;
        }
        List nodeIds = flowProc.getDynamicObjectCollection("nodeentry").stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        DynamicObject[] roleDy = FLOW_RUSUP_DOMAIN_SERVICE.queryRoleDefByNodeDef(nodeIds);
        if (Objects.isNull(roleDy)) {
            return combos;
        }
        for (DynamicObject role : roleDy) {
            if (role == null) continue;
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(role.getPkValue()));
            item.setCaption(new LocaleString(role.getString("rolename")));
            item.setValue(String.valueOf(role.getPkValue()));
            combos.add(item);
        }
        return combos;
    }

    private DynamicObject getFlowProcDy() {
        String flowId = this.getView().getParentView().getPageCache().get("flowDefId");
        DynamicObject[] flows = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowByPkValue((Set)Sets.newHashSet((Object[])new Object[]{Long.parseLong(flowId)}));
        if (Objects.isNull(flows) || flows.length <= 0) {
            return null;
        }
        Long flowProcId = ((DynamicObject)flows[0].getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
        DynamicObject flowProc = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowProcPkValue(flowProcId);
        if (Objects.isNull(flowProc)) {
            return null;
        }
        return flowProc;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("flowrunode.flownodedef.id".equals(fieldName) || "flowrunode.flownodedef.nodename".equals(fieldName)) {
            List<Long> nodeIds = this.getNodeIdLists();
            if (CollectionUtils.isEmpty(nodeIds)) {
                return;
            }
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("id", "in", nodeIds));
        }
        if ("flowrurole.flowdefrole.id".equals(fieldName) || "flowrurole.flowdefrole.rolename".equals(fieldName)) {
            String nodeIDsStr = this.getView().getPageCache().get("nodeIds");
            List nodeIds = HRStringUtils.isEmpty((String)nodeIDsStr) ? this.getNodeIdLists() : (List)SerializationUtils.fromJsonString((String)nodeIDsStr, List.class);
            if (CollectionUtils.isEmpty((Collection)nodeIds)) {
                return;
            }
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("defnode", "in", (Object)nodeIds));
        }
    }

    private List<Long> getNodeIdLists() {
        DynamicObject flowProc = this.getFlowProcDy();
        if (flowProc == null) {
            return null;
        }
        List<Long> nodeIds = flowProc.getDynamicObjectCollection("nodeentry").stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        this.getView().getPageCache().put("nodeIds", SerializationUtils.toJsonString(nodeIds));
        return nodeIds;
    }
}

