/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evaluator;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.LikeHint;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;

public class SetEvaluatorCorssList
extends HRDataBaseList {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final String ACTOBJ_DEFPROC = "actevalobj.evalflow";
    private static final String ACTOBJ_NODESTATUS = "actevalobj.nodestatus";
    private static final String ACTOBJ_NODEINDEX = "actevalobj.nodeindex";
    private static final String ACTOBJ_ASSESSNODE = "actevalobj.assessnode";
    private static final String HEADSCULPTURE = "person.headsculpture";
    private static final String AFFILIATEADMINORG = "actevalobj.affiliateadminorg.name";
    private static final String PERSON_NAME = "actevalobj.perffile.name";
    private static final String PERSON_NUMBER = "person.number";
    private static final String INDCTR_NAME = "indctrname";
    private Map<Long, String> evaluatorMap = new HashMap<Long, String>(16);

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object flowId = this.getView().getFormShowParameter().getCustomParam("flowDefId");
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        int lastIndex = nodeIndex - 1;
        Long lastNodeId = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getNodeIdByActIdAndIndex(activityId, lastIndex);
        String lastNodeStatus = AssessNodeStatusEnum.getLastNodeStatus((Long)lastNodeId).getStatus();
        this.getView().getPageCache().put("nodestatus", lastNodeStatus);
        QFilter qfilter = new QFilter("activity", "=", (Object)activityId).and(ACTOBJ_DEFPROC, "=", (Object)Long.parseLong(flowId.toString())).and(ACTOBJ_NODESTATUS, "=", (Object)lastNodeStatus).and(ACTOBJ_ASSESSNODE, "=", (Object)lastNodeId).and(ACTOBJ_NODEINDEX, "=", (Object)lastIndex);
        List filterList = evt.getQFilters();
        filterList.add(qfilter);
        QFilter actIdFilter = null;
        for (QFilter filter2 : filterList) {
            Object value;
            if (!"issetted".equals(filter2.getProperty()) || !((value = filter2.getValue()) instanceof String)) continue;
            String qcp = "1".equals(value) ? "in" : "not in";
            Long nodeDefId = (Long)this.getView().getFormShowParameter().getCustomParam("flownode");
            List ids = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getIdsByIsSetted(activityId, flowId, lastNodeStatus, lastNodeId, lastIndex, nodeDefId);
            actIdFilter = new QFilter("indicator", qcp, (Object)ids);
        }
        filterList.removeIf(filter -> "issetted".equals(filter.getProperty()));
        if (actIdFilter != null) {
            filterList.add(actIdFilter);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        List<String> fixedColumnList = Arrays.asList("fseq", HEADSCULPTURE, PERSON_NAME, PERSON_NUMBER, AFFILIATEADMINORG, INDCTR_NAME);
        fixedColumnList.forEach(column -> {
            if (columns != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        super.beforePackageData(evt);
        DynamicObjectCollection pageData = evt.getPageData();
        if (!pageData.isEmpty()) {
            Object[] ids = pageData.stream().map(DataEntityBase::getPkValue).toArray(Object[]::new);
            Long nodeDefId = (Long)this.getView().getFormShowParameter().getCustomParam("flownode");
            this.evaluatorMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvaluatorMap(nodeDefId, ids);
        }
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        Object source = evt.getSource();
        DynamicObject rowData = evt.getRowData();
        String evalperson = this.evaluatorMap.get(rowData.getLong("id"));
        if (source instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc columnDesc = (DynamicTextColumnDesc)source;
            if ("evaluaties".equals(columnDesc.getKey())) {
                evt.setFormatValue((Object)evalperson);
            }
        } else if (source instanceof ColumnDesc) {
            ColumnDesc columnDesc = (ColumnDesc)source;
            if ("issetted".equals(columnDesc.getKey())) {
                Integer isSet = StringUtils.isNotBlank((CharSequence)evalperson) ? 1 : 0;
                evt.setFormatValue((Object)isSet);
            }
            if ("roleevalperson".equals(columnDesc.getKey())) {
                evt.setFormatValue((Object)evalperson);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BosListUtil.setListBgColor(this.getView(), "#ffffff");
        BosListUtil.setGripMargin(this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean dataChange;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        boolean nullView = this.getView().getParentView().getParentView() == null;
        boolean bl = dataChange = this.getView().getParentView().getParentView() != null && StringUtils.isNotBlank((CharSequence)this.getView().getParentView().getParentView().getPageCache().get("datachange"));
        if (nullView || dataChange) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"SetEvaluatorCorssList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return;
        }
        if ("seteval".equals(key)) {
            String evals = this.getView().getPageCache().get("evaluaties");
            if (StringUtils.isBlank((CharSequence)evals)) {
                args.setCancel(true);
                if (this.checkActObj()) {
                    Object nodeId = this.getView().getFormShowParameter().getCustomParam("flownode");
                    Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("epa_setevaluator_corss");
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setStatus(OperationStatus.EDIT);
                    showParameter.setCustomParam("count", (Object)this.getSelectedRows().size());
                    showParameter.setCustomParam("flownode", nodeId);
                    showParameter.setCustomParam("selectIds", (Object)primaryKeyValues);
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_setevaluator_corss"));
                    this.getView().showForm(showParameter);
                }
            } else {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("batchop_batchsize", "0");
                op.setOption(operateOption);
                this.getView().getPageCache().remove("evaluaties");
            }
        } else if ("refresh".equals(key)) {
            FormOperate source = (FormOperate)args.getSource();
            String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
            if (HRStringUtils.equals((String)systemInvoke, (String)"true")) {
                return;
            }
            args.setCancel(true);
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("seteval".equals(operateKey)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("systeminvoke", "true");
            this.getView().invokeOperation("refresh", operateOption);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData != null && "epa_setevaluator_corss".equals(actionId)) {
            this.getView().getPageCache().put("evaluaties", returnData.toString());
            this.getView().invokeOperation("seteval");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private boolean checkActObj() {
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        DynamicObject[] objects = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryActObjByCrossId(primaryKeyValues);
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        String nodeStatus = this.getView().getPageCache().get("nodestatus");
        StringBuilder errorMessage = new StringBuilder();
        for (DynamicObject dy : objects) {
            DynamicObject objDy = dy.getDynamicObject("actevalobj");
            int index = objDy.getInt("nodeindex");
            String status = objDy.getString("nodestatus");
            if (index == nodeIndex - 1 && StringUtils.equals((CharSequence)status, (CharSequence)nodeStatus)) continue;
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                errorMessage.append("\n");
            }
            errorMessage.append(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u5df2\u4e0d\u5728\u7ee9\u6548\u8bc4\u4f30-\u5f85\u542f\u52a8\uff0c\u4e0d\u53ef\u8bbe\u7f6e", (String)"SetEvaluatorCorssList_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{dy.getString("person.name"), dy.getString(PERSON_NUMBER)}));
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            String title = ResManager.loadKDString((String)"\u5b58\u5728\u4e0d\u53ef\u8bbe\u7f6e\u7684\u6570\u636e\uff0c\u8bf7\u5173\u95ed\u5f39\u7a97\u540e\u5237\u65b0\u9875\u9762", (String)"SetEvaluatorCorssList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(title, errorMessage.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private QFilter getDefaultFilter() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object flowId = this.getView().getFormShowParameter().getCustomParam("flowDefId");
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        int lastIndex = nodeIndex - 1;
        Long lastNodeId = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getNodeIdByActIdAndIndex(activityId, lastIndex);
        String lastNodeStatus = AssessNodeStatusEnum.getLastNodeStatus((Long)lastNodeId).getStatus();
        QFilter qfilter = new QFilter("activity", "=", (Object)activityId).and(ACTOBJ_DEFPROC, "=", (Object)Long.parseLong(flowId.toString())).and(ACTOBJ_NODESTATUS, "=", (Object)lastNodeStatus).and(ACTOBJ_ASSESSNODE, "=", (Object)lastNodeId).and(ACTOBJ_NODEINDEX, "=", (Object)lastIndex);
        return qfilter;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final Long nodeDefId = (Long)this.getView().getFormShowParameter().getCustomParam("flownode");
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public List<QFilter> getQFilters() {
                List qFilterList = super.getQFilters();
                for (int i = 0; i < qFilterList.size(); ++i) {
                    String property;
                    QFilter qFilter = (QFilter)qFilterList.get(i);
                    if (qFilter == null || !"roleevalperson".equals(property = qFilter.getProperty())) continue;
                    Map acrossIds = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getAcrossIds(SetEvaluatorCorssList.this.getDefaultFilter(), nodeDefId);
                    qFilterList.remove(i);
                    --i;
                    QFilter acrossFilter = this.getPersonToAcrossFilter(qFilter, acrossIds);
                    if (acrossFilter == null) continue;
                    qFilterList.add(acrossFilter);
                }
                return qFilterList;
            }

            private QFilter getPersonToAcrossFilter(QFilter qFilter, Map<String, Set<Long>> nameOrNumberAcrossMap) {
                String cp = qFilter.getCP();
                cp = cp.toLowerCase();
                QFilter evalQFilter = null;
                switch (cp) {
                    case "like": {
                        evalQFilter = this.like(qFilter, nameOrNumberAcrossMap);
                        break;
                    }
                    case "not like": {
                        evalQFilter = this.notLike(qFilter, nameOrNumberAcrossMap);
                        break;
                    }
                    case "=": {
                        evalQFilter = this.equalsValue(qFilter, nameOrNumberAcrossMap);
                        break;
                    }
                    case "!=": {
                        evalQFilter = this.notEqualsValue(qFilter, nameOrNumberAcrossMap);
                        break;
                    }
                    case "in": {
                        evalQFilter = this.inValues(qFilter, nameOrNumberAcrossMap);
                        break;
                    }
                    case "not in": {
                        evalQFilter = this.notInValues(qFilter, nameOrNumberAcrossMap);
                        break;
                    }
                    case "is not null": {
                        evalQFilter = this.notNullValue(nameOrNumberAcrossMap);
                        break;
                    }
                }
                return evalQFilter;
            }

            private QFilter like(QFilter qFilter, Map<String, Set<Long>> nameOrNumAcrossIdsMap) {
                QFilterHint qFilterHint = qFilter.getQFilterHint();
                HashSet queryAcrossIds = new HashSet(16);
                if (qFilterHint instanceof LikeHint) {
                    boolean hasLeftPercent = ((LikeHint)qFilterHint).isAppendLeftPercent();
                    boolean hasRightPercent = ((LikeHint)qFilterHint).isAppendRightPercent();
                    Object value = qFilter.getOriginValue();
                    if (value instanceof String) {
                        nameOrNumAcrossIdsMap.forEach((nameOrNum, acrossIds) -> {
                            if (hasLeftPercent && hasRightPercent) {
                                if (nameOrNum != null && nameOrNum.contains((String)value)) {
                                    queryAcrossIds.addAll(acrossIds);
                                }
                            } else if (hasLeftPercent && !hasRightPercent) {
                                if (nameOrNum != null && nameOrNum.endsWith((String)value)) {
                                    queryAcrossIds.addAll(acrossIds);
                                }
                            } else if (!hasLeftPercent && hasRightPercent && nameOrNum != null && nameOrNum.startsWith((String)value)) {
                                queryAcrossIds.addAll(acrossIds);
                            }
                        });
                    }
                }
                return new QFilter("id", "in", queryAcrossIds);
            }

            private QFilter notLike(QFilter qFilter, Map<String, Set<Long>> nameOrNumAcrossIdsMap) {
                HashSet queryAcrossIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof String) {
                    nameOrNumAcrossIdsMap.forEach((nameOrNum, acrossIds) -> {
                        if (nameOrNum != null && nameOrNum.contains((String)value)) {
                            queryAcrossIds.addAll(acrossIds);
                        }
                    });
                }
                return new QFilter("id", "not in", queryAcrossIds);
            }

            private QFilter equalsValue(QFilter qFilter, Map<String, Set<Long>> nameOrNumAcrossIdsMap) {
                HashSet queryAcrossIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof String) {
                    nameOrNumAcrossIdsMap.forEach((nameOrNum, acrossIds) -> {
                        if (nameOrNum != null && nameOrNum.equals(value)) {
                            queryAcrossIds.addAll(acrossIds);
                        }
                    });
                } else if (value instanceof QEmptyValue) {
                    nameOrNumAcrossIdsMap.forEach((nameOrNum, acrossIds) -> {
                        if (nameOrNum != null && HRStringUtils.isEmpty((String)nameOrNum)) {
                            queryAcrossIds.addAll(acrossIds);
                        }
                    });
                }
                return new QFilter("id", "in", queryAcrossIds);
            }

            private QFilter notEqualsValue(QFilter qFilter, Map<String, Set<Long>> nameOrNumAcrossIdsMap) {
                HashSet queryAcrossIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof String) {
                    nameOrNumAcrossIdsMap.forEach((nameOrNum, acrossIds) -> {
                        if (nameOrNum != null && nameOrNum.equals(value)) {
                            queryAcrossIds.addAll(acrossIds);
                        }
                    });
                }
                return new QFilter("id", "not in", queryAcrossIds);
            }

            private QFilter notNullValue(Map<String, Set<Long>> nameOrNumAcrossIdsMap) {
                HashSet queryAcrossIds = new HashSet(16);
                nameOrNumAcrossIdsMap.forEach((nameOrNum, acrossIds) -> {
                    if (nameOrNum != null && HRStringUtils.isNotEmpty((String)nameOrNum)) {
                        queryAcrossIds.addAll(acrossIds);
                    }
                });
                return new QFilter("id", "in", queryAcrossIds);
            }

            private QFilter inValues(QFilter qFilter, Map<String, Set<Long>> nameOrNumAcrossIdsMap) {
                HashSet queryAcrossIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof List) {
                    nameOrNumAcrossIdsMap.forEach((nameOrNum, acrossIds) -> {
                        if (nameOrNum != null && ((List)value).contains(nameOrNum)) {
                            queryAcrossIds.addAll(acrossIds);
                        }
                    });
                }
                return new QFilter("id", "in", queryAcrossIds);
            }

            private QFilter notInValues(QFilter qFilter, Map<String, Set<Long>> nameOrNumAcrossIdsMap) {
                HashSet queryAcrossIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof List) {
                    nameOrNumAcrossIdsMap.forEach((nameOrNum, acrossIds) -> {
                        if (nameOrNum != null && ((List)value).contains(nameOrNum)) {
                            queryAcrossIds.addAll(acrossIds);
                        }
                    });
                }
                return new QFilter("id", "not in", queryAcrossIds);
            }
        });
    }
}

