/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evaluator;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.vo.SetEvalautorBO;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.business.domain.workflow.model.CrossScoreParamsBo;
import kd.opmc.pbs.business.domain.workflow.model.CrossScoreRoleBo;

public class SetEvaluatorCrossEditPlugin
extends HRDataBaseEdit
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final String BO_LIST = "boList";

    public void registerListener(EventObject e) {
        BasedataEdit evalF7 = (BasedataEdit)this.getView().getControl("evaluaties");
        BasedataEdit depempF7 = (BasedataEdit)this.getView().getControl("depempf7");
        depempF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        depempF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        evalF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object count = this.getView().getFormShowParameter().getCustomParam("count");
        this.getModel().setValue("count", count);
        this.addEntryData();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList list = new ArrayList(10);
        entryEntity.forEach(dy -> {
            SetEvalautorBO bo = new SetEvalautorBO();
            bo.setRoleWeight(dy.getBigDecimal("roleweight"));
            DynamicObjectCollection handers = dy.getDynamicObjectCollection("evaluaties");
            List handerIds = handers.stream().map(obj -> obj.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            bo.setHanderIds(SerializationUtils.serializeToBase64(handerIds));
            list.add(bo);
        });
        this.getView().getPageCache().put(BO_LIST, SerializationUtils.toJsonString(list));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("columnResizeMode", "preset");
        this.getView().updateControlMetadata("entryentity", map);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("confirm".equals(key)) {
            boolean ref;
            boolean actPerm = EvalObjUtils.checkActivityPermission((IFormView)this.getView());
            if (!actPerm) {
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection cols = this.getModel().getEntryEntity("entryentity");
            double count = cols.stream().filter(dy -> dy.getBoolean("enable")).mapToDouble(dy -> dy.getBigDecimal("roleweight") == null ? 0.0 : dy.getBigDecimal("roleweight").doubleValue()).sum();
            int value = BigDecimal.valueOf(count).compareTo(new BigDecimal(100));
            if (value != 0) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89d2\u8272\u6743\u91cd\u4e4b\u548c\u987b=100", (String)"SetEvaluatorCrossEditPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
            if (ref = cols.stream().anyMatch(dy -> dy.getBoolean("enable") && dy.getDynamicObjectCollection("evaluaties").isEmpty())) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8bc4\u4f30\u4eba\u201d\u3002", (String)"SetEvaluatorCrossEditPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("confirm".equals(operateKey) && args.getOperationResult().isSuccess()) {
            CrossScoreParamsBo paramsBo = this.packageCrossEvaluaties();
            boolean result = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.setCrossEvaluaties(paramsBo);
            if (result) {
                this.getView().returnDataToParent((Object)result);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8bc4\u4f30\u4eba\u5931\u8d25", (String)"SetEvaluatorCrossEditPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if ("enable".equals(name)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int selectRow = entryGrid.getSelectRows()[0];
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            boolean enable = ((DynamicObject)entryEntity.get(selectRow)).getBoolean("enable");
            String listStr = this.getView().getPageCache().get(BO_LIST);
            List boList = SerializationUtils.fromJsonStringToList((String)listStr, SetEvalautorBO.class);
            SetEvalautorBO bo = (SetEvalautorBO)boList.get(selectRow);
            if (enable) {
                String handerIds = bo.getHanderIds();
                List handerList = (List)SerializationUtils.deSerializeFromBase64((String)handerIds);
                DynamicObjectCollection baseCols = ((DynamicObject)entryEntity.get(selectRow)).getDynamicObjectCollection("evaluaties");
                DynamicObjectCollection handerCols = new DynamicObjectCollection(baseCols.getDynamicObjectType(), (Object)baseCols);
                handerList.forEach(hander -> {
                    DynamicObject newHander = new DynamicObject(baseCols.getDynamicObjectType());
                    newHander.set("fbasedataid", hander);
                    newHander.set("fbasedataid_id", hander.getPkValue());
                    handerCols.add((Object)newHander);
                });
                this.getModel().setValue("roleweight", (Object)bo.getRoleWeight(), selectRow);
                this.getModel().setValue("evaluaties", (Object)handerCols, selectRow);
            } else {
                boolean unable = entryEntity.stream().noneMatch(dy -> dy.getBoolean("enable"));
                if (unable) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u542f\u7528\u4e00\u4e2a\u89d2\u8272\u3002", (String)"SetEvaluatorCrossEditPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("enable", (Object)1, selectRow);
                    return;
                }
                BigDecimal weight = ((DynamicObject)entryEntity.get(selectRow)).getBigDecimal("roleweight");
                DynamicObjectCollection handers = ((DynamicObject)entryEntity.get(selectRow)).getDynamicObjectCollection("evaluaties");
                List handerIds = handers.stream().map(obj -> obj.getDynamicObject("fbasedataid")).collect(Collectors.toList());
                bo.setRoleWeight(weight);
                bo.setHanderIds(SerializationUtils.serializeToBase64(handerIds));
                boList.set(selectRow, bo);
                this.getView().getPageCache().put(BO_LIST, SerializationUtils.toJsonString((Object)boList));
                this.getModel().setValue("roleweight", null, selectRow);
                this.getModel().setValue("evaluaties", null, selectRow);
            }
        }
    }

    private CrossScoreParamsBo packageCrossEvaluaties() {
        Long nodeId = (Long)this.getView().getFormShowParameter().getCustomParam("flownode");
        DynamicObjectCollection cols = this.getModel().getEntryEntity("entryentity");
        CrossScoreParamsBo crossScoreBo = new CrossScoreParamsBo();
        crossScoreBo.setNodeDefId(nodeId);
        ArrayList<CrossScoreRoleBo> roleBoList = new ArrayList<CrossScoreRoleBo>(10);
        for (DynamicObject dy2 : cols) {
            if (!dy2.getBoolean("enable")) continue;
            CrossScoreRoleBo roleBo = new CrossScoreRoleBo();
            Long pkValue = (Long)dy2.getDynamicObject("flowdefrole").getPkValue();
            BigDecimal roleWeight = dy2.getBigDecimal("roleweight") == null ? new BigDecimal(0) : dy2.getBigDecimal("roleweight");
            int sort = dy2.getDynamicObject("flowdefrole").getInt("turnoversort");
            DynamicObjectCollection evals = dy2.getDynamicObjectCollection("evaluaties");
            List evalIds = evals.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            roleBo.setRoleDef(pkValue);
            roleBo.setTurnoverSort(sort);
            roleBo.setRoleWeight(Double.parseDouble(roleWeight.toString()));
            roleBo.setRoleHandlerList(evalIds);
            roleBoList.add(roleBo);
        }
        crossScoreBo.setCrossScoreRoleBo(roleBoList);
        HashMap<Long, Map<Long, Long>> actEvaObjIndMap = new HashMap<Long, Map<Long, Long>>(16);
        DynamicObject[] crossData = this.getSelectCrossData();
        Map<Long, List<DynamicObject>> actObjMap = Arrays.stream(crossData).collect(Collectors.groupingBy(dy -> (Long)dy.getDynamicObject("actevalobj").getPkValue()));
        for (Map.Entry<Long, List<DynamicObject>> set : actObjMap.entrySet()) {
            Map<Long, Long> indicatorMap = set.getValue().stream().collect(Collectors.toMap(dy -> dy.getLong("indicator"), dy -> dy.getLong("area")));
            actEvaObjIndMap.put(set.getKey(), indicatorMap);
        }
        crossScoreBo.setActEvaObjIndMap(actEvaObjIndMap);
        return crossScoreBo;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if ("evaluaties".equals(fieldKey)) {
            evt.setCancel(true);
            this.getModel().setValue("depempf7", null);
            BasedataEdit control = (BasedataEdit)this.getView().getControl("depempf7");
            control.click();
        } else if ("depempf7".equals(fieldKey)) {
            FormShowParameter formShowParameter = evt.getFormShowParameter();
            formShowParameter.setCustomParam("showeffect", (Object)"0");
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((Control)evt.getSource()).getKey();
        if ("depempf7".equals(fieldKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = entryGrid.getSelectRows();
            DynamicObjectCollection depemps = (DynamicObjectCollection)this.getModel().getValue("depempf7");
            if (depemps.size() > 100) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u4eba\u6700\u591a\u53ea\u80fd\u8bbe\u7f6e100\u4e2a\uff08\u542b\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SetEvaluatorCrossEditPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("evaluaties", null, rows[0]);
            } else {
                List depempIds = depemps.stream().map(dy -> dy.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                List userIds = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getUserIdsByDepempIds(depempIds);
                List flowCommonResultBos = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.verifyUserIsValid(userIds);
                for (FlowCommonResultBo flowCommonResultBo : flowCommonResultBos) {
                    if (!"-1".equals(flowCommonResultBo.getCode())) continue;
                    this.getView().showErrorNotification(flowCommonResultBo.getMessage());
                    this.getModel().setValue("evaluaties", null);
                    return;
                }
                if (CollectionUtils.isNotEmpty((Collection)userIds) && userIds.size() == flowCommonResultBos.size()) {
                    DynamicObjectCollection cols = (DynamicObjectCollection)this.getModel().getValue("evaluaties", rows[0]);
                    DynamicObjectCollection handerCols = new DynamicObjectCollection();
                    userIds.forEach(eval -> {
                        DynamicObject hander = new DynamicObject(cols.getDynamicObjectType());
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)eval, (String)"bos_user");
                        hander.set("fbasedataid", (Object)dynamicObject);
                        hander.set("fbasedataid_id", eval);
                        handerCols.add((Object)hander);
                    });
                    this.getModel().setValue("evaluaties", (Object)handerCols, rows[0]);
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u5904\u7406\u4eba\u5728\u5e73\u53f0\u8d26\u53f7\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SetEvaluatorCrossEditPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void addEntryData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.dealWithSetter(setter);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void dealWithSetter(TableValueSetter setter) {
        setter.addField("flowdefrole", new Object[0]);
        setter.addField("roleweight", new Object[0]);
        setter.addField("evaluaties", new Object[0]);
        setter.addField("enable", new Object[0]);
        Long nodeId = (Long)this.getView().getFormShowParameter().getCustomParam("flownode");
        DynamicObject[] crossData = this.getSelectCrossData();
        List indicatorIds = Arrays.stream(crossData).map(dy -> dy.getLong("indicator")).collect(Collectors.toList());
        List dataList = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvaluatiesByIndicatorId(nodeId, indicatorIds);
        DynamicObject[] defRoleDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getDefRoleByDefNodeId(nodeId);
        DynamicObject[] defRoles = (DynamicObject[])Arrays.stream(defRoleDys).sorted(Comparator.comparing(role -> role.getString("turnoversort"))).toArray(DynamicObject[]::new);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            Arrays.stream(defRoles).forEach(role -> setter.addRow(new Object[]{role.getPkValue(), role.getBigDecimal("roleweight"), null, true}));
        } else if (dataList.size() == defRoles.length) {
            dataList.stream().sorted(Comparator.comparing(data -> data.getInt("turnoversort"))).forEach(data -> {
                DynamicObjectCollection handerCols = this.createHanders((DynamicObject)data);
                setter.addRow(new Object[]{data.getDynamicObject("defroleid").getPkValue(), data.getBigDecimal("roleweight"), handerCols, true});
            });
        } else {
            int i = 0;
            int j = 0;
            while (i < defRoles.length) {
                if (j == dataList.size()) {
                    setter.addRow(new Object[]{defRoles[i].getPkValue(), null, null, false});
                    ++i;
                    continue;
                }
                if (defRoles[i].getPkValue().equals(((DynamicObject)dataList.get(j)).getDynamicObject("defroleid").getPkValue())) {
                    DynamicObject data2 = (DynamicObject)dataList.get(j);
                    DynamicObjectCollection handerCols = this.createHanders((DynamicObject)dataList.get(j));
                    setter.addRow(new Object[]{data2.getDynamicObject("defroleid").getPkValue(), data2.getBigDecimal("roleweight"), handerCols, true});
                    ++i;
                    ++j;
                    continue;
                }
                setter.addRow(new Object[]{defRoles[i].getPkValue(), null, null, false});
                ++i;
            }
        }
    }

    private DynamicObjectCollection createHanders(DynamicObject data) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection baseCols = ((DynamicObject)entryEntity.get(0)).getDynamicObjectCollection("evaluaties");
        DynamicObjectCollection handerCols = new DynamicObjectCollection();
        DynamicObjectCollection cols = data.getDynamicObjectCollection("entryentity");
        cols.forEach(dy -> {
            DynamicObject handerDy = dy.getDynamicObject("handlerid");
            DynamicObject hander = new DynamicObject(baseCols.getDynamicObjectType());
            hander.set("fbasedataid", (Object)handerDy);
            hander.set("fbasedataid_id", handerDy.getPkValue());
            handerCols.add((Object)hander);
        });
        return handerCols;
    }

    private DynamicObject[] getSelectCrossData() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam("selectIds");
        List selectIds = JSONObject.parseArray((String)JSONObject.toJSONString((Object)customParam), Long.class);
        return ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryActObjByCrossId(selectIds.toArray());
    }
}

