/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evaluator;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entity.AcrossEvaluatorListDataBO;
import kd.opmc.epa.business.domain.activitymanage.entity.EvaluatorListDataBO;
import kd.opmc.epa.common.utils.export.EPAExportDataHelper;
import kd.opmc.epa.common.vo.ExportSheetBO;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class SetEvaluatorDynamicPlugin
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(SetEvaluatorDynamicPlugin.class);
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessActivityApplicationService ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final String FLOW_NODE_MAP = "flowNodeMap";
    private static final String EXPORT_FLEX_AP = "exportflexap";
    private static final String EXPORT_VECTOR_AP = "exportvectorap";
    private static final String EXPORT_LABEL_AP = "exportlabelap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry nodeEntry = (CardEntry)this.getView().getControl("entryentity");
        nodeEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{EXPORT_FLEX_AP, EXPORT_VECTOR_AP, EXPORT_LABEL_AP});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            parentView.getPageCache().remove("datachange");
        }
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object nodexIndex = this.getView().getFormShowParameter().getCustomParam("nodeindex");
        Map flowMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvalFlowsMap(activityId, nodexIndex);
        DynamicObject[] flows = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowByPkValue(flowMap.keySet());
        DynamicObject perfWorkFlow = ACTIVITY_APPLICATION_SERVICE.queryPerfWorkFlow(activityId);
        DynamicObjectCollection flowEntry = perfWorkFlow.getDynamicObjectCollection("flowentry");
        Map<Long, Boolean> temMap = flowEntry.stream().collect(Collectors.toMap(itemL -> itemL.getLong("flowvid"), itemB -> itemB.getBoolean("isdefaultflow")));
        Arrays.stream(flows).forEach(item -> {
            if (temMap.containsKey(item.getLong("id"))) {
                item.set("isdefault", temMap.get(item.getLong("id")));
            }
        });
        this.initFlowNodeMap(flows);
        this.buildComboItem(flowMap, flows);
        this.addNodeCard();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.chooseFirstCard();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if ("flowcombo".equals(name)) {
            String flowId = (String)this.getModel().getValue("flowcombo");
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (null == parentViewPageCache) {
                return;
            }
            parentViewPageCache.put("currentSelectFlow", flowId);
            parentViewPageCache.remove("lastSelectRow");
            this.addNodeCard();
            this.chooseFirstCard();
        }
    }

    private void initFlowNodeMap(DynamicObject[] flows) {
        Map<Long, List> flowNodeMap = Arrays.stream(flows).collect(Collectors.toMap(flow -> flow.getLong("id"), flow -> {
            Long flowProcId = ((DynamicObject)flow.getDynamicObjectCollection("entryentity").get(0)).getLong("flowdefproc");
            DynamicObject flowProc = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowProcPkValue(flowProcId);
            return flowProc.getDynamicObjectCollection("nodeentry").stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }));
        String mapStr = JSONObject.toJSONString(flowNodeMap);
        this.getView().getPageCache().put(FLOW_NODE_MAP, mapStr);
    }

    private void buildComboItem(Map<Object, Long> flowMap, DynamicObject[] flows) {
        DynamicObject defaultFlow = Arrays.stream(flows).filter(dy -> dy.getBoolean("isdefault")).findFirst().orElse(null);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        if (defaultFlow != null) {
            String name = defaultFlow.getString("name");
            Long count = flowMap.get(defaultFlow.getPkValue());
            String value = name + "\uff08" + count + "\uff09";
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(defaultFlow.getPkValue()));
            item.setCaption(new LocaleString(value));
            item.setValue(String.valueOf(defaultFlow.getPkValue()));
            combos.add(item);
        }
        Arrays.stream(flows).filter(dy -> !dy.getBoolean("isdefault")).forEach(dy -> {
            String name = dy.getString("name");
            Long count = (Long)flowMap.get(dy.getPkValue());
            String value = name + String.format("\uff08%s\uff09", count);
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(dy.getPkValue()));
            item.setCaption(new LocaleString(value));
            item.setValue(String.valueOf(dy.getPkValue()));
            combos.add(item);
        });
        ComboEdit comboEdit = (ComboEdit)this.getControl("flowcombo");
        comboEdit.setComboItems(combos);
        this.getModel().setValue("flowcombo", (Object)((ComboItem)combos.get(0)).getId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"refresh")) {
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (parentViewPageCache == null) {
                return;
            }
            String selectFlow = parentViewPageCache.get("currentSelectFlow");
            String selectRow = parentViewPageCache.get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)selectFlow)) {
                this.getModel().setValue("flowcombo", (Object)selectFlow);
            }
            if (ObjectUtils.isEmpty((Object)selectRow)) {
                return;
            }
            CardEntry card = (CardEntry)this.getControl("entryentity");
            card.selectCard(Integer.valueOf(Integer.parseInt(selectRow)));
            parentViewPageCache.remove("lastSelectRow");
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof CardEntry && HRStringUtils.equals((String)"entryentity", (String)((CardEntry)source).getKey())) {
            int lastSelectRow;
            boolean dataChange;
            boolean nullView = this.getView().getParentView() == null;
            boolean bl = dataChange = this.getView().getParentView() != null && StringUtils.isNotBlank((CharSequence)this.getView().getParentView().getPageCache().get("datachange"));
            if (nullView || dataChange) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"SetEvaluatorDynamicPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
                return;
            }
            int row = evt.getRow();
            DynamicObjectCollection nodeEntry = this.getModel().getEntryEntity("entryentity");
            IPageCache parentViewPageCache = this.getParentViewPageCache();
            if (parentViewPageCache == null) {
                return;
            }
            String lastSelectRowStr = parentViewPageCache.get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)lastSelectRowStr) && (lastSelectRow = Integer.parseInt(lastSelectRowStr)) == row) {
                return;
            }
            for (int i = 0; i < nodeEntry.size(); ++i) {
                this.getView().getModel().setValue("isselected", (Object)(row == i ? 1 : 0), i);
            }
            parentViewPageCache.put("lastSelectRow", String.valueOf(row));
            Object pkValue = ((DynamicObject)nodeEntry.get(row)).getDynamicObject("flownode").getPkValue();
            Boolean crossscore = (Boolean)((DynamicObject)nodeEntry.get(row)).getDynamicObject("flownode").get("crossscore");
            this.showRightList(pkValue, row + 1, crossscore);
        }
    }

    private void showRightList(Object pkValue, int seq, Boolean crossscore) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object nodeIndex = this.getView().getFormShowParameter().getCustomParam("nodeindex");
        Object flowId = this.getModel().getValue("flowcombo");
        String billFormId = crossscore != false ? "epa_evalobjindlist_corss" : "epa_evalobjrolequery_all";
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId(billFormId);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("listpanel");
        parameter.setCustomParam("activity", (Object)activityId);
        parameter.setCustomParam("flowDefId", flowId);
        parameter.setCustomParam("flownode", pkValue);
        parameter.setCustomParam("seq", (Object)seq);
        parameter.setCustomParam("nodeindex", nodeIndex);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void addNodeCard() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.dealWithSetter(setter);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void dealWithSetter(TableValueSetter setter) {
        int seq = 1;
        setter.addField("flownode", new Object[0]);
        setter.addField("nodeposition", new Object[0]);
        setter.addField("isselected", new Object[0]);
        String flowId = String.valueOf(this.getModel().getValue("flowcombo"));
        String mapStr = this.getView().getPageCache().get(FLOW_NODE_MAP);
        JSONObject jsonObject = JSONObject.parseObject((String)mapStr);
        Object nodes = jsonObject.get((Object)flowId);
        List nodeIds = JSONObject.parseArray((String)JSONObject.toJSONString((Object)nodes), Long.class);
        for (Long nodeId : nodeIds) {
            String position = null;
            if (seq == 1) {
                position = "top";
            } else if (nodeIds.indexOf(nodeId) == nodeIds.size() - 1) {
                position = "bottom";
            }
            setter.addRow(new Object[]{nodeId, position, seq == 1});
            ++seq;
        }
    }

    private void chooseFirstCard() {
        CardEntry nodeCard = (CardEntry)this.getControl("entryentity");
        nodeCard.selectCard(Integer.valueOf(0));
    }

    private IPageCache getParentViewPageCache() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"SetEvaluatorDynamicPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return null;
        }
        return parentView.getPageCache();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().close();
        }
    }

    public void pageRelease(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            parentView.getPageCache().remove("lastSelectRow");
            parentView.getPageCache().remove("currentSelectFlow");
            parentView.getPageCache().remove("datachange");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (this.checkActivityPermission()) {
            this.exportExcel();
        }
    }

    protected boolean checkActivityPermission() {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650", (String)"SetEvaluatorDynamicPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }

    private void exportExcel() {
        String excelName = MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u8bbe\u7f6e\u8bc4\u4f30\u4eba_{0}", (String)"SetEvaluatorDynamicPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        List<HRExportHeadObject> headDataList = this.getExportHead();
        List<Map<String, Object>> exportDataList = this.getExportData();
        List<HRExportHeadObject> acrossExportHeadDataList = this.getAcrossExportHead();
        List<Map<String, Object>> acrossExportDataList = this.getAcrossExportData();
        String exportUrl = null;
        ExportSheetBO exportSheetBO = new ExportSheetBO(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8bc4\u4f30\u4eba_\u6574\u5355\u8282\u70b9", (String)"SetEvaluatorDynamicPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]), exportDataList, headDataList);
        ExportSheetBO acrossExportSheetBO = new ExportSheetBO(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8bc4\u4f30\u4eba_\u4ea4\u53c9\u8282\u70b9", (String)"SetEvaluatorDynamicPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]), acrossExportDataList, acrossExportHeadDataList);
        ArrayList<ExportSheetBO> exportSheetBOs = new ArrayList<ExportSheetBO>(10);
        exportSheetBOs.add(exportSheetBO);
        exportSheetBOs.add(acrossExportSheetBO);
        try {
            exportUrl = EPAExportDataHelper.getExportExcelUrl((String)excelName, exportSheetBOs);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        if (!HRStringUtils.isEmpty((String)exportUrl)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)exportUrl);
        }
    }

    private List<HRExportHeadObject> getExportHead() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("perffilenumber", ResManager.loadKDString((String)"\u7ee9\u6548\u6863\u6848\u7f16\u7801", (String)"SetEvaluatorDynamicPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"SetEvaluatorDynamicPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"SetEvaluatorDynamicPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("adminorg.name", ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"SetEvaluatorDynamicPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("process.name", ResManager.loadKDString((String)"\u6d41\u7a0b\u540d\u79f0", (String)"SetEvaluatorDynamicPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("node.name", ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0", (String)"SetEvaluatorDynamicPlugin_10", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("role.name", ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"SetEvaluatorDynamicPlugin_11", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("turnoversort", ResManager.loadKDString((String)"\u6d41\u8f6c\u987a\u5e8f", (String)"SetEvaluatorDynamicPlugin_12", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("handle.name", ResManager.loadKDString((String)"\u8bc4\u4f30\u4eba", (String)"SetEvaluatorDynamicPlugin_13", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("setup", ResManager.loadKDString((String)"\u624b\u52a8\u8bbe\u7f6e", (String)"SetEvaluatorDynamicPlugin_14", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("job.name", ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"SetEvaluatorDynamicPlugin_15", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("belongcom.name", ResManager.loadKDString((String)"\u6240\u5c5e\u516c\u53f8", (String)"SetEvaluatorDynamicPlugin_16", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        return headDataList;
    }

    private List<Map<String, Object>> getExportData() {
        Object nodexIndex;
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(10);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        List formulatorRoleListData = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvaluatorListData(activityId, nodexIndex = this.getView().getFormShowParameter().getCustomParam("nodeindex"));
        if (ObjectUtils.isEmpty((Object)formulatorRoleListData)) {
            return exportDataList;
        }
        for (EvaluatorListDataBO dataBO : formulatorRoleListData) {
            HashMap<String, Object> exportData = new HashMap<String, Object>(16);
            exportData.put("perffilenumber", dataBO.getPerfFileNumber());
            exportData.put("name", dataBO.getName());
            exportData.put("number", dataBO.getNumber());
            exportData.put("process.name", dataBO.getProcessName());
            exportData.put("node.name", dataBO.getNodeName());
            exportData.put("handle.name", dataBO.getHandle());
            exportData.put("setup", dataBO.getIsSetHandler());
            exportData.put("role.name", dataBO.getRole());
            exportData.put("turnoversort", dataBO.getTurnoversort());
            exportData.put("job.name", dataBO.getJob());
            exportData.put("adminorg.name", dataBO.getAdminorg());
            exportData.put("belongcom.name", dataBO.getBelongCom());
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    private List<HRExportHeadObject> getAcrossExportHead() {
        ArrayList<HRExportHeadObject> headDataList = new ArrayList<HRExportHeadObject>();
        headDataList.add(new HRExportHeadObject("perffilenumber", ResManager.loadKDString((String)"\u7ee9\u6548\u6863\u6848\u7f16\u7801", (String)"SetEvaluatorDynamicPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"SetEvaluatorDynamicPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"SetEvaluatorDynamicPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("adminorg.name", ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"SetEvaluatorDynamicPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("indicatorname", ResManager.loadKDString((String)"\u6307\u6807\u540d\u79f0", (String)"SetEvaluatorDynamicPlugin_17", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("process.name", ResManager.loadKDString((String)"\u6d41\u7a0b\u540d\u79f0", (String)"SetEvaluatorDynamicPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("node.name", ResManager.loadKDString((String)"\u8282\u70b9\u540d\u79f0", (String)"SetEvaluatorDynamicPlugin_10", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("handle.name", ResManager.loadKDString((String)"\u89d2\u8272\u8bc4\u4f30\u4eba", (String)"SetEvaluatorDynamicPlugin_18", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("setup", ResManager.loadKDString((String)"\u624b\u52a8\u8bbe\u7f6e", (String)"SetEvaluatorDynamicPlugin_14", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("job.name", ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"SetEvaluatorDynamicPlugin_15", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        headDataList.add(new HRExportHeadObject("belongcom.name", ResManager.loadKDString((String)"\u6240\u5c5e\u516c\u53f8", (String)"SetEvaluatorDynamicPlugin_16", (String)"opmc-epa-formplugin", (Object[])new Object[0])));
        return headDataList;
    }

    private List<Map<String, Object>> getAcrossExportData() {
        Object nodexIndex;
        ArrayList<Map<String, Object>> exportDataList = new ArrayList<Map<String, Object>>(10);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        List formulatorRoleListData = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getAcrossEvaluatorListData(activityId, nodexIndex = this.getView().getFormShowParameter().getCustomParam("nodeindex"));
        if (ObjectUtils.isEmpty((Object)formulatorRoleListData)) {
            return exportDataList;
        }
        for (AcrossEvaluatorListDataBO dataBO : formulatorRoleListData) {
            HashMap<String, String> exportData = new HashMap<String, String>(16);
            exportData.put("perffilenumber", dataBO.getFileNo());
            exportData.put("name", dataBO.getName());
            exportData.put("number", dataBO.getPersonNumber());
            exportData.put("adminorg.name", dataBO.getAdminOrgName());
            exportData.put("indicatorname", dataBO.getIndName());
            exportData.put("process.name", dataBO.getFlowName());
            exportData.put("node.name", dataBO.getDefNodeName());
            exportData.put("handle.name", dataBO.getEvalName());
            exportData.put("setup", dataBO.getIsSetHandler());
            exportData.put("job.name", dataBO.getJob());
            exportData.put("belongcom.name", dataBO.getBelongCom());
            exportDataList.add(exportData);
        }
        return exportDataList;
    }
}

