/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.evaluator;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.orm.query.LikeHint;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.hr.hbp.business.service.query.ksql.IKsqlConfig;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.service.query.ksql.KsqlListDataProvider;
import kd.hr.hbp.business.servicehelper.EntityReleaseInfoService;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.utils.BosListUtil;
import kd.opmc.epa.formplugin.web.utils.ShowConfigTipsUtils;

public class SetEvaluatorRoleList
extends QueryListPlugin {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final String ACTIVITY = "epa_actevalobj.activity";
    private static final String DEFPROC = "epa_actevalobj.evalflow";
    private static final String INDEX = "pbs_flowrunode.index";
    private static final String NODESTATUS = "epa_actevalobj.nodestatus";
    private static final String ASSESSNODE = "epa_actevalobj.assessnode";
    private static final String NODEINDEX = "epa_actevalobj.nodeindex";
    private static final String CHECKBOXLISTCOLUMNAP = "checkboxlistcolumnap";
    private static final String HEADSCULPTURE = "epa_actevalobj.person.headsculpture";
    private static final String AFFILIATEADMINORG = "epa_actevalobj.affiliateadminorg.name";
    private static final String PERSON_NAME = "epa_actevalobj.perffile.name";
    private static final String PERSON_NUMBER = "epa_actevalobj.perffile.billno";
    private static final String FLOWDEFROLE = "flowdefrole.rolename";
    private Map<Long, String> evaluatorMap = new HashMap<Long, String>(16);

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object flowId = this.getView().getFormShowParameter().getCustomParam("flowDefId");
        Object seq = this.getView().getFormShowParameter().getCustomParam("seq");
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        int lastIndex = nodeIndex - 1;
        Long lastNodeId = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getNodeIdByActIdAndIndex(activityId, lastIndex);
        String lastNodeStatus = AssessNodeStatusEnum.getLastNodeStatus((Long)lastNodeId).getStatus();
        QFilter filter = new QFilter(ACTIVITY, "=", (Object)activityId).and(INDEX, "=", seq).and(DEFPROC, "=", (Object)Long.parseLong(flowId.toString())).and(NODESTATUS, "=", (Object)lastNodeStatus).and(ASSESSNODE, "=", (Object)lastNodeId).and(NODEINDEX, "=", (Object)lastIndex);
        evt.getQFilters().add(filter);
        evt.setOrderBy("epa_actevalobj.modifytime desc,issethandler asc,epa_actevalobj.personnumber desc");
    }

    private List<Long> getDefaultList() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Object flowId = this.getView().getFormShowParameter().getCustomParam("flowDefId");
        Object seq = this.getView().getFormShowParameter().getCustomParam("seq");
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        int lastIndex = nodeIndex - 1;
        Long lastNodeId = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getNodeIdByActIdAndIndex(activityId, lastIndex);
        String lastNodeStatus = AssessNodeStatusEnum.getLastNodeStatus((Long)lastNodeId).getStatus();
        return ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryByListDefaultFilter(activityId, seq, Long.valueOf(Long.parseLong(flowId.toString())), lastNodeStatus, lastNodeId, lastIndex);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        KsqlConfig ksqlConfig;
        DynamicObject entityReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName((String)"epa_evalobjrolequery");
        if (Objects.isNull(entityReleaseInfo)) {
            return;
        }
        String ksqlQueryType = entityReleaseInfo.getString("ksqlquerytype");
        boolean ksqlUseUnion = entityReleaseInfo.getBoolean("ksqluseunion");
        String queryType = "FULLSQL";
        if (HRStringUtils.equals((String)ksqlQueryType, (String)"IDQUERY")) {
            queryType = "PKSQL";
        }
        if ((ksqlConfig = this.setCustomKSqlConfig()) == null) {
            ksqlConfig = new KsqlConfig();
        }
        args.setListDataProvider((IListDataProvider)new KsqlListDataProvider(this.getView(), (IKsqlConfig)ksqlConfig, queryType, ksqlUseUnion, true){

            public List<QFilter> getQFilters() {
                List qFilterList = super.getQFilters();
                for (int i = 0; i < qFilterList.size(); ++i) {
                    String property;
                    QFilter qFilter = (QFilter)qFilterList.get(i);
                    if (qFilter == null || !"evalpersonshow".equals(property = qFilter.getProperty())) continue;
                    List roleList = SetEvaluatorRoleList.this.getDefaultList();
                    Map nameOrNumRoleSetMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryNameOrNumRoleSetMap(roleList);
                    qFilterList.remove(i);
                    --i;
                    QFilter roleFilter = this.getPersonToRoleFilter(qFilter, nameOrNumRoleSetMap);
                    if (roleFilter == null) continue;
                    qFilterList.add(roleFilter);
                }
                return qFilterList;
            }

            private QFilter getPersonToRoleFilter(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                String cp = qFilter.getCP();
                cp = cp.toLowerCase();
                QFilter roleQFilter = null;
                switch (cp) {
                    case "like": {
                        roleQFilter = this.like(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "not like": {
                        roleQFilter = this.notLike(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "=": {
                        roleQFilter = this.equalsValue(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "!=": {
                        roleQFilter = this.notEqualsValue(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "in": {
                        roleQFilter = this.inValues(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "not in": {
                        roleQFilter = this.notInValues(qFilter, nameOrNumberRoleMap);
                        break;
                    }
                    case "is not null": {
                        roleQFilter = this.notNullValue(nameOrNumberRoleMap);
                        break;
                    }
                }
                return roleQFilter;
            }

            private QFilter like(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                QFilterHint qFilterHint = qFilter.getQFilterHint();
                HashSet queryRoleIds = new HashSet(16);
                if (qFilterHint instanceof LikeHint) {
                    boolean hasLeftPercent = ((LikeHint)qFilterHint).isAppendLeftPercent();
                    boolean hasRightPercent = ((LikeHint)qFilterHint).isAppendRightPercent();
                    Object value = qFilter.getOriginValue();
                    if (value instanceof String) {
                        nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                            if (hasLeftPercent && hasRightPercent) {
                                if (nameOrNum != null && nameOrNum.contains((String)value)) {
                                    queryRoleIds.addAll(roleIds);
                                }
                            } else if (hasLeftPercent && !hasRightPercent) {
                                if (nameOrNum != null && nameOrNum.endsWith((String)value)) {
                                    queryRoleIds.addAll(roleIds);
                                }
                            } else if (!hasLeftPercent && hasRightPercent && nameOrNum != null && nameOrNum.startsWith((String)value)) {
                                queryRoleIds.addAll(roleIds);
                            }
                        });
                    }
                }
                return new QFilter("id", "in", queryRoleIds);
            }

            private QFilter notLike(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof String) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && nameOrNum.contains((String)value)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                }
                if (queryRoleIds.size() == 0) {
                    return null;
                }
                return new QFilter("id", "not in", queryRoleIds);
            }

            private QFilter equalsValue(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof String) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && nameOrNum.equals(value)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                } else if (value instanceof QEmptyValue) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && HRStringUtils.isEmpty((String)nameOrNum)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                }
                return new QFilter("id", "in", queryRoleIds);
            }

            private QFilter notEqualsValue(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof String) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && nameOrNum.equals(value)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                }
                if (queryRoleIds.size() == 0) {
                    return null;
                }
                return new QFilter("id", "not in", queryRoleIds);
            }

            private QFilter notNullValue(Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                    if (nameOrNum != null && HRStringUtils.isNotEmpty((String)nameOrNum)) {
                        queryRoleIds.addAll(roleIds);
                    }
                });
                return new QFilter("id", "in", queryRoleIds);
            }

            private QFilter inValues(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof List) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && ((List)value).contains(nameOrNum)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                }
                return new QFilter("id", "in", queryRoleIds);
            }

            private QFilter notInValues(QFilter qFilter, Map<String, Set<Long>> nameOrNumberRoleMap) {
                HashSet queryRoleIds = new HashSet(16);
                Object value = qFilter.getOriginValue();
                if (value instanceof List) {
                    nameOrNumberRoleMap.forEach((nameOrNum, roleIds) -> {
                        if (nameOrNum != null && ((List)value).contains(nameOrNum)) {
                            queryRoleIds.addAll(roleIds);
                        }
                    });
                }
                if (queryRoleIds.size() == 0) {
                    return null;
                }
                return new QFilter("id", "not in", queryRoleIds);
            }
        });
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        super.beforePackageData(evt);
        DynamicObjectCollection pageData = evt.getPageData();
        if (!pageData.isEmpty()) {
            List roleIds = pageData.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            this.evaluatorMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvaluator(roleIds);
        }
    }

    public void packageData(PackageDataEvent evt) {
        ColumnDesc columnDesc;
        super.packageData(evt);
        Object source = evt.getSource();
        if (source instanceof ColumnDesc && "evalpersonshow".equals((columnDesc = (ColumnDesc)source).getKey())) {
            DynamicObject rowData = evt.getRowData();
            String evalPersonShow = this.evaluatorMap.get(rowData.getLong("id"));
            evt.setFormatValue((Object)evalPersonShow);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        for (IListColumn listColumn : columns) {
            DynamicObject dy = this.getModel().getDataEntity();
            if (!StringUtils.equals((CharSequence)"issethandler", (CharSequence)listColumn.getListFieldKey()) || !(listColumn instanceof ListColumn)) continue;
            ShowConfigTipsUtils.showListColumnTips((ListColumn)listColumn, CHECKBOXLISTCOLUMNAP, "epa_evalobjrolequery", dy);
        }
        List<String> fixedColumnList = Arrays.asList("fseq", HEADSCULPTURE, PERSON_NAME, PERSON_NUMBER, AFFILIATEADMINORG, FLOWDEFROLE);
        fixedColumnList.forEach(column -> args.getListColumn(column).setFixed(true));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BosListUtil.setListBgColor(this.getView(), "#ffffff");
        BosListUtil.setGripMargin(this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean dataChange;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        boolean nullView = this.getView().getParentView().getParentView() == null;
        boolean bl = dataChange = this.getView().getParentView().getParentView() != null && StringUtils.isNotBlank((CharSequence)this.getView().getParentView().getParentView().getPageCache().get("datachange"));
        if (nullView || dataChange) {
            args.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"SetEvaluatorRoleList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return;
        }
        if ("seteval".equals(key)) {
            String evals = this.getView().getPageCache().get("evaluaties");
            if (StringUtils.isBlank((CharSequence)evals)) {
                args.setCancel(true);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_setevaluator");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCustomParam("count", (Object)this.getSelectedRows().size());
                showParameter.setCustomParam("evaluaties", (Object)this.getSelectedRows().getPrimaryKeyValues());
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_setevaluator"));
                this.getView().showForm(showParameter);
            } else {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("batchop_batchsize", "0");
                operateOption.setVariableValue("evaluaties", evals);
                op.setOption(operateOption);
                this.getView().getPageCache().remove("evaluaties");
            }
        } else if ("refresh".equals(key)) {
            FormOperate source = (FormOperate)args.getSource();
            String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
            if (HRStringUtils.equals((String)systemInvoke, (String)"true")) {
                return;
            }
            args.setCancel(true);
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("seteval".equals(operateKey)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("systeminvoke", "true");
            this.getView().invokeOperation("refresh", operateOption);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData != null && "epa_setevaluator".equals(actionId)) {
            String json = JSON.toJSONString((Object)returnData);
            this.getView().getPageCache().put("evaluaties", json);
            this.getView().invokeOperation("seteval");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (FLOWDEFROLE.equals(fieldName)) {
            Object nodeId = this.getView().getFormShowParameter().getCustomParam("flownode");
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("defnode", "=", nodeId));
        }
    }
}

