/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.importindsoi;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.opmc.epa.business.application.service.activitymanage.IndicatorScoreImportApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.common.constants.IndScoreImportConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.IndImportErrorTypeEnum;
import kd.opmc.epa.common.enums.assessrule.EvalWayEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.common.enums.evaluat.ResSyncStatusEnum;

public class IndicatorScoreValidator
extends AbstractValidateHandler
implements IndScoreImportConstants {
    private static final IndicatorScoreImportApplicationService APP_SERVICE = IndicatorScoreImportApplicationService.getInstance();
    private static final ActEvalObjManageDomainService EVAL_OBJ_DOMAIN = ActEvalObjManageDomainService.getInstance();
    private static final Log LOGGER = LogFactory.getLog(IndicatorScoreValidator.class);
    public static final String MAX_SCORE = "scoresystem.maxscore";
    public static final String MIN_SCORE = "scoresystem.minscore";
    private final Long activityId;
    private final Map<String, DynamicObject> indicatorMap;

    public IndicatorScoreValidator(Long activityId, Map<String, DynamicObject> indicatorMap) {
        this.activityId = activityId;
        this.indicatorMap = indicatorMap;
    }

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    public void validate(List<ImportBillData> list, ImportLog importLog) {
        Map errorLogMap;
        if (ObjectUtils.isEmpty(list)) {
            return;
        }
        ArrayList<IndImportErrorTypeEnum> busValidates = new ArrayList<IndImportErrorTypeEnum>(10);
        this.validateActivity(list, importLog, busValidates);
        this.validatePerfFile(list, importLog, busValidates);
        this.validateAreaName(list, importLog, busValidates);
        this.validateIndicatorName(list, importLog, busValidates);
        this.validateObjAssessStatus(list, importLog, busValidates);
        try {
            this.validateIndicatorIecs(list, importLog);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        if (list.size() > 0 && importLog.getRowErrors().size() > 0 && (errorLogMap = (Map)importLog.getRowErrors().get(list.get(0).getSheetName())) != null && errorLogMap.size() > 0) {
            Set errorLine = errorLogMap.keySet();
            for (ImportBillData data : list) {
                if (errorLine.contains(data.getStartIndex())) continue;
                importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u6b63\u786e", (String)"IndicatorScoreValidator_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateObjAssessStatus(List<ImportBillData> list, ImportLog importLog, List<IndImportErrorTypeEnum> busValidates) {
        if (busValidates.size() == 0) {
            Tuple booleanBooleanTuple = EVAL_OBJ_DOMAIN.queryIsLastNodeNActEnd(this.activityId, AssessNodeStatusEnum.EVALUATED);
            Long lastNode = APP_SERVICE.queryLastActNode(this.activityId, AssessNodeStatusEnum.EVALUATING.getNodeId());
            AssessNodeStatusEnum lastNodeStatus = AssessNodeStatusEnum.getLastNodeStatus((Long)lastNode);
            for (ImportBillData data : list) {
                JSONObject adminOrgJson;
                JSONObject personJson;
                String indicatorKey = this.getIndicatorKey(data);
                DynamicObject indicatorDy = this.indicatorMap.get(indicatorKey);
                if (indicatorDy == null) continue;
                long nodeId = indicatorDy.getLong("actevalobj.assessnode.id");
                String nodeStatus = indicatorDy.getString("actevalobj.nodestatus");
                String assessStatus = indicatorDy.getString("actevalobj.assessstaus");
                boolean isLastNodeAndCompleted = (Boolean)booleanBooleanTuple.item1 != false && assessStatus.equals(AssessStausEnum.COMPLETED.getStatus());
                AssessNodeStatusEnum nodeStatusEnum = AssessNodeStatusEnum.getEnumByIdAndStatus((Long)nodeId, (String)nodeStatus);
                if (nodeStatusEnum != lastNodeStatus && nodeStatusEnum != AssessNodeStatusEnum.EVALUATING && nodeStatusEnum != AssessNodeStatusEnum.EVALUATED && !isLastNodeAndCompleted) {
                    this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u7ee9\u6548\u8bc4\u4f30\u73af\u8282", (String)"IndicatorScoreValidator_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                String resSyncStatus = indicatorDy.getString("actevalobj.ressyncstatus");
                if (ResSyncStatusEnum.ARCHIVED.getCode().equals(resSyncStatus)) {
                    this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u5df2\u5f52\u6863", (String)"IndicatorScoreValidator_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                if ((personJson = data.getData().getJSONObject("epa_objimportscoreind").getJSONObject("person")) != null) {
                    if (!HRStringUtils.equals((String)indicatorDy.getString("person.number"), (String)personJson.getString("number"))) {
                        this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u7b2cE\u5217\u5de5\u53f7\u4e0e\u7ee9\u6548\u6863\u6848\u4e0d\u7b26", (String)"IndicatorScoreValidator_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    }
                    if (!HRStringUtils.equals((String)indicatorDy.getString("person.name"), (String)personJson.getString("name"))) {
                        this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u7b2cF\u5217\u59d3\u540d\u4e0e\u7ee9\u6548\u6863\u6848\u4e0d\u7b26", (String)"IndicatorScoreValidator_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    }
                }
                if ((adminOrgJson = data.getData().getJSONObject("epa_objimportscoreind").getJSONObject("affiliateadminorg")) == null || HRStringUtils.equals((String)indicatorDy.getString("affiliateadminorg.name"), (String)adminOrgJson.getString("name"))) continue;
                this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u7b2cG\u5217\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u884c\u653f\u7ec4\u7ec7\u540d\u79f0\u4e0e\u7ee9\u6548\u6863\u6848\u4e0d\u7b26", (String)"IndicatorScoreValidator_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void validateIndicatorIecs(List<ImportBillData> list, ImportLog importLog) {
        DynamicObject formDy = APP_SERVICE.queryFormByActivity(this.activityId);
        EvalWayEnum evalWay = EvalWayEnum.getEvalWay((String)formDy.getString("evalway"));
        if (evalWay != EvalWayEnum.SCORE) {
            for (ImportBillData data : list) {
                this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u6307\u6807\u8bc4\u4f30\u65b9\u5f0f\u4e0d\u4e3a\u8bc4\u5206\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u6307\u6807\u5f97\u5206", (String)"IndicatorScoreValidator_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        Map<Long, DynamicObject> confDyMap = this.queryAreaConf();
        int numAccuracy = formDy.getInt("numaccuracy");
        for (ImportBillData data : list) {
            BigDecimal iecs;
            String iecsStr = data.getData().getJSONObject("epa_objimportscoreind").getString("iecs");
            try {
                iecs = new BigDecimal(iecsStr);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            int scale = iecs.scale();
            if (numAccuracy >= scale) continue;
            this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u7b2cJ\u5217\u6307\u6807\u5f97\u5206\u5c0f\u6570\u4f4d\u4e0d\u6ee1\u8db3\u8bc4\u4f30\u8868\u7684\u8981\u6c42{0}\u4f4d", (String)"IndicatorScoreValidator_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{numAccuracy}));
        }
        ScoreCalcWayEnum scoreCalcWay = ScoreCalcWayEnum.getScoreCalcWay((String)formDy.getString("scorecalcway"));
        if (scoreCalcWay == ScoreCalcWayEnum.SUM) {
            this.validateScoreLimitOfSum(list, importLog, confDyMap, numAccuracy);
        } else if (scoreCalcWay == ScoreCalcWayEnum.WEIGHT) {
            this.validateScoreLimitOfWeight(list, importLog, formDy, confDyMap, numAccuracy);
        }
    }

    private void validateScoreLimitOfWeight(List<ImportBillData> list, ImportLog importLog, DynamicObject formDy, Map<Long, DynamicObject> confDyMap, int numAccuracy) {
        boolean isSameScoreSystem = "1".equals(formDy.getString("consistentwitharea"));
        for (ImportBillData data : list) {
            BigDecimal iecs;
            BigDecimal minScore;
            BigDecimal maxScore;
            String indicatorKey = this.getIndicatorKey(data);
            DynamicObject indicatorDy = this.indicatorMap.get(indicatorKey);
            if (indicatorDy == null) continue;
            DynamicObject confDy = this.getConfDy(confDyMap, indicatorDy);
            if (isSameScoreSystem) {
                maxScore = formDy.getBigDecimal(MAX_SCORE);
                minScore = formDy.getBigDecimal(MIN_SCORE);
            } else {
                maxScore = confDy.getBigDecimal(MAX_SCORE);
                minScore = confDy.getBigDecimal(MIN_SCORE);
            }
            if (confDy.getBoolean("reversepoints")) {
                minScore = maxScore.add(indicatorDy.getBigDecimal("indicator.minevalscore"));
                maxScore = maxScore.add(indicatorDy.getBigDecimal("indicator.maxevalscore"));
            }
            String iecsStr = data.getData().getJSONObject("epa_objimportscoreind").getString("iecs");
            try {
                iecs = new BigDecimal(iecsStr);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            if (iecs.compareTo(maxScore) <= 0 && iecs.compareTo(minScore) >= 0) continue;
            this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u7b2cJ\u5217\u6307\u6807\u5f97\u5206\u6307\u6807\u5f97\u5206\u8d85\u51fa\u8bc4\u5206\u4e0a\u4e0b\u9650[{0}\uff0c{1}]", (String)"IndicatorScoreValidator_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore.setScale(numAccuracy, RoundingMode.DOWN), maxScore.setScale(numAccuracy, RoundingMode.DOWN)}));
        }
    }

    private void validateScoreLimitOfSum(List<ImportBillData> list, ImportLog importLog, Map<Long, DynamicObject> confDyMap, int numAccuracy) {
        for (ImportBillData data : list) {
            BigDecimal iecs;
            String indicatorKey = this.getIndicatorKey(data);
            DynamicObject indicatorDy = this.indicatorMap.get(indicatorKey);
            if (indicatorDy == null) continue;
            DynamicObject confDy = this.getConfDy(confDyMap, indicatorDy);
            BigDecimal maxScore = indicatorDy.getBigDecimal("indicator.indctrscore");
            BigDecimal minScore = indicatorDy.getBigDecimal("indicator.indctrscore");
            if (confDy.getBoolean("reversepoints")) {
                maxScore = maxScore.add(indicatorDy.getBigDecimal("indicator.maxevalscore"));
                minScore = minScore.add(indicatorDy.getBigDecimal("indicator.minevalscore"));
            } else {
                minScore = new BigDecimal(0);
            }
            String iecsStr = data.getData().getJSONObject("epa_objimportscoreind").getString("iecs");
            try {
                iecs = new BigDecimal(iecsStr);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            if (iecs.compareTo(maxScore) <= 0 && iecs.compareTo(minScore) >= 0) continue;
            this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u7b2cJ\u5217\u6307\u6807\u5f97\u5206\u6307\u6807\u5f97\u5206\u8d85\u51fa\u8bc4\u5206\u4e0a\u4e0b\u9650[{0}\uff0c{1}]", (String)"IndicatorScoreValidator_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{minScore.setScale(numAccuracy, RoundingMode.DOWN), maxScore.setScale(numAccuracy, RoundingMode.DOWN)}));
        }
    }

    private Map<Long, DynamicObject> queryAreaConf() {
        Set areaConfIdSet = this.indicatorMap.values().stream().map(dy -> dy.getLong("area.areaconf.id")).collect(Collectors.toSet());
        DynamicObject[] confDys = APP_SERVICE.queryNormalConfById(areaConfIdSet);
        return Arrays.stream(confDys).collect(Collectors.toMap(confDy -> confDy.getLong("id"), Function.identity()));
    }

    private DynamicObject getConfDy(Map<Long, DynamicObject> confDyMap, DynamicObject indicatorDy) {
        long confId = indicatorDy.getLong("area.areaconf.id");
        return confDyMap.get(confId);
    }

    private String getIndicatorKey(ImportBillData data) {
        return data.getData().getJSONObject("epa_objimportscoreind").getString("perffilenumber") + data.getData().getJSONObject("epa_objimportscoreind").getString("areaname") + data.getData().getJSONObject("epa_objimportscoreind").getString("indicatorname");
    }

    private void validateIndicatorName(List<ImportBillData> list, ImportLog importLog, List<IndImportErrorTypeEnum> busValidates) {
        IndImportErrorTypeEnum[] type = new IndImportErrorTypeEnum[1];
        if (busValidates.size() == 0) {
            HashMap<String, DynamicObject> copyIndicatorMap = new HashMap<String, DynamicObject>(this.indicatorMap);
            Map<String, List<DynamicObject>> dbIndGroupMap = copyIndicatorMap.values().stream().collect(Collectors.groupingBy(dy -> dy.getString("perffilenumber") + dy.getString("areaname")));
            Map<String, List<ImportBillData>> dataGroupMap = list.stream().filter(data -> HRStringUtils.isNotEmpty((String)data.getData().getJSONObject("epa_objimportscoreind").getString("areaname"))).collect(Collectors.groupingBy(data -> data.getData().getJSONObject("epa_objimportscoreind").getString("perffilenumber") + data.getData().getJSONObject("epa_objimportscoreind").getString("areaname")));
            Map<String, List<DynamicObject>> dbIndGroupByObjMap = copyIndicatorMap.values().stream().collect(Collectors.groupingBy(dy -> dy.getString("perffilenumber")));
            Map<String, List<ImportBillData>> dataGroupByObjMap = list.stream().collect(Collectors.groupingBy(data -> data.getData().getJSONObject("epa_objimportscoreind").getString("perffilenumber")));
            dataGroupMap.forEach((key, dataList) -> {
                Map<String, List<ImportBillData>> dataGroupByName = dataList.stream().filter(data -> HRStringUtils.isNotEmpty((String)data.getData().getJSONObject("epa_objimportscoreind").getString("indicatorname"))).collect(Collectors.groupingBy(data -> data.getData().getJSONObject("epa_objimportscoreind").getString("indicatorname")));
                dataGroupByName.forEach((indName, dataListGroup) -> {
                    if (HRStringUtils.isNotEmpty((String)indName) && dataListGroup.size() > 1) {
                        for (ImportBillData data : dataListGroup) {
                            this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u7b2cI\u5217\u533a\u57df\u6307\u6807\u91cd\u590d\u5b58\u5728", (String)"IndicatorScoreValidator_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        }
                        type[0] = IndImportErrorTypeEnum.INDICATOR_ERROR;
                    }
                });
                List dbIndicators = (List)dbIndGroupMap.get(key);
                if (dbIndicators != null && dbIndicators.size() > 0) {
                    for (ImportBillData data2 : dataList) {
                        String indName2 = data2.getData().getJSONObject("epa_objimportscoreind").getString("indicatorname");
                        DynamicObject dbInd = this.indicatorMap.get(key + indName2);
                        if (!HRStringUtils.isNotEmpty((String)indName2) || dbInd != null) continue;
                        this.writeRowlog(importLog, data2, ResManager.loadKDString((String)"\u7b2cI\u5217\u533a\u57df\u6307\u6807\u4e0d\u5b58\u5728\u6216\u65e0\u9700\u5f15\u5165", (String)"IndicatorScoreValidator_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        type[0] = IndImportErrorTypeEnum.INDICATOR_ERROR;
                    }
                }
            });
            if (type[0] == null) {
                dataGroupByObjMap.forEach((key, dataList) -> {
                    List dbIndicators = (List)dbIndGroupByObjMap.get(key);
                    if (dbIndicators != null && dbIndicators.size() > dataList.size()) {
                        for (ImportBillData data : dataList) {
                            String indName = data.getData().getJSONObject("epa_objimportscoreind").getString("indicatorname");
                            DynamicObject dbInd = this.indicatorMap.get(key + indName);
                            if (!HRStringUtils.isNotEmpty((String)indName) || dbInd != null) continue;
                            this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u7b2cI\u5217\u8bc4\u4f30\u5bf9\u8c61\u5e94\u5f15\u5165\u7684\u6307\u6807\u7f3a\u4e86", (String)"IndicatorScoreValidator_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        }
                        type[0] = IndImportErrorTypeEnum.INDICATOR_ERROR;
                    }
                });
            }
        }
        if (type[0] != null) {
            busValidates.add(type[0]);
        }
    }

    private void validateAreaName(List<ImportBillData> list, ImportLog importLog, List<IndImportErrorTypeEnum> busValidates) {
        Set areaNameSet = this.indicatorMap.values().stream().map(dy -> dy.getString("perffilenumber") + dy.getString("areaname")).collect(Collectors.toSet());
        Set fileNumberSet = this.indicatorMap.values().stream().map(dy -> dy.getString("perffilenumber")).collect(Collectors.toSet());
        IndImportErrorTypeEnum type = null;
        for (ImportBillData data : list) {
            JSONObject activity = data.getData().getJSONObject("epa_objimportscoreind").getJSONObject("activity");
            if (activity == null) continue;
            Long importActivityId = activity.getLong("id");
            String fileNumber = data.getData().getJSONObject("epa_objimportscoreind").getString("perffilenumber");
            String areaName = data.getData().getJSONObject("epa_objimportscoreind").getString("areaname");
            if (!ObjectUtils.nullSafeEquals((Object)this.activityId, (Object)importActivityId) || !fileNumberSet.contains(fileNumber) || areaNameSet.contains(fileNumber + areaName) || !HRStringUtils.isNotEmpty((String)areaName)) continue;
            this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u7b2cH\u5217\u8bc4\u4f30\u8868\u4e0d\u5b58\u5728\u8be5\u533a\u57df", (String)"IndicatorScoreValidator_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            type = IndImportErrorTypeEnum.AREA_ERROR;
        }
        if (type != null) {
            busValidates.add(type);
        }
    }

    private void validatePerfFile(List<ImportBillData> list, ImportLog importLog, List<IndImportErrorTypeEnum> busValidates) {
        Set perfFileNumbers = this.indicatorMap.values().stream().map(dy -> dy.getString("perffilenumber")).collect(Collectors.toSet());
        IndImportErrorTypeEnum type = null;
        for (ImportBillData data : list) {
            JSONObject activity = data.getData().getJSONObject("epa_objimportscoreind").getJSONObject("activity");
            if (activity == null) continue;
            Long importActivityId = activity.getLong("id");
            String importFileNumber = data.getData().getJSONObject("epa_objimportscoreind").getString("perffilenumber");
            if (!ObjectUtils.nullSafeEquals((Object)this.activityId, (Object)importActivityId) || perfFileNumbers.contains(importFileNumber)) continue;
            this.writeRowlog(importLog, data, ResManager.loadKDString((String)"\u7b2cD\u5217\u7684\u6863\u6848\u7f16\u7801\u4e0d\u5728\u6240\u52fe\u9009\u7684\u6570\u636e\u8303\u56f4\u5185\u6216\u5df2\u4e0d\u5728\u5f53\u524d\u5217\u8868", (String)"IndicatorScoreValidator_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            type = IndImportErrorTypeEnum.PREF_FILE_ERROR;
        }
        if (type != null) {
            busValidates.add(type);
        }
    }

    private void writeRowlog(ImportLog importLog, ImportBillData data, String msg) {
        JSONObject activity = data.getData().getJSONObject("epa_objimportscoreind").getJSONObject("activity");
        if (activity == null || !ObjectUtils.nullSafeEquals((Object)this.activityId, (Object)activity.getLong("id"))) {
            return;
        }
        importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), msg);
    }

    private void validateActivity(List<ImportBillData> list, ImportLog importLog, List<IndImportErrorTypeEnum> busValidates) {
        boolean isMultiAct = list.stream().anyMatch(data -> {
            JSONObject activity = data.getData().getJSONObject("epa_objimportscoreind").getJSONObject("activity");
            if (activity != null) {
                return !ObjectUtils.nullSafeEquals((Object)data.getData().getJSONObject("epa_objimportscoreind").getJSONObject("activity").getLong("id"), (Object)this.activityId);
            }
            return false;
        });
        if (isMultiAct) {
            busValidates.add(IndImportErrorTypeEnum.ACTIVITY_ERROR);
            for (ImportBillData data2 : list) {
                Long importActivityId;
                JSONObject activity = data2.getData().getJSONObject("epa_objimportscoreind").getJSONObject("activity");
                if (activity == null || (importActivityId = activity.getLong("id")) == null || ObjectUtils.nullSafeEquals((Object)this.activityId, (Object)importActivityId)) continue;
                importLog.writeRowLog(data2.getSheetName(), data2.getStartIndex(), data2.getEndIndex(), ResManager.loadKDString((String)"\u7b2cB\u5217\u7684\u8003\u6838\u6d3b\u52a8\u4e0d\u5c5e\u4e8e\u5f53\u524d\u6d3b\u52a8", (String)"IndicatorScoreValidator_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

