/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FieldgroupPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.userconfig.GridConfigDAO;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.business.domain.outservice.IEvalPageRenderService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.pbs.common.enums.FieldTypeEnum;

public class EvaluteDrawEntryEntityUtils {
    private static final String ALL_LOCK_STR = "new,edit,view,submit,audit";
    private static final String NORMAL_LOCK_STR = "view,submit,audit";
    private static final String SOE = "soe";
    private static final String AREA_ID = "areatitle";
    private static final String IS_ALLOW_EVAL = "isalloweval";
    private static final Log LOGGER = LogFactory.getLog(EvaluteDrawEntryEntityUtils.class);
    public static final Map<String, String> ASSESS_FORM_FILED_MAP = new HashMap<String, String>(16);
    private static final IEvalPageRenderService I_EVAL_PAGE_RENDER_SERVICE = IEvalPageRenderService.getInstance();
    public static final String[] GEN_NOT_FIRE_UP_FIELDS;
    public static final String[] ADDSUB_NOT_FIRE_UP_FIELDS;
    public static final String[] ATTACH_NOT_FIRE_UP_FIELDS;

    public static void customDrawArea(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField, Long areaReg, List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        String formId = AreaRegEnum.get((Long)areaReg).getEvalObjAreaPageIdOfEval();
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        gridConfigDAO.deleteGridConfig(formId, "entryentity");
        EntryAp entryAp = EvaluteDrawEntryEntityUtils.createEntryAp(args, conf, ignoreField, areaReg, fieldEntryEvaDtos);
        entryAp.setOrderAndFilter(1);
        EvaluteDrawEntryEntityUtils.afterCreateEntryAp(args, entryAp, areaReg, conf);
        EvaluteDrawEntryEntityUtils.afterCreateEntryByOutService(args, entryAp, areaReg, conf);
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        mapEntry.put("selchexkbox", (String)entryAp.createControl().get("selchexkbox"));
        args.getItems().add(mapEntry);
    }

    private static Boolean afterCreateEntryByOutService(LoadCustomControlMetasArgs args, EntryAp entryAp, Long areaReg, DynamicObject conf) {
        HRPluginProxy proxy = new HRPluginProxy((Object)I_EVAL_PAGE_RENDER_SERVICE, IEvalPageRenderService.class, "kd.opmc.epa.business.domain.outservice.IEvalPageRenderService#afterCreateEntryAp", (PluginFilter)null);
        List results = proxy.callReplaceIfPresent(p -> p.afterCreateEntryAp(args, entryAp, areaReg, conf));
        return CollectionUtils.isEmpty((Collection)results) ? Boolean.FALSE : (Boolean)results.get(0);
    }

    public static void afterCreateEntryAp(LoadCustomControlMetasArgs args, EntryAp entryAp, Long areaReg, DynamicObject conf) {
        if (areaReg != null && areaReg.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK) && ObjEvaluationUtils.isOpenAdjustScore(conf)) {
            ArrayList<EntryFieldAp> addItems = new ArrayList<EntryFieldAp>(10);
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setId("beforeadjust");
            entryFieldAp.setKey("beforeadjust");
            entryFieldAp.isFireUpdEvt();
            entryFieldAp.setNoDisplayScaleZero(false);
            String msgTips = ResManager.loadKDString((String)"\u8c03\u6574\u524d\u5206\u503c", (String)"EvaluteDrawEntryEntityUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            entryFieldAp.setName(new LocaleString(msgTips));
            entryFieldAp.setLock(ALL_LOCK_STR);
            FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
            int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
            DecimalField decimalField = new DecimalField();
            decimalField.setPrecision(numAccuracy + 13);
            decimalField.setScale(numAccuracy);
            decimalField.setZeroShow(true);
            decimalField.setId("beforeadjust");
            decimalField.setKey("beforeadjust");
            decimalField.setName(new LocaleString(msgTips));
            entryFieldAp.setField((Field)decimalField);
            entryFieldAp.setWidth(new LocaleString("100px"));
            addItems.add(entryFieldAp);
            String adjustTips = ResManager.loadKDString((String)"\u53ef\u8c03\u6574\u5206\u503c", (String)"EvaluteDrawEntryEntityUtils_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            EntryFieldAp entryFieldAp1 = new EntryFieldAp();
            entryFieldAp1.setId("adjustval");
            entryFieldAp1.setKey("adjustval");
            entryFieldAp1.isFireUpdEvt();
            entryFieldAp1.setNoDisplayScaleZero(false);
            entryFieldAp1.setName(new LocaleString(adjustTips));
            entryFieldAp1.setLock(NORMAL_LOCK_STR);
            DecimalField decimalField1 = new DecimalField();
            decimalField1.setPrecision(numAccuracy + 13);
            decimalField1.setScale(numAccuracy);
            decimalField1.setZeroShow(true);
            decimalField1.setId("adjustval");
            decimalField1.setKey("adjustval");
            decimalField1.setName(new LocaleString(adjustTips));
            decimalField1.setMustInput(true);
            decimalField1.setEnableNull(true);
            BigDecimal defValue = decimalField1.getDefValue();
            LOGGER.info("adjustval defaValue:{}", (Object)defValue);
            decimalField1.setDefValue(null);
            entryFieldAp1.setField((Field)decimalField1);
            entryFieldAp1.setWidth(new LocaleString("100px"));
            addItems.add(entryFieldAp1);
            String afterTips = ResManager.loadKDString((String)"\u8c03\u6574\u540e\u5206\u503c", (String)"EvaluteDrawEntryEntityUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            String adjustDetailMsg = ResManager.loadKDString((String)"\u8c03\u6574\u8bf4\u660e", (String)"EvaluteDrawEntryEntityUtils_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            String scoreColName = ResManager.loadKDString((String)"\u57fa\u7840\u5206\u503c", (String)"EvaluteDrawEntryEntityUtils_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            int soeIndex = -1;
            List items = entryAp.getItems();
            if (items != null) {
                for (int i = 0; i < items.size(); ++i) {
                    ControlAp item = (ControlAp)items.get(i);
                    if (item == null) continue;
                    String id = item.getId();
                    if (SOE.equals(id)) {
                        soeIndex = i;
                        item.setName(new LocaleString(afterTips));
                        item.setLock(ALL_LOCK_STR);
                        EntryFieldAp item1 = (EntryFieldAp)item;
                        Field field = item1.getField();
                        if (field != null) {
                            field.setMustInput(false);
                        }
                        item1.setCtlTips(null);
                    }
                    if ("evaldesc".equals(id)) {
                        item.setName(new LocaleString(adjustDetailMsg));
                    }
                    if (!"indctrscore".equals(id)) continue;
                    item.setName(new LocaleString(scoreColName));
                }
                if (soeIndex != -1) {
                    items.addAll(soeIndex, addItems);
                }
            }
        }
    }

    private static EntryAp createEntryAp(LoadCustomControlMetasArgs args, DynamicObject conf, String[] ignoreField, Long areaReg, List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        EvaluteDrawEntryEntityUtils.setAreaNameByConfDynObj(args, conf);
        Set<String> notLoadFiled = Arrays.stream(ignoreField).collect(Collectors.toSet());
        EvaluteDrawEntryEntityUtils.removeCustomeField(notLoadFiled);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        entryAp.setShowSeq(false);
        entryAp.setShowSelChexkbox(false);
        entryAp.setMulti(false);
        entryAp.setAutoRowHeight(true);
        Map<Long, ContentFieldEntryEvaDto> filePermMap = EvaluteDrawEntryEntityUtils.change2PermMap(fieldEntryEvaDtos);
        for (DynamicObject fieldInfo : entryEntity) {
            Boolean fieldModifyItem;
            Boolean displayItem;
            long areaFieldId;
            ContentFieldEntryEvaDto permFileDto;
            if (fieldInfo == null) continue;
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            String fieldKey = fieldInfo.getString("areafield.number");
            if (fieldKey == null || notLoadFiled.contains(fieldKey) || (permFileDto = filePermMap.get(areaFieldId = fieldInfo.getLong("areafield.id"))) == null) continue;
            if (fieldKey.startsWith("customfiled") || fieldKey.equals("customfield")) {
                if (AssessRuleConstants.ATTACH_AREA_PK.equals(areaReg)) {
                    Boolean bl = displayItem = permFileDto.getFieldDisplayItem() == null ? Boolean.FALSE : permFileDto.getFieldDisplayItem();
                    if (!displayItem.booleanValue()) {
                        continue;
                    }
                } else {
                    Boolean bl = fieldModifyItem = permFileDto.getFieldModifyItem() == null ? Boolean.FALSE : permFileDto.getFieldModifyItem();
                    if (!fieldModifyItem.booleanValue()) {
                        continue;
                    }
                }
            } else {
                displayItem = permFileDto.getFieldDisplayItem() == null ? Boolean.FALSE : permFileDto.getFieldDisplayItem();
                if (!displayItem.booleanValue()) continue;
            }
            if (ASSESS_FORM_FILED_MAP.containsKey(fieldKey)) {
                fieldKey = ASSESS_FORM_FILED_MAP.get(fieldKey);
                if (areaReg.equals(AssessRuleConstants.NORM_INDCTR_AREA_PK) && fieldKey.equals(SOE) && !conf.getBoolean(IS_ALLOW_EVAL)) continue;
            }
            Boolean bl = fieldModifyItem = permFileDto.getFieldModifyItem() == null ? Boolean.FALSE : permFileDto.getFieldModifyItem();
            if (fieldModifyItem.booleanValue()) {
                entryFieldAp.setLock(NORMAL_LOCK_STR);
            } else {
                entryFieldAp.setLock(ALL_LOCK_STR);
            }
            entryFieldAp.setId(fieldKey);
            entryFieldAp.setKey(fieldKey);
            if (HRStringUtils.equals((String)fieldKey, (String)"indctrname") || HRStringUtils.equals((String)fieldKey, (String)"keyactname")) {
                entryFieldAp.setHyperlink(false);
            }
            if (SOE.equals(fieldKey)) {
                entryFieldAp.setNoDisplayScaleZero(false);
            } else {
                entryFieldAp.setNoDisplayScaleZero(true);
            }
            entryFieldAp.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            boolean mustInput = false;
            Boolean fieldMustInputItem = permFileDto.getFieldMustInputItem() == null ? Boolean.FALSE : permFileDto.getFieldMustInputItem();
            mustInput = fieldMustInputItem;
            entryFieldAp.setField(EvaluteDrawEntryEntityUtils.assembleField(fieldInfo, (FormShowParameter)args.getSource(), mustInput));
            EvaluteDrawEntryEntityUtils.setFieldWidth(entryFieldAp, fieldInfo, areaReg);
            entryAp.getItems().add(entryFieldAp);
        }
        return entryAp;
    }

    private static void notFireUpFild(String fieldKey, Long areaReg, EntryFieldAp entryFieldAp) {
        if (AssessRuleConstants.NORM_INDCTR_AREA_PK.equals(areaReg) && GEN_NOT_FIRE_UP_FIELDS != null) {
            for (String notFireUpField : GEN_NOT_FIRE_UP_FIELDS) {
                if (!notFireUpField.equals(fieldKey)) continue;
                entryFieldAp.setFireUpdEvt(false);
            }
        }
        if (AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaReg) && ADDSUB_NOT_FIRE_UP_FIELDS != null) {
            for (String notFireUpField : ADDSUB_NOT_FIRE_UP_FIELDS) {
                if (!notFireUpField.equals(fieldKey)) continue;
                entryFieldAp.setFireUpdEvt(false);
            }
        }
        if (AssessRuleConstants.ATTACH_AREA_PK.equals(areaReg) && ATTACH_NOT_FIRE_UP_FIELDS != null) {
            for (String notFireUpField : ATTACH_NOT_FIRE_UP_FIELDS) {
                if (!notFireUpField.equals(fieldKey)) continue;
                entryFieldAp.setFireUpdEvt(false);
            }
        }
    }

    private static void setFieldWidth(EntryFieldAp entryFieldAp, DynamicObject fieldInfo, Long areaReg) {
        DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldPropEnum((String)areaField.getString("proptype"));
        String fieldKey = fieldInfo.getString("areafield.number");
        if (HRStringUtils.equals((String)fieldKey, (String)"indctrname") || HRStringUtils.equals((String)fieldKey, (String)"keyactname")) {
            if (AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(areaReg)) {
                entryFieldAp.setWidth(new LocaleString("300px"));
            } else {
                entryFieldAp.setWidth(new LocaleString("200px"));
            }
            return;
        }
        switch (fieldTypeEnum) {
            case MuliLangText: 
            case Text: 
            case TextAreaProp: 
            case MuliLangGlTextProp: 
            case LargeTextProp: {
                entryFieldAp.setWidth(new LocaleString("425px"));
                break;
            }
            default: {
                entryFieldAp.setWidth(new LocaleString("100px"));
            }
        }
    }

    private static Map<Long, ContentFieldEntryEvaDto> change2PermMap(List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        HashMap<Long, ContentFieldEntryEvaDto> filePermMap = new HashMap<Long, ContentFieldEntryEvaDto>(16);
        if (fieldEntryEvaDtos != null) {
            for (ContentFieldEntryEvaDto fieldEntryEvaDto : fieldEntryEvaDtos) {
                if (fieldEntryEvaDto == null) continue;
                filePermMap.put(fieldEntryEvaDto.getAreaFieldId(), fieldEntryEvaDto);
            }
        }
        return filePermMap;
    }

    private static void removeCustomeField(Set<String> notLoadFiled) {
        if (notLoadFiled != null) {
            Iterator<String> iterator = notLoadFiled.iterator();
            while (iterator.hasNext()) {
                String fieldKeyNumber = iterator.next();
                if (fieldKeyNumber == null || !fieldKeyNumber.startsWith("customfiled") && !fieldKeyNumber.equals("customfield")) continue;
                iterator.remove();
            }
        }
    }

    private static void setAreaNameByConfDynObj(LoadCustomControlMetasArgs args, DynamicObject conf) {
        Object customName = conf.get("areacustname");
        HashMap<String, Object> mapAreaName = new HashMap<String, Object>(16);
        mapAreaName.put("id", AREA_ID);
        mapAreaName.put("caption", customName);
        args.getItems().add(mapAreaName);
    }

    private static Field assembleField(DynamicObject fieldInfo, FormShowParameter formShowParameter, boolean mustInput) {
        int numAccuracy = Integer.parseInt((String)formShowParameter.getCustomParam("numaccuracy"));
        DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
        Field field = EvaluteDrawEntryEntityUtils.createField(areaField, numAccuracy);
        String fieldKey = areaField.getString("number");
        if (ASSESS_FORM_FILED_MAP.containsKey(fieldKey)) {
            fieldKey = ASSESS_FORM_FILED_MAP.get(fieldKey);
        }
        field.setId(fieldKey);
        field.setKey(fieldKey);
        field.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
        if (mustInput) {
            field.setMustInput(Boolean.TRUE.booleanValue());
        }
        return field;
    }

    private static Field createField(DynamicObject areaField, int numAccuracy) {
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldPropEnum((String)areaField.getString("proptype"));
        int max = areaField.getInt("max");
        int min = areaField.getInt("min");
        String dataScope = areaField.getString("datascope");
        switch (fieldTypeEnum) {
            case MuliLangText: {
                MuliLangTextField muliLangTextField = new MuliLangTextField();
                muliLangTextField.setMutiLine(false);
                muliLangTextField.setMaxLength(max);
                muliLangTextField.setMinLength(min);
                return muliLangTextField;
            }
            case Text: {
                TextField textField = new TextField();
                textField.setMaxLength(max);
                textField.setMinLength(min);
                return textField;
            }
            case Combo: {
                ComboField comboField = new ComboField();
                String key = areaField.getString("number");
                if (HRStringUtils.equals((String)key, (String)"evaltype")) {
                    EvaluteDrawEntryEntityUtils.addItem(comboField, ResManager.loadKDString((String)"\u5b9a\u6027", (String)"EvaluteDrawEntryEntityUtils_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "10");
                    EvaluteDrawEntryEntityUtils.addItem(comboField, ResManager.loadKDString((String)"\u5b9a\u91cf", (String)"EvaluteDrawEntryEntityUtils_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), "20");
                }
                return comboField;
            }
            case Date: {
                return new DateField();
            }
            case Boolean: {
                return new CheckBoxField();
            }
            case Decimal: {
                DecimalField decimalField = new DecimalField();
                decimalField.setPrecision(numAccuracy + 13);
                decimalField.setScale(numAccuracy);
                decimalField.setDataScope(dataScope);
                decimalField.setZeroShow(true);
                return decimalField;
            }
            case TextAreaProp: {
                TextAreaField textAreaField = new TextAreaField();
                textAreaField.setMaxLength(max);
                textAreaField.setMinLength(min);
                return textAreaField;
            }
            case MuliLangGlTextProp: {
                MuliLangTextField mumuliLangTextField = new MuliLangTextField();
                mumuliLangTextField.setMutiLine(true);
                mumuliLangTextField.setMaxLength(max);
                mumuliLangTextField.setMinLength(min);
                return mumuliLangTextField;
            }
            case LargeTextProp: {
                MuliLangTextField lamuliLangTextField = new MuliLangTextField();
                lamuliLangTextField.setMutiLine(true);
                lamuliLangTextField.setMaxLength(max);
                lamuliLangTextField.setMinLength(min);
                return lamuliLangTextField;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u5b57\u6bb5\u7c7b\u578b!", (String)"EvaluteDrawEntryEntityUtils_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    private static void addItem(ComboField comboField, String caption, String value) {
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(caption));
        comboItem.setValue(value);
        comboField.getItems().add(comboItem);
    }

    public static void drawCustomField(LoadCustomControlMetasArgs args, DynamicObject conf) {
        EvaluteDrawEntryEntityUtils.setAreaNameByConfDynObj(args, conf);
        FieldgroupPanelAp fieldOfRuleAp = new FieldgroupPanelAp();
        fieldOfRuleAp.setKey("custompanelap");
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        for (DynamicObject fieldInfo : entryEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            FieldAp fieldAp = new FieldAp();
            fieldAp.setId(fieldKey);
            fieldAp.setKey(fieldKey);
            fieldAp.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
            fieldAp.setFireUpdEvt(true);
            fieldAp.setNoDisplayScaleZero(false);
            fieldAp.setField(EvaluteDrawEntryEntityUtils.assembleCustomAreaField(fieldInfo, (FormShowParameter)args.getSource()));
            EvaluteDrawEntryEntityUtils.setCustomAreaFieldStyle(fieldAp, fieldInfo);
            fieldOfRuleAp.getItems().add(fieldAp);
        }
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", fieldOfRuleAp.getKey());
        mapEntry.put("items", (String)fieldOfRuleAp.createControl().get("items"));
        args.getItems().add(mapEntry);
    }

    private static Field assembleCustomAreaField(DynamicObject fieldInfo, FormShowParameter source) {
        DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
        Field field = EvaluteDrawEntryEntityUtils.createCustomField(areaField);
        String fieldKey = areaField.getString("number");
        field.setId(fieldKey);
        field.setKey(fieldKey);
        field.setName(new LocaleString(fieldInfo.getString("fieldcustname")));
        return field;
    }

    private static void setCustomAreaFieldStyle(FieldAp fieldAp, DynamicObject fieldInfo) {
        DynamicObject areaField = fieldInfo.getDynamicObject("areafield");
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldPropEnum((String)areaField.getString("proptype"));
        fieldAp.setFullLine(true);
        if (FieldTypeEnum.Attachment.equals((Object)fieldTypeEnum)) {
            Style style = new Style();
            Padding padding = new Padding();
            padding.setLeft("0px");
            padding.setRight("0px");
            style.setPadding(padding);
            fieldAp.setStyle(style);
        }
        if (FieldTypeEnum.TextAreaProp.equals((Object)fieldTypeEnum) || FieldTypeEnum.MuliLangGlTextProp.equals((Object)fieldTypeEnum) || FieldTypeEnum.LargeTextProp.equals((Object)fieldTypeEnum)) {
            fieldAp.setHeight(new LocaleString("92px"));
            fieldAp.setFieldStyle(2);
            fieldAp.setTextAlign("default");
        }
    }

    private static Field createCustomField(DynamicObject areaField) {
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldPropEnum((String)areaField.getString("proptype"));
        switch (fieldTypeEnum) {
            case MuliLangGlTextProp: {
                int max = areaField.getInt("max");
                int min = areaField.getInt("min");
                MuliLangTextField muliLangTextField = new MuliLangTextField();
                muliLangTextField.setMutiLine(Boolean.TRUE.booleanValue());
                muliLangTextField.setMaxLength(max);
                muliLangTextField.setMinLength(min);
                return muliLangTextField;
            }
            case Attachment: {
                AttachmentField attachmentField = new AttachmentField();
                return attachmentField;
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u5b57\u6bb5\u7c7b\u578b!", (String)"EvaluteDrawEntryEntityUtils_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    static {
        ASSESS_FORM_FILED_MAP.put("realfinishdate", "realfinishdate");
        ASSESS_FORM_FILED_MAP.put("qualityres", "qualityres");
        ASSESS_FORM_FILED_MAP.put("finishdesc", "finishdesc");
        ASSESS_FORM_FILED_MAP.put("evalscore", SOE);
        ASSESS_FORM_FILED_MAP.put("evaldesc", "evaldesc");
        GEN_NOT_FIRE_UP_FIELDS = new String[]{"realfinishdate", "finishdesc", "evaldesc", "customfiled1", "customfiled2", "customfiled3", "customfiled4", "customfiled5"};
        ADDSUB_NOT_FIRE_UP_FIELDS = new String[]{"evaldesc", "finishdesc", "evaldesc"};
        ATTACH_NOT_FIRE_UP_FIELDS = new String[]{"customfield"};
    }
}

