/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluate.utils;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class OpmcTaskProgressFormEdit
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String FORMID_TASKPROGRESS = "sch_taskprogress";
    public static final String CUSTPARAM_CLIENTJOBINFO = "sch_clientjobinfo";
    public static final String CUSTPARAM_TASKID = "sch_taskid";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_LBLPROGRESS = "lblprogress";
    private static final String KEY_STOP = "btnstop";
    private static final String KEY_MIN = "btnmin";
    private static final String CONFIRMACTIONID_STOP = "continue_stop";
    private static final String CONFIRMACTIONID_BACKGROUND = "continue_background";
    private boolean canClose = false;
    private JobFormInfo jobFormInfo;

    private JobInfo getJobInfo() {
        if (this.jobFormInfo == null) {
            this.jobFormInfo = this.getJobFormInfo();
        }
        return this.jobFormInfo == null ? null : this.jobFormInfo.getJobInfo();
    }

    private JobFormInfo getJobFormInfo() {
        if (this.jobFormInfo == null) {
            String str = (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_CLIENTJOBINFO);
            if (StringUtils.isBlank((CharSequence)str)) {
                return null;
            }
            this.jobFormInfo = (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
        }
        return this.jobFormInfo;
    }

    private String getTaskId() {
        return this.getView().getFormShowParameter().getCustomParams().containsKey(CUSTPARAM_TASKID) ? (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_TASKID) : this.getPageCache().get(CUSTPARAM_TASKID);
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put(CUSTPARAM_TASKID, taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        return StringUtils.isBlank((CharSequence)start) ? false : Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        return StringUtils.isBlank((CharSequence)finished) ? false : Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{KEY_STOP, KEY_MIN});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.startBar();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_STOP, KEY_MIN});
        this.getView().setVisible(Boolean.FALSE, new String[]{"showexp"});
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.setProgressDesc(ResManager.loadKDString((String)"\u51c6\u5907\u542f\u52a8\u4efb\u52a1", (String)"OpmcTaskProgressFormEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            bar.setPercent(progress);
            this.setProgressDesc(taskInfo.getDesc());
            this.setLabVal(taskInfo);
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            if (jobFormInfo != null) {
                this.setButtonVisible(jobFormInfo);
            }
        }
    }

    public void click(EventObject e) {
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_STOP)) {
            this.stop();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_MIN)) {
            this.tranBackground();
        }
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
        } else if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                this.complete(taskInfo, e);
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                String desc = taskInfo.getDesc();
                e.setProgress(progress);
                this.setLabVal(taskInfo);
                if (StringUtils.isNotBlank((CharSequence)desc)) {
                    this.setProgressDesc(desc);
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String taskId;
        JobFormInfo jobFormInfo;
        super.beforeClosed(e);
        if (!this.isStart()) {
            e.setCancel(true);
        } else if (!(this.canClose || this.isFinished() || (jobFormInfo = this.getJobFormInfo()) == null || StringUtils.isBlank((CharSequence)(taskId = this.getTaskId())))) {
            if (jobFormInfo.isCanStop()) {
                this.stop();
                e.setCancel(true);
            } else if (jobFormInfo.isCanBackground()) {
                this.tranBackground();
                e.setCancel(true);
            } else {
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() != MessageBoxResult.Yes) {
            this.startBar();
        } else if (StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)CONFIRMACTIONID_BACKGROUND)) {
            this.doTranBackground();
        } else {
            this.doStop();
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo != null) {
            if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
                jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
            }
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            this.setTaskId(taskId);
            this.setButtonVisible(jobFormInfo);
        }
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            if (OpmcTaskProgressFormEdit.isShowStackTrace()) {
                this.getView().showErrMessage(taskInfo.getFailureReason(), "");
            } else {
                String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u65e5\u5fd7", (String)"OpmcTaskProgressFormEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
            this.stopBar();
        } else if (!isFinished) {
            String msg = StringUtils.equalsIgnoreCase((CharSequence)"ABORTED", (CharSequence)taskInfo.getStatus()) ? ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u7ec8\u6b62", (String)"OpmcTaskProgressFormEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5", (String)"OpmcTaskProgressFormEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.setProgressDesc(msg);
            e.setProgress(99);
            this.setLabVal(taskInfo);
        } else {
            this.returnResult(null);
            if (StringUtils.equalsIgnoreCase((CharSequence)"COMPLETED", (CharSequence)taskInfo.getStatus())) {
                this.returnResult(taskInfo);
            }
            this.stopBar();
            e.setProgress(100);
            this.setLabVal(taskInfo);
            this.closeForm();
        }
    }

    private void setLabVal(TaskInfo taskInfo) {
        String data = taskInfo.getData();
        if (HRStringUtils.isEmpty((String)data)) {
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        if (HRObjectUtils.isEmpty((Object)map)) {
            return;
        }
        Label totalnumlap = (Label)this.getControl("valtotalnum");
        totalnumlap.setText(this.transferObj2Str(map.get("valTotalNum")));
        Label totalnumlap1 = (Label)this.getControl("startTotalNum");
        totalnumlap1.setText(this.transferObj2Str(map.get("startTotalNum")));
        Label totalnumlap2 = (Label)this.getControl("valdealnum");
        totalnumlap2.setText(this.transferObj2Str(map.get("valDealNum")));
        Label totalnumlap3 = (Label)this.getControl("startdealnum");
        totalnumlap3.setText(this.transferObj2Str(map.get("startDealNum")));
    }

    private String transferObj2Str(Object obj) {
        if (Objects.isNull(obj)) {
            return "0";
        }
        if (obj instanceof Integer) {
            return Integer.toString((Integer)obj);
        }
        return "0";
    }

    private void stop() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMACTIONID_STOP, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u6267\u884c", (String)"OpmcTaskProgressFormEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62\u6267\u884c", (String)"OpmcTaskProgressFormEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u7ec8\u6b62\u6267\u884c\uff1f", (String)"OpmcTaskProgressFormEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doStop() {
        this.startBar();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            ScheduleServiceHelper.stopTask((String)taskId);
            TaskClientProxy.suspend((JobFormInfo)this.jobFormInfo, (String)taskId);
        }
    }

    private void tranBackground() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMACTIONID_BACKGROUND, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"OpmcTaskProgressFormEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u540e\u53f0\u6267\u884c", (String)"OpmcTaskProgressFormEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u8f6c\u5165\u540e\u53f0\u6267\u884c\uff1f", (String)"OpmcTaskProgressFormEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doTranBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), this.getJobFormInfo(), taskId);
                ThreadPools.executeOnce((String)"BOSSchedule-task-background-monitor", (Runnable)subscriber);
            }
        }
    }

    private void setProgressDesc(String desc) {
        Label lblDesc = (Label)this.getControl(KEY_LBLPROGRESS);
        lblDesc.setText(desc);
    }

    private void setButtonVisible(JobFormInfo jobFormInfo) {
        if (jobFormInfo.isCanStop()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_STOP});
        }
        if (jobFormInfo.isCanBackground()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_MIN});
        }
    }

    private void returnResult(TaskInfo taskInfo) {
        Map<String, String> result = OpmcTaskProgressFormEdit.packageReturnResult(taskInfo);
        if (result != null) {
            this.getView().returnDataToParent(result);
        }
    }

    public static Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (taskInfo != null) {
            String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
            result.put("taskinfo", taskInfoStr);
            result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        }
        return result;
    }

    private static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if (showStackTrace != null && "true".equals(showStackTrace)) {
            return true;
        }
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }
}

