/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluated;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.process.ProcessExecuteApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ObjsetScoreRecordDomainService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.common.enums.evaluat.ResSyncStatusEnum;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;

public class EvalModifyEvalResultPlugIn
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener,
ItemClickListener {
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY = ExecuteSchemeEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();
    private static final ProcessExecuteApplicationService PROCESS_EXECUTE_APPLICATION_SERVICE = ProcessExecuteApplicationService.getInstance();
    private static final ObjsetScoreRecordDomainService OBJSET_SCORERECORD_ENTITY_SERVICE = ObjsetScoreRecordDomainService.getInstance();
    private static final String ASSESS_OBJECT_ENTRY_ENTITY = "assessobjectentryentity";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "comfirm": {
                this.checkAssessObjectForSave(args);
                break;
            }
        }
    }

    private void checkAssessObjectForSave(BeforeDoOperationEventArgs args) {
        boolean actPerm;
        DynamicObjectCollection assessObject = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)assessObject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u8bf7\u6dfb\u52a0\u6570\u636e", (String)"EvalModifyEvalResultPlugIn_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (!(actPerm = EvalObjUtils.checkActivityPermission((IFormView)this.getView()))) {
            args.setCancel(true);
            return;
        }
        if (!this.checkScore(assessObject)) {
            args.setCancel(true);
            return;
        }
    }

    private boolean checkScore(DynamicObjectCollection assessObjectColl) {
        IPageCache pageCache = this.getView().getPageCache();
        String maxscore = pageCache.get("maxscore");
        BigDecimal maxscoreBig = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)maxscore) ? BigDecimal.ZERO : new BigDecimal(maxscore);
        String minscore = pageCache.get("minscore");
        BigDecimal minscoreBig = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)minscore) ? BigDecimal.ZERO : new BigDecimal(minscore);
        ArrayList<String> objMsgList = new ArrayList<String>();
        String levalMust = pageCache.get("levelMust");
        for (DynamicObject objEntry : assessObjectColl) {
            BigDecimal score = objEntry.getBigDecimal("scorefield");
            if (null == score) {
                String objMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199 {0}\uff08{1}\uff09\u7684\u7ee9\u6548\u8bc4\u4f30\u5f97\u5206", (String)"EvalModifyEvalResultPlugIn_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{objEntry.getString("perffile.name"), objEntry.getString("perffile.billno"), minscoreBig.stripTrailingZeros().toPlainString(), maxscoreBig.stripTrailingZeros().toPlainString()});
                objMsgList.add(objMsg);
                continue;
            }
            if (score.compareTo(minscoreBig) < 0 || score.compareTo(maxscoreBig) > 0) {
                String objMsg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u7684\u201c\u7ee9\u6548\u8bc4\u4f30\u5f97\u5206\u201d\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{2}~{3}\u3002", (String)"EvalModifyEvalResultPlugIn_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{objEntry.getString("perffile.name"), objEntry.getString("perffile.billno"), minscoreBig.stripTrailingZeros().toPlainString(), maxscoreBig.stripTrailingZeros().toPlainString()});
                objMsgList.add(objMsg);
                continue;
            }
            boolean isValidateLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isValidateLevel");
            String level = objEntry.getString("levelfield");
            if (!isValidateLevel || !HRStringUtils.equals((String)levalMust, (String)"1") || !HRStringUtils.isEmpty((String)level)) continue;
            String objMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199 {0}\uff08{1}\uff09\u7684\u7ee9\u6548\u8bc4\u4f30\u7b49\u7ea7", (String)"EvalModifyEvalResultPlugIn_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{objEntry.getString("perffile.name"), objEntry.getString("perffile.billno")});
            objMsgList.add(objMsg);
        }
        if (objMsgList.size() > 0) {
            String checkMsg = String.join((CharSequence)"\r\n", objMsgList);
            this.getView().showErrorNotification(checkMsg);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "comfirm": {
                this.saveAssessObjUptData(args);
                break;
            }
        }
    }

    private void saveAssessObjUptData(AfterDoOperationEventArgs args) {
        ArrayList<String> failMessage;
        DynamicObjectCollection assessObjectColl = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY);
        int notSuitCount = this.dealPartEvalBackResultData(assessObjectColl, args, failMessage = new ArrayList<String>(16));
        if (notSuitCount == 0) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f", (String)"EvalModifyEvalResultPlugIn_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"EvalModifyEvalResultPlugIn_5", (String)"opmc-epa-business", (Object[])new Object[0]), assessObjectColl.size(), assessObjectColl.size() - notSuitCount, notSuitCount);
            Tuple message = Tuple.create((Object)title, (Object)String.join((CharSequence)"\n", failMessage));
            this.getView().getParentView().showMessage(String.valueOf(message.item1), String.valueOf(message.item2), MessageTypes.Default);
        }
    }

    private int dealPartEvalBackResultData(DynamicObjectCollection assessObjectColl, AfterDoOperationEventArgs args, List<String> failMessage) {
        int allSize;
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        DynamicObject activityDy = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(activityId);
        Map scoreAndLevelMap = EvalObjUtils.reqFormScoreAndLevel((DynamicObject)activityDy);
        List essessObjIdList = assessObjectColl.stream().map(assessObj -> assessObj.getLong("evalobj.id")).collect(Collectors.toList());
        Map evalObjDyMap = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithIdList("id,activity.id,perforg.id,assessyear,assessperiod,evalfinishtype,sop,lop,msoac,mloac,sopsource,fsop,flop,fsopsource,assessstaus,ressyncstatus,person.name,person.number,assessnode.id,nodestatus,modifier,modifytime,perffile.sourcevid,perffilev,fsopscoresystem,floplevel", essessObjIdList);
        int successSize = allSize = assessObjectColl.size();
        Date date = new Date();
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        Tuple booleanBooleanTuple = PROCESS_EXECUTE_APPLICATION_SERVICE.queryIsLastNodeNActEnd(activityId, AssessNodeStatusEnum.EVALUATED);
        boolean lastNodeFlag = (Boolean)booleanBooleanTuple.item1;
        Map<Long, Object> reasonMap = assessObjectColl.stream().collect(Collectors.toMap(assCollKey -> assCollKey.getLong("evalobj.id"), assCollVal -> assCollVal.get("reason")));
        for (int index = 0; index < allSize; ++index) {
            boolean evalCompletedLastNode;
            DynamicObject entryDy = (DynamicObject)assessObjectColl.get(index);
            DynamicObject evalObj = (DynamicObject)evalObjDyMap.get(entryDy.getLong("evalobj.id"));
            boolean bl = evalCompletedLastNode = lastNodeFlag && HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessNodeStatusEnum.EVALUATED.getStatus());
            if (evalCompletedLastNode && HRStringUtils.equals((String)evalObj.getString("ressyncstatus"), (String)ResSyncStatusEnum.ARCHIVED.getCode())) {
                failMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0} ({1}) : \u7ed3\u679c\u5df2\u5f52\u6863\uff0c\u4e0d\u53ef\u4fee\u6539", (String)"EvalModifyEvalResultPlugIn_6", (String)"opmc-epa-business", (Object[])new Object[0]), evalObj.getString("person.name"), evalObj.getString("person.number")));
                --successSize;
                continue;
            }
            if (!(evalCompletedLastNode || evalObj.getLong("assessnode.id") == NodeTabMapEnum.EVAL_PROCESS.getNodeId().longValue() && HRStringUtils.equals((String)evalObj.getString("nodestatus"), (String)AssessNodeStatusEnum.EVALUATED.getStatus()) && HRStringUtils.equals((String)evalObj.getString("assessstaus"), (String)AssessStausEnum.HAVE_IN_HAND.getStatus()))) {
                failMessage.add(MessageFormat.format(ResManager.loadKDString((String)"{0} ({1}) : \u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u8bc4\u4f30\u5b8c\u6210", (String)"EvalModifyEvalResultPlugIn_7", (String)"opmc-epa-business", (Object[])new Object[0]), evalObj.getString("person.name"), evalObj.getString("person.number")));
                --successSize;
                continue;
            }
            BigDecimal score = entryDy.getBigDecimal("scorefield");
            String levelId = entryDy.getString("levelfield");
            String level = this.getLevel2PageCache(levelId, Boolean.TRUE);
            evalObj.set(AssessScoreAbbrEnum.MSOAC.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.MLOAC.getCode(), (Object)level);
            evalObj.set(AssessScoreAbbrEnum.SOP.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.LOP.getCode(), (Object)level);
            evalObj.set("sopsource", (Object)AssessScoreAbbrEnum.MSOAC.getCode());
            evalObj.set(AssessScoreAbbrEnum.FSOP.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.FLOP.getCode(), (Object)level);
            evalObj.set("fsopsource", (Object)AssessScoreAbbrEnum.SOP.getCode());
            evalObj.set("fsopscoresystem", scoreAndLevelMap.get("scoreSystem"));
            evalObj.set("floplevel", scoreAndLevelMap.get("sumPerfLevel"));
            evalObj.set("perffilev", evalObj.get("perffile.sourcevid"));
            long userId = UserServiceHelper.getCurrentUserId();
            evalObj.set("modifier", (Object)userId);
            evalObj.set("modifytime", (Object)date);
            dyColl.add((Object)evalObj);
        }
        OBJSET_SCORERECORD_ENTITY_SERVICE.saveEntityByEval(dyColl, reasonMap, AssessNodeStatusEnum.EVALUATED.getNodeId());
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObjectColl(dyColl);
        return allSize - successSize;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IPageCache pageCache = this.getView().getPageCache();
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("scorefield".equals(propertyName)) {
            boolean validateFlage;
            BigDecimal score = (BigDecimal)changeData.getNewValue();
            if (null == score) {
                return;
            }
            String numaccuracy = pageCache.get("numaccuracy");
            String scaletype = pageCache.get("scaletype");
            if (StringUtils.isNotEmpty((CharSequence)numaccuracy)) {
                score = score.setScale(Integer.parseInt(numaccuracy), StringUtils.equals((CharSequence)scaletype, (CharSequence)"10") ? 0 : (StringUtils.equals((CharSequence)scaletype, (CharSequence)"20") ? 1 : 4));
            }
            if (!(validateFlage = this.valiateScoreByScoreRange(score, changeData))) {
                return;
            }
            String levalMust = pageCache.get("levelMust");
            String isMappinng = pageCache.get("isMappinng");
            boolean isConvertLevelByScore = EvalObjUtils.requireLevelAndScoreParam((String)"isConvertLevelByScore");
            if ("1".equals(isMappinng) && isConvertLevelByScore && HRStringUtils.equals((String)levalMust, (String)"1")) {
                String levelPk = ASSESS_FORM_DOMAIN_SERVICE.requireLevelPk(Long.valueOf(Long.parseLong(pageCache.get("assessFormId"))), (BigDecimal)e.getChangeSet()[0].getNewValue());
                this.getView().getModel().setValue("levelfield", (Object)levelPk, changeData.getRowIndex());
            }
            this.getView().getModel().setValue("scorefield", (Object)score, changeData.getRowIndex());
        }
    }

    private boolean valiateScoreByScoreRange(BigDecimal score, ChangeData changeData) {
        BigDecimal minscoreBig;
        IPageCache pageCache = this.getView().getPageCache();
        String maxscore = pageCache.get("maxscore");
        BigDecimal maxscoreBig = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)maxscore) ? BigDecimal.ZERO : new BigDecimal(maxscore);
        String minscore = pageCache.get("minscore");
        BigDecimal bigDecimal = minscoreBig = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)minscore) ? BigDecimal.ZERO : new BigDecimal(minscore);
        if (score.compareTo(minscoreBig) >= 0 && score.compareTo(maxscoreBig) <= 0) {
            return Boolean.TRUE;
        }
        this.getView().showErrorNotification(String.format("%s%s~%s\u3002", ResManager.loadKDString((String)"\u201c\u7ee9\u6548\u8bc4\u4f30\u5f97\u5206\u201d\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a", (String)"EvalModifyEvalResultPlugIn_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]), minscoreBig.stripTrailingZeros().toPlainString(), maxscoreBig.stripTrailingZeros().toPlainString()));
        return Boolean.FALSE;
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void afterCreateNewData(EventObject evt) {
        DynamicObject assessForm;
        super.afterCreateNewData(evt);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long activityId = (Long)parameter.getCustomParam("activity");
        if (Objects.isNull(activityId)) {
            return;
        }
        DynamicObject atcivityDy = ACTIVITY_ENTITY_SERVICE.queryAssessFormByActivity(activityId);
        if (Objects.isNull(atcivityDy)) {
            this.setDefualtScoreRange();
            return;
        }
        long assessFormId = atcivityDy.getLong("assessform.id");
        if (assessFormId == 0L) {
            DynamicObject executeSchemeDy = EXECUTE_SCHEME_ENTITY.queryOne(atcivityDy.get("executescheme_id"));
            assessFormId = executeSchemeDy.getLong("assessform_id");
        }
        if (Objects.isNull(assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(Long.valueOf(assessFormId)))) {
            this.setDefualtScoreRange();
            return;
        }
        this.isScoreMappingLeval(assessFormId);
        this.setScoreRange2PageCache(assessForm);
        this.setScoreAndLevelStyle(assessForm);
        this.builderEntryData();
    }

    private void builderEntryData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List evalObjectIds = (List)parameter.getCustomParams().get("evalObjectIds");
        DynamicObject[] evalObjDyArr = EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvalObjWithScoreById(evalObjectIds);
        if (CollectionUtils.isEmpty((Collection)evalObjectIds)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("evalobj", new Object[0]);
        setter.addField("perffile", new Object[0]);
        setter.addField("group", new Object[0]);
        setter.addField("person", new Object[0]);
        setter.addField("empposorgrel", new Object[0]);
        setter.addField("employee", new Object[0]);
        setter.addField("scorefield", new Object[0]);
        setter.addField("levelfield", new Object[0]);
        IPageCache pageCache = this.getView().getPageCache();
        String numaccuracy = pageCache.get("numaccuracy");
        String scaletype = pageCache.get("scaletype");
        boolean isInitLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isInitLevel");
        for (DynamicObject evalObj : evalObjDyArr) {
            String level = this.getLevel2PageCache(evalObj.getString(AssessScoreAbbrEnum.LOP.getCode()), Boolean.FALSE);
            if (!isInitLevel) {
                level = "";
            }
            BigDecimal score = evalObj.getBigDecimal(AssessScoreAbbrEnum.SOP.getCode());
            if (StringUtils.isNotEmpty((CharSequence)numaccuracy)) {
                score = score.setScale(Integer.parseInt(numaccuracy), StringUtils.equals((CharSequence)scaletype, (CharSequence)"10") ? 0 : (StringUtils.equals((CharSequence)scaletype, (CharSequence)"20") ? 1 : 4));
            }
            setter.addRow(new Object[]{evalObj.getLong("id"), evalObj.getLong("perffile.id"), evalObj.getLong("assgroup.id"), evalObj.getLong("person.id"), evalObj.getLong("empposrel.id"), evalObj.getLong("employee.id"), score, level});
        }
        model.batchCreateNewEntryRow(ASSESS_OBJECT_ENTRY_ENTITY, setter);
        model.endInit();
        this.getView().updateView(ASSESS_OBJECT_ENTRY_ENTITY);
    }

    private void setScoreAndLevelStyle(DynamicObject assessForm) {
        DecimalEdit decimalEdit = (DecimalEdit)this.getControl("scorefield");
        decimalEdit.setMustInput(true);
        IPageCache pageCache = this.getView().getPageCache();
        FieldEdit combofield = (FieldEdit)this.getControl("levelfield");
        combofield.setMustInput(true);
        pageCache.put("levelMust", "1");
        DynamicObject sumperflevel = assessForm.getDynamicObject("sumperflevel");
        boolean isVisibleLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isVisibleLevel");
        if (Objects.isNull(sumperflevel) || !isVisibleLevel) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"levelfield"});
            combofield.setMustInput(false);
            pageCache.put("levelMust", "0");
            return;
        }
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle(sumperflevel.getPkValue());
        this.genaratePerfLevelSelect(sumPerfLevel);
    }

    private void genaratePerfLevelSelect(DynamicObject sumPerfLevel) {
        DynamicObjectCollection entryentity = sumPerfLevel.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return;
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        for (DynamicObject entry : entryentity) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(entry.getPkValue()));
            item.setCaption(new LocaleString(entry.getString("levelname")));
            item.setValue(String.valueOf(entry.getPkValue()));
            combos.add(item);
            this.setLevel2PageCache(entry);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("levelfield");
        comboEdit.setComboItems(combos);
    }

    private void setLevel2PageCache(DynamicObject entry) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put(MessageFormat.format("{0}{1}", "levelID", String.valueOf(entry.getPkValue())), entry.getString("seq"));
        pageCache.put(MessageFormat.format("{0}{1}", "levelseq", entry.getString("seq")), String.valueOf(entry.getPkValue()));
    }

    private String getLevel2PageCache(String level, boolean type) {
        IPageCache pageCache = this.getView().getPageCache();
        String levelData = pageCache.get(MessageFormat.format("{0}{1}", type ? "levelID" : "levelseq", level));
        return levelData;
    }

    private void isScoreMappingLeval(Long assessFormId) {
        IPageCache pageCache = this.getView().getPageCache();
        boolean isMappinng = ASSESS_FORM_DOMAIN_SERVICE.isScoreMappingLeval(assessFormId);
        pageCache.put("isMappinng", isMappinng ? "1" : "0");
    }

    private void setScoreRange2PageCache(DynamicObject assessForm) {
        IPageCache pageCache = this.getView().getPageCache();
        String numaccuracy = assessForm.getString("numaccuracy");
        pageCache.put("numaccuracy", numaccuracy);
        String scaletype = assessForm.getString("scaletype");
        pageCache.put("scaletype", scaletype);
        DynamicObject scoresystem = assessForm.getDynamicObject("scoresystem");
        String evaSumLimit = assessForm.getString("evasumlimit");
        String limitmaxscore = assessForm.getString("limitmaxscore");
        String limitminscore = assessForm.getString("limitminscore");
        pageCache.put("evaSumLimit", evaSumLimit);
        if (HRStringUtils.isEmpty((String)evaSumLimit) && Objects.isNull(scoresystem)) {
            this.setDefualtScoreRange();
            return;
        }
        pageCache.put("assessFormId", assessForm.getPkValue().toString());
        if (HRStringUtils.isEmpty((String)evaSumLimit) || HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.SUM_LIMIT.getValue())) {
            pageCache.put("maxscore", scoresystem.getString("maxscore"));
            pageCache.put("minscore", scoresystem.getString("minscore"));
        } else if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.APPOINT_SUM_LIMIT.getValue())) {
            pageCache.put("maxscore", limitmaxscore);
            pageCache.put("minscore", limitminscore);
        } else if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.NOT_LIMIT.getValue())) {
            DynamicObjectCollection areaEntry = assessForm.getDynamicObjectCollection("areaconfentry");
            List plusMinusList = areaEntry.stream().filter(entry -> AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(entry.getDynamicObject("areareg").getPkValue())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(plusMinusList)) {
                Long areaConf = ((DynamicObject)plusMinusList.get(0)).getLong("areaconf");
                DynamicObject plusMinusConfigDy = ASSESS_RULE_APP_SERVICE.queryPlusMinusConfigByPk(areaConf);
                BigDecimal maxScore = scoresystem.getBigDecimal("maxscore").add(plusMinusConfigDy.getBigDecimal("pluslimit"));
                BigDecimal minScore = scoresystem.getBigDecimal("minscore").add(plusMinusConfigDy.getBigDecimal("minuslimit"));
                pageCache.put("maxscore", maxScore.toString());
                pageCache.put("minscore", minScore.toString());
            } else {
                pageCache.put("maxscore", scoresystem.getString("maxscore"));
                pageCache.put("minscore", scoresystem.getString("minscore"));
            }
        } else {
            this.setDefualtScoreRange();
        }
        ObjEvaluationUtils.ExtPointSetScope(assessForm, this.getView());
        this.initScoreRange();
    }

    private void initScoreRange() {
        IPageCache pageCache = this.getView().getPageCache();
        BigDecimal minscore = pageCache.get("minscore") == null ? BigDecimal.ZERO : new BigDecimal(pageCache.get("minscore"));
        BigDecimal maxscore = pageCache.get("maxscore") == null ? BigDecimal.ZERO : new BigDecimal(pageCache.get("maxscore"));
        Label totalnumlap = (Label)this.getControl("minlab");
        totalnumlap.setText(this.setNull2Zero(minscore));
        Label sucessnumlab = (Label)this.getControl("maxlab");
        sucessnumlab.setText(this.setNull2Zero(maxscore));
    }

    private String setNull2Zero(BigDecimal num) {
        return num.stripTrailingZeros().toPlainString();
    }

    private void setDefualtScoreRange() {
        this.getView().getPageCache().put("maxscore", "0");
        this.getView().getPageCache().put("minscore", "0");
    }
}

