/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;

public class EvalTaskManageDynamicPlugin
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ListView parentView = (ListView)this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        String billFormId = parentView.getBillFormId();
        if (billFormId.equals("epa_targetformulating")) {
            Label name = (Label)this.getView().getControl("labelap");
            name.setText(ResManager.loadKDString((String)"\u5236\u5b9a\u6d41\u7a0b", (String)"EvalTaskManageDynamicPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Map flowMap = billFormId.equals("epa_targetformulating") ? ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFormulatingFlowsMap(activityId) : ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvaluatingFlowsMap(activityId);
        DynamicObject[] flows = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryFlowByPkValue(flowMap.keySet());
        this.buildComboItem(flowMap, flows);
        this.showRightList();
    }

    private void buildComboItem(Map<Object, Long> flowMap, DynamicObject[] flows) {
        DynamicObject defaultFlow = Arrays.stream(flows).filter(dy -> dy.getBoolean("isdefault")).findFirst().orElse(null);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        if (defaultFlow != null) {
            String name = defaultFlow.getString("name");
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(defaultFlow.getPkValue()));
            item.setCaption(new LocaleString(name));
            item.setValue(String.valueOf(defaultFlow.getPkValue()));
            combos.add(item);
        }
        Arrays.stream(flows).filter(dy -> !dy.getBoolean("isdefault")).forEach(dy -> {
            String name = dy.getString("name");
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(dy.getPkValue()));
            item.setCaption(new LocaleString(name));
            item.setValue(String.valueOf(dy.getPkValue()));
            combos.add(item);
        });
        ComboEdit comboEdit = (ComboEdit)this.getControl("flowcomb");
        comboEdit.setComboItems(combos);
        if (!CollectionUtils.isEmpty(combos)) {
            this.getModel().setValue("flowcomb", (Object)((ComboItem)combos.get(0)).getId());
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        if (this.getView().getParentView() == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"EvalTaskManageDynamicPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return;
        }
        String name = args.getProperty().getName();
        if ("flowcomb".equals(name)) {
            Object flowId = this.getModel().getValue("flowcomb");
            this.showRightList();
        }
    }

    private void showRightList() {
        ListView parentView = (ListView)this.getView().getParentView();
        if (null == parentView) {
            return;
        }
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        Object flowId = this.getModel().getValue("flowcomb");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        String rightBillFormId = parentView.getBillFormId().equals("epa_targetformulating") ? "epa_formultaskquerylist" : "epa_evaltaskquerylist";
        parameter.setBillFormId(rightBillFormId);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("flexpanelap1");
        parameter.setCustomParam("activity", (Object)activityId);
        parameter.setCustomParam("nodeindex", (Object)nodeIndex);
        parameter.setCustomParam("flowDefId", flowId);
        this.getView().getPageCache().put("task_page_id", parameter.getPageId());
        this.getView().getPageCache().put("flowDefId", flowId.toString());
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView")) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                this.getView().close();
            }
            return;
        }
    }
}

