/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluated;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;

public class EvaluateSetResultPlugin
extends AbstractBasePlugIn {
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY = ExecuteSchemeEntityService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long activityId = (Long)parameter.getCustomParam("activity");
        if (Objects.isNull(activityId)) {
            return;
        }
        String operationType = (String)parameter.getCustomParam("operationType");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationType)) {
            return;
        }
        LocaleString forTitle = null;
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
        switch (operationType) {
            case "0": {
                forTitle = ResManager.getLocaleString((String)"\u4e0d\u53c2\u4e0e\u8bc4\u4f30", (String)"EvaluateSetResultPlugin_2", (String)"opmc-epa-formplugin");
                this.getView().setVisible(Boolean.FALSE, new String[]{"hintap1", "hintap2"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap1"});
                fieldMap.put("bc", "#FFF1D4");
                break;
            }
            case "1": {
                forTitle = ResManager.getLocaleString((String)"\u7ed3\u675f\u8bc4\u4f30", (String)"EvaluateSetResultPlugin_3", (String)"opmc-epa-formplugin");
                this.getView().setVisible(Boolean.FALSE, new String[]{"hintap2", "hintap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap1"});
                fieldMap.put("bc", "#FFF1D4");
                break;
            }
            case "2": {
                forTitle = ResManager.getLocaleString((String)"\u4fee\u6539\u8bc4\u4f30\u7ed3\u679c", (String)"EvaluateSetResultPlugin_4", (String)"opmc-epa-formplugin");
                this.getView().setVisible(Boolean.FALSE, new String[]{"hintap", "hintap1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap"});
                fieldMap.put("bc", "#E1EFFF");
                break;
            }
        }
        this.getView().setFormTitle(forTitle);
        this.setPageContent(activityId);
        String evalCount = (String)parameter.getCustomParam("evalCount");
        this.setTotalNumLab(evalCount);
        this.getView().updateControlMetadata("flexpanelap", (Map)fieldMap);
    }

    private void setTotalNumLab(String evalCount) {
        Label totalnumlap = (Label)this.getControl("totalnumlab");
        totalnumlap.setText(this.setNull2Zero(evalCount));
    }

    private String setNull2Zero(String num) {
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)num) ? "0" : num;
    }

    private void setPageContent(Long activityId) {
        DynamicObject assessForm;
        DynamicObject atcivityDy = ACTIVITY_ENTITY_SERVICE.queryAssessFormByActivity(activityId);
        if (Objects.isNull(atcivityDy)) {
            this.setDefualtScoreRange();
            return;
        }
        long assessFormId = atcivityDy.getLong("assessform.id");
        if (assessFormId == 0L) {
            DynamicObject executeSchemeDy = EXECUTE_SCHEME_ENTITY.queryOne(atcivityDy.get("executescheme_id"));
            assessFormId = executeSchemeDy.getLong("assessform_id");
        }
        if (Objects.isNull(assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(Long.valueOf(assessFormId)))) {
            this.setDefualtScoreRange();
            return;
        }
        this.isScoreMappingLeval(assessFormId);
        this.setScoreRange2PageCache(assessForm);
        this.setScoreAndLevelStyle(assessForm);
    }

    private void isScoreMappingLeval(Long assessFormId) {
        IPageCache pageCache = this.getView().getPageCache();
        boolean isMappinng = ASSESS_FORM_DOMAIN_SERVICE.isScoreMappingLeval(assessFormId);
        pageCache.put("isMappinng", isMappinng ? "1" : "0");
    }

    private void setScoreAndLevelStyle(DynamicObject assessForm) {
        IPageCache pageCache = this.getView().getPageCache();
        DecimalEdit decimalEdit = (DecimalEdit)this.getControl("scorefield");
        decimalEdit.setMustInput(true);
        this.setPageInitScore();
        FieldEdit combofield = (FieldEdit)this.getControl("levelfield");
        boolean isValidateLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isValidateLevel");
        if (isValidateLevel) {
            combofield.setMustInput(true);
        } else {
            combofield.setMustInput(false);
        }
        boolean isVisibleLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isVisibleLevel");
        DynamicObject sumperflevel = assessForm.getDynamicObject("sumperflevel");
        if (Objects.isNull(sumperflevel) || !isVisibleLevel) {
            combofield.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"levelfield"});
            pageCache.put("levelVisibleFlag", "1");
            return;
        }
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle(sumperflevel.getPkValue());
        this.genaratePerfLevelSelect(sumPerfLevel);
    }

    private void setPageInitScore() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String operationType = (String)parameter.getCustomParam("operationType");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationType) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)operationType, (CharSequence)"2")) {
            return;
        }
        String evalCount = (String)parameter.getCustomParam("evalCount");
        BigDecimal sscore = (BigDecimal)parameter.getCustomParam("sscore");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)evalCount) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)evalCount, (CharSequence)"1") || Objects.isNull(sscore)) {
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String numaccuracy = pageCache.get("numaccuracy");
        String scaletype = pageCache.get("scaletype");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)numaccuracy)) {
            sscore = sscore.setScale(Integer.parseInt(numaccuracy), org.apache.commons.lang3.StringUtils.equals((CharSequence)scaletype, (CharSequence)"10") ? 0 : (org.apache.commons.lang3.StringUtils.equals((CharSequence)scaletype, (CharSequence)"20") ? 1 : 4));
        }
        this.getView().getModel().setValue("scorefield", (Object)sscore);
    }

    private void genaratePerfLevelSelect(DynamicObject sumPerfLevel) {
        DynamicObjectCollection entryentity = sumPerfLevel.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return;
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String operationType = (String)parameter.getCustomParam("operationType");
        String evalCount = (String)parameter.getCustomParam("evalCount");
        String slevel = (String)parameter.getCustomParam("slevel");
        BigDecimal sscore = (BigDecimal)parameter.getCustomParam("sscore");
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        String defultLevelPk = null;
        for (DynamicObject entry : entryentity) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(entry.getPkValue()));
            String seq = entry.getString("seq");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)slevel) && org.apache.commons.lang3.StringUtils.equals((CharSequence)seq, (CharSequence)slevel)) {
                defultLevelPk = String.valueOf(entry.getPkValue());
            }
            item.setCaption(new LocaleString(entry.getString("levelname")));
            item.setValue(String.valueOf(entry.getPkValue()));
            combos.add(item);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("levelfield");
        comboEdit.setComboItems(combos);
        boolean isInitLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isInitLevel");
        if (!isInitLevel) {
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)evalCount) && org.apache.commons.lang3.StringUtils.equals((CharSequence)evalCount, (CharSequence)"1") && org.apache.commons.lang3.StringUtils.isNotEmpty(defultLevelPk)) {
            this.getModel().setValue("levelfield", (Object)defultLevelPk);
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String isMappinng = pageCache.get("isMappinng");
        if ("0".equals(isMappinng) || null == sscore) {
            return;
        }
        String levelPk = ASSESS_FORM_DOMAIN_SERVICE.requireLevelPk(Long.valueOf(Long.parseLong(pageCache.get("assessFormId"))), BigDecimal.ZERO);
        this.getView().getModel().setValue("levelfield", (Object)levelPk);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        IPageCache pageCache = this.getView().getPageCache();
        String levelVisibleFlag = pageCache.get("levelVisibleFlag");
        boolean isValidateLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isValidateLevel");
        switch (operateKey) {
            case "donothing_comfire": {
                boolean actPerm = EvalObjUtils.checkActivityPermission((IFormView)this.getView());
                if (!actPerm) {
                    args.setCancel(true);
                    return;
                }
                if (!this.checkScore(levelVisibleFlag)) {
                    args.setCancel(true);
                    break;
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)levelVisibleFlag) && org.apache.commons.lang3.StringUtils.equals((CharSequence)levelVisibleFlag, (CharSequence)"1") || !isValidateLevel) {
                    if (this.checkCalcMustInput("scorefield")) break;
                    args.setCancel(true);
                    break;
                }
                if (this.checkCalcMustInput("scorefield", "levelfield")) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "donothing_comfire": {
                this.returnData2ParentPage();
                break;
            }
        }
    }

    private void returnData2ParentPage() {
        IPageCache pageCache = this.getView().getPageCache();
        String dataChanged = pageCache.get("dataChanged");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String operationType = (String)parameter.getCustomParam("operationType");
        if (HRStringUtils.equals((String)"2", (String)operationType) && (HRStringUtils.isEmpty((String)dataChanged) || HRStringUtils.equals((String)"0", (String)operationType))) {
            return;
        }
        BigDecimal score = (BigDecimal)this.getModel().getValue("scorefield");
        String level = (String)this.getModel().getValue("levelfield");
        Object reason = this.getModel().getValue("reason");
        JSONObject resultData = new JSONObject();
        resultData.put("score", (Object)score);
        level = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)level) ? "" : this.requireSeqByLevelPK(Long.parseLong(pageCache.get("assessFormId")), level);
        resultData.put("level", (Object)level);
        resultData.put("reason", reason);
        this.getView().returnDataToParent((Object)resultData);
    }

    private String requireSeqByLevelPK(Long assessFormId, String level) {
        String seq = "";
        DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(assessFormId);
        DynamicObject sumperflevel = assessForm.getDynamicObject("sumperflevel");
        if (Objects.isNull(sumperflevel)) {
            return seq;
        }
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle(sumperflevel.getPkValue());
        DynamicObjectCollection entryentity = sumPerfLevel.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return seq;
        }
        for (DynamicObject entry : entryentity) {
            String entryPk = String.valueOf(entry.getPkValue());
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)level) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)level, (CharSequence)entryPk)) continue;
            seq = entry.getString("seq");
            return seq;
        }
        return seq;
    }

    private void setScoreRange2PageCache(DynamicObject assessForm) {
        IPageCache pageCache = this.getView().getPageCache();
        String numaccuracy = assessForm.getString("numaccuracy");
        pageCache.put("numaccuracy", numaccuracy);
        String scaletype = assessForm.getString("scaletype");
        pageCache.put("scaletype", scaletype);
        DynamicObject scoresystem = assessForm.getDynamicObject("scoresystem");
        String evaSumLimit = assessForm.getString("evasumlimit");
        String limitmaxscore = assessForm.getString("limitmaxscore");
        String limitminscore = assessForm.getString("limitminscore");
        pageCache.put("evaSumLimit", evaSumLimit);
        if (HRStringUtils.isEmpty((String)evaSumLimit) && Objects.isNull(scoresystem)) {
            this.setDefualtScoreRange();
            return;
        }
        pageCache.put("assessFormId", assessForm.getPkValue().toString());
        if (HRStringUtils.isEmpty((String)evaSumLimit) || HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.SUM_LIMIT.getValue())) {
            pageCache.put("maxscore", scoresystem.getString("maxscore"));
            pageCache.put("minscore", scoresystem.getString("minscore"));
            return;
        }
        if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.APPOINT_SUM_LIMIT.getValue())) {
            pageCache.put("maxscore", limitmaxscore);
            pageCache.put("minscore", limitminscore);
            return;
        }
        if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.NOT_LIMIT.getValue())) {
            DynamicObjectCollection areaEntry = assessForm.getDynamicObjectCollection("areaconfentry");
            List plusMinusList = areaEntry.stream().filter(entry -> AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(entry.getDynamicObject("areareg").getPkValue())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(plusMinusList)) {
                Long areaConf = ((DynamicObject)plusMinusList.get(0)).getLong("areaconf");
                DynamicObject plusMinusConfigDy = ASSESS_RULE_APP_SERVICE.queryPlusMinusConfigByPk(areaConf);
                BigDecimal maxScore = scoresystem.getBigDecimal("maxscore").add(plusMinusConfigDy.getBigDecimal("pluslimit"));
                BigDecimal minScore = scoresystem.getBigDecimal("minscore").add(plusMinusConfigDy.getBigDecimal("minuslimit"));
                pageCache.put("maxscore", maxScore.toString());
                pageCache.put("minscore", minScore.toString());
            } else {
                pageCache.put("maxscore", scoresystem.getString("maxscore"));
                pageCache.put("minscore", scoresystem.getString("minscore"));
            }
        }
        ObjEvaluationUtils.ExtPointSetScope(assessForm, this.getView());
    }

    private void setDefualtScoreRange() {
        this.getView().getPageCache().put("maxscore", "0");
        this.getView().getPageCache().put("minscore", "0");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IPageCache pageCache = this.getView().getPageCache();
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        pageCache.put("dataChanged", this.getModel().getDataChanged() ? "1" : "0");
        if ("scorefield".equals(propertyName)) {
            boolean validateFlage;
            BigDecimal score = (BigDecimal)changeData.getNewValue();
            if (null == score) {
                return;
            }
            String validateScoreFlag = pageCache.get("validateScoreFlag");
            if (StringUtils.isNotEmpty((CharSequence)validateScoreFlag) && StringUtils.equals((CharSequence)validateScoreFlag, (CharSequence)"1")) {
                pageCache.remove("validateScoreFlag");
            }
            String numaccuracy = pageCache.get("numaccuracy");
            String scaletype = pageCache.get("scaletype");
            String levelVisibleFlag = pageCache.get("levelVisibleFlag");
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)numaccuracy)) {
                score = score.setScale(Integer.parseInt(numaccuracy), org.apache.commons.lang3.StringUtils.equals((CharSequence)scaletype, (CharSequence)"10") ? 0 : (org.apache.commons.lang3.StringUtils.equals((CharSequence)scaletype, (CharSequence)"20") ? 1 : 4));
            }
            if (!(validateFlage = this.valiateScoreByScoreRange(score, true))) {
                return;
            }
            String isMappinng = pageCache.get("isMappinng");
            boolean isConvertLevelByScore = EvalObjUtils.requireLevelAndScoreParam((String)"isConvertLevelByScore");
            if ("1".equals(isMappinng) && isConvertLevelByScore && (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)levelVisibleFlag) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)levelVisibleFlag, (CharSequence)"1"))) {
                String levelPk = ASSESS_FORM_DOMAIN_SERVICE.requireLevelPk(Long.valueOf(Long.parseLong(pageCache.get("assessFormId"))), (BigDecimal)e.getChangeSet()[0].getNewValue());
                this.getView().getModel().setValue("levelfield", (Object)levelPk);
            }
            this.getView().getModel().setValue("scorefield", (Object)score);
        }
    }

    private boolean checkScore(String levelVisibleFlag) {
        BigDecimal score = (BigDecimal)this.getView().getModel().getValue("scorefield");
        if (null == score) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ee9\u6548\u8bc4\u4f30\u5f97\u5206", (String)"EvaluateSetResultPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String level = (String)this.getView().getModel().getValue("levelfield");
        boolean isValidateLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isValidateLevel");
        if (isValidateLevel && null == level && (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)levelVisibleFlag) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)levelVisibleFlag, (CharSequence)"1"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ee9\u6548\u8bc4\u4f30\u7b49\u7ea7", (String)"EvaluateSetResultPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return this.valiateScoreByScoreRange(score, false);
    }

    private boolean valiateScoreByScoreRange(BigDecimal score, boolean isFromChange) {
        BigDecimal minscoreBig;
        IPageCache pageCache = this.getView().getPageCache();
        String maxscore = pageCache.get("maxscore");
        BigDecimal maxscoreBig = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)maxscore) ? BigDecimal.ZERO : new BigDecimal(maxscore);
        String minscore = pageCache.get("minscore");
        BigDecimal bigDecimal = minscoreBig = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)minscore) ? BigDecimal.ZERO : new BigDecimal(minscore);
        if (score.compareTo(minscoreBig) >= 0 && score.compareTo(maxscoreBig) <= 0) {
            return Boolean.TRUE;
        }
        if (isFromChange) {
            return Boolean.FALSE;
        }
        pageCache.put("validateScoreFlag", "1");
        this.getView().showErrorNotification(String.format("%s%s~%s\u3002", ResManager.loadKDString((String)"\u201c\u7ee9\u6548\u8bc4\u4f30\u5f97\u5206\u201d\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a", (String)"EvaluateSetResultPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]), minscoreBig.stripTrailingZeros().toPlainString(), maxscoreBig.stripTrailingZeros().toPlainString()));
        return Boolean.FALSE;
    }

    private boolean checkCalcMustInput(String ... keys) {
        boolean checkFlag = true;
        for (String key : keys) {
            FieldTip nameTip;
            if (this.getControl(key).isInvisible()) continue;
            if (HRObjectUtils.isEmpty((Object)this.getModel().getValue(key))) {
                nameTip = this.showValidaTip(false, ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"EvaluateSetResultPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), key);
                checkFlag = false;
            } else {
                nameTip = this.showValidaTip(true, null, key);
            }
            this.getView().showFieldTip(nameTip);
        }
        return checkFlag;
    }

    private FieldTip showValidaTip(boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
        }
        return fieldTip;
    }
}

