/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.evaluated;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.AssessRuleApplicationService;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssignManagerApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.assessform.entityservice.AssessFormEntityService;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.ExecuteSchemeEntityService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.assessrule.EvaSumLimit;
import kd.opmc.epa.formplugin.web.utils.EvalObjectVaildatorUtil;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.epa.formplugin.web.utils.permission.ProcessExecutePermissionUtils;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;

public class InputEvalObjEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener,
ItemClickListener {
    private static final AssessRuleApplicationService ASSESS_RULE_APP_SERVICE = AssessRuleApplicationService.getInstance();
    private static final AssessObjectApplicationService ASSESS_OBJECT = AssessObjectApplicationService.getInstance();
    private static final AssignManagerApplicationService ASSIGN_MANAGER_APPLICATION_SERVICE = AssignManagerApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();
    private static final ExecuteSchemeEntityService EXECUTE_SCHEME_ENTITY = ExecuteSchemeEntityService.getInstance();
    private static final AssessFormEntityService ASSESS_FORM_ENTITY_SERVICE = AssessFormEntityService.getInstance();
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();
    private static final String PERF_FILE_F7 = "perffilef7";
    private static final String GROUP_F7 = "groupf7";
    private static final String ADD_ASSESS_OBJECT = "addassessobject";
    private static final String ASSESS_OBJECT_ENTRY_ENTITY = "assessobjectentryentity";
    private static final String EMPENTRYENTITY = "empentryentity";
    private static final String SET_GROUP = "setgroup";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit perffileF7 = (BasedataEdit)this.getView().getControl(PERF_FILE_F7);
        BasedataEdit group = (BasedataEdit)this.getView().getControl("group");
        group.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        group.addAfterF7SelectListener((AfterF7SelectListener)this);
        perffileF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        perffileF7.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long activityId = (Long)parameter.getCustomParam("activity");
        if (Objects.isNull(activityId)) {
            return;
        }
        DynamicObject atcivityDy = ACTIVITY_ENTITY_SERVICE.queryAssessFormByActivity(activityId);
        if (Objects.isNull(atcivityDy)) {
            this.setDefualtScoreRange();
            return;
        }
        Long assessFormId = atcivityDy.getLong("assessform.id");
        DynamicObject assessForm = ASSESS_FORM_ENTITY_SERVICE.queryAssessFormByPk(assessFormId);
        if (Objects.isNull(assessForm)) {
            this.setDefualtScoreRange();
            return;
        }
        this.isScoreMappingLeval(assessFormId);
        this.setScoreRange2PageCache(assessForm);
        this.setScoreAndLevelStyle(assessForm);
    }

    private void isScoreMappingLeval(Long assessFormId) {
        IPageCache pageCache = this.getView().getPageCache();
        boolean isMappinng = ASSESS_FORM_DOMAIN_SERVICE.isScoreMappingLeval(assessFormId);
        pageCache.put("isMappinng", isMappinng ? "1" : "0");
    }

    private void setScoreAndLevelStyle(DynamicObject assessForm) {
        DecimalEdit decimalEdit = (DecimalEdit)this.getControl("scorefield");
        decimalEdit.setMustInput(true);
        IPageCache pageCache = this.getView().getPageCache();
        FieldEdit combofield = (FieldEdit)this.getControl("levelfield");
        boolean isValidateLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isValidateLevel");
        if (isValidateLevel) {
            combofield.setMustInput(true);
            pageCache.put("levelMust", "1");
        } else {
            combofield.setMustInput(false);
            pageCache.put("levelMust", "0");
        }
        boolean isVisibleLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isVisibleLevel");
        DynamicObject sumperflevel = assessForm.getDynamicObject("sumperflevel");
        if (Objects.isNull(sumperflevel) || !isVisibleLevel) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"levelfield"});
            combofield.setMustInput(false);
            pageCache.put("levelMust", "0");
            return;
        }
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle(sumperflevel.getPkValue());
        this.genaratePerfLevelSelect(sumPerfLevel);
    }

    private void genaratePerfLevelSelect(DynamicObject sumPerfLevel) {
        DynamicObjectCollection entryentity = sumPerfLevel.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return;
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        for (DynamicObject entry : entryentity) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(entry.getPkValue()));
            item.setCaption(new LocaleString(entry.getString("levelname")));
            item.setValue(String.valueOf(entry.getPkValue()));
            combos.add(item);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("levelfield");
        comboEdit.setComboItems(combos);
    }

    private void setDefualtScoreRange() {
        this.getView().getPageCache().put("maxscore", "0");
        this.getView().getPageCache().put("minscore", "0");
    }

    private void setScoreRange2PageCache(DynamicObject assessForm) {
        IPageCache pageCache = this.getView().getPageCache();
        String numaccuracy = assessForm.getString("numaccuracy");
        pageCache.put("numaccuracy", numaccuracy);
        String scaletype = assessForm.getString("scaletype");
        pageCache.put("scaletype", scaletype);
        DynamicObject scoresystem = assessForm.getDynamicObject("scoresystem");
        String evaSumLimit = assessForm.getString("evasumlimit");
        String limitmaxscore = assessForm.getString("limitmaxscore");
        String limitminscore = assessForm.getString("limitminscore");
        pageCache.put("evaSumLimit", evaSumLimit);
        if (HRStringUtils.isEmpty((String)evaSumLimit) && Objects.isNull(scoresystem)) {
            this.setDefualtScoreRange();
            return;
        }
        pageCache.put("assessFormId", assessForm.getPkValue().toString());
        if (HRStringUtils.isEmpty((String)evaSumLimit) || HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.SUM_LIMIT.getValue())) {
            pageCache.put("maxscore", scoresystem.getString("maxscore"));
            pageCache.put("minscore", scoresystem.getString("minscore"));
        } else if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.APPOINT_SUM_LIMIT.getValue())) {
            pageCache.put("maxscore", limitmaxscore);
            pageCache.put("minscore", limitminscore);
        } else if (HRStringUtils.equals((String)evaSumLimit, (String)EvaSumLimit.NOT_LIMIT.getValue())) {
            DynamicObjectCollection areaEntry = assessForm.getDynamicObjectCollection("areaconfentry");
            List plusMinusList = areaEntry.stream().filter(entry -> AssessRuleConstants.PLUS_MINUS_AREA_PK.equals(entry.getDynamicObject("areareg").getPkValue())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(plusMinusList)) {
                Long areaConf = ((DynamicObject)plusMinusList.get(0)).getLong("areaconf");
                DynamicObject plusMinusConfigDy = ASSESS_RULE_APP_SERVICE.queryPlusMinusConfigByPk(areaConf);
                BigDecimal maxScore = scoresystem.getBigDecimal("maxscore").add(plusMinusConfigDy.getBigDecimal("pluslimit"));
                BigDecimal minScore = scoresystem.getBigDecimal("minscore").add(plusMinusConfigDy.getBigDecimal("minuslimit"));
                pageCache.put("maxscore", maxScore.toString());
                pageCache.put("minscore", minScore.toString());
            } else {
                pageCache.put("maxscore", scoresystem.getString("maxscore"));
                pageCache.put("minscore", scoresystem.getString("minscore"));
            }
        } else {
            this.setDefualtScoreRange();
        }
        ObjEvaluationUtils.ExtPointSetScope(assessForm, this.getView());
        this.initScoreRange();
    }

    private void initScoreRange() {
        IPageCache pageCache = this.getView().getPageCache();
        BigDecimal minscore = pageCache.get("minscore") == null ? BigDecimal.ZERO : new BigDecimal(pageCache.get("minscore"));
        BigDecimal maxscore = pageCache.get("maxscore") == null ? BigDecimal.ZERO : new BigDecimal(pageCache.get("maxscore"));
        Label totalnumlap = (Label)this.getControl("minlab");
        totalnumlap.setText(this.setNull2Zero(minscore));
        Label sucessnumlab = (Label)this.getControl("maxlab");
        sucessnumlab.setText(this.setNull2Zero(maxscore));
    }

    private String setNull2Zero(BigDecimal num) {
        return num.stripTrailingZeros().toPlainString();
    }

    private Map<Long, DynamicObject[]> getPerffileMapAndTableSetter(DynamicObject[] perffileList, TableValueSetter setter) {
        setter.addField("perffile", new Object[0]);
        setter.addField("group", new Object[0]);
        setter.addField("person", new Object[0]);
        setter.addField("empposorgrel", new Object[0]);
        setter.addField("employee", new Object[0]);
        setter.addField("levelfield", new Object[0]);
        HashMap<Long, DynamicObject[]> perffileMap = new HashMap<Long, DynamicObject[]>(16);
        for (DynamicObject dynamicObject : perffileList) {
            DynamicObject[] perffileMapInfo = new DynamicObject[3];
            perffileMapInfo[0] = dynamicObject.getDynamicObject("person");
            DynamicObjectCollection empentryentity = dynamicObject.getDynamicObjectCollection(EMPENTRYENTITY);
            if (CollectionUtils.isNotEmpty((Collection)empentryentity)) {
                perffileMapInfo[1] = ((DynamicObject)empentryentity.get(0)).getDynamicObject("empposorgrel");
            }
            perffileMap.put(dynamicObject.getLong("id"), perffileMapInfo);
            perffileMapInfo[2] = dynamicObject.getDynamicObject("employee");
        }
        return perffileMap;
    }

    private DynamicObject[] queryPerffileListByIds(List<Long> ids) {
        return ASSESS_OBJECT.getPerffileListByIds(ids);
    }

    public void addItemClickListeners(String ... keys) {
        super.addItemClickListeners(keys);
        this.addClickListeners(new String[]{SET_GROUP, ADD_ASSESS_OBJECT});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IPageCache pageCache = this.getView().getPageCache();
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("scorefield".equals(propertyName)) {
            boolean validateFlage;
            BigDecimal score = (BigDecimal)changeData.getNewValue();
            if (null == score) {
                return;
            }
            String numaccuracy = pageCache.get("numaccuracy");
            String scaletype = pageCache.get("scaletype");
            if (StringUtils.isNotEmpty((CharSequence)numaccuracy)) {
                score = score.setScale(Integer.parseInt(numaccuracy), StringUtils.equals((CharSequence)scaletype, (CharSequence)"10") ? 0 : (StringUtils.equals((CharSequence)scaletype, (CharSequence)"20") ? 1 : 4));
            }
            if (!(validateFlage = this.valiateScoreByScoreRange(score, changeData))) {
                return;
            }
            String levalMust = pageCache.get("levelMust");
            String isMappinng = pageCache.get("isMappinng");
            boolean isConvertLevelByScore = EvalObjUtils.requireLevelAndScoreParam((String)"isConvertLevelByScore");
            if ("1".equals(isMappinng) && isConvertLevelByScore && HRStringUtils.equals((String)levalMust, (String)"1")) {
                String levelPk = ASSESS_FORM_DOMAIN_SERVICE.requireLevelPk(Long.valueOf(Long.parseLong(pageCache.get("assessFormId"))), (BigDecimal)e.getChangeSet()[0].getNewValue());
                this.getView().getModel().setValue("levelfield", (Object)levelPk, changeData.getRowIndex());
            }
            this.getView().getModel().setValue("scorefield", (Object)score, changeData.getRowIndex());
        }
    }

    private boolean valiateScoreByScoreRange(BigDecimal score, ChangeData changeData) {
        BigDecimal minscoreBig;
        IPageCache pageCache = this.getView().getPageCache();
        String maxscore = pageCache.get("maxscore");
        BigDecimal maxscoreBig = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)maxscore) ? BigDecimal.ZERO : new BigDecimal(maxscore);
        String minscore = pageCache.get("minscore");
        BigDecimal bigDecimal = minscoreBig = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)minscore) ? BigDecimal.ZERO : new BigDecimal(minscore);
        if (score.compareTo(minscoreBig) >= 0 && score.compareTo(maxscoreBig) <= 0) {
            return Boolean.TRUE;
        }
        this.getView().showErrorNotification(String.format("%s%s~%s\u3002", ResManager.loadKDString((String)"\u201c\u7ee9\u6548\u8bc4\u4f30\u5f97\u5206\u201d\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a", (String)"InputEvalObjEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), minscoreBig.stripTrailingZeros().toPlainString(), maxscoreBig.stripTrailingZeros().toPlainString()));
        return Boolean.FALSE;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "joinin": {
                this.checkAssessObjectForSave(args);
                break;
            }
            case "addassessobject": {
                this.createPerffileF7Select();
                break;
            }
            case "setgroup": {
                this.createGroupF7Select();
                break;
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void checkAssessObjectForSave(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection assessObject = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)assessObject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u8bf7\u6dfb\u52a0\u6570\u636e", (String)"InputEvalObjEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        this.getModel().setDataChanged(false);
        boolean actPerm = EvalObjUtils.checkActivityPermission((IFormView)this.getView());
        if (!actPerm) {
            args.setCancel(true);
            return;
        }
        IFormView parentView = this.getView().getParentView();
        boolean permission = ProcessExecutePermissionUtils.checkPermission(parentView);
        if (!permission) {
            this.getView().close();
            this.getView().sendFormAction(parentView);
            args.setCancel(true);
            return;
        }
        if (!this.checkScore()) {
            args.setCancel(true);
            return;
        }
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        boolean allSuccess = EvalObjectVaildatorUtil.checkEvalObjectWithInput(this.getView(), assessObject, activityId);
        if (!allSuccess) {
            args.setCancel(true);
        }
    }

    private boolean checkScore() {
        IPageCache pageCache = this.getView().getPageCache();
        String maxscore = pageCache.get("maxscore");
        BigDecimal maxscoreBig = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)maxscore) ? BigDecimal.ZERO : new BigDecimal(maxscore);
        String minscore = pageCache.get("minscore");
        BigDecimal minscoreBig = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)minscore) ? BigDecimal.ZERO : new BigDecimal(minscore);
        DynamicObject[] objEntryArrs = this.getEntryEntityDynamicObjectArrs();
        ArrayList<String> objMsgList = new ArrayList<String>();
        String levalMust = pageCache.get("levelMust");
        for (DynamicObject objEntry : objEntryArrs) {
            BigDecimal score = objEntry.getBigDecimal("scorefield");
            if (null == score) {
                String objMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199 {0}\uff08{1}\uff09\u7684\u7ee9\u6548\u8bc4\u4f30\u5f97\u5206", (String)"InputEvalObjEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{objEntry.getString("perffile.name"), objEntry.getString("perffile.billno"), minscoreBig.stripTrailingZeros().toPlainString(), maxscoreBig.stripTrailingZeros().toPlainString()});
                objMsgList.add(objMsg);
                continue;
            }
            if (score.compareTo(minscoreBig) < 0 || score.compareTo(maxscoreBig) > 0) {
                String objMsg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u7684\u201c\u7ee9\u6548\u8bc4\u4f30\u5f97\u5206\u201d\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{2}~{3}\u3002", (String)"InputEvalObjEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{objEntry.getString("perffile.name"), objEntry.getString("perffile.billno"), minscoreBig.stripTrailingZeros().toPlainString(), maxscoreBig.stripTrailingZeros().toPlainString()});
                objMsgList.add(objMsg);
                continue;
            }
            boolean isValidateLevel = EvalObjUtils.requireLevelAndScoreParam((String)"isValidateLevel");
            if (!isValidateLevel) continue;
            String level = objEntry.getString("levelfield");
            if (!HRStringUtils.equals((String)levalMust, (String)"1") || !HRStringUtils.isEmpty((String)level)) continue;
            String objMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199 {0}\uff08{1}\uff09\u7684\u7ee9\u6548\u8bc4\u4f30\u7b49\u7ea7", (String)"InputEvalObjEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{objEntry.getString("perffile.name"), objEntry.getString("perffile.billno")});
            objMsgList.add(objMsg);
        }
        if (objMsgList.size() > 0) {
            String checkMsg = String.join((CharSequence)"\r\n", objMsgList);
            this.getView().showErrorNotification(checkMsg);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private DynamicObject[] getEntryEntityDynamicObjectArrs() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ASSESS_OBJECT_ENTRY_ENTITY);
        EntryData entryData = entryGrid.getEntryData();
        String entryKey = entryData.getEntryKey();
        DynamicObject[] dataEntities = entryData.getDataEntitys();
        return dataEntities;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if ("joinin".equals(source.getOperateKey())) {
            this.savePerffile2AssessObject();
        }
    }

    private void savePerffile2AssessObject() {
        DynamicObjectCollection assessObject = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY);
        IListView parentView = (IListView)this.getView().getParentView();
        parentView.invokeOperation("refresh");
        this.getView().sendFormAction((IFormView)parentView);
    }

    private void createGroupF7Select() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ASSESS_OBJECT_ENTRY_ENTITY);
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"InputEvalObjEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        BasedataEdit assessRule = (BasedataEdit)this.getView().getControl(GROUP_F7);
        assessRule.click();
    }

    private void createPerffileF7Select() {
        BasedataEdit assessRule = (BasedataEdit)this.getView().getControl(PERF_FILE_F7);
        assessRule.click();
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        DynamicObject group2;
        String fieldKey = ((Control)evt.getSource()).getKey();
        if (PERF_FILE_F7.equals(fieldKey)) {
            DynamicObjectCollection perffileF7Selected = this.getModel().getDataEntity().getDynamicObjectCollection(PERF_FILE_F7);
            DynamicObjectCollection coll = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY);
            Set<Object> entryIds = null;
            entryIds = null == coll || coll.size() <= 0 || null == ((DynamicObject)coll.get(0)).getDynamicObject("perffile") ? new HashSet() : coll.stream().map(assessObject -> assessObject.getDynamicObject("perffile").getLong("id")).collect(Collectors.toSet());
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
            DynamicObjectCollection assgroupentry = activity.getDynamicObjectCollection("assgroupentry");
            DynamicObject[] assessGroup = (DynamicObject[])assgroupentry.stream().map(dy -> dy.getDynamicObject("assgroup")).toArray(DynamicObject[]::new);
            DynamicObject defaultAssessGroup = Arrays.stream(assessGroup).filter(group -> group.get("isdefault").equals(Boolean.TRUE)).findFirst().orElse(null);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter setter = new TableValueSetter(new String[0]);
            DynamicObject[] perffileList = this.queryPerffileListByIds(new ArrayList<Long>(10));
            Map<Long, DynamicObject[]> perffileMap = this.getPerffileMapAndTableSetter(perffileList, setter);
            IPageCache pageCache = this.getView().getPageCache();
            String levelPk = "";
            Long asseessGroupInit = null == assessGroup || assessGroup.length <= 0 ? null : Long.valueOf(assessGroup[0].getLong("id"));
            for (DynamicObject perffile : perffileF7Selected) {
                long id = perffile.getDynamicObject("fbasedataid").getLong("id");
                if (entryIds.contains(id)) continue;
                setter.addRow(new Object[]{perffile.getDynamicObject("fbasedataid").getLong("id"), HRObjectUtils.isEmpty((Object)defaultAssessGroup) ? asseessGroupInit.longValue() : defaultAssessGroup.getLong("id"), perffileMap.get(id)[0] != null ? Long.valueOf(perffileMap.get(id)[0].getLong("id")) : null, perffileMap.get(id)[1] != null ? Long.valueOf(perffileMap.get(id)[1].getLong("id")) : null, perffileMap.get(id)[2] != null ? Long.valueOf(perffileMap.get(id)[2].getLong("id")) : null, levelPk});
            }
            model.batchCreateNewEntryRow(ASSESS_OBJECT_ENTRY_ENTITY, setter);
            model.endInit();
            this.getView().updateView(ASSESS_OBJECT_ENTRY_ENTITY);
            this.getModel().setValue(PERF_FILE_F7, null);
        }
        if (GROUP_F7.equals(fieldKey)) {
            List<Long> groupIds;
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject(GROUP_F7);
            long groupId = dynamicObject.getLong("id");
            String pageId = this.getView().getParentView().getPageCache().get("epa_schememanagement");
            if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty(groupIds = this.getGroupIds()) && !groupIds.contains(groupId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762", (String)"InputEvalObjEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ASSESS_OBJECT_ENTRY_ENTITY);
            int[] rows = entryGrid.getSelectRows();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            for (int i = 0; i < rows.length; ++i) {
                this.getModel().setValue("group", (Object)groupId, rows[i]);
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"group"});
            }
            model.endInit();
            this.getView().updateView(ASSESS_OBJECT_ENTRY_ENTITY);
        }
        if ("group".equals(fieldKey) && (group2 = (DynamicObject)this.getModel().getValue("group")) != null) {
            this.getView().updateView(ASSESS_OBJECT_ENTRY_ENTITY);
        }
    }

    private Long getSchemeId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (Long)formShowParameter.getCustomParam("schemeId");
    }

    private DynamicObject getManagerData() {
        Long schemeId = this.getSchemeId();
        long sysUserId = RequestContext.get().getCurrUserId();
        return ASSIGN_MANAGER_APPLICATION_SERVICE.queryBySchmeIdAndUserId(schemeId, sysUserId);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if (HRStringUtils.isNotEmpty((String)fieldKey)) {
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            if (PERF_FILE_F7.equals(fieldKey)) {
                DynamicObject[] allJoinInList = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvaObjByActivityId(activityId);
                List joinInPerffileIds = Arrays.stream(allJoinInList).map(perffile -> perffile.getDynamicObject("perffile").getLong("id")).collect(Collectors.toList());
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                DynamicObjectCollection filteredEmptyObject = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY).stream().filter(org -> !HRObjectUtils.isEmpty((Object)org.getDynamicObject("perffile"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
                List emptyIds = filteredEmptyObject.stream().map(org -> org.getDynamicObject("perffile").getLong("id")).collect(Collectors.toList());
                joinInPerffileIds.addAll(emptyIds);
                if (CollectionUtils.isNotEmpty(joinInPerffileIds)) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", joinInPerffileIds).and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("archivesstatus", "=", (Object)"1")));
                } else {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("billstatus", "=", (Object)"C").and(new QFilter("archivesstatus", "=", (Object)"1")));
                }
            } else if (GROUP_F7.equals(fieldKey) || "group".equals(fieldKey)) {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                DynamicObject activity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
                DynamicObjectCollection col = activity.getDynamicObjectCollection("assgroupentry");
                List groupIds = col.stream().map(dy -> dy.getLong("assgroup.id")).collect(Collectors.toList());
                QFilter filter = new QFilter("id", "in", groupIds);
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }

    private void setFilterParameter(ListShowParameter showParameter) {
        List<Long> groupIds;
        String pageId = this.getView().getParentView().getPageCache().get("epa_schememanagement");
        if (StringUtils.isNotBlank((CharSequence)pageId) && pageId.contains("epa_schememanagement") && !ObjectUtils.isEmpty(groupIds = this.getGroupIds())) {
            QFilter filter = new QFilter("id", "in", groupIds);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private List<Long> getGroupIds() {
        boolean groupCheck;
        List<Long> groupIds = new ArrayList<Long>(10);
        DynamicObject manager = this.getManagerData();
        if (!ObjectUtils.isEmpty((Object)manager) && !(groupCheck = manager.getBoolean("isgroupcheck"))) {
            DynamicObjectCollection groups = manager.getDynamicObjectCollection("assessgroup");
            groupIds = groups.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
        }
        return groupIds;
    }
}

