/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.indicator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.domain.indicator.enums.AuditStatusEnum;
import kd.opmc.epa.business.domain.indicator.enums.ConfStatusEnum;
import kd.opmc.epa.business.domain.indicator.enums.InDStatusEnum;
import kd.opmc.epa.business.task.SubmitBatchIndicatorTask;
import kd.opmc.epa.common.utils.DispatchUtil;
import kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.IndicatorBatchMsgBindDataService;
import kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.impl.IndicatorBatchMsgBindDataServiceImpl;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRuSecondDomainService;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class IndicatorMsgBatchPlugin
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final String EPA_INDICATOR_BATCH_FILTER = "epa_indicator_batchfilter";
    private static final String EPA_INDICATOR_SINGLE = "epa_indicator_single";
    private static final String HAVE_FILTER_AP = "havefilterap";
    private static final String BTN_CANCEL = "btncancel";
    private static final String SELECT_CHECK_AP = "selectcheckap";
    private static final String BATCH_AP = "batchap";
    private static final String BATCH = "batch";
    private static final String BTN_BATCH = "btnbatch";
    private static final String CANCE = "cance";
    private static final String REFRESH_ENTRY = "refresh_entry";
    private static final String SINGLE_PERSON_AP = "singlepersonap";
    private static final String CHILDREN_PAGE = "children_page";
    private static final String CHILDREN_OBJ_ID = "children_objid";
    private static final String SUBMIT_TASK_CLOSE_BACK = "submit_task_close_back";
    private static final String CUSTOMCONTROLAP = "customcontrolap";
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final FlowRuSecondDomainService FLOW_RU_SECOND_DOMAIN_SERVICE = FlowRuSecondDomainService.getInstance();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"showleft"});
        this.initPersonCart(true);
        this.showFilterFrom();
        this.showBatchAp();
        this.showRollbackBtn();
        IndicatorBatchMsgBindDataServiceImpl indicatorBatchMsgBindDataService = new IndicatorBatchMsgBindDataServiceImpl();
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)indicatorBatchMsgBindDataService, IndicatorBatchMsgBindDataService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.IndicatorBatchMsgBindDataService#afterBindData", null);
        pluginProxy.callReplaceIfPresent(p -> p.afterBindData(e, this.getView()));
    }

    private void showBatchAp() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("personcartentity");
        if (entryEntity.isEmpty()) {
            return;
        }
        boolean isHide = true;
        for (DynamicObject dy : entryEntity) {
            String taskStatus = dy.getString("status");
            if (!"20".equals(taskStatus) && !"30".equals(taskStatus)) continue;
            isHide = false;
            break;
        }
        if (isHide) {
            this.getPageCache().put("is_batch", "");
            this.getView().setVisible(Boolean.valueOf(!isHide), new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP, BTN_BATCH});
            CardEntry cardEntry = (CardEntry)this.getView().getControl("personcartentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                cardEntry.setChildVisible(false, i, new String[]{"selectcheck"});
            }
        }
    }

    private void showRollbackBtn() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("personcartentity");
        if (entryEntity.isEmpty()) {
            return;
        }
        List taskIdList = entryEntity.stream().map(dy -> dy.getLong("taskid")).collect(Collectors.toList());
        Map taskIdIndexMap = FLOW_RU_PROC_APPLICATION_SERVICE.getTaskIdIndexMap(taskIdList);
        boolean isNotAllOne = false;
        for (Long taskId : taskIdList) {
            if ((Integer)taskIdIndexMap.get(taskId) == 1) continue;
            isNotAllOne = true;
            break;
        }
        if (!isNotAllOne) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rollback"});
        }
    }

    public void customEvent(CustomEventArgs e) {
        if (HRStringUtils.equals((String)e.getKey(), (String)CUSTOMCONTROLAP)) {
            this.getPageCache().put(CUSTOMCONTROLAP, e.getEventArgs());
            if (HRStringUtils.equals((String)e.getEventArgs(), (String)"false")) {
                this.openFilterView();
                this.reloadFilterView();
            } else {
                this.closeFilterView();
            }
        }
    }

    private void openFilterView() {
        this.getPageCache().put(CUSTOMCONTROLAP, "true");
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOMCONTROLAP);
        map.put("show", "true");
        map.put("date", new Date());
        customcontrol.setData(map);
    }

    private List<Map<String, Object>> getTaskList(Long batchTaskId) {
        QFilter taskStatusFilter = new QFilter("taskstatus", "in", Arrays.asList(FlowRuTaskStatusEnum.WAITING.getCode(), FlowRuTaskStatusEnum.PROCESSING.getCode(), FlowRuTaskStatusEnum.PROCESSED.getCode(), FlowRuTaskStatusEnum.RETURNED.getCode()));
        taskStatusFilter.and("handler", "=", (Object)RequestContext.get().getCurrUserId());
        return FLOW_RU_SECOND_DOMAIN_SERVICE.getBatchTaskDetails(batchTaskId, taskStatusFilter);
    }

    private List<Map<String, Object>> initTaskList() {
        List<Map<String, Object>> mapList;
        Object baseMaps = this.getView().getFormShowParameter().getCustomParam("maps");
        List maps = (List)SerializationUtils.deSerializeFromBase64((String)baseMaps.toString());
        if (maps != null && maps.size() > 0 && (mapList = maps.stream().filter(task -> HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)((String)task.get("taskStatus"))) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSING.getCode(), (String)((String)task.get("taskStatus")))).collect(Collectors.toList())).size() > 0) {
            this.getPageCache().put("has_default_filter", Boolean.TRUE.toString());
            this.getView().setVisible(Boolean.TRUE, new String[]{HAVE_FILTER_AP});
            return mapList;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{HAVE_FILTER_AP});
        return maps;
    }

    private void initPersonCart(boolean isInit) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String batchTaskId = (String)formShowParameter.getCustomParam("batchTaskId");
        String urlEvalObjId = (String)formShowParameter.getCustomParam("evalObjId");
        Long aLong = Long.valueOf(batchTaskId);
        List<Map<String, Object>> maps = null;
        IPageCache pageCache = this.getPageCache();
        if (isInit && HRStringUtils.isEmpty((String)pageCache.get("isinit"))) {
            maps = this.initTaskList();
            pageCache.put("isinit", Boolean.TRUE.toString());
        }
        if (ObjectUtils.isEmpty(maps)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{HAVE_FILTER_AP});
            maps = this.getTaskList(aLong);
        }
        if (maps == null || ObjectUtils.isEmpty(maps)) {
            this.getView().close();
            return;
        }
        List actEvaObjId = maps.stream().map(map -> (Long)map.get("actEvaObjId")).collect(Collectors.toList());
        List<Long> taskIds = maps.stream().map(ma -> (Long)ma.get("taskId")).collect(Collectors.toList());
        Map<Long, Long> typeMap = this.getTypeMap(taskIds);
        DynamicObject[] dynamicObjects = APPLICATION_SERVICE.queryById("person", actEvaObjId);
        dynamicObjects = this.sortArrayIndex(dynamicObjects, urlEvalObjId);
        Map mapMap = maps.stream().collect(Collectors.toMap(data -> data.get("actEvaObjId"), Function.identity()));
        IDataModel model = this.getModel();
        model.deleteEntryData("personcartentity");
        model.batchCreateNewEntryRow("personcartentity", dynamicObjects.length);
        int row = 0;
        for (int index = 0; index < dynamicObjects.length; ++index) {
            model.setValue("person", (Object)dynamicObjects[index].getLong("person.id"), index);
            long objId = dynamicObjects[index].getLong("id");
            model.setValue("evalobj", (Object)objId, index);
            Map evaObjId = (Map)mapMap.get(objId);
            if (evaObjId != null) {
                model.setValue("taskid", evaObjId.get("taskId"), index);
                this.setStatus(model, evaObjId, index, typeMap);
            }
            model.setValue("headsculpture", (Object)HRImageUrlUtil.getImageFullUrl((String)String.valueOf(dynamicObjects[index].getString("person.headsculpture"))), index);
        }
        this.getView().updateView("personcartentity");
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP});
        this.setBatch("0");
        this.selectPerson(row);
    }

    private DynamicObject[] sortArrayIndex(DynamicObject[] dynamicObjects, String urlEvalObjId) {
        if (HRStringUtils.isEmpty((String)urlEvalObjId)) {
            return dynamicObjects;
        }
        int size = dynamicObjects.length;
        int row = 0;
        for (int index = 0; index < size; ++index) {
            long objId = dynamicObjects[index].getLong("id");
            if (objId != Long.parseLong(urlEvalObjId)) continue;
            row = index;
            break;
        }
        if (row == 0) {
            return dynamicObjects;
        }
        DynamicObject targetDy = dynamicObjects[row];
        for (int index = row; index > 0; --index) {
            dynamicObjects[index] = dynamicObjects[index - 1];
        }
        dynamicObjects[0] = targetDy;
        return dynamicObjects;
    }

    private void initFilterValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String batchTaskId = (String)formShowParameter.getCustomParam("batchTaskId");
        Long aLong = Long.valueOf(batchTaskId);
        List<Map<String, Object>> maps = this.getTaskList(aLong);
        List actEvaObjId = maps.stream().map(map -> (Long)map.get("actEvaObjId")).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = APPLICATION_SERVICE.queryById("id,affiliateadminorg,person,empposrel,empposrel.position,empposrel.job", actEvaObjId);
        ArrayList<Long> orgId = new ArrayList<Long>(16);
        ArrayList<Long> jobId = new ArrayList<Long>(16);
        ArrayList<Long> positionId = new ArrayList<Long>(16);
        ArrayList<String> allTaskStatus = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            orgId.add(dynamicObject.getLong("affiliateadminorg.id"));
            positionId.add(dynamicObject.getLong("empposrel.position.id"));
            jobId.add(dynamicObject.getLong("empposrel.job.id"));
            long objId = dynamicObject.getLong("id");
            Map evaObjId = maps.stream().filter(map -> HRObjectUtils.equals(map.get("actEvaObjId"), (Object)objId)).findFirst().orElse(null);
            if (evaObjId == null) continue;
            String taskStatus = (String)evaObjId.get("taskStatus");
            allTaskStatus.add(taskStatus);
        }
        IPageCache pageCache = this.getPageCache();
        pageCache.put("orgId", SerializationUtils.toJsonString(orgId));
        pageCache.put("jobId", SerializationUtils.toJsonString(jobId));
        pageCache.put("positionId", SerializationUtils.toJsonString(positionId));
        pageCache.put("allTaskStatus", SerializationUtils.toJsonString(allTaskStatus.stream().distinct().collect(Collectors.toList())));
    }

    private void setStatus(IDataModel model, Map<String, Object> evaObjId, int index, Map<Long, Long> typeMap) {
        String taskStatus = (String)evaObjId.get("taskStatus");
        Long taskId = (Long)evaObjId.get("taskId");
        Long typeId = typeMap.get(taskId);
        if (typeId.equals(NodeTypeConstants.INDICATOR_FORMULATE)) {
            this.setIndStatus(model, index, taskStatus);
        } else if (typeId.equals(NodeTypeConstants.INDICATOR_AUDIT)) {
            this.setAuditStatus(model, index, taskStatus);
        } else if (typeId.equals(NodeTypeConstants.INDICATOR_CONFIRM)) {
            this.setConfirmStatus(model, index, taskStatus);
        }
        model.setValue("status", (Object)taskStatus, index);
        model.setValue("nodetype", (Object)typeId, index);
    }

    private Map<Long, Long> getTypeMap(List<Long> taskIds) {
        return FLOW_RU_PROC_APPLICATION_SERVICE.queryDefNodeByTaskIds(taskIds);
    }

    private void setIndStatus(IDataModel model, int index, String taskStatus) {
        if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)taskStatus) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSING.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)InDStatusEnum.TO_INDICATOR.getStatusCode(), index);
        } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)InDStatusEnum.BACK_INDICATOR.getStatusCode(), index);
        } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSED.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)InDStatusEnum.DONE_INDICATOR.getStatusCode(), index);
        } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)InDStatusEnum.LOSE_INDICATOR.getStatusCode(), index);
        }
    }

    private void setAuditStatus(IDataModel model, int index, String taskStatus) {
        if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)taskStatus) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSING.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)AuditStatusEnum.TO_AUDIT.getStatusCode(), index);
        } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)AuditStatusEnum.BACK_AUDIT.getStatusCode(), index);
        } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSED.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)AuditStatusEnum.DONE_AUDIT.getStatusCode(), index);
        } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)AuditStatusEnum.LOSE_AUDIT.getStatusCode(), index);
        }
    }

    private void setConfirmStatus(IDataModel model, int index, String taskStatus) {
        if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)taskStatus) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSING.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)ConfStatusEnum.TO_CONFIRM.getStatusCode(), index);
        } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)ConfStatusEnum.BACK_AUDIT.getStatusCode(), index);
        } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSED.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)ConfStatusEnum.DONE_CONFIRM.getStatusCode(), index);
        } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)taskStatus)) {
            model.setValue("taskstatus", (Object)ConfStatusEnum.LOSE_CONFIRM.getStatusCode(), index);
        }
    }

    private void selectAll() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("personcartentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            model.setValue("selectcheck", model.getValue("selectall"), index);
        }
        this.getView().updateView("personcartentity");
    }

    private void isSelectAll() {
        int checkNum = 0;
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("personcartentity");
        for (DynamicObject dynamicObject : entryEntity) {
            if (!dynamicObject.getBoolean("selectcheck")) continue;
            ++checkNum;
        }
        model.setValue("selectall", (Object)(checkNum == entryEntity.size() ? 1 : 0));
        this.getView().updateView("personcartentity");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container cardEntry = (Container)this.getView().getControl("cardentrynumberlap");
        cardEntry.addClickListener((ClickListener)this);
        Container filterAp = (Container)this.getView().getControl(HAVE_FILTER_AP);
        filterAp.addClickListener((ClickListener)this);
        Container cardEntrySelect = (Container)this.getView().getControl("cardentryinfolap");
        cardEntrySelect.addClickListener((ClickListener)this);
        Vector filterVec = (Vector)this.getView().getControl("filtervectorap");
        filterVec.addClickListener((ClickListener)this);
        Container selectAllAp = (Container)this.getView().getControl("selectallap");
        selectAllAp.addClickListener((ClickListener)this);
        Container selectCheckAp = (Container)this.getView().getControl(SELECT_CHECK_AP);
        selectCheckAp.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"closeleft", "showleft", "closeleftvector", "showleftvector", "selectallap", SELECT_CHECK_AP});
    }

    private void showSingPerson(Long id, String taskId, Long nodeType, String taskStatus) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setPkId((Object)id);
        baseShowParameter.setCustomParam("taskId", (Object)taskId);
        String isBatch = this.getPageCache().get("is_batch");
        if ("true".equals(isBatch)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BATCH});
        }
        baseShowParameter.setCustomParam("is_batch", (Object)isBatch);
        baseShowParameter.setCustomParam("nodetype", (Object)nodeType);
        baseShowParameter.setCustomParam("taskstatus", (Object)taskStatus);
        baseShowParameter.setCustomParam("isCtrlPermission", (Object)Boolean.TRUE);
        baseShowParameter.setFormId(EPA_INDICATOR_SINGLE);
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.getOpenStyle().setTargetKey(SINGLE_PERSON_AP);
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)baseShowParameter);
        this.getPageCache().put(CHILDREN_PAGE, baseShowParameter.getPageId());
        this.getPageCache().put(CHILDREN_OBJ_ID, String.valueOf(id));
        this.getPageCache().put("taskId", taskId);
    }

    private void selectPerson(int row) {
        Map allPageCache = this.getPageCache().getAll();
        ArrayList<String> oldCache = new ArrayList<String>(16);
        if (!HRObjectUtils.isEmpty((Object)allPageCache)) {
            for (Map.Entry entry : allPageCache.entrySet()) {
                String cacheKey = (String)entry.getKey();
                if (!HRStringUtils.isNotEmpty((String)cacheKey) || !cacheKey.startsWith("indicatorMustInput_")) continue;
                oldCache.add(cacheKey);
            }
        }
        for (String string : oldCache) {
            this.getPageCache().remove(string);
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection dynamicObjectCollection = model.getEntryEntity("personcartentity");
        for (int index = 0; index < dynamicObjectCollection.size(); ++index) {
            model.setValue("select", (Object)"0", index);
        }
        model.setValue("select", (Object)"1", row);
        this.showSingPerson(((DynamicObject)dynamicObjectCollection.get(row)).getLong("evalobj.id"), ((DynamicObject)dynamicObjectCollection.get(row)).getString("taskid"), ((DynamicObject)dynamicObjectCollection.get(row)).getLong("nodetype"), ((DynamicObject)dynamicObjectCollection.get(row)).getString("taskstatus"));
        this.getView().updateView("personcartentity");
    }

    private void canCelSplitPage() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("personcartentity");
        entryGrid.setSplitPage(Boolean.FALSE.booleanValue());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("cardentryinfolap".equals(key) || "cardentrynumberlap".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("personcartentity");
            int[] rows = entryGrid.getSelectRows();
            if (rows.length > 0) {
                this.canCelSplitPage();
                this.selectPerson(rows[0]);
                this.initBatchPersonCart();
            }
        } else if ("filtervectorap".equals(key) || HAVE_FILTER_AP.equals(key)) {
            String filterPageStatus = this.getPageCache().get(CUSTOMCONTROLAP);
            if (HRStringUtils.equals((String)filterPageStatus, (String)"false")) {
                this.openFilterView();
                this.reloadFilterView();
            } else {
                this.closeFilterView();
            }
        } else if ("selectallap".equals(key)) {
            this.canCelSplitPage();
            this.selectAll();
        } else if (SELECT_CHECK_AP.equals(key)) {
            this.canCelSplitPage();
            this.isSelectAll();
        } else if ("showleft".equals(key) || "showleftvector".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"leftap", "closeleft"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"showleft"});
        } else if ("closeleft".equals(key) || "closeleftvector".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"leftap", "closeleft"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"showleft"});
        }
    }

    private void showFilterFrom() {
        String positionsStr;
        String jobsStr;
        String affIdsStr;
        String jobIdsStr;
        String positionIdStr;
        this.initFilterValue();
        IPageCache pageCache = this.getPageCache();
        FormShowParameter showParameter = new FormShowParameter();
        String orgIdStr = pageCache.get("orgId");
        if (!StringUtils.isEmpty((String)orgIdStr)) {
            List orgIds = JSONObject.parseArray((String)orgIdStr, Long.class);
            showParameter.setCustomParam("orgId", (Object)orgIds);
        }
        if (!StringUtils.isEmpty((String)(positionIdStr = pageCache.get("positionId")))) {
            List positionIds = JSONObject.parseArray((String)positionIdStr, Long.class);
            showParameter.setCustomParam("positionId", (Object)positionIds);
        }
        if (!StringUtils.isEmpty((String)(jobIdsStr = pageCache.get("jobId")))) {
            List Ids = JSONObject.parseArray((String)jobIdsStr, Long.class);
            showParameter.setCustomParam("jobId", (Object)Ids);
        }
        if (!StringUtils.isEmpty((String)(affIdsStr = pageCache.get("affiliateadminorg")))) {
            List Ids = JSONObject.parseArray((String)affIdsStr, Long.class);
            showParameter.setCustomParam("affiliateadminorg", (Object)Ids);
        }
        if (!StringUtils.isEmpty((String)(jobsStr = pageCache.get("job")))) {
            List Ids = JSONObject.parseArray((String)jobsStr, Long.class);
            showParameter.setCustomParam("job", (Object)Ids);
        }
        if (!StringUtils.isEmpty((String)(positionsStr = pageCache.get("position")))) {
            List Ids = JSONObject.parseArray((String)positionsStr, Long.class);
            showParameter.setCustomParam("position", (Object)Ids);
        }
        showParameter.setFormId(EPA_INDICATOR_BATCH_FILTER);
        showParameter.setShowTitle(false);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(CUSTOMCONTROLAP);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("elementId", CUSTOMCONTROLAP + this.getView().getPageId());
        showParameter.getOpenStyle().setCustParam(customParams);
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
        this.getView().getPageCache().put("filter_page", showParameter.getPageId());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (SUBMIT_TASK_CLOSE_BACK.equals(actionId) && !ObjectUtils.isEmpty((Object)returnData) && returnData instanceof Map) {
            Map resultMap = (Map)returnData;
            if (!resultMap.containsKey("taskinfo")) {
                return;
            }
            JSONObject taskInfo = JSONObject.parseObject((String)String.valueOf(resultMap.get("taskinfo")));
            JSONObject resultDate = JSONObject.parseObject((String)((String)taskInfo.get((Object)"data")));
            List msGs = (List)resultDate.get((Object)"msgList");
            Integer success = (Integer)resultDate.get((Object)"success");
            Integer fail = (Integer)resultDate.get((Object)"fail");
            Integer total = (Integer)resultDate.get((Object)"total");
            IFormView view = this.getView();
            String typeIdStr = this.getPageCache().get("nodeTypeId");
            Long typeId = HRStringUtils.isEmpty((String)typeIdStr) ? 0L : Long.parseLong(typeIdStr);
            String text = null;
            if (typeId.equals(NodeTypeConstants.INDICATOR_FORMULATE)) {
                text = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u63d0\u4ea4\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"IndicatorMsgBatchPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{total, success, fail});
            } else if (typeId.equals(NodeTypeConstants.INDICATOR_AUDIT)) {
                text = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u901a\u8fc7\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"IndicatorMsgBatchPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{total, success, fail});
            } else if (typeId.equals(NodeTypeConstants.INDICATOR_CONFIRM)) {
                text = ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u786e\u8ba4\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"IndicatorMsgBatchPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{total, success, fail});
            }
            view.showMessage(text, String.join((CharSequence)"\n", msGs), MessageTypes.Default);
            view.invokeOperation(REFRESH_ENTRY);
            view.sendFormAction(view);
        }
    }

    private void initBatchPersonCart() {
        if (HRStringUtils.isEmpty((String)this.getPageCache().get("is_batch"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BATCH});
            this.getView().updateView("personcartentity");
            this.setBatch("0");
            this.isHideChildrenSubmit();
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BATCH});
            this.setBatch("1");
            this.getPageCache().put("is_batch", Boolean.TRUE.toString());
            this.showBottomType();
            this.isHideChildrenSubmit();
        }
    }

    private void refreshBatchPersonCart() {
        Object[] dynamicObjects;
        this.canCelSplitPage();
        IPageCache pageCache = this.getPageCache();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String batchTaskId = (String)formShowParameter.getCustomParam("batchTaskId");
        Long aLong = Long.valueOf(batchTaskId);
        List<Map<String, Object>> maps = this.getTaskList(aLong);
        if (ObjectUtils.isEmpty(maps)) {
            this.getView().close();
            return;
        }
        String filterPage = pageCache.get("filter_page");
        IFormView filterView = this.getView().getView(filterPage);
        DynamicObject dataEntity = filterView.getModel().getDataEntity();
        String indStatus = dataEntity.getString("indstatus");
        List actEvaObjId = maps.stream().map(map -> (Long)map.get("actEvaObjId")).collect(Collectors.toList());
        if (HRStringUtils.isNotEmpty((String)indStatus)) {
            String[] strings = indStatus.split(",");
            ArrayList list = new ArrayList(strings.length);
            Collections.addAll(list, strings);
            List<String> inds = list.stream().filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(inds)) {
                DynamicObjectCollection personEntry = this.getModel().getEntryEntity("personcartentity");
                Long nodeType = ((DynamicObject)personEntry.get(0)).getLong("nodetype");
                ArrayList<String> status = new ArrayList<String>(16);
                this.setTaskStatus(inds, nodeType, status);
                if (!ObjectUtils.isEmpty(status)) {
                    actEvaObjId = maps.stream().filter(obj -> status.contains((String)obj.get("taskStatus"))).map(map -> (Long)map.get("actEvaObjId")).collect(Collectors.toList());
                }
            }
        }
        if (actEvaObjId.isEmpty()) {
            this.getPageCache().put("is_batch", "");
            filterView.invokeOperation("reset");
            this.getView().sendFormAction(filterView);
        }
        if (!ObjectUtils.isEmpty((Object[])(dynamicObjects = APPLICATION_SERVICE.queryById("id,affiliateadminorg,person,empposrel,empposrel.position,empposrel.job", actEvaObjId)))) {
            this.setCartEntryAndCache((DynamicObject[])dynamicObjects, maps);
        } else if (!ObjectUtils.isEmpty((Object)filterView)) {
            filterView.invokeOperation("nodata");
            this.getView().sendFormAction(filterView);
        }
    }

    private void reloadFilterView() {
        this.initFilterValue();
        IPageCache pageCache = this.getPageCache();
        String filterPage = pageCache.get("filter_page");
        IFormView filterView = this.getView().getView(filterPage);
        filterView.invokeOperation("loaddata");
        this.getView().sendFormAction(filterView);
    }

    private void setCartEntryAndCache(DynamicObject[] dynamicObjects, List<Map<String, Object>> maps) {
        DynamicObjectCollection jobs;
        DynamicObjectCollection positions;
        DynamicObjectCollection orGs;
        IPageCache pageCache = this.getPageCache();
        IDataModel model = this.getModel();
        String filterPage = pageCache.get("filter_page");
        IFormView filterView = this.getView().getView(filterPage);
        DynamicObject dataEntity = filterView.getModel().getDataEntity();
        List<DynamicObject> collect = Arrays.stream(dynamicObjects).collect(Collectors.toList());
        List<Object> inds = new ArrayList(16);
        String indStatus = dataEntity.getString("indstatus");
        if (HRStringUtils.isNotEmpty((String)indStatus)) {
            String[] strings = indStatus.split(",");
            ArrayList list = new ArrayList(strings.length);
            Collections.addAll(list, strings);
            inds = list.stream().filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty((Object)(orGs = dataEntity.getDynamicObjectCollection("affiliateadminorg")))) {
            List orgId = orGs.stream().map(org -> org.getLong("fbasedataid.id")).collect(Collectors.toList());
            collect = collect.stream().filter(dynamicObject -> orgId.contains(dynamicObject.getLong("affiliateadminorg.id"))).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty((Object)(positions = dataEntity.getDynamicObjectCollection("position")))) {
            List positionId = positions.stream().map(org -> org.getLong("fbasedataid.id")).collect(Collectors.toList());
            collect = collect.stream().filter(dynamicObject -> positionId.contains(dynamicObject.getLong("empposrel.position.id"))).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty((Object)(jobs = dataEntity.getDynamicObjectCollection("job")))) {
            List jobId = jobs.stream().map(org -> org.getLong("fbasedataid.id")).collect(Collectors.toList());
            collect = collect.stream().filter(dynamicObject -> jobId.contains(dynamicObject.getLong("empposrel.job.id"))).collect(Collectors.toList());
        }
        if (collect.size() > 0) {
            Boolean haveFilter = Boolean.FALSE;
            if (!ObjectUtils.isEmpty((Object)orGs)) {
                haveFilter = Boolean.TRUE;
                List orgId = orGs.stream().map(org -> org.getLong("fbasedataid.id")).collect(Collectors.toList());
                pageCache.put("affiliateadminorg", SerializationUtils.toJsonString(orgId));
            } else {
                pageCache.put("affiliateadminorg", null);
            }
            if (!ObjectUtils.isEmpty((Object)positions)) {
                haveFilter = Boolean.TRUE;
                List positionId = positions.stream().map(org -> org.getLong("fbasedataid.id")).collect(Collectors.toList());
                pageCache.put("position", SerializationUtils.toJsonString(positionId));
            } else {
                pageCache.put("position", null);
            }
            if (!ObjectUtils.isEmpty((Object)jobs)) {
                haveFilter = Boolean.TRUE;
                List jobId = jobs.stream().map(org -> org.getLong("fbasedataid.id")).collect(Collectors.toList());
                pageCache.put("job", SerializationUtils.toJsonString(jobId));
            } else {
                pageCache.put("job", null);
            }
            if (!ObjectUtils.isEmpty(inds)) {
                haveFilter = Boolean.TRUE;
                pageCache.put("indstatus", indStatus);
            } else {
                pageCache.put("indstatus", null);
            }
            this.setPersonEntry(maps, model, collect);
            this.selectPerson(0);
            this.closeFilterView();
            this.getView().setVisible(haveFilter, new String[]{HAVE_FILTER_AP});
        } else if (!ObjectUtils.isEmpty((Object)filterView)) {
            filterView.invokeOperation("nodata");
            this.getView().sendFormAction(filterView);
        }
        this.initBatchPersonCart();
        this.isSelectAll();
    }

    private void setPersonEntry(List<Map<String, Object>> maps, IDataModel model, List<DynamicObject> collect) {
        model.deleteEntryData("personcartentity");
        model.batchCreateNewEntryRow("personcartentity", collect.size());
        List<Long> taskIds = maps.stream().map(ma -> (Long)ma.get("taskId")).collect(Collectors.toList());
        Map<Long, Long> typeMap = this.getTypeMap(taskIds);
        for (int index = 0; index < collect.size(); ++index) {
            model.setValue("person", (Object)collect.get(index).getLong("person.id"), index);
            long objId = collect.get(index).getLong("id");
            model.setValue("evalobj", (Object)objId, index);
            Map evaObjId = maps.stream().filter(map -> HRObjectUtils.equals(map.get("actEvaObjId"), (Object)objId)).findFirst().orElse(null);
            if (evaObjId != null) {
                model.setValue("taskid", evaObjId.get("taskId"), index);
                this.setStatus(model, evaObjId, index, typeMap);
            }
            model.setValue("headsculpture", (Object)HRImageUrlUtil.getImageFullUrl((String)String.valueOf(collect.get(index).getString("person.headsculpture"))), index);
        }
    }

    private void setTaskStatus(List<String> inds, Long nodeType, List<String> status) {
        if (nodeType.equals(NodeTypeConstants.INDICATOR_FORMULATE)) {
            if (inds.contains(InDStatusEnum.TO_INDICATOR.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.WAITING.getCode());
                status.add(FlowRuTaskStatusEnum.PROCESSING.getCode());
            }
            if (inds.contains(InDStatusEnum.BACK_INDICATOR.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.RETURNED.getCode());
            }
            if (inds.contains(InDStatusEnum.DONE_INDICATOR.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.PROCESSED.getCode());
            }
            if (inds.contains(InDStatusEnum.LOSE_INDICATOR.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.EXPIRED.getCode());
            }
        } else if (nodeType.equals(NodeTypeConstants.INDICATOR_AUDIT)) {
            if (inds.contains(AuditStatusEnum.TO_AUDIT.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.WAITING.getCode());
                status.add(FlowRuTaskStatusEnum.PROCESSING.getCode());
            }
            if (inds.contains(AuditStatusEnum.BACK_AUDIT.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.RETURNED.getCode());
            }
            if (inds.contains(AuditStatusEnum.DONE_AUDIT.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.PROCESSED.getCode());
            }
            if (inds.contains(AuditStatusEnum.LOSE_AUDIT.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.EXPIRED.getCode());
            }
        } else if (nodeType.equals(NodeTypeConstants.INDICATOR_CONFIRM)) {
            if (inds.contains(ConfStatusEnum.TO_CONFIRM.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.WAITING.getCode());
                status.add(FlowRuTaskStatusEnum.PROCESSING.getCode());
            }
            if (inds.contains(ConfStatusEnum.DONE_CONFIRM.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.PROCESSED.getCode());
            }
            if (inds.contains(ConfStatusEnum.LOSE_CONFIRM.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.EXPIRED.getCode());
            }
            if (inds.contains(ConfStatusEnum.BACK_AUDIT.getStatusCode())) {
                status.add(FlowRuTaskStatusEnum.RETURNED.getCode());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        IPageCache pageCache = this.getPageCache();
        if (HRStringUtils.equals((String)operateKey, (String)"assindsubmit")) {
            this.assindSubmit(args);
        } else if (HRStringUtils.equals((String)operateKey, (String)"filter_cancel")) {
            this.closeFilterView();
        } else if (HRStringUtils.equals((String)operateKey, (String)"filter_reset")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{HAVE_FILTER_AP});
            pageCache.put("affiliateadminorg", null);
            pageCache.put("job", null);
            pageCache.put("position", null);
            pageCache.put("indstatus", null);
            this.initPersonCart(false);
            this.initBatchPersonCart();
            this.isSelectAll();
            this.closeFilterView();
        } else if (HRStringUtils.equals((String)operateKey, (String)"rollback")) {
            this.showRollBackConfirm(args);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"filter_confirm")) {
            this.confirmFilter();
        }
    }

    private void closeFilterView() {
        this.getPageCache().put(CUSTOMCONTROLAP, "false");
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOMCONTROLAP);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("show", "false");
        map.put("date", new Date());
        customcontrol.setData(map);
    }

    private void confirmFilter() {
        this.refreshBatchPersonCart();
    }

    private void assindSubmit(BeforeDoOperationEventArgs args) {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = billObj.getDynamicObjectCollection("personcartentity");
        List<Long> objIds = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getBoolean("selectcheck")).map(dyc -> dyc.getLong("evalobj.id")).collect(Collectors.toList());
        Map<Long, Long> taskMap = dynamicObjectCollection.stream().collect(Collectors.toMap(dyc -> dyc.getLong("evalobj.id"), dyc -> dyc.getLong("taskid")));
        if (ObjectUtils.isEmpty(objIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e", (String)"IndicatorMsgBatchPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String areaNum = this.getPageCache().get("area_num");
        HashMap indicatorMustInputMap = Maps.newHashMapWithExpectedSize((int)10);
        Map allPageCache = this.getPageCache().getAll();
        if (!HRObjectUtils.isEmpty((Object)allPageCache)) {
            for (Map.Entry pageCacheEntry : allPageCache.entrySet()) {
                String cacheKey = (String)pageCacheEntry.getKey();
                if (!HRStringUtils.isNotEmpty((String)cacheKey) || !cacheKey.startsWith("indicatorMustInput_")) continue;
                String value = (String)pageCacheEntry.getValue();
                indicatorMustInputMap.put(cacheKey, JSON.parseObject((String)value, List.class));
            }
        }
        if (HRStringUtils.isEmpty((String)areaNum) || indicatorMustInputMap.size() != Integer.parseInt(areaNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u6b63\u5728\u6e32\u67d3\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"IndicatorMsgBatchPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        this.validateDispatch(objIds, taskMap, indicatorMustInputMap);
    }

    private void showRollBackConfirm(BeforeDoOperationEventArgs args) {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = billObj.getDynamicObjectCollection("personcartentity");
        List taskIdList = dynamicObjectCollection.stream().filter(dynamicObject -> dynamicObject.getBoolean("selectcheck")).map(dyc -> dyc.getLong("taskid")).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(taskIdList) || taskIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e", (String)"IndicatorMsgBatchPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        StringBuilder taskIdsSB = new StringBuilder();
        for (Long taskId : taskIdList) {
            taskIdsSB.append(taskId).append(",");
        }
        String taskIdsStr = taskIdsSB.substring(0, taskIdsSB.length() - 1);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("batchTaskIds", (Object)taskIdsStr);
        showParameter.setFormId("epa_indicatorback_confirm");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (BATCH.equals(key)) {
            this.canCelSplitPage();
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_BATCH});
            this.setBatch("1");
            this.getPageCache().put("is_batch", Boolean.TRUE.toString());
            this.showBottomType();
            this.isHideChildrenSubmit();
        } else if (CANCE.equals(key)) {
            this.canCelSplitPage();
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CANCEL, SELECT_CHECK_AP, BATCH_AP});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_BATCH});
            this.getView().updateView("personcartentity");
            this.setBatch("0");
            this.getPageCache().put("is_batch", "");
            this.isHideChildrenSubmit();
        } else if (REFRESH_ENTRY.equals(key)) {
            this.canCelSplitPage();
            this.refreshBatchPersonCart();
        }
    }

    private void validateDispatch(List<Long> objIds, Map<Long, Long> taskMap, Map<String, List<String>> indicatorMustInputMap) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("evaluationObjectIds", SerializationUtils.serializeToBase64(objIds));
        params.put("taskMap", SerializationUtils.serializeToBase64(taskMap));
        params.put("indicatorMustInputMap", SerializationUtils.serializeToBase64(indicatorMustInputMap));
        String kdString = ResManager.loadKDString((String)"\u6307\u6807\u5236\u5b9a", (String)"IndicatorMsgBatchPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        DispatchUtil.dispatch((AbstractFormPlugin)this, params, (String)SubmitBatchIndicatorTask.class.getName(), (String)kdString, (boolean)false, (String)SUBMIT_TASK_CLOSE_BACK);
    }

    private void isHideChildrenSubmit() {
        String pageId = this.getPageCache().get(CHILDREN_PAGE);
        String isBatch = this.getPageCache().get("is_batch");
        IFormView view = this.getView().getView(pageId);
        if (!ObjectUtils.isEmpty((Object)view)) {
            boolean isCanOperation;
            String taskStatus = (String)view.getFormShowParameter().getCustomParam("taskstatus");
            boolean bl = isCanOperation = HRObjectUtils.equals((Object)taskStatus, (Object)FlowRuTaskStatusEnum.WAITING.getCode()) || HRObjectUtils.equals((Object)taskStatus, (Object)FlowRuTaskStatusEnum.PROCESSING.getCode());
            if (!HRStringUtils.isNotEmpty((String)isBatch) && isCanOperation) {
                view.setVisible(Boolean.TRUE, new String[]{"opreationap"});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"opreationap"});
            }
            this.getView().sendFormAction(view);
        }
        this.showBatchAp();
    }

    private void setBatch(String value) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("personcartentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            model.setValue("batchselect", (Object)value, index);
        }
        this.getView().updateView("personcartentity");
    }

    private void showBottomType() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"formulateap", "auditap", "confirmap"});
        String objId = this.getPageCache().get(CHILDREN_OBJ_ID);
        ArrayList<Long> objIds = new ArrayList<Long>(16);
        objIds.add(Long.valueOf(objId));
        Object[] billObjs = APPLICATION_SERVICE.queryById("formulateflow", objIds);
        if (HRArrayUtils.isEmpty((Object[])billObjs)) {
            return;
        }
        Object billObj = billObjs[0];
        long flowId = billObj.getLong("formulateflow.id");
        DynamicObject[] dynamicObjects = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcByEvaObjIds(objIds);
        List objects = Arrays.stream(dynamicObjects).filter(dynamicObject -> HRObjectUtils.equals((Object)dynamicObject.getLong("flowv.id"), (Object)flowId)).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(objects)) {
            DynamicObjectCollection entryEntity;
            long currentNode = ((DynamicObject)objects.get(0)).getLong("currentnode.id");
            if (currentNode != 0L) {
                this.getPageCache().put("currentNodeId", String.valueOf(currentNode));
                FlowRuNodeBo ruNodeInstance = FLOW_RU_PROC_APPLICATION_SERVICE.getRuNodeInstance(Long.valueOf(currentNode));
                DynamicObject flowDefNode = ruNodeInstance.getFlowDefNode();
                String entrySeq = flowDefNode.getString("entryseq");
                this.getPageCache().put("entryseq", entrySeq);
            }
            if (!ObjectUtils.isEmpty((Object)(entryEntity = this.getModel().getEntryEntity("personcartentity")))) {
                long taskId = ((DynamicObject)entryEntity.get(0)).getLong("taskid");
                Long typeId = FLOW_RU_PROC_APPLICATION_SERVICE.queryDefNodeByTaskId(Long.valueOf(taskId));
                if (typeId.equals(NodeTypeConstants.INDICATOR_FORMULATE)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"formulateap"});
                } else if (typeId.equals(NodeTypeConstants.INDICATOR_AUDIT)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"auditap"});
                } else if (typeId.equals(NodeTypeConstants.INDICATOR_CONFIRM)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"confirmap"});
                }
                this.getPageCache().put("nodeTypeId", String.valueOf(typeId));
            }
        }
    }
}

