/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.indicator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.task.RollbackBatchIndicatorTask;
import kd.opmc.epa.common.utils.DispatchUtil;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowValidateResultBo;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;

public class IndicatorRollBackEdit
extends AbstractFormPlugin {
    private static final String ROLLBACK_TASK_CLOSE_BACK = "rollback_task_close_back";
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final String CHECK_EXPIRED = "checkExpired";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskIdStr = (String)formShowParameter.getCustomParam("taskId");
        if (HRStringUtils.isEmpty((String)taskIdStr)) {
            return;
        }
        Long taskId = Long.parseLong(taskIdStr);
        if (taskId != null && taskId != 0L) {
            DynamicObject task = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.getTask(taskId);
            int taskStatus = task.getInt("taskstatus");
            if (Integer.parseInt(FlowRuTaskStatusEnum.EXPIRED.getCode()) == taskStatus) {
                String text = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5904\u7406\u5931\u8d25\r\n\u5931\u8d25\u539f\u56e0\u53ef\u80fd\u6709\u4ee5\u4e0b2\u70b9\uff1a\r\n1\u3001\u8be5\u4efb\u52a1\u5df2\u88ab\u540c\u4e00\u5904\u7406\u89d2\u8272\u5904\u7406\u4eba\u5904\u7406\uff0c\u63d0\u4ea4\u5931\u6548\r\n2\u3001\u60a8\u5f53\u524d\u4efb\u52a1\u5904\u7406\u6743\u9650\u5df2\u88ab\u4fee\u6539", (String)"IndicatorRollBackEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(text, "", MessageTypes.Default, new ConfirmCallBackListener(CHECK_EXPIRED, (IFormPlugin)this));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean isOperationSuccess;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        boolean bl = isOperationSuccess = HRStringUtils.equals((String)operateKey, (String)"confirm") && !HRObjectUtils.isEmpty((Object)operationResult) && operationResult.isSuccess();
        if (isOperationSuccess) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String batchTaskIds = (String)parameter.getCustomParam("batchTaskIds");
            if (HRStringUtils.isEmpty((String)batchTaskIds)) {
                this.rollbackEvaTask();
            } else {
                this.batchRollback(args);
            }
        }
    }

    private void rollbackEvaTask() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskId = (String)formShowParameter.getCustomParam("taskId");
        if (HRStringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        Long taskIdLong = Long.parseLong(taskId);
        ArrayList<Long> taskList = new ArrayList<Long>(10);
        taskList.add(taskIdLong);
        String reason = this.getView().getModel().getDataEntity().getString("reason");
        FlowValidateResultBo resultBo = FLOW_RU_PROC_APPLICATION_SERVICE.batchRollbackTasks(taskList, reason);
        if (resultBo != null) {
            String resultBoCode = resultBo.getCode();
            if ("-1".equals(resultBoCode)) {
                if (HRStringUtils.equals((String)this.getView().getParentView().getFormShowParameter().getParentFormId(), (String)"epa_indicatorworkbench")) {
                    this.getView().getParentView().getParentView().showErrorNotification(resultBo.getMessage());
                } else {
                    this.getView().showTipNotification(resultBo.getMessage());
                }
            } else if ("1".equals(resultBoCode)) {
                Map validateMap = resultBo.getValidateMap();
                if (validateMap != null && !validateMap.isEmpty() && !HRStringUtils.isBlank((CharSequence)((CharSequence)validateMap.get(taskIdLong)))) {
                    String msg = (String)validateMap.get(taskIdLong);
                    this.getView().showTipNotification(msg);
                } else {
                    Long objId = (Long)formShowParameter.getCustomParam("objId");
                    APP_SERVICE.updateWeightAndIndctrScore(objId);
                    String tips = ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f", (String)"IndicatorRollBackEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                    this.getView().getParentView().showSuccessNotification(tips);
                    this.getView().getParentView().setStatus(OperationStatus.VIEW);
                    this.getView().getParentView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                    if (HRStringUtils.equals((String)this.getView().getParentView().getFormShowParameter().getParentFormId(), (String)"epa_indicatorworkbench")) {
                        this.getView().getParentView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f", (String)"IndicatorRollBackEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                        this.getView().getParentView().getParentView().invokeOperation("refresh_entry");
                        this.getView().sendFormAction(this.getView().getParentView().getParentView());
                    }
                    this.getView().close();
                }
            }
        }
    }

    private void batchRollback(AfterDoOperationEventArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String taskIdsStr = (String)formShowParameter.getCustomParam("batchTaskIds");
        String[] taskIds = taskIdsStr.split(",");
        List taskList = Arrays.stream(taskIds).map(taskIdStr -> Long.parseLong(taskIdStr)).collect(Collectors.toList());
        DynamicObject[] taskDys = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryTaskInfos(taskList);
        List<Long> objIds = Arrays.stream(taskDys).map(dyc -> dyc.getLong("flowruproc.actevalobj")).collect(Collectors.toList());
        Map<Long, Long> taskMap = Arrays.stream(taskDys).collect(Collectors.toMap(dyc -> dyc.getLong("flowruproc.actevalobj"), dyc -> dyc.getLong("id")));
        Map<Long, Long> objMap = Arrays.stream(taskDys).collect(Collectors.toMap(dyc -> dyc.getLong("id"), dyc -> dyc.getLong("flowruproc.actevalobj")));
        String reason = this.getView().getModel().getDataEntity().getString("reason");
        this.validateDispatch(objIds, taskMap, objMap, reason);
    }

    private void validateDispatch(List<Long> objIds, Map<Long, Long> taskMap, Map<Long, Long> objMap, String reason) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("evaluationObjectIds", SerializationUtils.serializeToBase64(objIds));
        params.put("taskMap", SerializationUtils.serializeToBase64(taskMap));
        params.put("objMap", SerializationUtils.serializeToBase64(objMap));
        params.put("reason", reason);
        String kdString = ResManager.loadKDString((String)"\u6307\u6807\u5236\u5b9a", (String)"IndicatorRollBackEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        DispatchUtil.dispatch((AbstractFormPlugin)this, params, (String)RollbackBatchIndicatorTask.class.getName(), (String)kdString, (boolean)false, (String)ROLLBACK_TASK_CLOSE_BACK);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (!ObjectUtils.isEmpty((Object)returnData) && returnData instanceof Map) {
            Map resultMap = (Map)returnData;
            if (!resultMap.containsKey("taskinfo")) {
                return;
            }
            JSONObject taskInfo = JSONObject.parseObject((String)String.valueOf(resultMap.get("taskinfo")));
            JSONObject resultDate = JSONObject.parseObject((String)((String)taskInfo.get((Object)"data")));
            List msGs = (List)resultDate.get((Object)"msgList");
            Integer success = (Integer)resultDate.get((Object)"success");
            Integer fail = (Integer)resultDate.get((Object)"fail");
            Integer total = (Integer)resultDate.get((Object)"total");
            IFormView view = this.getView();
            view.showMessage(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u9000\u56de\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"IndicatorRollBackEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{total, success, fail}), String.join((CharSequence)"\n", msGs), MessageTypes.Default);
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(this.getView().getParentView());
            view.close();
            view.sendFormAction(view);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)CHECK_EXPIRED, (String)callBackId)) {
            if (HRStringUtils.equals((String)this.getView().getParentView().getFormShowParameter().getParentFormId(), (String)"epa_indicatorworkbench")) {
                this.getView().getParentView().getParentView().invokeOperation("refresh_entry");
                this.getView().sendFormAction(this.getView().getParentView().getParentView());
            } else {
                this.getView().getParentView().setStatus(OperationStatus.VIEW);
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
            }
        }
    }
}

