/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.indicator;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.mvc.list.ListView;
import kd.bos.openapi.common.util.Pair;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.application.service.indicator.IndicatorGroupApplicationService;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.assessrule.entityservice.EmpInfoConfigEntityService;
import kd.opmc.epa.business.domain.evaluating.entity.ContentAreaEntryEvaDto;
import kd.opmc.epa.business.domain.indicator.enums.AuditStatusEnum;
import kd.opmc.epa.business.domain.indicator.enums.ConfStatusEnum;
import kd.opmc.epa.business.domain.indicator.enums.InDStatusEnum;
import kd.opmc.epa.business.task.extpoint.SubmitBatchIndicatorResultService;
import kd.opmc.epa.business.task.extpoint.impl.SubmitBatchIndicatorResultServiceImpl;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.IndicatorSingleMsgBindDataService;
import kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.IndicatorSingleSubmitCheckService;
import kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.impl.IndicatorSingleMsgBindDataServiceImpl;
import kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.impl.IndicatorSingleSubmitCheckServiceImpl;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class IndicatorSingleEdit
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(IndicatorSingleEdit.class);
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActEvalObjManageDomainService ACTEVALOBJMANAGE_DOMAIN_SERVICE = ActEvalObjManageDomainService.getInstance();
    private static final EmpInfoConfigEntityService EMP_INFO_CONFIG_ENTITY_SERVICE = EmpInfoConfigEntityService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final IndicatorGroupApplicationService INDICATOR_GROUP_APPLICATION_SERVICE = IndicatorGroupApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final String MODIFY = "modify";
    private static final String PROCESS_AP = "processap";
    private static final String CHECK_EXPIRED = "checkExpired";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter parameter = e.getFormShowParameter();
        Object taskIdObj = parameter.getCustomParam("taskId");
        LOG.info("taskId: {}", taskIdObj);
        long taskId = 0L;
        if (!ObjectUtils.isEmpty((Object)taskIdObj)) {
            taskId = taskIdObj instanceof String ? Long.parseLong((String)taskIdObj) : (Long)taskIdObj;
            Pair checkResult = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.checkTaskInfo(Long.valueOf(taskId), ResManager.loadKDString((String)"\u5236\u5b9a", (String)"IndicatorSingleEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            if (!((Boolean)checkResult.getKey()).booleanValue()) {
                e.setCancel(true);
                e.setCancelMessage((String)checkResult.getValue());
                return;
            }
            DynamicObject task = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.processTaskAndGetTask(Long.valueOf(taskId));
            parameter.setCustomParam("flowrunodeId", (Object)task.getLong("flowrunode.id"));
            Map taskStatusMap = this.FLOW_RU_PROC_APPLICATION_SERVICE.getSubmitTaskStatus(Collections.singletonList(taskId));
            LOG.info("taskStatusMap:{}\uff1b taskId\uff1a{}\uff1b taskstatus\uff1a{}", new Object[]{taskStatusMap.toString(), taskId, taskStatusMap.get(taskId)});
            parameter.setCustomParam("taskstatus", taskStatusMap.get(taskId));
            parameter.setStatus(this.getViewStatusOfTask((String)taskStatusMap.get(taskId)));
        }
    }

    public OperationStatus getViewStatusOfTask(String taskStatus) {
        FlowRuTaskStatusEnum status = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatus);
        if (status == FlowRuTaskStatusEnum.PROCESSING) {
            return OperationStatus.EDIT;
        }
        return OperationStatus.VIEW;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry indPeriodEntry = (CardEntry)this.getView().getControl("indperiodentry");
        indPeriodEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"imptlap1"});
        this.addClickListeners(new String[]{"indguideap"});
        this.addClickListeners(new String[]{PROCESS_AP});
    }

    private void showIndicatorImportStartView() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObject dynamicObject = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)billObj.getLong("activity.id"));
        DynamicObject assessForm = APP_SERVICE.loadAssessForm((Object)dynamicObject.getLong("assessform.id"));
        if (assessForm == null || HRObjectUtils.isEmpty((Object)assessForm)) {
            return;
        }
        DynamicObject scoresystem = assessForm.getDynamicObject("scoresystem");
        String scoreCalcway = assessForm.getString("scorecalcway");
        BigDecimal maxScore = scoresystem.getBigDecimal("maxscore");
        BigDecimal minScore = scoresystem.getBigDecimal("minscore");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_objindimportstart");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("actevalObjid", this.getModel().getDataEntity().getPkValue());
        showParameter.setCustomParam("numaccuracy", (Object)assessForm.getString("numaccuracy"));
        showParameter.setCustomParam("scorecalcway", (Object)scoreCalcway);
        showParameter.setCustomParam("maxscore", (Object)maxScore);
        showParameter.setCustomParam("minscore", (Object)minScore);
        showParameter.setCustomParam("isgroup", (Object)false);
        String from = (String)this.getView().getFormShowParameter().getCustomParam("from");
        showParameter.setCustomParam("from", (Object)from);
        this.getView().showForm(showParameter);
    }

    public void afterBindData(EventObject e) {
        Long taskId;
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        Image image = (Image)this.getView().getControl("headsculpture");
        image.setUrl(HRImageUrlUtil.getImageFullUrl((String)String.valueOf(dataEntity.getString("person.headsculpture"))));
        if (HRObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("empposrel")) || HRObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("empposrel.position"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"positionname"});
        }
        Label nameLabel = (Label)this.getControl("name");
        Label numberLabel = (Label)this.getControl("number");
        nameLabel.setText(dataEntity.getString("perffile.name"));
        numberLabel.setText(dataEntity.getString("perffile.billno"));
        this.showBottomType();
        this.showAssTableView();
        this.selectIndPeriodOfFirst();
        this.setTabTitle();
        this.addIndicatorPeriod(Collections.singletonList(model.getDataEntity().getLong("activity.id")));
        this.setBottomCenter();
        this.setTaskStatus();
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"imptlap1"});
        }
        if ((taskId = this.getTaskId()) != null) {
            this.getPageCache().put("taskId", String.valueOf(this.getTaskId()));
        }
        IndicatorSingleMsgBindDataServiceImpl indicatorSingleMsgBindDataService = new IndicatorSingleMsgBindDataServiceImpl();
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)indicatorSingleMsgBindDataService, IndicatorSingleMsgBindDataService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.IndicatorSingleMsgBindDataService#afterBindData", null);
        pluginProxy.callReplaceIfPresent(p -> p.afterBindData(e, this.getView()));
    }

    public void beforeBindData(EventObject e) {
        Object indGroup;
        String billFormId;
        super.beforeBindData(e);
        this.setMutex(this.getTaskId());
        this.showLocked();
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView && (HRStringUtils.equals((String)(billFormId = ((ListView)parentView).getBillFormId()), (String)"epa_targetformulated") || HRStringUtils.equals((String)billFormId, (String)"epa_tobetargetformulate"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"processflexpanelap"});
        }
        if (HRObjectUtils.isEmpty((Object)(indGroup = this.getModel().getDataEntity().get("indigroup")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"indguideap"});
        }
    }

    private void setTaskStatus() {
        Long taskId = this.getTaskId();
        if (!HRObjectUtils.isEmpty((Object)taskId)) {
            Map taskStatusMap = this.WORK_FLOW_APPLICATION_SERVICE.queryTasksStatusByIds(Collections.singletonList(taskId));
            LOG.info("setTaskStatus taskStatusMap:{}\uff1b taskId\uff1a{}\uff1b taskstatus\uff1a{}", new Object[]{taskStatusMap.toString(), taskId, taskStatusMap.get(taskId)});
            String taskStatus = (String)taskStatusMap.get(taskId);
            Long typeId = this.getNodeType(taskId);
            Label status = (Label)this.getControl("taskstatus");
            if (status == null) {
                return;
            }
            if (typeId.equals(NodeTypeConstants.INDICATOR_FORMULATE)) {
                if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)taskStatus) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSING.getCode(), (String)taskStatus)) {
                    status.setText(InDStatusEnum.TO_INDICATOR.getName());
                    this.setTaskStatusStyles(InDStatusEnum.TO_INDICATOR.getColor(), InDStatusEnum.TO_INDICATOR.getBgColor(), InDStatusEnum.TO_INDICATOR.getBorderColor());
                } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)taskStatus)) {
                    status.setText(InDStatusEnum.BACK_INDICATOR.getName());
                    this.setTaskStatusStyles(InDStatusEnum.BACK_INDICATOR.getColor(), InDStatusEnum.BACK_INDICATOR.getBgColor(), InDStatusEnum.BACK_INDICATOR.getBorderColor());
                } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSED.getCode(), (String)taskStatus)) {
                    status.setText(InDStatusEnum.DONE_INDICATOR.getName());
                    this.setTaskStatusStyles(InDStatusEnum.DONE_INDICATOR.getColor(), InDStatusEnum.DONE_INDICATOR.getBgColor(), InDStatusEnum.DONE_INDICATOR.getBorderColor());
                } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)taskStatus)) {
                    status.setText(InDStatusEnum.LOSE_INDICATOR.getName());
                    this.setTaskStatusStyles(InDStatusEnum.LOSE_INDICATOR.getColor(), InDStatusEnum.LOSE_INDICATOR.getBgColor(), InDStatusEnum.LOSE_INDICATOR.getBorderColor());
                }
            } else if (typeId.equals(NodeTypeConstants.INDICATOR_AUDIT)) {
                if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)taskStatus) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSING.getCode(), (String)taskStatus)) {
                    status.setText(AuditStatusEnum.TO_AUDIT.getName());
                    this.setTaskStatusStyles(AuditStatusEnum.TO_AUDIT.getColor(), AuditStatusEnum.TO_AUDIT.getBgColor(), AuditStatusEnum.TO_AUDIT.getBorderColor());
                } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)taskStatus)) {
                    status.setText(AuditStatusEnum.BACK_AUDIT.getName());
                    this.setTaskStatusStyles(AuditStatusEnum.BACK_AUDIT.getColor(), AuditStatusEnum.BACK_AUDIT.getBgColor(), AuditStatusEnum.BACK_AUDIT.getBorderColor());
                } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSED.getCode(), (String)taskStatus)) {
                    status.setText(AuditStatusEnum.DONE_AUDIT.getName());
                    this.setTaskStatusStyles(AuditStatusEnum.DONE_AUDIT.getColor(), AuditStatusEnum.DONE_AUDIT.getBgColor(), AuditStatusEnum.DONE_AUDIT.getBorderColor());
                } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)taskStatus)) {
                    status.setText(AuditStatusEnum.LOSE_AUDIT.getName());
                    this.setTaskStatusStyles(AuditStatusEnum.LOSE_AUDIT.getColor(), AuditStatusEnum.LOSE_AUDIT.getBgColor(), AuditStatusEnum.LOSE_AUDIT.getBorderColor());
                }
            } else if (typeId.equals(NodeTypeConstants.INDICATOR_CONFIRM)) {
                if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.WAITING.getCode(), (String)taskStatus) || HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSING.getCode(), (String)taskStatus)) {
                    status.setText(ConfStatusEnum.TO_CONFIRM.getName());
                    this.setTaskStatusStyles(ConfStatusEnum.TO_CONFIRM.getColor(), ConfStatusEnum.TO_CONFIRM.getBgColor(), ConfStatusEnum.TO_CONFIRM.getBorderColor());
                } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.PROCESSED.getCode(), (String)taskStatus)) {
                    status.setText(ConfStatusEnum.DONE_CONFIRM.getName());
                    this.setTaskStatusStyles(ConfStatusEnum.DONE_CONFIRM.getColor(), ConfStatusEnum.DONE_CONFIRM.getBgColor(), ConfStatusEnum.DONE_CONFIRM.getBorderColor());
                } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.EXPIRED.getCode(), (String)taskStatus)) {
                    status.setText(ConfStatusEnum.LOSE_CONFIRM.getName());
                    this.setTaskStatusStyles(ConfStatusEnum.LOSE_CONFIRM.getColor(), ConfStatusEnum.LOSE_CONFIRM.getBgColor(), ConfStatusEnum.LOSE_CONFIRM.getBorderColor());
                } else if (HRStringUtils.equals((String)FlowRuTaskStatusEnum.RETURNED.getCode(), (String)taskStatus)) {
                    status.setText(ConfStatusEnum.BACK_AUDIT.getName());
                    this.setTaskStatusStyles(ConfStatusEnum.BACK_AUDIT.getColor(), ConfStatusEnum.BACK_AUDIT.getBgColor(), ConfStatusEnum.BACK_AUDIT.getBorderColor());
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"assessstatusap", "labelap22"});
        }
    }

    private void setTaskStatusStyles(String foreColor, String bgColor, String borderColor) {
        HashMap<String, String> foreColorMap = new HashMap<String, String>(16);
        foreColorMap.put("fc", foreColor);
        this.getView().updateControlMetadata("taskstatus", foreColorMap);
        HashMap<String, String> bgColorMap = new HashMap<String, String>(16);
        bgColorMap.put("bc", bgColor);
        this.getView().updateControlMetadata("assessstatusap", bgColorMap);
        HashMap<String, String> borderMap = new HashMap<String, String>(16);
        borderMap.put("r", "1px_solid_" + borderColor);
        borderMap.put("l", "1px_solid_" + borderColor);
        borderMap.put("t", "1px_solid_" + borderColor);
        borderMap.put("b", "1px_solid_" + borderColor);
        HashMap<String, HashMap<String, String>> statusapMap = new HashMap<String, HashMap<String, String>>(16);
        statusapMap.put("b", borderMap);
        HashMap<String, HashMap<String, HashMap<String, String>>> styleMap = new HashMap<String, HashMap<String, HashMap<String, String>>>(16);
        styleMap.put("s", statusapMap);
        this.getView().updateControlMetadata("assessstatusap", styleMap);
    }

    private void setBottomCenter() {
        String formId;
        IFormView parentView = this.getView().getParentView();
        if (!HRObjectUtils.isEmpty((Object)parentView) && HRStringUtils.equals((String)(formId = parentView.getFormShowParameter().getFormId()), (String)"epa_indicatormsg")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttomcenter"});
        }
    }

    private void setTabTitle() {
        String billFormId;
        String name = this.getModel().getDataEntity().getString("perffile.name");
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView && (HRStringUtils.equals((String)(billFormId = ((ListView)parentView).getBillFormId()), (String)"epa_targetformulated") || HRStringUtils.equals((String)billFormId, (String)"epa_tobetargetformulate") || HRStringUtils.equals((String)billFormId, (String)"epa_targetformulating"))) {
            String title = ResManager.loadKDString((String)"\u6307\u6807\u5236\u5b9a-%s", (String)"IndicatorSingleEdit_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{name});
            this.getView().setFormTitle(new LocaleString(title));
        }
    }

    private void checkTaskStatus() {
        Long aLong = this.getTaskId();
        if (aLong == null) {
            return;
        }
        ArrayList<Long> taskIds = new ArrayList<Long>(16);
        taskIds.add(aLong);
        Map statusByIds = this.WORK_FLOW_APPLICATION_SERVICE.queryTasksStatusByIds(taskIds);
        String taskStatus = (String)statusByIds.get(aLong);
        if (HRObjectUtils.equals((Object)taskStatus, (Object)FlowRuTaskStatusEnum.WAITING.getCode()) || HRObjectUtils.equals((Object)taskStatus, (Object)FlowRuTaskStatusEnum.PROCESSING.getCode())) {
            LOG.info("*********************taskStatus: {} *****************", (Object)taskStatus);
        } else {
            LOG.info("########################taskStatus: {} ########################", (Object)taskStatus);
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"opreationap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttommarget"});
        }
    }

    private Long getTaskId() {
        if (ObjectUtils.isEmpty((Object)this.getView().getFormShowParameter())) {
            return null;
        }
        Object taskId = this.getView().getFormShowParameter().getCustomParam("taskId");
        LOG.info("taskId: {}", taskId);
        if (ObjectUtils.isEmpty((Object)taskId)) {
            return null;
        }
        long aLong = taskId instanceof String ? Long.parseLong((String)taskId) : (Long)taskId;
        return aLong;
    }

    private Long getFlowRuNodeId() {
        Long taskId = this.getTaskId();
        long flowRuNodeId = 0L;
        if (taskId != null && taskId != 0L) {
            Object flowruNodeObjId = this.getView().getFormShowParameter().getCustomParam("flowrunodeId");
            if (flowruNodeObjId != null) {
                flowRuNodeId = (Long)flowruNodeObjId;
            } else {
                DynamicObject taskDy = this.FLOW_RU_PROC_APPLICATION_SERVICE.getTaskById(taskId);
                flowRuNodeId = taskDy.getLong("flowrunode.id");
            }
        }
        return flowRuNodeId;
    }

    private void addIndicatorPeriod(List<Long> activityIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("indperiodentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("activitycart", new Object[0]);
        for (Long activityId : activityIds) {
            vs.addRow(new Object[]{activityId});
        }
        model.batchCreateNewEntryRow("indperiodentry", vs);
        this.getView().updateView("indperiodentry");
        model.endInit();
    }

    private void selectIndPeriodOfFirst() {
        DynamicObjectCollection indPeriodEntry = this.getModel().getEntryEntity("indperiodentry");
        if (!ObjectUtils.isEmpty((Object)indPeriodEntry)) {
            CardEntry assGroupCard = (CardEntry)this.getControl("indperiodentry");
            assGroupCard.selectCard(Integer.valueOf(0));
        } else {
            this.getView().getPageCache().remove("lastSelectRow");
        }
    }

    private Long initNodeType() {
        Long taskId = this.getTaskId();
        Long typeId = this.FLOW_RU_PROC_APPLICATION_SERVICE.queryDefNodeByTaskId(taskId);
        if (!ObjectUtils.isEmpty((Object)typeId)) {
            this.getPageCache().put("nodeTypeId", String.valueOf(typeId));
        }
        return typeId;
    }

    private Long getNodeType(Long taskId) {
        long typeId;
        String typeIdStr = this.getPageCache().get("nodeTypeId");
        if (HRStringUtils.isEmpty((String)typeIdStr)) {
            typeId = this.FLOW_RU_PROC_APPLICATION_SERVICE.queryDefNodeByTaskId(taskId);
            if (!ObjectUtils.isEmpty((Object)typeId)) {
                this.getPageCache().put("nodeTypeId", String.valueOf(typeId));
            }
        } else {
            typeId = Long.parseLong(typeIdStr);
        }
        return typeId;
    }

    private void showBottomType() {
        FormShowParameter formShowParameter;
        String customParam;
        this.getView().setVisible(Boolean.FALSE, new String[]{"formulateap", "auditap", "confirmap"});
        Long taskId = this.getTaskId();
        LOG.info("IndicatorSingleEdit.showBottomType===========taskId {}=============", (Object)taskId);
        if (taskId != null && taskId != 0L) {
            DynamicObject taskDy = this.FLOW_RU_PROC_APPLICATION_SERVICE.getTaskById(taskId);
            long currentNode = taskDy.getLong("flowrunode.id");
            LOG.info("===========currentnode.id {}=============", (Object)currentNode);
            if (currentNode != 0L) {
                int currentIndex;
                this.getPageCache().put("currentNodeId", String.valueOf(currentNode));
                FlowRuNodeBo ruNodeInstance = this.FLOW_RU_PROC_APPLICATION_SERVICE.getRuNodeInstance(Long.valueOf(currentNode));
                DynamicObject flowDefNode = ruNodeInstance.getFlowDefNode();
                String entrySeq = flowDefNode.getString("entryseq");
                LOG.info("=============entrySeq {}=============", (Object)entrySeq);
                this.getPageCache().put("entryseq", entrySeq);
                LOG.info("=============current taskId {}=========", (Object)taskId);
                if (!HRObjectUtils.isEmpty((Object)taskId)) {
                    Long typeId = this.getNodeType(taskId);
                    LOG.info("=============currentnode typeId {}==========", (Object)typeId);
                    if (!ObjectUtils.isEmpty((Object)typeId)) {
                        this.getPageCache().put("nodeTypeId", String.valueOf(typeId));
                        if (typeId.equals(NodeTypeConstants.INDICATOR_FORMULATE)) {
                            this.getView().setVisible(Boolean.TRUE, new String[]{"formulateap"});
                        } else if (typeId.equals(NodeTypeConstants.INDICATOR_AUDIT)) {
                            if (!this.isReviewerCanEdit()) {
                                this.getView().setStatus(OperationStatus.VIEW);
                            }
                            this.getView().setVisible(Boolean.TRUE, new String[]{"auditap"});
                        } else if (typeId.equals(NodeTypeConstants.INDICATOR_CONFIRM)) {
                            this.getView().setStatus(OperationStatus.VIEW);
                            this.getView().setVisible(Boolean.TRUE, new String[]{"confirmap"});
                        }
                    }
                }
                if ((currentIndex = this.getIndexByNodeId(currentNode)) == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"rollback"});
                }
            }
        }
        if (HRStringUtils.isNotEmpty((String)(customParam = (String)(formShowParameter = this.getView().getFormShowParameter()).getCustomParam("is_batch")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"opreationap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttommarget"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"opreationap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttommarget"});
            this.setBottomCenter();
        }
        this.checkTaskStatus();
    }

    private int getIndexByNodeId(Long currentNode) {
        String nodeIndex = this.getPageCache().get("getIndexByNodeId");
        if (HRStringUtils.isEmpty((String)nodeIndex)) {
            Integer indexByNodeId = ACTEVALOBJMANAGE_DOMAIN_SERVICE.getIndexByNodeId(currentNode);
            this.getPageCache().put("getIndexByNodeId", String.valueOf(indexByNodeId));
            return indexByNodeId;
        }
        this.getPageCache().remove("getIndexByNodeId");
        return Integer.parseInt(nodeIndex);
    }

    private void showHeadView(DynamicObject ruleDy) {
        String from;
        boolean isFromToBeList;
        DynamicObject scoreSystem = ruleDy.getDynamicObject("scoresystem");
        if (!HRObjectUtils.isEmpty((Object)scoreSystem)) {
            Label scoreSystemAp = (Label)this.getControl("scoresystemap");
            scoreSystemAp.setText(ruleDy.getString("scoresystem.name"));
            Label scoreCalcWayAp = (Label)this.getControl("scorecalcwayap");
            ScoreCalcWayEnum scorecalcway = ScoreCalcWayEnum.getScoreCalcWay((String)ruleDy.getString("scorecalcway"));
            scoreCalcWayAp.setText(ObjectUtils.isEmpty((Object)scorecalcway) ? "" : scorecalcway.getText());
            Label limitMaxScoreAp = (Label)this.getControl("limitmaxscoreap");
            limitMaxScoreAp.setText(scoreSystem.getBigDecimal("maxscore").stripTrailingZeros().toPlainString());
            Label limitMinScoreAp = (Label)this.getControl("limitminscoreap");
            limitMinScoreAp.setText(scoreSystem.getBigDecimal("minscore").stripTrailingZeros().toPlainString());
        }
        if (isFromToBeList = "epa_tobetargetformulate".equals(from = (String)this.getView().getFormShowParameter().getCustomParam("from"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"imptlap1"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"imptlap1"});
        }
    }

    private void showAssTableView() {
        DynamicObject billObj = this.getModel().getDataEntity(true);
        DynamicObject actObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)billObj.getLong("activity.id"));
        long ruleId = actObj.getLong("assessform.id");
        DynamicObject assessformDy = APP_SERVICE.queryAssessForm(ruleId);
        this.showHeadView(assessformDy);
        DynamicObjectCollection areaEntry = billObj.getDynamicObjectCollection("areaentry");
        FlexPanelAp assTableFlex = new HRFlexPanelAp.Builder("asstableflex").setDirection("column").setAlignItems("stretch").setJustifyContent("flex-start").setWrap(false).setGrow(0).setShrink(1).build();
        ArrayList<DynamicObject> areaList = new ArrayList<DynamicObject>((Collection<DynamicObject>)assessformDy.getDynamicObjectCollection("areaconfentry"));
        List<ContentAreaEntryEvaDto> processPermSetting = this.getProcessPermSetting(areaList, areaEntry);
        Map<Long, ContentAreaEntryEvaDto> areaEntryEvaDtoMap = this.convert2MapByAreaConf(processPermSetting);
        Boolean isCtrlPermission = (Boolean)this.getView().getFormShowParameter().getCustomParam("isCtrlPermission");
        boolean reviewerCanEdit = this.isReviewerCanEdit();
        ArrayList subPageList = Lists.newArrayListWithExpectedSize((int)areaEntry.size());
        int currentIndex = 0;
        Long taskId = this.getTaskId();
        String from = (String)this.getView().getFormShowParameter().getCustomParam("from");
        if (taskId != null && taskId != 0L) {
            long flowrunodeId = this.getFlowRuNodeId();
            currentIndex = this.getIndexByNodeId(flowrunodeId);
        } else if ("epa_targetformulating".equals(from)) {
            Long objId = billObj.getLong("id");
            currentIndex = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.getCurrentNodeIndex(objId);
        }
        for (int i = 0; i < areaEntry.size(); ++i) {
            Long confId = ((DynamicObject)areaEntry.get(i)).getLong("areaconf");
            String assTableItem = "asstableitemflex" + i;
            FlexPanelAp tableItemAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(assTableItem).setMarginBottom("10px")).setGrow(0).setShrink(1).build();
            if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getFormId(), (String)"epa_actevalobj_asstable")) {
                Style style = tableItemAp.getStyle();
                style = style == null ? new Style() : style;
                Border border = new Border();
                border.setLeft("1px_solid_#D9D9D9");
                border.setTop("1px_solid_#D9D9D9");
                border.setRight("1px_solid_#D9D9D9");
                border.setBottom("1px_solid_#D9D9D9");
                style.setBorder(border);
                tableItemAp.setStyle(style);
            }
            assTableFlex.getItems().add(tableItemAp);
            Long areaInstanceId = ((DynamicObject)areaEntry.get(i)).getLong("areains");
            DynamicObject areaReg = ((DynamicObject)areaEntry.get(i)).getDynamicObject("areareg");
            long areaRegId = areaReg.getLong("id");
            if (areaRegId == 4L) {
                this.getPageCache().put("attachAreaConfId", confId.toString());
            }
            String formId = AreaRegEnum.get((Long)areaRegId).getEvalObjAreaPageIdOfAssign();
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId(formId);
            showParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            showParameter.setPkId((Object)areaInstanceId);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(assTableItem);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
            showParameter.setCustomParam("confid", (Object)confId);
            showParameter.setCustomParam("obj_id", (Object)billObj.getLong("id"));
            showParameter.setCustomParam("taskId", (Object)this.getTaskId());
            showParameter.setCustomParam("from", (Object)from);
            showParameter.setCustomParam("REVIEWER_CAN_EDIT", (Object)reviewerCanEdit);
            showParameter.setCustomParam("scorecalcway", (Object)assessformDy.getString("scorecalcway"));
            showParameter.setCustomParam("consistentwitharea", (Object)assessformDy.getString("consistentwitharea"));
            showParameter.setCustomParam("evalway", (Object)assessformDy.getString("evalway"));
            showParameter.setCustomParam("numaccuracy", (Object)assessformDy.getString("numaccuracy"));
            showParameter.setCustomParam("evasumlimit", (Object)assessformDy.getString("evasumlimit"));
            if (assessformDy.getBigDecimal("limitmaxratio") != null) {
                showParameter.setCustomParam("limitmaxratio", (Object)assessformDy.getBigDecimal("limitmaxratio").toString());
            }
            IHRAppCache cache = HRAppCache.get((String)"epa");
            String areaConfStr = "";
            switch (formId) {
                case "epa_genareains_assign": {
                    if (!HRStringUtils.isEmpty((String)((String)cache.get("epa_genareains_assign" + confId, String.class)))) {
                        areaConfStr = (String)cache.get("epa_genareains_assign" + confId, String.class);
                        break;
                    }
                    areaConfStr = SerializationUtils.serializeToBase64((Object)ASSESS_ACTIVITY_APPLICATION_SERVICE.queryNormalConfigByPk(confId));
                    cache.put("epa_genareains_assign" + confId, (Object)areaConfStr);
                    break;
                }
                case "epa_addsubareains_assign": {
                    if (!HRStringUtils.isEmpty((String)((String)cache.get("epa_addsubareains_assign" + confId, String.class)))) {
                        areaConfStr = (String)cache.get("epa_addsubareains_assign" + confId, String.class);
                        break;
                    }
                    areaConfStr = SerializationUtils.serializeToBase64((Object)ASSESS_ACTIVITY_APPLICATION_SERVICE.queryPlusMinusConfigByPk(confId));
                    cache.put("epa_addsubareains_assign" + confId, (Object)areaConfStr);
                    break;
                }
                case "epa_attachareains_assign": {
                    if (!HRStringUtils.isEmpty((String)((String)cache.get("epa_attachareains_assign" + confId, String.class)))) {
                        areaConfStr = (String)cache.get("epa_attachareains_assign" + confId, String.class);
                        break;
                    }
                    areaConfStr = SerializationUtils.serializeToBase64((Object)ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAttachConfigByPk(confId));
                    cache.put("epa_attachareains_assign" + confId, (Object)areaConfStr);
                    break;
                }
            }
            showParameter.setCustomParam("conf", (Object)areaConfStr);
            showParameter.setCustomParam("scoresystem", (Object)assessformDy.getDynamicObject("scoresystem").getLong("id"));
            showParameter.setCustomParam("scoreSystemObj", (Object)SerializationUtils.serializeToBase64((Object)assessformDy.getDynamicObject("scoresystem")));
            showParameter.setHasRight(true);
            if (!HRObjectUtils.isEmpty((Object)isCtrlPermission) && isCtrlPermission.booleanValue()) {
                if (!this.isShowArea(areaEntryEvaDtoMap, confId)) {
                    IFormView parentsView = this.getView().getParentView();
                    String cacheKey = "indicatorMustInput_" + areaRegId + "_" + confId;
                    ArrayList mustInputFieldList = new ArrayList(16);
                    this.getPageCache().put(cacheKey, JSON.toJSONString(mustInputFieldList));
                    if (parentsView == null) continue;
                    parentsView.getPageCache().put(cacheKey, JSON.toJSONString(mustInputFieldList));
                    continue;
                }
                if (!this.hasModifyPermission(areaEntryEvaDtoMap, confId)) {
                    showParameter.setStatus(OperationStatus.VIEW);
                }
                ContentAreaEntryEvaDto areaEntryEvaDto = areaEntryEvaDtoMap.get(confId);
                showParameter.setCustomParam("fieldPermSettingJsonStr", (Object)JSON.toJSONString((Object)areaEntryEvaDto.getContentfieldentry()));
            }
            subPageList.add(showParameter.getPageId());
            showParameter.setCustomParam("currentIndex", (Object)currentIndex);
            showParameter.setSendToClient(true);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        this.getView().getPageCache().put("subAssignIndicatorPageList", SerializationUtils.toJsonString((Object)subPageList));
        this.getView().getPageCache().put("reviewercanedit", String.valueOf(reviewerCanEdit));
        this.getView().updateControlMetadata(assTableFlex.getKey(), assTableFlex.createControl());
        this.showPersonInfoTips(assessformDy);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.getPageCache().put("area_num", String.valueOf(areaEntry.size()));
        }
    }

    protected boolean hasModifyPermission(Map<Long, ContentAreaEntryEvaDto> areaEntryEvaDtoMap, Long confId) {
        ContentAreaEntryEvaDto areaEntryEvaDto = areaEntryEvaDtoMap.get(confId);
        if (areaEntryEvaDto == null) {
            return true;
        }
        Boolean areaModifyItem = areaEntryEvaDto.getAreaModifyItem();
        return areaModifyItem == null || areaModifyItem != false;
    }

    private List<ContentAreaEntryEvaDto> getProcessPermSetting(List<DynamicObject> areaList, DynamicObjectCollection areaEntry) {
        Long taskId = this.getTaskId();
        if (ObjectUtils.isEmpty((Object)taskId) || taskId == 0L) {
            return null;
        }
        DynamicObject ruNodeDy = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryFlowDefNodeIdByruNodeId(this.getFlowRuNodeId());
        long flowNodeDefId = 0L;
        if (ruNodeDy != null) {
            flowNodeDefId = ruNodeDy.getLong("flownodedef.id");
        }
        Long processPermSetting = this.getProcessPermSettingId();
        return ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryProcessPermSettingByKeyFieldNew(processPermSetting, Long.valueOf(flowNodeDefId));
    }

    private boolean isShowArea(Map<Long, ContentAreaEntryEvaDto> areaEntryEvaDtoMap, Long areaConfId) {
        Boolean areaDisplayItem;
        boolean isShowArea = false;
        ContentAreaEntryEvaDto areaEntryEvaDto = areaEntryEvaDtoMap.get(areaConfId);
        if (areaEntryEvaDto != null && (areaDisplayItem = areaEntryEvaDto.getAreaDisplayItem()) != null) {
            isShowArea = areaDisplayItem;
        }
        return isShowArea;
    }

    private Map<Long, ContentAreaEntryEvaDto> convert2MapByAreaConf(List<ContentAreaEntryEvaDto> contentAreaEntryEvaDtos) {
        HashMap<Long, ContentAreaEntryEvaDto> returnMap = new HashMap<Long, ContentAreaEntryEvaDto>(16);
        if (contentAreaEntryEvaDtos != null) {
            for (ContentAreaEntryEvaDto areaEntryEvaDto : contentAreaEntryEvaDtos) {
                if (areaEntryEvaDto == null) continue;
                Long areaPageInsId = areaEntryEvaDto.getAreaPageInsId();
                returnMap.put(areaPageInsId, areaEntryEvaDto);
            }
        }
        return returnMap;
    }

    private void showPersonInfoTips(DynamicObject assessformDy) {
        DynamicObject empInfoConfDy = EMP_INFO_CONFIG_ENTITY_SERVICE.queryOne((Object)assessformDy.getLong("empinfoconf"));
        DynamicObjectCollection empInfoConfEntry = empInfoConfDy.getDynamicObjectCollection("entryentity");
        List<String> blackList = Arrays.asList("headsculpture", "name", "number");
        Boolean isShowPersonInfoTips = false;
        for (DynamicObject empInfo : empInfoConfEntry) {
            String fieldKey;
            DynamicObject field = empInfo.getDynamicObject("areafield");
            if (field == null || blackList.contains(fieldKey = field.getString("number")) || !empInfo.getBoolean("isshow")) continue;
            isShowPersonInfoTips = true;
            break;
        }
        if (isShowPersonInfoTips.booleanValue()) {
            Tips tips = new Tips();
            tips.setTitle(null);
            tips.setTriggerType("hover");
            tips.setShowIcon(Boolean.FALSE.booleanValue());
            tips.setPlace("bottom");
            tips.setBillno("epa_personinfo");
            tips.setType("bill");
            Label nameLab = (Label)this.getControl("name");
            nameLab.addTips(tips);
        }
    }

    private boolean isReviewerCanEdit() {
        Long taskId = this.getTaskId();
        LOG.info("=====================taskId: {} =========", (Object)taskId);
        if (HRObjectUtils.isEmpty((Object)taskId)) {
            return true;
        }
        String reviewercanedit = this.getPageCache().get("isReviewerCanEdit");
        if (!HRStringUtils.isEmpty((String)reviewercanedit)) {
            return reviewercanedit.equals(Boolean.TRUE.toString());
        }
        DynamicObject nodeRole = this.FLOW_RU_PROC_APPLICATION_SERVICE.queryNodeRoleByTask(taskId);
        if (HRObjectUtils.isEmpty((Object)nodeRole)) {
            LOG.warn("nodeRole is empty!");
            return true;
        }
        if (nodeRole.getBoolean("reviewercanedit")) {
            this.getPageCache().put("isReviewerCanEdit", Boolean.TRUE.toString());
        } else {
            this.getPageCache().put("isReviewerCanEdit", Boolean.FALSE.toString());
        }
        return nodeRole.getBoolean("reviewercanedit");
    }

    private boolean isIndicatorLastNode() {
        Long taskId = this.getTaskId();
        if (HRObjectUtils.isEmpty((Object)taskId)) {
            return false;
        }
        return this.FLOW_RU_PROC_APPLICATION_SERVICE.isFormulateLastTask(taskId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        Long taskId = this.getTaskId();
        OperateOption option = op.getOption();
        if (taskId != null) {
            option.setVariableValue("taskId", taskId.toString());
        }
        if (HRStringUtils.equals((String)operateKey, (String)"assindsubmit")) {
            List<Map<String, Object>> validateList = this.checkIndMustItem();
            boolean failure = validateList.stream().anyMatch(validate -> (Boolean)validate.get("success") == false);
            this.removeValidView();
            if (failure) {
                this.getView().getPageCache().put("validateList", SerializationUtils.toJsonString(validateList));
                this.showIndMustValidatePage();
                args.setCancel(true);
                return;
            }
            IndicatorSingleSubmitCheckServiceImpl indicatorSingleSubmitService = new IndicatorSingleSubmitCheckServiceImpl();
            HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)indicatorSingleSubmitService, IndicatorSingleSubmitCheckService.class, (String)"kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.IndicatorSingleSubmitCheckService#checkSingleIndicatorSubmit", (PluginFilter)null);
            proxy.callReplaceIfPresent(validate -> validate.checkSingleIndicatorSubmit(args, (IFormPlugin)this, this.getView(), this.isIndicatorLastNode(), this.isReviewerCanEdit()));
        } else if (HRStringUtils.equals((String)operateKey, (String)"rollback") && taskId != null && taskId != 0L) {
            DynamicObject task = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.getTask(taskId);
            int taskStatus = task.getInt("taskstatus");
            if (Integer.parseInt(FlowRuTaskStatusEnum.EXPIRED.getCode()) == taskStatus) {
                String text = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5904\u7406\u5931\u8d25\r\n\u5931\u8d25\u539f\u56e0\u53ef\u80fd\u6709\u4ee5\u4e0b2\u70b9\uff1a\r\n1\u3001\u8be5\u4efb\u52a1\u5df2\u88ab\u540c\u4e00\u5904\u7406\u89d2\u8272\u5904\u7406\u4eba\u5904\u7406\uff0c\u63d0\u4ea4\u5931\u6548\r\n2\u3001\u60a8\u5f53\u524d\u4efb\u52a1\u5904\u7406\u6743\u9650\u5df2\u88ab\u4fee\u6539", (String)"IndicatorSingleEdit_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(text, "", MessageTypes.Default, new ConfirmCallBackListener(CHECK_EXPIRED, (IFormPlugin)this));
                args.setCancel(true);
            }
        }
    }

    private void removeValidView() {
        String validViewId = this.getView().getPageCache().get("validViewPageId");
        IFormView view = this.getView().getView(validViewId);
        if (view != null) {
            view.close();
            this.getView().sendFormAction(view);
        }
    }

    private void showIndMustValidatePage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId("epa_actindvalidview");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.getOpenStyle().setFloatingDirection(FloatingDirection.BottomRight);
        this.getView().getPageCache().put("validViewPageId", showParameter.getPageId());
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
    }

    private void invokeValidateOp(List<Map<String, Object>> validateList, IFormView areaPage) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult operationResult = areaPage.invokeOperation("submitvalid", option);
        boolean success = operationResult.isSuccess();
        String message = operationResult.getMessage();
        List allErrorInfo = operationResult.getAllErrorInfo();
        HashMap<String, Object> validateMap = new HashMap<String, Object>(16);
        validateMap.put("success", success);
        validateMap.put("areaname", message);
        validateMap.put("errorInfo", allErrorInfo);
        validateList.add(validateMap);
    }

    private List<Map<String, Object>> checkIndMustItem() {
        ArrayList<Map<String, Object>> validateList = new ArrayList<Map<String, Object>>(10);
        String subEvalRecordPageListStr = this.getView().getPageCache().get("subAssignIndicatorPageList");
        List subEvalRecordPageList = (List)SerializationUtils.fromJsonString((String)subEvalRecordPageListStr, List.class);
        for (String subEvalRecordPage : subEvalRecordPageList) {
            IFormView subAreaPage = this.getView().getView(subEvalRecordPage);
            this.invokeValidateOp(validateList, subAreaPage);
        }
        return validateList;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "assindsubmit": {
                HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                this.afterAssindsubmit(operationResult, resultMap);
                SubmitBatchIndicatorResultServiceImpl submitBatchIndicatorResultService = new SubmitBatchIndicatorResultServiceImpl();
                HRPluginProxy pluginProxy = HRPlugInProxyFactory.create((Object)submitBatchIndicatorResultService, SubmitBatchIndicatorResultService.class, (String)"kd.opmc.epa.business.task.extpoint.SubmitBatchIndicatorResultService#submitTaskResult", null);
                pluginProxy.callReplaceIfPresent(p -> p.submitTaskResult((Map)resultMap));
                break;
            }
            case "rollback": {
                this.showRollBackConfirm();
                break;
            }
        }
    }

    private void afterAssindsubmit(OperationResult operationResult, HashMap<String, Object> resultMap) {
        boolean isOperationSuccess = !HRObjectUtils.isEmpty((Object)operationResult) && operationResult.isSuccess();
        LOG.info("isOperationSuccess result {} ", (Object)isOperationSuccess);
        ArrayList<String> msgList = new ArrayList<String>(16);
        ArrayList<Long> successObj = new ArrayList<Long>(16);
        ArrayList<Long> objIds = new ArrayList<Long>(16);
        LinkedList<Long> submitTaskSuccessList = new LinkedList<Long>();
        HashMap<Long, Long> taskMap = new HashMap<Long, Long>(16);
        resultMap.put("msgList", msgList);
        Long objId = this.getModel().getDataEntity().getLong("id");
        Long taskId = this.getTaskId();
        taskMap.put(objId, taskId);
        objIds.add(objId);
        resultMap.put("evaluationObjectIds", objIds);
        resultMap.put("taskMap", taskMap);
        resultMap.put("success", 0);
        resultMap.put("fail", objIds.size());
        resultMap.put("total", objIds.size());
        resultMap.put("successObj", successObj);
        if (isOperationSuccess) {
            LOG.info("submitTask {} ", (Object)taskId);
            Map taskStatusMap = this.FLOW_RU_PROC_APPLICATION_SERVICE.getSubmitTaskStatus(Collections.singletonList(taskId));
            String taskStatusCode = (String)taskStatusMap.get(taskId);
            if (!FlowRuTaskStatusEnum.WAITING.getCode().equals(taskStatusCode) && !FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskStatusCode)) {
                String taskStatusStr = FlowRuTaskStatusEnum.getFlowRuTaskStatusByCode((String)taskStatusCode).getText();
                String failMsg = ResManager.loadKDString((String)"{0}\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"IndicatorSingleEdit_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{taskStatusStr});
                msgList.add(failMsg);
                resultMap.put("msgList", msgList);
                if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getParentFormId(), (String)"epa_indicatorworkbench")) {
                    this.getView().getParentView().showErrorNotification(failMsg);
                    this.getView().getParentView().invokeOperation("refresh_entry");
                    this.getView().sendFormAction(this.getView().getParentView());
                } else {
                    this.getView().showErrorNotification(failMsg);
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getView().updateView();
                }
                return;
            }
            boolean submitTask = this.FLOW_RU_PROC_APPLICATION_SERVICE.submitTask(taskId);
            LOG.info("submitTask result {} ", (Object)submitTask);
            if (submitTask) {
                submitTaskSuccessList.add(taskId);
                successObj.add(objId);
                resultMap.put("success", submitTaskSuccessList.size());
                resultMap.put("fail", objIds.size() - submitTaskSuccessList.size());
                resultMap.put("total", objIds.size());
                resultMap.put("successObj", successObj);
                APP_SERVICE.updateWeightAndIndctrScore(Long.valueOf(this.getModel().getDataEntity().getLong("id")));
                LOG.info(" after submitTask {} ", (Object)taskId);
                this.getView().setStatus(OperationStatus.VIEW);
                String msg = this.showSuccessNotification();
                msgList.add(msg);
                resultMap.put("msgList", msgList);
                if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getParentFormId(), (String)"epa_indicatorworkbench")) {
                    this.showParentSuccessNotification();
                    this.getView().getParentView().invokeOperation("refresh_entry");
                    this.getView().sendFormAction(this.getView().getParentView());
                } else {
                    this.getView().updateView();
                }
                this.setTaskStatus();
            } else {
                String failMsg = this.showFlowFailNotification();
                msgList.add(failMsg);
                resultMap.put("msgList", msgList);
            }
        }
    }

    private void showRollBackConfirm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_indicatorback_confirm");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Long taskId = this.getTaskId();
        if (taskId != null) {
            showParameter.setCustomParam("taskId", (Object)taskId.toString());
            showParameter.setCustomParam("objId", (Object)this.getModel().getDataEntity().getLong("id"));
        }
        this.getView().showForm(showParameter);
    }

    private void showParentSuccessNotification() {
        String typeIdStr = this.getPageCache().get("nodeTypeId");
        LOG.info("currentnode typeId {}", (Object)typeIdStr);
        Long typeId = Long.valueOf(typeIdStr);
        if (NodeTypeConstants.INDICATOR_FORMULATE.equals(typeId)) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"IndicatorSingleEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else if (NodeTypeConstants.INDICATOR_AUDIT.equals(typeId)) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u901a\u8fc7\u6210\u529f", (String)"IndicatorSingleEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else if (NodeTypeConstants.INDICATOR_CONFIRM.equals(typeId)) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f", (String)"IndicatorSingleEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private String showSuccessNotification() {
        String typeIdStr = this.getPageCache().get("nodeTypeId");
        String msgStr = "";
        LOG.info("currentnode typeId {}", (Object)typeIdStr);
        Long typeId = Long.valueOf(typeIdStr);
        if (NodeTypeConstants.INDICATOR_FORMULATE.equals(typeId)) {
            msgStr = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"IndicatorSingleEdit_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        } else if (NodeTypeConstants.INDICATOR_AUDIT.equals(typeId)) {
            msgStr = ResManager.loadKDString((String)"\u901a\u8fc7\u6210\u529f", (String)"IndicatorSingleEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        } else if (NodeTypeConstants.INDICATOR_CONFIRM.equals(typeId)) {
            msgStr = ResManager.loadKDString((String)"\u786e\u8ba4\u6210\u529f", (String)"IndicatorSingleEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        }
        this.getView().showSuccessNotification(msgStr);
        return msgStr;
    }

    private String showFlowFailNotification() {
        String msg = ResManager.loadKDString((String)"\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\u3002", (String)"IndicatorSingleEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(msg);
        return msg;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Long userId;
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
        Long taskId = this.getTaskId();
        if (taskId == null) {
            return;
        }
        Long nodeId = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryNodeId(this.getTaskId());
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        DataMutex dataMutex = DataMutex.create();
        Map lockInfoMap = dataMutex.getLockInfo(nodeId.toString(), "default_netctrl", "epa_actevalobj");
        if (lockInfoMap != null && (userId = Long.valueOf((String)lockInfoMap.get("userid"))) != 0L && currentUserId.equals(userId)) {
            MutexHelper.release((String)"epa_actevalobj", (String)"nodeview", (String)nodeId.toString());
        }
    }

    public void pageRelease(EventObject e) {
        long userId;
        Long taskId = this.getTaskId();
        if (taskId == null) {
            return;
        }
        Long nodeId = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryNodeId(this.getTaskId());
        Long currentUserId = UserServiceHelper.getCurrentUserId();
        DataMutex dataMutex = DataMutex.create();
        Map lockInfoMap = dataMutex.getLockInfo(nodeId.toString(), "default_netctrl", "epa_actevalobj");
        if (lockInfoMap != null && (userId = Long.parseLong((String)lockInfoMap.get("userid"))) != 0L && currentUserId.equals(userId)) {
            MutexHelper.release((String)"epa_actevalobj", (String)"nodeview", (String)nodeId.toString());
        }
    }

    private void setMutex(Long taskId) {
        if (taskId == null || taskId == 0L) {
            return;
        }
        if (NodeTypeConstants.INDICATOR_AUDIT.equals(this.initNodeType()) && !this.isReviewerCanEdit()) {
            return;
        }
        if (this.isTaskOperate(taskId)) {
            Long nodeId = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryNodeId(taskId);
            MutexLockInfo lockInfo = new MutexLockInfo();
            lockInfo.setStrict(true);
            lockInfo.setEntityNumber("epa_actevalobj");
            lockInfo.setOperationKey("nodeview");
            lockInfo.setCallSource("default");
            lockInfo.setDataObjId(nodeId.toString());
            StringBuilder msg = new StringBuilder();
            DataMutex dataMutex = DataMutex.create();
            Map lockInfoMap = dataMutex.getLockInfo(nodeId.toString(), "default_netctrl", "epa_actevalobj");
            if (lockInfoMap != null) {
                DynamicObject userObj;
                Long currentUserId = UserServiceHelper.getCurrentUserId();
                long userId = Long.parseLong((String)lockInfoMap.get("userid"));
                if (userId != 0L && currentUserId.equals(userId)) {
                    this.getPageCache().put("isLocked", "false");
                } else {
                    this.getPageCache().put("isLocked", "true");
                }
                if (userId != -1L && (userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user")) != null) {
                    this.getPageCache().put("operatePersonId", userObj.getString("id"));
                    this.getPageCache().put("operatePerson", userObj.getString("name"));
                    this.getPageCache().put("operatePersonNum", userObj.getString("number"));
                }
            } else {
                boolean require = MutexHelper.require((MutexLockInfo)lockInfo, (StringBuilder)msg);
                if (!require) {
                    this.getPageCache().put("isLocked", "true");
                } else {
                    this.getPageCache().put("isLocked", "false");
                }
            }
        }
    }

    private boolean isTaskOperate(Long taskId) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        DynamicObject[] taskDys = this.FLOW_RU_PROC_APPLICATION_SERVICE.queryTaskByIds(taskIds);
        if (taskDys != null && taskDys.length > 0) {
            String taskstatus = taskDys[0].getString("taskstatus");
            return FlowRuTaskStatusEnum.PROCESSING.getCode().equals(taskstatus);
        }
        return false;
    }

    private void showLocked() {
        String isLocked = this.getPageCache().get("isLocked");
        if (HRStringUtils.equals((String)"true", (String)isLocked)) {
            Map tasksCooperator;
            List cooperatorIds;
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.TRUE, new String[]{"lockpanel", "lockpanelpading"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap13"});
            Label lockedmsgAp = (Label)this.getControl("lockedmsg");
            String operatePerson = this.getPageCache().get("operatePerson");
            String operatePersonNum = this.getPageCache().get("operatePersonNum");
            String operatePersonId = this.getPageCache().get("operatePersonId");
            Long taskId = this.getTaskId();
            boolean isCooperator = false;
            if (taskId != null && (cooperatorIds = (List)(tasksCooperator = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getTaskCooperatorIds((List)Lists.newArrayList((Object[])new Long[]{this.getTaskId()}))).get(taskId)) != null && operatePersonId != null && cooperatorIds.contains(Long.valueOf(operatePersonId))) {
                isCooperator = true;
            }
            String lockText = isCooperator ? CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u7684\u4efb\u52a1\u6b63\u5728\u88ab\u534f\u529e\u4eba\u3010{0} \uff08{1}\uff09 \u3011\u5904\u7406\u4e2d\uff0c\u73b0\u4ec5\u652f\u6301\u67e5\u770b\u3002", (String)"IndicatorSingleEdit_8", (String)"opmc-epa-business", (Object[])new Object[]{operatePerson, operatePersonNum})) : CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u7684\u4efb\u52a1\u6b63\u5728\u88ab\u5236\u5b9a\u4eba\u3010{0} \uff08{1}\uff09 \u3011\u5904\u7406\u4e2d\uff0c\u73b0\u4ec5\u652f\u6301\u67e5\u770b\u3002", (String)"IndicatorSingleEdit_9", (String)"opmc-epa-business", (Object[])new Object[]{operatePerson, operatePersonNum}));
            lockedmsgAp.setText(lockText);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lockpanel", "lockpanelpading"});
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "processap": {
                FormShowParameter formShowParameter = new FormShowParameter();
                Long evalflowinsId = this.getModel().getDataEntity().getLong("formulateflowins.id");
                formShowParameter.setCustomParam("evalflowinsId", (Object)evalflowinsId);
                formShowParameter.setCustomParam("taskId", (Object)this.getTaskId());
                formShowParameter.setCustomParam("OP_SOURCE", (Object)"formulate");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setFormId("epa_workflow_proc");
                String caption = ResManager.loadKDString((String)"\u6307\u6807\u5236\u5b9a\u6d41\u7a0b\u4fe1\u606f", (String)"IndicatorSingleEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                formShowParameter.setCaption(caption);
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("800");
                styleCss.setHeight("600");
                formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
                formShowParameter.setHasRight(true);
                this.getView().showForm(formShowParameter);
                break;
            }
            case "imptlap1": {
                this.showIndicatorImportStartView();
                break;
            }
            case "indguideap": {
                this.showIndicatorGuideView();
                break;
            }
        }
    }

    private void showIndicatorGuideView() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epa_indicatorguideview");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.VIEW);
        Long aLong = this.getModel().getDataEntity().getDynamicObject("indigroup").getLong("id");
        DynamicObject dynamicObject1 = INDICATOR_GROUP_APPLICATION_SERVICE.queryIndicatorGuide(aLong);
        DynamicObjectCollection indareaconfentry = dynamicObject1.getDynamicObjectCollection("indicatorguide");
        HashMap indGuide = Maps.newHashMapWithExpectedSize((int)indareaconfentry.size());
        for (DynamicObject dynamicObject : indareaconfentry) {
            indGuide.put(String.valueOf(dynamicObject.getString("locale.id")), dynamicObject.getString("indguide"));
        }
        formShowParameter.setCustomParam("indguide", (Object)SerializationUtils.toJsonString((Object)indGuide));
        formShowParameter.setHasRight(true);
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)CHECK_EXPIRED, (String)callBackId)) {
            if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getParentFormId(), (String)"epa_indicatorworkbench")) {
                this.getView().getParentView().invokeOperation("refresh_entry");
                this.getView().sendFormAction(this.getView().getParentView());
            } else {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().updateView();
            }
        }
    }

    private Long getProcessPermSettingId() {
        DynamicObject activityDy = this.getModel().getDataEntity().getDynamicObject("activity");
        Long processpermsetting = 0L;
        if (activityDy != null) {
            processpermsetting = (Long)activityDy.get("dynamicpermission.id");
        }
        return processpermsetting;
    }
}

