/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.formplugin.web.activitymanage.indicator.extpoint.IndicatorSingleSubmitCheckService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class IndicatorSingleSubmitCheckServiceImpl
implements IndicatorSingleSubmitCheckService {
    private static final Log LOG = LogFactory.getLog(IndicatorSingleSubmitCheckServiceImpl.class);
    private static final ActEvalObjManageDomainService ACTEVALOBJMANAGE_DOMAIN_SERVICE = ActEvalObjManageDomainService.getInstance();
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final String CHECK_EXPIRED = "checkExpired";

    @Override
    public boolean checkSingleIndicatorSubmit(BeforeDoOperationEventArgs args, IFormPlugin iFormPlugin, IFormView view, boolean isIndicatorLastNode, boolean canEdit) {
        Long taskId;
        String duAreaName;
        DynamicObject billObj = view.getModel().getDataEntity();
        ArrayList<Long> objIds = new ArrayList<Long>(16);
        objIds.add((Long)billObj.getPkValue());
        String attachAreaConfIdStr = view.getPageCache().get("attachAreaConfId");
        String currentNodeIdStr = view.getPageCache().get("currentNodeId");
        int index = 0;
        if (!HRStringUtils.isEmpty((String)currentNodeIdStr)) {
            Long nodeId = Long.parseLong(currentNodeIdStr);
            index = ACTEVALOBJMANAGE_DOMAIN_SERVICE.getIndexByNodeId(nodeId);
        }
        long attachAreaConfId = 0L;
        if (!HRStringUtils.isEmpty((String)attachAreaConfIdStr)) {
            attachAreaConfId = Long.parseLong(attachAreaConfIdStr);
        }
        if (!HRStringUtils.isEmpty((String)(duAreaName = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.checkIndicatorNameInArea(objIds, Long.valueOf(attachAreaConfId), index)))) {
            String duText = ResManager.loadKDString((String)"{0}\u4e2d\u6709\u91cd\u590d\u540d\u79f0\u7684\u6307\u6807\uff0c\u8bf7\u4fee\u6539", (String)"IndicatorSingleSubmitCheckServiceImpl_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{duAreaName});
            view.showTipNotification(duText);
            args.setCancel(true);
        }
        if ((taskId = this.getTaskId(view)) != null && taskId != 0L) {
            DynamicObject task = ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.getTask(taskId);
            int taskStatus = task.getInt("taskstatus");
            if (Integer.parseInt(FlowRuTaskStatusEnum.EXPIRED.getCode()) == taskStatus) {
                Iterator text = ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5904\u7406\u5931\u8d25\r\n\u5931\u8d25\u539f\u56e0\u53ef\u80fd\u6709\u4ee5\u4e0b2\u70b9\uff1a\r\n1\u3001\u8be5\u4efb\u52a1\u5df2\u88ab\u540c\u4e00\u5904\u7406\u89d2\u8272\u5904\u7406\u4eba\u5904\u7406\uff0c\u63d0\u4ea4\u5931\u6548\r\n2\u3001\u60a8\u5f53\u524d\u4efb\u52a1\u5904\u7406\u6743\u9650\u5df2\u88ab\u4fee\u6539", (String)"IndicatorSingleSubmitCheckServiceImpl_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                view.showMessage(text, "", MessageTypes.Default, new ConfirmCallBackListener(CHECK_EXPIRED, iFormPlugin));
                args.setCancel(true);
            }
        }
        String nodeTypeId = view.getPageCache().get("nodeTypeId");
        if (isIndicatorLastNode || HRStringUtils.equals((String)nodeTypeId, (String)String.valueOf(NodeTypeConstants.INDICATOR_AUDIT)) && canEdit) {
            LOG.info("checkSubmitIndicator {}", objIds);
            List msgList = APP_SERVICE.checkSubmitIndicator(objIds);
            LOG.info("checkSubmitIndicator result {} ", (Object)msgList);
            if (!ObjectUtils.isEmpty((Object)msgList)) {
                for (String msg : msgList) {
                    view.showTipNotification(msg);
                }
                args.setCancel(true);
            }
        } else {
            LOG.info("checkAreaEqual {}", objIds);
            List areaMsgList = APP_SERVICE.checkAreaEqual(objIds);
            LOG.info("checkAreaEqual result {} ", (Object)areaMsgList);
            if (!ObjectUtils.isEmpty((Object)areaMsgList)) {
                for (String msg : areaMsgList) {
                    view.showTipNotification(msg);
                }
                args.setCancel(true);
                return args.isCancel();
            }
            LOG.info("checkSurpassSubmitIndicator {}", objIds);
            List msgList = APP_SERVICE.checkSurpassSubmitIndicator(objIds);
            LOG.info("checkSurpassSubmitIndicator result {} ", (Object)msgList);
            if (!ObjectUtils.isEmpty((Object)msgList)) {
                for (String msg : msgList) {
                    view.showTipNotification(msg);
                }
                args.setCancel(true);
            }
        }
        return args.isCancel();
    }

    private Long getTaskId(IFormView view) {
        if (ObjectUtils.isEmpty((Object)view.getFormShowParameter())) {
            return null;
        }
        Object taskId = view.getFormShowParameter().getCustomParam("taskId");
        LOG.info("taskId: {}", taskId);
        if (ObjectUtils.isEmpty((Object)taskId)) {
            return null;
        }
        long aLong = taskId instanceof String ? Long.parseLong((String)taskId) : (Long)taskId;
        return aLong;
    }
}

