/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.mp.entityservice.MpCalcItemEntityService;
import kd.opmc.epa.business.domain.mp.entityservice.MpRuleEntityService;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumResultSetBo;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumRuleCalBo;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumCalDomainService;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumResultDomainService;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetEntryVO;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetVO;
import kd.opmc.epa.common.enums.activitymanage.MpModeEnum;
import kd.opmc.pmd.business.domain.perffile.entityservice.PerffileEntityService;

public class MpModifyRulePlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log LOG = LogFactory.getLog(MpModifyRulePlugin.class);
    private static final ActivityEvaluationObjectEntityService EPA_ACTEVALOBJ = ActivityEvaluationObjectEntityService.getInstance();
    private static final MpCalcItemEntityService MP_CALC_ITEM_ENTITY_SERVICE = MpCalcItemEntityService.getInstance();
    private static final PerffileEntityService PERFFILE_SERVICE = PerffileEntityService.getInstance();
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();
    private static final MpRuleEntityService MP_RULE_ENTITY_SERVICE = MpRuleEntityService.getInstance();
    private static final PerfSumCalDomainService PERF_SUM_CAL_DOMAIN_SERVICE = PerfSumCalDomainService.getInstance();
    private static final String RADIOGROUP = "radiogroupfield";
    private static final String MULTI = "*";
    private static final String ADD = "+";
    private static final String PER = "%";
    private static final String SUMCALC = "sumcalc";
    private static final String PERCRNT = "percent";
    private static final String ADDCALCITEM = "addcalcitem";
    private static final String DELCALCITEM = "delcalcitem";
    private static final String MPCALCITEMS = "mpcalcitems";
    private static final PerfSumResultDomainService PERF_SUM_RESULT_DOMAIN_SERVICE = PerfSumResultDomainService.getInstance();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        Long actObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actObjId");
        PerfSumResultSetBo perfSumResultSetBo = PERF_SUM_RESULT_DOMAIN_SERVICE.getPerfSumDataDealSetByActivityId(activityId, Boolean.valueOf(false));
        Map levelSeq2NameMapByEvaObjId = PERF_SUM_RESULT_DOMAIN_SERVICE.getLevelSeq2NameMapByEvaObjId(actObjId);
        perfSumResultSetBo.setLevelNameMap(levelSeq2NameMapByEvaObjId);
        this.getView().getPageCache().put("perfSumResultSet", SerializationUtils.toJsonString((Object)perfSumResultSetBo));
        DynamicObject actObj = this.initPersonInfo(actObjId);
        String mpMode = this.queryMpruleByActObj(actObj);
        this.getModel().setValue(RADIOGROUP, (Object)mpMode);
        this.getView().updateView(RADIOGROUP);
        this.assembleCalItem(actObjId);
        this.modifyMpRule(mpMode);
        this.calcMpResulit();
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("calentryentity", "setColEditorProp", new Object[]{"sopfield", "sc", perfSumResultSetBo.getNumAccuracy()});
    }

    private PerfSumResultSetBo getPerfSumResultSet(IFormView view) {
        String perfSumResultSet = view.getPageCache().get("perfSumResultSet");
        if (HRStringUtils.isEmpty((String)perfSumResultSet)) {
            return new PerfSumResultSetBo();
        }
        return (PerfSumResultSetBo)SerializationUtils.fromJsonString((String)perfSumResultSet, PerfSumResultSetBo.class);
    }

    private String queryMpruleByActObj(DynamicObject actObj) {
        DynamicObject mprule;
        String mpMode = "1";
        DynamicObject dynamicObject = mprule = actObj.getDynamicObject("mprealrule") != null ? actObj.getDynamicObject("mprealrule") : actObj.getDynamicObject("activity").getDynamicObject("mprule");
        if (mprule != null) {
            DynamicObject newMpRule = MP_RULE_ENTITY_SERVICE.loadDynamicObject(new QFilter("id", "=", (Object)mprule.getLong("id")));
            mpMode = newMpRule.getString("mpmode");
        }
        return mpMode;
    }

    private void calcMpResulit() {
        DynamicObjectCollection calColls = this.getModel().getDataEntity(true).getDynamicObjectCollection("calentryentity");
        StringBuilder ruleBuilder = new StringBuilder();
        if (calColls != null && calColls.size() > 0) {
            DynamicObjectCollection ruleColls = this.getModel().getDataEntity(true).getDynamicObjectCollection("ruleentryentity");
            if (!HRObjectUtils.isEmpty((Object)ruleColls) && ruleColls.size() > 0) {
                for (int i = 0; i < ruleColls.size(); ++i) {
                    if (i == ruleColls.size() - 1) {
                        ruleBuilder.append(((DynamicObject)ruleColls.get(i)).getString("ruletimetag")).append(MULTI).append(((DynamicObject)ruleColls.get(i)).getBigDecimal(PERCRNT).setScale(2, 4)).append(PER);
                        continue;
                    }
                    ruleBuilder.append(((DynamicObject)ruleColls.get(i)).getString("ruletimetag")).append(MULTI).append(((DynamicObject)ruleColls.get(i)).getBigDecimal(PERCRNT).setScale(2, 4)).append(PER).append(ADD);
                }
            } else {
                ruleBuilder.append("(");
                for (int i = 0; i < calColls.size(); ++i) {
                    String rulename = ((DynamicObject)calColls.get(i)).getString("mpcalcitem.timetag");
                    if (i == ruleColls.size() - 1) {
                        ruleBuilder.append(rulename);
                    }
                    ruleBuilder.append(rulename).append(ADD);
                }
                ruleBuilder.deleteCharAt(ruleBuilder.length() - 1);
                ruleBuilder.append(")").append("/").append(calColls.size());
            }
        } else {
            ruleBuilder.append("");
        }
        this.getModel().initValue("mpresult", (Object)ruleBuilder.toString());
        this.getView().updateView("mpresult");
    }

    private void modifyMpRule(String selectVal) {
        AbstractFormDataModel model0 = (AbstractFormDataModel)this.getModel();
        model0.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("rulename", new Object[0]);
        setter.addField(PERCRNT, new Object[0]);
        setter.addField("ruletimetag", new Object[0]);
        DynamicObjectCollection calColls = this.getModel().getDataEntity(true).getDynamicObjectCollection("calentryentity");
        if (!HRObjectUtils.isEmpty((Object)calColls) && calColls.size() > 0 && "2".equals(selectVal)) {
            for (DynamicObject calitem : calColls) {
                String timeTag = calitem.getString("mpcalcitem.timetag");
                String rulename = timeTag + "." + calitem.getString("mpcalcitem.number");
                Long actObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actObjId");
                DynamicObject actObj = EPA_ACTEVALOBJ.loadDynamicObject(new QFilter("id", "=", (Object)actObjId));
                DynamicObject mprule = actObj.getDynamicObject("mprealrule") != null ? actObj.getDynamicObject("mprealrule") : actObj.getDynamicObject("activity").getDynamicObject("mprule");
                BigDecimal weight = new BigDecimal("0.00");
                if (mprule != null) {
                    DynamicObject mpRule = MP_RULE_ENTITY_SERVICE.loadDynamicObject(new QFilter("id", "=", (Object)mprule.getLong("id")));
                    DynamicObjectCollection ruleEntrys = mpRule.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : ruleEntrys) {
                        if (!timeTag.equals(entry.getString("timetag"))) continue;
                        weight = entry.getBigDecimal("weight").setScale(2, 4);
                    }
                    setter.addRow(new Object[]{rulename, weight, timeTag});
                    continue;
                }
                setter.addRow(new Object[]{rulename, weight, timeTag});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"ruleentryentity"});
            model0.deleteEntryData("ruleentryentity");
            model0.batchCreateNewEntryRow("ruleentryentity", setter);
            model0.endInit();
        } else {
            model0.deleteEntryData("ruleentryentity");
            model0.endInit();
            this.getView().setVisible(Boolean.FALSE, new String[]{"ruleentryentity"});
        }
        this.getView().updateView("ruleentryentity");
    }

    private void assembleCalItem(Long actObjId) {
        this.getModel().deleteEntryData("calentryentity");
        DynamicObject[] calcitems = MP_CALC_ITEM_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{new QFilter("evaobj", "=", (Object)actObjId), new QFilter("isused", "=", (Object)"1")});
        if (!HRObjectUtils.isEmpty((Object)calcitems) && calcitems.length > 0) {
            PerfSumResultSetBo perfSumResultSetBo = this.getPerfSumResultSet(this.getView());
            int numAccuracy = Integer.parseInt(perfSumResultSetBo.getNumAccuracy());
            String scaleType = perfSumResultSetBo.getScaleType();
            for (int i = 0; i < calcitems.length; ++i) {
                BigDecimal sopBig = calcitems[i].getBigDecimal("sop");
                sopBig = sopBig.setScale(numAccuracy, StringUtils.equals((CharSequence)scaleType, (CharSequence)"10") ? 0 : (StringUtils.equals((CharSequence)scaleType, (CharSequence)"20") ? 1 : 4));
                int row = this.getModel().createNewEntryRow("calentryentity");
                this.getModel().initValue("mpcalcitem", (Object)calcitems[i].getLong("id"), row);
                this.getModel().initValue("perffilefield", (Object)calcitems[i].getLong("evaobj.perffile.id"), row);
                this.getModel().initValue("sopfield", (Object)sopBig, row);
                String lopStr = calcitems[i].getString("lop");
                long perfleveId = calcitems[i].getLong("perfleve.id");
                this.getModel().initValue("lopfield", perfSumResultSetBo.getLevelNameMap().get(perfleveId + "_" + lopStr), row);
            }
            this.getView().updateView("calentryentity");
        }
    }

    private DynamicObject initPersonInfo(Long actObjId) {
        DynamicObject actObj = EPA_ACTEVALOBJ.loadDynamicObject(new QFilter("id", "=", (Object)actObjId));
        if (!HRObjectUtils.isEmpty((Object)actObj)) {
            this.getModel().initValue("perffile", (Object)actObj.getLong("perffile.id"));
            Image image = (Image)this.getControl("headsculpture");
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)String.valueOf(actObj.getString("person.headsculpture"))));
            Label assgroupLab = (Label)this.getControl("assgroup");
            assgroupLab.setText(actObj.getString("assgroup.name"));
            Label postypeLab = (Label)this.getControl("postype");
            postypeLab.setText(actObj.getString("empposrel.postype.name"));
            DynamicObject employeeDy = actObj.getDynamicObject("employee");
            if (!HRObjectUtils.isEmpty((Object)employeeDy)) {
                Label laborLab = (Label)this.getControl("laborrelstatus");
                laborLab.setText(employeeDy.getString("laborrelstatus.name"));
            }
        }
        this.getView().updateView("infoflexpanel");
        return actObj;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        Object value = this.getModel().getValue(RADIOGROUP);
        if (RADIOGROUP.equals(name)) {
            this.modifyMpRule((String)value);
            this.calcMpResulit();
        } else if (PERCRNT.equals(name) && "2".equals(value)) {
            this.calcMpResulit();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "sumcalc": {
                this.sumCalcRsult();
                break;
            }
            case "addcalcitem": {
                BasedataEdit additem = (BasedataEdit)this.getControl(MPCALCITEMS);
                additem.click();
                break;
            }
            case "delcalcitem": {
                this.delCalEntry();
                Object mpMode = this.getModel().getValue(RADIOGROUP);
                this.modifyMpRule((String)mpMode);
                this.calcMpResulit();
                break;
            }
        }
    }

    private void sumCalcRsult() {
        block29: {
            DynamicObjectCollection calColls = this.getModel().getDataEntity(true).getDynamicObjectCollection("calentryentity");
            if (calColls != null && calColls.size() > 0) {
                String radio = (String)this.getModel().getValue(RADIOGROUP);
                Long actObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actObjId");
                DynamicObject actObj = EPA_ACTEVALOBJ.loadDynamicObject(new QFilter("id", "=", (Object)actObjId));
                Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
                if (!PERF_SUM_RESULT_DOMAIN_SERVICE.checkEvaObjNotInToBeMP(nodeIndex, actObj)) {
                    DynamicObject[] allCalObjs;
                    MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
                    ArrayList<MpRuleSetEntryVO> mpRuleSetEntrys = new ArrayList<MpRuleSetEntryVO>(10);
                    PerfSumRuleCalBo perfSumRuleCalBo = new PerfSumRuleCalBo();
                    ArrayList<DynamicObject> updatecalObjs = new ArrayList<DynamicObject>(10);
                    ArrayList<DynamicObject> delcalObjs = new ArrayList<DynamicObject>(10);
                    List calItemIds = calColls.stream().map(cal -> cal.getLong("mpcalcitem.id")).collect(Collectors.toList());
                    for (DynamicObject calitemobj : allCalObjs = MP_CALC_ITEM_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{new QFilter("evaobj", "=", (Object)actObjId)})) {
                        DynamicObject updateCalObj = MP_CALC_ITEM_ENTITY_SERVICE.queryOne("id,isused", new QFilter("id", "=", (Object)calitemobj.getLong("id")));
                        if (calItemIds.contains(calitemobj.getLong("id"))) {
                            DynamicObject calobj = calColls.stream().filter(cal -> cal.getLong("mpcalcitem.id") == calitemobj.getLong("id")).findFirst().orElse(null);
                            updateCalObj.set("isused", (Object)Boolean.TRUE);
                            updatecalObjs.add(updateCalObj);
                            MpRuleSetEntryVO mpRuleSetEntryVO = new MpRuleSetEntryVO();
                            mpRuleSetEntryVO.setTimetag(calobj.getString("mpcalcitem.timetag"));
                            if ("1".equals(radio)) {
                                BigDecimal weight = new BigDecimal("0.00").setScale(2, 4);
                                mpRuleSetEntryVO.setWeight(weight);
                                perfSumRuleCalBo.setMpModeEnum(MpModeEnum.AVG_WEIGHT);
                                perfSumRuleCalBo.addMpCalcItemInfo(Long.valueOf(calobj.getLong("mpcalcitem.id")), calobj.getString("mpcalcitem.timetag"), weight);
                            } else {
                                DynamicObjectCollection ruleColls = this.getModel().getDataEntity(true).getDynamicObjectCollection("ruleentryentity");
                                if (!HRObjectUtils.isEmpty((Object)ruleColls) && ruleColls.size() > 0) {
                                    BigDecimal totalPer = BigDecimal.valueOf(0.0);
                                    BigDecimal sumPer = BigDecimal.valueOf(100.0);
                                    for (DynamicObject rule : ruleColls) {
                                        totalPer = totalPer.add(rule.getBigDecimal(PERCRNT).setScale(2, 4));
                                    }
                                    if (sumPer.compareTo(totalPer) == 0) {
                                        for (DynamicObject rule : ruleColls) {
                                            String rulename = calobj.getString("mpcalcitem.timetag") + "." + calobj.getString("mpcalcitem.number");
                                            if (!rulename.equals(rule.getString("rulename"))) continue;
                                            mpRuleSetEntryVO.setWeight(rule.getBigDecimal(PERCRNT).setScale(2, 4));
                                            perfSumRuleCalBo.setMpModeEnum(MpModeEnum.CUSTOM_PROPORTION);
                                            perfSumRuleCalBo.addMpCalcItemInfo(Long.valueOf(calobj.getLong("mpcalcitem.id")), calobj.getString("mpcalcitem.timetag"), rule.getBigDecimal(PERCRNT).setScale(2, 4));
                                        }
                                    } else {
                                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u4e0e\u6c47\u603b\u7684\u8003\u6838\u7ed3\u679c\u7684\u6743\u91cd\u548c\u987b=100%", (String)"MpModifyRulePlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                                        return;
                                    }
                                }
                            }
                            mpRuleSetEntryVO.setCalcitem(calitemobj);
                            mpRuleSetEntrys.add(mpRuleSetEntryVO);
                            continue;
                        }
                        updateCalObj.set("isused", (Object)Boolean.FALSE);
                        delcalObjs.add(updateCalObj);
                    }
                    mpRuleSetVO.setEntryentities(mpRuleSetEntrys);
                    mpRuleSetVO.setMpmode(Integer.parseInt((String)this.getModel().getValue(RADIOGROUP)));
                    mpRuleSetVO.setMpformula((String)this.getModel().getValue("mpresult"));
                    mpRuleSetVO.setErdealrule(1);
                    try (TXHandle txHandle = TX.required();){
                        DynamicObject[] updateCalItems = (DynamicObject[])updatecalObjs.stream().toArray(DynamicObject[]::new);
                        MP_CALC_ITEM_ENTITY_SERVICE.update(updateCalItems);
                        DynamicObject[] delCalItems = (DynamicObject[])delcalObjs.stream().toArray(DynamicObject[]::new);
                        MP_CALC_ITEM_ENTITY_SERVICE.update(delCalItems);
                        DynamicObject mpSaveVO = MP_RULE_ENTITY_SERVICE.saveByVo(mpRuleSetVO, Long.valueOf(actObj.getLong("mprule.id")));
                        DynamicObject updateActObj = EPA_ACTEVALOBJ.queryOne("id,ismprmodify,mprsource,mprule,mprealrule", new QFilter("id", "=", (Object)actObjId));
                        updateActObj.set("ismprmodify", (Object)Boolean.TRUE);
                        updateActObj.set("mprsource", (Object)"1");
                        updateActObj.set("mprule", (Object)mpSaveVO);
                        updateActObj.set("mprealrule", (Object)mpSaveVO);
                        EPA_ACTEVALOBJ.updateOne(updateActObj);
                        perfSumRuleCalBo.setEvalObjId(actObjId);
                        perfSumRuleCalBo.setActicityId(Long.valueOf(actObj.getLong("activity.id")));
                        String perfSumRes = PERF_SUM_CAL_DOMAIN_SERVICE.ruleCalPerfSumData(perfSumRuleCalBo);
                        if (HRStringUtils.isNotEmpty((String)perfSumRes)) {
                            this.getView().showErrorNotification(perfSumRes);
                            return;
                        }
                        try {
                            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
                            this.getView().close();
                            this.getView().getParentView().invokeOperation("refresh");
                            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\uff0c\u6c47\u603b\u7ed3\u679c\u5df2\u91cd\u65b0\u8ba1\u7b97", (String)"MpModifyRulePlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                            this.getView().sendFormAction(this.getView().getParentView());
                            break block29;
                        }
                        catch (Exception ex) {
                            LOG.error((Throwable)ex);
                            txHandle.markRollback();
                            throw ex;
                        }
                    }
                }
                String name = actObj.getString("perffile.name");
                String billno = actObj.getString("perffile.billno");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}{1}\uff1a\u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u7ed3\u679c\u6c47\u603b-\u5f85\u6c47\u603b\u72b6\u6001\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"MpModifyRulePlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{name, billno}));
                return;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53c2\u4e0e\u6c47\u603b\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MpModifyRulePlugin_3", (String)"opmc-epa-business", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = ((Control)evt.getSource()).getKey()) {
            case "mpcalcitems": {
                Long actObjId = (Long)this.getView().getFormShowParameter().getCustomParam("actObjId");
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.setCustomParam("activity", this.getView().getFormShowParameter().getCustomParam("activity"));
                showParameter.setCustomParam("evaobj", (Object)actObjId);
                DynamicObjectCollection calColls = this.getModel().getDataEntity(true).getDynamicObjectCollection("calentryentity");
                List calItemIds = calColls.stream().map(cal -> cal.getLong("mpcalcitem.id")).collect(Collectors.toList());
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("evaobj", "=", (Object)actObjId));
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", calItemIds));
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = ((Control)evt.getSource()).getKey()) {
            case "mpcalcitems": {
                DynamicObjectCollection calcItemColls = (DynamicObjectCollection)this.getModel().getValue(MPCALCITEMS);
                this.addCalEntry(calcItemColls);
                Object mpMode = this.getModel().getValue(RADIOGROUP);
                this.modifyMpRule((String)mpMode);
                this.calcMpResulit();
                break;
            }
        }
    }

    private void addCalEntry(DynamicObjectCollection calcItemColls) {
        DynamicObjectCollection calColls = this.getModel().getDataEntity(true).getDynamicObjectCollection("calentryentity");
        for (DynamicObject calcItem : calcItemColls) {
            DynamicObject calcObj = MP_CALC_ITEM_ENTITY_SERVICE.loadDynamicObject(new QFilter("id", "=", (Object)calcItem.getLong("fbasedataid_id")));
            Boolean isExistCal = Boolean.FALSE;
            for (DynamicObject cal : calColls) {
                if (cal.getLong("mpcalcitem.id") != calcObj.getLong("id")) continue;
                isExistCal = Boolean.TRUE;
            }
            if (isExistCal.booleanValue()) continue;
            PerfSumResultSetBo perfSumResultSetBo = this.getPerfSumResultSet(this.getView());
            int numAccuracy = Integer.parseInt(perfSumResultSetBo.getNumAccuracy());
            String scaleType = perfSumResultSetBo.getScaleType();
            BigDecimal sopBig = calcObj.getBigDecimal("sop");
            sopBig = sopBig.setScale(numAccuracy, StringUtils.equals((CharSequence)scaleType, (CharSequence)"10") ? 0 : (StringUtils.equals((CharSequence)scaleType, (CharSequence)"20") ? 1 : 4));
            String lopStr = calcObj.getString("lop");
            int row = this.getModel().createNewEntryRow("calentryentity");
            this.getModel().setValue("mpcalcitem", (Object)calcObj.getLong("id"), row);
            this.getModel().initValue("perffilefield", (Object)calcObj.getLong("evaobj.perffile.id"), row);
            this.getModel().initValue("sopfield", (Object)sopBig, row);
            long perfleveId = calcObj.getLong("perfleve.id");
            this.getModel().initValue("lopfield", perfSumResultSetBo.getLevelNameMap().get(perfleveId + "_" + lopStr), row);
        }
        this.getModel().setValue(MPCALCITEMS, null);
        this.getView().updateView("calentryentity");
    }

    private void delCalEntry() {
        DynamicObjectCollection calColls = this.getModel().getDataEntity(true).getDynamicObjectCollection("calentryentity");
        if (calColls != null) {
            String deleteMsg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"MpModifyRulePlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(deleteMsg);
            EntryGrid calentryentity = (EntryGrid)this.getControl("calentryentity");
            calentryentity.clearEntryState();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mpCalsitems = (BasedataEdit)this.getView().getControl(MPCALCITEMS);
        mpCalsitems.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        mpCalsitems.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().getModel().setDataChanged(false);
    }
}

