/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.opmc.epa.business.domain.mp.entityservice.MpCalcItemEntityService;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumResultSetBo;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumResultDomainService;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;

public class MpPlaningResultList
extends QueryListPlugin {
    private static final MpCalcItemEntityService mpCalcItemEntityService = MpCalcItemEntityService.getInstance();
    private static final PerfSumResultDomainService PERF_SUM_RESULT_DOMAIN_SERVICE = PerfSumResultDomainService.getInstance();

    public void setFilter(SetFilterEvent event) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        QFilter activityFilter = new QFilter("epa_actevalobj.activity.id", "=", (Object)activityId);
        event.getQFilters().add(activityFilter);
        event.setOrderBy("createtime desc");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List<String> fixedColumnList = Arrays.asList("fseq", "number", "calc_perffile.person.headsculpture", "calc_perffile.name", "calc_perffile.billno");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        PerfSumResultSetBo perfSumResultSetBo = PERF_SUM_RESULT_DOMAIN_SERVICE.getPerfSumDataDealSetByActivityId(activityId, Boolean.valueOf(false));
        String numAccuracy = perfSumResultSetBo.getNumAccuracy();
        this.getView().getPageCache().put("numAccuracy", numAccuracy);
        ListUtils.decimalDisplayeFormatHandle(args, this.getView(), "sop");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        List selectedList;
        QFilter qFilter;
        super.beforeDoOperation(args);
        if (ObjectUtils.isEmpty((Object)this.getParentViewPageCache())) {
            args.setCancel(true);
            return;
        }
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("delete".equals(operateKey) && mpCalcItemEntityService.isExists(qFilter = new QFilter("id", "in", selectedList = this.getSelectedRows().stream().map(selected -> (Long)selected.getPrimaryKeyValue()).collect(Collectors.toList())).and("isused", "=", (Object)Boolean.TRUE))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6570\u636e\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MpPlaningResultList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "delete": {
                ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
                long orgId = RequestContext.get().getOrgId();
                AppLogInfo logInfo = this.buildLogInfo(ResManager.loadKDString((String)"\u5220\u9664\u53c2\u4e0e\u6c47\u603b\u7684\u6570\u636e\u6210\u529f", (String)"MpPlaningResultList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53c2\u4e0e\u6c47\u603b\u7684\u6570\u636e", (String)"MpPlaningResultList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), orgId);
                logService.addLog(logInfo);
                break;
            }
        }
    }

    private AppLogInfo buildLogInfo(String msg, String opName, Long orgId) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        String bizApppnumber = this.getView().getFormShowParameter().getAppId();
        String bizAppid = BizAppServiceHelp.getAppIdByAppNumber((String)bizApppnumber);
        logInfo.setBizAppID(bizAppid);
        logInfo.setBizObjID("epa_mpcalcitemquery");
        logInfo.setOrgID(orgId);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        final Map levelSeq2NameMap = PERF_SUM_RESULT_DOMAIN_SERVICE.getLevelSeq2NameMapByActivityId(activityId);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    String lop;
                    long perfLevelId;
                    if (!row.containsProperty("perfleve") || (perfLevelId = row.getLong("perfleve.id")) == 0L || !HRStringUtils.isNotEmpty((String)(lop = row.getString("lop")))) continue;
                    row.set("lop", levelSeq2NameMap.get(perfLevelId + "_" + lop));
                }
                return rows;
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List qFilters = args.getQfilters();
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        if (fieldName.contains("pmdperson.name")) {
            qFilters.add(new QFilter("bussinessfield.number", "=", (Object)"105010_S"));
        } else if ("activity.number".equals(fieldName) || "activity.name".equals(fieldName)) {
            QFilter filter = new QFilter("evaobj.activity.id", "=", (Object)activityId);
            DynamicObject[] dyColl = mpCalcItemEntityService.query("activity.id", new QFilter[]{filter});
            HashSet<Long> activityIdSet = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : dyColl) {
                DynamicObject activityDy = dynamicObject.getDynamicObject("activity");
                if (activityDy == null) continue;
                activityIdSet.add(activityDy.getLong("id"));
            }
            if (CollectionUtils.isNotEmpty(activityIdSet)) {
                qFilters.add(new QFilter("id", "in", activityIdSet));
            } else {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
            }
        } else if (fieldName.contains("epa_actevalobj.perffile")) {
            QFilter filter = new QFilter("evaobj.activity.id", "=", (Object)activityId);
            DynamicObject[] dyColl = mpCalcItemEntityService.query("evaobj.perffile.id", new QFilter[]{filter});
            HashSet<Long> perffileIdSet = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : dyColl) {
                DynamicObject evaObjDy = dynamicObject.getDynamicObject("evaobj");
                if (evaObjDy == null) continue;
                perffileIdSet.add(evaObjDy.getLong("perffile.id"));
            }
            if (CollectionUtils.isNotEmpty(perffileIdSet)) {
                qFilters.add(new QFilter("id", "in", perffileIdSet));
            } else {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
            }
        }
    }

    protected IPageCache getParentViewPageCache() {
        IFormView parentView = this.getView().getParentView().getParentView();
        if (parentView == null) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u9875\u9762\u5df2\u66f4\u65b0\uff0c\u8bf7\u5173\u95ed\u9875\u9762\u5e76\u91cd\u65b0\u6253\u5f00", (String)"MpPlaningResultList_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("closeView", (IFormPlugin)this));
            return null;
        }
        return parentView.getPageCache();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView")) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                this.getView().getParentView().close();
                this.getView().sendFormAction(this.getView().getParentView());
            }
            return;
        }
    }
}

