/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary;

import com.alibaba.fastjson.JSONArray;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.hr.expt.common.plugin.BeforeShowConfirmMessageEventArgs;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumResultDomainService;

public class MpResultImportList
extends HRDataBaseList
implements HRExportPlugin {
    private static final PerfSumResultDomainService PERF_SUM_RESULT_DOMAIN_SERVICE = PerfSumResultDomainService.getInstance();
    static final String ACTIVITY_ID = "activityId";
    static final String EXPORT_SOURCE = "exportSource";

    public void setFilter(SetFilterEvent filterEvent) {
        List selectedIdList;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long activityId = (Long)formShowParameter.getCustomParam("activity");
        int nodeIndex = (Integer)formShowParameter.getCustomParam("nodeindex");
        QFilter commonFilter = PERF_SUM_RESULT_DOMAIN_SERVICE.getToBePerfSumCommonFilter(Integer.valueOf(nodeIndex));
        commonFilter.and("activity", "=", (Object)activityId);
        JSONArray selectdIds = (JSONArray)formShowParameter.getCustomParam("selectIds");
        if (selectdIds != null && (selectedIdList = selectdIds.toJavaList(Long.class)).size() > 0) {
            commonFilter.and("id", "in", (Object)selectedIdList);
        }
        filterEvent.getQFilters().add(commonFilter);
        filterEvent.setOrderBy("modifytime desc,perffile.affiliateadminorg.name asc,perffile.billno  asc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        IPageCache pageCache = this.getView().getPageCache();
        switch (operateKey) {
            case "export_from_impttpl_hr": {
                Long activity = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                pageCache.put(ACTIVITY_ID, String.valueOf(activity));
                pageCache.put(EXPORT_SOURCE, "epa_tobeperfsum_" + operateKey);
                break;
            }
        }
    }

    public void beforeShowConfirmMessage(BeforeShowConfirmMessageEventArgs args) {
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(args.getPageId());
        IPageCache pageCache = view.getPageCache();
        String activityId = pageCache.get(ACTIVITY_ID);
        String exportSource = pageCache.get(EXPORT_SOURCE);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put(ACTIVITY_ID, activityId);
        params.put(EXPORT_SOURCE, exportSource);
        args.setExtParams(SerializationUtils.toJsonString(params));
        super.beforeShowConfirmMessage(args);
    }

    public void beforeWriteData(BeforeWriteDataEventArgs args) {
        super.beforeWriteData(args);
        List tplDataRows = args.getTplDataRows();
        if (tplDataRows.isEmpty()) {
            return;
        }
        PERF_SUM_RESULT_DOMAIN_SERVICE.assembleMpResultExport(args, tplDataRows);
    }
}

