/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.impt.common.enu.ValidatorEnum;
import kd.hr.impt.common.plugin.AfterCallOperationEventArgs;
import kd.hr.impt.common.plugin.AfterLoadStartPageEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.opmc.epa.business.domain.mp.enums.MpSopGenWayEnum;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumResultDomainService;
import kd.opmc.epa.formplugin.web.activitymanage.performsummary.MpResultScoreValidator;

public class MpResultImportPlugin
extends HRDataBaseList
implements HRImportPlugin {
    private static final PerfSumResultDomainService PERF_SUM_RESULT_DOMAIN_SERVICE = PerfSumResultDomainService.getInstance();

    public void afterLoadStartPage(AfterLoadStartPageEventArgs args) {
        IFormView viewNoPlugin = SessionManager.getCurrent().getViewNoPlugin(args.getPageId());
        FormShowParameter formShowParameter = viewNoPlugin.getFormShowParameter();
        Long activityId = (Long)formShowParameter.getCustomParam("activity");
        Integer nodeIndex = (Integer)formShowParameter.getCustomParam("nodeindex");
        Object selectIds = formShowParameter.getCustomParam("selectIds");
        List selectIdList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)selectIds), Long.class);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("activity", activityId);
        customParams.put("nodeindex", nodeIndex);
        customParams.put("selectIds", selectIdList);
        args.setExtParams(JSONObject.toJSONString(customParams));
    }

    public void beforeInitValidator(BeforeInitValidatorEventArgs args) {
        String extParams = args.getExtParams();
        Map extParamMap = (Map)JSONObject.parseObject((String)extParams, Map.class);
        Long activityId = (Long)extParamMap.get("activity");
        Integer nodeIndex = (Integer)extParamMap.get("nodeindex");
        String selectIds = String.valueOf(extParamMap.get("selectIds"));
        List objIds = JSONArray.parseArray((String)selectIds, Long.class);
        DynamicObject[] evaObjArr = PERF_SUM_RESULT_DOMAIN_SERVICE.queryToBePerfSumObj(activityId, nodeIndex, objIds);
        Map<String, DynamicObject> evaObjMap = Arrays.stream(evaObjArr).collect(Collectors.toMap(dy -> dy.getString("perffile.number"), Function.identity()));
        args.setValidator(ValidatorEnum.CUSTOM_VALIDATOR, (AbstractValidateHandler)new MpResultScoreValidator(activityId, evaObjMap));
    }

    public void afterCallOperation(AfterCallOperationEventArgs args) {
        DynamicObject[] evaObjArr = args.getDynamicObjects();
        if (evaObjArr != null && evaObjArr.length > 0) {
            DynamicObjectCollection dyColl = new DynamicObjectCollection();
            dyColl.addAll(Arrays.asList(evaObjArr));
            PERF_SUM_RESULT_DOMAIN_SERVICE.addMpResultModifyLog(dyColl, null, MpSopGenWayEnum.RESULT_IMPORT);
        }
    }
}

