/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.mp.enums.MpSopGenWayEnum;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumResultSetBo;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumResultDomainService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.common.constants.PerformSummaryConstants;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;
import kd.opmc.pbs.business.domain.perfcecycle.entityservice.PerfLevelEntityService;

public class MpResultModifyPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener,
ItemClickListener {
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final PerfLevelEntityService PERF_LEVEL_ENTITY = PerfLevelEntityService.getInstance();
    private static final PerfSumResultDomainService PERF_SUM_RESULT_DOMAIN_SERVICE = PerfSumResultDomainService.getInstance();
    private static final String ASSESS_OBJECT_ENTRY_ENTITY = "assessobjectentryentity";
    static final String LEVEL_MUST = "levelMust";
    static final String SCORE_FIELD = "scorefield";
    static final String LEVEL_FIELD = "levelfield";
    static final String COMFIRM_BTN = "comfirm";
    static final String MP_SOP_GEN_WAY = "mpsopgenway";
    static final String IS_MAPPING = "isMappinng";
    static final String SUM_PERF_LEVEL_ID = "sumPerfLevelId";
    static final String SCORE_SYSTEM_ID = "scoreSystemId";
    static final String NUM_ACCURACY = "numaccuracy";
    static final String SCALE_TYPE = "scaletype";
    static final String MAX_SCORE = "maxscore";
    static final String MIN_SCORE = "minscore";
    static final String EVALOBJ = "evalobj";
    static final String PERSON = "person";
    static final String PERFFILE_ID = "perffile.id";
    static final String PERSON_ID = "person.id";

    public void afterBindData(EventObject e) {
        String numAccuracy = this.getView().getPageCache().get(NUM_ACCURACY);
        if (HRStringUtils.isEmpty((String)numAccuracy)) {
            numAccuracy = "2";
        }
        Integer numAccuracyInt = Integer.parseInt(numAccuracy);
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(ASSESS_OBJECT_ENTRY_ENTITY, "setColEditorProp", new Object[]{SCORE_FIELD, "sc", numAccuracyInt});
        clientViewProxy.invokeControlMethod(ASSESS_OBJECT_ENTRY_ENTITY, "setColEditorProp", new Object[]{SCORE_FIELD, "pc", numAccuracyInt + 13});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "comfirm": {
                this.checkAssessObjectForSave(args);
                break;
            }
        }
    }

    private void checkAssessObjectForSave(BeforeDoOperationEventArgs args) {
        boolean actPerm;
        DynamicObjectCollection assessObject = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY);
        if (CollectionUtils.isEmpty((Collection)assessObject)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u8bf7\u6dfb\u52a0\u6570\u636e", (String)"MpResultModifyPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (!(actPerm = EvalObjUtils.checkActivityPermission((IFormView)this.getView()))) {
            args.setCancel(true);
            return;
        }
        if (!this.checkScore(assessObject)) {
            args.setCancel(true);
        }
    }

    private boolean checkScore(DynamicObjectCollection assessObjectColl) {
        IPageCache pageCache = this.getView().getPageCache();
        BigDecimal maxscoreBig = PerformSummaryConstants.MAX_SCORE_BIG;
        ArrayList<String> objMsgList = new ArrayList<String>(10);
        String levalMust = pageCache.get(LEVEL_MUST);
        for (DynamicObject objEntry : assessObjectColl) {
            String objMsg;
            BigDecimal score = objEntry.getBigDecimal(SCORE_FIELD);
            if (null == score) {
                objMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199 {0} {1}\u7684\u6c47\u603b\u5f97\u5206", (String)"MpResultModifyPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{objEntry.getString("perffile.name"), objEntry.getString("perffile.billno")});
                objMsgList.add(objMsg);
                continue;
            }
            if (!PERF_SUM_RESULT_DOMAIN_SERVICE.validMpSop(score)) {
                objMsg = ResManager.loadKDString((String)"{0} {1}\u7684\u6c47\u603b\u5f97\u5206\u5df2\u8d85\u51fa\u5206\u6570\u8303\u56f4\uff1a[{2},{3}]", (String)"MpResultModifyPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{objEntry.getString("perffile.name"), objEntry.getString("perffile.billno"), PerformSummaryConstants.MIN_SCORE_BIG.toPlainString(), PerformSummaryConstants.MAX_SCORE_BIG.toPlainString()});
                objMsgList.add(objMsg);
                continue;
            }
            String level = objEntry.getString(LEVEL_FIELD);
            if (!HRStringUtils.equals((String)levalMust, (String)"1") || !HRStringUtils.isEmpty((String)level)) continue;
            String objMsg2 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199 {0} {1} \u7684\u6c47\u603b\u7b49\u7ea7", (String)"MpResultModifyPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{objEntry.getString("perffile.name"), objEntry.getString("perffile.billno")});
            objMsgList.add(objMsg2);
        }
        if (objMsgList.size() > 0) {
            String checkMsg = String.join((CharSequence)"\r\n", objMsgList);
            this.getView().showErrorNotification(checkMsg);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (source.getOperateKey()) {
            case "comfirm": {
                int successCount = this.saveAssessObjUptData(args);
                this.getView().returnDataToParent((Object)successCount);
                break;
            }
        }
    }

    private int saveAssessObjUptData(AfterDoOperationEventArgs args) {
        DynamicObjectCollection assessObjectColl = this.getModel().getEntryEntity(ASSESS_OBJECT_ENTRY_ENTITY);
        List<String> failMessageList = this.dealPartEvalBackResultData(assessObjectColl, args);
        int totalCount = assessObjectColl.size();
        int failCount = failMessageList.size();
        if (failCount < 1) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"MpResultModifyPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
        } else if (totalCount == 1) {
            this.getView().getParentView().showErrorNotification(failMessageList.get(0));
            this.getView().sendFormAction(this.getView().getParentView());
        } else {
            String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (String)"MpResultModifyPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{totalCount, totalCount - failCount, failCount});
            this.getView().showMessage(title, String.join((CharSequence)"\n", failMessageList), MessageTypes.Default);
        }
        IPageCache pageCache = this.getView().getPageCache();
        if ("1".equals(pageCache.get("isRefreshList"))) {
            return 1;
        }
        return totalCount - failCount;
    }

    private List<String> dealPartEvalBackResultData(DynamicObjectCollection assessObjectColl, AfterDoOperationEventArgs args) {
        List essessObjIdList = assessObjectColl.stream().map(assessObj -> assessObj.getLong("evalobj.id")).collect(Collectors.toList());
        DynamicObject[] evaObjs = PERF_SUM_RESULT_DOMAIN_SERVICE.queryEvalObjWithMpResultById(essessObjIdList);
        Map<Long, DynamicObject> evalObjDyMap = Arrays.stream(evaObjs).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        int allSize = assessObjectColl.size();
        Date date = new Date();
        DynamicObjectCollection dyColl = new DynamicObjectCollection();
        Map<Long, Object> reasonMap = assessObjectColl.stream().collect(Collectors.toMap(assCollKey -> assCollKey.getLong("evalobj.id"), assCollVal -> assCollVal.get("reason")));
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<String> failMessage = new ArrayList<String>(10);
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("isRefreshList", "0");
        for (int index = 0; index < allSize; ++index) {
            DynamicObject entryDy = (DynamicObject)assessObjectColl.get(index);
            DynamicObject evalObj = evalObjDyMap.get(entryDy.getLong("evalobj.id"));
            if (PERF_SUM_RESULT_DOMAIN_SERVICE.checkEvaObjNotInToBeMP(nodeIndex, evalObj)) {
                failMessage.add(ResManager.loadKDString((String)"{0} {1}: \u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u7ed3\u679c\u6c47\u603b-\u5f85\u6c47\u603b\u5217\u8868\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"MpResultModifyPlugin_6", (String)"opmc-epa-business", (Object[])new Object[]{evalObj.getString("perffile.name"), evalObj.getString("perffile.billno")}));
                pageCache.put("isRefreshList", "1");
                continue;
            }
            BigDecimal score = entryDy.getBigDecimal(SCORE_FIELD);
            String levelId = entryDy.getString(LEVEL_FIELD);
            String level = this.getLevel2PageCache(levelId, Boolean.TRUE);
            evalObj.set(AssessScoreAbbrEnum.MPSOP.getCode(), (Object)score);
            evalObj.set(AssessScoreAbbrEnum.MPLOP.getCode(), (Object)level);
            evalObj.set(MP_SOP_GEN_WAY, (Object)MpSopGenWayEnum.RESULT_MODIFY.getCode());
            evalObj.set("modifier", (Object)userId);
            evalObj.set("modifytime", (Object)date);
            dyColl.add((Object)evalObj);
        }
        if (dyColl.size() > 0) {
            PERF_SUM_RESULT_DOMAIN_SERVICE.addMpResultModifyLog(dyColl, reasonMap, MpSopGenWayEnum.RESULT_MODIFY);
            EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObjectColl(dyColl);
        }
        return failMessage;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IPageCache pageCache = this.getView().getPageCache();
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (SCORE_FIELD.equals(propertyName)) {
            BigDecimal score = (BigDecimal)changeData.getNewValue();
            if (null == score) {
                return;
            }
            boolean validateFlage = this.valiateScoreByScoreRange(score = this.getMpSopByScale(score), changeData);
            if (!validateFlage) {
                return;
            }
            String isMappinng = pageCache.get(IS_MAPPING);
            if ("1".equals(isMappinng)) {
                String levelPk = PERF_SUM_RESULT_DOMAIN_SERVICE.calcLevelByScore(Long.valueOf(Long.parseLong(pageCache.get(SUM_PERF_LEVEL_ID))), Long.valueOf(Long.parseLong(pageCache.get(SCORE_SYSTEM_ID))), (BigDecimal)e.getChangeSet()[0].getNewValue());
                this.getView().getModel().setValue(LEVEL_FIELD, (Object)levelPk, changeData.getRowIndex());
            }
            this.getView().getModel().setValue(SCORE_FIELD, (Object)score, changeData.getRowIndex());
        }
    }

    private boolean valiateScoreByScoreRange(BigDecimal score, ChangeData changeData) {
        if (PERF_SUM_RESULT_DOMAIN_SERVICE.validMpSop(score)) {
            return Boolean.TRUE;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u603b\u5f97\u5206\u5df2\u8d85\u51fa\u5206\u6570\u8303\u56f4\uff1a[{0},{1}]", (String)"MpResultModifyPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{PerformSummaryConstants.MIN_SCORE_BIG.toPlainString(), PerformSummaryConstants.MAX_SCORE_BIG.toPlainString()}));
        return Boolean.FALSE;
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long activityId = (Long)parameter.getCustomParam("activity");
        if (Objects.isNull(activityId)) {
            return;
        }
        PerfSumResultSetBo perfSumResultSetBo = PERF_SUM_RESULT_DOMAIN_SERVICE.getPerfSumDataDealSetByActivityId(activityId, Boolean.valueOf(false));
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put(NUM_ACCURACY, perfSumResultSetBo.getNumAccuracy());
        pageCache.put(SCALE_TYPE, perfSumResultSetBo.getScaleType());
        pageCache.put(MAX_SCORE, perfSumResultSetBo.getMaxScore());
        pageCache.put(MIN_SCORE, perfSumResultSetBo.getMinScore());
        this.initScoreRange();
        Long perfLevelId = perfSumResultSetBo.getPerfLevelId();
        Long scoreSystemId = perfSumResultSetBo.getScoreSystemId();
        this.setScoreAndLevelStyle(perfLevelId);
        this.isScoreMappingLeval(scoreSystemId, perfLevelId);
        this.builderEntryData();
    }

    private void builderEntryData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List evalObjectIds = (List)parameter.getCustomParams().get("evalObjectIds");
        DynamicObject[] evalObjDyArr = PERF_SUM_RESULT_DOMAIN_SERVICE.queryEvalObjWithMpResultById(evalObjectIds);
        if (CollectionUtils.isEmpty((Collection)evalObjectIds)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField(EVALOBJ, new Object[0]);
        setter.addField("perffile", new Object[0]);
        setter.addField(PERSON, new Object[0]);
        setter.addField(SCORE_FIELD, new Object[0]);
        setter.addField(LEVEL_FIELD, new Object[0]);
        for (DynamicObject evalObj : evalObjDyArr) {
            String level = this.getLevel2PageCache(evalObj.getString(AssessScoreAbbrEnum.MPLOP.getCode()), Boolean.FALSE);
            String mpsopgenway = evalObj.getString(MP_SOP_GEN_WAY);
            BigDecimal mpsopBig = null;
            if (!HRStringUtils.isEmpty((String)mpsopgenway)) {
                mpsopBig = evalObj.getBigDecimal(AssessScoreAbbrEnum.MPSOP.getCode());
                mpsopBig = this.getMpSopByScale(mpsopBig);
            }
            setter.addRow(new Object[]{evalObj.getLong("id"), evalObj.getLong(PERFFILE_ID), evalObj.getLong(PERSON_ID), mpsopBig, level});
        }
        model.batchCreateNewEntryRow(ASSESS_OBJECT_ENTRY_ENTITY, setter);
        model.endInit();
        this.getView().updateView(ASSESS_OBJECT_ENTRY_ENTITY);
    }

    private void setScoreAndLevelStyle(Long sumperflevelId) {
        DecimalEdit decimalEdit = (DecimalEdit)this.getControl(SCORE_FIELD);
        decimalEdit.setMustInput(true);
        IPageCache pageCache = this.getView().getPageCache();
        FieldEdit combofield = (FieldEdit)this.getControl(LEVEL_FIELD);
        combofield.setMustInput(true);
        pageCache.put(LEVEL_MUST, "1");
        if (sumperflevelId == null || sumperflevelId == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LEVEL_FIELD});
            combofield.setMustInput(false);
            pageCache.put(LEVEL_MUST, "0");
            return;
        }
        DynamicObject sumPerfLevel = PERF_LEVEL_ENTITY.loadSingle((Object)sumperflevelId);
        this.genaratePerfLevelSelect(sumPerfLevel);
    }

    private void genaratePerfLevelSelect(DynamicObject sumPerfLevel) {
        DynamicObjectCollection entryentity = sumPerfLevel.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return;
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(10);
        for (DynamicObject entry : entryentity) {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(entry.getPkValue()));
            item.setCaption(new LocaleString(entry.getString("levelname")));
            item.setValue(String.valueOf(entry.getPkValue()));
            combos.add(item);
            this.setLevel2PageCache(entry);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(LEVEL_FIELD);
        comboEdit.setComboItems(combos);
    }

    private void setLevel2PageCache(DynamicObject entry) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put(MessageFormat.format("{0}{1}", "levelID", String.valueOf(entry.getPkValue())), entry.getString("seq"));
        pageCache.put(MessageFormat.format("{0}{1}", "levelseq", entry.getString("seq")), String.valueOf(entry.getPkValue()));
    }

    private String getLevel2PageCache(String level, boolean type) {
        IPageCache pageCache = this.getView().getPageCache();
        String levelData = pageCache.get(MessageFormat.format("{0}{1}", type ? "levelID" : "levelseq", level));
        return levelData;
    }

    private void isScoreMappingLeval(Long scoreSystemId, Long sumPerfLevelId) {
        IPageCache pageCache = this.getView().getPageCache();
        boolean isMappinng = PERF_SUM_RESULT_DOMAIN_SERVICE.isScoreMappingLeval(scoreSystemId, sumPerfLevelId);
        pageCache.put(SCORE_SYSTEM_ID, String.valueOf(scoreSystemId));
        pageCache.put(SUM_PERF_LEVEL_ID, String.valueOf(sumPerfLevelId));
        pageCache.put(IS_MAPPING, isMappinng ? "1" : "0");
    }

    private void initScoreRange() {
        IPageCache pageCache = this.getView().getPageCache();
        BigDecimal minscore = new BigDecimal(pageCache.get(MIN_SCORE));
        BigDecimal maxscore = new BigDecimal(pageCache.get(MAX_SCORE));
        Label totalnumlap = (Label)this.getControl("minlab");
        totalnumlap.setText(this.setNull2Zero(minscore));
        Label sucessnumlab = (Label)this.getControl("maxlab");
        sucessnumlab.setText(this.setNull2Zero(maxscore));
    }

    private String setNull2Zero(BigDecimal num) {
        return num.stripTrailingZeros().toPlainString();
    }

    private void setDefualtScoreRange() {
        this.getView().getPageCache().put(MAX_SCORE, "0");
        this.getView().getPageCache().put(MIN_SCORE, "0");
    }

    private BigDecimal getMpSopByScale(BigDecimal score) {
        if (score == null) {
            return null;
        }
        IPageCache pageCache = this.getView().getPageCache();
        String numaccuracy = pageCache.get(NUM_ACCURACY);
        String scaletype = pageCache.get(SCALE_TYPE);
        if (StringUtils.isNotEmpty((CharSequence)numaccuracy)) {
            score = score.setScale(Integer.parseInt(numaccuracy), StringUtils.equals((CharSequence)scaletype, (CharSequence)"10") ? 0 : (StringUtils.equals((CharSequence)scaletype, (CharSequence)"20") ? 1 : 4));
        }
        return score;
    }
}

