/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.opmc.epa.business.domain.mp.enums.MpSopGenWayEnum;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumResultSetBo;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumResultDomainService;
import kd.opmc.epa.common.constants.PerformSummaryConstants;

public class MpResultScoreValidator
extends AbstractValidateHandler {
    private static final PerfSumResultDomainService PERF_SUM_RESULT_DOMAIN_SERVICE = PerfSumResultDomainService.getInstance();
    private static final Log log = LogFactory.getLog(MpResultScoreValidator.class);
    public static final String MAX_SCORE = "scoresystem.maxscore";
    public static final String MIN_SCORE = "scoresystem.minscore";
    private final Long activityId;
    private final Map<String, DynamicObject> evaObjMap;
    private final PerfSumResultSetBo perfSumResultSetBo;

    public MpResultScoreValidator(Long activityId, Map<String, DynamicObject> evaObjMap) {
        this.activityId = activityId;
        this.evaObjMap = evaObjMap;
        this.perfSumResultSetBo = PERF_SUM_RESULT_DOMAIN_SERVICE.getPerfSumDataDealSetByActivityId(this.activityId, Boolean.valueOf(false));
    }

    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.AFTER;
    }

    public void validate(List<ImportBillData> list, ImportLog importLog) {
        Map errorLogMap;
        if (ObjectUtils.isEmpty(list)) {
            return;
        }
        this.commonValidate(list, importLog);
        if (list.size() > 0 && importLog.getRowErrors().size() > 0 && (errorLogMap = (Map)importLog.getRowErrors().get(list.get(0).getSheetName())) != null && errorLogMap.size() > 0) {
            Set errorLine = errorLogMap.keySet();
            for (ImportBillData data : list) {
                if (errorLine.contains(data.getStartIndex())) continue;
                importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u6b63\u786e", (String)"MpResultScoreValidator_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void commonValidate(List<ImportBillData> list, ImportLog importLog) {
        Map levelNameMap = this.perfSumResultSetBo.getLevelNameMap();
        HashMap levelName2SeqMap = new HashMap(16);
        if (levelNameMap != null) {
            for (Map.Entry tabKeyEntry : levelNameMap.entrySet()) {
                levelName2SeqMap.put(tabKeyEntry.getValue(), tabKeyEntry.getKey());
            }
        }
        int numAccuracy = Integer.parseInt(this.perfSumResultSetBo.getNumAccuracy());
        for (ImportBillData data : list) {
            String mpsop;
            JSONObject impEvaObjObj = data.getData().getJSONObject("epa_actevalobj");
            JSONObject impPerfFile = impEvaObjObj.getJSONObject("perffile");
            if (impPerfFile == null) continue;
            String impPerfFileNumber = impPerfFile.getString("number");
            JSONObject activity = impEvaObjObj.getJSONObject("activity");
            if (activity == null) continue;
            String impActivityNumber = activity.getString("number");
            if (HRStringUtils.isEmpty((String)impPerfFileNumber) || HRStringUtils.isEmpty((String)impActivityNumber)) continue;
            DynamicObject dynamicObject = this.evaObjMap.get(impPerfFileNumber);
            if (dynamicObject == null) {
                importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u7ed3\u679c\u6c47\u603b-\u5f85\u6c47\u603b\u5217\u8868\u3002", (String)"MpResultScoreValidator_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                continue;
            }
            String activityNumber = dynamicObject.getString("activity.number");
            if (HRStringUtils.isNotEmpty((String)impActivityNumber) && !HRStringUtils.equals((String)activityNumber, (String)impActivityNumber)) {
                importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), ResManager.loadKDString((String)"\u7b2cB\u5217\u7684\u5b57\u6bb5\u201c\u8003\u6838\u6d3b\u52a8\u7f16\u7801\u201d\u4e0d\u5c5e\u4e8e\u672c\u8003\u6838\u6d3b\u52a8\u3002", (String)"MpResultScoreValidator_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
            String impPerfFileName = impPerfFile.getString("name");
            String perffileName = dynamicObject.getString("perffile.name");
            if (!HRStringUtils.equals((String)perffileName, (String)impPerfFileName)) {
                importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), ResManager.loadKDString((String)"\u7b2cE\u5217\u7684\u5b57\u6bb5\u201c\u5458\u5de5\u59d3\u540d\u201d\u4e0e\u7ee9\u6548\u6863\u6848\u4e0d\u7b26\u3002", (String)"MpResultScoreValidator_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)(mpsop = impEvaObjObj.getString("mpsop")))) {
                try {
                    BigDecimal mpsopBig = new BigDecimal(mpsop);
                    if (numAccuracy < mpsopBig.scale()) {
                        importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), ResManager.loadKDString((String)"\u7b2cG\u5217\u7684\u5b57\u6bb5\u201c\u6c47\u603b\u5f97\u5206\u201d\u5c0f\u6570\u4f4d\u4e0d\u6ee1\u8db3\u8bc4\u4f30\u8868\u5355/\u7ed3\u679c\u6c47\u603b\u7684\u5c0f\u6570\u4f4d\u8981\u6c42\uff1a{0}\u4f4d\u3002", (String)"MpResultScoreValidator_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{numAccuracy}));
                    }
                    if (!PERF_SUM_RESULT_DOMAIN_SERVICE.validMpSop(mpsopBig)) {
                        importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), ResManager.loadKDString((String)"\u7b2cG\u5217\u7684\u5b57\u6bb5\u201c\u6c47\u603b\u5f97\u5206\u201d\u5df2\u8d85\u51fa\u5206\u6570\u8303\u56f4\uff1a[{0},{1}]\u3002", (String)"MpResultScoreValidator_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{PerformSummaryConstants.MIN_SCORE_BIG.toPlainString(), PerformSummaryConstants.MAX_SCORE_BIG.toPlainString()}));
                    }
                }
                catch (Exception e) {
                    importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), ResManager.loadKDString((String)"\u7b2cG\u5217\u7684\u5b57\u6bb5\u201c\u6c47\u603b\u5f97\u5206\u201d\u6570\u636e\u683c\u5f0f\u6709\u8bef", (String)"MpResultScoreValidator_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
            }
            String mplop = impEvaObjObj.getString("mplop");
            if (this.perfSumResultSetBo.getPerfLevelId() != null) {
                if (HRStringUtils.isEmpty((String)mplop)) {
                    importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), ResManager.loadKDString((String)"\u7b2cH\u5217\u7684\u5b57\u6bb5\u201c\u6c47\u603b\u7b49\u7ea7\u201d\u65e0\u6570\u636e\uff0c\u8bf7\u7ef4\u62a4\u6570\u636e\u540e\u4e0a\u4f20", (String)"MpResultScoreValidator_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                if (HRStringUtils.isEmpty((String)((String)levelName2SeqMap.get(mplop)))) {
                    importLog.writeRowLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), ResManager.loadKDString((String)"\u7b2cH\u5217\u7684\u5b57\u6bb5\u201c\u6c47\u603b\u7b49\u7ea7\u201d-\u8bc4\u4f30\u8868\u5355/\u7ed3\u679c\u6c47\u603b\u7684\u7b49\u7ea7\u89c4\u5219\u4e2d\u65e0\u6b64\u7b49\u7ea7", (String)"MpResultScoreValidator_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
                impEvaObjObj.put("mplop", levelName2SeqMap.get(mplop));
            } else {
                impEvaObjObj.put("mplop", (Object)"");
            }
            impEvaObjObj.put("mpsopgenway", (Object)MpSopGenWayEnum.RESULT_IMPORT.getCode());
        }
    }
}

