/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumResultSetBo;
import kd.opmc.epa.common.enums.activitymanage.ErDealRuleEnum;
import kd.opmc.epa.common.enums.activitymanage.MpModeEnum;

public class MpResultViewPlugin
extends HRDataBaseEdit {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();

    public void beforeBindData(EventObject e) {
        DynamicObject mprule;
        super.beforeBindData(e);
        Long objId = (Long)this.getView().getFormShowParameter().getCustomParam("actObjId");
        DynamicObject actEvalObj = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryByPkValue(objId);
        DynamicObject dynamicObject = mprule = actEvalObj.getDynamicObject("mprealrule") != null ? actEvalObj.getDynamicObject("mprealrule") : actEvalObj.getDynamicObject("activity").getDynamicObject("mprule");
        if (mprule == null) {
            return;
        }
        DynamicObject rule = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryMpRuleByPkValue(mprule.getPkValue());
        this.setPersonInfo(actEvalObj, rule);
        this.addEntryData(actEvalObj, rule);
        this.setTips(rule);
    }

    private void setPersonInfo(DynamicObject actEvalObj, DynamicObject rule) {
        String score;
        Image headSculpture = (Image)this.getView().getControl("headsculpture");
        headSculpture.setUrl(HRImageUrlUtil.getImageFullUrl((String)actEvalObj.getString("person.headsculpture")));
        Long perffile = actEvalObj.getLong("perffile.id");
        Long employee = actEvalObj.getLong("employee.id");
        this.getModel().setValue("perffile", (Object)perffile);
        this.getModel().setValue("employee", (Object)employee);
        String group = actEvalObj.getString("assgroup.name");
        Label assessgroup = (Label)this.getControl("assessgroup");
        assessgroup.setText(group);
        BigDecimal mpsop = actEvalObj.getBigDecimal("mpsop");
        mpsop = this.setDataScale(actEvalObj, mpsop);
        String mplop = actEvalObj.getString("mplop");
        if (StringUtils.isNotBlank((CharSequence)mplop)) {
            long flowId = actEvalObj.getLong("activity.perfworkflow.id");
            long assessFormId = actEvalObj.getLong("activity.assessform.id");
            String mplopStr = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.mplopMapping(flowId, assessFormId, mplop);
            score = mpsop + "/" + mplopStr;
        } else {
            score = String.valueOf(mpsop);
        }
        Label scoreLabel = (Label)this.getControl("score");
        scoreLabel.setText(score);
        String mpformula = rule.getString("mpformula");
        Label yearresultLabel = (Label)this.getControl("yearresult");
        yearresultLabel.setText(mpformula);
    }

    private void addEntryData(DynamicObject actEvalObj, DynamicObject rule) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.dealWithSetter(setter, actEvalObj, rule);
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void dealWithSetter(TableValueSetter setter, DynamicObject actEvalObj, DynamicObject rule) {
        setter.addField("period", new Object[0]);
        setter.addField("adminorg", new Object[0]);
        setter.addField("position", new Object[0]);
        setter.addField("job", new Object[0]);
        setter.addField("result", new Object[0]);
        setter.addField("proportion", new Object[0]);
        setter.addField("number", new Object[0]);
        DynamicObject mprule = actEvalObj.getDynamicObject("mprule");
        DynamicObject[] mpResults = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryMpResultByObjId(Long.valueOf(actEvalObj.getLong("id")));
        DynamicObjectCollection cols = rule.getDynamicObjectCollection("entryentity");
        Map<String, BigDecimal> timeTagMap = cols.stream().collect(Collectors.toMap(dy -> dy.getLong("calcitem.id") + dy.getString("timetag"), dy -> dy.getBigDecimal("weight"), (k1, k2) -> k1));
        String mpmode = rule.getString("mpmode");
        for (DynamicObject dy2 : mpResults) {
            DynamicObject perffile = dy2.getDynamicObject("perffile");
            String adminorg = perffile.getString("affiliateadminorg.name");
            String position = perffile.getString("position.name");
            String job = perffile.getString("job.name");
            BigDecimal sop = dy2.getBigDecimal("sop");
            sop = this.setDataScale(actEvalObj, sop);
            String lop = dy2.getString("lop");
            String mappingResult = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getMappingResultByMplop(Long.valueOf(dy2.getLong("perfleve.id")), lop);
            String result = StringUtils.isEmpty((CharSequence)lop) ? String.valueOf(sop) : sop + "|" + mappingResult;
            BigDecimal proportion = null;
            if (!MpModeEnum.AVG_WEIGHT.getCode().equals(mpmode)) {
                String key;
                Object pkValue = dy2.getPkValue();
                String timetag = dy2.getString("timetag");
                String string = key = mprule == null ? 0 + timetag : pkValue + timetag;
                if (timeTagMap.get(key) != null) {
                    proportion = timeTagMap.get(key).setScale(2, 4);
                }
            }
            setter.addRow(new Object[]{dy2.getString("period"), adminorg, position, job, result, proportion, dy2.getString("number")});
        }
    }

    private void setTips(DynamicObject rule) {
        String erdealrule = rule.getString("erdealrule");
        ErDealRuleEnum ruleEnum = ErDealRuleEnum.getRuleByCode((String)erdealrule);
        this.getModel().setValue("erdealrule", (Object)ruleEnum.getCode());
        String field = ruleEnum.getField();
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = this.service.getTips("epa_mpruleset", field, dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipContent));
            props.put("tips", tips);
            this.getView().updateControlMetadata("tip", props);
        }
    }

    private BigDecimal setDataScale(DynamicObject actEvalObj, BigDecimal value) {
        long activityId = actEvalObj.getLong("activity.id");
        PerfSumResultSetBo bo = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getScale(activityId);
        String numAccuracy = bo.getNumAccuracy();
        String scaleType = bo.getScaleType();
        if (StringUtils.isNotBlank((CharSequence)numAccuracy) && StringUtils.isNotBlank((CharSequence)scaleType)) {
            value = value.setScale(Integer.parseInt(bo.getNumAccuracy()), ScalaTypeEnum.get((String)bo.getScaleType()).getType());
        }
        return value;
    }
}

