/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.hr.expt.common.plugin.BeforeShowConfirmMessageEventArgs;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.evaladjustment.ActEvalObjAdjApplicationService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumDomainService;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumResultDomainService;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.activitymanage.performsummary.utils.ListUtil;
import kd.opmc.epa.formplugin.web.utils.ActManageUtils;

public class PerfSummaryCompletedList
extends EvalObjBaseList
implements HRExportPlugin {
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final PerfSumDomainService PERF_SUM_DOMAIN_SERVICE = PerfSumDomainService.getInstance();
    private static final PerfSumResultDomainService PERF_SUM_RESULT_DOMAIN_SERVICE = PerfSumResultDomainService.getInstance();
    private static final ActEvalObjAdjApplicationService ACT_EVAL_OBJ_ADJ_APPLICATION_SERVICE = ActEvalObjAdjApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    private DynamicObject[] getEvaluationObjects() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Long[] evalObjectIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(Arrays.asList(evalObjectIdList));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        ListUtil.setScoreAndLevel(args, activityId);
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("mpgroup.name".equals(fieldName)) {
            List qFilters = args.getQfilters();
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("epa_mpgroup");
            DynamicObject[] groupibjs = baseServiceHelper.queryOriginalArray("id", new QFilter[]{new QFilter("activity", "=", (Object)activityId)});
            List id = Stream.of(groupibjs).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", id));
        }
    }

    public void setFilter(SetFilterEvent filterEvent) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        List objIds = ACT_EVAL_OBJ_ADJ_APPLICATION_SERVICE.queryPerfSummaryedObjIdByActivityId(activityId);
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        filterEvent.getQFilters().add(filter);
        filterEvent.setOrderBy("modifytime desc,perffile.affiliateadminorg.name asc,perffile.billno  asc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "donothing_resetsumresult": {
                this.resetEvalPerfSum(args);
                break;
            }
            case "export_from_impttpl_hr": {
                IPageCache pageCache = this.getView().getPageCache();
                Long activity = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                pageCache.put("activityId", String.valueOf(activity));
                pageCache.put("exportSource", "epa_tobeperfsum_" + operateKey);
                break;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "refresh": {
                Long prenode = ((Integer)this.getView().getFormShowParameter().getCustomParam("prenode")).longValue();
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                ActManageUtils.refreshPerformSummaryCount(this.getView(), this.getView().getParentView(), prenode, activityId);
                break;
            }
        }
    }

    private void resetEvalPerfSum(BeforeDoOperationEventArgs args) {
        Long activityId;
        DynamicObject[] evalDyArr = this.getEvaluationObjects();
        int totalCount = evalDyArr.length;
        StringBuilder message = new StringBuilder();
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        int failureCount = PERF_SUM_DOMAIN_SERVICE.dealResetEvalSum(message, evalDyArr, nodeIndex, activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity"));
        if (failureCount > 0) {
            String title = ResManager.loadKDString((String)"\u5171{0}\u6761\uff1a\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"PerfSummaryCompletedList_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{totalCount, totalCount - failureCount, failureCount});
            this.getView().showMessage(title, message.toString(), MessageTypes.Default);
            this.getView().invokeOperation("refresh");
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f", (String)"PerfSummaryCompletedList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    public void beforeShowConfirmMessage(BeforeShowConfirmMessageEventArgs args) {
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(args.getPageId());
        IPageCache pageCache = view.getPageCache();
        String activityId = pageCache.get("activityId");
        String exportSource = pageCache.get("exportSource");
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("activityId", activityId);
        params.put("exportSource", exportSource);
        args.setExtParams(SerializationUtils.toJsonString(params));
        super.beforeShowConfirmMessage(args);
    }

    public void beforeWriteData(BeforeWriteDataEventArgs args) {
        super.beforeWriteData(args);
        List tplDataRows = args.getTplDataRows();
        if (tplDataRows.isEmpty()) {
            return;
        }
        PERF_SUM_RESULT_DOMAIN_SERVICE.assembleMpResultExport(args, tplDataRows);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        switch (fieldName = event.getFieldName()) {
            case "perffile_name": {
                this.ShowResultForm();
                break;
            }
        }
        args.setCancel(true);
    }

    private void ShowResultForm() {
        boolean existRule;
        Object focusRowPkId = this.getFocusRowPkId();
        DynamicObject actEvalObj = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryByPkValue(Long.valueOf(Long.parseLong(focusRowPkId.toString())));
        boolean bl = existRule = actEvalObj.getDynamicObject("mprealrule") != null;
        if (existRule) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("epa_mpresultdialog");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setCustomParam("actObjId", focusRowPkId);
            this.getView().showForm(formShowParameter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u7ed3\u679c\u6c47\u603b\u8bb0\u5f55\u3002", (String)"PerfSummaryCompletedList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        ListUtil.decimalDisplayeFormatHandle(args, activityId, "mpsop");
    }

    @Override
    public void setEnableCustomSum(EnableCustomSumEvent args) {
        args.setEnableCustomSum(false);
        super.setEnableCustomSum(args);
    }
}

