/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.mp.entityservice.MpRuleEntityService;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumCalDomainService;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetEntryVO;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetVO;
import kd.opmc.epa.common.enums.activitymanage.PerfSumTaskTypeEnum;
import kd.opmc.epa.formplugin.web.utils.MpRuleUtils;

public class PerformSummarygroupEditPlugin
extends HRDataBaseEdit
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(PerformSummarygroupEditPlugin.class);
    private static final String WEIGHTSET = "weightset";
    private static final String ER_DEALRULE = "erdealrule";
    private static final List<String> TIME_TAG_ALL = Arrays.asList("M1", "M2", "M3", "Q1", "M4", "M5", "M6", "Q2", "H1", "M7", "M8", "M9", "Q3", "M10", "M11", "M12", "Q4", "H2", "Y");
    private static final MpRuleEntityService MP_RULE_ENTITY_SERVICE = MpRuleEntityService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final PerfSumCalDomainService perfSumCalDomainService = PerfSumCalDomainService.getInstance();
    public static final String LASTMODIFYROW = "lastmodifyrow";
    public static final String ISMODIFY = "ismodify";
    public static final String ORIGINVALUE = "originvalue";
    public static final String ISMODIFYCONFIRM = "ismodifyconfirm";
    public static final String TRUE = "true";
    public static final String SAVE = "save";
    public static final String MODIFYCONFIRM = "modifyconfirm";
    public static final String LASTMODIFYGROUPNAME = "lastmodifygroupname";

    public void afterBindData(EventObject e) {
        OperationStatus status;
        super.afterBindData(e);
        int row = (Integer)this.getView().getFormShowParameter().getCustomParam("currentRow");
        this.getView().getParentView().getPageCache().put(LASTMODIFYROW, String.valueOf(row));
        this.getView().getParentView().getPageCache().put(LASTMODIFYGROUPNAME, ((OrmLocaleValue)this.getView().getModel().getValue("name")).getLocaleValue());
        this.showRulePage();
        String ismodify = (String)this.getView().getFormShowParameter().getCustomParam(ISMODIFY);
        if (TRUE.equals(ismodify)) {
            this.getView().getPageCache().put(ISMODIFY, TRUE);
            this.getView().getPageCache().put(ORIGINVALUE, String.valueOf(this.getModel().getValue("ismpruleset")));
        }
        if (OperationStatus.VIEW == (status = this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave1"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if (SAVE.equals(source.getOperateKey())) {
            this.getView().getParentView().getPageCache().put(LASTMODIFYGROUPNAME, ((OrmLocaleValue)this.getView().getModel().getValue("name")).getLocaleValue());
            Long activity = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            this.getView().getModel().setValue("activity", (Object)activity);
            IPageCache pageCache = this.getView().getPageCache();
            if (TRUE.equals(pageCache.get(ISMODIFY))) {
                Boolean currValue = (Boolean)this.getView().getModel().getValue("ismpruleset");
                boolean originvalue = Boolean.parseBoolean(pageCache.get(ORIGINVALUE));
                if (!originvalue ^ currValue || TRUE.equals(pageCache.get(ISMODIFYCONFIRM))) {
                    this.setRule(args, pageCache);
                    return;
                }
                if (originvalue) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u7684\u6c47\u603b\u89c4\u5219\u5df2\u5173\u95ed\uff0c\u5c06\u6309\u7167\u8003\u6838\u6d3b\u52a8\u914d\u7f6e\u7684\u89c4\u5219\u8ba1\u7b97\u8bc4\u4f30\u7ed3\u679c\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u64cd\u4f5c\u3002", (String)"PerformSummarygroupEditPlugin_0", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MODIFYCONFIRM, (IFormPlugin)this));
                } else {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u7684\u6c47\u603b\u89c4\u5219\u5df2\u5f00\u542f\uff0c\u5c06\u6309\u7167\u5206\u7ec4\u914d\u7f6e\u7684\u89c4\u5219\u8ba1\u7b97\u8bc4\u4f30\u7ed3\u679c\u3002\u8bf7\u786e\u8ba4\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u64cd\u4f5c\u3002", (String)"PerformSummarygroupEditPlugin_1", (String)"opmc-pbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MODIFYCONFIRM, (IFormPlugin)this));
                }
                args.setCancel(true);
                return;
            }
            this.setRule(args, pageCache);
        }
    }

    private void setRule(BeforeDoOperationEventArgs args, IPageCache pageCache) {
        if (!((Boolean)this.getView().getModel().getValue("ismpruleset")).booleanValue()) {
            this.getView().getModel().setValue("mprule", null);
            return;
        }
        String pageid = pageCache.get("pageid");
        IFormView childview = this.getView().getView(pageid);
        MpRuleSetVO ruleSetVO = this.getRuleSetVO(childview);
        if (this.valideVOWeight(ruleSetVO)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u91cd\u4e4b\u548c\u987b=100", (String)"PerformSummarygroupEditPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else {
            DynamicObject dynamicObject = MP_RULE_ENTITY_SERVICE.saveByVo(ruleSetVO, Long.valueOf(0L));
            Object pkValue = dynamicObject.getPkValue();
            this.getView().getModel().setValue("mprule", pkValue);
        }
        this.getView().getPageCache().put(ORIGINVALUE, String.valueOf(this.getModel().getValue("ismpruleset")));
        this.getView().getPageCache().put(ISMODIFYCONFIRM, "false");
    }

    private boolean valideVOWeight(MpRuleSetVO mpRuleSetVO) {
        boolean result = false;
        if (mpRuleSetVO.getMpmode() == 1) {
            return result;
        }
        List entryentities = mpRuleSetVO.getEntryentities();
        BigDecimal total = new BigDecimal("0");
        BigDecimal validWeight = new BigDecimal("100");
        for (MpRuleSetEntryVO vo : entryentities) {
            total = total.add(vo.getWeight());
        }
        return validWeight.compareTo(total) != 0;
    }

    private MpRuleSetVO getRuleSetVO(IFormView childview) {
        MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
        ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
        mpRuleSetVO.setMpmode(Integer.parseInt((String)childview.getModel().getValue(WEIGHTSET)));
        mpRuleSetVO.setErdealrule(Integer.parseInt((String)childview.getModel().getValue(ER_DEALRULE)));
        if (mpRuleSetVO.getMpmode() == 2) {
            for (String tag : TIME_TAG_ALL) {
                MpRuleSetEntryVO vo = new MpRuleSetEntryVO();
                if (!((Boolean)childview.getModel().getValue(tag)).booleanValue()) continue;
                vo.setTimetag(tag.toUpperCase(Locale.ROOT));
                vo.setTimetag(tag);
                entryentities.add(vo);
                if (childview.getModel().getValue(tag.toLowerCase(Locale.ROOT) + "weight") == null) continue;
                vo.setWeight((BigDecimal)childview.getModel().getValue(tag.toLowerCase(Locale.ROOT) + "weight"));
            }
        } else {
            MpRuleUtils.buildEntryVO(entryentities, this.getPeriodDynamicObjects());
        }
        mpRuleSetVO.setEntryentities(entryentities);
        return mpRuleSetVO;
    }

    private DynamicObjectCollection getPeriodDynamicObjects() {
        Long activity = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        HRBaseServiceHelper activityService = new HRBaseServiceHelper("epa_activity");
        DynamicObject[] query = activityService.query("scheme.id,executescheme,mprule", new QFilter[]{new QFilter("id", "=", (Object)activity)});
        Long schemeId = query[0].getLong("scheme.id");
        DynamicObject schemeDyn = ASSESS_SCHEME_APPLICATION_SERVICE.queryOne("mprule,mprule.entryentity,cycletype,cycletype.number,periodconfentity,periodconfentity.pcycletype,periodconfentity.pcycletype.name", schemeId);
        DynamicObjectCollection periodconfentity = new DynamicObjectCollection();
        periodconfentity = schemeDyn.getDynamicObjectCollection("periodconfentity");
        if (periodconfentity.size() == 0) {
            periodconfentity = new DynamicObjectCollection();
            DynamicObject periodconf = ASSESS_SCHEME_APPLICATION_SERVICE.generateEmptyEntryDynamicObject("periodconfentity");
            periodconf.set("pcycletype", schemeDyn.get("cycletype"));
            periodconfentity.add((Object)periodconf);
        }
        return periodconfentity;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        if (SAVE.equals(source.getOperateKey())) {
            IFormView parentView = this.getView().getParentView();
            parentView.getModel().setValue("isconfirm", (Object)true);
            int row = (Integer)this.getView().getFormShowParameter().getCustomParam("currentRow");
            DynamicObject entryRowEntity = parentView.getModel().getEntryRowEntity("indicatorgroupentry", row);
            entryRowEntity.set("indicatorgroup", this.getView().getModel().getValue("id"));
            entryRowEntity.set("indicatorgroup_id", this.getView().getModel().getValue("id"));
            parentView.updateView("indicatorgroupentry");
            this.getView().sendFormAction(parentView);
            Long pkid = (Long)this.getView().getModel().getValue("id");
            if (pkid == null || 0L == pkid) {
                return;
            }
            DynamicObject[] objs = this.updateEvalObj(pkid);
            List<Long> ids = Stream.of(objs).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            this.CalPerfsumData(ids);
        }
    }

    private DynamicObject[] updateEvalObj(Long pkid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("epa_actevalobj");
        QFilter qFilter = new QFilter("mpgroup", "=", (Object)pkid);
        DynamicObject[] objs = serviceHelper.query("id,mprealrule,ismprmodify,mprsource", new QFilter[]{qFilter});
        Boolean currValue = (Boolean)this.getView().getModel().getValue("ismpruleset");
        for (DynamicObject obj : objs) {
            if (((Boolean)this.getView().getModel().getValue("ismpruleset")).booleanValue()) {
                Long mpruleId = (Long)((DynamicObject)this.getModel().getValue("mprule")).getPkValue();
                obj.set("mprealrule", (Object)mpruleId);
                obj.set("ismprmodify", (Object)true);
                obj.set("mprsource", (Object)"3");
                continue;
            }
            obj.set("ismprmodify", (Object)false);
            obj.set("mprealrule", (Object)0L);
        }
        serviceHelper.save(objs);
        return objs;
    }

    private void CalPerfsumData(List<Long> ids) {
        try {
            perfSumCalDomainService.batchCalPerfSumData(ids, PerfSumTaskTypeEnum.GROUP_MODIFY);
        }
        catch (Exception exception) {
            LOG.error("\u6c47\u603b\u8ba1\u7b97\u9519\u8bef\uff1a", (Object)exception.getMessage());
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String name = event.getProperty().getName();
        if ("name".equals(name)) {
            int row = (Integer)this.getView().getFormShowParameter().getCustomParam("currentRow");
            IFormView parentView = this.getView().getParentView();
            parentView.getModel().setValue("isconfirm", (Object)false);
            parentView.getModel().setValue("issave", (Object)true);
            DynamicObject entryRowEntity = parentView.getModel().getEntryRowEntity("indicatorgroupentry", row);
            entryRowEntity.set("groupname", this.getView().getModel().getValue("name"));
            parentView.updateView("indicatorgroupentry");
            this.getView().sendFormAction(parentView);
        }
    }

    private void showRulePage() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        FormShowParameter showParameter = new FormShowParameter();
        this.setRuleInfo(showParameter);
        showParameter.setFormId("epa_mpruleset_inh");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("rule");
        showParameter.setStatus(status);
        String pageId = showParameter.getPageId();
        this.getView().getPageCache().put("pageid", pageId);
        this.getView().showForm(showParameter);
    }

    private void setRuleInfo(FormShowParameter showParameter) {
        Long activity = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        HRBaseServiceHelper activityService = new HRBaseServiceHelper("epa_activity");
        DynamicObject[] query = activityService.query("scheme.id,executescheme,mprule", new QFilter[]{new QFilter("id", "=", (Object)activity)});
        Long schemeId = query[0].getLong("scheme.id");
        if (this.getView().getModel().getValue("mprule") != null) {
            MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
            ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
            MpRuleUtils.buildVoByMpRule(this.getView().getModel().getDataEntity().getDynamicObject("mprule"), mpRuleSetVO, entryentities);
            mpRuleSetVO.setEntryentities(entryentities);
            showParameter.setCustomParam("tempvo", (Object)JSON.toJSONString((Object)mpRuleSetVO));
            showParameter.setCustomParam("scheme", (Object)schemeId);
        } else if (query[0].getDynamicObject("mprule") != null) {
            MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
            ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
            DynamicObject mpRuleDyn = MP_RULE_ENTITY_SERVICE.queryOne(Long.valueOf(query[0].getDynamicObject("mprule").getLong("id")));
            MpRuleUtils.buildVoByMpRule(mpRuleDyn, mpRuleSetVO, entryentities);
            mpRuleSetVO.setEntryentities(entryentities);
            showParameter.setCustomParam("tempvo", (Object)JSON.toJSONString((Object)mpRuleSetVO));
            showParameter.setCustomParam("scheme", (Object)schemeId);
        } else {
            long assessscopeid = query[0].getDynamicObject("executescheme").getLong("assessscope.id");
            HRBaseServiceHelper objectscopeService = new HRBaseServiceHelper("epa_objectscope");
            long schemeid = objectscopeService.queryOne((Object)assessscopeid).getLong("scheme.id");
            showParameter.setCustomParam("scheme", (Object)schemeid);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "modifyconfirm": {
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) break;
                this.getView().getPageCache().put(ISMODIFYCONFIRM, TRUE);
                this.getView().invokeOperation(SAVE);
            }
        }
    }
}

