/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.hr.expt.common.plugin.BeforeShowConfirmMessageEventArgs;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.hbp.business.service.operatelog.OperateLogService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.indicator.imp.helper.DataValidateServiceHelper;
import kd.opmc.epa.business.domain.mp.entityservice.MpCalcItemEntityService;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumDomainService;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumResultDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.activitymanage.actevalobj.EvalObjBaseList;
import kd.opmc.epa.formplugin.web.activitymanage.performsummary.utils.ListUtil;
import kd.opmc.epa.formplugin.web.utils.ActManageUtils;
import kd.opmc.epa.formplugin.web.utils.AssignIndicatorPageUtils;

public class TobePerformSummaryList
extends EvalObjBaseList
implements HRExportPlugin {
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final PerfSumDomainService PERF_SUM_DOMAIN_SERVICE = PerfSumDomainService.getInstance();
    private static final PerfSumResultDomainService PERF_SUM_RESULT_DOMAIN_SERVICE = PerfSumResultDomainService.getInstance();
    private static final MpCalcItemEntityService MP_CALC_ITEM_ENTITY_SERVICE = MpCalcItemEntityService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final ActEvalObjManageDomainService ACT_EVALOBJ_MANAGE_DOMAIN_SERVICE = ActEvalObjManageDomainService.getInstance();

    private DynamicObject[] getEvaluationObjects() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Long[] evalObjectIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        return EVALUATION_OBJECT_DOMAIN_SERVICE.queryEvaluationObjectById(Arrays.asList(evalObjectIdList));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("mpgroup.name".equals(fieldName)) {
            List qFilters = args.getQfilters();
            Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("epa_mpgroup");
            DynamicObject[] groupibjs = baseServiceHelper.queryOriginalArray("id", new QFilter[]{new QFilter("activity", "=", (Object)activityId)});
            List id = Stream.of(groupibjs).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", id));
        }
    }

    public void setFilter(SetFilterEvent filterEvent) {
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        QFilter preFilter = null;
        if (nodeIndex != 1) {
            Long prenode = ((Integer)this.getView().getFormShowParameter().getCustomParam("prenode")).longValue();
            preFilter = new QFilter("activity", "=", (Object)activityId).and("assessnode", "=", (Object)prenode).and("nodestatus", "=", (Object)AssessStausEnum.COMPLETED.getStatus());
        } else {
            preFilter = new QFilter("activity", "=", (Object)activityId).and("assessstaus", "=", (Object)"10");
        }
        QFilter currFilter = new QFilter("activity", "=", (Object)activityId).and("assessnode", "=", (Object)5L).and("nodestatus", "=", (Object)AssessStausEnum.HAVE_IN_HAND.getStatus());
        QFilter unionFilter = preFilter.or(currFilter);
        filterEvent.getQFilters().add(unionFilter);
        filterEvent.setOrderBy("modifytime desc,perffile.affiliateadminorg.name asc,perffile.billno  asc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        ListUtil.setScoreAndLevel(args, activityId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        IPageCache pageCache = this.getView().getPageCache();
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        switch (operateKey) {
            case "groupsettingps": {
                if ("1".equals(((DefaultEntityOperate)args.getSource()).getOption().getVariableValue("isgroupid", "0"))) break;
                this.showGroupSettingPage();
                args.setCancel(true);
                break;
            }
            case "groupconf": {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setCustomParam("activity", (Object)activityId);
                parameter.setFormId("epa_groupconf");
                parameter.setShowTitle(true);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss inlineStyleCss = new StyleCss();
                inlineStyleCss.setHeight("584");
                inlineStyleCss.setWidth("950");
                parameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "indicatorgroupset"));
                this.getView().showForm(parameter);
                break;
            }
            case "groupremove": {
                if ("1".equals(((DefaultEntityOperate)args.getSource()).getOption().getVariableValue("isconfirm", "0"))) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u9009\u62e9{0}\u4eba\uff0c\u5220\u9664\u5206\u7ec4\u540e\uff0c\u5df2\u4f7f\u7528\u5206\u7ec4\u6c47\u603b\u89c4\u5219\u7684\u8bc4\u4f30\u5bf9\u8c61\u5c06\u6309\u8003\u6838\u6d3b\u52a8\u7684\u6c47\u603b\u89c4\u5219\u91cd\u65b0\u8ba1\u7b97\u7ed3\u679c\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"TobePerformSummaryList_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{this.getSelectedRows().size()}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("isconfirm", (IFormPlugin)this));
                args.setCancel(true);
                return;
            }
            case "addothercycle": {
                HRBaseServiceHelper activityService = new HRBaseServiceHelper("epa_activity");
                DynamicObject dynamicObject = activityService.queryOriginalOne("activitystatus", (Object)activityId);
                if (!"30".equals(dynamicObject.getString("activitystatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u72b6\u6001\u4e0d\u4e3a\u201c\u6267\u884c\u4e2d\u201d\uff0c\u8be5\u529f\u80fd\u4e0d\u53ef\u7528", (String)"TobePerformSummaryList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListShowParameter evalobjlist = this.openNormalF7();
                this.getView().showForm((FormShowParameter)evalobjlist);
                break;
            }
            case "modifyrule": {
                this.modifyMpRule();
                break;
            }
            case "donothing_evalendsum": {
                this.endEvalSum(args);
                break;
            }
            case "donothing_sumcal": {
                this.dealSumCal(args);
                break;
            }
            case "notsummary": {
                DynamicObject activityDy = PERF_SUM_RESULT_DOMAIN_SERVICE.queryAssessFormByActivity(activityId);
                DynamicObject perfworkflowObj = activityDy.getDynamicObject("perfworkflow");
                long perfworkFlowId = perfworkflowObj.getLong("id");
                boolean isDependentSummary = ACT_EVALOBJ_MANAGE_DOMAIN_SERVICE.isDependentSummary(Long.valueOf(perfworkFlowId));
                if (isDependentSummary) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c\u7ed3\u679c\u6c47\u603b\u201d\u4e3a\u8003\u6838\u6d3b\u52a8\u4e2d\u7684\u9996\u4e2a\u8003\u6838\u6b65\u9aa4\uff0c\u672c\u529f\u80fd\u65e0\u6cd5\u4f7f\u7528\u3002", (String)"TobePerformSummaryList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                this.notSummary();
                break;
            }
            case "modifympresult": {
                this.openModifyMpResultPage();
                break;
            }
            case "export_from_impttpl_hr": {
                this.validateEvaObj4Export(args);
                Long activity = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                pageCache.put("activityId", String.valueOf(activity));
                pageCache.put("exportSource", "epa_tobeperfsum_" + operateKey);
                break;
            }
            case "viewcalcitem": {
                this.openViewCalcViewPage();
                break;
            }
            case "resetrule": {
                this.beforeReset(source);
            }
        }
    }

    private void beforeReset(AbstractOperate source) {
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        Object prenode = this.getView().getFormShowParameter().getCustomParam("prenode");
        source.getOption().setVariableValue("nodeindex", String.valueOf(nodeIndex));
        source.getOption().setVariableValue("prenode", String.valueOf(prenode));
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "importmpresult": {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Long activity = (Long)formShowParameter.getCustomParam("activity");
                Object[] selectIds = this.getSelectedRows().getPrimaryKeyValues();
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_mpresultimport");
                showParameter.setCustomParam("formId", (Object)"epa_actevalobj");
                showParameter.setCustomParam("RealPermissionEntityId", (Object)"epa_tobeperfsum");
                showParameter.setCustomParam("activity", (Object)activity);
                showParameter.setCustomParam("ServiceAppId", (Object)"epa");
                showParameter.setCustomParam("selectIds", (Object)selectIds);
                showParameter.setCustomParam("ListName", (Object)this.getView().getFormShowParameter().getCaption());
                showParameter.setCustomParam("nodeindex", formShowParameter.getCustomParam("nodeindex"));
                showParameter.setCustomParam("nodeindex", formShowParameter.getCustomParam("nodeindex"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setHasRight(true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "importmpresult"));
                this.getView().showForm(showParameter);
                break;
            }
            case "resetrule": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "refresh": {
                Long prenode = ((Integer)this.getView().getFormShowParameter().getCustomParam("prenode")).longValue();
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                ActManageUtils.refreshPerformSummaryCount(this.getView(), this.getView().getParentView(), prenode, activityId);
                break;
            }
            case "groupsettingps": 
            case "groupconf": 
            case "groupremove": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void dealSumCal(BeforeDoOperationEventArgs args) {
        Long activityId;
        DynamicObject[] evalDyArr = this.getEvaluationObjects();
        int totalCount = evalDyArr.length;
        StringBuilder message = new StringBuilder();
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        int failureCount = PERF_SUM_DOMAIN_SERVICE.dealSumCal(message, evalDyArr, nodeIndex, activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity"));
        if (failureCount > 0) {
            String title = ResManager.loadKDString((String)"\u5171{0}\u6761\uff1a\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"TobePerformSummaryList_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{totalCount, totalCount - failureCount, failureCount});
            this.getView().showMessage(title, message.toString(), MessageTypes.Default);
            this.getView().invokeOperation("refresh");
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6c47\u603b\u8ba1\u7b97\u6210\u529f", (String)"TobePerformSummaryList_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void endEvalSum(BeforeDoOperationEventArgs args) {
        Long activityId;
        DynamicObject[] evalDyArr = this.getEvaluationObjects();
        int totalCount = evalDyArr.length;
        StringBuilder message = new StringBuilder();
        int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
        int failureCount = PERF_SUM_DOMAIN_SERVICE.dealEndEvalSum(message, evalDyArr, nodeIndex, activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity"));
        if (failureCount > 0) {
            String title = ResManager.loadKDString((String)"\u5171{0}\u6761\uff1a\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"TobePerformSummaryList_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{totalCount, totalCount - failureCount, failureCount});
            this.getView().showMessage(title, message.toString(), MessageTypes.Default);
            this.getView().invokeOperation("refresh");
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u6c47\u603b\u6210\u529f", (String)"TobePerformSummaryList_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void modifyMpRule() {
        if (this.getSelectedRows().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u529f\u80fd\u4ec5\u652f\u6301\u5355\u9009\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"TobePerformSummaryList_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        Long actObjId = (Long)this.getSelectedRows().getPrimaryKeyValues()[0];
        DynamicObject[] calcitems = MP_CALC_ITEM_ENTITY_SERVICE.loadDynamicObjectArray(new QFilter[]{new QFilter("evaobj", "=", (Object)actObjId)});
        if (calcitems == null || calcitems.length <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53c2\u4e0e\u6c47\u603b\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TobePerformSummaryList_7", (String)"opmc-epa-business", (Object[])new Object[0]));
            return;
        }
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_mpmodifyrule");
        baseShowParameter.setCustomParam("actObjId", (Object)actObjId);
        baseShowParameter.setCustomParam("activity", (Object)activityId);
        baseShowParameter.setCustomParam("nodeindex", this.getView().getFormShowParameter().getCustomParam("nodeindex"));
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void showGroupSettingPage() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setBillFormId("epa_mpgroup");
        String groupName = AssignIndicatorPageUtils.getIndicatorGroupMetaName();
        String caption = ResManager.loadKDString((String)"\u6307\u5b9a{0}", (String)"TobePerformSummaryList_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{groupName});
        showParameter.setCaption(caption);
        showParameter.setFormId("epa_listff7grouptis");
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setShowTitle(false);
        showParameter.setMultiSelect(false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "groupsettingps"));
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        showParameter.setCustomParam("activity", (Object)activityId);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter("activity", "=", (Object)activityId));
        showParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private ListShowParameter openNormalF7() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("epa_listf7tips");
        listShowParameter.setBillFormId("pmd_perffileps");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u975e\u672c\u5468\u671f\u8bc4\u4f30\u5bf9\u8c61", (String)"TobePerformSummaryList_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        listShowParameter.setShowTitle(false);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList<QFilter> qFilters = this.getPerfileFilters();
        listShowParameter.setListFilterParameter(new ListFilterParameter(qFilters, "admissiondate desc, gradutiondate desc"));
        listShowParameter.getListFilterParameter().setFilter(new QFilter("archivesstatus", "=", (Object)"1"));
        QFilter date_pmd = DataValidateServiceHelper.getDataRule((String)"pmd_perffile", (String)"47150e89000000ac", new HashMap());
        listShowParameter.getListFilterParameter().setFilter(date_pmd);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("580");
        inlineStyleCss.setWidth("960");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addothercycle"));
        listShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        listShowParameter.setLookUp(true);
        return listShowParameter;
    }

    private ArrayList<QFilter> getPerfileFilters() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        HRBaseServiceHelper activity = new HRBaseServiceHelper("epa_activity");
        DynamicObject[] query = activity.query("executescheme,year", new QFilter[]{new QFilter("id", "=", (Object)activityId)});
        Long assessscopeId = query[0].getDynamicObject("executescheme").getLong("assessscope.id");
        Date year = (Date)query[0].get("year");
        HRBaseServiceHelper assessgroup = new HRBaseServiceHelper("epa_assessgroup");
        QFilter defaultGroup = new QFilter("isdefault", "=", (Object)"1");
        DynamicObject[] assessgroupList = assessgroup.query("id", new QFilter[]{new QFilter("objectscope", "=", (Object)assessscopeId), defaultGroup});
        if (assessgroupList == null || assessgroupList.length == 0) {
            assessgroupList = assessgroup.query("id", new QFilter[]{new QFilter("objectscope", "=", (Object)assessscopeId)});
        }
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("assessgroupid", assessgroupList[0].getPkValue().toString());
        HRBaseServiceHelper executescheme = new HRBaseServiceHelper("epa_executescheme");
        DynamicObject[] executeschemeList = executescheme.query("id", new QFilter[]{new QFilter("assessscope", "=", (Object)assessscopeId)});
        Long[] ids = (Long[])Arrays.stream(executeschemeList).map(executesche -> executesche.getLong("id")).toArray(Long[]::new);
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy");
            String curyear = format.format(year);
            String nextYear = format.format(HRDateTimeUtils.addYear((Date)year, (int)1));
            Date curyearDate = format.parse(curyear);
            Date nextyearDate = format.parse(nextYear);
            QFilter yearLargeFilter = new QFilter("year", ">=", (Object)curyearDate);
            QFilter yearLessFilter = new QFilter("year", "<", (Object)nextyearDate);
            DynamicObject[] activityList = activity.query("id", new QFilter[]{new QFilter("executescheme", "in", (Object)ids), yearLargeFilter, yearLessFilter});
            HRBaseServiceHelper actevalobj = new HRBaseServiceHelper("epa_actevalobj");
            Long[] actids = (Long[])Arrays.stream(activityList).map(act -> act.getLong("id")).toArray(Long[]::new);
            QFilter[] evalobjfilter = new QFilter[]{new QFilter("activity", "in", (Object)actids), new QFilter("assessstaus", "!=", (Object)"40")};
            DynamicObject[] actevalobjList = actevalobj.query("perffile", evalobjfilter);
            Set perfileIdList = Arrays.stream(actevalobjList).map(obj -> obj.getLong("perffile.id")).collect(Collectors.toSet());
            DynamicObject[] currActevalobjList = actevalobj.query("perffile", new QFilter[]{new QFilter("activity", "=", (Object)activityId)});
            Set currPerfileIdList = Arrays.stream(currActevalobjList).map(obj -> obj.getLong("perffile.id")).collect(Collectors.toSet());
            perfileIdList.removeAll(currPerfileIdList);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("id", "in", perfileIdList));
            return qFilters;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"importmpresult")) {
            this.getView().invokeOperation("refresh");
            ActManageUtils.refreshEvaluateCount(this.getView());
            return;
        }
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "groupsettingps": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                Long groupid = (Long)((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
                Object[] evalobjids = this.getSelectedRows().getPrimaryKeyValues();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("mpgroup", groupid.toString());
                operateOption.setVariableValue("isgroupid", "1");
                int nodeIndex1 = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
                operateOption.setVariableValue("nodeindex", String.valueOf(nodeIndex1));
                Long prenode = ((Integer)this.getView().getFormShowParameter().getCustomParam("prenode")).longValue();
                operateOption.setVariableValue("prenode", String.valueOf(prenode));
                this.getView().invokeOperation("groupsettingps", operateOption);
                this.getView().updateView();
                break;
            }
            case "modifyMpResultPage": {
                if ((Integer)returnData <= 0) break;
                this.getView().invokeOperation("refresh");
                ActManageUtils.refreshEvaluateCount(this.getView());
                break;
            }
            case "addothercycle": {
                ListSelectedRowCollection selectedList = (ListSelectedRowCollection)returnData;
                if (((ListSelectedRowCollection)returnData).size() <= 0) {
                    return;
                }
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("epa_actevalobj");
                Long assessgroupid = Long.valueOf(this.getView().getPageCache().get("assessgroupid"));
                Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
                int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
                String assessstaus = nodeIndex == 1 ? "10" : "20";
                int size = selectedList.size();
                ArrayList<DynamicObject> dynamicObjectslist = new ArrayList<DynamicObject>();
                Map<Long, DynamicObject> selectedPerfiles = this.getSelectedPerfiles(selectedList);
                HRBaseServiceHelper evalobj = new HRBaseServiceHelper("epa_actevalobj");
                QFilter qFilter = new QFilter("activity", "=", (Object)activityId);
                DynamicObject[] perfilds = evalobj.queryOriginalArray("perffile.id", new QFilter[]{qFilter});
                List existPerfile = Arrays.stream(perfilds).map(obj -> obj.getLong("perffile.id")).collect(Collectors.toList());
                int failcount = 0;
                ArrayList<String> errorMsg = new ArrayList<String>();
                for (int i = 0; i < size; ++i) {
                    Long perfileid = (Long)selectedList.get(i).getPrimaryKeyValue();
                    DynamicObject currPerfile = selectedPerfiles.get(perfileid);
                    String status = currPerfile.getString("archivesstatus");
                    if ("2".equals(status)) {
                        this.addErrorinfo(currPerfile, errorMsg);
                        ++failcount;
                        continue;
                    }
                    if (existPerfile.contains(perfileid)) {
                        this.addErrorInfoActivity(currPerfile, errorMsg);
                        ++failcount;
                        continue;
                    }
                    DynamicObject dynamicObject = this.genDynamicObject(serviceHelper, assessgroupid, activityId, nodeIndex, assessstaus, perfileid, currPerfile);
                    dynamicObjectslist.add(dynamicObject);
                }
                if (dynamicObjectslist.size() > 0) {
                    DynamicObject[] saveresult = dynamicObjectslist.toArray(new DynamicObject[0]);
                    serviceHelper.save(saveresult);
                    OperateLogService.commonWriteLog((String)"24E05ECYZ6K0", (String)"epa_actevalobj", (String)"addothercycle", (MultiLangEnumBridge)new MultiLangEnumBridge("\u786e\u5b9a", "TobePerformSummaryList_10", "opmc-epa-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6dfb\u52a0\u975e\u672c\u5468\u671f\u4fdd\u5b58\u6210\u529f", "TobePerformSummaryList_11", "opmc-epa-formplugin"), (String[])new String[0]);
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6dfb\u52a0\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"TobePerformSummaryList_12", (String)"opmc-epa-business", (Object[])new Object[]{size, size - failcount, failcount}), String.join((CharSequence)"\n", errorMsg), MessageTypes.Default);
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private DynamicObject genDynamicObject(HRBaseServiceHelper serviceHelper, Long assessgroupid, Long activityId, int nodeIndex, String assessstaus, Object perfileid, DynamicObject perfile) {
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("person", perfile.get("person"));
        dynamicObject.set("perffile", perfileid);
        dynamicObject.set("activity", (Object)activityId);
        dynamicObject.set("assessstaus", (Object)assessstaus);
        dynamicObject.set("assessnode", (Object)5L);
        dynamicObject.set("nodestatus", (Object)AssessNodeStatusEnum.MPING.getStatus());
        dynamicObject.set("iscurperiod", (Object)false);
        dynamicObject.set("nodeindex", (Object)nodeIndex);
        dynamicObject.set("assgroup", (Object)assessgroupid);
        dynamicObject.set("affiliateadminorg", perfile.get("affiliateadminorg"));
        dynamicObject.set("empposrel", perfile.get("empposrel"));
        dynamicObject.set("ressyncstatus", (Object)"10");
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("employee", perfile.get("employee"));
        dynamicObject.set("perforg", perfile.get("pmdorg"));
        return dynamicObject;
    }

    private void addErrorInfoActivity(DynamicObject perfile, ArrayList<String> errorMsg) {
        errorMsg.add(ResManager.loadKDString((String)"{0} {1}\uff1a\u7ee9\u6548\u6863\u6848\u5df2\u5b58\u5728\u4e8e\u8003\u6838\u6d3b\u52a8\u3002", (String)"TobePerformSummaryList_13", (String)"opmc-epa-business", (Object[])new Object[]{perfile.get("name"), perfile.get("billno")}));
    }

    private void addErrorinfo(DynamicObject perfile, ArrayList<String> errorMsg) {
        errorMsg.add(ResManager.loadKDString((String)"{0} {1}\uff1a\u7ee9\u6548\u6863\u6848\u5df2\u505c\u6b62\u8003\u6838\u3002", (String)"TobePerformSummaryList_14", (String)"opmc-epa-business", (Object[])new Object[]{perfile.get("name"), perfile.get("billno")}));
    }

    private Map<Long, DynamicObject> getSelectedPerfiles(ListSelectedRowCollection selectedList) {
        HRBaseServiceHelper perffileServiceHelper = new HRBaseServiceHelper("pmd_perffile");
        Long[] longs = (Long[])selectedList.stream().map(selected -> (Long)selected.getPrimaryKeyValue()).toArray(Long[]::new);
        QFilter qFilter = new QFilter("id", "in", (Object)longs);
        DynamicObject[] perfiles = perffileServiceHelper.queryOriginalArray("archivesstatus,id,name,billno,person,employee,empposrel,pmdorg,affiliateadminorg", new QFilter[]{qFilter});
        return Stream.of(perfiles).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isconfirm", "1");
            int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
            Long prenode = ((Integer)this.getView().getFormShowParameter().getCustomParam("prenode")).longValue();
            operateOption.setVariableValue("prenode", String.valueOf(prenode));
            operateOption.setVariableValue("nodeindex", String.valueOf(nodeIndex));
            this.getView().invokeOperation("groupremove", operateOption);
            this.getView().updateView();
        }
    }

    private void notSummary() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Long[] evalObjectIdList = (Long[])Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).toArray(Long[]::new);
        DynamicObject[] dynamicObjects = PERF_SUM_RESULT_DOMAIN_SERVICE.queryEvalObjWithMpResultById(Arrays.asList(evalObjectIdList));
        List failMessage = PERF_SUM_RESULT_DOMAIN_SERVICE.notSummary(this.getView(), dynamicObjects);
        int failCount = failMessage.size();
        int totalCount = dynamicObjects.length;
        if (failCount < 1) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TobePerformSummaryList_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else if (totalCount == 1) {
            this.getView().showErrorNotification((String)failMessage.get(0));
        } else {
            String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\uff0c\u5931\u8d25\u539f\u56e0", (String)"TobePerformSummaryList_16", (String)"opmc-epa-formplugin", (Object[])new Object[]{totalCount, totalCount - failCount, failCount});
            this.getView().showMessage(title, String.join((CharSequence)"\n", failMessage), MessageTypes.Default);
        }
        this.getView().invokeOperation("refresh");
    }

    private void openModifyMpResultPage() {
        Long activityIdTmp = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        FormShowParameter showParameter = new FormShowParameter();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List evalObjectIdList = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList());
        showParameter.setFormId("epa_modifympeval");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("activity", (Object)activityIdTmp);
        showParameter.setCustomParam("evalObjectIds", evalObjectIdList);
        showParameter.setCustomParam("nodeindex", this.getView().getFormShowParameter().getCustomParam("nodeindex"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifyMpResultPage"));
        this.getView().showForm(showParameter);
    }

    public void beforeShowConfirmMessage(BeforeShowConfirmMessageEventArgs args) {
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(args.getPageId());
        IPageCache pageCache = view.getPageCache();
        String activityId = pageCache.get("activityId");
        String exportSource = pageCache.get("exportSource");
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("activityId", activityId);
        params.put("exportSource", exportSource);
        args.setExtParams(SerializationUtils.toJsonString(params));
        super.beforeShowConfirmMessage(args);
    }

    public void beforeWriteData(BeforeWriteDataEventArgs args) {
        super.beforeWriteData(args);
        List tplDataRows = args.getTplDataRows();
        if (tplDataRows.isEmpty()) {
            return;
        }
        PERF_SUM_RESULT_DOMAIN_SERVICE.assembleMpResultExport(args, tplDataRows);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        switch (fieldName = event.getFieldName()) {
            case "perffile_name": {
                this.ShowResultForm();
                break;
            }
        }
        args.setCancel(true);
    }

    private void ShowResultForm() {
        boolean existRule;
        Object focusRowPkId = this.getFocusRowPkId();
        DynamicObject actEvalObj = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryByPkValue(Long.valueOf(Long.parseLong(focusRowPkId.toString())));
        boolean bl = existRule = actEvalObj.getDynamicObject("mprealrule") != null;
        if (existRule) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("epa_mpresultdialog");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setCustomParam("actObjId", focusRowPkId);
            this.getView().showForm(formShowParameter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u7ed3\u679c\u6c47\u603b\u8bb0\u5f55\u3002", (String)"TobePerformSummaryList_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateEvaObj4Export(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (!selectedRows.isEmpty()) {
            List evalObjectIdList = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(row -> Long.parseLong(row.toString())).collect(Collectors.toList());
            DynamicObject[] evalObjDyArr = PERF_SUM_RESULT_DOMAIN_SERVICE.queryEvalObjWithMpResultById(evalObjectIdList);
            int nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeindex");
            ArrayList<String> failMessageList = new ArrayList<String>(10);
            for (DynamicObject evalObj : evalObjDyArr) {
                if (!PERF_SUM_RESULT_DOMAIN_SERVICE.checkEvaObjNotInToBeMP(Integer.valueOf(nodeIndex), evalObj)) continue;
                failMessageList.add(ResManager.loadKDString((String)"{0} {1}: \u8bc4\u4f30\u5bf9\u8c61\u5df2\u4e0d\u5728\u7ed3\u679c\u6c47\u603b-\u5f85\u6c47\u603b\u5217\u8868\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"TobePerformSummaryList_18", (String)"opmc-epa-business", (Object[])new Object[]{evalObj.getString("perffile.name"), evalObj.getString("perffile.billno")}));
            }
            if (failMessageList.size() > 0) {
                String title = ResManager.loadKDString((String)"\u5f15\u51fa\u5931\u8d25\uff0c\u68c0\u67e5\u5f15\u51fa\u5931\u8d25\u7ed3\u679c\uff1a", (String)"TobePerformSummaryList_19", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(title, String.join((CharSequence)"\n", failMessageList), MessageTypes.Default);
                args.setCancel(true);
            }
        }
    }

    @Override
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        ListUtil.decimalDisplayeFormatHandle(args, activityId, "mpsop");
    }

    private void openViewCalcViewPage() {
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setPageId("epa_joinedmpresultmanage_" + activityId);
        showParameter.setFormId("epa_joinedmpresultmanage");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("activity", (Object)activityId);
        this.getView().showForm(showParameter);
    }

    @Override
    public void setEnableCustomSum(EnableCustomSumEvent args) {
        args.setEnableCustomSum(false);
        super.setEnableCustomSum(args);
    }
}

