/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.performsummary.utils;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.DecimalListColumn;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.perfsumcal.entity.PerfSumResultSetBo;
import kd.opmc.epa.business.domain.perfsumcal.service.PerfSumResultDomainService;

public class ListUtil {
    private static final PerfSumResultDomainService PERF_SUM_RESULT_DOMAIN_SERVICE = PerfSumResultDomainService.getInstance();

    public static void setScoreAndLevel(BeforeCreateListDataProviderArgs args, Long activityId) {
        PerfSumResultSetBo perfSumResultSetBo = PERF_SUM_RESULT_DOMAIN_SERVICE.getPerfSumDataDealSetByActivityId(activityId, Boolean.valueOf(false));
        final String[] numAccuracy = new String[]{perfSumResultSetBo.getNumAccuracy()};
        final String scaleType = perfSumResultSetBo.getScaleType();
        final Long perfLevelId = perfSumResultSetBo.getPerfLevelId();
        final Map levelNameMap = perfSumResultSetBo.getLevelNameMap();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    if (perfLevelId != null) {
                        String lop = row.getString("mplop");
                        row.set("mplop", levelNameMap.get(lop));
                    }
                    BigDecimal sop = row.getBigDecimal("mpsop");
                    if (HRStringUtils.isEmpty((String)numAccuracy[0])) {
                        numAccuracy[0] = "2";
                    }
                    sop = sop.setScale(Integer.parseInt(numAccuracy[0]), ScalaTypeEnum.get((String)scaleType).getType());
                    row.set("mpsop", (Object)sop);
                }
                return rows;
            }
        });
    }

    public static void decimalDisplayeFormatHandle(BeforeCreateListColumnsArgs args, Long activityId, String columkey) {
        PerfSumResultSetBo perfSumResultSetBo = PERF_SUM_RESULT_DOMAIN_SERVICE.getPerfSumDataDealSetByActivityId(activityId, Boolean.valueOf(false));
        String numAccuracy = perfSumResultSetBo.getNumAccuracy();
        if (HRStringUtils.isNotEmpty((String)numAccuracy)) {
            int numAccuracyInt = Integer.parseInt(numAccuracy);
            StringBuilder displayFormatStr = new StringBuilder("#");
            for (int i = 0; i < numAccuracyInt; ++i) {
                if (i == 0) {
                    displayFormatStr.append(".");
                }
                displayFormatStr.append("#");
            }
            DecimalListColumn listColumn = (DecimalListColumn)args.getListColumn(columkey);
            if (listColumn != null) {
                listColumn.setDisplayFormatString(displayFormatStr.toString());
            }
        }
    }
}

