/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.process;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.process.ProcessExecuteApplicationService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessObjectEntityService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.per.PassessNodeEnum;
import kd.opmc.epa.formplugin.web.utils.permission.ProcessExecutePermissionUtils;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class ProcessExecuteEditPlugin
extends HRDataBaseEdit
implements RowClickEventListener,
TabSelectListener,
AfterF7SelectListener,
BeforeF7SelectListener {
    private static final ProcessExecuteApplicationService PROCESS_EXECUTE_APPLICATION_SERVICE = ProcessExecuteApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessObjectEntityService ASSESS_OBJECT_ENTITY_SERVICE = AssessObjectEntityService.getInstance();
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();
    private static final Log LOG = LogFactory.getLog(ProcessExecuteEditPlugin.class);
    private static final String NULL_LINE_STR = "\n";
    private static final String ISFORBIDDEN = "isforbidden";
    private static final String CUSTOMCONTROLAP = "customcontrolap";
    private static final String SKIP_HIS_VERSION_CHANGE_TIPS = "skipHisVersionChangeTips";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("righttabap");
        tab.addTabSelectListener((TabSelectListener)this);
        CardEntry nodeEntry = (CardEntry)this.getView().getControl("activityentry");
        nodeEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"addtext", "addseq", "addcount", "addflex", "addflexleft", "addflexright", "addlabright"});
        this.addClickListeners(new String[]{"cootext", "cooflexright", "coocount", "coolabright", "cooflex"});
        this.addClickListeners(new String[]{"finishtext", "finishseq", "finishcount", "finishflex", "finishflexleft", "finishflexright", "finishlabright", "activitydetailflex"});
        this.addClickListeners(new String[]{"joinflex", "joinflexflex", "joinflextext", "joinflexparticipated", "joinflexrightlab"});
        this.addClickListeners(new String[]{"missflex", "missflexflex", "missflextext"});
        this.addClickListeners(new String[]{"notjoinflex", "notjoinflexflex", "notjoinflextext"});
        BasedataEdit groupF7 = (BasedataEdit)this.getView().getControl("objassessgroup");
        groupF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit resPersonF7 = (BasedataEdit)this.getView().getControl("respersonf7");
        resPersonF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        resPersonF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"workflowedit"});
        this.addClickListeners(new String[]{"dynpermissionedit"});
        this.addClickListeners(new String[]{"activityedit"});
        this.addClickListeners(new String[]{"dynperminfolabel"});
        this.addClickListeners(new String[]{"activityinfolabel"});
        this.addClickListeners(new String[]{"workflowinfolabel"});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
        this.initTips();
        this.initBaseInfo();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
    }

    private void initData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String status = dataEntity.getString("activitystatus");
        String lastSelectRowStr = this.getView().getPageCache().get("lastSelectRow");
        CardEntry assGroupCard = (CardEntry)this.getControl("activityentry");
        String assesstatus = (String)this.getView().getFormShowParameter().getCustomParam("assessstaus");
        if (StringUtils.isNotBlank((CharSequence)lastSelectRowStr)) {
            this.addNodeCard();
            int lastSelect = Integer.parseInt(lastSelectRowStr);
            if (lastSelect < 0) {
                this.showTabAndRefresh(lastSelectRowStr, false);
            } else {
                DynamicObjectCollection activityEntry = this.getModel().getEntryEntity("activityentry");
                DynamicObject object = activityEntry.stream().filter(obj -> lastSelectRowStr.equals(obj.getDynamicObject("activitynode").getPkValue().toString())).findFirst().orElse(null);
                int index = activityEntry.indexOf((Object)object);
                assGroupCard.selectCard(Integer.valueOf(index));
            }
        } else if (HRStringUtils.isNotEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("tabkey"))) && !HRStringUtils.equalsIgnoreCase((String)assesstatus, (String)"20")) {
            if (HRStringUtils.equalsIgnoreCase((String)assesstatus, (String)"10")) {
                String tabkey = (String)this.getView().getFormShowParameter().getCustomParam("tabkey");
                String labid = (String)this.getView().getFormShowParameter().getCustomParam("labid");
                this.showTabAndRefresh(tabkey, labid);
            } else if (HRStringUtils.equalsIgnoreCase((String)assesstatus, (String)"30")) {
                this.showTabAndRefresh("-1", true);
            }
        } else {
            Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
            int index = PROCESS_EXECUTE_APPLICATION_SERVICE.getNowNodeIndex(activityId);
            if (ActivityStatusEnum.TO_BE_EXECUTE.getValue().equals(status)) {
                this.showTabAndRefresh("-6", true);
            } else if (ActivityStatusEnum.COMPLETED.getValue().equals(status)) {
                this.showTabAndRefresh("-1", true);
            } else if (ActivityStatusEnum.EXECUTING.getValue().equals(status)) {
                this.addNodeCard();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("timeplanentry");
                Map map = PROCESS_EXECUTE_APPLICATION_SERVICE.queryCountByActId(activityId, entryEntity);
                int completeCount = (Integer)map.get("completed");
                if (index == 0 && completeCount == 0) {
                    this.showTabAndRefresh("joinedap", "-6");
                } else if (index == 0 && completeCount != 0) {
                    this.showTabAndRefresh("-1", true);
                } else {
                    int selectIndex = 0;
                    for (int nodeIndex = index + 1; nodeIndex > 0; --nodeIndex) {
                        Integer nodeCount = (Integer)map.get(String.valueOf(nodeIndex));
                        if (nodeCount == null || nodeCount <= 0) continue;
                        selectIndex = nodeIndex - 1;
                        break;
                    }
                    assGroupCard.selectCard(Integer.valueOf(selectIndex));
                }
            }
        }
        this.setStatusColor(ActivityStatusEnum.getActivityStatusEnum((String)status));
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        boolean permission = ProcessExecutePermissionUtils.checkPermission(this.getView());
        if (!permission) {
            evt.setCancel(true);
            return;
        }
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.contains("finish")) {
            this.showTabAndRefresh("-1", true);
        } else if (key.contains("notjoinflex")) {
            this.showTabAndRefresh("-5", true);
        } else if (key.contains("joinflex")) {
            this.showTabAndRefresh("-2", true);
        } else if (key.contains("missflex")) {
            this.showTabAndRefresh("-3", true);
        } else if (key.contains("add")) {
            this.showTabAndRefresh("-6", true);
            this.refreshAddTab();
        } else if (key.contains("coo")) {
            this.showTabAndRefresh("-7", true);
            this.refreshCooTab();
        }
    }

    public void click(EventObject evt) {
        Control con;
        Container fieldEdit;
        String fieldKey;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Container && "activitydetailflex".equals(fieldKey = (fieldEdit = (Container)source).getKey())) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("epa_evalactivity");
            showParameter.setPkId(this.getModel().getDataEntity().getPkValue());
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setPageId(this.getView().getPageId() + this.getView().getFormShowParameter().getAppId() + this.getModel().getDataEntity().getPkValue());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if ("workflowedit".equals((con = (Control)source).getKey()) && OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"41QGVNN=M9PQ")) {
            this.showWorkFlowDrow(OperationStatus.EDIT);
            this.openWorkFlowDraw();
        } else if ("dynpermissionedit".equals(con.getKey()) && PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"epa", (String)"epa_activity", (String)"41QGUMQT=JKC")) {
            this.showDynPermissionSettingPage(OperationStatus.EDIT);
            this.openDynPermissionSettingDraw();
        } else if ("activityedit".equals(con.getKey())) {
            this.showActivityDrow(OperationStatus.EDIT, BillOperationStatus.EDIT);
        } else if ("workflowinfolabel".equals(con.getKey())) {
            this.showWorkFlowDrow(OperationStatus.VIEW);
            this.openWorkFlowDraw();
        } else if ("dynperminfolabel".equals(con.getKey())) {
            this.showDynPermissionSettingPage(OperationStatus.VIEW);
            this.openDynPermissionSettingDraw();
        } else if ("activityinfolabel".equals(con.getKey())) {
            this.showActivityDrow(OperationStatus.VIEW, BillOperationStatus.VIEW);
        }
    }

    private void showDynPermissionSettingPage(OperationStatus operationStatus) {
        DynamicObject dynamicpermission = (DynamicObject)this.getModel().getValue("dynamicpermission");
        Long permissId = 0L;
        if (!ObjectUtils.isEmpty((Object)dynamicpermission)) {
            permissId = dynamicpermission.getLong("id");
        }
        Long activityId = this.getModel().getDataEntity().getLong("id");
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("epa_act_permissionsetting");
        baseShowParameter.setPageId(String.valueOf(permissId));
        baseShowParameter.setCustomParam("status", (Object)operationStatus.toString());
        baseShowParameter.setCustomParam("BATCH_SETTING", (Object)false);
        baseShowParameter.setCustomParam("processpermsetting", (Object)permissId);
        baseShowParameter.setCustomParam("activityId", (Object)activityId);
        baseShowParameter.setCustomParam("FromWhere", (Object)"Process");
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_act_permissionsetting"));
        baseShowParameter.setShowTitle(false);
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.getOpenStyle().setTargetKey(CUSTOMCONTROLAP);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("elementId", CUSTOMCONTROLAP + this.getView().getPageId());
        baseShowParameter.getOpenStyle().setCustParam(customParams);
        baseShowParameter.setHasRight(true);
        this.getView().showForm(baseShowParameter);
    }

    private void openDynPermissionSettingDraw() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOMCONTROLAP);
        map.put("show", "true");
        map.put("date", new Date());
        customcontrol.setData(map);
    }

    private void showWorkFlowDrow(OperationStatus operationStatus) {
        long pkId = this.getModel().getDataEntity().getDynamicObject("perfworkflow").getLong("id");
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("epa_activity_perfworkflow");
        showParameter.setPkId((Object)pkId);
        showParameter.setStatus(operationStatus);
        showParameter.setPageId(this.getView().getPageId() + "epa_activity_perfworkflow" + pkId);
        if (OperationStatus.EDIT == operationStatus) {
            showParameter.setCustomParam("isVersionDataPage", (Object)"1");
            showParameter.setCustomParam("fromPage", (Object)"revise");
            showParameter.setCustomParam("his_action", (Object)"open_revise_page");
            showParameter.setCustomParam("currentDataId", (Object)pkId);
            showParameter.setCustomParam("boid", (Object)pkId);
            showParameter.setCustomParam(SKIP_HIS_VERSION_CHANGE_TIPS, (Object)Boolean.TRUE);
        }
        showParameter.setCustomParam("activity.id", this.getModel().getValue("id"));
        if (this.getModel().getDataEntity().getDynamicObject("dynamicpermission") != null) {
            showParameter.setCustomParam("dynamicpermission.id", (Object)this.getModel().getDataEntity().getDynamicObject("dynamicpermission").getLong("id"));
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "flow_revise"));
        showParameter.setShowTitle(false);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(CUSTOMCONTROLAP);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("elementId", CUSTOMCONTROLAP + this.getView().getPageId());
        showParameter.getOpenStyle().setCustParam(customParams);
        showParameter.setHasRight(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("100vh");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openWorkFlowDraw() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOMCONTROLAP);
        map.put("show", "true");
        map.put("date", new Date());
        customcontrol.setData(map);
    }

    public void entryRowClick(RowClickEvent evt) {
        boolean permission = ProcessExecutePermissionUtils.checkPermission(this.getView());
        if (!permission) {
            return;
        }
        Object source = evt.getSource();
        if (source instanceof CardEntry && HRStringUtils.equals((String)"activityentry", (String)((CardEntry)source).getKey())) {
            int rowId;
            int lastSelectRow;
            int row = evt.getRow();
            DynamicObjectCollection activityEntry = this.getModel().getEntryEntity("activityentry");
            Object pkValue = ((DynamicObject)activityEntry.get(row)).getDynamicObject("activitynode").getPkValue();
            String lastSelectRowStr = this.getView().getPageCache().get("lastSelectRow");
            if (!ObjectUtils.isEmpty((Object)lastSelectRowStr) && (lastSelectRow = Integer.parseInt(lastSelectRowStr)) == (rowId = Integer.parseInt(String.valueOf(pkValue)))) {
                return;
            }
            for (int i = 0; i < activityEntry.size(); ++i) {
                this.getView().getModel().setValue("isselected", (Object)Boolean.FALSE, i);
            }
            this.getView().getModel().setValue("isselected", (Object)Boolean.TRUE, row);
            this.showTabAndRefresh(String.valueOf(pkValue), true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate source = (AbstractOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "donothing_refreshtab": {
                this.refreshTabBySubPage();
                break;
            }
        }
    }

    private void refreshTabBySubPage() {
        Tab tab = (Tab)this.getView().getControl("righttabap");
        tab.activeTab("evaluatingap");
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        boolean permission = ProcessExecutePermissionUtils.checkPermissionNotMsg();
        if (!permission) {
            String firstSelectTab = this.getView().getPageCache().get("SEL_TAB_NOT_PERMISSION");
            if ("true".equals(firstSelectTab)) {
                this.getView().getPageCache().put("SEL_TAB_NOT_PERMISSION", "false");
                String caption = FormMetadataCache.getFormConfig((String)"epa_activity").getCaption().getLocaleValue();
                String message = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u67e5\u8be2\u201d\u548c\u201c\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProcessExecuteEditPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), caption);
                this.getView().showErrorNotification(message);
            } else {
                this.getView().getPageCache().put("SEL_TAB_NOT_PERMISSION", "true");
                String cacheTabKey = this.getView().getPageCache().get("tabkey");
                Tab tab = (Tab)this.getView().getControl("righttabap");
                tab.activeTab(cacheTabKey);
            }
            return;
        }
        String tabKey = tabSelectEvent.getTabKey();
        this.getView().getPageCache().put("tabkey", tabKey);
        ProcessManageApEnum manageApEnum = ProcessManageApEnum.getProcessManageApByTab((String)tabKey);
        String curLabId = this.getView().getPageCache().get("lastSelectRow");
        if (HRStringUtils.equals((String)"-6", (String)curLabId) && HRStringUtils.equals((String)tabKey, (String)"joinedap")) {
            manageApEnum = ProcessManageApEnum.ADD;
        }
        this.refreshTab(manageApEnum);
    }

    private void showTabAndRefresh(String labId, boolean isInit) {
        this.getModel().setValue("selectlab", (Object)labId);
        this.getView().getPageCache().put("lastSelectRow", labId);
        Tab tab = (Tab)this.getView().getControl("righttabap");
        List tabs = ProcessManageApEnum.getTabsByLabId((String)labId);
        for (Control control : tab.getItems()) {
            if (!tabs.contains(control.getKey())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{control.getKey()});
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{control.getKey()});
        }
        if (!ObjectUtils.isEmpty((Object)tabs)) {
            String key;
            String string = key = isInit ? (String)tabs.get(0) : this.getView().getPageCache().get("tabkey");
            if (labId.equals("-6")) {
                this.refreshAddTab();
            } else if (ProcessManageApEnum.COOPERATOR.getLabId().equals(labId)) {
                this.refreshCooTab();
            }
            tab.activeTab(key);
        }
    }

    private void refreshTab(ProcessManageApEnum manageApEnum) {
        if ("-1".equals(manageApEnum.getLabId())) {
            this.showOrRefreshRightList(manageApEnum, 0);
        }
        if ("-6".equals(manageApEnum.getLabId())) {
            this.refreshAddTab();
            this.showOrRefreshRightList(manageApEnum, 0);
        } else if ("-5".equals(manageApEnum.getLabId())) {
            this.showOrRefreshRightList(manageApEnum, 0);
        } else if ("-3".equals(manageApEnum.getLabId())) {
            this.showOrRefreshRightList(manageApEnum, 0);
        } else if (String.valueOf(NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId()).equals(manageApEnum.getLabId())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("timeplanentry");
            Integer nodeIndex = entryEntity.stream().filter(row -> row.getDynamicObject("activity").getString("id").equals(manageApEnum.getLabId())).map(row -> row.getInt("seq")).findFirst().orElse(0);
            this.refreshTargetFormulateTab(nodeIndex, manageApEnum.getLabId());
            this.showOrRefreshRightList(manageApEnum, nodeIndex);
        } else if (String.valueOf(NodeTabMapEnum.EVAL_PROCESS.getNodeId()).equals(manageApEnum.getLabId())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("timeplanentry");
            Integer nodeIndex = entryEntity.stream().filter(row -> row.getDynamicObject("activity").getString("id").equals(manageApEnum.getLabId())).map(row -> row.getInt("seq")).findFirst().orElse(0);
            this.refreshTobeEvaluatedTab(nodeIndex, manageApEnum.getLabId());
            this.showOrRefreshRightList(manageApEnum, nodeIndex);
        } else if (!String.valueOf(NodeTabMapEnum.PERF_CALIBRATION.getNodeId()).equals(manageApEnum.getLabId()) && !String.valueOf(NodeTabMapEnum.PERF_INTERVIEW.getNodeId()).equals(manageApEnum.getLabId())) {
            if (String.valueOf(NodeTabMapEnum.RESULT_CONFIRM.getNodeId()).equals(manageApEnum.getLabId())) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("timeplanentry");
                Integer nodeIndex = entryEntity.stream().filter(row -> row.getDynamicObject("activity").getString("id").equals(manageApEnum.getLabId())).map(row -> row.getInt("seq")).findFirst().orElse(0);
                this.refreshConfirmTab(nodeIndex, manageApEnum.getLabId());
                this.showOrRefreshRightList(manageApEnum, nodeIndex);
            } else if (String.valueOf(NodeTabMapEnum.PERF_SUM.getNodeId()).equals(manageApEnum.getLabId())) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("timeplanentry");
                Integer nodeIndex = entryEntity.stream().filter(row -> row.getDynamicObject("activity").getString("id").equals(manageApEnum.getLabId())).map(row -> row.getInt("seq")).findFirst().orElse(0);
                Long preNode = 0L;
                if (nodeIndex > 1) {
                    for (DynamicObject dynamicObject : entryEntity) {
                        if (dynamicObject.getInt("seq") != nodeIndex - 1) continue;
                        preNode = dynamicObject.getLong("activity.id");
                        break;
                    }
                }
                this.refreshPerformSummaryTab(preNode, 5L);
                this.showOrRefreshRightList(manageApEnum, nodeIndex);
            } else if ("-7".equals(manageApEnum.getLabId())) {
                this.refreshCooTab();
                this.showOrRefreshRightList(manageApEnum, 0);
            }
        }
        this.addNodeCard();
    }

    private void refreshAddTab() {
        Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
        Map map = PROCESS_EXECUTE_APPLICATION_SERVICE.queryJoinInCountByActId(activityId);
        Label addCountLab = (Label)this.getControl("addcount");
        Label addCountHoverLab = (Label)this.getControl("addcounthover");
        int all = map.values().stream().mapToInt(Integer::intValue).sum();
        addCountLab.setText(String.valueOf(all));
        addCountHoverLab.setText(String.valueOf(all));
        TabPage planpartAp = (TabPage)this.getControl("planpartap");
        planpartAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u9000\u51fa\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{map.get("exited")})));
        int joined = map.values().stream().mapToInt(Integer::intValue).sum() - (Integer)map.get("exited");
        TabPage joinedAp = (TabPage)this.getControl("joinedap");
        joinedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u53c2\u4e0e\u8003\u6838\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{joined})));
    }

    private void refreshCooTab() {
        Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
        int count = PROCESS_EXECUTE_APPLICATION_SERVICE.countCoorganizerByActivityId(activityId);
        Label cooCountLab = (Label)this.getControl("coocount");
        Label cooCountHoverLab = (Label)this.getControl("coocounthover");
        cooCountLab.setText(String.valueOf(count));
        cooCountHoverLab.setText(String.valueOf(count));
        TabPage coorganizerAp = (TabPage)this.getControl("coorganizerap");
        coorganizerAp.setText(new LocaleString(ResManager.loadKDString((String)"\u534f\u529e\u4eba\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{count})));
    }

    private void refreshJoinInTab() {
        Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
        Map map = PROCESS_EXECUTE_APPLICATION_SERVICE.queryJoinInCountByActId(activityId);
        int joined = (Integer)map.get("joined");
        int inHand = (Integer)map.get("haveInHand");
        int completed = (Integer)map.get("completed");
        int exited = (Integer)map.get("exited");
        TabPage joinedAp = (TabPage)this.getControl("joinedap");
        TabPage inHandAp = (TabPage)this.getControl("inhandap");
        TabPage completedAp = (TabPage)this.getControl("completedap");
        TabPage exitedAp = (TabPage)this.getControl("exitedap");
        joinedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u672a\u5f00\u59cb\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{joined})));
        inHandAp.setText(new LocaleString(ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{inHand})));
        completedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{completed})));
        exitedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u9000\u51fa\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{exited})));
    }

    private void refreshTobeEvaluatedTab(Integer nodeIndex, String labId) {
        Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
        Map map = PROCESS_EXECUTE_APPLICATION_SERVICE.queryNodeCountByActId(activityId, nodeIndex, Long.valueOf(Long.parseLong(labId)));
        int tobeevaluatedCount = (Integer)map.get(AssessNodeStatusEnum.TO_BE_EVALUATED.getLabelName());
        int evaluatingCount = (Integer)map.get(AssessNodeStatusEnum.EVALUATING.getLabelName());
        int completedCount = (Integer)map.get(AssessNodeStatusEnum.EVALUATED.getLabelName());
        TabPage evaluatedAp = (TabPage)this.getControl("evaluatedap");
        TabPage tobeEvaluatedAp = (TabPage)this.getControl("tobeevaluatedap");
        TabPage evaluatingAp = (TabPage)this.getControl("evaluatingap");
        tobeEvaluatedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5f85\u542f\u52a8\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{tobeevaluatedCount})));
        evaluatingAp.setText(new LocaleString(ResManager.loadKDString((String)"\u8bc4\u4f30\u4e2d\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[]{evaluatingCount})));
        evaluatedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{completedCount})));
        evaluatedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{completedCount})));
    }

    private void refreshPerformSummaryTab(Long preNode, Long currNodeId) {
        Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
        Map result = PROCESS_EXECUTE_APPLICATION_SERVICE.queryPerformSummaryCountByActId(activityId, preNode, currNodeId);
        int toBePerformSummaryCount = (Integer)result.get("notcompletedCount");
        int performSummaryedCount = (Integer)result.get("completedCount");
        TabPage toperformsumAp = (TabPage)this.getControl("toperformsum");
        TabPage performsumedAp = (TabPage)this.getControl("performsumed");
        toperformsumAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5f85\u6c47\u603b\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_9", (String)"opmc-epa-formplugin", (Object[])new Object[]{toBePerformSummaryCount})));
        performsumedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{performSummaryedCount})));
    }

    private void refreshTargetFormulateTab(Integer nodeIndex, String labId) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"formulatingap", "formulatedap", "tobeformulatedap"});
        Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
        Map map = PROCESS_EXECUTE_APPLICATION_SERVICE.queryNodeCountByActId(activityId, nodeIndex, Long.valueOf(Long.parseLong(labId)));
        Map joinInCountMap = PROCESS_EXECUTE_APPLICATION_SERVICE.queryJoinInCountByActId(activityId);
        int tobeFormulatedCount = (Integer)joinInCountMap.get("joined");
        int formulatingCount = (Integer)map.get(AssessNodeStatusEnum.TARGET_FORMULATING.getLabelName());
        int formulatedCount = (Integer)map.get(AssessNodeStatusEnum.TARGET_FORMULATED.getLabelName());
        TabPage tobeFormulatedAp = (TabPage)this.getControl("tobeformulatedap");
        TabPage formulatingAp = (TabPage)this.getControl("formulatingap");
        TabPage formulatedAp = (TabPage)this.getControl("formulatedap");
        tobeFormulatedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5f85\u5236\u5b9a\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_11", (String)"opmc-epa-formplugin", (Object[])new Object[]{tobeFormulatedCount})));
        formulatingAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5236\u5b9a\u4e2d\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_11", (String)"opmc-epa-formplugin", (Object[])new Object[]{formulatingCount})));
        this.refreshAddTab();
        formulatedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{formulatedCount})));
    }

    private void refreshConfirmTab(Integer nodeIndex, String labId) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"tobeconfirmedap", "confirmingap", "confirmedap"});
        Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
        Map map = PROCESS_EXECUTE_APPLICATION_SERVICE.queryNodeCountByActId(activityId, nodeIndex, Long.valueOf(Long.parseLong(labId)));
        int tobeConfirmedCount = (Integer)map.get(AssessNodeStatusEnum.TO_BE_CONFIRMED.getLabelName());
        int confirmingCount = (Integer)map.get(AssessNodeStatusEnum.CONFIRMING.getLabelName());
        int tobeAppealCount = (Integer)map.get(AssessNodeStatusEnum.TO_BE_APPEAL.getLabelName());
        int appealingCount = (Integer)map.get(AssessNodeStatusEnum.APPEALING.getLabelName());
        int terminateCount = (Integer)map.get(AssessNodeStatusEnum.TERMINATE.getLabelName());
        int confirmedCount = (Integer)map.get(AssessNodeStatusEnum.CONFIRMED.getLabelName());
        TabPage toConfirmedAp = (TabPage)this.getControl("tobeconfirmedap");
        TabPage confirmingAp = (TabPage)this.getControl("confirmingap");
        TabPage confirmedAp = (TabPage)this.getControl("confirmedap");
        toConfirmedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5f85\u786e\u8ba4\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_12", (String)"opmc-epa-formplugin", (Object[])new Object[]{tobeConfirmedCount})));
        confirmingAp.setText(new LocaleString(ResManager.loadKDString((String)"\u786e\u8ba4\u4e2d\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_13", (String)"opmc-epa-formplugin", (Object[])new Object[]{confirmingCount + tobeAppealCount + appealingCount + terminateCount})));
        confirmedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"ProcessExecuteEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{confirmedCount})));
    }

    private void showOrRefreshRightList(ProcessManageApEnum manageApEnum, Integer nodeIndex) {
        String rightListViewPageId = this.getView().getPageCache().get(manageApEnum.getTab());
        IFormView rightListView = this.getView().getView(rightListViewPageId);
        if (rightListView != null) {
            rightListView.invokeOperation("refresh");
            this.getView().sendFormAction(rightListView);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        if (HRStringUtils.equals((String)manageApEnum.getFormId(), (String)ProcessManageApEnum.EVALUATING.getFormId())) {
            parameter.setFormId("epa_evallisttemplate");
        }
        if (ProcessManageApEnum.TO_BE_EVALUATED.getFormId().equals(manageApEnum.getFormId())) {
            parameter.setFormId("epa_tobeevaltemplate");
        }
        if (ProcessManageApEnum.TO_BE_FORMULATED.getFormId().equals(manageApEnum.getFormId())) {
            parameter.setFormId("epa_tobeformaletemplate");
        }
        if (ProcessManageApEnum.TARGET_FORMULATING.getFormId().equals(manageApEnum.getFormId())) {
            parameter.setFormId("epa_formalingtemplate");
        }
        parameter.setBillFormId(manageApEnum.getFormId());
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(manageApEnum.getTab());
        Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
        parameter.setCustomParam("activity", (Object)activityId);
        parameter.setCustomParam("nodeindex", (Object)nodeIndex);
        parameter.setCustomParam("billFormId", (Object)manageApEnum.getFormId());
        Long scopeId = this.getModel().getDataEntity().getLong("executescheme.assessscope.id");
        parameter.setCustomParam("objectscope", (Object)scopeId);
        String status = this.getModel().getDataEntity().getString("activitystatus");
        parameter.setCustomParam("activitystatus", (Object)status);
        if ("epa_actevalobjjoined".equals(manageApEnum.getFormId())) {
            this.getPageCache().put("epa_actevalobjjoined", parameter.getPageId());
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("timeplanentry");
        parameter.setCustomParam("prenode", (Object)0L);
        if (nodeIndex > 1) {
            for (DynamicObject dynamicObject : entryEntity) {
                if (dynamicObject.getInt("seq") != nodeIndex - 1) continue;
                parameter.setCustomParam("prenode", (Object)dynamicObject.getLong("activity.id"));
                break;
            }
        }
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().setVisible(Boolean.TRUE, new String[]{"righttabap"});
        this.getView().getPageCache().put(manageApEnum.getTab(), parameter.getPageId());
    }

    private void addNodeCard() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        this.dealWithSetter(setter);
        model.deleteEntryData("activityentry");
        model.batchCreateNewEntryRow("activityentry", setter);
        model.endInit();
        this.getView().updateView("activityentry");
    }

    private void dealWithSetter(TableValueSetter setter) {
        int seq = 1;
        setter.addField("activitynode", new Object[0]);
        setter.addField("nodename", new Object[0]);
        setter.addField("nodeseq", new Object[0]);
        setter.addField("nodeseqselected", new Object[0]);
        setter.addField("nodecount", new Object[0]);
        setter.addField("istop", new Object[0]);
        setter.addField("isselected", new Object[0]);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("timeplanentry");
        HashMap<String, Integer> nodeIndexMap = new HashMap<String, Integer>();
        for (DynamicObject obj : entryEntity) {
            nodeIndexMap.put(obj.getDynamicObject("activity").getString("id"), 0);
        }
        Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
        Map map = PROCESS_EXECUTE_APPLICATION_SERVICE.queryCountByActId(activityId, entryEntity);
        Map formulatingMap = PROCESS_EXECUTE_APPLICATION_SERVICE.queryNodeCountByActId(activityId, Integer.valueOf(1), Long.valueOf(1L));
        Map joinInCountMap = PROCESS_EXECUTE_APPLICATION_SERVICE.queryJoinInCountByActId(activityId);
        int tobeFormulatedCount = (Integer)joinInCountMap.get("joined");
        int formulatingCount = (Integer)formulatingMap.get(AssessNodeStatusEnum.TARGET_FORMULATING.getLabelName());
        nodeIndexMap.put("1", tobeFormulatedCount + formulatingCount);
        Map nodeCountMap = PROCESS_EXECUTE_APPLICATION_SERVICE.queryNodeCountByActId(activityId, Integer.valueOf(2), Long.valueOf(Long.parseLong("4")));
        int tobeEvaluatedCount = (Integer)nodeCountMap.get(AssessNodeStatusEnum.TO_BE_EVALUATED.getLabelName());
        int evaluatingCount = (Integer)nodeCountMap.get(AssessNodeStatusEnum.EVALUATING.getLabelName());
        nodeIndexMap.put("4", tobeEvaluatedCount + evaluatingCount);
        for (int nodexIndex = 1; nodexIndex < entryEntity.size() + 1; ++nodexIndex) {
            DynamicObject nodeDyn = (DynamicObject)entryEntity.get(nodexIndex - 1);
            Long nodeId = nodeDyn.getDynamicObject("activity").getLong("id");
            if (!PassessNodeEnum.RESULT_CONFIRMATION.getValue().equals(nodeId)) continue;
            Map tabCountMap = PROCESS_EXECUTE_APPLICATION_SERVICE.queryNodeCountByActId(activityId, Integer.valueOf(nodexIndex), nodeId);
            int tobeConfirmedCount = (Integer)tabCountMap.get(AssessNodeStatusEnum.TO_BE_CONFIRMED.getLabelName());
            int confirmingCount = (Integer)tabCountMap.get(AssessNodeStatusEnum.CONFIRMING.getLabelName());
            int tobeAppealCount = (Integer)tabCountMap.get(AssessNodeStatusEnum.TO_BE_APPEAL.getLabelName());
            int terminateCount = (Integer)tabCountMap.get(AssessNodeStatusEnum.TERMINATE.getLabelName());
            int appealingCount = (Integer)tabCountMap.get(AssessNodeStatusEnum.APPEALING.getLabelName());
            nodeIndexMap.put(nodeId.toString(), tobeConfirmedCount + confirmingCount + tobeAppealCount + appealingCount + terminateCount);
        }
        String lastSelectRowStr = this.getView().getPageCache().get("lastSelectRow");
        DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)((Long)this.getModel().getDataEntity().getPkValue()));
        long perfWorkFlowId = activityDynObj.getLong("perfworkflow.id");
        DynamicObject workFlowDynObj = PERF_WORK_FLOW_DOMAIN_SERVICE.loadSingleWorkFlow(perfWorkFlowId);
        DynamicObjectCollection workEntryEntity = workFlowDynObj.getDynamicObjectCollection("entryentity");
        Map<Long, String> nodeNameMap = workEntryEntity.stream().filter(data -> data.getBoolean("isshow")).collect(Collectors.toMap(data -> data.getDynamicObject("node").getLong("id"), data -> data.getString("customname"), (key1, key2) -> key2));
        for (DynamicObject obj : entryEntity) {
            int count = (Integer)map.get(String.valueOf(seq));
            long id = obj.getDynamicObject("activity").getLong("id");
            if (id == 1L || id == 4L || id == 8L) {
                count = (Integer)nodeIndexMap.get(String.valueOf(id));
            }
            if (seq == 1 && id == 5L) {
                count = (Integer)map.get("joined") + count;
            }
            boolean isSelected = StringUtils.equals((CharSequence)String.valueOf(id), (CharSequence)lastSelectRowStr);
            setter.addRow(new Object[]{id, nodeNameMap.get(id), seq, seq, count, seq == 1, isSelected});
            ++seq;
        }
        this.drawPanel(seq, map);
    }

    private void drawPanel(int seq, Map<String, Integer> map) {
        Label finishLab = (Label)this.getControl("finishseq");
        Label finishHoverLab = (Label)this.getControl("finishseqhover");
        finishLab.setText(String.valueOf(seq));
        finishHoverLab.setText(String.valueOf(seq));
        int completed = map.get("completed");
        Label finishCountLab = (Label)this.getControl("finishcount");
        Label finishCountHoverLab = (Label)this.getControl("finishcounthover");
        finishCountLab.setText(String.valueOf(completed));
        finishCountHoverLab.setText(String.valueOf(completed));
        int participated = map.get("joinflexparticipated");
        Label partLab = (Label)this.getControl("joinflexparticipated");
        Label partHoverLab = (Label)this.getControl("participatedhover");
        partLab.setText(String.valueOf(participated));
        partHoverLab.setText(String.valueOf(participated));
        Long activityId = (Long)this.getModel().getDataEntity().getPkValue();
        Map joinMap = PROCESS_EXECUTE_APPLICATION_SERVICE.queryJoinInCountByActId(activityId);
        Label addCountLab = (Label)this.getControl("addcount");
        Label addCountHoverLab = (Label)this.getControl("addcounthover");
        int all = joinMap.values().stream().mapToInt(Integer::intValue).sum();
        addCountLab.setText(String.valueOf(all));
        addCountHoverLab.setText(String.valueOf(all));
        int count = PROCESS_EXECUTE_APPLICATION_SERVICE.countCoorganizerByActivityId(activityId);
        Label cooCountLab = (Label)this.getControl("coocount");
        Label cooCountHoverLab = (Label)this.getControl("coocounthover");
        cooCountLab.setText(String.valueOf(count));
        cooCountHoverLab.setText(String.valueOf(count));
    }

    private void initTips() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String tipContent = PROCESS_EXECUTE_APPLICATION_SERVICE.getTips("vectorap", dataEntity);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            String no = ResManager.loadKDString((String)"\u5426", (String)"ProcessExecuteEditPlugin_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            String yes = ResManager.loadKDString((String)"\u662f", (String)"ProcessExecuteEditPlugin_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            String title = ResManager.loadKDString((String)"\u8003\u6838\u6d3b\u52a8\u4fe1\u606f", (String)"ProcessExecuteEditPlugin_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            tipContent = tipContent.replace("false", no);
            tipContent = tipContent.replace("true", yes);
            if (ResManager.loadKDString((String)"\u6c47\u603b", (String)"ProcessExecuteEditPlugin_26", (String)"opmc-epa-formplugin", (Object[])new Object[0]).equals(dataEntity.getString("executescheme.assesssumtype"))) {
                int formFirstInd = tipContent.indexOf(ResManager.loadKDString((String)"\u8bc4\u4f30\u8868\u5355", (String)"ProcessExecuteEditPlugin_27", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                int formLastInd = tipContent.indexOf(NULL_LINE_STR, formFirstInd);
                tipContent = tipContent.replace(tipContent.substring(formFirstInd, formLastInd + 1), "");
                int wayFirstInd = tipContent.indexOf(ResManager.loadKDString((String)"\u5f97\u5206\u8ba1\u7b97\u65b9\u5f0f", (String)"ProcessExecuteEditPlugin_28", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                int wayLastInd = tipContent.indexOf(NULL_LINE_STR, wayFirstInd);
                tipContent = tipContent.replace(tipContent.substring(wayFirstInd, wayLastInd + 1), "");
            }
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setPlace("right");
            tips.setType("text");
            tips.setShowIcon(false);
            tips.setTitle(new LocaleString(title));
            tips.setContent(new LocaleString(tipContent));
            props.put("tips", tips);
            this.getView().updateControlMetadata("moreinfo", props);
        }
    }

    private void setStatusColor(ActivityStatusEnum statusEnum) {
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((Control)evt.getSource()).getKey();
        if ("objassessgroup".equals(fieldKey)) {
            boolean permission = ProcessExecutePermissionUtils.checkPermission(this.getView());
            if (!permission) {
                return;
            }
            DynamicObject group = this.getModel().getDataEntity().getDynamicObject("objassessgroup");
            if (group == null) {
                return;
            }
            String childPageId = this.getPageCache().get("epa_actevalobjjoined");
            IListView childView = (IListView)this.getView().getView(childPageId);
            ListSelectedRowCollection selectedRows = childView.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
            ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.updateAssessObjGroup(pkValue, Long.valueOf(group.getLong("id")), primaryKeyValues);
            childView.refresh();
            childView.showSuccessNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u8003\u6838\u7ec4\u6210\u529f", (String)"ProcessExecuteEditPlugin_20", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("systeminvoke", "true");
            childView.invokeOperation("changegroup", operateOption);
            this.getView().sendFormAction((IFormView)childView);
        } else if (HRStringUtils.equals((String)"respersonf7", (String)fieldKey)) {
            this.setResponsePerson();
            String childPageId = this.getPageCache().get("epa_actevalobjjoined");
            IListView childView = (IListView)this.getView().getView(childPageId);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("systeminvoke", "true");
            childView.invokeOperation("setresperson", operateOption);
            childView.invokeOperation("refresh");
            this.getView().sendFormAction((IFormView)childView);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fileKey = e.getProperty().getName();
        if (HRStringUtils.isNotEmpty((String)fileKey) && "respersonf7".equals(fileKey)) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter(ISFORBIDDEN, "=", (Object)false));
        }
    }

    private void showTabAndRefresh(String tabkey, String labId) {
        if (StringUtils.isBlank((CharSequence)tabkey)) {
            return;
        }
        this.getModel().setValue("selectlab", (Object)labId);
        this.getView().getPageCache().put("lastSelectRow", labId);
        Tab tab = (Tab)this.getView().getControl("righttabap");
        List tabs = ProcessManageApEnum.getTabsByLabId((String)labId);
        for (Control control : tab.getItems()) {
            if (!tabs.contains(control.getKey())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{control.getKey()});
                continue;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{control.getKey()});
        }
        if (!ObjectUtils.isEmpty((Object)tabs)) {
            if (labId.equals("-6")) {
                this.refreshAddTab();
            }
            tab.activeTab(tabkey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResponsePerson() {
        String childPageId = this.getPageCache().get("epa_actevalobjjoined");
        IListView childView = (IListView)this.getView().getView(childPageId);
        IFormView parentView = this.getView();
        ListSelectedRowCollection selectedRows = childView.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (Object primaryKeyValue : primaryKeyValues) {
            idList.add((Long)primaryKeyValue);
        }
        DynamicObjectCollection personF7 = (DynamicObjectCollection)parentView.getModel().getValue("respersonf7");
        DynamicObject[] evaluationObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryActivityEvaluationObjectById("id,perffile.id, resperson,assessstaus, nodeindex, assessnode, nodestatus", idList);
        Object pkValue = this.getView().getModel().getDataEntity().getPkValue();
        DynamicObject curActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne(pkValue);
        DynamicObject[] assessObjects = ASSESS_OBJECT_ENTITY_SERVICE.queryListBySchemeId("id,perfile.id,resperson", Long.valueOf(curActivity.getLong("scheme.id")));
        HashMap<Long, DynamicObject> assessObjMap = new HashMap<Long, DynamicObject>(assessObjects.length);
        ArrayList<DynamicObject> assessObjsToSave = new ArrayList<DynamicObject>();
        for (DynamicObject obj : assessObjects) {
            assessObjMap.put(obj.getLong("perfile.id"), obj);
        }
        for (DynamicObject evaluationObject : evaluationObjects) {
            DynamicObjectCollection personColl = this.getResPersonColl(personF7, evaluationObject);
            evaluationObject.set("resperson", (Object)personColl);
            Long personId = evaluationObject.getLong("perffile.id");
            DynamicObject assessObj = (DynamicObject)assessObjMap.get(personId);
            if (assessObj == null) continue;
            DynamicObjectCollection personCollOfAssessobj = this.getResPersonColl(personF7, assessObj);
            assessObj.set("resperson", (Object)personCollOfAssessobj);
            assessObjsToSave.add(assessObj);
        }
        try (TXHandle required = TX.required();){
            if (assessObjsToSave.size() > 0) {
                ASSESS_OBJECT_ENTITY_SERVICE.save(assessObjsToSave.toArray(new DynamicObject[0]));
            }
            ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evaluationObjects);
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u8003\u6838\u8d23\u4efb\u4eba\u6210\u529f", (String)"ProcessExecuteEditPlugin_21", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObjectCollection getResPersonColl(DynamicObjectCollection personF7, DynamicObject evaluationObject) {
        DynamicObjectCollection personColl = evaluationObject.getDynamicObjectCollection("resperson");
        personColl.clear();
        for (DynamicObject person : personF7) {
            DynamicObject newCurrency = new DynamicObject(personColl.getDynamicObjectType());
            newCurrency.set("fbasedataid", person.get("fbasedataid"));
            personColl.add((Object)newCurrency);
        }
        return personColl;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Tab tab = (Tab)this.getView().getControl("righttabap");
        String tabKey = tab.getCurrentTab();
        this.getView().getPageCache().put("tabkey", tabKey);
        ProcessManageApEnum manageApEnum = ProcessManageApEnum.getProcessManageApByTab((String)tabKey);
        String curLabId = this.getView().getPageCache().get("lastSelectRow");
        if (HRStringUtils.equals((String)"-6", (String)curLabId) && HRStringUtils.equals((String)tabKey, (String)"joinedap")) {
            manageApEnum = ProcessManageApEnum.ADD;
        }
        switch (actionId) {
            case "epa_act_permissionsetting": {
                this.closeCustomDraw();
                break;
            }
            case "epa_evalactivity": {
                this.closeCustomDraw();
                this.refreshTab(manageApEnum);
                break;
            }
            case "flow_revise": {
                this.refreshTab(manageApEnum);
                break;
            }
        }
    }

    private void closeCustomDraw() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOMCONTROLAP);
        if (customcontrol != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("show", "false");
            map.put("date", new Date());
            customcontrol.setData(map);
        }
    }

    private void initBaseInfo() {
        Label activityeditlabel = (Label)this.getView().getControl("activityeditlabel");
        Label activityinfolabel = (Label)this.getView().getControl("activityinfolabel");
        Label workfloweditlabel = (Label)this.getView().getControl("workfloweditlabel");
        Label workflowinfolabel = (Label)this.getView().getControl("workflowinfolabel");
        Label dynpermeditlabel = (Label)this.getView().getControl("dynpermeditlabel");
        Label dynperminfolabel = (Label)this.getView().getControl("dynperminfolabel");
        activityeditlabel.setText(this.getModel().getDataEntity().getString("name"));
        activityinfolabel.setText(this.getModel().getDataEntity().getString("name"));
        workfloweditlabel.setText(this.getModel().getDataEntity().getString("perfworkflow.name"));
        workflowinfolabel.setText(this.getModel().getDataEntity().getString("perfworkflow.name"));
        String permName = ResManager.loadKDString((String)"\u6743\u9650\u65b9\u6848", (String)"ProcessExecuteEditPlugin_22", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
        dynpermeditlabel.setText(permName);
        dynperminfolabel.setText(permName);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String status = dataEntity.getString("activitystatus");
        if (ActivityStatusEnum.COMPLETED.getValue().equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"floweditpanel", "permissioneditpanel", "activityeditpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flowinfopanel", "permissioninfopanel", "activityinfopanel"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"floweditpanel", "permissioneditpanel", "activityeditpanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flowinfopanel", "permissioninfopanel", "activityinfopanel"});
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasWorkflowPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"41QGVNN=M9PQ");
        boolean hasDynPermPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_activity", (String)"41QGUMQT=JKC");
        if (!hasWorkflowPermission) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"floweditpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flowinfopanel"});
        }
        if (!hasDynPermPermission) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"permissioneditpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"permissioninfopanel"});
        }
    }

    private void showActivityDrow(OperationStatus operationStatus, BillOperationStatus billOperationStatus) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("epa_evalactivity");
        showParameter.setPkId(this.getModel().getDataEntity().getPkValue());
        showParameter.setBillStatus(billOperationStatus);
        showParameter.setStatus(operationStatus);
        showParameter.setPageId(this.getView().getPageId() + this.getView().getFormShowParameter().getAppId() + this.getModel().getDataEntity().getPkValue());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_evalactivity"));
        showParameter.getShowParameter().setCustomParam("source", (Object)"epa_processmanage");
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1100");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setShowTitle(false);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(CUSTOMCONTROLAP);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("elementId", CUSTOMCONTROLAP + this.getView().getPageId());
        showParameter.getOpenStyle().setCustParam(customParams);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
        HashMap<String, Object> map = new HashMap<String, Object>();
        CustomControl customcontrol = (CustomControl)this.getView().getControl(CUSTOMCONTROLAP);
        map.put("show", "true");
        map.put("date", new Date());
        customcontrol.setData(map);
    }
}

