/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.targetformulate;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.formplugin.web.activitymanage.targetformulate.FormulateBaseList;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowCommonResultBo;
import kd.opmc.pbs.common.utils.OpmcPermissionUtils;

public class FormulateDetailList
extends FormulateBaseList {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();
    private static final String ROLE_NAME = "flowrurole.flowdefrole.rolename";
    private Map<Long, String> COOPERATOR_MAP = new HashMap<Long, String>(16);

    public void setFilter(SetFilterEvent event) {
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeseq");
        QFilter nodeIndexFilter = new QFilter("flowrunode.index", "=", (Object)nodeIndex);
        QFilter isCooperatorTask = new QFilter("iscotask", "=", (Object)"0");
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        QFilter activityFilter = new QFilter("activity", "=", (Object)activityId);
        QFilter nodeStatusFilter = new QFilter("epa_actevalobj.nodestatus", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()).and("epa_actevalobj.assessnode", "=", (Object)Long.valueOf(ProcessManageApEnum.TARGET_FORMULATING.getLabId())).and("epa_actevalobj.nodeindex", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId()).or(new QFilter("epa_actevalobj.nodestatus", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getStatus()).and("epa_actevalobj.assessnode", "=", (Object)Long.valueOf(ProcessManageApEnum.TARGET_FORMULATED.getLabId())).and("epa_actevalobj.nodeindex", "=", (Object)AssessNodeStatusEnum.TARGET_FORMULATED.getNodeId()));
        Long evalFlowId = (Long)this.getView().getFormShowParameter().getCustomParam("formulateflow");
        QFilter evalFlowFilter = new QFilter("epa_actevalobj.formulateflow", "=", (Object)evalFlowId);
        event.getQFilters().add(isCooperatorTask);
        event.getQFilters().add(nodeIndexFilter);
        event.getQFilters().add(activityFilter);
        event.getQFilters().add(nodeStatusFilter);
        event.getQFilters().add(evalFlowFilter);
        event.setOrderBy("taskstatus desc");
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        super.beforePackageData(dataEvent);
        DynamicObjectCollection pageData = dataEvent.getPageData();
        if (!pageData.isEmpty()) {
            List taskIds = pageData.stream().map(actObj -> actObj.getLong("id")).collect(Collectors.toList());
            this.COOPERATOR_MAP = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getTasksCooperator(taskIds);
        }
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        DynamicObject rowData = evt.getRowData();
        AbstractColumnDesc source = (AbstractColumnDesc)evt.getSource();
        String fieldKey = source.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"duration")) {
            Date date = rowData.getDate("updatestatustime");
            int intervalDays = DateUtils.getIntervalDays((Date)date, (Date)new Date());
            evt.setFormatValue((Object)(intervalDays + "d"));
        }
        if (HRStringUtils.equals((String)fieldKey, (String)"cohandler")) {
            evt.setFormatValue((Object)"");
            if (this.COOPERATOR_MAP != null && !this.COOPERATOR_MAP.isEmpty()) {
                Long taskId = rowData.getLong("id");
                evt.setFormatValue((Object)(this.COOPERATOR_MAP.get(taskId) == null ? "" : this.COOPERATOR_MAP.get(taskId)));
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        if (super.isCloseParentView()) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "urging": {
                this.handleUrging(args);
                break;
            }
            case "sendprocessingtask": {
                this.handleSendHandlerTask(args);
                break;
            }
            case "addhandler": {
                this.handleSetFormulator(args, "addhandler");
                break;
            }
            case "adjusthandler": {
                this.handleSetFormulator(args, "adjusthandler");
                break;
            }
            case "delhandler": {
                this.delHandlerBeforeOp(args);
                break;
            }
            case "returnformulate": {
                this.returnFormulateOp(args);
                break;
            }
            case "adjcooperator": {
                this.cooperatorSetFormulator(args, "adjcooperator");
                break;
            }
            case "delcooperator": {
                this.delCooperatorBeforeOp(args);
                break;
            }
            case "setcooperator": {
                this.cooperatorSetFormulator(args, "setcooperator");
                break;
            }
        }
    }

    private void returnFormulateOp(BeforeDoOperationEventArgs args) {
        List<Object> taskIdList = this.getSelectIdList();
        List validateList = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.validateTaskOfReturnFormulate(taskIdList);
        if (!ObjectUtils.isEmpty((Object)validateList)) {
            args.setCancel(true);
            for (String validate : validateList) {
                this.getView().showTipNotification(validate);
            }
            return;
        }
        AbstractOperate source = (AbstractOperate)args.getSource();
        String reason = source.getOption().getVariableValue("reason", "");
        if (HRStringUtils.isEmpty((String)reason)) {
            args.setCancel(true);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("epa_returntaskdialog");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("dataCount", (Object)this.getSelectedRows().size());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "returnformulate"));
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
        }
    }

    private List<Object> getSelectIdList() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        return selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
    }

    private void delCooperatorBeforeOp(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u8be5\u4efb\u52a1\u7684\u534f\u529e\u4eba\u5417\uff1f", (String)"IndicatorSetterPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delcooperator", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private void delHandlerBeforeOp(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5220\u9664\u5236\u5b9a\u4eba\u662f\u4ee5\u4efb\u52a1\u4e3a\u7ef4\u5ea6\uff0c\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u4efb\u52a1\u540e\uff0c\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5931\u6548\u201d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"IndicatorSetterPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{this.getSelectedRows().size()}));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delhandler", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private void handleSetFormulator(BeforeDoOperationEventArgs args, String operateKey) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            FormShowParameter baseShowParameter = new FormShowParameter();
            baseShowParameter.setFormId("epa_setformulator");
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setStatus(OperationStatus.EDIT);
            String addCaption = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.getLocaleString((String)"\u65b0\u589e\u5236\u5b9a\u4eba", (String)"IndicatorSetterPlugin_0", (String)"opmc-epa-formplugin").getLocaleValue());
            String adjustCaption = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.getLocaleString((String)"\u8c03\u6574\u5236\u5b9a\u4eba", (String)"IndicatorSetterPlugin_1", (String)"opmc-epa-formplugin").getLocaleValue());
            baseShowParameter.setCaption(HRStringUtils.equals((String)operateKey, (String)"addhandler") ? addCaption : adjustCaption);
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            baseShowParameter.setCustomParam("SELECTED_ROW", (Object)primaryKeyValues.length);
            baseShowParameter.setCustomParam("ROW_DATA", (Object)primaryKeyValues);
            baseShowParameter.setCustomParam("operateKey", (Object)operateKey);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            this.getView().showForm(baseShowParameter);
            args.setCancel(true);
        }
    }

    private void cooperatorSetFormulator(BeforeDoOperationEventArgs args, String operateKey) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true")) {
            FormShowParameter baseShowParameter = new FormShowParameter();
            baseShowParameter.setFormId("epa_setcooperator");
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setStatus(OperationStatus.EDIT);
            String addCaption = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.getLocaleString((String)"\u8bbe\u7f6e\u534f\u529e\u4eba", (String)"IndicatorSetterPlugin_6", (String)"opmc-epa-formplugin").getLocaleValue());
            String adjustCaption = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.getLocaleString((String)"\u8c03\u6574\u534f\u529e\u4eba", (String)"IndicatorSetterPlugin_7", (String)"opmc-epa-formplugin").getLocaleValue());
            baseShowParameter.setCaption(HRStringUtils.equals((String)operateKey, (String)"setcooperator") ? addCaption : adjustCaption);
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            baseShowParameter.setCustomParam("SELECTED_ROW", (Object)primaryKeyValues.length);
            baseShowParameter.setCustomParam("ROW_DATA", (Object)primaryKeyValues);
            baseShowParameter.setCustomParam("operateKey", (Object)operateKey);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            this.getView().showForm(baseShowParameter);
            args.setCancel(true);
        }
    }

    private void handleSendHandlerTask(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        int size;
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true") && (size = (selectedRows = this.getSelectedRows()).size()) > 0) {
            String msg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u62e9{0}\u4eba\uff0c\u70b9\u51fb\u201c\u53d1\u9001\u5236\u5b9a\u4efb\u52a1\u201d\u4f1a\u5c06\u5904\u7406\u72b6\u6001\u4e3a\u201c\u7b49\u5f85\u4e2d\u201d\u7684\u4efb\u52a1\u6fc0\u6d3b\u53d1\u9001\u7ed9\u5236\u5b9a\u4eba\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"FormulateTaskList_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{size}));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("sendprocessingtask", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private void handleUrging(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        int size;
        AbstractOperate source = (AbstractOperate)args.getSource();
        String systemInvoke = source.getOption().getVariableValue("systeminvoke", "false");
        if (!HRStringUtils.equals((String)systemInvoke, (String)"true") && (size = (selectedRows = this.getSelectedRows()).size()) > 0) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u4f60\u5df2\u7ecf\u9009\u62e9{0}\u4eba\uff0c\u70b9\u51fb\u201d\u50ac\u529e\u201c\u5c06\u53d1\u9001\u6d88\u606f\u7ed9\u5bf9\u5e94\u6267\u884c\u4e2d\u7684\u5904\u7406\u4eba\u3002\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u50ac\u529e\uff1f", (String)"FormulateTaskList_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]), this.getSelectedRows().size(), size);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("urging", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView")) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes == result) {
                this.getView().getParentView().close();
                this.getView().sendFormAction(this.getView().getParentView());
            }
            return;
        }
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result)) {
            return;
        }
        switch (callBackId) {
            case "urging": {
                if (!this.checkActivityPermission()) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                operateOption.setVariableValue("OP_SOURCE", "formulate");
                this.getView().invokeOperation("urging", operateOption);
                break;
            }
            case "sendprocessingtask": {
                if (!this.checkActivityPermission()) break;
                OperateOption sendOp = OperateOption.create();
                sendOp.setVariableValue("systeminvoke", "true");
                sendOp.setVariableValue("OP_SOURCE", "formulate");
                this.getView().invokeOperation("sendprocessingtask", sendOp);
                break;
            }
            case "delhandler": {
                if (!this.checkActivityPermission()) break;
                OperateOption delOp = OperateOption.create();
                delOp.setVariableValue("systeminvoke", "true");
                delOp.setVariableValue("OP_SOURCE", "formulate");
                this.getView().invokeOperation("delhandler", delOp);
                break;
            }
            case "delcooperator": {
                if (!this.checkActivityPermission()) break;
                OperateOption delCoOp = OperateOption.create();
                delCoOp.setVariableValue("systeminvoke", "true");
                delCoOp.setVariableValue("OP_SOURCE", "formulate");
                this.getView().invokeOperation("delcooperator", delCoOp);
                break;
            }
        }
    }

    private boolean checkActivityPermission() {
        boolean isPass = OpmcPermissionUtils.checkPermission((String)"24E05ECYZ6K0", (String)"epa_activity", (String)"37LTQSOQE94P");
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u8003\u6838\u6d3b\u52a8\u7684\u6267\u884c\u8fc7\u7a0b\u7ba1\u7406\u6743\u9650\u3002", (String)"FormulateTaskList_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        }
        return isPass;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object childMap = event.getReturnData();
        if (HRObjectUtils.isEmpty((Object)childMap)) {
            return;
        }
        switch (actionId) {
            case "returnformulate": {
                String reason = (String)event.getReturnData();
                if (HRStringUtils.isEmpty((String)reason)) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("reason", reason);
                this.getView().invokeOperation("returnformulate", operateOption);
                break;
            }
            case "adjusthandler": 
            case "addhandler": {
                Map handlers = (Map)childMap;
                List userIds = (List)handlers.get("handlers");
                List flowCommonResultBos = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.verifyUserIsValid(userIds);
                for (FlowCommonResultBo flowCommonResultBo : flowCommonResultBos) {
                    if (!"-1".equals(flowCommonResultBo.getCode())) continue;
                    this.getView().showErrorNotification(flowCommonResultBo.getMessage());
                    return;
                }
            }
            case "setcooperator": 
            case "adjcooperator": {
                OperateOption option = OperateOption.create();
                String returnStr = SerializationUtils.serializeToBase64((Object)childMap);
                option.setVariableValue("return_str", returnStr);
                option.setVariableValue("select_size", String.valueOf(this.getSelectedRows().size()));
                option.setVariableValue("systeminvoke", "true");
                option.setVariableValue("OP_SOURCE", "epa_formulatedetailview");
                this.getView().invokeOperation(actionId, option);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (!HRObjectUtils.isEmpty((Object)operationResult) && operationResult.isSuccess() && ("adjusthandler".equals(key) || "sendprocessingtask".equals(key) || "addhandler".equals(key) || "delhandler".equals(key) || "returnformulate".equals(key) || "setcooperator".equals(key) || "adjcooperator".equals(key) || "delcooperator".equals(key))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("systeminvoke", "true");
            this.getView().invokeOperation("refresh", operateOption);
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (ROLE_NAME.equals(fieldName)) {
            Object nodeId = this.getView().getFormShowParameter().getCustomParam("flownode");
            List qFilters = args.getQfilters();
            qFilters.add(new QFilter("defnode", "=", nodeId));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("epa_actevalobj.person.headsculpture", "epa_actevalobj.perffile.name", "epa_actevalobj.perffile.billno");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }
}

