/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.activitymanage.targetformulate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.formplugin.web.activitymanage.targetformulate.FormulateBaseList;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowRuRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuRoleStatusEnum;

public class FormulatePersonList
extends FormulateBaseList {
    private static final FlowRuRoleEntityService FLOW_RU_ROLE_ENTITY_SERVICE = FlowRuRoleEntityService.getInstance();
    private Map<Long, String> roleIdStatusMap = new HashMap<Long, String>(16);

    public void setFilter(SetFilterEvent event) {
        Long nodeId = (Long)this.getView().getFormShowParameter().getCustomParam("flownode");
        QFilter nodeFilter = new QFilter("epa_actevalobj.formulateflowins.currentnode.flownodedef", "=", (Object)nodeId);
        Integer nodeIndex = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeseq");
        QFilter nodeIndexFilter = new QFilter("flowrunode.index", "=", (Object)nodeIndex);
        Long activityId = (Long)this.getView().getFormShowParameter().getCustomParam("activity");
        QFilter activityFilter = new QFilter("activity", "=", (Object)activityId);
        Long evalFlowId = (Long)this.getView().getFormShowParameter().getCustomParam("formulateflow");
        QFilter evalFlowFilter = new QFilter("epa_actevalobj.formulateflow", "=", (Object)evalFlowId);
        event.getQFilters().add(nodeFilter);
        event.getQFilters().add(activityFilter);
        event.getQFilters().add(evalFlowFilter);
        event.getQFilters().add(nodeIndexFilter);
        event.setOrderBy("taskstatus desc");
    }

    public void beforePackageData(BeforePackageDataEvent dataEvent) {
        DynamicObjectCollection pageData = dataEvent.getPageData();
        List roleIds = pageData.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", roleIds);
        Object[] roleList = FLOW_RU_ROLE_ENTITY_SERVICE.query("rolestatus", new QFilter[]{qFilter});
        if (ObjectUtils.isEmpty((Object[])roleList)) {
            return;
        }
        for (Object role : roleList) {
            this.roleIdStatusMap.put(role.getLong("id"), role.getString("rolestatus"));
        }
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        DynamicObject rowData = evt.getRowData();
        AbstractColumnDesc source = (AbstractColumnDesc)evt.getSource();
        String fieldKey = source.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"flowdefrole.rolename")) {
            String roleStatus = this.roleIdStatusMap.get(rowData.getLong("id"));
            FlowRuRoleStatusEnum rolestatus = FlowRuRoleStatusEnum.getFlowRuRoleStatusByCode((String)roleStatus);
            String value = evt.getFormatValue() + "\uff08" + rolestatus.getText() + "\uff09";
            evt.setFormatValue((Object)new LocaleString(value));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"closeView") && MessageBoxResult.Yes == (result = event.getResult())) {
            this.getView().getParentView().close();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List<String> fixedColumnList = Arrays.asList("epa_actevalobj.person.headsculpture", "epa_actevalobj.perffile.name", "epa_actevalobj.perffile.billno");
        fixedColumnList.forEach(column -> {
            if (args.getListColumn(column) != null) {
                args.getListColumn(column).setFixed(true);
            }
        });
    }
}

